/*
 * Copyright 2013 Red Hat Inc. and/or its affiliates and other contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.switchyard.component.bean.tests;

import java.util.HashMap;
import java.util.Map;

import org.switchyard.component.bean.Property;
import org.switchyard.component.bean.Service;

@Service(PropertyService.class)
public class PropertyServiceBean implements PropertyService {
    
    @Property(name="foo")
    String _foo;
    
    @Property(name="composite.foo")
    String _compositeFoo;
    
    @Property(name="component.foo")
    String _componentFoo;
    
    @Override
    public Map<String,String> getProperties() {
        Map<String,String> response = new HashMap<String,String>();
        response.put("foo", _foo);
        response.put("composite.foo", _compositeFoo);
        response.put("component.foo", _componentFoo);
        return response;
    }
}
