@echo off

set INSTALL_DB=FALSE
set "SCRIPT_HOME=%~dp0"
set ANT_ARGS=

:loop
if not "%1"=="" (
   if "%1"=="--setup-db" (
      set INSTALL_DB=TRUE
   ) else (
      set ANT_ARGS=%ANT_ARGS% %1
   )
   shift
   goto :loop
)

call:normalize EAP_HOME "%SCRIPT_HOME%\..\..\.."
call:normalize ANT_HOME "%EAP_HOME%\lib"
call:normalize DATA_DIR "%EAP_HOME%\standalone\data"
set DATA_DIR=%DATA_DIR:\=/%

java -Dant.home=%ANT_HOME% -Dpath=%EAP_HOME% -Dappserver.id=jboss-eap-64 -cp %ANT_HOME%\ant-launcher-1.8.3.jar org.apache.tools.ant.launch.Launcher -q -f %SCRIPT_HOME%\platforms\jboss-eap-64\all\build.xml %ANT_ARGS% install

if "%INSTALL_DB%"=="TRUE" (
   call:normalize H2_HOME "%EAP_HOME%\modules\system\layers\base\com\h2database\h2\main"

   set WORK_DIR=%CD%
   cd %H2_HOME%
   for /F %%a in ('dir /b *.jar') do set H2_JAR=%%a
   cd %WORK_DIR%

   echo "Setting up H2 database jdbc:h2:%DATA_DIR%/h2/rtgov"
   java -cp %H2_HOME%\%H2_JAR% org.h2.tools.RunScript -url jdbc:h2:%DATA_DIR%/h2/rtgov -script %EAP_HOME%\sql\rtgov\overlord-rtgov.H2Dialect.sql
)
goto:eof

:normalize
   set "%~1=%~f2"
   goto:eof