/**
 * Copyright (C) FuseSource, Inc.
 * http://fusesource.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.fusesource.fabric.api;

import java.util.Map;

public interface MQService {

    static final String MQ_PROFILE_BASE = "mq-base";

    static final String MQ_PID_TEMPLATE = "org.fusesource.mq.fabric.template";
    
    Profile createMQProfile(String version, String brokerName, Map<String, String> configs);
    
    String getConfig(String version, String config);
    
}
