/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.processor.aggregate.AggregationCollection;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAggregationCollection
extends AbstractCollection<Exchange>
implements AggregationCollection {
    private static final transient Log LOG = LogFactory.getLog(DefaultAggregationCollection.class);
    private Expression correlationExpression;
    private AggregationStrategy aggregationStrategy;
    private final Map<Object, Exchange> aggregated = new LinkedHashMap<Object, Exchange>();
    private final AtomicInteger counter = new AtomicInteger();

    public DefaultAggregationCollection() {
    }

    public DefaultAggregationCollection(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        this.correlationExpression = correlationExpression;
        this.aggregationStrategy = aggregationStrategy;
    }

    protected Map<Object, Exchange> getAggregated() {
        return this.aggregated;
    }

    @Override
    public boolean add(Exchange exchange) {
        Boolean filtered = exchange.getProperty("CamelFiltered", Boolean.class);
        if (filtered != null && filtered.booleanValue()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Cannot aggregate exchange as its filtered: " + exchange));
            }
            return false;
        }
        Object correlationKey = this.correlationExpression.evaluate(exchange, Object.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Evaluated expression: " + this.correlationExpression + " as correlation key: " + correlationKey));
        }
        Exchange oldExchange = this.aggregated.get(correlationKey);
        Exchange newExchange = exchange;
        Integer size = 1;
        if (oldExchange != null) {
            size = oldExchange.getProperty("CamelAggregatedSize", Integer.class);
            ObjectHelper.notNull(size, "CamelAggregatedSize on " + oldExchange);
            Integer n = size;
            Integer n2 = size = Integer.valueOf(size + 1);
        }
        ExchangeHelper.prepareAggregation(oldExchange, newExchange);
        newExchange = this.aggregationStrategy.aggregate(oldExchange, newExchange);
        newExchange.setProperty("CamelAggregatedSize", size);
        newExchange.setProperty("CamelAggregatedIndex", this.counter.getAndIncrement());
        if (!newExchange.equals(oldExchange)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Put exchange:" + newExchange + " with correlation key:" + correlationKey));
            }
            this.aggregated.put(correlationKey, newExchange);
        }
        this.onAggregation(correlationKey, newExchange);
        return true;
    }

    @Override
    public Iterator<Exchange> iterator() {
        return this.aggregated.values().iterator();
    }

    @Override
    public int size() {
        return this.aggregated.size();
    }

    @Override
    public void clear() {
        this.aggregated.clear();
        this.counter.set(0);
    }

    @Override
    public void onAggregation(Object correlationKey, Exchange exchange) {
    }

    @Override
    public Expression getCorrelationExpression() {
        return this.correlationExpression;
    }

    @Override
    public void setCorrelationExpression(Expression correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    @Override
    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    @Override
    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }
}

