/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.util;

import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class Utils {
    private static String m_systemDefaultCharEncoding = Charset.defaultCharset().name();

    private Utils() {
    }

    public static int contentCompare(CharSequence s1, CharSequence s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        for (int i = 0; i < len1 && i < len2; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 < (c2 = s2.charAt(i))) {
                return -1;
            }
            if (c1 <= c2) continue;
            return 1;
        }
        if (len1 < len2) {
            return -1;
        }
        if (len1 > len2) {
            return 1;
        }
        return 0;
    }

    public static boolean contentEquals(CharSequence s1, CharSequence s2) {
        CharBuffer b2;
        CharBuffer b1;
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        int len = s1.length();
        if (len != s2.length()) {
            return false;
        }
        if (s1 instanceof CharBuffer && (b1 = (CharBuffer)s1).hasArray()) {
            CharBuffer b22;
            char[] c1 = b1.array();
            int o1 = b1.arrayOffset() + b1.position();
            if (s2 instanceof CharBuffer && (b22 = (CharBuffer)s2).hasArray()) {
                char[] c2 = b22.array();
                int o2 = b22.arrayOffset() + b22.position();
                len += o1;
                while (o1 < len) {
                    if (c1[o1] != c2[o2]) {
                        return false;
                    }
                    ++o1;
                    ++o2;
                }
                return true;
            }
            for (int o2 = 0; o2 < len; ++o2) {
                if (c1[o1] != s2.charAt(o2)) {
                    return false;
                }
                ++o1;
            }
            return true;
        }
        if (s2 instanceof CharBuffer && (b2 = (CharBuffer)s2).hasArray()) {
            char[] c2 = b2.array();
            int o2 = b2.arrayOffset() + b2.position();
            int o1 = 0;
            while (o1 < len) {
                if (s1.charAt(o1) != c2[o2]) {
                    return false;
                }
                ++o1;
                ++o2;
            }
            return true;
        }
        if (s1 instanceof String) {
            return ((String)s1).contentEquals(s2);
        }
        if (s2 instanceof String) {
            return ((String)s2).contentEquals(s1);
        }
        for (int i = 0; i < len; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEqualsIgnoreCase(CharSequence s1, CharSequence s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        int len = s1.length();
        if (len != s2.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i)) || Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static String getSystemDefaultCharEncoding() {
        return m_systemDefaultCharEncoding;
    }

    public static String removeAllDotsFromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(46) < 0) {
            return string;
        }
        int length = string.length();
        StringBuilder str = new StringBuilder(length - 1);
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c == '.') continue;
            str.append(c);
        }
        return str.toString();
    }

    public static int versionsCompare(String version1, String version2) throws NumberFormatException {
        if (version1 == null) {
            if (version2 == null) {
                return 0;
            }
            if (version2.length() == 0) {
                return -1;
            }
            if (version2.equals("0")) {
                return -1;
            }
            version1 = "0";
        }
        if (version2 == null) {
            if (version1.length() == 0) {
                return 1;
            }
            if (version1.equals("0")) {
                return 1;
            }
            version2 = "0";
        }
        if (version1.length() == 0) {
            if (version2.length() == 0) {
                return 0;
            }
            if (version2.equals("0")) {
                return -1;
            }
            version1 = "0";
        }
        if (version2.length() == 0) {
            if (version1.equals("0")) {
                return 1;
            }
            version2 = "0";
        }
        int e1 = -1;
        int e2 = -1;
        int v1 = 0;
        int v2 = 0;
        do {
            int s1 = e1 + 1;
            int s2 = e2 + 1;
            e1 = version1.indexOf(46, s1);
            e2 = version2.indexOf(46, s2);
            if (e1 == -1) {
                e1 = version1.length();
            }
            if (e2 == -1) {
                e2 = version2.length();
            }
            if ((v1 = Integer.parseInt(version1.substring(s1, e1))) > (v2 = Integer.parseInt(version2.substring(s2, e2)))) {
                return 1;
            }
            if (v1 >= v2) continue;
            return -1;
        } while (e1 < version1.length() && e2 < version2.length());
        if (e1 == version1.length() && e2 == version2.length()) {
            return 0;
        }
        if (e1 == version1.length()) {
            return -1;
        }
        return 1;
    }
}

