/*
 * Copyright 2016 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */
package org.jbosson.plugins.fuse;

import java.util.Set;

import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/**
 * Adds support for converting <code>MemoryPercentUsage</code> metric value from absolute integer to percentage.
 *
 * @author dbokde
 */
public class ActiveMQResourceComponent<T extends JMXComponent<?>> extends MBeanResourceComponent<T> {

    private static final String SUFFIX_PERCENT_USAGE = "PercentUsage";

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        super.getValues(report, requests);
        // normalize percentage metric values to 0..1.0
        for (MeasurementDataNumeric dataNumeric : report.getNumericData()) {
            String name = dataNumeric.getName();
            if (name != null
                && name.endsWith(SUFFIX_PERCENT_USAGE)
                && dataNumeric.getValue() != null) {
                dataNumeric.setValue(dataNumeric.getValue() / 100.0);
            }
        }
    }

}
