/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertBase;
import com.sap.i18n.cp.ConvertCToX;
import com.sap.i18n.cp.ConvertCToXFactory;
import com.sap.i18n.cp.ConvertSimpleBase;
import com.sap.i18n.cp.ConvertTImplBase;
import com.sap.i18n.cp.ConvertXToC;
import com.sap.i18n.cp.ConverterException;
import com.sap.i18n.cp.ConverterJNITestDataCpCToX;
import com.sap.i18n.cp.ConverterJNITestDataSingleCToX;
import com.sap.i18n.cp.ConverterJNITestDataSingleCToXOk;
import com.sap.i18n.cp.ConverterJNITestDataSingleCToXShortcut;
import com.sap.i18n.cp.StrUtil;
import com.sap.i18n.verify.intf.VerifyIntf;

public class ConvertCToXTImpl
extends ConvertTImplBase {
    public static ConverterJNITestDataCpCToX[] m_aTestDataCToXAll = new ConverterJNITestDataCpCToX[]{new ConverterJNITestDataCpCToX("1100", 0, new ConverterJNITestDataSingleCToX[]{new ConverterJNITestDataSingleCToXOk(new char[]{'A', 'B', 'C'}, new byte[]{65, 66, 67}), new ConverterJNITestDataSingleCToXOk(new char[]{'A', '\u00c4', 'C'}, new byte[]{65, -60, 67}), new ConverterJNITestDataSingleCToXOk(new char[]{'\u0000', '\u00ff'}, new byte[]{0, -1}), new ConverterJNITestDataSingleCToXOk(new char[]{'A', '\uff1d'}, new byte[]{65, 35}), new ConverterJNITestDataSingleCToX(new char[]{'A', 'B', 'C', 'D', 'E'}, new byte[]{65, 66, 67}, 32), new ConverterJNITestDataSingleCToXOk(new char[0], new byte[0])}), new ConverterJNITestDataCpCToX("8000", 0, new ConverterJNITestDataSingleCToX[]{new ConverterJNITestDataSingleCToXOk(new char[]{'A', 'B', 'C'}, new byte[]{65, 66, 67}), new ConverterJNITestDataSingleCToX(new char[]{'A', '\u00c4', 'C'}, new byte[]{65, 35, 67}, 0), new ConverterJNITestDataSingleCToXOk(new char[]{'A', '\uff1d'}, new byte[]{65, -127, -127}), new ConverterJNITestDataSingleCToX(new char[]{'A', '\uffff'}, new byte[]{65, 35}, 0), new ConverterJNITestDataSingleCToXOk(new char[]{'\udbf8', '\udc3c'}, new byte[]{-121, -112}), new ConverterJNITestDataSingleCToX(new char[]{'A', '\ud800', '\udc00'}, new byte[]{65, 35}, 0), new ConverterJNITestDataSingleCToX(new char[]{'A', '\udc00', '\ud800'}, new byte[]{65, 35, 35}, 0), new ConverterJNITestDataSingleCToX(new char[]{'A', '\uff1d'}, new byte[]{65}, 32), new ConverterJNITestDataSingleCToX(new char[]{'A', '\uff1d'}, new byte[]{65, 0}, 32), new ConverterJNITestDataSingleCToXOk(new char[0], new byte[0])}), new ConverterJNITestDataCpCToX("4102", 0, new ConverterJNITestDataSingleCToX[]{new ConverterJNITestDataSingleCToXOk(new char[]{'A', 'B', 'C'}, new byte[]{0, 65, 0, 66, 0, 67}), new ConverterJNITestDataSingleCToXOk(new char[]{'A', '\u3000', 'C'}, new byte[]{0, 65, 48, 0, 0, 67}), new ConverterJNITestDataSingleCToX(new char[]{'A', 'B', 'C'}, new byte[]{0, 65}, 32), new ConverterJNITestDataSingleCToXShortcut(new char[]{'A', '\uff1d'}, new byte[]{0, 65, 0}, 32, 32), new ConverterJNITestDataSingleCToXOk(new char[0], new byte[0])}), new ConverterJNITestDataCpCToX("4103", 0, new ConverterJNITestDataSingleCToX[]{new ConverterJNITestDataSingleCToXOk(new char[]{'A', 'B', 'C'}, new byte[]{65, 0, 66, 0, 67, 0}), new ConverterJNITestDataSingleCToXOk(new char[]{'A', '\u3000', 'C'}, new byte[]{65, 0, 0, 48, 67, 0}), new ConverterJNITestDataSingleCToX(new char[]{'A', 'B', 'C'}, new byte[]{65, 0}, 32), new ConverterJNITestDataSingleCToXShortcut(new char[]{'A', '\uff1d'}, new byte[]{65, 0, 0}, 32, 32), new ConverterJNITestDataSingleCToXOk(new char[0], new byte[0])}), new ConverterJNITestDataCpCToX("4110", 0, new ConverterJNITestDataSingleCToX[]{new ConverterJNITestDataSingleCToXOk(new char[]{'A', 'B', 'C'}, new byte[]{65, 66, 67}), new ConverterJNITestDataSingleCToXOk(new char[]{'A', '\u00c4', 'C'}, new byte[]{65, -61, -124, 67}), new ConverterJNITestDataSingleCToXOk(new char[]{'A', '\u3000', 'C'}, new byte[]{65, -29, -128, -128, 67}), new ConverterJNITestDataSingleCToXOk(new char[]{'A', '\u9000', 'C'}, new byte[]{65, -23, -128, -128, 67}), new ConverterJNITestDataSingleCToXOk(new char[]{'\udbf8', '\udc3c'}, new byte[]{-12, -114, -128, -68}), new ConverterJNITestDataSingleCToX(new char[]{'\udbf8'}, new byte[]{35}, 0), new ConverterJNITestDataSingleCToX(new char[]{'\udc3c'}, new byte[]{35}, 0), new ConverterJNITestDataSingleCToX(new char[]{'\udc3c', '\udbf8'}, new byte[]{35, 35}, 0), new ConverterJNITestDataSingleCToX(new char[]{'A', 'B', 'C'}, new byte[]{65}, 32), new ConverterJNITestDataSingleCToX(new char[]{'A', '\u00c4'}, new byte[]{65}, 32), new ConverterJNITestDataSingleCToX(new char[]{'A', '\u00c4'}, new byte[]{65, 0}, 32), new ConverterJNITestDataSingleCToX(new char[]{'A', '\u3000'}, new byte[]{65}, 32), new ConverterJNITestDataSingleCToX(new char[]{'A', '\u3000'}, new byte[]{65, 0}, 32), new ConverterJNITestDataSingleCToX(new char[]{'A', '\u3000'}, new byte[]{65, 0, 0}, 32), new ConverterJNITestDataSingleCToX(new char[]{'A', '\udbf8', '\udc3c'}, new byte[]{65, 0}, 32), new ConverterJNITestDataSingleCToX(new char[]{'A', '\udbf8', '\udc3c'}, new byte[]{65, 0, 0}, 32), new ConverterJNITestDataSingleCToX(new char[]{'A', '\udbf8', '\udc3c'}, new byte[]{65, 0, 0, 0}, 32), new ConverterJNITestDataSingleCToXOk(new char[0], new byte[0])}), new ConverterJNITestDataCpCToX("", 16, new ConverterJNITestDataSingleCToX[]{new ConverterJNITestDataSingleCToX(new char[]{'A', 'B', 'C'}, new byte[0], 16)})};

    public ConvertCToXTImpl(VerifyIntf oVerify) {
        super(oVerify);
    }

    public void testMain() {
        this.printLogln("TEST ConvertCToXTImpl BEGIN");
        this.testConvertCToX();
        this.printLogln("testConvertCToX done");
        this.stressConvertCToX("1101");
        this.stressConvertCToX("1800");
        this.stressConvertCToX("8000");
        ConvertBase.throwExceptions4Test();
        this.printLogln("stressConvertCToX done");
        this.printLogln("TEST ConvertCToXTImpl END");
    }

    public void testConvertCToX() {
        this.testConvertCToXInner(false);
        this.testConvertCToXInner(true);
        this.testConvertCToXRound("1100".toCharArray());
        this.testConvertCToXRound("1401".toCharArray());
        this.testConvertCToXRound("8000".toCharArray());
    }

    public void testConvertCToXInner(boolean bUseShortcut) {
        for (int i = 0; i < m_aTestDataCToXAll.length; ++i) {
            ConverterJNITestDataCpCToX oDataCp = m_aTestDataCToXAll[i];
            ConvertCToX oCnvObj = bUseShortcut ? ConvertCToXFactory.createConvertCToX(oDataCp.m_acCpOut, true) : new ConvertCToX(oDataCp.m_acCpOut, true);
            this.verifyConvertInit("ConvertCToX", oCnvObj, oDataCp.m_nReturn);
            if (oDataCp.m_nReturn != 0) {
                return;
            }
            boolean bReallyUseShortcut = oCnvObj.isShortcut();
            ConvertCToX oCnvObjBreakOnErr = bUseShortcut ? ConvertCToXFactory.createConvertCToX(oDataCp.m_acCpOut, false) : new ConvertCToX(oDataCp.m_acCpOut, false);
            char[] acDummy4Test = new char[]{'a', 'b', 'c'};
            char[] dummy4Test = this.moveCharArrBeginBack(acDummy4Test, 1);
            this.verify(dummy4Test[0] == 'b', "first char should be 'b'", "moveCharArrBeginBack");
            for (int j = 0; j < oDataCp.m_aData.length; ++j) {
                ConverterJNITestDataSingleCToX oData = oDataCp.m_aData[j];
                if (!bReallyUseShortcut && !oData.m_bNative) continue;
                this.testConvertCToXSingle(oCnvObj, oData, bUseShortcut);
                if (oData.m_nReturn == 0 && oDataCp.m_acCpOut[0] != '4') {
                    char[] acInAdd = this.appendCharArr(oData.m_acDataIn, '0');
                    byte[] abOutAdd = this.appendByteArr(oData.m_abDataOut, (byte)48);
                    ConverterJNITestDataSingleCToX oDataAdd = new ConverterJNITestDataSingleCToX(acInAdd, abOutAdd, 0);
                    this.testConvertCToXSingle(oCnvObj, oDataAdd, bUseShortcut);
                    acInAdd = this.appendCharArr(acInAdd, '0');
                    abOutAdd = this.appendByteArr(abOutAdd, (byte)48);
                    oDataAdd = new ConverterJNITestDataSingleCToX(acInAdd, abOutAdd, 0);
                    this.testConvertCToXSingle(oCnvObj, oDataAdd, bUseShortcut);
                }
                this.testConvertCToXSingleBreakOnErr(oCnvObjBreakOnErr, oData, bUseShortcut);
            }
        }
    }

    public void testConvertCToXSingle(ConvertCToX oCnvObj, ConverterJNITestDataSingleCToX oData, boolean bUseShortcut) {
        byte[] abOut;
        boolean bConvertArrOk;
        boolean bTooLong = oData.m_nReturn == 32;
        boolean bReallyUseShortcut = bUseShortcut && ConvertBase.m_bCnvShortcutsAvailable;
        boolean bl = bConvertArrOk = bReallyUseShortcut || ConvertBase.m_bCnvArrAvailable;
        if (!bTooLong) {
            abOut = oCnvObj.Convert(new String(oData.m_acDataIn));
            this.verifyConvertCToX("ConverterJNI.ConvertCToX", oCnvObj, oData, abOut);
        }
        if (bConvertArrOk) {
            abOut = new byte[oData.m_abDataOut.length];
            oCnvObj.ConvertArr(oData.m_acDataIn, 0, oData.m_acDataIn.length, abOut, 0, abOut.length);
            this.verifyConvertCToX("ConverterJNI.ConvertCToXArr", oCnvObj, oData, abOut);
        }
        if (bConvertArrOk) {
            abOut = new byte[oData.m_abDataOut.length];
            try {
                oCnvObj.ConvertArrExc(oData.m_acDataIn, 0, oData.m_acDataIn.length, abOut, 0, abOut.length);
            }
            catch (ConverterException e) {
                this.verify(false, "Unexpected Exception: " + e.getMessage(), "ConverterJNI.ConvertCToXArr");
            }
            this.verifyConvertCToX("ConverterJNI.ConvertCToXArr", oCnvObj, oData, abOut);
        }
        if (bConvertArrOk) {
            char[] acIn = this.moveCharArrBegin(oData.m_acDataIn, 1);
            byte[] abOut2 = new byte[oData.m_abDataOut.length + 2];
            oCnvObj.ConvertArr(acIn, 1, acIn.length, abOut2, 2, abOut2.length);
            abOut2 = this.moveByteArrBeginBack(abOut2, 2);
            this.verifyConvertCToX("ConverterJNI.ConvertCToXArrMoved", oCnvObj, oData, abOut2);
        }
        if (!bTooLong) {
            int nOutLen = oCnvObj.outLength(oData.m_acDataIn, 0, oData.m_acDataIn.length);
            this.verifyConvertCToXLen("ConverterJNI.outLength", oCnvObj, oData, nOutLen);
        }
    }

    public void testConvertCToXSingleBreakOnErr(ConvertCToX oCnvObj, ConverterJNITestDataSingleCToX oData, boolean bUseShortcut) {
        byte[] abOut;
        boolean bConvertArrOk;
        boolean bTooLong = oData.m_nReturn == 32;
        boolean bReallyUseShortcut = bUseShortcut && ConvertBase.m_bCnvShortcutsAvailable;
        boolean bl = bConvertArrOk = bReallyUseShortcut || ConvertBase.m_bCnvArrAvailable;
        if (!bTooLong) {
            abOut = oCnvObj.Convert(new String(oData.m_acDataIn));
            this.verifyConvertCToXBreakOnErr("ConverterJNI.ConvertCToX", oCnvObj, oData, abOut);
        }
        if (bConvertArrOk) {
            abOut = new byte[oData.m_abDataOut.length];
            oCnvObj.ConvertArr(oData.m_acDataIn, 0, oData.m_acDataIn.length, abOut, 0, abOut.length);
            abOut = (byte[])(oCnvObj.GetLastRet() == 0 ? abOut : null);
            this.verifyConvertCToXBreakOnErr("ConverterJNI.ConvertXToCArr", oCnvObj, oData, abOut);
        }
        if (bReallyUseShortcut) {
            abOut = new byte[oData.m_abDataOut.length];
            int nErrPos = -1;
            for (int i = 0; i < oData.m_abDataOut.length; ++i) {
                if (oData.m_abDataOut[i] != 35) continue;
                nErrPos = i;
                break;
            }
            try {
                oCnvObj.ConvertArrExc(oData.m_acDataIn, 0, oData.m_acDataIn.length, abOut, 0, abOut.length);
                this.verify(oData.m_nReturn == 0 && nErrPos == -1, "Expected exception did not occur. " + this.describeTestCToX(oCnvObj, oData, abOut), "ConverterJNI.ConvertCToXArrExc");
            }
            catch (ConverterException e) {
                this.verify(oData.m_nReturn != 0 || nErrPos != -1, "Unexpected Exception: " + e.getMessage() + " at test " + this.describeTestCToX(oCnvObj, oData, null), "ConverterJNI.ConvertCToXArrExc");
            }
        }
    }

    public void testConvertCToXRound(char[] sCp) {
        this.printLogln("testConvertCToXRound Cp: " + new String(sCp));
        byte[] abIn = new byte[2];
        char[] acCnv = new char[2];
        byte[] abEnd = new byte[2];
        ConvertXToC oCnvObj = new ConvertXToC(sCp, true);
        ConvertCToX oCnvObjBack = ConvertCToXFactory.createConvertCToX(sCp, true);
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                abIn[0] = (byte)i;
                abIn[1] = (byte)j;
                int nDone = oCnvObj.ConvertArr(abIn, 0, 2, acCnv, 0, 2);
                oCnvObjBack.ConvertArr(acCnv, 0, nDone, abEnd, 0, 2);
                ConverterJNITestDataSingleCToX oTestData = new ConverterJNITestDataSingleCToX(acCnv, abIn, 0);
                this.verifyConvertCToX("testConvertCToXRound", oCnvObjBack, oTestData, abEnd);
            }
        }
    }

    protected void verifyConvertCToXBreakOnErr(String sName, ConvertSimpleBase oCnvObj, ConverterJNITestDataSingleCToX oTestData, byte[] abOut) {
        if (abOut != null) {
            this.verifyConvertCToX("ConverterJNI.ConvertCToX", oCnvObj, oTestData, abOut);
            return;
        }
        int nReturn = oCnvObj.GetLastRet();
        int nErrPos = -1;
        for (int i = 0; i < oTestData.m_abDataOut.length; ++i) {
            if (oTestData.m_abDataOut[i] != 35) continue;
            nErrPos = i;
            break;
        }
        int nReturnExpected = nErrPos != -1 ? 2048 : oTestData.m_nReturn;
        this.verify(nReturn == nReturnExpected, this.describeTestCToX(oCnvObj, oTestData, abOut), sName);
        String sOutBytes = "";
        String sOutBytesExpected = nReturnExpected == 0 ? StrUtil.buildByteString(new String(oTestData.m_abDataOut)) : "";
        this.verify(sOutBytes.equals(sOutBytesExpected), this.describeTestCToX(oCnvObj, oTestData, abOut), sName);
        if (nReturnExpected != 0) {
            this.printLogln("Expected error occured:\n" + oCnvObj.GetLastError().GetText());
        }
    }

    void verifyConvertCToXLen(String sName, ConvertSimpleBase oCnvObj, ConverterJNITestDataSingleCToX oTestData, int nOutLen) {
        String sInBytes = StrUtil.buildByteString(new String(oTestData.m_acDataIn));
        int nExpectedLen = oTestData.m_abDataOut.length;
        this.verify(nOutLen == nExpectedLen, oCnvObj.getCnvDisplayText() + ": " + sInBytes + " CnvLen: " + nOutLen + "(" + nExpectedLen + ")", sName);
    }

    private void stressConvertCToXInner(String sCheckName, ConvertCToX oCnvObj, char[] acIn, int nCnt) {
        int nLen = acIn.length;
        String sIn = new String(acIn);
        for (int i = 0; i < nLen; ++i) {
            acIn[i] = (char)(64 + i % 10);
        }
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while ((long)i < (long)nCnt * 1L) {
            oCnvObj.Convert(sIn);
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Stress test \"" + sCheckName + "\"", startLoop, endLoop, (long)nCnt * 1L, nLen);
    }

    private void stressConvertCToXArrInner(String sCheckName, ConvertCToX oCnvObj, char[] acIn, int nCnt) {
        int nLen = acIn.length;
        byte[] abOut = new byte[nLen];
        for (int i = 0; i < nLen; ++i) {
            acIn[i] = (char)(64 + i % 10);
        }
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while ((long)i < (long)nCnt * 1L) {
            oCnvObj.ConvertArr(acIn, 0, nLen, abOut, 0, nLen);
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.verify((acIn[nLen - 1] & 0xFFFF) > 128 || abOut[nLen - 1] == acIn[nLen - 1], "Stress test failed with size: " + nLen, sCheckName);
        this.timecheckPrintResult("Stress test \"" + sCheckName + "\"", startLoop, endLoop, (long)nCnt * 1L, nLen);
    }

    private void stressConvertCToXCreate(String sOutCp, int nCnt) {
        long startLoop = System.currentTimeMillis();
        ConvertCToX[] aCnvObj = new ConvertCToX[nCnt];
        int i = 0;
        while ((long)i < (long)nCnt * 1L) {
            aCnvObj[i % nCnt] = ConvertCToXFactory.createConvertCToX(sOutCp.toCharArray(), true);
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Stress test \"CToXCreate\"", startLoop, endLoop, (long)nCnt * 1L, 1L);
    }

    public void stressConvertCToX(String sCp) {
        ConvertCToX oCnvObj = ConvertCToXFactory.createConvertCToX(sCp.toCharArray(), true);
        this.printLogln("Stress test begin: " + oCnvObj.getCnvDisplayText());
        char[] acInFrequent = new char[1];
        this.stressConvertCToXInner("Frequent string", oCnvObj, acInFrequent, 1000000);
        this.stressConvertCToXArrInner("Frequent array", oCnvObj, acInFrequent, 1000000);
        char[] acInStandard = new char[10];
        this.stressConvertCToXInner("Standard string", oCnvObj, acInStandard, 100000);
        this.stressConvertCToXArrInner("Standard array", oCnvObj, acInStandard, 100000);
        char[] acInMedium = new char[1000];
        this.stressConvertCToXInner("Medium string", oCnvObj, acInMedium, 1000);
        this.stressConvertCToXArrInner("Medium array", oCnvObj, acInMedium, 1000);
        char[] acInMedium2 = new char[10250];
        this.stressConvertCToXInner("Medium2 string", oCnvObj, acInMedium2, 100);
        this.stressConvertCToXArrInner("Medium2 array", oCnvObj, acInMedium2, 100);
        char[] acInLarge = new char[1000000];
        this.stressConvertCToXInner("Large string", oCnvObj, acInLarge, 1);
        this.stressConvertCToXArrInner("Large array", oCnvObj, acInLarge, 1);
        this.stressConvertCToXCreate(sCp, 100000);
    }
}

