package org.jboss.qe.camel.components.ejb.subB;

import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TextMessage;

public abstract class AbstractTransactionEjb {

	@Resource(mappedName = "java:/JmsXA")
	private QueueConnectionFactory connectionFactory;

	@Resource(mappedName = "java:/jms/queue/ejbTestEjbQueue")
	private Destination queue;

	public abstract void accept(String message) throws Exception;

	protected void sendMessage(String m) throws Exception {
		final String text = "[" + getClass().getName() + "]:" + m;
		final Connection connection = connectionFactory.createConnection();
		connection.start();

		try {
			final Session session = connection.createSession(false, -1); // CMTD
			final MessageProducer producer = session.createProducer(queue);
			final TextMessage message = session.createTextMessage();
			message.setText(text);
			producer.send(message);
			System.out.println("send " + text + " to queue" + queue.toString());
		} finally {
			connection.close();
		}
	}
}
