/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.TableParameter;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.data.ARFCSDATA;
import com.sap.conn.rfc.data.ARFCSSTATE;
import com.sap.conn.rfc.data.ARfcSDataHeader;
import com.sap.conn.rfc.driver.RfcTypePlayback;
import com.sap.conn.rfc.engine.RfcIoControl;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcPut;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.conn.rfc.exceptions.RfcIoException;

public abstract class TRfc {
    public static final int RFC_PB_WITH_STATE = 1;
    public static final int RFC_PB_CHECK = 2;

    public static void rfcQueueInsert(RfcIoOpenCntl act_cntl, String function, IRfcParameter[] exporting, IRfcTable[] tables, String qname, String tid, boolean supportsASXML, AbapClassException.Mode classExceptionMode) throws RfcException {
        ARfcSDataHeader arfc_header = new ARfcSDataHeader();
        ARFCSSTATE arfcstate = new ARFCSSTATE(act_cntl, "STATE");
        DefaultTable state = arfcstate.getTable();
        ARFCSDATA arfcsdata = new ARFCSDATA(act_cntl, "DATA");
        IRfcTable[] table = new TableParameter[2];
        int blcnt = 1;
        state.appendRow();
        arfc_header.setTID(tid);
        state.setValue(0, tid);
        arfc_header.setDestination(act_cntl.destination);
        state.setValue(1, act_cntl.destination);
        arfc_header.setLuwCounter(1);
        state.setValue(2, 1);
        state.setValue(4, function);
        arfc_header.setBlockCounter(blcnt);
        if (qname != null) {
            state.setValue(16, 'I');
            int strlen = qname.length();
            FastStringBuffer strBuf = new FastStringBuffer(24);
            for (int i = 0; i < strlen; ++i) {
                strBuf.append(Character.toUpperCase(qname.charAt(i)));
            }
            qname = strBuf.toString();
            state.setValue(17, qname);
        }
        TRfc.RfcRecord(function, exporting, tables, arfcsdata, arfc_header, act_cntl, supportsASXML, classExceptionMode);
        try {
            RfcPut.ab_rfcput(act_cntl, 1284);
        }
        catch (RfcIoException ioEx) {
            if (act_cntl.trace) {
                StringBuffer text = new StringBuffer(64);
                text.append("Error> rfcQueueInsert [");
                text.append(act_cntl.hrfc);
                text.append("] : could not send ARFC_Agent container\n");
                Trc.ab_rfctrc(text.toString());
            }
            throw new RfcException(ioEx);
        }
        table[0] = arfcstate;
        table[1] = arfcsdata;
        act_cntl.RfcCallReceive("ARFC_DEST_SHIP", null, null, null, table, AbapClassException.Mode.OFF, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RfcRecord(String function, IRfcParameter[] exporting, IRfcTable[] tables, ARFCSDATA itab_h, ARfcSDataHeader header, RfcIoOpenCntl org_cntl, boolean supportsASXML, AbapClassException.Mode classExceptionMode) throws RfcException {
        String name = "EXTERNAL";
        RfcTypePlayback cntl = null;
        if (org_cntl == null) {
            throw new RfcException(18, "Handle not referenced", 104, 0L, true);
        }
        RfcIoOpenCntl loc_cntl = null;
        try {
            loc_cntl = RfcIoControl.ab_rfcopen(name, org_cntl.destination, 10, null);
            if (loc_cntl == null) {
                throw new RfcException(18, "RfcOpen for tRFC failed", 104, 0L, true);
            }
            cntl = (RfcTypePlayback)loc_cntl.channel;
            cntl.itab_h = itab_h;
            cntl.key = header;
            loc_cntl.setCodepage(org_cntl.getCodepage());
            loc_cntl.setCommunicationCodepage(org_cntl.getCommunicationCodepage());
            loc_cntl.pcs = org_cntl.pcs;
            loc_cntl.real_pcs = org_cntl.real_pcs;
            loc_cntl.trace = org_cntl.trace;
            loc_cntl.destination = org_cntl.destination;
            loc_cntl.userid = org_cntl.userid;
            loc_cntl.own_type = org_cntl.own_type;
            loc_cntl.own_rel = org_cntl.own_rel;
            loc_cntl.rfc_role = org_cntl.rfc_role;
            loc_cntl.own_type = org_cntl.own_type;
            loc_cntl.target = org_cntl.target;
            loc_cntl.mysapsso2 = org_cntl.mysapsso2;
            loc_cntl.th_client_id = org_cntl.th_client_id;
            loc_cntl.stateless = false;
            loc_cntl.RfcCall(function, exporting, null, null, tables, supportsASXML, classExceptionMode);
        }
        finally {
            if (loc_cntl != null) {
                loc_cntl.RfcClose();
                RfcIoControl.release(loc_cntl);
            }
        }
    }
}

