/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.RepositoryCacheProxy;
import com.sap.conn.jco.rt.json.Field;
import com.sap.conn.jco.rt.json.JCoRepositorySerializationException;
import com.sap.conn.jco.rt.json.JSonParser;
import java.io.IOException;

abstract class JSonContainerReader {
    RepositoryCacheProxy repo;
    JSonParser parser;

    JSonContainerReader(JSonParser parser) {
        this.parser = parser;
    }

    JSonContainerReader withRepository(JCoRepository r) {
        if (r instanceof BasicRepository) {
            this.repo = new RepositoryCacheProxy((BasicRepository)r);
            return this;
        }
        throw new IllegalArgumentException("Require repository instance created by JCo runtime to be able to add metadata to repository.");
    }

    public void read(BasicRepository r) throws IOException {
        this.withRepository(r);
        this.parser.assertChar('[');
        if (this.parser.nextNonBlankChar() == 123) {
            while (true) {
                String nextStr;
                if (!"name".equals(nextStr = this.parser.nextString())) {
                    throw new JCoRepositorySerializationException("\"name\" expected as first container attribute", this.parser);
                }
                this.parser.assertChar(':');
                String name = this.parser.nextString();
                this.read(name);
                this.parser.assertChar('}');
                if (this.parser.nextNonBlankChar() != 44) break;
                this.parser.assertChar('{');
            }
            this.parser.undo();
        } else {
            this.parser.undo();
        }
        this.parser.assertChar(']');
    }

    abstract JSonContainerReader read(String var1) throws IOException;

    void readFields() throws IOException {
        this.parser.assertChar('[');
        if (this.parser.nextNonBlankChar() == 123) {
            while (true) {
                Field f = null;
                while (true) {
                    f = this.readField();
                    if (this.parser.nextNonBlankChar() == 125) break;
                    this.parser.undo();
                    this.parser.assertChar(',');
                }
                if (f.name == null) {
                    throw new JCoRepositorySerializationException("element definition without a name ending", this.parser);
                }
                f.setImplicitValues();
                this.setField(f);
                if (this.parser.nextNonBlankChar() != 44) break;
                this.parser.assertChar('{');
            }
            this.parser.undo();
        } else {
            this.parser.undo();
        }
        this.parser.assertChar(']');
    }

    abstract void setField(Field var1) throws IOException;

    Field readField() throws IOException {
        Field field = new Field();
        do {
            String attribute = this.parser.nextString();
            this.parser.assertChar(':');
            if ("name".equals(attribute)) {
                field.name = this.parser.nextString();
                continue;
            }
            if ("abapType".equals(attribute)) {
                String typeAsString = this.parser.nextString();
                field.type = typeAsString.charAt(0);
                continue;
            }
            if ("ddicName".equals(attribute)) {
                field.ddicName = this.parser.nextString();
                continue;
            }
            if ("doc".equals(attribute)) {
                field.descr = this.parser.nextString();
                continue;
            }
            if ("default".equals(attribute)) {
                field.defaultValue = this.parser.nextString();
                continue;
            }
            if ("direction".equals(attribute)) {
                field.direction = this.parser.nextString();
                continue;
            }
            if ("recordFieldName".equals(attribute)) {
                field.recordFieldName = this.parser.nextString();
                continue;
            }
            if ("kind".equals(attribute)) {
                field.kind = this.parser.nextString();
                continue;
            }
            if ("nucLength".equals(attribute)) {
                field.nucLength = this.parser.nextInt();
                continue;
            }
            if ("ucLength".equals(attribute)) {
                field.ucLength = this.parser.nextInt();
                continue;
            }
            if ("nucOffset".equals(attribute)) {
                field.nucOffset = this.parser.nextInt();
                continue;
            }
            if ("ucOffset".equals(attribute)) {
                field.ucOffset = this.parser.nextInt();
                continue;
            }
            if ("decimals".equals(attribute)) {
                field.decimals = this.parser.nextInt();
                continue;
            }
            if ("declClass".equals(attribute)) {
                field.declaringClass = this.parser.nextString();
                continue;
            }
            if ("optional".equals(attribute)) {
                field.optional = this.parser.nextBool();
                continue;
            }
            if ("readonly".equals(attribute)) {
                field.readOnly = this.parser.nextBool();
                continue;
            }
            throw new JCoRepositorySerializationException("unknown attribute \"" + attribute + "\"", this.parser);
        } while (this.parser.nextNonBlankChar() == 44);
        this.parser.undo();
        return field;
    }
}

