/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.cxf.tools.fortest.holder;


import javax.jws.WebParam;
import javax.jws.WebParam.Mode;
import javax.jws.WebService;
import javax.xml.ws.Holder;

@WebService
public interface HolderService {

    String echo(String s1, String s2, 
                @WebParam(mode = Mode.OUT) Holder<String> outS2);

    String echo2(String s1, 
                 @WebParam(mode = Mode.OUT) Holder<String> outS2, String s2);

    String echo3(@WebParam(mode = Mode.INOUT, header = true, name = "header")
                 Holder<String> header, String s1);

}
