/*
 * Copyright 2013 Red Hat Inc. and/or its affiliates and other contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.switchyard.component.camel.deploy.support;

import javax.inject.Named;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;

/**
 *  Java DSL route builder perform onException.
 */
@Named("onExceptionRouteBuilder")
public class OnExceptionRouteBuilder extends RouteBuilder {

    public void configure() {
        onException(Exception.class)
            .log(">>>>> Entering onException clause")
            .handled(true);
        
        from("switchyard://OnExceptionService")
            .log(">>>>> OnExceptionService: Request received")
            .process(new Processor() {
                @Override
                public void process(Exchange exchange) throws Exception {
                    if (exchange.getIn().getBody().equals("processor")) {
                        throw new Exception("Throwing from processor");
                    }
                }
            })
            .log(">>>>> Forwarding to ExceptionService")
            .to("switchyard://ExceptionService");
    }

}
