/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.restlet;

import org.apache.camel.builder.RouteBuilder;
import org.junit.Test;

/**
 * @version 
 */
public class RestletRecipientListTest extends RestletTestSupport {

    @Test
    public void testRestlet() throws Exception {
        getMockEndpoint("mock:oracle").expectedBodiesReceived("110");
        getMockEndpoint("mock:apple").expectedBodiesReceived("150");

        template.sendBody("restlet:http://0.0.0.0:" + portNum + "/stock/ORCL?restletMethod=post", "110");
        template.sendBody("restlet:http://0.0.0.0:" + portNum + "/stock/APPL?restletMethod=post", "150");

        assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                from("restlet:http://0.0.0.0:" + portNum + "/stock/{symbol}?restletMethods=post")
                    .recipientList().simple("seda:${header.symbol}");

                from("seda:ORCL").to("mock:oracle");
                from("seda:APPL").to("mock:apple");
            }
        };
    }
}
