/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.parser.VMSFTPEntryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMSVersioningFTPEntryParser
extends VMSFTPEntryParser {
    private Matcher _preparse_matcher_;
    private Pattern _preparse_pattern_;
    private static final String PRE_PARSE_REGEX = "(.*);([0-9]+)\\s*.*";

    public VMSVersioningFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public VMSVersioningFTPEntryParser(FTPClientConfig config) {
        this.configure(config);
        try {
            this._preparse_pattern_ = Pattern.compile(PRE_PARSE_REGEX);
        }
        catch (PatternSyntaxException pse) {
            throw new IllegalArgumentException("Unparseable regex supplied:  (.*);([0-9]+)\\s*.*");
        }
    }

    @Override
    public List<String> preParse(List<String> original) {
        NameVersion existing;
        NameVersion nv;
        String version2;
        String name2;
        MatchResult result2;
        String entry2;
        original = super.preParse(original);
        HashMap<String, NameVersion> existingEntries = new HashMap<String, NameVersion>();
        ListIterator<String> iter2 = original.listIterator();
        while (iter2.hasNext()) {
            entry2 = iter2.next().trim();
            result2 = null;
            this._preparse_matcher_ = this._preparse_pattern_.matcher(entry2);
            if (!this._preparse_matcher_.matches()) continue;
            result2 = this._preparse_matcher_.toMatchResult();
            name2 = result2.group(1);
            version2 = result2.group(2);
            nv = new NameVersion(name2, version2);
            existing = (NameVersion)existingEntries.get(name2);
            if (null != existing && nv.versionNumber < existing.versionNumber) {
                iter2.remove();
                continue;
            }
            existingEntries.put(name2, nv);
        }
        while (iter2.hasPrevious()) {
            entry2 = iter2.previous().trim();
            result2 = null;
            this._preparse_matcher_ = this._preparse_pattern_.matcher(entry2);
            if (!this._preparse_matcher_.matches()) continue;
            result2 = this._preparse_matcher_.toMatchResult();
            name2 = result2.group(1);
            version2 = result2.group(2);
            nv = new NameVersion(name2, version2);
            existing = (NameVersion)existingEntries.get(name2);
            if (null == existing || nv.versionNumber >= existing.versionNumber) continue;
            iter2.remove();
        }
        return original;
    }

    @Override
    protected boolean isVersioning() {
        return true;
    }

    private static class NameVersion {
        String name;
        int versionNumber;

        NameVersion(String name2, String vers) {
            this.name = name2;
            this.versionNumber = Integer.parseInt(vers);
        }
    }
}

