/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.net.io.CopyStreamException;
import org.apache.commons.net.io.CopyStreamListener;

public final class Util {
    public static final int DEFAULT_COPY_BUFFER_SIZE = 1024;

    private Util() {
    }

    public static final long copyStream(InputStream source, OutputStream dest, int bufferSize, long streamSize, CopyStreamListener listener, boolean flush2) throws CopyStreamException {
        byte[] buffer2 = new byte[bufferSize];
        long total2 = 0L;
        try {
            int bytes2;
            while ((bytes2 = source.read(buffer2)) != -1) {
                if (bytes2 == 0) {
                    bytes2 = source.read();
                    if (bytes2 >= 0) {
                        dest.write(bytes2);
                        if (flush2) {
                            dest.flush();
                        }
                        ++total2;
                        if (listener == null) continue;
                        listener.bytesTransferred(total2, 1, streamSize);
                        continue;
                    }
                    break;
                }
                dest.write(buffer2, 0, bytes2);
                if (flush2) {
                    dest.flush();
                }
                total2 += (long)bytes2;
                if (listener == null) continue;
                listener.bytesTransferred(total2, bytes2, streamSize);
            }
        }
        catch (IOException e) {
            throw new CopyStreamException("IOException caught while copying.", total2, e);
        }
        return total2;
    }

    public static final long copyStream(InputStream source, OutputStream dest, int bufferSize, long streamSize, CopyStreamListener listener) throws CopyStreamException {
        return Util.copyStream(source, dest, bufferSize, streamSize, listener, true);
    }

    public static final long copyStream(InputStream source, OutputStream dest, int bufferSize) throws CopyStreamException {
        return Util.copyStream(source, dest, bufferSize, -1L, null);
    }

    public static final long copyStream(InputStream source, OutputStream dest) throws CopyStreamException {
        return Util.copyStream(source, dest, 1024);
    }

    public static final long copyReader(Reader source, Writer dest, int bufferSize, long streamSize, CopyStreamListener listener) throws CopyStreamException {
        char[] buffer2 = new char[bufferSize];
        long total2 = 0L;
        try {
            int chars;
            while ((chars = source.read(buffer2)) != -1) {
                if (chars == 0) {
                    chars = source.read();
                    if (chars >= 0) {
                        dest.write(chars);
                        dest.flush();
                        ++total2;
                        if (listener == null) continue;
                        listener.bytesTransferred(total2, chars, streamSize);
                        continue;
                    }
                    break;
                }
                dest.write(buffer2, 0, chars);
                dest.flush();
                total2 += (long)chars;
                if (listener == null) continue;
                listener.bytesTransferred(total2, chars, streamSize);
            }
        }
        catch (IOException e) {
            throw new CopyStreamException("IOException caught while copying.", total2, e);
        }
        return total2;
    }

    public static final long copyReader(Reader source, Writer dest, int bufferSize) throws CopyStreamException {
        return Util.copyReader(source, dest, bufferSize, -1L, null);
    }

    public static final long copyReader(Reader source, Writer dest) throws CopyStreamException {
        return Util.copyReader(source, dest, 1024);
    }
}

