/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.TrustStrategy;

class TrustManagerDecorator
implements X509TrustManager {
    private final X509TrustManager trustManager;
    private final TrustStrategy trustStrategy;

    TrustManagerDecorator(X509TrustManager trustManager, TrustStrategy trustStrategy) {
        this.trustManager = trustManager;
        this.trustStrategy = trustStrategy;
    }

    public void checkClientTrusted(X509Certificate[] chain2, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain2, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain2, String authType) throws CertificateException {
        if (!this.trustStrategy.isTrusted(chain2, authType)) {
            this.trustManager.checkServerTrusted(chain2, authType);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

