/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.net.Socket;
import org.apache.http.impl.SocketHttpClientConnection;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class DefaultHttpClientConnection
extends SocketHttpClientConnection {
    public void bind(Socket socket, HttpParams params2) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params2));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(params2));
        int linger = HttpConnectionParams.getLinger(params2);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        super.bind(socket, params2);
    }

    public String toString() {
        StringBuffer buffer2 = new StringBuffer();
        buffer2.append("[");
        if (this.isOpen()) {
            buffer2.append(this.getRemotePort());
        } else {
            buffer2.append("closed");
        }
        buffer2.append("]");
        return buffer2.toString();
    }
}

