/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicListHeaderIterator;
import org.apache.http.util.CharArrayBuffer;

public class HeaderGroup
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2608834160639271617L;
    private final List headers = new ArrayList(16);

    public void clear() {
        this.headers.clear();
    }

    public void addHeader(Header header2) {
        if (header2 == null) {
            return;
        }
        this.headers.add(header2);
    }

    public void removeHeader(Header header2) {
        if (header2 == null) {
            return;
        }
        this.headers.remove(header2);
    }

    public void updateHeader(Header header2) {
        if (header2 == null) {
            return;
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            Header current = (Header)this.headers.get(i);
            if (!current.getName().equalsIgnoreCase(header2.getName())) continue;
            this.headers.set(i, header2);
            return;
        }
        this.headers.add(header2);
    }

    public void setHeaders(Header[] headers) {
        this.clear();
        if (headers == null) {
            return;
        }
        for (int i = 0; i < headers.length; ++i) {
            this.headers.add(headers[i]);
        }
    }

    public Header getCondensedHeader(String name2) {
        Header[] headers = this.getHeaders(name2);
        if (headers.length == 0) {
            return null;
        }
        if (headers.length == 1) {
            return headers[0];
        }
        CharArrayBuffer valueBuffer = new CharArrayBuffer(128);
        valueBuffer.append(headers[0].getValue());
        for (int i = 1; i < headers.length; ++i) {
            valueBuffer.append(", ");
            valueBuffer.append(headers[i].getValue());
        }
        return new BasicHeader(name2.toLowerCase(Locale.ENGLISH), valueBuffer.toString());
    }

    public Header[] getHeaders(String name2) {
        ArrayList<Header> headersFound = new ArrayList<Header>();
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header2 = (Header)this.headers.get(i);
            if (!header2.getName().equalsIgnoreCase(name2)) continue;
            headersFound.add(header2);
        }
        return headersFound.toArray(new Header[headersFound.size()]);
    }

    public Header getFirstHeader(String name2) {
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header2 = (Header)this.headers.get(i);
            if (!header2.getName().equalsIgnoreCase(name2)) continue;
            return header2;
        }
        return null;
    }

    public Header getLastHeader(String name2) {
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            Header header2 = (Header)this.headers.get(i);
            if (!header2.getName().equalsIgnoreCase(name2)) continue;
            return header2;
        }
        return null;
    }

    public Header[] getAllHeaders() {
        return this.headers.toArray(new Header[this.headers.size()]);
    }

    public boolean containsHeader(String name2) {
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header2 = (Header)this.headers.get(i);
            if (!header2.getName().equalsIgnoreCase(name2)) continue;
            return true;
        }
        return false;
    }

    public HeaderIterator iterator() {
        return new BasicListHeaderIterator(this.headers, null);
    }

    public HeaderIterator iterator(String name2) {
        return new BasicListHeaderIterator(this.headers, name2);
    }

    public HeaderGroup copy() {
        HeaderGroup clone2 = new HeaderGroup();
        clone2.headers.addAll(this.headers);
        return clone2;
    }

    public Object clone() throws CloneNotSupportedException {
        HeaderGroup clone2 = (HeaderGroup)super.clone();
        clone2.headers.clear();
        clone2.headers.addAll(this.headers);
        return clone2;
    }

    public String toString() {
        return this.headers.toString();
    }
}

