/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.util.FS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetRC {
    static final Pattern NETRC = Pattern.compile("(\\S+)");
    static final String DEFAULT_ENTRY = "default";
    private File netrc;
    private long lastModified;
    private Map<String, NetRCEntry> hosts = new HashMap<String, NetRCEntry>();
    private static final TreeMap<String, State> STATE = new TreeMap<String, State>(){
        private static final long serialVersionUID = -4285910831814853334L;
        {
            this.put("machine", State.MACHINE);
            this.put("login", State.LOGIN);
            this.put("password", State.PASSWORD);
            this.put(NetRC.DEFAULT_ENTRY, State.DEFAULT);
            this.put("account", State.ACCOUNT);
            this.put("macdef", State.MACDEF);
        }
    };

    public NetRC() {
        this.netrc = NetRC.getDefaultFile();
        if (this.netrc != null) {
            this.parse();
        }
    }

    public NetRC(File netrc) {
        this.netrc = netrc;
        this.parse();
    }

    private static File getDefaultFile() {
        File home = FS.DETECTED.userHome();
        File netrc = new File(home, ".netrc");
        if (netrc.exists()) {
            return netrc;
        }
        netrc = new File(home, "_netrc");
        if (netrc.exists()) {
            return netrc;
        }
        return null;
    }

    public NetRCEntry getEntry(String host) {
        NetRCEntry entry2;
        if (this.netrc == null) {
            return null;
        }
        if (this.lastModified != this.netrc.lastModified()) {
            this.parse();
        }
        if ((entry2 = this.hosts.get(host)) == null) {
            entry2 = this.hosts.get(DEFAULT_ENTRY);
        }
        return entry2;
    }

    public Collection<NetRCEntry> getEntries() {
        return this.hosts.values();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse() {
        this.hosts.clear();
        this.lastModified = this.netrc.lastModified();
        BufferedReader r = null;
        try {
            try {
                r = new BufferedReader(new FileReader(this.netrc));
                String line = null;
                NetRCEntry entry2 = new NetRCEntry();
                State state = State.COMMAND;
                String macbody = "";
                Matcher matcher2 = NETRC.matcher("");
                while ((line = r.readLine()) != null) {
                    if (entry2.macdef != null && entry2.macbody == null) {
                        if (line.length() == 0) {
                            entry2.macbody = macbody;
                            macbody = "";
                            continue;
                        }
                        macbody = macbody + line + "\n";
                        continue;
                    }
                    matcher2.reset(line);
                    block17: while (matcher2.find()) {
                        String command = matcher2.group().toLowerCase();
                        if (command.startsWith("#")) {
                            matcher2.reset("");
                            continue;
                        }
                        state = STATE.get(command);
                        if (state == null) {
                            state = State.COMMAND;
                        }
                        switch (state) {
                            case COMMAND: {
                                break;
                            }
                            case ACCOUNT: {
                                if (entry2.account != null && entry2.complete()) {
                                    this.hosts.put(entry2.machine, entry2);
                                    entry2 = new NetRCEntry();
                                }
                                if (matcher2.find()) {
                                    entry2.account = matcher2.group();
                                }
                                state = State.COMMAND;
                                break;
                            }
                            case LOGIN: {
                                if (entry2.login != null && entry2.complete()) {
                                    this.hosts.put(entry2.machine, entry2);
                                    entry2 = new NetRCEntry();
                                }
                                if (matcher2.find()) {
                                    entry2.login = matcher2.group();
                                }
                                state = State.COMMAND;
                                break;
                            }
                            case PASSWORD: {
                                if (entry2.password != null && entry2.complete()) {
                                    this.hosts.put(entry2.machine, entry2);
                                    entry2 = new NetRCEntry();
                                }
                                if (matcher2.find()) {
                                    entry2.password = matcher2.group().toCharArray();
                                }
                                state = State.COMMAND;
                                break;
                            }
                            case DEFAULT: {
                                if (entry2.machine != null && entry2.complete()) {
                                    this.hosts.put(entry2.machine, entry2);
                                    entry2 = new NetRCEntry();
                                }
                                entry2.machine = DEFAULT_ENTRY;
                                state = State.COMMAND;
                                break;
                            }
                            case MACDEF: {
                                if (entry2.macdef != null && entry2.complete()) {
                                    this.hosts.put(entry2.machine, entry2);
                                    entry2 = new NetRCEntry();
                                }
                                if (matcher2.find()) {
                                    entry2.macdef = matcher2.group();
                                }
                                state = State.COMMAND;
                                break;
                            }
                            case MACHINE: {
                                if (entry2.machine != null && entry2.complete()) {
                                    this.hosts.put(entry2.machine, entry2);
                                    entry2 = new NetRCEntry();
                                }
                                if (matcher2.find()) {
                                    entry2.machine = matcher2.group();
                                }
                                state = State.COMMAND;
                                continue block17;
                            }
                        }
                    }
                }
                if (entry2.macdef != null && entry2.macbody == null) {
                    entry2.macbody = macbody;
                }
                if (entry2.complete()) {
                    this.hosts.put(entry2.machine, entry2);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable2) {
            Object var9_10 = null;
            try {
                if (r == null) throw throwable2;
                r.close();
                throw throwable2;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (r == null) return;
        r.close();
    }

    public static class NetRCEntry {
        public String login;
        public char[] password;
        public String machine;
        public String account;
        public String macdef;
        public String macbody;

        boolean complete() {
            return this.login != null && this.password != null && this.machine != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        COMMAND,
        MACHINE,
        LOGIN,
        PASSWORD,
        DEFAULT,
        ACCOUNT,
        MACDEF;

    }
}

