/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Camel Api Route test generated by camel-component-util-maven-plugin
 * Generated on: Wed Jul 09 19:57:11 PDT 2014
 */
package org.apache.camel.component.linkedin;

import java.util.HashMap;
import java.util.Map;

import org.apache.camel.builder.RouteBuilder;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Test class for {@link org.apache.camel.component.linkedin.api.SearchResource} APIs.
 */
public class SearchResourceIntegrationTest extends AbstractLinkedInTestSupport {

    private static final Logger LOG = LoggerFactory.getLogger(SearchResourceIntegrationTest.class);
    private static final String PATH_PREFIX = "search";

    @Test
    public void testSearchCompanies() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.fields", "");
        // parameter type is String
        headers.put("CamelLinkedIn.keywords", "linkedin");
        // all fields are nullable, and fields defaults to ""
/*
        // parameter type is String
        headers.put("CamelLinkedIn.hq_only", null);
        // parameter type is String
        headers.put("CamelLinkedIn.facet", null);
        // parameter type is String
        headers.put("CamelLinkedIn.facets", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.start", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.count", null);
        // parameter type is String
        headers.put("CamelLinkedIn.sort", null);
*/

        final org.apache.camel.component.linkedin.api.model.CompanySearch result = requestBodyAndHeaders("direct://SEARCHCOMPANIES", null, headers);

        assertNotNull("searchCompanies result", result);
        LOG.debug("searchCompanies: " + result);
    }

    @Ignore("Requires vetted API Access Program")
    @Test
    public void testSearchJobs() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.fields", "");
/*
        // parameter type is String
        headers.put("CamelLinkedIn.keywords", null);
        // parameter type is String
        headers.put("CamelLinkedIn.company_name", null);
        // parameter type is String
        headers.put("CamelLinkedIn.job_title", null);
        // parameter type is String
        headers.put("CamelLinkedIn.country_code", null);
        // parameter type is String
        headers.put("CamelLinkedIn.postal_code", null);
        // parameter type is org.apache.camel.component.linkedin.api.model.Distance
        headers.put("CamelLinkedIn.distance", null);
        // parameter type is String
        headers.put("CamelLinkedIn.facet", null);
        // parameter type is String
        headers.put("CamelLinkedIn.facets", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.start", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.count", null);
        // parameter type is String
        headers.put("CamelLinkedIn.sort", null);
*/

        final org.apache.camel.component.linkedin.api.model.JobSearch result = requestBodyAndHeaders("direct://SEARCHJOBS", null, headers);

        assertNotNull("searchJobs result", result);
        LOG.debug("searchJobs: " + result);
    }

    @Ignore("Requires vetted API Access Program")
    @Test
    public void testSearchPeople() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.fields", "");
/*
        // parameter type is String
        headers.put("CamelLinkedIn.keywords", null);
        // parameter type is String
        headers.put("CamelLinkedIn.first_name", null);
        // parameter type is String
        headers.put("CamelLinkedIn.last_name", null);
        // parameter type is String
        headers.put("CamelLinkedIn.company_name", null);
        // parameter type is String
        headers.put("CamelLinkedIn.current_company", null);
        // parameter type is String
        headers.put("CamelLinkedIn.title", null);
        // parameter type is String
        headers.put("CamelLinkedIn.current_title", null);
        // parameter type is String
        headers.put("CamelLinkedIn.school_name", null);
        // parameter type is String
        headers.put("CamelLinkedIn.current_school", null);
        // parameter type is String
        headers.put("CamelLinkedIn.country_code", null);
        // parameter type is String
        headers.put("CamelLinkedIn.postal_code", null);
        // parameter type is org.apache.camel.component.linkedin.api.model.Distance
        headers.put("CamelLinkedIn.distance", null);
        // parameter type is String
        headers.put("CamelLinkedIn.facet", null);
        // parameter type is String
        headers.put("CamelLinkedIn.facets", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.start", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.count", null);
        // parameter type is String
        headers.put("CamelLinkedIn.sort", null);
*/

        final org.apache.camel.component.linkedin.api.model.PeopleSearch result = requestBodyAndHeaders("direct://SEARCHPEOPLE", null, headers);

        assertNotNull("searchPeople result", result);
        LOG.debug("searchPeople: " + result);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder() {
            public void configure() {
                // test route for searchCompanies
                from("direct://SEARCHCOMPANIES")
                    .to("linkedin://" + PATH_PREFIX + "/searchCompanies");

                // test route for searchJobs
                from("direct://SEARCHJOBS")
                    .to("linkedin://" + PATH_PREFIX + "/searchJobs");

                // test route for searchPeople
                from("direct://SEARCHPEOPLE")
                    .to("linkedin://" + PATH_PREFIX + "/searchPeople");

            }
        };
    }
}
