#!/usr/bin/groovy

import groovy.xml.XmlUtil
import java.nio.file.Files
import java.nio.file.StandardCopyOption
/**
 * A script to merge the license.xml files and downloaded licenses from the dependency feature pack projects
 */

def dependencyFeaturePackPaths = [
    "${basedir}/../modules",
    "${basedir}/../extrasA",
    "${basedir}/../extrasB",
    "${basedir}/../extrasC",
    "${basedir}/../extrasD",
]

final File docsPackageDir = new File("${basedir}/src/main/resources/packages/docs.licenses")
final File outputFile = new File("${docsPackageDir}/content/docs/fuse/licenses/licenses.xml")
final File outputDir = new File("${docsPackageDir}/pm/wildfly/licenses")
outputDir.mkdirs()

def result = null

// Build up a list of modules and identify duplicates
dependencyFeaturePackPaths.eachWithIndex { path, i ->

    final File licensesXmlPath = new File("${path}/src/main/licenses/licenses.xml")
    assert licensesXmlPath.exists() : "${licensesXmlPath} does not exist; you may want to build the dependency project"

    if (i == 0) {
        result = new XmlParser().parseText(licensesXmlPath.getText())
    } else {
        def toAdd = new XmlParser().parseText(licensesXmlPath.getText())
        toAdd.dependencies.dependency.each{ dep ->
            result.dependencies[0].children().add(dep)
        }
    }

    new File("${path}/src/main/licenses").eachFile { licFile ->
        if (licFile.getName() != "licenses.xml") {
           Files.copy(licFile.toPath(), outputDir.toPath().resolve(licFile.getName()), StandardCopyOption.REPLACE_EXISTING)
        }
    }
}

result.dependencies[0].children().sort(true) { dep ->
    dep.get("groupId").get(0).text() +":"+ dep.get("artifactId").get(0).text() +":"+ dep.get("version").get(0).text()
}

new File("${outputDir}/licenses.xml").withWriter('UTF-8') { writer ->
    writer.write(XmlUtil.serialize(result))
}

outputFile.withWriter('UTF-8') { writer ->
    writer.write(XmlUtil.serialize(result))
}
