/*
 * #%L
 * Fuse Patch :: Core
 * %%
 * Copyright (C) 2015 Private
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.wildfly.extras.patch.test;

import org.junit.Assert;
import org.junit.Test;
import org.wildfly.extras.patch.Record;

public class ParseRecordTest {

    private static final String LINE_WITHOUT_SPACES = "INFO withouth_spaces 2562598008";
    private static final String LINE_WITH_SPACES = "INFO wit space 2562598008";

    @Test
    public void testParsingWithSaces() {

        Record r = Record.fromString(LINE_WITHOUT_SPACES);
        //parsing has to finish successfully
        Assert.assertNotNull(r);

        r = Record.fromString(LINE_WITH_SPACES);
        //parsing has to finish successfully
        Assert.assertNotNull(r);
    }
}
