/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Vector;

class Util {
    private static final byte[] b64 = Util.str2byte("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=");
    private static String[] chars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    static final byte[] empty = Util.str2byte("");

    Util() {
    }

    private static byte val(byte foo) {
        if (foo == 61) {
            return 0;
        }
        for (int j = 0; j < b64.length; ++j) {
            if (foo != b64[j]) continue;
            return (byte)j;
        }
        return 0;
    }

    static byte[] fromBase64(byte[] buf, int start, int length) {
        byte[] foo = new byte[length];
        int j = 0;
        for (int i = start; i < start + length; i += 4) {
            foo[j] = (byte)(Util.val(buf[i]) << 2 | (Util.val(buf[i + 1]) & 0x30) >>> 4);
            if (buf[i + 2] == 61) {
                ++j;
                break;
            }
            foo[j + 1] = (byte)((Util.val(buf[i + 1]) & 0xF) << 4 | (Util.val(buf[i + 2]) & 0x3C) >>> 2);
            if (buf[i + 3] == 61) {
                j += 2;
                break;
            }
            foo[j + 2] = (byte)((Util.val(buf[i + 2]) & 3) << 6 | Util.val(buf[i + 3]) & 0x3F);
            j += 3;
        }
        byte[] bar2 = new byte[j];
        System.arraycopy(foo, 0, bar2, 0, j);
        return bar2;
    }

    static byte[] toBase64(byte[] buf, int start, int length) {
        int k;
        int j;
        byte[] tmp = new byte[length * 2];
        int foo = length / 3 * 3 + start;
        int i = 0;
        for (j = start; j < foo; j += 3) {
            k = buf[j] >>> 2 & 0x3F;
            tmp[i++] = b64[k];
            k = (buf[j] & 3) << 4 | buf[j + 1] >>> 4 & 0xF;
            tmp[i++] = b64[k];
            k = (buf[j + 1] & 0xF) << 2 | buf[j + 2] >>> 6 & 3;
            tmp[i++] = b64[k];
            k = buf[j + 2] & 0x3F;
            tmp[i++] = b64[k];
        }
        if ((foo = start + length - foo) == 1) {
            k = buf[j] >>> 2 & 0x3F;
            tmp[i++] = b64[k];
            k = (buf[j] & 3) << 4 & 0x3F;
            tmp[i++] = b64[k];
            tmp[i++] = 61;
            tmp[i++] = 61;
        } else if (foo == 2) {
            k = buf[j] >>> 2 & 0x3F;
            tmp[i++] = b64[k];
            k = (buf[j] & 3) << 4 | buf[j + 1] >>> 4 & 0xF;
            tmp[i++] = b64[k];
            k = (buf[j + 1] & 0xF) << 2 & 0x3F;
            tmp[i++] = b64[k];
            tmp[i++] = 61;
        }
        byte[] bar2 = new byte[i];
        System.arraycopy(tmp, 0, bar2, 0, i);
        return bar2;
    }

    static String[] split(String foo, String split2) {
        int index2;
        if (foo == null) {
            return null;
        }
        byte[] buf = Util.str2byte(foo);
        Vector<String> bar2 = new Vector<String>();
        int start = 0;
        while ((index2 = foo.indexOf(split2, start)) >= 0) {
            bar2.addElement(Util.byte2str(buf, start, index2 - start));
            start = index2 + 1;
        }
        bar2.addElement(Util.byte2str(buf, start, buf.length - start));
        String[] result2 = new String[bar2.size()];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = (String)bar2.elementAt(i);
        }
        return result2;
    }

    static boolean glob(byte[] pattern2, byte[] name2) {
        return Util.glob0(pattern2, 0, name2, 0);
    }

    private static boolean glob0(byte[] pattern2, int pattern_index, byte[] name2, int name_index) {
        if (name2.length > 0 && name2[0] == 46) {
            if (pattern2.length > 0 && pattern2[0] == 46) {
                if (pattern2.length == 2 && pattern2[1] == 42) {
                    return true;
                }
                return Util.glob(pattern2, pattern_index + 1, name2, name_index + 1);
            }
            return false;
        }
        return Util.glob(pattern2, pattern_index, name2, name_index);
    }

    private static boolean glob(byte[] pattern2, int pattern_index, byte[] name2, int name_index) {
        int patternlen = pattern2.length;
        if (patternlen == 0) {
            return false;
        }
        int namelen = name2.length;
        int i = pattern_index;
        int j = name_index;
        while (i < patternlen && j < namelen) {
            if (pattern2[i] == 92) {
                if (i + 1 == patternlen) {
                    return false;
                }
                if (pattern2[++i] != name2[j]) {
                    return false;
                }
                i += Util.skipUTF8Char(pattern2[i]);
                j += Util.skipUTF8Char(name2[j]);
                continue;
            }
            if (pattern2[i] == 42) {
                while (i < patternlen && pattern2[i] == 42) {
                    ++i;
                }
                if (patternlen == i) {
                    return true;
                }
                byte foo = pattern2[i];
                if (foo == 63) {
                    while (j < namelen) {
                        if (Util.glob(pattern2, i, name2, j)) {
                            return true;
                        }
                        j += Util.skipUTF8Char(name2[j]);
                    }
                    return false;
                }
                if (foo == 92) {
                    if (i + 1 == patternlen) {
                        return false;
                    }
                    foo = pattern2[++i];
                    while (j < namelen) {
                        if (foo == name2[j] && Util.glob(pattern2, i + Util.skipUTF8Char(foo), name2, j + Util.skipUTF8Char(name2[j]))) {
                            return true;
                        }
                        j += Util.skipUTF8Char(name2[j]);
                    }
                    return false;
                }
                while (j < namelen) {
                    if (foo == name2[j] && Util.glob(pattern2, i, name2, j)) {
                        return true;
                    }
                    j += Util.skipUTF8Char(name2[j]);
                }
                return false;
            }
            if (pattern2[i] == 63) {
                ++i;
                j += Util.skipUTF8Char(name2[j]);
                continue;
            }
            if (pattern2[i] != name2[j]) {
                return false;
            }
            i += Util.skipUTF8Char(pattern2[i]);
            if ((j += Util.skipUTF8Char(name2[j])) < namelen) continue;
            if (i >= patternlen) {
                return true;
            }
            if (pattern2[i] != 42) continue;
        }
        if (i == patternlen && j == namelen) {
            return true;
        }
        if (j >= namelen && pattern2[i] == 42) {
            boolean ok = true;
            while (i < patternlen) {
                if (pattern2[i++] == 42) continue;
                ok = false;
                break;
            }
            return ok;
        }
        return false;
    }

    static String quote(String path2) {
        byte[] _path = Util.str2byte(path2);
        int count2 = 0;
        for (int i = 0; i < _path.length; ++i) {
            byte b = _path[i];
            if (b != 92 && b != 63 && b != 42) continue;
            ++count2;
        }
        if (count2 == 0) {
            return path2;
        }
        byte[] _path2 = new byte[_path.length + count2];
        int j = 0;
        for (int i = 0; i < _path.length; ++i) {
            byte b = _path[i];
            if (b == 92 || b == 63 || b == 42) {
                _path2[j++] = 92;
            }
            _path2[j++] = b;
        }
        return Util.byte2str(_path2);
    }

    static String unquote(String path2) {
        byte[] bar2;
        byte[] foo = Util.str2byte(path2);
        if (foo.length == (bar2 = Util.unquote(foo)).length) {
            return path2;
        }
        return Util.byte2str(bar2);
    }

    static byte[] unquote(byte[] path2) {
        int pathlen = path2.length;
        int i = 0;
        while (i < pathlen) {
            if (path2[i] == 92) {
                if (i + 1 == pathlen) break;
                System.arraycopy(path2, i + 1, path2, i, path2.length - (i + 1));
                --pathlen;
                ++i;
                continue;
            }
            ++i;
        }
        if (pathlen == path2.length) {
            return path2;
        }
        byte[] foo = new byte[pathlen];
        System.arraycopy(path2, 0, foo, 0, pathlen);
        return foo;
    }

    static String getFingerPrint(HASH hash2, byte[] data) {
        try {
            hash2.init();
            hash2.update(data, 0, data.length);
            byte[] foo = hash2.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < foo.length; ++i) {
                int bar2 = foo[i] & 0xFF;
                sb.append(chars[bar2 >>> 4 & 0xF]);
                sb.append(chars[bar2 & 0xF]);
                if (i + 1 >= foo.length) continue;
                sb.append(":");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "???";
        }
    }

    static boolean array_equals(byte[] foo, byte[] bar2) {
        int i = foo.length;
        if (i != bar2.length) {
            return false;
        }
        for (int j = 0; j < i; ++j) {
            if (foo[j] == bar2[j]) continue;
            return false;
        }
        return true;
    }

    static Socket createSocket(String host, int port, int timeout) throws JSchException {
        Socket socket = null;
        if (timeout == 0) {
            try {
                socket = new Socket(host, port);
                return socket;
            }
            catch (Exception e) {
                String message = e.toString();
                if (e instanceof Throwable) {
                    throw new JSchException(message, e);
                }
                throw new JSchException(message);
            }
        }
        final String _host = host;
        final int _port = port;
        final Socket[] sockp = new Socket[1];
        final Exception[] ee = new Exception[1];
        String message = "";
        Thread tmp = new Thread(new Runnable(){

            public void run() {
                sockp[0] = null;
                try {
                    sockp[0] = new Socket(_host, _port);
                }
                catch (Exception e) {
                    ee[0] = e;
                    if (sockp[0] != null && sockp[0].isConnected()) {
                        try {
                            sockp[0].close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    sockp[0] = null;
                }
            }
        });
        tmp.setName("Opening Socket " + host);
        tmp.start();
        try {
            tmp.join(timeout);
            message = "timeout: ";
        }
        catch (InterruptedException eee) {
            // empty catch block
        }
        if (sockp[0] == null || !sockp[0].isConnected()) {
            message = message + "socket is not established";
            if (ee[0] != null) {
                message = ee[0].toString();
            }
            tmp.interrupt();
            tmp = null;
            throw new JSchException(message);
        }
        socket = sockp[0];
        return socket;
    }

    static byte[] str2byte(String str, String encoding) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            return str.getBytes();
        }
    }

    static byte[] str2byte(String str) {
        return Util.str2byte(str, "UTF-8");
    }

    static String byte2str(byte[] str, String encoding) {
        return Util.byte2str(str, 0, str.length, encoding);
    }

    static String byte2str(byte[] str, int s2, int l, String encoding) {
        try {
            return new String(str, s2, l, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(str, s2, l);
        }
    }

    static String byte2str(byte[] str) {
        return Util.byte2str(str, 0, str.length, "UTF-8");
    }

    static String byte2str(byte[] str, int s2, int l) {
        return Util.byte2str(str, s2, l, "UTF-8");
    }

    static void bzero(byte[] foo) {
        if (foo == null) {
            return;
        }
        for (int i = 0; i < foo.length; ++i) {
            foo[i] = 0;
        }
    }

    static String diffString(String str, String[] not_available) {
        String[] stra = Util.split(str, ",");
        String result2 = null;
        block0: for (int i = 0; i < stra.length; ++i) {
            for (int j = 0; j < not_available.length; ++j) {
                if (stra[i].equals(not_available[j])) continue block0;
            }
            result2 = result2 == null ? stra[i] : result2 + "," + stra[i];
        }
        return result2;
    }

    static String checkTilde(String str) {
        if (str.indexOf("~") != -1) {
            try {
                str = str.replace("~", System.getProperty("user.home"));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return str;
    }

    private static int skipUTF8Char(byte b) {
        if ((byte)(b & 0x80) == 0) {
            return 1;
        }
        if ((byte)(b & 0xE0) == -64) {
            return 2;
        }
        if ((byte)(b & 0xF0) == -32) {
            return 3;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] fromFile(String _file) throws IOException {
        _file = Util.checkTilde(_file);
        File file = new File(_file);
        FileInputStream fis = new FileInputStream(_file);
        try {
            int i;
            byte[] result2 = new byte[(int)file.length()];
            int len = 0;
            while ((i = fis.read(result2, len, result2.length - len)) > 0) {
                len += i;
            }
            fis.close();
            byte[] byArray = result2;
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }
}

