/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.text.ParseException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;

public class UnixFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    static final String DEFAULT_DATE_FORMAT = "MMM d yyyy";
    static final String DEFAULT_RECENT_DATE_FORMAT = "MMM d HH:mm";
    static final String NUMERIC_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    public static final FTPClientConfig NUMERIC_DATE_CONFIG = new FTPClientConfig("UNIX", "yyyy-MM-dd HH:mm", null, null, null, null);
    private static final String REGEX = "([bcdelfmpSs-])(((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-])))\\+?\\s+(\\d+)\\s+(?:(\\S+(?:\\s\\S+)*?)\\s+)?(?:(\\S+(?:\\s\\S+)*)\\s+)?(\\d+(?:,\\s*\\d+)?)\\s+((?:\\d+[-/]\\d+[-/]\\d+)|(?:\\S+\\s+\\S+))\\s+(\\d+(?::\\d+)?)\\s+(\\S*)(\\s*.*)";

    public UnixFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public UnixFTPEntryParser(FTPClientConfig config) {
        super(REGEX);
        this.configure(config);
    }

    public FTPFile parseFTPEntry(String entry2) {
        FTPFile file = new FTPFile();
        file.setRawListing(entry2);
        boolean isDevice = false;
        if (this.matches(entry2)) {
            int type;
            String typeStr = this.group(1);
            String hardLinkCount = this.group(15);
            String usr = this.group(16);
            String grp = this.group(17);
            String filesize = this.group(18);
            String datestr = this.group(19) + " " + this.group(20);
            String name2 = this.group(21);
            String endtoken = this.group(22);
            try {
                file.setTimestamp(super.parseTimestamp(datestr));
            }
            catch (ParseException e) {
                // empty catch block
            }
            switch (typeStr.charAt(0)) {
                case 'd': {
                    type = 1;
                    break;
                }
                case 'e': {
                    type = 2;
                    break;
                }
                case 'l': {
                    type = 2;
                    break;
                }
                case 'b': 
                case 'c': {
                    isDevice = true;
                }
                case '-': 
                case 'f': {
                    type = 0;
                    break;
                }
                default: {
                    type = 3;
                }
            }
            file.setType(type);
            int g2 = 4;
            int access2 = 0;
            while (access2 < 3) {
                file.setPermission(access2, 0, !this.group(g2).equals("-"));
                file.setPermission(access2, 1, !this.group(g2 + 1).equals("-"));
                String execPerm = this.group(g2 + 2);
                if (!execPerm.equals("-") && !Character.isUpperCase(execPerm.charAt(0))) {
                    file.setPermission(access2, 2, true);
                } else {
                    file.setPermission(access2, 2, false);
                }
                ++access2;
                g2 += 4;
            }
            if (!isDevice) {
                try {
                    file.setHardLinkCount(Integer.parseInt(hardLinkCount));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            file.setUser(usr);
            file.setGroup(grp);
            try {
                file.setSize(Long.parseLong(filesize));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (null == endtoken) {
                file.setName(name2);
            } else {
                name2 = name2 + endtoken;
                if (type == 2) {
                    int end2 = name2.indexOf(" -> ");
                    if (end2 == -1) {
                        file.setName(name2);
                    } else {
                        file.setName(name2.substring(0, end2));
                        file.setLink(name2.substring(end2 + 4));
                    }
                } else {
                    file.setName(name2);
                }
            }
            return file;
        }
        return null;
    }

    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("UNIX", DEFAULT_DATE_FORMAT, DEFAULT_RECENT_DATE_FORMAT, null, null, null);
    }
}

