/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class URLEncodedUtils {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";

    public static List<NameValuePair> parse(URI uri, String encoding) {
        List<NameValuePair> result2 = Collections.emptyList();
        String query = uri.getRawQuery();
        if (query != null && query.length() > 0) {
            result2 = new ArrayList<NameValuePair>();
            URLEncodedUtils.parse(result2, new Scanner(query), encoding);
        }
        return result2;
    }

    public static List<NameValuePair> parse(HttpEntity entity) throws IOException {
        String content;
        HeaderElement[] elems;
        List<NameValuePair> result2 = Collections.emptyList();
        String contentType2 = null;
        String charset = null;
        Header h2 = entity.getContentType();
        if (h2 != null && (elems = h2.getElements()).length > 0) {
            HeaderElement elem2 = elems[0];
            contentType2 = elem2.getName();
            NameValuePair param2 = elem2.getParameterByName("charset");
            if (param2 != null) {
                charset = param2.getValue();
            }
        }
        if (contentType2 != null && contentType2.equalsIgnoreCase(CONTENT_TYPE) && (content = EntityUtils.toString(entity, "ASCII")) != null && content.length() > 0) {
            result2 = new ArrayList<NameValuePair>();
            URLEncodedUtils.parse(result2, new Scanner(content), charset);
        }
        return result2;
    }

    public static boolean isEncoded(HttpEntity entity) {
        Header h2 = entity.getContentType();
        if (h2 != null) {
            HeaderElement[] elems = h2.getElements();
            if (elems.length > 0) {
                String contentType2 = elems[0].getName();
                return contentType2.equalsIgnoreCase(CONTENT_TYPE);
            }
            return false;
        }
        return false;
    }

    public static void parse(List<NameValuePair> parameters, Scanner scanner, String encoding) {
        scanner.useDelimiter(PARAMETER_SEPARATOR);
        while (scanner.hasNext()) {
            String[] nameValue = scanner.next().split(NAME_VALUE_SEPARATOR);
            if (nameValue.length == 0 || nameValue.length > 2) {
                throw new IllegalArgumentException("bad parameter");
            }
            String name2 = URLEncodedUtils.decode(nameValue[0], encoding);
            String value2 = null;
            if (nameValue.length == 2) {
                value2 = URLEncodedUtils.decode(nameValue[1], encoding);
            }
            parameters.add(new BasicNameValuePair(name2, value2));
        }
    }

    public static String format(List<? extends NameValuePair> parameters, String encoding) {
        StringBuilder result2 = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedValue;
            String encodedName = URLEncodedUtils.encode(nameValuePair.getName(), encoding);
            String value2 = nameValuePair.getValue();
            String string2 = encodedValue = value2 != null ? URLEncodedUtils.encode(value2, encoding) : "";
            if (result2.length() > 0) {
                result2.append(PARAMETER_SEPARATOR);
            }
            result2.append(encodedName);
            result2.append(NAME_VALUE_SEPARATOR);
            result2.append(encodedValue);
        }
        return result2.toString();
    }

    private static String decode(String content, String encoding) {
        try {
            return URLDecoder.decode(content, encoding != null ? encoding : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }
}

