/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.text.MessageFormat;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BeforeDfsPackIndexLoadedEvent;
import org.eclipse.jgit.internal.storage.dfs.DeltaBaseCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackKey;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsText;
import org.eclipse.jgit.internal.storage.dfs.LargePackedWholeObject;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.pack.BinaryDelta;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.LongList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfsPackFile {
    private static final long POS_INDEX = -1L;
    private static final long POS_REVERSE_INDEX = -2L;
    private static final long POS_BITMAP_INDEX = -3L;
    private final DfsBlockCache cache;
    private final DfsPackDescription packDesc;
    final DfsPackKey key;
    volatile long length;
    private volatile int blockSize;
    private volatile boolean invalid;
    private final Object initLock = new Object();
    private volatile DfsBlockCache.Ref<PackIndex> index;
    private volatile DfsBlockCache.Ref<PackReverseIndex> reverseIndex;
    private volatile DfsBlockCache.Ref<PackBitmapIndex> bitmapIndex;
    private volatile LongList corruptObjects;

    DfsPackFile(DfsBlockCache cache, DfsPackDescription desc, DfsPackKey key) {
        this.cache = cache;
        this.packDesc = desc;
        this.key = key;
        this.length = desc.getFileSize(PackExt.PACK);
        if (this.length <= 0L) {
            this.length = -1L;
        }
    }

    public DfsPackDescription getPackDescription() {
        return this.packDesc;
    }

    public boolean isIndexLoaded() {
        DfsBlockCache.Ref<PackIndex> idxref = this.index;
        return idxref != null && idxref.has();
    }

    public long getCachedSize() {
        return this.key.cachedSize.get();
    }

    private String getPackName() {
        return this.packDesc.getFileName(PackExt.PACK);
    }

    void setBlockSize(int newSize) {
        this.blockSize = newSize;
    }

    void setPackIndex(PackIndex idx) {
        long objCnt = idx.getObjectCount();
        int recSize = 28;
        int sz = (int)Math.min(objCnt * (long)recSize, Integer.MAX_VALUE);
        this.index = this.cache.put(this.key, -1L, sz, idx);
    }

    PackIndex getPackIndex(DfsReader ctx) throws IOException {
        return this.idx(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackIndex idx(DfsReader ctx) throws IOException {
        PackIndex idx;
        DfsBlockCache.Ref<PackIndex> idxref = this.index;
        if (idxref != null && (idx = idxref.get()) != null) {
            return idx;
        }
        if (this.invalid) {
            throw new PackInvalidException(this.getPackName());
        }
        Repository.getGlobalListenerList().dispatch(new BeforeDfsPackIndexLoadedEvent(this));
        Object object = this.initLock;
        synchronized (object) {
            PackIndex idx2;
            idxref = this.index;
            if (idxref != null && (idx2 = idxref.get()) != null) {
                return idx2;
            }
            try {
                ReadableChannel rc = ctx.db.openFile(this.packDesc, PackExt.INDEX);
                try {
                    InputStream in = Channels.newInputStream(rc);
                    int wantSize = 8192;
                    int bs = rc.blockSize();
                    if (0 < bs && bs < wantSize) {
                        bs = wantSize / bs * bs;
                    } else if (bs <= 0) {
                        bs = wantSize;
                    }
                    in = new BufferedInputStream(in, bs);
                    idx2 = PackIndex.read(in);
                    Object var10_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_14 = null;
                    rc.close();
                    throw throwable2;
                }
                rc.close();
                {
                }
            }
            catch (EOFException e) {
                this.invalid = true;
                IOException e2 = new IOException(MessageFormat.format(DfsText.get().shortReadOfIndex, this.packDesc.getFileName(PackExt.INDEX)));
                e2.initCause(e);
                throw e2;
            }
            catch (IOException e) {
                this.invalid = true;
                IOException e2 = new IOException(MessageFormat.format(DfsText.get().cannotReadIndex, this.packDesc.getFileName(PackExt.INDEX)));
                e2.initCause(e);
                throw e2;
            }
            this.setPackIndex(idx2);
            return idx2;
        }
    }

    final boolean isGarbage() {
        return this.packDesc.getPackSource() == DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    PackBitmapIndex getBitmapIndex(DfsReader ctx) throws IOException {
        PackBitmapIndex idx;
        if (this.invalid || this.isGarbage()) {
            return null;
        }
        DfsBlockCache.Ref<PackBitmapIndex> idxref = this.bitmapIndex;
        if (idxref != null && (idx = idxref.get()) != null) {
            return idx;
        }
        if (!this.packDesc.hasFileExt(PackExt.BITMAP_INDEX)) {
            return null;
        }
        Object object = this.initLock;
        synchronized (object) {
            void var4_5;
            PackBitmapIndex idx2;
            PackBitmapIndex idx3;
            idxref = this.bitmapIndex;
            if (idxref != null && (idx3 = idxref.get()) != null) {
                return idx3;
            }
            try {
                ReadableChannel rc = ctx.db.openFile(this.packDesc, PackExt.BITMAP_INDEX);
                try {
                    InputStream in = Channels.newInputStream(rc);
                    int wantSize = 8192;
                    int bs = rc.blockSize();
                    if (0 < bs && bs < wantSize) {
                        bs = wantSize / bs * bs;
                    } else if (bs <= 0) {
                        bs = wantSize;
                    }
                    in = new BufferedInputStream(in, bs);
                    idx2 = PackBitmapIndex.read(in, this.idx(ctx), this.getReverseIdx(ctx));
                    Object var12_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_17 = null;
                    long size2 = rc.position();
                    rc.close();
                    throw throwable2;
                }
                long size2 = rc.position();
                rc.close();
                {
                }
            }
            catch (EOFException e) {
                IOException e2 = new IOException(MessageFormat.format(DfsText.get().shortReadOfIndex, this.packDesc.getFileName(PackExt.BITMAP_INDEX)));
                e2.initCause(e);
                throw e2;
            }
            catch (IOException e) {
                IOException e2 = new IOException(MessageFormat.format(DfsText.get().cannotReadIndex, this.packDesc.getFileName(PackExt.BITMAP_INDEX)));
                e2.initCause(e);
                throw e2;
            }
            this.bitmapIndex = this.cache.put(this.key, -3L, (int)Math.min((long)var4_5, Integer.MAX_VALUE), idx2);
            return idx2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackReverseIndex getReverseIdx(DfsReader ctx) throws IOException {
        PackReverseIndex revidx;
        DfsBlockCache.Ref<PackReverseIndex> revref = this.reverseIndex;
        if (revref != null && (revidx = revref.get()) != null) {
            return revidx;
        }
        Object object = this.initLock;
        synchronized (object) {
            PackReverseIndex revidx2;
            revref = this.reverseIndex;
            if (revref != null && (revidx2 = revref.get()) != null) {
                return revidx2;
            }
            PackIndex idx = this.idx(ctx);
            PackReverseIndex revidx3 = new PackReverseIndex(idx);
            int sz = (int)Math.min(idx.getObjectCount() * 8L, Integer.MAX_VALUE);
            this.reverseIndex = this.cache.put(this.key, -2L, sz, revidx3);
            return revidx3;
        }
    }

    public boolean hasObject(DfsReader ctx, AnyObjectId id2) throws IOException {
        long offset = this.idx(ctx).findOffset(id2);
        return 0L < offset && !this.isCorrupt(offset);
    }

    ObjectLoader get(DfsReader ctx, AnyObjectId id2) throws IOException {
        long offset = this.idx(ctx).findOffset(id2);
        return 0L < offset && !this.isCorrupt(offset) ? this.load(ctx, offset) : null;
    }

    long findOffset(DfsReader ctx, AnyObjectId id2) throws IOException {
        return this.idx(ctx).findOffset(id2);
    }

    void resolve(DfsReader ctx, Set<ObjectId> matches, AbbreviatedObjectId id2, int matchLimit) throws IOException {
        this.idx(ctx).resolve(matches, id2, matchLimit);
    }

    public void close() {
        this.cache.remove(this);
        this.index = null;
        this.reverseIndex = null;
    }

    long getObjectCount(DfsReader ctx) throws IOException {
        return this.idx(ctx).getObjectCount();
    }

    private byte[] decompress(long position2, int sz, DfsReader ctx) throws IOException, DataFormatException {
        byte[] dstbuf;
        try {
            dstbuf = new byte[sz];
        }
        catch (OutOfMemoryError noMemory) {
            return null;
        }
        if (ctx.inflate(this, position2, dstbuf, false) != sz) {
            throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, position2));
        }
        return dstbuf;
    }

    void copyPackAsIs(PackOutputStream out, boolean validate2, DfsReader ctx) throws IOException {
        ctx.pin(this, 0L);
        ctx.copyPackAsIs(this, this.length, validate2, out);
    }

    void copyAsIs(PackOutputStream out, DfsObjectToPack src, boolean validate2, DfsReader ctx) throws IOException, StoredObjectRepresentationNotAvailableException {
        long cnt;
        long pos;
        long expectedCRC;
        DfsBlock quickCopy;
        CRC32 crc1 = validate2 ? new CRC32() : null;
        CRC32 crc2 = validate2 ? new CRC32() : null;
        byte[] buf = out.getCopyBuffer();
        try {
            this.readFully(src.offset, buf, 0, 20, ctx);
        }
        catch (IOException ioError) {
            StoredObjectRepresentationNotAvailableException gone = new StoredObjectRepresentationNotAvailableException(src);
            gone.initCause(ioError);
            throw gone;
        }
        int c = buf[0] & 0xFF;
        int typeCode = c >> 4 & 7;
        long inflatedLength = c & 0xF;
        int shift = 4;
        int headerCnt = 1;
        while ((c & 0x80) != 0) {
            c = buf[headerCnt++] & 0xFF;
            inflatedLength += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        if (typeCode == 6) {
            while (((c = buf[headerCnt++] & 0xFF) & 0x80) != 0) {
            }
            if (validate2) {
                crc1.update(buf, 0, headerCnt);
                crc2.update(buf, 0, headerCnt);
            }
        } else if (typeCode == 7) {
            if (validate2) {
                crc1.update(buf, 0, headerCnt);
                crc2.update(buf, 0, headerCnt);
            }
            this.readFully(src.offset + (long)headerCnt, buf, 0, 20, ctx);
            if (validate2) {
                crc1.update(buf, 0, 20);
                crc2.update(buf, 0, 20);
            }
            headerCnt += 20;
        } else if (validate2) {
            crc1.update(buf, 0, headerCnt);
            crc2.update(buf, 0, headerCnt);
        }
        long dataOffset = src.offset + (long)headerCnt;
        long dataLength = src.length;
        try {
            quickCopy = ctx.quickCopy(this, dataOffset, dataLength);
            if (validate2 && this.idx(ctx).hasCRC32Support()) {
                expectedCRC = this.idx(ctx).findCRC32(src);
                if (quickCopy != null) {
                    quickCopy.crc32(crc1, dataOffset, (int)dataLength);
                } else {
                    int n;
                    pos = dataOffset;
                    for (cnt = dataLength; cnt > 0L; cnt -= (long)n) {
                        n = (int)Math.min(cnt, (long)buf.length);
                        this.readFully(pos, buf, 0, n, ctx);
                        crc1.update(buf, 0, n);
                        pos += (long)n;
                    }
                }
                if (crc1.getValue() != expectedCRC) {
                    this.setCorrupt(src.offset);
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getPackName()));
                }
            } else if (validate2) {
                Inflater inf = ctx.inflater();
                byte[] tmp = new byte[1024];
                if (quickCopy != null) {
                    quickCopy.check(inf, tmp, dataOffset, (int)dataLength);
                } else {
                    int n;
                    long pos2 = dataOffset;
                    for (long cnt2 = dataLength; cnt2 > 0L; cnt2 -= (long)n) {
                        n = (int)Math.min(cnt2, (long)buf.length);
                        this.readFully(pos2, buf, 0, n, ctx);
                        crc1.update(buf, 0, n);
                        inf.setInput(buf, 0, n);
                        while (inf.inflate(tmp, 0, tmp.length) > 0) {
                        }
                        pos2 += (long)n;
                    }
                }
                if (!inf.finished() || inf.getBytesRead() != dataLength) {
                    this.setCorrupt(src.offset);
                    throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, src.offset));
                }
                expectedCRC = crc1.getValue();
            } else {
                expectedCRC = -1L;
            }
        }
        catch (DataFormatException dataFormat) {
            this.setCorrupt(src.offset);
            CorruptObjectException corruptObject = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getPackName()));
            corruptObject.initCause(dataFormat);
            StoredObjectRepresentationNotAvailableException gone = new StoredObjectRepresentationNotAvailableException(src);
            gone.initCause(corruptObject);
            throw gone;
        }
        catch (IOException ioError) {
            StoredObjectRepresentationNotAvailableException gone = new StoredObjectRepresentationNotAvailableException(src);
            gone.initCause(ioError);
            throw gone;
        }
        if (quickCopy != null) {
            out.writeHeader(src, inflatedLength);
            quickCopy.write(out, dataOffset, (int)dataLength, null);
        } else if (dataLength <= (long)buf.length) {
            if (!validate2) {
                int n;
                pos = dataOffset;
                for (cnt = dataLength; cnt > 0L; cnt -= (long)n) {
                    n = (int)Math.min(cnt, (long)buf.length);
                    this.readFully(pos, buf, 0, n, ctx);
                    pos += (long)n;
                }
            }
            out.writeHeader(src, inflatedLength);
            out.write(buf, 0, (int)dataLength);
        } else {
            int n;
            out.writeHeader(src, inflatedLength);
            pos = dataOffset;
            for (cnt = dataLength; cnt > 0L; cnt -= (long)n) {
                n = (int)Math.min(cnt, (long)buf.length);
                this.readFully(pos, buf, 0, n, ctx);
                if (validate2) {
                    crc2.update(buf, 0, n);
                }
                out.write(buf, 0, n);
                pos += (long)n;
            }
            if (validate2 && crc2.getValue() != expectedCRC) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getPackName()));
            }
        }
    }

    boolean invalid() {
        return this.invalid;
    }

    void setInvalid() {
        this.invalid = true;
    }

    private void readFully(long position2, byte[] dstbuf, int dstoff, int cnt, DfsReader ctx) throws IOException {
        if (ctx.copy(this, position2, dstbuf, dstoff, cnt) != cnt) {
            throw new EOFException();
        }
    }

    long alignToBlock(long pos) {
        int size2 = this.blockSize;
        if (size2 == 0) {
            size2 = this.cache.getBlockSize();
        }
        return pos / (long)size2 * (long)size2;
    }

    DfsBlock getOrLoadBlock(long pos, DfsReader ctx) throws IOException {
        return this.cache.getOrLoad(this, pos, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DfsBlock readOneBlock(long pos, DfsReader ctx) throws IOException {
        DfsBlock dfsBlock;
        if (this.invalid) {
            throw new PackInvalidException(this.getPackName());
        }
        ReadableChannel rc = ctx.db.openFile(this.packDesc, PackExt.PACK);
        try {
            DfsBlock v;
            long len;
            int size2 = this.blockSize;
            if (size2 == 0) {
                size2 = rc.blockSize();
                if (size2 <= 0) {
                    size2 = this.cache.getBlockSize();
                } else if (size2 < this.cache.getBlockSize()) {
                    size2 = this.cache.getBlockSize() / size2 * size2;
                }
                this.blockSize = size2;
                pos = pos / (long)size2 * (long)size2;
            }
            if ((len = this.length) < 0L && 0L <= (len = rc.size())) {
                this.length = len;
            }
            if (0L <= len && len < pos + (long)size2) {
                size2 = (int)(len - pos);
            }
            if (size2 <= 0) {
                throw new EOFException(MessageFormat.format(DfsText.get().shortReadOfBlock, pos, this.getPackName(), 0L, 0L));
            }
            byte[] buf = new byte[size2];
            rc.position(pos);
            int cnt = IO.read(rc, buf, 0, size2);
            if (cnt != size2) {
                if (0L <= len) {
                    throw new EOFException(MessageFormat.format(DfsText.get().shortReadOfBlock, pos, this.getPackName(), size2, cnt));
                }
                byte[] n = new byte[cnt];
                System.arraycopy(buf, 0, n, 0, n.length);
                buf = n;
            } else if (len < 0L) {
                this.length = len = rc.size();
            }
            dfsBlock = v = new DfsBlock(this.key, pos, buf);
            Object var13_10 = null;
        }
        catch (Throwable throwable2) {
            Object var13_11 = null;
            rc.close();
            throw throwable2;
        }
        rc.close();
        return dfsBlock;
    }

    ObjectLoader load(DfsReader ctx, long pos) throws IOException {
        try {
            byte[] ib = ctx.tempId;
            Delta delta = null;
            byte[] data = null;
            int type = -1;
            boolean cached = false;
            block9: while (true) {
                this.readFully(pos, ib, 0, 20, ctx);
                int c = ib[0] & 0xFF;
                int typeCode = c >> 4 & 7;
                long sz = c & 0xF;
                int shift = 4;
                int p = 1;
                while ((c & 0x80) != 0) {
                    c = ib[p++] & 0xFF;
                    sz += (long)(c & 0x7F) << shift;
                    shift += 7;
                }
                switch (typeCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (delta != null) {
                            data = this.decompress(pos + (long)p, (int)sz, ctx);
                            type = typeCode;
                            break block9;
                        }
                        if (sz < (long)ctx.getStreamFileThreshold() && (data = this.decompress(pos + (long)p, (int)sz, ctx)) != null) {
                            return new ObjectLoader.SmallObject(typeCode, data);
                        }
                        return new LargePackedWholeObject(typeCode, sz, pos, p, this, ctx.db);
                    }
                    case 6: {
                        c = ib[p++] & 0xFF;
                        long base = c & 0x7F;
                        while ((c & 0x80) != 0) {
                            ++base;
                            c = ib[p++] & 0xFF;
                            base <<= 7;
                            base += (long)(c & 0x7F);
                        }
                        base = pos - base;
                        delta = new Delta(delta, pos, (int)sz, p, base);
                        if (sz != (long)delta.deltaSize) break block9;
                        DeltaBaseCache.Entry e = ctx.getDeltaBaseCache().get(this.key, base);
                        if (e != null) {
                            type = e.type;
                            data = e.data;
                            cached = true;
                            break block9;
                        }
                        pos = base;
                        continue block9;
                    }
                    case 7: {
                        this.readFully(pos + (long)p, ib, 0, 20, ctx);
                        long base = this.findDeltaBase(ctx, ObjectId.fromRaw(ib));
                        delta = new Delta(delta, pos, (int)sz, p + 20, base);
                        if (sz != (long)delta.deltaSize) break block9;
                        DeltaBaseCache.Entry e = ctx.getDeltaBaseCache().get(this.key, base);
                        if (e != null) {
                            type = e.type;
                            data = e.data;
                            cached = true;
                            break block9;
                        }
                        pos = base;
                        continue block9;
                    }
                    default: {
                        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
                    }
                }
                break;
            }
            if (data == null) {
                throw new LargeObjectException();
            }
            do {
                byte[] result2;
                if (cached) {
                    cached = false;
                } else if (delta.next == null) {
                    ctx.getDeltaBaseCache().put(this.key, delta.basePos, type, data);
                }
                pos = delta.deltaPos;
                byte[] cmds = this.decompress(pos + (long)delta.hdrLen, delta.deltaSize, ctx);
                if (cmds == null) {
                    data = null;
                    throw new LargeObjectException();
                }
                long sz = BinaryDelta.getResultSize(cmds);
                if (Integer.MAX_VALUE <= sz) {
                    throw new LargeObjectException.ExceedsByteArrayLimit();
                }
                try {
                    result2 = new byte[(int)sz];
                }
                catch (OutOfMemoryError tooBig) {
                    data = null;
                    cmds = null;
                    throw new LargeObjectException.OutOfMemory(tooBig);
                }
                BinaryDelta.apply(data, cmds, result2);
                data = result2;
            } while ((delta = delta.next) != null);
            return new ObjectLoader.SmallObject(type, data);
        }
        catch (DataFormatException dfe) {
            CorruptObjectException coe = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, pos, this.getPackName()));
            coe.initCause(dfe);
            throw coe;
        }
    }

    private long findDeltaBase(DfsReader ctx, ObjectId baseId) throws IOException, MissingObjectException {
        long ofs = this.idx(ctx).findOffset(baseId);
        if (ofs < 0L) {
            throw new MissingObjectException(baseId, JGitText.get().missingDeltaBase);
        }
        return ofs;
    }

    byte[] getDeltaHeader(DfsReader wc, long pos) throws IOException, DataFormatException {
        byte[] hdr = new byte[32];
        wc.inflate(this, pos, hdr, true);
        return hdr;
    }

    int getObjectType(DfsReader ctx, long pos) throws IOException {
        int type;
        byte[] ib = ctx.tempId;
        block5: while (true) {
            this.readFully(pos, ib, 0, 20, ctx);
            int c = ib[0] & 0xFF;
            type = c >> 4 & 7;
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return type;
                }
                case 6: {
                    int p = 1;
                    while ((c & 0x80) != 0) {
                        c = ib[p++] & 0xFF;
                    }
                    c = ib[p++] & 0xFF;
                    long ofs = c & 0x7F;
                    while ((c & 0x80) != 0) {
                        ++ofs;
                        c = ib[p++] & 0xFF;
                        ofs <<= 7;
                        ofs += (long)(c & 0x7F);
                    }
                    pos -= ofs;
                    continue block5;
                }
                case 7: {
                    int p = 1;
                    while ((c & 0x80) != 0) {
                        c = ib[p++] & 0xFF;
                    }
                    this.readFully(pos + (long)p, ib, 0, 20, ctx);
                    pos = this.findDeltaBase(ctx, ObjectId.fromRaw(ib));
                    continue block5;
                }
            }
            break;
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, type));
    }

    long getObjectSize(DfsReader ctx, AnyObjectId id2) throws IOException {
        long offset = this.idx(ctx).findOffset(id2);
        return 0L < offset ? this.getObjectSize(ctx, offset) : -1L;
    }

    long getObjectSize(DfsReader ctx, long pos) throws IOException {
        long deltaAt;
        byte[] ib = ctx.tempId;
        this.readFully(pos, ib, 0, 20, ctx);
        int c = ib[0] & 0xFF;
        int type = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        int p = 1;
        while ((c & 0x80) != 0) {
            c = ib[p++] & 0xFF;
            sz += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return sz;
            }
            case 6: {
                c = ib[p++] & 0xFF;
                while ((c & 0x80) != 0) {
                    c = ib[p++] & 0xFF;
                }
                deltaAt = pos + (long)p;
                break;
            }
            case 7: {
                deltaAt = pos + (long)p + 20L;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, type));
            }
        }
        try {
            return BinaryDelta.getResultSize(this.getDeltaHeader(ctx, deltaAt));
        }
        catch (DataFormatException dfe) {
            CorruptObjectException coe = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, pos, this.getPackName()));
            coe.initCause(dfe);
            throw coe;
        }
    }

    void representation(DfsObjectRepresentation r, long pos, DfsReader ctx, PackReverseIndex rev) throws IOException {
        r.offset = pos;
        byte[] ib = ctx.tempId;
        this.readFully(pos, ib, 0, 20, ctx);
        int c = ib[0] & 0xFF;
        int p = 1;
        int typeCode = c >> 4 & 7;
        while ((c & 0x80) != 0) {
            c = ib[p++] & 0xFF;
        }
        long len = rev.findNextOffset(pos, this.length - 20L) - pos;
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                r.format = 1;
                r.baseId = null;
                r.length = len - (long)p;
                return;
            }
            case 6: {
                c = ib[p++] & 0xFF;
                long ofs = c & 0x7F;
                while ((c & 0x80) != 0) {
                    ++ofs;
                    c = ib[p++] & 0xFF;
                    ofs <<= 7;
                    ofs += (long)(c & 0x7F);
                }
                r.format = 0;
                r.baseId = rev.findObject(pos - ofs);
                r.length = len - (long)p;
                return;
            }
            case 7: {
                this.readFully(pos + (long)p, ib, 0, 20, ctx);
                r.format = 0;
                r.baseId = ObjectId.fromRaw(ib);
                r.length = len - (long)p - 20L;
                return;
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCorrupt(long offset) {
        LongList list2 = this.corruptObjects;
        if (list2 == null) {
            return false;
        }
        LongList longList = list2;
        synchronized (longList) {
            return list2.contains(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCorrupt(long offset) {
        Object object;
        LongList list2 = this.corruptObjects;
        if (list2 == null) {
            object = this.initLock;
            synchronized (object) {
                list2 = this.corruptObjects;
                if (list2 == null) {
                    this.corruptObjects = list2 = new LongList();
                }
            }
        }
        object = list2;
        synchronized (object) {
            list2.add(offset);
        }
    }

    private static class Delta {
        final Delta next;
        final long deltaPos;
        final int deltaSize;
        final int hdrLen;
        final long basePos;

        Delta(Delta next2, long ofs, int sz, int hdrLen, long baseOffset) {
            this.next = next2;
            this.deltaPos = ofs;
            this.deltaSize = sz;
            this.hdrLen = hdrLen;
            this.basePos = baseOffset;
        }
    }
}

