/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ConfigLine;
import org.eclipse.jgit.lib.ConfigSnapshot;
import org.eclipse.jgit.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final long KiB = 1024L;
    private static final long MiB = 0x100000L;
    private static final long GiB = 0x40000000L;
    private final ListenerList listeners = new ListenerList();
    private final AtomicReference<ConfigSnapshot> state;
    private final Config baseConfig;
    private static final String MAGIC_EMPTY_VALUE = new String();

    public Config() {
        this(null);
    }

    public Config(Config defaultConfig) {
        this.baseConfig = defaultConfig;
        this.state = new AtomicReference<ConfigSnapshot>(this.newState());
    }

    private static String escapeValue(String x) {
        boolean inquote = false;
        int lineStart = 0;
        StringBuilder r = new StringBuilder(x.length());
        block9: for (int k = 0; k < x.length(); ++k) {
            char c = x.charAt(k);
            switch (c) {
                case '\n': {
                    if (inquote) {
                        r.append('\"');
                        inquote = false;
                    }
                    r.append("\\n\\\n");
                    lineStart = r.length();
                    continue block9;
                }
                case '\t': {
                    r.append("\\t");
                    continue block9;
                }
                case '\b': {
                    r.append("\\b");
                    continue block9;
                }
                case '\\': {
                    r.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    r.append("\\\"");
                    continue block9;
                }
                case '#': 
                case ';': {
                    if (!inquote) {
                        r.insert(lineStart, '\"');
                        inquote = true;
                    }
                    r.append(c);
                    continue block9;
                }
                case ' ': {
                    if (!inquote && r.length() > 0 && r.charAt(r.length() - 1) == ' ') {
                        r.insert(lineStart, '\"');
                        inquote = true;
                    }
                    r.append(' ');
                    continue block9;
                }
                default: {
                    r.append(c);
                }
            }
        }
        if (inquote) {
            r.append('\"');
        }
        return r.toString();
    }

    public int getInt(String section, String name2, int defaultValue2) {
        return this.getInt(section, null, name2, defaultValue2);
    }

    public int getInt(String section, String subsection, String name2, int defaultValue2) {
        long val = this.getLong(section, subsection, name2, defaultValue2);
        if (Integer.MIN_VALUE <= val && val <= Integer.MAX_VALUE) {
            return (int)val;
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().integerValueOutOfRange, section, name2));
    }

    public long getLong(String section, String name2, long defaultValue2) {
        return this.getLong(section, null, name2, defaultValue2);
    }

    public long getLong(String section, String subsection, String name2, long defaultValue2) {
        String str = this.getString(section, subsection, name2);
        if (str == null) {
            return defaultValue2;
        }
        String n = str.trim();
        if (n.length() == 0) {
            return defaultValue2;
        }
        long mul = 1L;
        switch (StringUtils.toLowerCase(n.charAt(n.length() - 1))) {
            case 'g': {
                mul = 0x40000000L;
                break;
            }
            case 'm': {
                mul = 0x100000L;
                break;
            }
            case 'k': {
                mul = 1024L;
            }
        }
        if (mul > 1L) {
            n = n.substring(0, n.length() - 1).trim();
        }
        if (n.length() == 0) {
            return defaultValue2;
        }
        try {
            return mul * Long.parseLong(n);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidIntegerValue, section, name2, str));
        }
    }

    public boolean getBoolean(String section, String name2, boolean defaultValue2) {
        return this.getBoolean(section, null, name2, defaultValue2);
    }

    public boolean getBoolean(String section, String subsection, String name2, boolean defaultValue2) {
        String n = this.getRawString(section, subsection, name2);
        if (n == null) {
            return defaultValue2;
        }
        if (MAGIC_EMPTY_VALUE == n) {
            return true;
        }
        try {
            return StringUtils.toBoolean(n);
        }
        catch (IllegalArgumentException err2) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidBooleanValue, section, name2, n));
        }
    }

    public <T extends Enum<?>> T getEnum(String section, String subsection, String name2, T defaultValue2) {
        Enum[] all = Config.allValuesOf(defaultValue2);
        return (T)this.getEnum(all, section, subsection, name2, defaultValue2);
    }

    private static <T> T[] allValuesOf(T value2) {
        try {
            return (Object[])value2.getClass().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception err2) {
            String typeName = value2.getClass().getName();
            String msg = MessageFormat.format(JGitText.get().enumValuesNotAvailable, typeName);
            throw new IllegalArgumentException(msg, err2);
        }
    }

    public <T extends Enum<?>> T getEnum(T[] all, String section, String subsection, String name2, T defaultValue2) {
        String value2 = this.getString(section, subsection, name2);
        if (value2 == null) {
            return defaultValue2;
        }
        if (all[0] instanceof ConfigEnum) {
            for (T t : all) {
                if (!((ConfigEnum)t).matchConfigValue(value2)) continue;
                return t;
            }
        }
        String n = value2.replace(' ', '_');
        n = n.replace('-', '_');
        T trueState = null;
        T falseState = null;
        for (T e : all) {
            if (StringUtils.equalsIgnoreCase(((Enum)e).name(), n)) {
                return e;
            }
            if (StringUtils.equalsIgnoreCase(((Enum)e).name(), "TRUE")) {
                trueState = e;
                continue;
            }
            if (!StringUtils.equalsIgnoreCase(((Enum)e).name(), "FALSE")) continue;
            falseState = e;
        }
        if (trueState != null && falseState != null) {
            try {
                return StringUtils.toBoolean(n) ? trueState : falseState;
            }
            catch (IllegalArgumentException err2) {
                // empty catch block
            }
        }
        if (subsection != null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported3, section, subsection, name2, value2));
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported2, section, name2, value2));
    }

    public String getString(String section, String subsection, String name2) {
        return this.getRawString(section, subsection, name2);
    }

    public String[] getStringList(String section, String subsection, String name2) {
        String[] base = this.baseConfig != null ? this.baseConfig.getStringList(section, subsection, name2) : EMPTY_STRING_ARRAY;
        String[] self2 = this.getRawStringList(section, subsection, name2);
        if (self2 == null) {
            return base;
        }
        if (base.length == 0) {
            return self2;
        }
        String[] res = new String[base.length + self2.length];
        int n = base.length;
        System.arraycopy(base, 0, res, 0, n);
        System.arraycopy(self2, 0, res, n, self2.length);
        return res;
    }

    public Set<String> getSubsections(String section) {
        return this.getState().getSubsections(section);
    }

    public Set<String> getSections() {
        return this.getState().getSections();
    }

    public Set<String> getNames(String section) {
        return this.getNames(section, null);
    }

    public Set<String> getNames(String section, String subsection) {
        return this.getState().getNames(section, subsection);
    }

    public Set<String> getNames(String section, boolean recursive) {
        return this.getState().getNames(section, null, recursive);
    }

    public Set<String> getNames(String section, String subsection, boolean recursive) {
        return this.getState().getNames(section, subsection, recursive);
    }

    public <T> T get(SectionParser<T> parser) {
        ConfigSnapshot myState = this.getState();
        Object obj2 = myState.cache.get(parser);
        if (obj2 == null) {
            obj2 = parser.parse(this);
            myState.cache.put(parser, obj2);
        }
        return (T)obj2;
    }

    public void uncache(SectionParser<?> parser) {
        this.state.get().cache.remove(parser);
    }

    public ListenerHandle addChangeListener(ConfigChangedListener listener) {
        return this.listeners.addConfigChangedListener(listener);
    }

    protected boolean notifyUponTransientChanges() {
        return true;
    }

    protected void fireConfigChangedEvent() {
        this.listeners.dispatch(new ConfigChangedEvent());
    }

    private String getRawString(String section, String subsection, String name2) {
        String[] lst = this.getRawStringList(section, subsection, name2);
        if (lst != null) {
            return lst[0];
        }
        if (this.baseConfig != null) {
            return this.baseConfig.getRawString(section, subsection, name2);
        }
        return null;
    }

    private String[] getRawStringList(String section, String subsection, String name2) {
        return this.state.get().get(section, subsection, name2);
    }

    private ConfigSnapshot getState() {
        ConfigSnapshot base;
        ConfigSnapshot upd;
        ConfigSnapshot cur;
        do {
            cur = this.state.get();
            base = this.getBaseState();
            if (cur.baseState != base) continue;
            return cur;
        } while (!this.state.compareAndSet(cur, upd = new ConfigSnapshot(cur.entryList, base)));
        return upd;
    }

    private ConfigSnapshot getBaseState() {
        return this.baseConfig != null ? this.baseConfig.getState() : null;
    }

    public void setInt(String section, String subsection, String name2, int value2) {
        this.setLong(section, subsection, name2, value2);
    }

    public void setLong(String section, String subsection, String name2, long value2) {
        String s2 = value2 >= 0x40000000L && value2 % 0x40000000L == 0L ? String.valueOf(value2 / 0x40000000L) + " g" : (value2 >= 0x100000L && value2 % 0x100000L == 0L ? String.valueOf(value2 / 0x100000L) + " m" : (value2 >= 1024L && value2 % 1024L == 0L ? String.valueOf(value2 / 1024L) + " k" : String.valueOf(value2)));
        this.setString(section, subsection, name2, s2);
    }

    public void setBoolean(String section, String subsection, String name2, boolean value2) {
        this.setString(section, subsection, name2, value2 ? "true" : "false");
    }

    public <T extends Enum<?>> void setEnum(String section, String subsection, String name2, T value2) {
        String n = value2 instanceof ConfigEnum ? ((ConfigEnum)((Object)value2)).toConfigValue() : value2.name().toLowerCase().replace('_', ' ');
        this.setString(section, subsection, name2, n);
    }

    public void setString(String section, String subsection, String name2, String value2) {
        this.setStringList(section, subsection, name2, Collections.singletonList(value2));
    }

    public void unset(String section, String subsection, String name2) {
        this.setStringList(section, subsection, name2, Collections.<String>emptyList());
    }

    public void unsetSection(String section, String subsection) {
        ConfigSnapshot res;
        ConfigSnapshot src;
        while (!this.state.compareAndSet(src = this.state.get(), res = this.unsetSection(src, section, subsection))) {
        }
    }

    private ConfigSnapshot unsetSection(ConfigSnapshot srcState, String section, String subsection) {
        int max2 = srcState.entryList.size();
        ArrayList<ConfigLine> r = new ArrayList<ConfigLine>(max2);
        boolean lastWasMatch = false;
        for (ConfigLine e : srcState.entryList) {
            if (e.match(section, subsection)) {
                lastWasMatch = true;
                continue;
            }
            if (lastWasMatch && e.section == null && e.subsection == null) continue;
            r.add(e);
        }
        return this.newState(r);
    }

    public void setStringList(String section, String subsection, String name2, List<String> values2) {
        ConfigSnapshot res;
        ConfigSnapshot src;
        while (!this.state.compareAndSet(src = this.state.get(), res = this.replaceStringList(src, section, subsection, name2, values2))) {
        }
        if (this.notifyUponTransientChanges()) {
            this.fireConfigChangedEvent();
        }
    }

    private ConfigSnapshot replaceStringList(ConfigSnapshot srcState, String section, String subsection, String name2, List<String> values2) {
        ConfigLine e;
        int entryIndex;
        List<ConfigLine> entries = Config.copy(srcState, values2);
        int valueIndex = 0;
        int insertPosition = -1;
        for (entryIndex = 0; entryIndex < entries.size() && valueIndex < values2.size(); ++entryIndex) {
            e = entries.get(entryIndex);
            if (!e.match(section, subsection, name2)) continue;
            entries.set(entryIndex, e.forValue(values2.get(valueIndex++)));
            insertPosition = entryIndex + 1;
        }
        if (valueIndex == values2.size() && entryIndex < entries.size()) {
            while (entryIndex < entries.size()) {
                if (!(e = entries.get(entryIndex++)).match(section, subsection, name2)) continue;
                entries.remove(--entryIndex);
            }
        }
        if (valueIndex < values2.size() && entryIndex == entries.size()) {
            if (insertPosition < 0) {
                insertPosition = Config.findSectionEnd(entries, section, subsection);
            }
            if (insertPosition < 0) {
                e = new ConfigLine();
                e.section = section;
                e.subsection = subsection;
                entries.add(e);
                insertPosition = entries.size();
            }
            while (valueIndex < values2.size()) {
                e = new ConfigLine();
                e.section = section;
                e.subsection = subsection;
                e.name = name2;
                e.value = values2.get(valueIndex++);
                entries.add(insertPosition++, e);
            }
        }
        return this.newState(entries);
    }

    private static List<ConfigLine> copy(ConfigSnapshot src, List<String> values2) {
        int max2 = src.entryList.size() + values2.size() + 1;
        ArrayList<ConfigLine> r = new ArrayList<ConfigLine>(max2);
        r.addAll(src.entryList);
        return r;
    }

    private static int findSectionEnd(List<ConfigLine> entries, String section, String subsection) {
        for (int i = 0; i < entries.size(); ++i) {
            ConfigLine e = entries.get(i);
            if (!e.match(section, subsection, null)) continue;
            ++i;
            while (i < entries.size() && (e = entries.get(i)).match(section, subsection, e.name)) {
                ++i;
            }
            return i;
        }
        return -1;
    }

    public String toText() {
        StringBuilder out = new StringBuilder();
        for (ConfigLine e : this.state.get().entryList) {
            if (e.prefix != null) {
                out.append(e.prefix);
            }
            if (e.section != null && e.name == null) {
                out.append('[');
                out.append(e.section);
                if (e.subsection != null) {
                    boolean quoted2;
                    out.append(' ');
                    String escaped2 = Config.escapeValue(e.subsection);
                    boolean bl = quoted2 = escaped2.startsWith("\"") && escaped2.endsWith("\"");
                    if (!quoted2) {
                        out.append('\"');
                    }
                    out.append(escaped2);
                    if (!quoted2) {
                        out.append('\"');
                    }
                }
                out.append(']');
            } else if (e.section != null && e.name != null) {
                if (e.prefix == null || "".equals(e.prefix)) {
                    out.append('\t');
                }
                out.append(e.name);
                if (MAGIC_EMPTY_VALUE != e.value) {
                    out.append(" =");
                    if (e.value != null) {
                        out.append(' ');
                        out.append(Config.escapeValue(e.value));
                    }
                }
                if (e.suffix != null) {
                    out.append(' ');
                }
            }
            if (e.suffix != null) {
                out.append(e.suffix);
            }
            out.append('\n');
        }
        return out.toString();
    }

    public void fromText(String text2) throws ConfigInvalidException {
        ArrayList<ConfigLine> newEntries;
        block13: {
            newEntries = new ArrayList<ConfigLine>();
            StringReader in = new StringReader(text2);
            ConfigLine last2 = null;
            ConfigLine e = new ConfigLine();
            while (true) {
                int input2;
                if (-1 == (input2 = in.read())) {
                    if (e.section != null) {
                        newEntries.add(e);
                    }
                    break block13;
                }
                char c = (char)input2;
                if ('\n' == c) {
                    newEntries.add(e);
                    if (e.section != null) {
                        last2 = e;
                    }
                    e = new ConfigLine();
                    continue;
                }
                if (e.suffix != null) {
                    e.suffix = e.suffix + c;
                    continue;
                }
                if (';' == c || '#' == c) {
                    e.suffix = String.valueOf(c);
                    continue;
                }
                if (e.section == null && Character.isWhitespace(c)) {
                    if (e.prefix == null) {
                        e.prefix = "";
                    }
                    e.prefix = e.prefix + c;
                    continue;
                }
                if ('[' == c) {
                    e.section = Config.readSectionName(in);
                    input2 = in.read();
                    if (34 == input2) {
                        e.subsection = Config.readValue(in, true, 34);
                        input2 = in.read();
                    }
                    if (93 != input2) {
                        throw new ConfigInvalidException(JGitText.get().badGroupHeader);
                    }
                    e.suffix = "";
                    continue;
                }
                if (last2 == null) break;
                e.section = last2.section;
                e.subsection = last2.subsection;
                in.reset();
                e.name = Config.readKeyName(in);
                if (e.name.endsWith("\n")) {
                    e.name = e.name.substring(0, e.name.length() - 1);
                    e.value = MAGIC_EMPTY_VALUE;
                    continue;
                }
                e.value = Config.readValue(in, false, -1);
            }
            throw new ConfigInvalidException(JGitText.get().invalidLineInConfigFile);
        }
        this.state.set(this.newState(newEntries));
    }

    private ConfigSnapshot newState() {
        return new ConfigSnapshot(Collections.<ConfigLine>emptyList(), this.getBaseState());
    }

    private ConfigSnapshot newState(List<ConfigLine> entries) {
        return new ConfigSnapshot(Collections.unmodifiableList(entries), this.getBaseState());
    }

    protected void clear() {
        this.state.set(this.newState());
    }

    private static String readSectionName(StringReader in) throws ConfigInvalidException {
        StringBuilder name2;
        block6: {
            name2 = new StringBuilder();
            while (true) {
                int c;
                if ((c = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (93 == c) {
                    in.reset();
                    break block6;
                }
                if (32 == c || 9 == c) {
                    do {
                        if ((c = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (34 != c) continue;
                        in.reset();
                        break block6;
                    } while (32 == c || 9 == c);
                    throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name2));
                }
                if (!Character.isLetterOrDigit((char)c) && 46 != c && 45 != c) break;
                name2.append((char)c);
            }
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name2));
        }
        return name2.toString();
    }

    private static String readKeyName(StringReader in) throws ConfigInvalidException {
        StringBuilder name2;
        block7: {
            int c;
            name2 = new StringBuilder();
            while (true) {
                if ((c = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (61 == c) break block7;
                if (32 == c || 9 == c) {
                    do {
                        if ((c = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (61 == c) break block7;
                        if (59 != c && 35 != c && 10 != c) continue;
                        in.reset();
                        break block7;
                    } while (32 == c || 9 == c);
                    throw new ConfigInvalidException(JGitText.get().badEntryDelimiter);
                }
                if (!Character.isLetterOrDigit((char)c) && c != 45) break;
                name2.append((char)c);
            }
            if (10 == c) {
                in.reset();
                name2.append((char)c);
            } else {
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEntryName, name2));
            }
        }
        return name2.toString();
    }

    private static String readValue(StringReader in, boolean quote, int eol) throws ConfigInvalidException {
        StringBuilder value2 = new StringBuilder();
        boolean space = false;
        block9: while (true) {
            int c;
            if ((c = in.read()) < 0) {
                if (value2.length() != 0) break;
                throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
            }
            if (10 == c) {
                if (quote) {
                    throw new ConfigInvalidException(JGitText.get().newlineInQuotesNotAllowed);
                }
                in.reset();
                break;
            }
            if (eol == c) break;
            if (!quote) {
                if (Character.isWhitespace((char)c)) {
                    space = true;
                    continue;
                }
                if (59 == c || 35 == c) {
                    in.reset();
                    break;
                }
            }
            if (space) {
                if (value2.length() > 0) {
                    value2.append(' ');
                }
                space = false;
            }
            if (92 == c) {
                c = in.read();
                switch (c) {
                    case -1: {
                        throw new ConfigInvalidException(JGitText.get().endOfFileInEscape);
                    }
                    case 10: {
                        continue block9;
                    }
                    case 116: {
                        value2.append('\t');
                        continue block9;
                    }
                    case 98: {
                        value2.append('\b');
                        continue block9;
                    }
                    case 110: {
                        value2.append('\n');
                        continue block9;
                    }
                    case 92: {
                        value2.append('\\');
                        continue block9;
                    }
                    case 34: {
                        value2.append('\"');
                        continue block9;
                    }
                }
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEscape, Character.valueOf((char)c)));
            }
            if (34 == c) {
                quote = !quote;
                continue;
            }
            value2.append((char)c);
        }
        return value2.length() > 0 ? value2.toString() : null;
    }

    public static interface ConfigEnum {
        public String toConfigValue();

        public boolean matchConfigValue(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SectionParser<T> {
        public T parse(Config var1);
    }

    private static class StringReader {
        private final char[] buf;
        private int pos;

        StringReader(String in) {
            this.buf = in.toCharArray();
        }

        int read() {
            try {
                return this.buf[this.pos++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.pos = this.buf.length;
                return -1;
            }
        }

        void reset() {
            --this.pos;
        }
    }
}

