/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.RemoteRepositoryException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BaseConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

abstract class BasePackConnection
extends BaseConnection {
    protected final Repository local;
    protected final URIish uri;
    protected final Transport transport;
    protected TimeoutInputStream timeoutIn;
    protected TimeoutOutputStream timeoutOut;
    private InterruptTimer myTimer;
    protected InputStream in;
    protected OutputStream out;
    protected PacketLineIn pckIn;
    protected PacketLineOut pckOut;
    protected boolean outNeedsEnd;
    protected boolean statelessRPC;
    private final Set<String> remoteCapablities = new HashSet<String>();
    protected final Set<ObjectId> additionalHaves = new HashSet<ObjectId>();

    BasePackConnection(PackTransport packTransport) {
        this.transport = (Transport)((Object)packTransport);
        this.local = this.transport.local;
        this.uri = this.transport.uri;
    }

    protected final void init(InputStream myIn, OutputStream myOut) {
        int timeout = this.transport.getTimeout();
        if (timeout > 0) {
            Thread caller = Thread.currentThread();
            this.myTimer = new InterruptTimer(caller.getName() + "-Timer");
            this.timeoutIn = new TimeoutInputStream(myIn, this.myTimer);
            this.timeoutOut = new TimeoutOutputStream(myOut, this.myTimer);
            this.timeoutIn.setTimeout(timeout * 1000);
            this.timeoutOut.setTimeout(timeout * 1000);
            myIn = this.timeoutIn;
            myOut = this.timeoutOut;
        }
        this.in = myIn;
        this.out = myOut;
        this.pckIn = new PacketLineIn(this.in);
        this.pckOut = new PacketLineOut(this.out);
        this.outNeedsEnd = true;
    }

    protected void readAdvertisedRefs() throws TransportException {
        try {
            this.readAdvertisedRefsImpl();
        }
        catch (TransportException err2) {
            this.close();
            throw err2;
        }
        catch (IOException err3) {
            this.close();
            throw new TransportException(err3.getMessage(), err3);
        }
        catch (RuntimeException err4) {
            this.close();
            throw new TransportException(err4.getMessage(), err4);
        }
    }

    private void readAdvertisedRefsImpl() throws IOException {
        LinkedHashMap<String, Ref> avail;
        block11: {
            String name2;
            avail = new LinkedHashMap<String, Ref>();
            while (true) {
                int nul;
                String line;
                try {
                    line = this.pckIn.readString();
                }
                catch (EOFException eof) {
                    if (avail.isEmpty()) {
                        throw this.noRepository();
                    }
                    throw eof;
                }
                if (line == PacketLineIn.END) break block11;
                if (line.startsWith("ERR ")) {
                    throw new RemoteRepositoryException(this.uri, line.substring(4));
                }
                if (avail.isEmpty() && (nul = line.indexOf(0)) >= 0) {
                    for (String c : line.substring(nul + 1).split(" ")) {
                        this.remoteCapablities.add(c);
                    }
                    line = line.substring(0, nul);
                }
                name2 = line.substring(41, line.length());
                if (avail.isEmpty() && name2.equals("capabilities^{}")) continue;
                ObjectId id2 = ObjectId.fromString(line.substring(0, 40));
                if (name2.equals(".have")) {
                    this.additionalHaves.add(id2);
                    continue;
                }
                if (name2.endsWith("^{}")) {
                    Ref prior = avail.get(name2 = name2.substring(0, name2.length() - 3));
                    if (prior == null) {
                        throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().advertisementCameBefore, name2, name2));
                    }
                    if (prior.getPeeledObjectId() != null) {
                        throw this.duplicateAdvertisement(name2 + "^{}");
                    }
                    avail.put(name2, new ObjectIdRef.PeeledTag(Ref.Storage.NETWORK, name2, prior.getObjectId(), id2));
                    continue;
                }
                Ref prior = avail.put(name2, new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, name2, id2));
                if (prior != null) break;
            }
            throw this.duplicateAdvertisement(name2);
        }
        this.available(avail);
    }

    protected TransportException noRepository() {
        return new NoRemoteRepositoryException(this.uri, JGitText.get().notFound);
    }

    protected boolean isCapableOf(String option2) {
        return this.remoteCapablities.contains(option2);
    }

    protected boolean wantCapability(StringBuilder b, String option2) {
        if (!this.isCapableOf(option2)) {
            return false;
        }
        b.append(' ');
        b.append(option2);
        return true;
    }

    private PackProtocolException duplicateAdvertisement(String name2) {
        return new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.out != null) {
            try {
                try {
                    if (this.outNeedsEnd) {
                        this.outNeedsEnd = false;
                        this.pckOut.end();
                    }
                    this.out.close();
                }
                catch (IOException err2) {
                    Object var3_2 = null;
                    this.out = null;
                    this.pckOut = null;
                }
                Object var3_1 = null;
                this.out = null;
                this.pckOut = null;
            }
            catch (Throwable throwable2) {
                Object var3_3 = null;
                this.out = null;
                this.pckOut = null;
                throw throwable2;
            }
        }
        if (this.in != null) {
            try {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    Object var5_8 = null;
                    this.in = null;
                    this.pckIn = null;
                }
                Object var5_7 = null;
                this.in = null;
                this.pckIn = null;
            }
            catch (Throwable throwable3) {
                Object var5_9 = null;
                this.in = null;
                this.pckIn = null;
                throw throwable3;
            }
        }
        if (this.myTimer != null) {
            try {
                this.myTimer.terminate();
                Object var7_11 = null;
                this.myTimer = null;
                this.timeoutIn = null;
                this.timeoutOut = null;
            }
            catch (Throwable throwable4) {
                Object var7_12 = null;
                this.myTimer = null;
                this.timeoutIn = null;
                this.timeoutOut = null;
                throw throwable4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endOut() {
        if (this.outNeedsEnd && this.out != null) {
            try {
                this.outNeedsEnd = false;
                this.pckOut.end();
            }
            catch (IOException e) {
                try {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {
                        Object var4_3 = null;
                        this.out = null;
                        this.pckOut = null;
                    }
                    Object var4_2 = null;
                    this.out = null;
                    this.pckOut = null;
                }
                catch (Throwable throwable2) {
                    Object var4_4 = null;
                    this.out = null;
                    this.pckOut = null;
                    throw throwable2;
                }
            }
        }
    }
}

