/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

public class RawCharUtil {
    private static final boolean[] WHITESPACE = new boolean[256];

    public static boolean isWhitespace(byte c) {
        return WHITESPACE[c & 0xFF];
    }

    public static int trimTrailingWhitespace(byte[] raw2, int start, int end2) {
        int ptr;
        for (ptr = end2 - 1; start <= ptr && RawCharUtil.isWhitespace(raw2[ptr]); --ptr) {
        }
        return ptr + 1;
    }

    public static int trimLeadingWhitespace(byte[] raw2, int start, int end2) {
        while (start < end2 && RawCharUtil.isWhitespace(raw2[start])) {
            ++start;
        }
        return start;
    }

    private RawCharUtil() {
    }

    static {
        RawCharUtil.WHITESPACE[13] = true;
        RawCharUtil.WHITESPACE[10] = true;
        RawCharUtil.WHITESPACE[9] = true;
        RawCharUtil.WHITESPACE[32] = true;
    }
}

