// Karma configuration file, see link for more information
// https://karma-runner.github.io/1.0/config/configuration-file.html

var process = require('process');
process.env.CHROME_BIN = require('puppeteer').executablePath();

module.exports = function (config) {
  config.set({
    basePath: '',
    files: [
      {pattern: 'test-resources/inspected/*', watched: true, served: true, included: false},
      {pattern: 'test-resources/fieldActions/*', watched: true, served: true, included: false}
    ],
    frameworks: ['jasmine-jquery', 'jasmine', '@angular-devkit/build-angular'],
    plugins: [
      require('karma-jasmine'),
      require('karma-jasmine-jquery'),
      require('karma-chrome-launcher'),
      require('karma-jasmine-html-reporter'),
      require('karma-coverage-istanbul-reporter'),
      require('karma-junit-reporter'),
      require('@angular-devkit/build-angular/plugins/karma'),
    ],
    client: {
      clearContext: false // leave Jasmine Spec Runner output visible in browser
    },
    coverageIstanbulReporter: {
      dir: require('path').join(__dirname, 'coverage'), reports: ['html', 'lcovonly'],
      fixWebpackSourcePaths: true
    },
    angularCli: {
      environment: 'dev'
    },
    reporters: ['progress', 'kjhtml', 'junit'],
    junitReporter: {
      outputDir: './junit',
      suite: '',
      useBrowserName: true,
    },
    port: 9876,
    colors: true,
    logLevel: config.LOG_INFO,
    autoWatch: true,
    browsers: ['ChromeHeadlessCustom','ChromeDebug'],
    customLaunchers: {
      'ChromeHeadlessCustom': {
        base: 'ChromeHeadless',
        flags: [
          '--no-sandbox',
          '--disable-setuid-sandbox',
        ],
      },
      'ChromeDebug': {
        base: 'Chrome',
        flags: ['--remote-debugging-port=9333'],
      },
     },
    singleRun: false
  });
};
