/*
    Copyright (C) 2017 Red Hat, Inc.

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

            http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { HttpClientModule } from '@angular/common/http';
import { RouterModule } from '@angular/router';

import { AppComponent } from './app.component';
import { AtlasmapNavbarComponent } from './atlasmap-navbar.component';

import { DataMapperModule } from './lib/atlasmap-data-mapper/data-mapper.module';

@NgModule({
  declarations: [
    AppComponent,
    AtlasmapNavbarComponent
  ],
  imports: [
    BrowserModule,
    FormsModule,
    HttpClientModule,
    RouterModule.forRoot([]),
    DataMapperModule.withInterceptor(),
  ],
  providers: [],
  bootstrap: [
    AppComponent,
    AtlasmapNavbarComponent,
  ],
})

export class ExampleAppModule { }
