// This file was automatically generated by informer-gen

package internalversion

import (
	apps "github.com/openshift/origin/pkg/deploy/apis/apps"
	internalinterfaces "github.com/openshift/origin/pkg/deploy/generated/informers/internalversion/internalinterfaces"
	internalclientset "github.com/openshift/origin/pkg/deploy/generated/internalclientset"
	internalversion "github.com/openshift/origin/pkg/deploy/generated/listers/apps/internalversion"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	time "time"
)

// DeploymentConfigInformer provides access to a shared informer and lister for
// DeploymentConfigs.
type DeploymentConfigInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() internalversion.DeploymentConfigLister
}

type deploymentConfigInformer struct {
	factory internalinterfaces.SharedInformerFactory
}

func newDeploymentConfigInformer(client internalclientset.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	sharedIndexInformer := cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				return client.Apps().DeploymentConfigs(v1.NamespaceAll).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				return client.Apps().DeploymentConfigs(v1.NamespaceAll).Watch(options)
			},
		},
		&apps.DeploymentConfig{},
		resyncPeriod,
		cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc},
	)

	return sharedIndexInformer
}

func (f *deploymentConfigInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&apps.DeploymentConfig{}, newDeploymentConfigInformer)
}

func (f *deploymentConfigInformer) Lister() internalversion.DeploymentConfigLister {
	return internalversion.NewDeploymentConfigLister(f.Informer().GetIndexer())
}
