// +build !ignore_autogenerated_openshift

// This file was autogenerated by conversion-gen. Do not edit it manually!

package v1

import (
	image "github.com/openshift/origin/pkg/image/apis/image"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	api "k8s.io/kubernetes/pkg/api"
	api_v1 "k8s.io/kubernetes/pkg/api/v1"
	unsafe "unsafe"
)

func init() {
	SchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1_DockerImageReference_To_image_DockerImageReference,
		Convert_image_DockerImageReference_To_v1_DockerImageReference,
		Convert_v1_Image_To_image_Image,
		Convert_image_Image_To_v1_Image,
		Convert_v1_ImageImportSpec_To_image_ImageImportSpec,
		Convert_image_ImageImportSpec_To_v1_ImageImportSpec,
		Convert_v1_ImageImportStatus_To_image_ImageImportStatus,
		Convert_image_ImageImportStatus_To_v1_ImageImportStatus,
		Convert_v1_ImageLayer_To_image_ImageLayer,
		Convert_image_ImageLayer_To_v1_ImageLayer,
		Convert_v1_ImageList_To_image_ImageList,
		Convert_image_ImageList_To_v1_ImageList,
		Convert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy,
		Convert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy,
		Convert_v1_ImageSignature_To_image_ImageSignature,
		Convert_image_ImageSignature_To_v1_ImageSignature,
		Convert_v1_ImageStream_To_image_ImageStream,
		Convert_image_ImageStream_To_v1_ImageStream,
		Convert_v1_ImageStreamImage_To_image_ImageStreamImage,
		Convert_image_ImageStreamImage_To_v1_ImageStreamImage,
		Convert_v1_ImageStreamImport_To_image_ImageStreamImport,
		Convert_image_ImageStreamImport_To_v1_ImageStreamImport,
		Convert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec,
		Convert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec,
		Convert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus,
		Convert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus,
		Convert_v1_ImageStreamList_To_image_ImageStreamList,
		Convert_image_ImageStreamList_To_v1_ImageStreamList,
		Convert_v1_ImageStreamMapping_To_image_ImageStreamMapping,
		Convert_image_ImageStreamMapping_To_v1_ImageStreamMapping,
		Convert_v1_ImageStreamSpec_To_image_ImageStreamSpec,
		Convert_image_ImageStreamSpec_To_v1_ImageStreamSpec,
		Convert_v1_ImageStreamStatus_To_image_ImageStreamStatus,
		Convert_image_ImageStreamStatus_To_v1_ImageStreamStatus,
		Convert_v1_ImageStreamTag_To_image_ImageStreamTag,
		Convert_image_ImageStreamTag_To_v1_ImageStreamTag,
		Convert_v1_ImageStreamTagList_To_image_ImageStreamTagList,
		Convert_image_ImageStreamTagList_To_v1_ImageStreamTagList,
		Convert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec,
		Convert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec,
		Convert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus,
		Convert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus,
		Convert_v1_SignatureCondition_To_image_SignatureCondition,
		Convert_image_SignatureCondition_To_v1_SignatureCondition,
		Convert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity,
		Convert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity,
		Convert_v1_SignatureIssuer_To_image_SignatureIssuer,
		Convert_image_SignatureIssuer_To_v1_SignatureIssuer,
		Convert_v1_SignatureSubject_To_image_SignatureSubject,
		Convert_image_SignatureSubject_To_v1_SignatureSubject,
		Convert_v1_TagEvent_To_image_TagEvent,
		Convert_image_TagEvent_To_v1_TagEvent,
		Convert_v1_TagEventCondition_To_image_TagEventCondition,
		Convert_image_TagEventCondition_To_v1_TagEventCondition,
		Convert_v1_TagImportPolicy_To_image_TagImportPolicy,
		Convert_image_TagImportPolicy_To_v1_TagImportPolicy,
		Convert_v1_TagReference_To_image_TagReference,
		Convert_image_TagReference_To_v1_TagReference,
		Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy,
		Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy,
	)
}

func autoConvert_v1_DockerImageReference_To_image_DockerImageReference(in *DockerImageReference, out *image.DockerImageReference, s conversion.Scope) error {
	out.Registry = in.Registry
	out.Namespace = in.Namespace
	out.Name = in.Name
	out.Tag = in.Tag
	out.ID = in.ID
	return nil
}

// Convert_v1_DockerImageReference_To_image_DockerImageReference is an autogenerated conversion function.
func Convert_v1_DockerImageReference_To_image_DockerImageReference(in *DockerImageReference, out *image.DockerImageReference, s conversion.Scope) error {
	return autoConvert_v1_DockerImageReference_To_image_DockerImageReference(in, out, s)
}

func autoConvert_image_DockerImageReference_To_v1_DockerImageReference(in *image.DockerImageReference, out *DockerImageReference, s conversion.Scope) error {
	out.Registry = in.Registry
	out.Namespace = in.Namespace
	out.Name = in.Name
	out.Tag = in.Tag
	out.ID = in.ID
	return nil
}

// Convert_image_DockerImageReference_To_v1_DockerImageReference is an autogenerated conversion function.
func Convert_image_DockerImageReference_To_v1_DockerImageReference(in *image.DockerImageReference, out *DockerImageReference, s conversion.Scope) error {
	return autoConvert_image_DockerImageReference_To_v1_DockerImageReference(in, out, s)
}

func autoConvert_v1_Image_To_image_Image(in *Image, out *image.Image, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.DockerImageReference = in.DockerImageReference
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.DockerImageMetadata, &out.DockerImageMetadata, 0); err != nil {
		return err
	}
	out.DockerImageMetadataVersion = in.DockerImageMetadataVersion
	out.DockerImageManifest = in.DockerImageManifest
	out.DockerImageLayers = *(*[]image.ImageLayer)(unsafe.Pointer(&in.DockerImageLayers))
	out.Signatures = *(*[]image.ImageSignature)(unsafe.Pointer(&in.Signatures))
	out.DockerImageSignatures = *(*[][]byte)(unsafe.Pointer(&in.DockerImageSignatures))
	out.DockerImageManifestMediaType = in.DockerImageManifestMediaType
	out.DockerImageConfig = in.DockerImageConfig
	return nil
}

func autoConvert_image_Image_To_v1_Image(in *image.Image, out *Image, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.DockerImageReference = in.DockerImageReference
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.DockerImageMetadata, &out.DockerImageMetadata, 0); err != nil {
		return err
	}
	out.DockerImageMetadataVersion = in.DockerImageMetadataVersion
	out.DockerImageManifest = in.DockerImageManifest
	if in.DockerImageLayers == nil {
		out.DockerImageLayers = make([]ImageLayer, 0)
	} else {
		out.DockerImageLayers = *(*[]ImageLayer)(unsafe.Pointer(&in.DockerImageLayers))
	}
	out.Signatures = *(*[]ImageSignature)(unsafe.Pointer(&in.Signatures))
	out.DockerImageSignatures = *(*[][]byte)(unsafe.Pointer(&in.DockerImageSignatures))
	out.DockerImageManifestMediaType = in.DockerImageManifestMediaType
	out.DockerImageConfig = in.DockerImageConfig
	return nil
}

func autoConvert_v1_ImageImportSpec_To_image_ImageImportSpec(in *ImageImportSpec, out *image.ImageImportSpec, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if err := Convert_v1_TagImportPolicy_To_image_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

// Convert_v1_ImageImportSpec_To_image_ImageImportSpec is an autogenerated conversion function.
func Convert_v1_ImageImportSpec_To_image_ImageImportSpec(in *ImageImportSpec, out *image.ImageImportSpec, s conversion.Scope) error {
	return autoConvert_v1_ImageImportSpec_To_image_ImageImportSpec(in, out, s)
}

func autoConvert_image_ImageImportSpec_To_v1_ImageImportSpec(in *image.ImageImportSpec, out *ImageImportSpec, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if err := Convert_image_TagImportPolicy_To_v1_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

// Convert_image_ImageImportSpec_To_v1_ImageImportSpec is an autogenerated conversion function.
func Convert_image_ImageImportSpec_To_v1_ImageImportSpec(in *image.ImageImportSpec, out *ImageImportSpec, s conversion.Scope) error {
	return autoConvert_image_ImageImportSpec_To_v1_ImageImportSpec(in, out, s)
}

func autoConvert_v1_ImageImportStatus_To_image_ImageImportStatus(in *ImageImportStatus, out *image.ImageImportStatus, s conversion.Scope) error {
	out.Status = in.Status
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(image.Image)
		if err := Convert_v1_Image_To_image_Image(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Image = nil
	}
	out.Tag = in.Tag
	return nil
}

// Convert_v1_ImageImportStatus_To_image_ImageImportStatus is an autogenerated conversion function.
func Convert_v1_ImageImportStatus_To_image_ImageImportStatus(in *ImageImportStatus, out *image.ImageImportStatus, s conversion.Scope) error {
	return autoConvert_v1_ImageImportStatus_To_image_ImageImportStatus(in, out, s)
}

func autoConvert_image_ImageImportStatus_To_v1_ImageImportStatus(in *image.ImageImportStatus, out *ImageImportStatus, s conversion.Scope) error {
	out.Tag = in.Tag
	out.Status = in.Status
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(Image)
		if err := Convert_image_Image_To_v1_Image(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Image = nil
	}
	return nil
}

// Convert_image_ImageImportStatus_To_v1_ImageImportStatus is an autogenerated conversion function.
func Convert_image_ImageImportStatus_To_v1_ImageImportStatus(in *image.ImageImportStatus, out *ImageImportStatus, s conversion.Scope) error {
	return autoConvert_image_ImageImportStatus_To_v1_ImageImportStatus(in, out, s)
}

func autoConvert_v1_ImageLayer_To_image_ImageLayer(in *ImageLayer, out *image.ImageLayer, s conversion.Scope) error {
	out.Name = in.Name
	out.LayerSize = in.LayerSize
	out.MediaType = in.MediaType
	return nil
}

// Convert_v1_ImageLayer_To_image_ImageLayer is an autogenerated conversion function.
func Convert_v1_ImageLayer_To_image_ImageLayer(in *ImageLayer, out *image.ImageLayer, s conversion.Scope) error {
	return autoConvert_v1_ImageLayer_To_image_ImageLayer(in, out, s)
}

func autoConvert_image_ImageLayer_To_v1_ImageLayer(in *image.ImageLayer, out *ImageLayer, s conversion.Scope) error {
	out.Name = in.Name
	out.LayerSize = in.LayerSize
	out.MediaType = in.MediaType
	return nil
}

// Convert_image_ImageLayer_To_v1_ImageLayer is an autogenerated conversion function.
func Convert_image_ImageLayer_To_v1_ImageLayer(in *image.ImageLayer, out *ImageLayer, s conversion.Scope) error {
	return autoConvert_image_ImageLayer_To_v1_ImageLayer(in, out, s)
}

func autoConvert_v1_ImageList_To_image_ImageList(in *ImageList, out *image.ImageList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]image.Image, len(*in))
		for i := range *in {
			if err := Convert_v1_Image_To_image_Image(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ImageList_To_image_ImageList is an autogenerated conversion function.
func Convert_v1_ImageList_To_image_ImageList(in *ImageList, out *image.ImageList, s conversion.Scope) error {
	return autoConvert_v1_ImageList_To_image_ImageList(in, out, s)
}

func autoConvert_image_ImageList_To_v1_ImageList(in *image.ImageList, out *ImageList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Image, len(*in))
		for i := range *in {
			if err := Convert_image_Image_To_v1_Image(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]Image, 0)
	}
	return nil
}

// Convert_image_ImageList_To_v1_ImageList is an autogenerated conversion function.
func Convert_image_ImageList_To_v1_ImageList(in *image.ImageList, out *ImageList, s conversion.Scope) error {
	return autoConvert_image_ImageList_To_v1_ImageList(in, out, s)
}

func autoConvert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy(in *ImageLookupPolicy, out *image.ImageLookupPolicy, s conversion.Scope) error {
	out.Local = in.Local
	return nil
}

// Convert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy is an autogenerated conversion function.
func Convert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy(in *ImageLookupPolicy, out *image.ImageLookupPolicy, s conversion.Scope) error {
	return autoConvert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy(in, out, s)
}

func autoConvert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy(in *image.ImageLookupPolicy, out *ImageLookupPolicy, s conversion.Scope) error {
	out.Local = in.Local
	return nil
}

// Convert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy is an autogenerated conversion function.
func Convert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy(in *image.ImageLookupPolicy, out *ImageLookupPolicy, s conversion.Scope) error {
	return autoConvert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy(in, out, s)
}

func autoConvert_v1_ImageSignature_To_image_ImageSignature(in *ImageSignature, out *image.ImageSignature, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Type = in.Type
	out.Content = *(*[]byte)(unsafe.Pointer(&in.Content))
	out.Conditions = *(*[]image.SignatureCondition)(unsafe.Pointer(&in.Conditions))
	out.ImageIdentity = in.ImageIdentity
	out.SignedClaims = *(*map[string]string)(unsafe.Pointer(&in.SignedClaims))
	out.Created = (*meta_v1.Time)(unsafe.Pointer(in.Created))
	out.IssuedBy = (*image.SignatureIssuer)(unsafe.Pointer(in.IssuedBy))
	out.IssuedTo = (*image.SignatureSubject)(unsafe.Pointer(in.IssuedTo))
	return nil
}

// Convert_v1_ImageSignature_To_image_ImageSignature is an autogenerated conversion function.
func Convert_v1_ImageSignature_To_image_ImageSignature(in *ImageSignature, out *image.ImageSignature, s conversion.Scope) error {
	return autoConvert_v1_ImageSignature_To_image_ImageSignature(in, out, s)
}

func autoConvert_image_ImageSignature_To_v1_ImageSignature(in *image.ImageSignature, out *ImageSignature, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Type = in.Type
	if in.Content == nil {
		out.Content = make([]byte, 0)
	} else {
		out.Content = *(*[]byte)(unsafe.Pointer(&in.Content))
	}
	out.Conditions = *(*[]SignatureCondition)(unsafe.Pointer(&in.Conditions))
	out.ImageIdentity = in.ImageIdentity
	out.SignedClaims = *(*map[string]string)(unsafe.Pointer(&in.SignedClaims))
	out.Created = (*meta_v1.Time)(unsafe.Pointer(in.Created))
	out.IssuedBy = (*SignatureIssuer)(unsafe.Pointer(in.IssuedBy))
	out.IssuedTo = (*SignatureSubject)(unsafe.Pointer(in.IssuedTo))
	return nil
}

// Convert_image_ImageSignature_To_v1_ImageSignature is an autogenerated conversion function.
func Convert_image_ImageSignature_To_v1_ImageSignature(in *image.ImageSignature, out *ImageSignature, s conversion.Scope) error {
	return autoConvert_image_ImageSignature_To_v1_ImageSignature(in, out, s)
}

func autoConvert_v1_ImageStream_To_image_ImageStream(in *ImageStream, out *image.ImageStream, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ImageStreamSpec_To_image_ImageStreamSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ImageStreamStatus_To_image_ImageStreamStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ImageStream_To_image_ImageStream is an autogenerated conversion function.
func Convert_v1_ImageStream_To_image_ImageStream(in *ImageStream, out *image.ImageStream, s conversion.Scope) error {
	return autoConvert_v1_ImageStream_To_image_ImageStream(in, out, s)
}

func autoConvert_image_ImageStream_To_v1_ImageStream(in *image.ImageStream, out *ImageStream, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_image_ImageStreamSpec_To_v1_ImageStreamSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_image_ImageStreamStatus_To_v1_ImageStreamStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_ImageStream_To_v1_ImageStream is an autogenerated conversion function.
func Convert_image_ImageStream_To_v1_ImageStream(in *image.ImageStream, out *ImageStream, s conversion.Scope) error {
	return autoConvert_image_ImageStream_To_v1_ImageStream(in, out, s)
}

func autoConvert_v1_ImageStreamImage_To_image_ImageStreamImage(in *ImageStreamImage, out *image.ImageStreamImage, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_Image_To_image_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ImageStreamImage_To_image_ImageStreamImage is an autogenerated conversion function.
func Convert_v1_ImageStreamImage_To_image_ImageStreamImage(in *ImageStreamImage, out *image.ImageStreamImage, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImage_To_image_ImageStreamImage(in, out, s)
}

func autoConvert_image_ImageStreamImage_To_v1_ImageStreamImage(in *image.ImageStreamImage, out *ImageStreamImage, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_image_Image_To_v1_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_ImageStreamImage_To_v1_ImageStreamImage is an autogenerated conversion function.
func Convert_image_ImageStreamImage_To_v1_ImageStreamImage(in *image.ImageStreamImage, out *ImageStreamImage, s conversion.Scope) error {
	return autoConvert_image_ImageStreamImage_To_v1_ImageStreamImage(in, out, s)
}

func autoConvert_v1_ImageStreamImport_To_image_ImageStreamImport(in *ImageStreamImport, out *image.ImageStreamImport, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ImageStreamImport_To_image_ImageStreamImport is an autogenerated conversion function.
func Convert_v1_ImageStreamImport_To_image_ImageStreamImport(in *ImageStreamImport, out *image.ImageStreamImport, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImport_To_image_ImageStreamImport(in, out, s)
}

func autoConvert_image_ImageStreamImport_To_v1_ImageStreamImport(in *image.ImageStreamImport, out *ImageStreamImport, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_ImageStreamImport_To_v1_ImageStreamImport is an autogenerated conversion function.
func Convert_image_ImageStreamImport_To_v1_ImageStreamImport(in *image.ImageStreamImport, out *ImageStreamImport, s conversion.Scope) error {
	return autoConvert_image_ImageStreamImport_To_v1_ImageStreamImport(in, out, s)
}

func autoConvert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec(in *ImageStreamImportSpec, out *image.ImageStreamImportSpec, s conversion.Scope) error {
	out.Import = in.Import
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(image.RepositoryImportSpec)
		if err := Convert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]image.ImageImportSpec, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageImportSpec_To_image_ImageImportSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

// Convert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec is an autogenerated conversion function.
func Convert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec(in *ImageStreamImportSpec, out *image.ImageStreamImportSpec, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImportSpec_To_image_ImageStreamImportSpec(in, out, s)
}

func autoConvert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(in *image.ImageStreamImportSpec, out *ImageStreamImportSpec, s conversion.Scope) error {
	out.Import = in.Import
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(RepositoryImportSpec)
		if err := Convert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]ImageImportSpec, len(*in))
		for i := range *in {
			if err := Convert_image_ImageImportSpec_To_v1_ImageImportSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

// Convert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec is an autogenerated conversion function.
func Convert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(in *image.ImageStreamImportSpec, out *ImageStreamImportSpec, s conversion.Scope) error {
	return autoConvert_image_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(in, out, s)
}

func autoConvert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus(in *ImageStreamImportStatus, out *image.ImageStreamImportStatus, s conversion.Scope) error {
	if in.Import != nil {
		in, out := &in.Import, &out.Import
		*out = new(image.ImageStream)
		if err := Convert_v1_ImageStream_To_image_ImageStream(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Import = nil
	}
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(image.RepositoryImportStatus)
		if err := Convert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]image.ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageImportStatus_To_image_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

// Convert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus is an autogenerated conversion function.
func Convert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus(in *ImageStreamImportStatus, out *image.ImageStreamImportStatus, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImportStatus_To_image_ImageStreamImportStatus(in, out, s)
}

func autoConvert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(in *image.ImageStreamImportStatus, out *ImageStreamImportStatus, s conversion.Scope) error {
	if in.Import != nil {
		in, out := &in.Import, &out.Import
		*out = new(ImageStream)
		if err := Convert_image_ImageStream_To_v1_ImageStream(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Import = nil
	}
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(RepositoryImportStatus)
		if err := Convert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_image_ImageImportStatus_To_v1_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

// Convert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus is an autogenerated conversion function.
func Convert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(in *image.ImageStreamImportStatus, out *ImageStreamImportStatus, s conversion.Scope) error {
	return autoConvert_image_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(in, out, s)
}

func autoConvert_v1_ImageStreamList_To_image_ImageStreamList(in *ImageStreamList, out *image.ImageStreamList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]image.ImageStream, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageStream_To_image_ImageStream(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ImageStreamList_To_image_ImageStreamList is an autogenerated conversion function.
func Convert_v1_ImageStreamList_To_image_ImageStreamList(in *ImageStreamList, out *image.ImageStreamList, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamList_To_image_ImageStreamList(in, out, s)
}

func autoConvert_image_ImageStreamList_To_v1_ImageStreamList(in *image.ImageStreamList, out *ImageStreamList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ImageStream, len(*in))
		for i := range *in {
			if err := Convert_image_ImageStream_To_v1_ImageStream(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]ImageStream, 0)
	}
	return nil
}

// Convert_image_ImageStreamList_To_v1_ImageStreamList is an autogenerated conversion function.
func Convert_image_ImageStreamList_To_v1_ImageStreamList(in *image.ImageStreamList, out *ImageStreamList, s conversion.Scope) error {
	return autoConvert_image_ImageStreamList_To_v1_ImageStreamList(in, out, s)
}

func autoConvert_v1_ImageStreamMapping_To_image_ImageStreamMapping(in *ImageStreamMapping, out *image.ImageStreamMapping, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_Image_To_image_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	out.Tag = in.Tag
	return nil
}

func autoConvert_image_ImageStreamMapping_To_v1_ImageStreamMapping(in *image.ImageStreamMapping, out *ImageStreamMapping, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	// INFO: in.DockerImageRepository opted out of conversion generation
	if err := Convert_image_Image_To_v1_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	out.Tag = in.Tag
	return nil
}

func autoConvert_v1_ImageStreamSpec_To_image_ImageStreamSpec(in *ImageStreamSpec, out *image.ImageStreamSpec, s conversion.Scope) error {
	if err := Convert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy(&in.LookupPolicy, &out.LookupPolicy, s); err != nil {
		return err
	}
	out.DockerImageRepository = in.DockerImageRepository
	// WARNING: in.Tags requires manual conversion: inconvertible types ([]github.com/openshift/origin/pkg/image/apis/image/v1.TagReference vs map[string]github.com/openshift/origin/pkg/image/apis/image.TagReference)
	return nil
}

func autoConvert_image_ImageStreamSpec_To_v1_ImageStreamSpec(in *image.ImageStreamSpec, out *ImageStreamSpec, s conversion.Scope) error {
	if err := Convert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy(&in.LookupPolicy, &out.LookupPolicy, s); err != nil {
		return err
	}
	out.DockerImageRepository = in.DockerImageRepository
	// WARNING: in.Tags requires manual conversion: inconvertible types (map[string]github.com/openshift/origin/pkg/image/apis/image.TagReference vs []github.com/openshift/origin/pkg/image/apis/image/v1.TagReference)
	return nil
}

func autoConvert_v1_ImageStreamStatus_To_image_ImageStreamStatus(in *ImageStreamStatus, out *image.ImageStreamStatus, s conversion.Scope) error {
	out.DockerImageRepository = in.DockerImageRepository
	out.PublicDockerImageRepository = in.PublicDockerImageRepository
	// WARNING: in.Tags requires manual conversion: inconvertible types ([]github.com/openshift/origin/pkg/image/apis/image/v1.NamedTagEventList vs map[string]github.com/openshift/origin/pkg/image/apis/image.TagEventList)
	return nil
}

func autoConvert_image_ImageStreamStatus_To_v1_ImageStreamStatus(in *image.ImageStreamStatus, out *ImageStreamStatus, s conversion.Scope) error {
	out.DockerImageRepository = in.DockerImageRepository
	out.PublicDockerImageRepository = in.PublicDockerImageRepository
	// WARNING: in.Tags requires manual conversion: inconvertible types (map[string]github.com/openshift/origin/pkg/image/apis/image.TagEventList vs []github.com/openshift/origin/pkg/image/apis/image/v1.NamedTagEventList)
	return nil
}

func autoConvert_v1_ImageStreamTag_To_image_ImageStreamTag(in *ImageStreamTag, out *image.ImageStreamTag, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Tag != nil {
		in, out := &in.Tag, &out.Tag
		*out = new(image.TagReference)
		if err := Convert_v1_TagReference_To_image_TagReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Tag = nil
	}
	out.Generation = in.Generation
	if err := Convert_v1_ImageLookupPolicy_To_image_ImageLookupPolicy(&in.LookupPolicy, &out.LookupPolicy, s); err != nil {
		return err
	}
	out.Conditions = *(*[]image.TagEventCondition)(unsafe.Pointer(&in.Conditions))
	if err := Convert_v1_Image_To_image_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ImageStreamTag_To_image_ImageStreamTag is an autogenerated conversion function.
func Convert_v1_ImageStreamTag_To_image_ImageStreamTag(in *ImageStreamTag, out *image.ImageStreamTag, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamTag_To_image_ImageStreamTag(in, out, s)
}

func autoConvert_image_ImageStreamTag_To_v1_ImageStreamTag(in *image.ImageStreamTag, out *ImageStreamTag, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Tag != nil {
		in, out := &in.Tag, &out.Tag
		*out = new(TagReference)
		if err := Convert_image_TagReference_To_v1_TagReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Tag = nil
	}
	out.Generation = in.Generation
	out.Conditions = *(*[]TagEventCondition)(unsafe.Pointer(&in.Conditions))
	if err := Convert_image_ImageLookupPolicy_To_v1_ImageLookupPolicy(&in.LookupPolicy, &out.LookupPolicy, s); err != nil {
		return err
	}
	if err := Convert_image_Image_To_v1_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_ImageStreamTag_To_v1_ImageStreamTag is an autogenerated conversion function.
func Convert_image_ImageStreamTag_To_v1_ImageStreamTag(in *image.ImageStreamTag, out *ImageStreamTag, s conversion.Scope) error {
	return autoConvert_image_ImageStreamTag_To_v1_ImageStreamTag(in, out, s)
}

func autoConvert_v1_ImageStreamTagList_To_image_ImageStreamTagList(in *ImageStreamTagList, out *image.ImageStreamTagList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]image.ImageStreamTag, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageStreamTag_To_image_ImageStreamTag(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ImageStreamTagList_To_image_ImageStreamTagList is an autogenerated conversion function.
func Convert_v1_ImageStreamTagList_To_image_ImageStreamTagList(in *ImageStreamTagList, out *image.ImageStreamTagList, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamTagList_To_image_ImageStreamTagList(in, out, s)
}

func autoConvert_image_ImageStreamTagList_To_v1_ImageStreamTagList(in *image.ImageStreamTagList, out *ImageStreamTagList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ImageStreamTag, len(*in))
		for i := range *in {
			if err := Convert_image_ImageStreamTag_To_v1_ImageStreamTag(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]ImageStreamTag, 0)
	}
	return nil
}

// Convert_image_ImageStreamTagList_To_v1_ImageStreamTagList is an autogenerated conversion function.
func Convert_image_ImageStreamTagList_To_v1_ImageStreamTagList(in *image.ImageStreamTagList, out *ImageStreamTagList, s conversion.Scope) error {
	return autoConvert_image_ImageStreamTagList_To_v1_ImageStreamTagList(in, out, s)
}

func autoConvert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec(in *RepositoryImportSpec, out *image.RepositoryImportSpec, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if err := Convert_v1_TagImportPolicy_To_image_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

// Convert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec is an autogenerated conversion function.
func Convert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec(in *RepositoryImportSpec, out *image.RepositoryImportSpec, s conversion.Scope) error {
	return autoConvert_v1_RepositoryImportSpec_To_image_RepositoryImportSpec(in, out, s)
}

func autoConvert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec(in *image.RepositoryImportSpec, out *RepositoryImportSpec, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if err := Convert_image_TagImportPolicy_To_v1_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

// Convert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec is an autogenerated conversion function.
func Convert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec(in *image.RepositoryImportSpec, out *RepositoryImportSpec, s conversion.Scope) error {
	return autoConvert_image_RepositoryImportSpec_To_v1_RepositoryImportSpec(in, out, s)
}

func autoConvert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus(in *RepositoryImportStatus, out *image.RepositoryImportStatus, s conversion.Scope) error {
	out.Status = in.Status
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]image.ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageImportStatus_To_image_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.AdditionalTags = *(*[]string)(unsafe.Pointer(&in.AdditionalTags))
	return nil
}

// Convert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus is an autogenerated conversion function.
func Convert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus(in *RepositoryImportStatus, out *image.RepositoryImportStatus, s conversion.Scope) error {
	return autoConvert_v1_RepositoryImportStatus_To_image_RepositoryImportStatus(in, out, s)
}

func autoConvert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus(in *image.RepositoryImportStatus, out *RepositoryImportStatus, s conversion.Scope) error {
	out.Status = in.Status
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_image_ImageImportStatus_To_v1_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.AdditionalTags = *(*[]string)(unsafe.Pointer(&in.AdditionalTags))
	return nil
}

// Convert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus is an autogenerated conversion function.
func Convert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus(in *image.RepositoryImportStatus, out *RepositoryImportStatus, s conversion.Scope) error {
	return autoConvert_image_RepositoryImportStatus_To_v1_RepositoryImportStatus(in, out, s)
}

func autoConvert_v1_SignatureCondition_To_image_SignatureCondition(in *SignatureCondition, out *image.SignatureCondition, s conversion.Scope) error {
	out.Type = image.SignatureConditionType(in.Type)
	out.Status = api.ConditionStatus(in.Status)
	out.LastProbeTime = in.LastProbeTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_SignatureCondition_To_image_SignatureCondition is an autogenerated conversion function.
func Convert_v1_SignatureCondition_To_image_SignatureCondition(in *SignatureCondition, out *image.SignatureCondition, s conversion.Scope) error {
	return autoConvert_v1_SignatureCondition_To_image_SignatureCondition(in, out, s)
}

func autoConvert_image_SignatureCondition_To_v1_SignatureCondition(in *image.SignatureCondition, out *SignatureCondition, s conversion.Scope) error {
	out.Type = SignatureConditionType(in.Type)
	out.Status = api_v1.ConditionStatus(in.Status)
	out.LastProbeTime = in.LastProbeTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_image_SignatureCondition_To_v1_SignatureCondition is an autogenerated conversion function.
func Convert_image_SignatureCondition_To_v1_SignatureCondition(in *image.SignatureCondition, out *SignatureCondition, s conversion.Scope) error {
	return autoConvert_image_SignatureCondition_To_v1_SignatureCondition(in, out, s)
}

func autoConvert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity(in *SignatureGenericEntity, out *image.SignatureGenericEntity, s conversion.Scope) error {
	out.Organization = in.Organization
	out.CommonName = in.CommonName
	return nil
}

// Convert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity is an autogenerated conversion function.
func Convert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity(in *SignatureGenericEntity, out *image.SignatureGenericEntity, s conversion.Scope) error {
	return autoConvert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity(in, out, s)
}

func autoConvert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity(in *image.SignatureGenericEntity, out *SignatureGenericEntity, s conversion.Scope) error {
	out.Organization = in.Organization
	out.CommonName = in.CommonName
	return nil
}

// Convert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity is an autogenerated conversion function.
func Convert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity(in *image.SignatureGenericEntity, out *SignatureGenericEntity, s conversion.Scope) error {
	return autoConvert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity(in, out, s)
}

func autoConvert_v1_SignatureIssuer_To_image_SignatureIssuer(in *SignatureIssuer, out *image.SignatureIssuer, s conversion.Scope) error {
	if err := Convert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_SignatureIssuer_To_image_SignatureIssuer is an autogenerated conversion function.
func Convert_v1_SignatureIssuer_To_image_SignatureIssuer(in *SignatureIssuer, out *image.SignatureIssuer, s conversion.Scope) error {
	return autoConvert_v1_SignatureIssuer_To_image_SignatureIssuer(in, out, s)
}

func autoConvert_image_SignatureIssuer_To_v1_SignatureIssuer(in *image.SignatureIssuer, out *SignatureIssuer, s conversion.Scope) error {
	if err := Convert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_SignatureIssuer_To_v1_SignatureIssuer is an autogenerated conversion function.
func Convert_image_SignatureIssuer_To_v1_SignatureIssuer(in *image.SignatureIssuer, out *SignatureIssuer, s conversion.Scope) error {
	return autoConvert_image_SignatureIssuer_To_v1_SignatureIssuer(in, out, s)
}

func autoConvert_v1_SignatureSubject_To_image_SignatureSubject(in *SignatureSubject, out *image.SignatureSubject, s conversion.Scope) error {
	if err := Convert_v1_SignatureGenericEntity_To_image_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	out.PublicKeyID = in.PublicKeyID
	return nil
}

// Convert_v1_SignatureSubject_To_image_SignatureSubject is an autogenerated conversion function.
func Convert_v1_SignatureSubject_To_image_SignatureSubject(in *SignatureSubject, out *image.SignatureSubject, s conversion.Scope) error {
	return autoConvert_v1_SignatureSubject_To_image_SignatureSubject(in, out, s)
}

func autoConvert_image_SignatureSubject_To_v1_SignatureSubject(in *image.SignatureSubject, out *SignatureSubject, s conversion.Scope) error {
	if err := Convert_image_SignatureGenericEntity_To_v1_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	out.PublicKeyID = in.PublicKeyID
	return nil
}

// Convert_image_SignatureSubject_To_v1_SignatureSubject is an autogenerated conversion function.
func Convert_image_SignatureSubject_To_v1_SignatureSubject(in *image.SignatureSubject, out *SignatureSubject, s conversion.Scope) error {
	return autoConvert_image_SignatureSubject_To_v1_SignatureSubject(in, out, s)
}

func autoConvert_v1_TagEvent_To_image_TagEvent(in *TagEvent, out *image.TagEvent, s conversion.Scope) error {
	out.Created = in.Created
	out.DockerImageReference = in.DockerImageReference
	out.Image = in.Image
	out.Generation = in.Generation
	return nil
}

// Convert_v1_TagEvent_To_image_TagEvent is an autogenerated conversion function.
func Convert_v1_TagEvent_To_image_TagEvent(in *TagEvent, out *image.TagEvent, s conversion.Scope) error {
	return autoConvert_v1_TagEvent_To_image_TagEvent(in, out, s)
}

func autoConvert_image_TagEvent_To_v1_TagEvent(in *image.TagEvent, out *TagEvent, s conversion.Scope) error {
	out.Created = in.Created
	out.DockerImageReference = in.DockerImageReference
	out.Image = in.Image
	out.Generation = in.Generation
	return nil
}

// Convert_image_TagEvent_To_v1_TagEvent is an autogenerated conversion function.
func Convert_image_TagEvent_To_v1_TagEvent(in *image.TagEvent, out *TagEvent, s conversion.Scope) error {
	return autoConvert_image_TagEvent_To_v1_TagEvent(in, out, s)
}

func autoConvert_v1_TagEventCondition_To_image_TagEventCondition(in *TagEventCondition, out *image.TagEventCondition, s conversion.Scope) error {
	out.Type = image.TagEventConditionType(in.Type)
	out.Status = api.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	out.Generation = in.Generation
	return nil
}

// Convert_v1_TagEventCondition_To_image_TagEventCondition is an autogenerated conversion function.
func Convert_v1_TagEventCondition_To_image_TagEventCondition(in *TagEventCondition, out *image.TagEventCondition, s conversion.Scope) error {
	return autoConvert_v1_TagEventCondition_To_image_TagEventCondition(in, out, s)
}

func autoConvert_image_TagEventCondition_To_v1_TagEventCondition(in *image.TagEventCondition, out *TagEventCondition, s conversion.Scope) error {
	out.Type = TagEventConditionType(in.Type)
	out.Status = api_v1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	out.Generation = in.Generation
	return nil
}

// Convert_image_TagEventCondition_To_v1_TagEventCondition is an autogenerated conversion function.
func Convert_image_TagEventCondition_To_v1_TagEventCondition(in *image.TagEventCondition, out *TagEventCondition, s conversion.Scope) error {
	return autoConvert_image_TagEventCondition_To_v1_TagEventCondition(in, out, s)
}

func autoConvert_v1_TagImportPolicy_To_image_TagImportPolicy(in *TagImportPolicy, out *image.TagImportPolicy, s conversion.Scope) error {
	out.Insecure = in.Insecure
	out.Scheduled = in.Scheduled
	return nil
}

// Convert_v1_TagImportPolicy_To_image_TagImportPolicy is an autogenerated conversion function.
func Convert_v1_TagImportPolicy_To_image_TagImportPolicy(in *TagImportPolicy, out *image.TagImportPolicy, s conversion.Scope) error {
	return autoConvert_v1_TagImportPolicy_To_image_TagImportPolicy(in, out, s)
}

func autoConvert_image_TagImportPolicy_To_v1_TagImportPolicy(in *image.TagImportPolicy, out *TagImportPolicy, s conversion.Scope) error {
	out.Insecure = in.Insecure
	out.Scheduled = in.Scheduled
	return nil
}

// Convert_image_TagImportPolicy_To_v1_TagImportPolicy is an autogenerated conversion function.
func Convert_image_TagImportPolicy_To_v1_TagImportPolicy(in *image.TagImportPolicy, out *TagImportPolicy, s conversion.Scope) error {
	return autoConvert_image_TagImportPolicy_To_v1_TagImportPolicy(in, out, s)
}

func autoConvert_v1_TagReference_To_image_TagReference(in *TagReference, out *image.TagReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Reference = in.Reference
	out.Generation = (*int64)(unsafe.Pointer(in.Generation))
	if err := Convert_v1_TagImportPolicy_To_image_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_TagReference_To_image_TagReference is an autogenerated conversion function.
func Convert_v1_TagReference_To_image_TagReference(in *TagReference, out *image.TagReference, s conversion.Scope) error {
	return autoConvert_v1_TagReference_To_image_TagReference(in, out, s)
}

func autoConvert_image_TagReference_To_v1_TagReference(in *image.TagReference, out *TagReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Reference = in.Reference
	out.Generation = (*int64)(unsafe.Pointer(in.Generation))
	if err := Convert_image_TagImportPolicy_To_v1_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	if err := Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy(&in.ReferencePolicy, &out.ReferencePolicy, s); err != nil {
		return err
	}
	return nil
}

// Convert_image_TagReference_To_v1_TagReference is an autogenerated conversion function.
func Convert_image_TagReference_To_v1_TagReference(in *image.TagReference, out *TagReference, s conversion.Scope) error {
	return autoConvert_image_TagReference_To_v1_TagReference(in, out, s)
}

func autoConvert_v1_TagReferencePolicy_To_image_TagReferencePolicy(in *TagReferencePolicy, out *image.TagReferencePolicy, s conversion.Scope) error {
	out.Type = image.TagReferencePolicyType(in.Type)
	return nil
}

// Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy is an autogenerated conversion function.
func Convert_v1_TagReferencePolicy_To_image_TagReferencePolicy(in *TagReferencePolicy, out *image.TagReferencePolicy, s conversion.Scope) error {
	return autoConvert_v1_TagReferencePolicy_To_image_TagReferencePolicy(in, out, s)
}

func autoConvert_image_TagReferencePolicy_To_v1_TagReferencePolicy(in *image.TagReferencePolicy, out *TagReferencePolicy, s conversion.Scope) error {
	out.Type = TagReferencePolicyType(in.Type)
	return nil
}

// Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy is an autogenerated conversion function.
func Convert_image_TagReferencePolicy_To_v1_TagReferencePolicy(in *image.TagReferencePolicy, out *TagReferencePolicy, s conversion.Scope) error {
	return autoConvert_image_TagReferencePolicy_To_v1_TagReferencePolicy(in, out, s)
}
