// This file was automatically generated by informer-gen

package v1

import (
	image_v1 "github.com/openshift/origin/pkg/image/apis/image/v1"
	clientset "github.com/openshift/origin/pkg/image/generated/clientset"
	internalinterfaces "github.com/openshift/origin/pkg/image/generated/informers/externalversions/internalinterfaces"
	v1 "github.com/openshift/origin/pkg/image/generated/listers/image/v1"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	time "time"
)

// ImageStreamInformer provides access to a shared informer and lister for
// ImageStreams.
type ImageStreamInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1.ImageStreamLister
}

type imageStreamInformer struct {
	factory internalinterfaces.SharedInformerFactory
}

func newImageStreamInformer(client clientset.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	sharedIndexInformer := cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options meta_v1.ListOptions) (runtime.Object, error) {
				return client.ImageV1().ImageStreams(meta_v1.NamespaceAll).List(options)
			},
			WatchFunc: func(options meta_v1.ListOptions) (watch.Interface, error) {
				return client.ImageV1().ImageStreams(meta_v1.NamespaceAll).Watch(options)
			},
		},
		&image_v1.ImageStream{},
		resyncPeriod,
		cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc},
	)

	return sharedIndexInformer
}

func (f *imageStreamInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&image_v1.ImageStream{}, newImageStreamInformer)
}

func (f *imageStreamInformer) Lister() v1.ImageStreamLister {
	return v1.NewImageStreamLister(f.Informer().GetIndexer())
}
