// This file was automatically generated by lister-gen

package v1

import (
	v1 "github.com/openshift/origin/pkg/oauth/apis/oauth/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// OAuthAuthorizeTokenLister helps list OAuthAuthorizeTokens.
type OAuthAuthorizeTokenLister interface {
	// List lists all OAuthAuthorizeTokens in the indexer.
	List(selector labels.Selector) (ret []*v1.OAuthAuthorizeToken, err error)
	// Get retrieves the OAuthAuthorizeToken from the index for a given name.
	Get(name string) (*v1.OAuthAuthorizeToken, error)
	OAuthAuthorizeTokenListerExpansion
}

// oAuthAuthorizeTokenLister implements the OAuthAuthorizeTokenLister interface.
type oAuthAuthorizeTokenLister struct {
	indexer cache.Indexer
}

// NewOAuthAuthorizeTokenLister returns a new OAuthAuthorizeTokenLister.
func NewOAuthAuthorizeTokenLister(indexer cache.Indexer) OAuthAuthorizeTokenLister {
	return &oAuthAuthorizeTokenLister{indexer: indexer}
}

// List lists all OAuthAuthorizeTokens in the indexer.
func (s *oAuthAuthorizeTokenLister) List(selector labels.Selector) (ret []*v1.OAuthAuthorizeToken, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.OAuthAuthorizeToken))
	})
	return ret, err
}

// Get retrieves the OAuthAuthorizeToken from the index for a given name.
func (s *oAuthAuthorizeTokenLister) Get(name string) (*v1.OAuthAuthorizeToken, error) {
	key := &v1.OAuthAuthorizeToken{ObjectMeta: meta_v1.ObjectMeta{Name: name}}
	obj, exists, err := s.indexer.Get(key)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("oauthauthorizetoken"), name)
	}
	return obj.(*v1.OAuthAuthorizeToken), nil
}
