// +build !ignore_autogenerated_openshift

// This file was autogenerated by openapi-gen. Do not edit it manually!

package openapi

import (
	spec "github.com/go-openapi/spec"
	resource "k8s.io/apimachinery/pkg/api/resource"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	openapi "k8s.io/apimachinery/pkg/openapi"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
)

func GetOpenAPIDefinitions(ref openapi.ReferenceCallback) map[string]openapi.OpenAPIDefinition {
	return map[string]openapi.OpenAPIDefinition{
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.Action": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Action describes a request to the API server",
					Properties: map[string]spec.Schema{
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"verb": {
							SchemaProps: spec.SchemaProps{
								Description: "Verb is one of: get, list, watch, create, update, delete",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceAPIGroup": {
							SchemaProps: spec.SchemaProps{
								Description: "Group is the API group of the resource Serialized as resourceAPIGroup to avoid confusion with the 'groups' field when inlined",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceAPIVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "Version is the API version of the resource Serialized as resourceAPIVersion to avoid confusion with TypeMeta.apiVersion and ObjectMeta.resourceVersion when inlined",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resource": {
							SchemaProps: spec.SchemaProps{
								Description: "Resource is one of the existing resource types",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceName": {
							SchemaProps: spec.SchemaProps{
								Description: "ResourceName is the name of the resource being requested for a \"get\" or deleted for a \"delete\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path is the path of a non resource URL",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"isNonResourceURL": {
							SchemaProps: spec.SchemaProps{
								Description: "IsNonResourceURL is true if this is a request for a non-resource URL (outside of the resource hieraarchy)",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"content": {
							SchemaProps: spec.SchemaProps{
								Description: "Content is the actual content of the request for create and update",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
					},
					Required: []string{"namespace", "verb", "resourceAPIGroup", "resourceAPIVersion", "resource", "resourceName", "path", "isNonResourceURL"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterPolicy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterPolicy is a object that holds all the ClusterRoles for a particular namespace.  There is at most one ClusterPolicy document per namespace.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"lastModified": {
							SchemaProps: spec.SchemaProps{
								Description: "LastModified is the last time that any part of the ClusterPolicy was created, updated, or deleted",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"roles": {
							SchemaProps: spec.SchemaProps{
								Description: "Roles holds all the ClusterRoles held by this ClusterPolicy, mapped by ClusterRole.Name",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedClusterRole"),
										},
									},
								},
							},
						},
					},
					Required: []string{"lastModified", "roles"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedClusterRole", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterPolicyBinding": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterPolicyBinding is a object that holds all the ClusterRoleBindings for a particular namespace.  There is one ClusterPolicyBinding document per referenced ClusterPolicy namespace",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"lastModified": {
							SchemaProps: spec.SchemaProps{
								Description: "LastModified is the last time that any part of the ClusterPolicyBinding was created, updated, or deleted",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"policyRef": {
							SchemaProps: spec.SchemaProps{
								Description: "PolicyRef is a reference to the ClusterPolicy that contains all the ClusterRoles that this ClusterPolicyBinding's RoleBindings may reference",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"roleBindings": {
							SchemaProps: spec.SchemaProps{
								Description: "RoleBindings holds all the ClusterRoleBindings held by this ClusterPolicyBinding, mapped by ClusterRoleBinding.Name",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedClusterRoleBinding"),
										},
									},
								},
							},
						},
					},
					Required: []string{"lastModified", "policyRef", "roleBindings"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedClusterRoleBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.Time", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterPolicyBindingList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterPolicyBindingList is a collection of ClusterPolicyBindings",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of ClusterPolicyBindings",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterPolicyBinding"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterPolicyBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterPolicyList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterPolicyList is a collection of ClusterPolicies",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of ClusterPolicies",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterPolicy"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterPolicy", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRole": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterRole is a logical grouping of PolicyRules that can be referenced as a unit by ClusterRoleBindings.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"rules": {
							SchemaProps: spec.SchemaProps{
								Description: "Rules holds all the PolicyRules for this ClusterRole",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyRule"),
										},
									},
								},
							},
						},
					},
					Required: []string{"rules"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyRule", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRoleBinding": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterRoleBinding references a ClusterRole, but not contain it.  It can reference any ClusterRole in the same namespace or in the global namespace. It adds who information via (Users and Groups) OR Subjects and namespace information by which namespace it exists in. ClusterRoleBindings in a given namespace only have effect in that namespace (excepting the master namespace which has power in all namespaces).",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"userNames": {
							SchemaProps: spec.SchemaProps{
								Description: "UserNames holds all the usernames directly bound to the role. This field should only be specified when supporting legacy clients and servers. See Subjects for further details.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"groupNames": {
							SchemaProps: spec.SchemaProps{
								Description: "GroupNames holds all the groups directly bound to the role. This field should only be specified when supporting legacy clients and servers. See Subjects for further details.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"subjects": {
							SchemaProps: spec.SchemaProps{
								Description: "Subjects hold object references to authorize with this rule. This field is ignored if UserNames or GroupNames are specified to support legacy clients and servers. Thus newer clients that do not need to support backwards compatibility should send only fully qualified Subjects and should omit the UserNames and GroupNames fields. Clients that need to support backwards compatibility can use this field to build the UserNames and GroupNames.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
										},
									},
								},
							},
						},
						"roleRef": {
							SchemaProps: spec.SchemaProps{
								Description: "RoleRef can only reference the current namespace and the global namespace. If the ClusterRoleRef cannot be resolved, the Authorizer must return an error. Since Policy is a singleton, this is sufficient knowledge to locate a role.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
					Required: []string{"userNames", "groupNames", "subjects", "roleRef"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRoleBindingList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterRoleBindingList is a collection of ClusterRoleBindings",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of ClusterRoleBindings",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRoleBinding"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRoleBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRoleList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterRoleList is a collection of ClusterRoles",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of ClusterRoles",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRole"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRole", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.GroupRestriction": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupRestriction matches a group either by a string match on the group name or a label selector applied to group labels.",
					Properties: map[string]spec.Schema{
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "Groups is a list of groups used to match against an individual user's groups. If the user is a member of one of the whitelisted groups, the user is allowed to be bound to a role.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"labels": {
							SchemaProps: spec.SchemaProps{
								Description: "Selectors specifies a list of label selectors over group labels.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
										},
									},
								},
							},
						},
					},
					Required: []string{"groups", "labels"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.IsPersonalSubjectAccessReview": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "IsPersonalSubjectAccessReview is a marker for PolicyRule.AttributeRestrictions that denotes that subjectaccessreviews on self should be allowed",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.LocalResourceAccessReview": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "LocalResourceAccessReview is a means to request a list of which users and groups are authorized to perform the action specified by spec in a particular namespace",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"verb": {
							SchemaProps: spec.SchemaProps{
								Description: "Verb is one of: get, list, watch, create, update, delete",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceAPIGroup": {
							SchemaProps: spec.SchemaProps{
								Description: "Group is the API group of the resource Serialized as resourceAPIGroup to avoid confusion with the 'groups' field when inlined",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceAPIVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "Version is the API version of the resource Serialized as resourceAPIVersion to avoid confusion with TypeMeta.apiVersion and ObjectMeta.resourceVersion when inlined",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resource": {
							SchemaProps: spec.SchemaProps{
								Description: "Resource is one of the existing resource types",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceName": {
							SchemaProps: spec.SchemaProps{
								Description: "ResourceName is the name of the resource being requested for a \"get\" or deleted for a \"delete\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path is the path of a non resource URL",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"isNonResourceURL": {
							SchemaProps: spec.SchemaProps{
								Description: "IsNonResourceURL is true if this is a request for a non-resource URL (outside of the resource hieraarchy)",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"content": {
							SchemaProps: spec.SchemaProps{
								Description: "Content is the actual content of the request for create and update",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
					},
					Required: []string{"namespace", "verb", "resourceAPIGroup", "resourceAPIVersion", "resource", "resourceName", "path", "isNonResourceURL"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.LocalSubjectAccessReview": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "LocalSubjectAccessReview is an object for requesting information about whether a user or group can perform an action in a particular namespace",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"verb": {
							SchemaProps: spec.SchemaProps{
								Description: "Verb is one of: get, list, watch, create, update, delete",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceAPIGroup": {
							SchemaProps: spec.SchemaProps{
								Description: "Group is the API group of the resource Serialized as resourceAPIGroup to avoid confusion with the 'groups' field when inlined",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceAPIVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "Version is the API version of the resource Serialized as resourceAPIVersion to avoid confusion with TypeMeta.apiVersion and ObjectMeta.resourceVersion when inlined",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resource": {
							SchemaProps: spec.SchemaProps{
								Description: "Resource is one of the existing resource types",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceName": {
							SchemaProps: spec.SchemaProps{
								Description: "ResourceName is the name of the resource being requested for a \"get\" or deleted for a \"delete\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path is the path of a non resource URL",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"isNonResourceURL": {
							SchemaProps: spec.SchemaProps{
								Description: "IsNonResourceURL is true if this is a request for a non-resource URL (outside of the resource hieraarchy)",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"content": {
							SchemaProps: spec.SchemaProps{
								Description: "Content is the actual content of the request for create and update",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "User is optional.  If both User and Groups are empty, the current authenticated user is used.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "Groups is optional.  Groups is the list of groups to which the User belongs.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"scopes": {
							SchemaProps: spec.SchemaProps{
								Description: "Scopes to use for the evaluation.  Empty means \"use the unscoped (full) permissions of the user/groups\". Nil for a self-SAR, means \"use the scopes on this request\". Nil for a regular SAR, means the same as empty.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"namespace", "verb", "resourceAPIGroup", "resourceAPIVersion", "resource", "resourceName", "path", "isNonResourceURL", "user", "groups", "scopes"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedClusterRole": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NamedClusterRole relates a name with a cluster role",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name is the name of the cluster role",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"role": {
							SchemaProps: spec.SchemaProps{
								Description: "Role is the cluster role being named",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRole"),
							},
						},
					},
					Required: []string{"name", "role"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRole"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedClusterRoleBinding": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NamedClusterRoleBinding relates a name with a cluster role binding",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name is the name of the cluster role binding",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"roleBinding": {
							SchemaProps: spec.SchemaProps{
								Description: "RoleBinding is the cluster role binding being named",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRoleBinding"),
							},
						},
					},
					Required: []string{"name", "roleBinding"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ClusterRoleBinding"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedRole": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NamedRole relates a Role with a name",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name is the name of the role",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"role": {
							SchemaProps: spec.SchemaProps{
								Description: "Role is the role being named",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.Role"),
							},
						},
					},
					Required: []string{"name", "role"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.Role"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedRoleBinding": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NamedRoleBinding relates a role binding with a name",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name is the name of the role binding",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"roleBinding": {
							SchemaProps: spec.SchemaProps{
								Description: "RoleBinding is the role binding being named",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBinding"),
							},
						},
					},
					Required: []string{"name", "roleBinding"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBinding"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.Policy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Policy is a object that holds all the Roles for a particular namespace.  There is at most one Policy document per namespace.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"lastModified": {
							SchemaProps: spec.SchemaProps{
								Description: "LastModified is the last time that any part of the Policy was created, updated, or deleted",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"roles": {
							SchemaProps: spec.SchemaProps{
								Description: "Roles holds all the Roles held by this Policy, mapped by Role.Name",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedRole"),
										},
									},
								},
							},
						},
					},
					Required: []string{"lastModified", "roles"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedRole", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyBinding": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PolicyBinding is a object that holds all the RoleBindings for a particular namespace.  There is one PolicyBinding document per referenced Policy namespace",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"lastModified": {
							SchemaProps: spec.SchemaProps{
								Description: "LastModified is the last time that any part of the PolicyBinding was created, updated, or deleted",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"policyRef": {
							SchemaProps: spec.SchemaProps{
								Description: "PolicyRef is a reference to the Policy that contains all the Roles that this PolicyBinding's RoleBindings may reference",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"roleBindings": {
							SchemaProps: spec.SchemaProps{
								Description: "RoleBindings holds all the RoleBindings held by this PolicyBinding, mapped by RoleBinding.Name",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedRoleBinding"),
										},
									},
								},
							},
						},
					},
					Required: []string{"lastModified", "policyRef", "roleBindings"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.NamedRoleBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.Time", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyBindingList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PolicyBindingList is a collection of PolicyBindings",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of PolicyBindings",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyBinding"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PolicyList is a collection of Policies",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of Policies",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.Policy"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.Policy", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyRule": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.",
					Properties: map[string]spec.Schema{
						"verbs": {
							SchemaProps: spec.SchemaProps{
								Description: "Verbs is a list of Verbs that apply to ALL the ResourceKinds and AttributeRestrictions contained in this rule.  VerbAll represents all kinds.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"attributeRestrictions": {
							SchemaProps: spec.SchemaProps{
								Description: "AttributeRestrictions will vary depending on what the Authorizer/AuthorizationAttributeBuilder pair supports. If the Authorizer does not recognize how to handle the AttributeRestrictions, the Authorizer should report an error.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
						"apiGroups": {
							SchemaProps: spec.SchemaProps{
								Description: "APIGroups is the name of the APIGroup that contains the resources.  If this field is empty, then both kubernetes and origin API groups are assumed. That means that if an action is requested against one of the enumerated resources in either the kubernetes or the origin API group, the request will be allowed",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "Resources is a list of resources this rule applies to.  ResourceAll represents all resources.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"resourceNames": {
							SchemaProps: spec.SchemaProps{
								Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"nonResourceURLs": {
							SchemaProps: spec.SchemaProps{
								Description: "NonResourceURLsSlice is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path This name is intentionally different than the internal type so that the DefaultConvert works nicely and because the ordering may be different.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"verbs", "apiGroups", "resources"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ResourceAccessReview": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ResourceAccessReview is a means to request a list of which users and groups are authorized to perform the action specified by spec",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"verb": {
							SchemaProps: spec.SchemaProps{
								Description: "Verb is one of: get, list, watch, create, update, delete",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceAPIGroup": {
							SchemaProps: spec.SchemaProps{
								Description: "Group is the API group of the resource Serialized as resourceAPIGroup to avoid confusion with the 'groups' field when inlined",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceAPIVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "Version is the API version of the resource Serialized as resourceAPIVersion to avoid confusion with TypeMeta.apiVersion and ObjectMeta.resourceVersion when inlined",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resource": {
							SchemaProps: spec.SchemaProps{
								Description: "Resource is one of the existing resource types",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceName": {
							SchemaProps: spec.SchemaProps{
								Description: "ResourceName is the name of the resource being requested for a \"get\" or deleted for a \"delete\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path is the path of a non resource URL",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"isNonResourceURL": {
							SchemaProps: spec.SchemaProps{
								Description: "IsNonResourceURL is true if this is a request for a non-resource URL (outside of the resource hieraarchy)",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"content": {
							SchemaProps: spec.SchemaProps{
								Description: "Content is the actual content of the request for create and update",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
					},
					Required: []string{"namespace", "verb", "resourceAPIGroup", "resourceAPIVersion", "resource", "resourceName", "path", "isNonResourceURL"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ResourceAccessReviewResponse": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ResourceAccessReviewResponse describes who can perform the action",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the namespace used for the access review",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"users": {
							SchemaProps: spec.SchemaProps{
								Description: "UsersSlice is the list of users who can perform the action",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "GroupsSlice is the list of groups who can perform the action",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"evalutionError": {
							SchemaProps: spec.SchemaProps{
								Description: "EvaluationError is an indication that some error occurred during resolution, but partial results can still be returned. It is entirely possible to get an error and be able to continue determine authorization status in spite of it.  This is most common when a bound role is missing, but enough roles are still present and bound to reason about the request.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"users", "groups", "evalutionError"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.Role": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Role is a logical grouping of PolicyRules that can be referenced as a unit by RoleBindings.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"rules": {
							SchemaProps: spec.SchemaProps{
								Description: "Rules holds all the PolicyRules for this Role",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyRule"),
										},
									},
								},
							},
						},
					},
					Required: []string{"rules"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyRule", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBinding": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RoleBinding references a Role, but not contain it.  It can reference any Role in the same namespace or in the global namespace. It adds who information via (Users and Groups) OR Subjects and namespace information by which namespace it exists in. RoleBindings in a given namespace only have effect in that namespace (excepting the master namespace which has power in all namespaces).",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"userNames": {
							SchemaProps: spec.SchemaProps{
								Description: "UserNames holds all the usernames directly bound to the role. This field should only be specified when supporting legacy clients and servers. See Subjects for further details.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"groupNames": {
							SchemaProps: spec.SchemaProps{
								Description: "GroupNames holds all the groups directly bound to the role. This field should only be specified when supporting legacy clients and servers. See Subjects for further details.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"subjects": {
							SchemaProps: spec.SchemaProps{
								Description: "Subjects hold object references to authorize with this rule. This field is ignored if UserNames or GroupNames are specified to support legacy clients and servers. Thus newer clients that do not need to support backwards compatibility should send only fully qualified Subjects and should omit the UserNames and GroupNames fields. Clients that need to support backwards compatibility can use this field to build the UserNames and GroupNames.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
										},
									},
								},
							},
						},
						"roleRef": {
							SchemaProps: spec.SchemaProps{
								Description: "RoleRef can only reference the current namespace and the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error. Since Policy is a singleton, this is sufficient knowledge to locate a role.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
					Required: []string{"userNames", "groupNames", "subjects", "roleRef"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBindingList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RoleBindingList is a collection of RoleBindings",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of RoleBindings",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBinding"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBindingRestriction": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RoleBindingRestriction is an object that can be matched against a subject (user, group, or service account) to determine whether rolebindings on that subject are allowed in the namespace to which the RoleBindingRestriction belongs.  If any one of those RoleBindingRestriction objects matches a subject, rolebindings on that subject in the namespace are allowed.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the matcher.",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBindingRestrictionSpec"),
							},
						},
					},
					Required: []string{"metadata", "spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBindingRestrictionSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBindingRestrictionList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RoleBindingRestrictionList is a collection of RoleBindingRestriction objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of RoleBindingRestriction objects.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBindingRestriction"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBindingRestriction", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleBindingRestrictionSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RoleBindingRestrictionSpec defines a rolebinding restriction.  Exactly one field must be non-nil.",
					Properties: map[string]spec.Schema{
						"userrestriction": {
							SchemaProps: spec.SchemaProps{
								Description: "UserRestriction matches against user subjects.",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.UserRestriction"),
							},
						},
						"grouprestriction": {
							SchemaProps: spec.SchemaProps{
								Description: "GroupRestriction matches against group subjects.",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.GroupRestriction"),
							},
						},
						"serviceaccountrestriction": {
							SchemaProps: spec.SchemaProps{
								Description: "ServiceAccountRestriction matches against service-account subjects.",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ServiceAccountRestriction"),
							},
						},
					},
					Required: []string{"userrestriction", "grouprestriction", "serviceaccountrestriction"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.GroupRestriction", "github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ServiceAccountRestriction", "github.com/openshift/origin/pkg/authorization/apis/authorization/v1.UserRestriction"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.RoleList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RoleList is a collection of Roles",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of Roles",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.Role"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.Role", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SelfSubjectRulesReview": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SelfSubjectRulesReview is a resource you can create to determine which actions you can perform in a namespace",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec adds information about how to conduct the check",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SelfSubjectRulesReviewSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status is completed by the server to tell which permissions you have",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SubjectRulesReviewStatus"),
							},
						},
					},
					Required: []string{"spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SelfSubjectRulesReviewSpec", "github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SubjectRulesReviewStatus"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SelfSubjectRulesReviewSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SelfSubjectRulesReviewSpec adds information about how to conduct the check",
					Properties: map[string]spec.Schema{
						"scopes": {
							SchemaProps: spec.SchemaProps{
								Description: "Scopes to use for the evaluation.  Empty means \"use the unscoped (full) permissions of the user/groups\". Nil means \"use the scopes on this request\".",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"scopes"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ServiceAccountReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceAccountReference specifies a service account and namespace by their names.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name is the name of the service account.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the namespace of the service account.  Service accounts from inside the whitelisted namespaces are allowed to be bound to roles.  If Namespace is empty, then the namespace of the RoleBindingRestriction in which the ServiceAccountReference is embedded is used.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name", "namespace"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ServiceAccountRestriction": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceAccountRestriction matches a service account by a string match on either the service-account name or the name of the service account's namespace.",
					Properties: map[string]spec.Schema{
						"serviceaccounts": {
							SchemaProps: spec.SchemaProps{
								Description: "ServiceAccounts specifies a list of literal service-account names.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ServiceAccountReference"),
										},
									},
								},
							},
						},
						"namespaces": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespaces specifies a list of literal namespace names.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"serviceaccounts", "namespaces"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.ServiceAccountReference"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SubjectAccessReview": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SubjectAccessReview is an object for requesting information about whether a user or group can perform an action",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"verb": {
							SchemaProps: spec.SchemaProps{
								Description: "Verb is one of: get, list, watch, create, update, delete",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceAPIGroup": {
							SchemaProps: spec.SchemaProps{
								Description: "Group is the API group of the resource Serialized as resourceAPIGroup to avoid confusion with the 'groups' field when inlined",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceAPIVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "Version is the API version of the resource Serialized as resourceAPIVersion to avoid confusion with TypeMeta.apiVersion and ObjectMeta.resourceVersion when inlined",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resource": {
							SchemaProps: spec.SchemaProps{
								Description: "Resource is one of the existing resource types",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceName": {
							SchemaProps: spec.SchemaProps{
								Description: "ResourceName is the name of the resource being requested for a \"get\" or deleted for a \"delete\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path is the path of a non resource URL",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"isNonResourceURL": {
							SchemaProps: spec.SchemaProps{
								Description: "IsNonResourceURL is true if this is a request for a non-resource URL (outside of the resource hieraarchy)",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"content": {
							SchemaProps: spec.SchemaProps{
								Description: "Content is the actual content of the request for create and update",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "User is optional. If both User and Groups are empty, the current authenticated user is used.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "GroupsSlice is optional. Groups is the list of groups to which the User belongs.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"scopes": {
							SchemaProps: spec.SchemaProps{
								Description: "Scopes to use for the evaluation.  Empty means \"use the unscoped (full) permissions of the user/groups\". Nil for a self-SAR, means \"use the scopes on this request\". Nil for a regular SAR, means the same as empty.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"namespace", "verb", "resourceAPIGroup", "resourceAPIVersion", "resource", "resourceName", "path", "isNonResourceURL", "user", "groups", "scopes"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SubjectAccessReviewResponse": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SubjectAccessReviewResponse describes whether or not a user or group can perform an action",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the namespace used for the access review",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"allowed": {
							SchemaProps: spec.SchemaProps{
								Description: "Allowed is required.  True if the action would be allowed, false otherwise.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "Reason is optional.  It indicates why a request was allowed or denied.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"evaluationError": {
							SchemaProps: spec.SchemaProps{
								Description: "EvaluationError is an indication that some error occurred during the authorization check. It is entirely possible to get an error and be able to continue determine authorization status in spite of it.  This is most common when a bound role is missing, but enough roles are still present and bound to reason about the request.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"allowed"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SubjectRulesReview": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SubjectRulesReview is a resource you can create to determine which actions another user can perform in a namespace",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec adds information about how to conduct the check",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SubjectRulesReviewSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status is completed by the server to tell which permissions you have",
								Ref:         ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SubjectRulesReviewStatus"),
							},
						},
					},
					Required: []string{"spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SubjectRulesReviewSpec", "github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SubjectRulesReviewStatus"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SubjectRulesReviewSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SubjectRulesReviewSpec adds information about how to conduct the check",
					Properties: map[string]spec.Schema{
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "User is optional.  At least one of User and Groups must be specified.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "Groups is optional.  Groups is the list of groups to which the User belongs.  At least one of User and Groups must be specified.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"scopes": {
							SchemaProps: spec.SchemaProps{
								Description: "Scopes to use for the evaluation.  Empty means \"use the unscoped (full) permissions of the user/groups\".",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"user", "groups", "scopes"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.SubjectRulesReviewStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SubjectRulesReviewStatus is contains the result of a rules check",
					Properties: map[string]spec.Schema{
						"rules": {
							SchemaProps: spec.SchemaProps{
								Description: "Rules is the list of rules (no particular sort) that are allowed for the subject",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyRule"),
										},
									},
								},
							},
						},
						"evaluationError": {
							SchemaProps: spec.SchemaProps{
								Description: "EvaluationError can appear in combination with Rules.  It means some error happened during evaluation that may have prevented additional rules from being populated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"rules"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.PolicyRule"},
		},
		"github.com/openshift/origin/pkg/authorization/apis/authorization/v1.UserRestriction": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "UserRestriction matches a user either by a string match on the user name, a string match on the name of a group to which the user belongs, or a label selector applied to the user labels.",
					Properties: map[string]spec.Schema{
						"users": {
							SchemaProps: spec.SchemaProps{
								Description: "Users specifies a list of literal user names.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "Groups specifies a list of literal group names.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"labels": {
							SchemaProps: spec.SchemaProps{
								Description: "Selectors specifies a list of label selectors over user labels.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
										},
									},
								},
							},
						},
					},
					Required: []string{"users", "groups", "labels"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BinaryBuildRequestOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BinaryBuildRequestOptions are the options required to fully speficy a binary build request",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "metadata for BinaryBuildRequestOptions.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"asFile": {
							SchemaProps: spec.SchemaProps{
								Description: "asFile determines if the binary should be created as a file within the source rather than extracted as an archive",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"revision.commit": {
							SchemaProps: spec.SchemaProps{
								Description: "revision.commit is the value identifying a specific commit",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"revision.message": {
							SchemaProps: spec.SchemaProps{
								Description: "revision.message is the description of a specific commit",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"revision.authorName": {
							SchemaProps: spec.SchemaProps{
								Description: "revision.authorName of the source control user",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"revision.authorEmail": {
							SchemaProps: spec.SchemaProps{
								Description: "revision.authorEmail of the source control user",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"revision.committerName": {
							SchemaProps: spec.SchemaProps{
								Description: "revision.committerName of the source control user",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"revision.committerEmail": {
							SchemaProps: spec.SchemaProps{
								Description: "revision.committerEmail of the source control user",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BinaryBuildSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BinaryBuildSource describes a binary file to be used for the Docker and Source build strategies, where the file will be extracted and used as the build source.",
					Properties: map[string]spec.Schema{
						"asFile": {
							SchemaProps: spec.SchemaProps{
								Description: "asFile indicates that the provided binary input should be considered a single file within the build input. For example, specifying \"webapp.war\" would place the provided binary as `/webapp.war` for the builder. If left empty, the Docker and Source build strategies assume this file is a zip, tar, or tar.gz file and extract it as the source. The custom strategy receives this binary as standard input. This filename may not contain slashes or be '..' or '.'.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BitbucketWebHookCause": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BitbucketWebHookCause has information about a Bitbucket webhook that triggered a build.",
					Properties: map[string]spec.Schema{
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "Revision is the git source revision information of the trigger.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"),
							},
						},
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "Secret is the obfuscated webhook secret that triggered a build.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.Build": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Build encapsulates the inputs needed to produce a new deployable image, as well as the status of the execution and a reference to the Pod which executed the build.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "spec is all the inputs used to execute the build.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "status is the current status of the build.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.BuildSpec", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildConfig": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Build configurations define a build process for new Docker images. There are three types of builds possible - a Docker build using a Dockerfile, a Source-to-Image build that uses a specially prepared base image that accepts source code that it can make runnable, and a custom build that can run // arbitrary Docker images as a base and accept the build parameters. Builds run on the cluster and on completion are pushed to the Docker registry specified in the \"output\" section. A build can be triggered via a webhook, when the base image changes, or when a user manually requests a new build be // created.\n\nEach build created by a build configuration is numbered and refers back to its parent configuration. Multiple builds can be triggered at once. Builds that do not have \"output\" set can be used to test code or run a verification build.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "metadata for BuildConfig.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "spec holds all the input necessary to produce a new build, and the conditions when to trigger them.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildConfigSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "status holds any relevant information about a build config",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildConfigStatus"),
							},
						},
					},
					Required: []string{"spec", "status"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.BuildConfigSpec", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildConfigStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildConfigList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildConfigList is a collection of BuildConfigs.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "metadata for BuildConfigList.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "items is a list of build configs",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildConfig"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.BuildConfig", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildConfigSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildConfigSpec describes when and how builds are created",
					Properties: map[string]spec.Schema{
						"triggers": {
							SchemaProps: spec.SchemaProps{
								Description: "triggers determine how new Builds can be launched from a BuildConfig. If no triggers are defined, a new build can only occur as a result of an explicit client build creation.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildTriggerPolicy"),
										},
									},
								},
							},
						},
						"runPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "RunPolicy describes how the new build created from this build configuration will be scheduled for execution. This is optional, if not specified we default to \"Serial\".",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"serviceAccount": {
							SchemaProps: spec.SchemaProps{
								Description: "serviceAccount is the name of the ServiceAccount to use to run the pod created by this build. The pod will be allowed to use secrets referenced by the ServiceAccount",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"source": {
							SchemaProps: spec.SchemaProps{
								Description: "source describes the SCM in use.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildSource"),
							},
						},
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "revision is the information from the source for a specific repo snapshot. This is optional.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"),
							},
						},
						"strategy": {
							SchemaProps: spec.SchemaProps{
								Description: "strategy defines how to perform a build.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildStrategy"),
							},
						},
						"output": {
							SchemaProps: spec.SchemaProps{
								Description: "output describes the Docker image the Strategy should produce.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildOutput"),
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "resources computes resource requirements to execute the build.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceRequirements"),
							},
						},
						"postCommit": {
							SchemaProps: spec.SchemaProps{
								Description: "postCommit is a build hook executed after the build output image is committed, before it is pushed to a registry.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildPostCommitSpec"),
							},
						},
						"completionDeadlineSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "completionDeadlineSeconds is an optional duration in seconds, counted from the time when a build pod gets scheduled in the system, that the build may be active on a node before the system actively tries to terminate the build; value must be positive integer",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"nodeSelector": {
							SchemaProps: spec.SchemaProps{
								Description: "nodeSelector is a selector which must be true for the build pod to fit on a node If nil, it can be overridden by default build nodeselector values for the cluster. If set to an empty map or a map with any values, default build nodeselector values are ignored.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"successfulBuildsHistoryLimit": {
							SchemaProps: spec.SchemaProps{
								Description: "successfulBuildsHistoryLimit is the number of old successful builds to retain. If not specified, all successful builds are retained.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"failedBuildsHistoryLimit": {
							SchemaProps: spec.SchemaProps{
								Description: "failedBuildsHistoryLimit is the number of old failed builds to retain. If not specified, all failed builds are retained.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"triggers", "strategy", "nodeSelector"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.BuildOutput", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildPostCommitSpec", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildSource", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildStrategy", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildTriggerPolicy", "github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision", "k8s.io/kubernetes/pkg/api/v1.ResourceRequirements"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildConfigStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildConfigStatus contains current state of the build config object.",
					Properties: map[string]spec.Schema{
						"lastVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "lastVersion is used to inform about number of last triggered build.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
					Required: []string{"lastVersion"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildList is a collection of Builds.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "metadata for BuildList.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "items is a list of builds",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.Build"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.Build", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildLog": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildLog is the (unused) resource associated with the build log redirector",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildLogOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildLogOptions is the REST options for a build log",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"container": {
							SchemaProps: spec.SchemaProps{
								Description: "cointainer for which to stream logs. Defaults to only container if there is one container in the pod.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"follow": {
							SchemaProps: spec.SchemaProps{
								Description: "follow if true indicates that the build log should be streamed until the build terminates.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"previous": {
							SchemaProps: spec.SchemaProps{
								Description: "previous returns previous build logs. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"sinceSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "sinceSeconds is a relative time in seconds before the current time from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"sinceTime": {
							SchemaProps: spec.SchemaProps{
								Description: "sinceTime is an RFC3339 timestamp from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"timestamps": {
							SchemaProps: spec.SchemaProps{
								Description: "timestamps, If true, add an RFC3339 or RFC3339Nano timestamp at the beginning of every line of log output. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"tailLines": {
							SchemaProps: spec.SchemaProps{
								Description: "tailLines, If set, is the number of lines from the end of the logs to show. If not specified, logs are shown from the creation of the container or sinceSeconds or sinceTime",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"limitBytes": {
							SchemaProps: spec.SchemaProps{
								Description: "limitBytes, If set, is the number of bytes to read from the server before terminating the log output. This may not display a complete final line of logging, and may return slightly more or slightly less than the specified limit.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"nowait": {
							SchemaProps: spec.SchemaProps{
								Description: "noWait if true causes the call to return immediately even if the build is not available yet. Otherwise the server will wait until the build has started.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"version": {
							SchemaProps: spec.SchemaProps{
								Description: "version of the build for which to view logs.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildOutput": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildOutput is input to a build strategy and describes the Docker image that the strategy should produce.",
					Properties: map[string]spec.Schema{
						"to": {
							SchemaProps: spec.SchemaProps{
								Description: "to defines an optional location to push the output of this build to. Kind must be one of 'ImageStreamTag' or 'DockerImage'. This value will be used to look up a Docker image repository to push to. In the case of an ImageStreamTag, the ImageStreamTag will be looked for in the namespace of the build unless Namespace is specified.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"pushSecret": {
							SchemaProps: spec.SchemaProps{
								Description: "PushSecret is the name of a Secret that would be used for setting up the authentication for executing the Docker push to authentication enabled Docker Registry (or Docker Hub).",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"imageLabels": {
							SchemaProps: spec.SchemaProps{
								Description: "imageLabels define a list of labels that are applied to the resulting image. If there are multiple labels with the same name then the last one in the list is used.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.ImageLabel"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.ImageLabel", "k8s.io/kubernetes/pkg/api/v1.LocalObjectReference", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildPostCommitSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A BuildPostCommitSpec holds a build post commit hook specification. The hook executes a command in a temporary container running the build output image, immediately after the last layer of the image is committed and before the image is pushed to a registry. The command is executed with the current working directory ($PWD) set to the image's WORKDIR.\n\nThe build will be marked as failed if the hook execution fails. It will fail if the script or command return a non-zero exit code, or if there is any other error related to starting the temporary container.\n\nThere are five different ways to configure the hook. As an example, all forms below are equivalent and will execute `rake test --verbose`.\n\n1. Shell script:\n\n       \"postCommit\": {\n         \"script\": \"rake test --verbose\",\n       }\n\n    The above is a convenient form which is equivalent to:\n\n       \"postCommit\": {\n         \"command\": [\"/bin/sh\", \"-ic\"],\n         \"args\":    [\"rake test --verbose\"]\n       }\n\n2. A command as the image entrypoint:\n\n       \"postCommit\": {\n         \"commit\": [\"rake\", \"test\", \"--verbose\"]\n       }\n\n    Command overrides the image entrypoint in the exec form, as documented in\n    Docker: https://docs.docker.com/engine/reference/builder/#entrypoint.\n\n3. Pass arguments to the default entrypoint:\n\n       \"postCommit\": {\n\t\t      \"args\": [\"rake\", \"test\", \"--verbose\"]\n\t      }\n\n    This form is only useful if the image entrypoint can handle arguments.\n\n4. Shell script with arguments:\n\n       \"postCommit\": {\n         \"script\": \"rake test $1\",\n         \"args\":   [\"--verbose\"]\n       }\n\n    This form is useful if you need to pass arguments that would otherwise be\n    hard to quote properly in the shell script. In the script, $0 will be\n    \"/bin/sh\" and $1, $2, etc, are the positional arguments from Args.\n\n5. Command with arguments:\n\n       \"postCommit\": {\n         \"command\": [\"rake\", \"test\"],\n         \"args\":    [\"--verbose\"]\n       }\n\n    This form is equivalent to appending the arguments to the Command slice.\n\nIt is invalid to provide both Script and Command simultaneously. If none of the fields are specified, the hook is not executed.",
					Properties: map[string]spec.Schema{
						"command": {
							SchemaProps: spec.SchemaProps{
								Description: "command is the command to run. It may not be specified with Script. This might be needed if the image doesn't have `/bin/sh`, or if you do not want to use a shell. In all other cases, using Script might be more convenient.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"args": {
							SchemaProps: spec.SchemaProps{
								Description: "args is a list of arguments that are provided to either Command, Script or the Docker image's default entrypoint. The arguments are placed immediately after the command to be run.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"script": {
							SchemaProps: spec.SchemaProps{
								Description: "script is a shell script to be run with `/bin/sh -ic`. It may not be specified with Command. Use Script when a shell script is appropriate to execute the post build hook, for example for running unit tests with `rake test`. If you need control over the image entrypoint, or if the image does not have `/bin/sh`, use Command and/or Args. The `-i` flag is needed to support CentOS and RHEL images that use Software Collections (SCL), in order to have the appropriate collections enabled in the shell. E.g., in the Ruby image, this is necessary to make `ruby`, `bundle` and other binaries available in the PATH.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildRequest": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildRequest is the resource used to pass parameters to build generator",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "metadata for BuildRequest.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "revision is the information from the source for a specific repo snapshot.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"),
							},
						},
						"triggeredByImage": {
							SchemaProps: spec.SchemaProps{
								Description: "triggeredByImage is the Image that triggered this build.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "from is the reference to the ImageStreamTag that triggered the build.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"binary": {
							SchemaProps: spec.SchemaProps{
								Description: "binary indicates a request to build from a binary provided to the builder",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BinaryBuildSource"),
							},
						},
						"lastVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "lastVersion (optional) is the LastVersion of the BuildConfig that was used to generate the build. If the BuildConfig in the generator doesn't match, a build will not be generated.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"env": {
							SchemaProps: spec.SchemaProps{
								Description: "env contains additional environment variables you want to pass into a builder container.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvVar"),
										},
									},
								},
							},
						},
						"triggeredBy": {
							SchemaProps: spec.SchemaProps{
								Description: "triggeredBy describes which triggers started the most recent update to the build configuration and contains information about those triggers.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildTriggerCause"),
										},
									},
								},
							},
						},
						"dockerStrategyOptions": {
							SchemaProps: spec.SchemaProps{
								Description: "DockerStrategyOptions contains additional docker-strategy specific options for the build",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.DockerStrategyOptions"),
							},
						},
					},
					Required: []string{"triggeredBy"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.BinaryBuildSource", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildTriggerCause", "github.com/openshift/origin/pkg/build/apis/build/v1.DockerStrategyOptions", "github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.EnvVar", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildSource is the SCM used for the build.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "type of build input to accept",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"binary": {
							SchemaProps: spec.SchemaProps{
								Description: "binary builds accept a binary as their input. The binary is generally assumed to be a tar, gzipped tar, or zip file depending on the strategy. For Docker builds, this is the build context and an optional Dockerfile may be specified to override any Dockerfile in the build context. For Source builds, this is assumed to be an archive as described above. For Source and Docker builds, if binary.asFile is set the build will receive a directory with a single file. contextDir may be used when an archive is provided. Custom builds will receive this binary as input on STDIN.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BinaryBuildSource"),
							},
						},
						"dockerfile": {
							SchemaProps: spec.SchemaProps{
								Description: "dockerfile is the raw contents of a Dockerfile which should be built. When this option is specified, the FROM may be modified based on your strategy base image and additional ENV stanzas from your strategy environment will be added after the FROM, but before the rest of your Dockerfile stanzas. The Dockerfile source type may be used with other options like git - in those cases the Git repo will have any innate Dockerfile replaced in the context dir.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"git": {
							SchemaProps: spec.SchemaProps{
								Description: "git contains optional information about git build source",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.GitBuildSource"),
							},
						},
						"images": {
							SchemaProps: spec.SchemaProps{
								Description: "images describes a set of images to be used to provide source for the build",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.ImageSource"),
										},
									},
								},
							},
						},
						"contextDir": {
							SchemaProps: spec.SchemaProps{
								Description: "contextDir specifies the sub-directory where the source code for the application exists. This allows to have buildable sources in directory other than root of repository.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"sourceSecret": {
							SchemaProps: spec.SchemaProps{
								Description: "sourceSecret is the name of a Secret that would be used for setting up the authentication for cloning private repository. The secret contains valid credentials for remote repository, where the data's key represent the authentication method to be used and value is the base64 encoded credentials. Supported auth methods are: ssh-privatekey.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"secrets": {
							SchemaProps: spec.SchemaProps{
								Description: "secrets represents a list of secrets and their destinations that will be used only for the build.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.SecretBuildSource"),
										},
									},
								},
							},
						},
					},
					Required: []string{"type"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.BinaryBuildSource", "github.com/openshift/origin/pkg/build/apis/build/v1.GitBuildSource", "github.com/openshift/origin/pkg/build/apis/build/v1.ImageSource", "github.com/openshift/origin/pkg/build/apis/build/v1.SecretBuildSource", "k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildSpec has the information to represent a build and also additional information about a build",
					Properties: map[string]spec.Schema{
						"serviceAccount": {
							SchemaProps: spec.SchemaProps{
								Description: "serviceAccount is the name of the ServiceAccount to use to run the pod created by this build. The pod will be allowed to use secrets referenced by the ServiceAccount",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"source": {
							SchemaProps: spec.SchemaProps{
								Description: "source describes the SCM in use.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildSource"),
							},
						},
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "revision is the information from the source for a specific repo snapshot. This is optional.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"),
							},
						},
						"strategy": {
							SchemaProps: spec.SchemaProps{
								Description: "strategy defines how to perform a build.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildStrategy"),
							},
						},
						"output": {
							SchemaProps: spec.SchemaProps{
								Description: "output describes the Docker image the Strategy should produce.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildOutput"),
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "resources computes resource requirements to execute the build.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceRequirements"),
							},
						},
						"postCommit": {
							SchemaProps: spec.SchemaProps{
								Description: "postCommit is a build hook executed after the build output image is committed, before it is pushed to a registry.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildPostCommitSpec"),
							},
						},
						"completionDeadlineSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "completionDeadlineSeconds is an optional duration in seconds, counted from the time when a build pod gets scheduled in the system, that the build may be active on a node before the system actively tries to terminate the build; value must be positive integer",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"nodeSelector": {
							SchemaProps: spec.SchemaProps{
								Description: "nodeSelector is a selector which must be true for the build pod to fit on a node If nil, it can be overridden by default build nodeselector values for the cluster. If set to an empty map or a map with any values, default build nodeselector values are ignored.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"triggeredBy": {
							SchemaProps: spec.SchemaProps{
								Description: "triggeredBy describes which triggers started the most recent update to the build configuration and contains information about those triggers.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildTriggerCause"),
										},
									},
								},
							},
						},
					},
					Required: []string{"strategy", "nodeSelector", "triggeredBy"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.BuildOutput", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildPostCommitSpec", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildSource", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildStrategy", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildTriggerCause", "github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision", "k8s.io/kubernetes/pkg/api/v1.ResourceRequirements"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildStatus contains the status of a build",
					Properties: map[string]spec.Schema{
						"phase": {
							SchemaProps: spec.SchemaProps{
								Description: "phase is the point in the build lifecycle. Possible values are \"New\", \"Pending\", \"Running\", \"Complete\", \"Failed\", \"Error\", and \"Cancelled\".",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"cancelled": {
							SchemaProps: spec.SchemaProps{
								Description: "cancelled describes if a cancel event was triggered for the build.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "message is a human-readable message indicating details about why the build has this status.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"startTimestamp": {
							SchemaProps: spec.SchemaProps{
								Description: "startTimestamp is a timestamp representing the server time when this Build started running in a Pod. It is represented in RFC3339 form and is in UTC.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"completionTimestamp": {
							SchemaProps: spec.SchemaProps{
								Description: "completionTimestamp is a timestamp representing the server time when this Build was finished, whether that build failed or succeeded.  It reflects the time at which the Pod running the Build terminated. It is represented in RFC3339 form and is in UTC.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"duration": {
							SchemaProps: spec.SchemaProps{
								Description: "duration contains time.Duration object describing build time.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"outputDockerImageReference": {
							SchemaProps: spec.SchemaProps{
								Description: "outputDockerImageReference contains a reference to the Docker image that will be built by this build. Its value is computed from Build.Spec.Output.To, and should include the registry address, so that it can be used to push and pull the image.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"config": {
							SchemaProps: spec.SchemaProps{
								Description: "config is an ObjectReference to the BuildConfig this Build is based on.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"output": {
							SchemaProps: spec.SchemaProps{
								Description: "output describes the Docker image the build has produced.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildStatusOutput"),
							},
						},
						"stages": {
							SchemaProps: spec.SchemaProps{
								Description: "stages contains details about each stage that occurs during the build including start time, duration (in milliseconds), and the steps that occured within each stage.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.StageInfo"),
										},
									},
								},
							},
						},
						"logSnippet": {
							SchemaProps: spec.SchemaProps{
								Description: "logSnippet is the last few lines of the build log.  This value is only set for builds that failed.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"phase"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.BuildStatusOutput", "github.com/openshift/origin/pkg/build/apis/build/v1.StageInfo", "k8s.io/apimachinery/pkg/apis/meta/v1.Time", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildStatusOutput": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildStatusOutput contains the status of the built image.",
					Properties: map[string]spec.Schema{
						"to": {
							SchemaProps: spec.SchemaProps{
								Description: "to describes the status of the built image being pushed to a registry.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildStatusOutputTo"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.BuildStatusOutputTo"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildStatusOutputTo": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildStatusOutputTo describes the status of the built image with regards to image registry to which it was supposed to be pushed.",
					Properties: map[string]spec.Schema{
						"imageDigest": {
							SchemaProps: spec.SchemaProps{
								Description: "imageDigest is the digest of the built Docker image. The digest uniquely identifies the image in the registry to which it was pushed.\n\nPlease note that this field may not always be set even if the push completes successfully - e.g. when the registry returns no digest or returns it in a format that the builder doesn't understand.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildStrategy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildStrategy contains the details of how to perform a build.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "type is the kind of build strategy.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"dockerStrategy": {
							SchemaProps: spec.SchemaProps{
								Description: "dockerStrategy holds the parameters to the Docker build strategy.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.DockerBuildStrategy"),
							},
						},
						"sourceStrategy": {
							SchemaProps: spec.SchemaProps{
								Description: "sourceStrategy holds the parameters to the Source build strategy.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceBuildStrategy"),
							},
						},
						"customStrategy": {
							SchemaProps: spec.SchemaProps{
								Description: "customStrategy holds the parameters to the Custom build strategy",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.CustomBuildStrategy"),
							},
						},
						"jenkinsPipelineStrategy": {
							SchemaProps: spec.SchemaProps{
								Description: "JenkinsPipelineStrategy holds the parameters to the Jenkins Pipeline build strategy. This strategy is in tech preview.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.JenkinsPipelineBuildStrategy"),
							},
						},
					},
					Required: []string{"type"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.CustomBuildStrategy", "github.com/openshift/origin/pkg/build/apis/build/v1.DockerBuildStrategy", "github.com/openshift/origin/pkg/build/apis/build/v1.JenkinsPipelineBuildStrategy", "github.com/openshift/origin/pkg/build/apis/build/v1.SourceBuildStrategy"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildTriggerCause": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildTriggerCause holds information about a triggered build. It is used for displaying build trigger data for each build and build configuration in oc describe. It is also used to describe which triggers led to the most recent update in the build configuration.",
					Properties: map[string]spec.Schema{
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "message is used to store a human readable message for why the build was triggered. E.g.: \"Manually triggered by user\", \"Configuration change\",etc.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"genericWebHook": {
							SchemaProps: spec.SchemaProps{
								Description: "genericWebHook holds data about a builds generic webhook trigger.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.GenericWebHookCause"),
							},
						},
						"githubWebHook": {
							SchemaProps: spec.SchemaProps{
								Description: "gitHubWebHook represents data for a GitHub webhook that fired a specific build.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.GitHubWebHookCause"),
							},
						},
						"imageChangeBuild": {
							SchemaProps: spec.SchemaProps{
								Description: "imageChangeBuild stores information about an imagechange event that triggered a new build.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.ImageChangeCause"),
							},
						},
						"gitlabWebHook": {
							SchemaProps: spec.SchemaProps{
								Description: "GitLabWebHook represents data for a GitLab webhook that fired a specific build.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.GitLabWebHookCause"),
							},
						},
						"bitbucketWebHook": {
							SchemaProps: spec.SchemaProps{
								Description: "BitbucketWebHook represents data for a Bitbucket webhook that fired a specific build.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BitbucketWebHookCause"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.BitbucketWebHookCause", "github.com/openshift/origin/pkg/build/apis/build/v1.GenericWebHookCause", "github.com/openshift/origin/pkg/build/apis/build/v1.GitHubWebHookCause", "github.com/openshift/origin/pkg/build/apis/build/v1.GitLabWebHookCause", "github.com/openshift/origin/pkg/build/apis/build/v1.ImageChangeCause"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.BuildTriggerPolicy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BuildTriggerPolicy describes a policy for a single trigger that results in a new Build.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "type is the type of build trigger",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"github": {
							SchemaProps: spec.SchemaProps{
								Description: "github contains the parameters for a GitHub webhook type of trigger",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.WebHookTrigger"),
							},
						},
						"generic": {
							SchemaProps: spec.SchemaProps{
								Description: "generic contains the parameters for a Generic webhook type of trigger",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.WebHookTrigger"),
							},
						},
						"imageChange": {
							SchemaProps: spec.SchemaProps{
								Description: "imageChange contains parameters for an ImageChange type of trigger",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.ImageChangeTrigger"),
							},
						},
						"gitlab": {
							SchemaProps: spec.SchemaProps{
								Description: "GitLabWebHook contains the parameters for a GitLab webhook type of trigger",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.WebHookTrigger"),
							},
						},
						"bitbucket": {
							SchemaProps: spec.SchemaProps{
								Description: "BitbucketWebHook contains the parameters for a Bitbucket webhook type of trigger",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.WebHookTrigger"),
							},
						},
					},
					Required: []string{"type"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.ImageChangeTrigger", "github.com/openshift/origin/pkg/build/apis/build/v1.WebHookTrigger"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.CommonSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "CommonSpec encapsulates all the inputs necessary to represent a build.",
					Properties: map[string]spec.Schema{
						"serviceAccount": {
							SchemaProps: spec.SchemaProps{
								Description: "serviceAccount is the name of the ServiceAccount to use to run the pod created by this build. The pod will be allowed to use secrets referenced by the ServiceAccount",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"source": {
							SchemaProps: spec.SchemaProps{
								Description: "source describes the SCM in use.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildSource"),
							},
						},
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "revision is the information from the source for a specific repo snapshot. This is optional.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"),
							},
						},
						"strategy": {
							SchemaProps: spec.SchemaProps{
								Description: "strategy defines how to perform a build.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildStrategy"),
							},
						},
						"output": {
							SchemaProps: spec.SchemaProps{
								Description: "output describes the Docker image the Strategy should produce.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildOutput"),
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "resources computes resource requirements to execute the build.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceRequirements"),
							},
						},
						"postCommit": {
							SchemaProps: spec.SchemaProps{
								Description: "postCommit is a build hook executed after the build output image is committed, before it is pushed to a registry.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.BuildPostCommitSpec"),
							},
						},
						"completionDeadlineSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "completionDeadlineSeconds is an optional duration in seconds, counted from the time when a build pod gets scheduled in the system, that the build may be active on a node before the system actively tries to terminate the build; value must be positive integer",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"nodeSelector": {
							SchemaProps: spec.SchemaProps{
								Description: "nodeSelector is a selector which must be true for the build pod to fit on a node If nil, it can be overridden by default build nodeselector values for the cluster. If set to an empty map or a map with any values, default build nodeselector values are ignored.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"strategy", "nodeSelector"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.BuildOutput", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildPostCommitSpec", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildSource", "github.com/openshift/origin/pkg/build/apis/build/v1.BuildStrategy", "github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision", "k8s.io/kubernetes/pkg/api/v1.ResourceRequirements"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.CommonWebHookCause": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "CommonWebHookCause factors out the identical format of these webhook causes into struct so we can share it in the specific causes;  it is too late for GitHub and Generic but we can leverage this pattern with GitLab and Bitbucket.",
					Properties: map[string]spec.Schema{
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "Revision is the git source revision information of the trigger.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"),
							},
						},
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "Secret is the obfuscated webhook secret that triggered a build.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.CustomBuildStrategy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "CustomBuildStrategy defines input parameters specific to Custom build.",
					Properties: map[string]spec.Schema{
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "from is reference to an DockerImage, ImageStreamTag, or ImageStreamImage from which the docker image should be pulled",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"pullSecret": {
							SchemaProps: spec.SchemaProps{
								Description: "pullSecret is the name of a Secret that would be used for setting up the authentication for pulling the Docker images from the private Docker registries",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"env": {
							SchemaProps: spec.SchemaProps{
								Description: "env contains additional environment variables you want to pass into a builder container.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvVar"),
										},
									},
								},
							},
						},
						"exposeDockerSocket": {
							SchemaProps: spec.SchemaProps{
								Description: "exposeDockerSocket will allow running Docker commands (and build Docker images) from inside the Docker container.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"forcePull": {
							SchemaProps: spec.SchemaProps{
								Description: "forcePull describes if the controller should configure the build pod to always pull the images for the builder or only pull if it is not present locally",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"secrets": {
							SchemaProps: spec.SchemaProps{
								Description: "secrets is a list of additional secrets that will be included in the build pod",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.SecretSpec"),
										},
									},
								},
							},
						},
						"buildAPIVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "buildAPIVersion is the requested API version for the Build object serialized and passed to the custom builder",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"from"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.SecretSpec", "k8s.io/kubernetes/pkg/api/v1.EnvVar", "k8s.io/kubernetes/pkg/api/v1.LocalObjectReference", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.DockerBuildStrategy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DockerBuildStrategy defines input parameters specific to Docker build.",
					Properties: map[string]spec.Schema{
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "from is reference to an DockerImage, ImageStreamTag, or ImageStreamImage from which the docker image should be pulled the resulting image will be used in the FROM line of the Dockerfile for this build.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"pullSecret": {
							SchemaProps: spec.SchemaProps{
								Description: "pullSecret is the name of a Secret that would be used for setting up the authentication for pulling the Docker images from the private Docker registries",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"noCache": {
							SchemaProps: spec.SchemaProps{
								Description: "noCache if set to true indicates that the docker build must be executed with the --no-cache=true flag",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"env": {
							SchemaProps: spec.SchemaProps{
								Description: "env contains additional environment variables you want to pass into a builder container.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvVar"),
										},
									},
								},
							},
						},
						"forcePull": {
							SchemaProps: spec.SchemaProps{
								Description: "forcePull describes if the builder should pull the images from registry prior to building.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"dockerfilePath": {
							SchemaProps: spec.SchemaProps{
								Description: "dockerfilePath is the path of the Dockerfile that will be used to build the Docker image, relative to the root of the context (contextDir).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"buildArgs": {
							SchemaProps: spec.SchemaProps{
								Description: "buildArgs contains build arguments that will be resolved in the Dockerfile.  See https://docs.docker.com/engine/reference/builder/#/arg for more details.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvVar"),
										},
									},
								},
							},
						},
						"imageOptimizationPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "imageOptimizationPolicy describes what optimizations the system can use when building images to reduce the final size or time spent building the image. The default policy is 'None' which means the final build image will be equivalent to an image created by the Docker build API. The experimental policy 'SkipLayers' will avoid commiting new layers in between each image step, and will fail if the Dockerfile cannot provide compatibility with the 'None' policy. An additional experimental policy 'SkipLayersAndWarn' is the same as 'SkipLayers' but simply warns if compatibility cannot be preserved.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.EnvVar", "k8s.io/kubernetes/pkg/api/v1.LocalObjectReference", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.DockerStrategyOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DockerStrategyOptions contains extra strategy options for Docker builds",
					Properties: map[string]spec.Schema{
						"buildArgs": {
							SchemaProps: spec.SchemaProps{
								Description: "Args contains any build arguments that are to be passed to Docker.  See https://docs.docker.com/engine/reference/builder/#/arg for more details",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvVar"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.EnvVar"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.GenericWebHookCause": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GenericWebHookCause holds information about a generic WebHook that triggered a build.",
					Properties: map[string]spec.Schema{
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "revision is an optional field that stores the git source revision information of the generic webhook trigger when it is available.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"),
							},
						},
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "secret is the obfuscated webhook secret that triggered a build.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.GenericWebHookEvent": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GenericWebHookEvent is the payload expected for a generic webhook post",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "type is the type of source repository",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"git": {
							SchemaProps: spec.SchemaProps{
								Description: "git is the git information if the Type is BuildSourceGit",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.GitInfo"),
							},
						},
						"env": {
							SchemaProps: spec.SchemaProps{
								Description: "env contains additional environment variables you want to pass into a builder container. ValueFrom is not supported.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvVar"),
										},
									},
								},
							},
						},
						"dockerStrategyOptions": {
							SchemaProps: spec.SchemaProps{
								Description: "DockerStrategyOptions contains additional docker-strategy specific options for the build",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.DockerStrategyOptions"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.DockerStrategyOptions", "github.com/openshift/origin/pkg/build/apis/build/v1.GitInfo", "k8s.io/kubernetes/pkg/api/v1.EnvVar"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.GitBuildSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GitBuildSource defines the parameters of a Git SCM",
					Properties: map[string]spec.Schema{
						"uri": {
							SchemaProps: spec.SchemaProps{
								Description: "uri points to the source that will be built. The structure of the source will depend on the type of build to run",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"ref": {
							SchemaProps: spec.SchemaProps{
								Description: "ref is the branch/tag/ref to build.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"httpProxy": {
							SchemaProps: spec.SchemaProps{
								Description: "httpProxy is a proxy used to reach the git repository over http",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"httpsProxy": {
							SchemaProps: spec.SchemaProps{
								Description: "httpsProxy is a proxy used to reach the git repository over https",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"noProxy": {
							SchemaProps: spec.SchemaProps{
								Description: "noProxy is the list of domains for which the proxy should not be used",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"uri"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.GitHubWebHookCause": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GitHubWebHookCause has information about a GitHub webhook that triggered a build.",
					Properties: map[string]spec.Schema{
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "revision is the git revision information of the trigger.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"),
							},
						},
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "secret is the obfuscated webhook secret that triggered a build.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.GitInfo": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GitInfo is the aggregated git information for a generic webhook post",
					Properties: map[string]spec.Schema{
						"uri": {
							SchemaProps: spec.SchemaProps{
								Description: "uri points to the source that will be built. The structure of the source will depend on the type of build to run",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"ref": {
							SchemaProps: spec.SchemaProps{
								Description: "ref is the branch/tag/ref to build.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"httpProxy": {
							SchemaProps: spec.SchemaProps{
								Description: "httpProxy is a proxy used to reach the git repository over http",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"httpsProxy": {
							SchemaProps: spec.SchemaProps{
								Description: "httpsProxy is a proxy used to reach the git repository over https",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"noProxy": {
							SchemaProps: spec.SchemaProps{
								Description: "noProxy is the list of domains for which the proxy should not be used",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"commit": {
							SchemaProps: spec.SchemaProps{
								Description: "commit is the commit hash identifying a specific commit",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"author": {
							SchemaProps: spec.SchemaProps{
								Description: "author is the author of a specific commit",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceControlUser"),
							},
						},
						"committer": {
							SchemaProps: spec.SchemaProps{
								Description: "committer is the committer of a specific commit",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceControlUser"),
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "message is the description of a specific commit",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"uri"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.SourceControlUser"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.GitLabWebHookCause": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GitLabWebHookCause has information about a GitLab webhook that triggered a build.",
					Properties: map[string]spec.Schema{
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "Revision is the git source revision information of the trigger.",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"),
							},
						},
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "Secret is the obfuscated webhook secret that triggered a build.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.GitSourceRevision": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GitSourceRevision is the commit information from a git source for a build",
					Properties: map[string]spec.Schema{
						"commit": {
							SchemaProps: spec.SchemaProps{
								Description: "commit is the commit hash identifying a specific commit",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"author": {
							SchemaProps: spec.SchemaProps{
								Description: "author is the author of a specific commit",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceControlUser"),
							},
						},
						"committer": {
							SchemaProps: spec.SchemaProps{
								Description: "committer is the committer of a specific commit",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.SourceControlUser"),
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "message is the description of a specific commit",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.SourceControlUser"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.ImageChangeCause": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageChangeCause contains information about the image that triggered a build",
					Properties: map[string]spec.Schema{
						"imageID": {
							SchemaProps: spec.SchemaProps{
								Description: "imageID is the ID of the image that triggered a a new build.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fromRef": {
							SchemaProps: spec.SchemaProps{
								Description: "fromRef contains detailed information about an image that triggered a build.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.ImageChangeTrigger": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageChangeTrigger allows builds to be triggered when an ImageStream changes",
					Properties: map[string]spec.Schema{
						"lastTriggeredImageID": {
							SchemaProps: spec.SchemaProps{
								Description: "lastTriggeredImageID is used internally by the ImageChangeController to save last used image ID for build",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "from is a reference to an ImageStreamTag that will trigger a build when updated It is optional. If no From is specified, the From image from the build strategy will be used. Only one ImageChangeTrigger with an empty From reference is allowed in a build configuration.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.ImageLabel": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageLabel represents a label applied to the resulting image.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name defines the name of the label. It must have non-zero length.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"value": {
							SchemaProps: spec.SchemaProps{
								Description: "value defines the literal value of the label.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.ImageSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageSource is used to describe build source that will be extracted from an image. A reference of type ImageStreamTag, ImageStreamImage or DockerImage may be used. A pull secret can be specified to pull the image from an external registry or override the default service account secret if pulling from the internal registry. A list of paths to copy from the image and their respective destination within the build directory must be specified in the paths array.",
					Properties: map[string]spec.Schema{
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "from is a reference to an ImageStreamTag, ImageStreamImage, or DockerImage to copy source from.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"paths": {
							SchemaProps: spec.SchemaProps{
								Description: "paths is a list of source and destination paths to copy from the image.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.ImageSourcePath"),
										},
									},
								},
							},
						},
						"pullSecret": {
							SchemaProps: spec.SchemaProps{
								Description: "pullSecret is a reference to a secret to be used to pull the image from a registry If the image is pulled from the OpenShift registry, this field does not need to be set.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
					},
					Required: []string{"from", "paths"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.ImageSourcePath", "k8s.io/kubernetes/pkg/api/v1.LocalObjectReference", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.ImageSourcePath": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageSourcePath describes a path to be copied from a source image and its destination within the build directory.",
					Properties: map[string]spec.Schema{
						"sourcePath": {
							SchemaProps: spec.SchemaProps{
								Description: "sourcePath is the absolute path of the file or directory inside the image to copy to the build directory.  If the source path ends in /. then the content of the directory will be copied, but the directory itself will not be created at the destination.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"destinationDir": {
							SchemaProps: spec.SchemaProps{
								Description: "destinationDir is the relative directory within the build directory where files copied from the image are placed.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"sourcePath", "destinationDir"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.JenkinsPipelineBuildStrategy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "JenkinsPipelineBuildStrategy holds parameters specific to a Jenkins Pipeline build. This strategy is in tech preview.",
					Properties: map[string]spec.Schema{
						"jenkinsfilePath": {
							SchemaProps: spec.SchemaProps{
								Description: "JenkinsfilePath is the optional path of the Jenkinsfile that will be used to configure the pipeline relative to the root of the context (contextDir). If both JenkinsfilePath & Jenkinsfile are both not specified, this defaults to Jenkinsfile in the root of the specified contextDir.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"jenkinsfile": {
							SchemaProps: spec.SchemaProps{
								Description: "Jenkinsfile defines the optional raw contents of a Jenkinsfile which defines a Jenkins pipeline build.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"env": {
							SchemaProps: spec.SchemaProps{
								Description: "env contains additional environment variables you want to pass into a build pipeline.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvVar"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.EnvVar"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.ProxyConfig": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ProxyConfig defines what proxies to use for an operation",
					Properties: map[string]spec.Schema{
						"httpProxy": {
							SchemaProps: spec.SchemaProps{
								Description: "httpProxy is a proxy used to reach the git repository over http",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"httpsProxy": {
							SchemaProps: spec.SchemaProps{
								Description: "httpsProxy is a proxy used to reach the git repository over https",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"noProxy": {
							SchemaProps: spec.SchemaProps{
								Description: "noProxy is the list of domains for which the proxy should not be used",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.SecretBuildSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SecretBuildSource describes a secret and its destination directory that will be used only at the build time. The content of the secret referenced here will be copied into the destination directory instead of mounting.",
					Properties: map[string]spec.Schema{
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "secret is a reference to an existing secret that you want to use in your build.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"destinationDir": {
							SchemaProps: spec.SchemaProps{
								Description: "destinationDir is the directory where the files from the secret should be available for the build time. For the Source build strategy, these will be injected into a container where the assemble script runs. Later, when the script finishes, all files injected will be truncated to zero length. For the Docker build strategy, these will be copied into the build directory, where the Dockerfile is located, so users can ADD or COPY them during docker build.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"secret"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.SecretSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SecretSpec specifies a secret to be included in a build pod and its corresponding mount point",
					Properties: map[string]spec.Schema{
						"secretSource": {
							SchemaProps: spec.SchemaProps{
								Description: "secretSource is a reference to the secret",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"mountPath": {
							SchemaProps: spec.SchemaProps{
								Description: "mountPath is the path at which to mount the secret",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"secretSource", "mountPath"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.SourceBuildStrategy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SourceBuildStrategy defines input parameters specific to an Source build.",
					Properties: map[string]spec.Schema{
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "from is reference to an DockerImage, ImageStreamTag, or ImageStreamImage from which the docker image should be pulled",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"pullSecret": {
							SchemaProps: spec.SchemaProps{
								Description: "pullSecret is the name of a Secret that would be used for setting up the authentication for pulling the Docker images from the private Docker registries",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"env": {
							SchemaProps: spec.SchemaProps{
								Description: "env contains additional environment variables you want to pass into a builder container.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvVar"),
										},
									},
								},
							},
						},
						"scripts": {
							SchemaProps: spec.SchemaProps{
								Description: "scripts is the location of Source scripts",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"incremental": {
							SchemaProps: spec.SchemaProps{
								Description: "incremental flag forces the Source build to do incremental builds if true.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"forcePull": {
							SchemaProps: spec.SchemaProps{
								Description: "forcePull describes if the builder should pull the images from registry prior to building.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"runtimeImage": {
							SchemaProps: spec.SchemaProps{
								Description: "runtimeImage is an optional image that is used to run an application without unneeded dependencies installed. The building of the application is still done in the builder image but, post build, you can copy the needed artifacts in the runtime image for use. Deprecated: This feature will be removed in a future release. Use ImageSource to copy binary artifacts created from one build into a separate runtime image.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"runtimeArtifacts": {
							SchemaProps: spec.SchemaProps{
								Description: "runtimeArtifacts specifies a list of source/destination pairs that will be copied from the builder to the runtime image. sourcePath can be a file or directory. destinationDir must be a directory. destinationDir can also be empty or equal to \".\", in this case it just refers to the root of WORKDIR. Deprecated: This feature will be removed in a future release. Use ImageSource to copy binary artifacts created from one build into a separate runtime image.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.ImageSourcePath"),
										},
									},
								},
							},
						},
					},
					Required: []string{"from"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.ImageSourcePath", "k8s.io/kubernetes/pkg/api/v1.EnvVar", "k8s.io/kubernetes/pkg/api/v1.LocalObjectReference", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.SourceControlUser": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SourceControlUser defines the identity of a user of source control",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name of the source control user",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"email": {
							SchemaProps: spec.SchemaProps{
								Description: "email of the source control user",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.SourceRevision": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SourceRevision is the revision or commit information from the source for the build",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "type of the build source, may be one of 'Source', 'Dockerfile', 'Binary', or 'Images'",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"git": {
							SchemaProps: spec.SchemaProps{
								Description: "Git contains information about git-based build source",
								Ref:         ref("github.com/openshift/origin/pkg/build/apis/build/v1.GitSourceRevision"),
							},
						},
					},
					Required: []string{"type"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.GitSourceRevision"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.StageInfo": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "StageInfo contains details about a build stage.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name is a unique identifier for each build stage that occurs.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"startTime": {
							SchemaProps: spec.SchemaProps{
								Description: "startTime is a timestamp representing the server time when this Stage started. It is represented in RFC3339 form and is in UTC.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"durationMilliseconds": {
							SchemaProps: spec.SchemaProps{
								Description: "durationMilliseconds identifies how long the stage took to complete in milliseconds. Note: the duration of a stage can exceed the sum of the duration of the steps within the stage as not all actions are accounted for in explicit build steps.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"steps": {
							SchemaProps: spec.SchemaProps{
								Description: "steps contains details about each step that occurs during a build stage including start time and duration in milliseconds.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/build/apis/build/v1.StepInfo"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/build/apis/build/v1.StepInfo", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.StepInfo": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "StepInfo contains details about a build step.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name is a unique identifier for each build step.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"startTime": {
							SchemaProps: spec.SchemaProps{
								Description: "startTime is a timestamp representing the server time when this Step started. it is represented in RFC3339 form and is in UTC.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"durationMilliseconds": {
							SchemaProps: spec.SchemaProps{
								Description: "durationMilliseconds identifies how long the step took to complete in milliseconds.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/build/apis/build/v1.WebHookTrigger": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "WebHookTrigger is a trigger that gets invoked using a webhook type of post",
					Properties: map[string]spec.Schema{
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "secret used to validate requests.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"allowEnv": {
							SchemaProps: spec.SchemaProps{
								Description: "allowEnv determines whether the webhook can set environment variables; can only be set to true for GenericWebHook.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.CustomDeploymentStrategyParams": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "CustomDeploymentStrategyParams are the input to the Custom deployment strategy.",
					Properties: map[string]spec.Schema{
						"image": {
							SchemaProps: spec.SchemaProps{
								Description: "Image specifies a Docker image which can carry out a deployment.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"environment": {
							SchemaProps: spec.SchemaProps{
								Description: "Environment holds the environment which will be given to the container for Image.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvVar"),
										},
									},
								},
							},
						},
						"command": {
							SchemaProps: spec.SchemaProps{
								Description: "Command is optional and overrides CMD in the container Image.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.EnvVar"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentCause": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentCause captures information about a particular cause of a deployment.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of the trigger that resulted in the creation of a new deployment",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"imageTrigger": {
							SchemaProps: spec.SchemaProps{
								Description: "ImageTrigger contains the image trigger details, if this trigger was fired based on an image change",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentCauseImageTrigger"),
							},
						},
					},
					Required: []string{"type"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentCauseImageTrigger"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentCauseImageTrigger": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentCauseImageTrigger represents details about the cause of a deployment originating from an image change trigger",
					Properties: map[string]spec.Schema{
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "From is a reference to the changed object which triggered a deployment. The field may have the kinds DockerImage, ImageStreamTag, or ImageStreamImage.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
					Required: []string{"from"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentCondition describes the state of a deployment config at a certain point.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of deployment condition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of True, False, Unknown.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastUpdateTime": {
							SchemaProps: spec.SchemaProps{
								Description: "The last time this condition was updated.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "The last time the condition transitioned from one status to another.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "The reason for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "A human readable message indicating details about the transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfig": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Deployment Configs define the template for a pod and manages deploying new images or configuration changes. A single deployment configuration is usually analogous to a single micro-service. Can support many different deployment patterns, including full restart, customizable rolling updates, and  fully custom behaviors, as well as pre- and post- deployment hooks. Each individual deployment is represented as a replication controller.\n\nA deployment is \"triggered\" when its configuration is changed or a tag in an Image Stream is changed. Triggers can be disabled to allow manual control over a deployment. The \"strategy\" determines how the deployment is carried out and may be changed at any time. The `latestVersion` field is updated when a new deployment is triggered by any means.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec represents a desired deployment state and how to deploy to it.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfigSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status represents the current deployment state.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfigStatus"),
							},
						},
					},
					Required: []string{"spec", "status"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfigSpec", "github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfigStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfigList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentConfigList is a collection of deployment configs.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of deployment configs",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfig"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfig", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfigRollback": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentConfigRollback provides the input to rollback generation.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the deployment config that will be rolled back.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"updatedAnnotations": {
							SchemaProps: spec.SchemaProps{
								Description: "UpdatedAnnotations is a set of new annotations that will be added in the deployment config.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the options to rollback generation.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfigRollbackSpec"),
							},
						},
					},
					Required: []string{"name", "spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfigRollbackSpec"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfigRollbackSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentConfigRollbackSpec represents the options for rollback generation.",
					Properties: map[string]spec.Schema{
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "From points to a ReplicationController which is a deployment.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "Revision to rollback to. If set to 0, rollback to the last revision.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"includeTriggers": {
							SchemaProps: spec.SchemaProps{
								Description: "IncludeTriggers specifies whether to include config Triggers.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"includeTemplate": {
							SchemaProps: spec.SchemaProps{
								Description: "IncludeTemplate specifies whether to include the PodTemplateSpec.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"includeReplicationMeta": {
							SchemaProps: spec.SchemaProps{
								Description: "IncludeReplicationMeta specifies whether to include the replica count and selector.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"includeStrategy": {
							SchemaProps: spec.SchemaProps{
								Description: "IncludeStrategy specifies whether to include the deployment Strategy.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"from", "includeTriggers", "includeTemplate", "includeReplicationMeta", "includeStrategy"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfigSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentConfigSpec represents the desired state of the deployment.",
					Properties: map[string]spec.Schema{
						"strategy": {
							SchemaProps: spec.SchemaProps{
								Description: "Strategy describes how a deployment is executed.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentStrategy"),
							},
						},
						"minReadySeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "MinReadySeconds is the minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"triggers": {
							SchemaProps: spec.SchemaProps{
								Description: "Triggers determine how updates to a DeploymentConfig result in new deployments. If no triggers are defined, a new deployment can only occur as a result of an explicit client update to the DeploymentConfig with a new LatestVersion. If null, defaults to having a config change trigger.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentTriggerPolicy"),
										},
									},
								},
							},
						},
						"replicas": {
							SchemaProps: spec.SchemaProps{
								Description: "Replicas is the number of desired replicas.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"revisionHistoryLimit": {
							SchemaProps: spec.SchemaProps{
								Description: "RevisionHistoryLimit is the number of old ReplicationControllers to retain to allow for rollbacks. This field is a pointer to allow for differentiation between an explicit zero and not specified. Defaults to 10. (This only applies to DeploymentConfigs created via the new group API resource, not the legacy resource.)",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"test": {
							SchemaProps: spec.SchemaProps{
								Description: "Test ensures that this deployment config will have zero replicas except while a deployment is running. This allows the deployment config to be used as a continuous deployment test - triggering on images, running the deployment, and then succeeding or failing. Post strategy hooks and After actions can be used to integrate successful deployment with an action.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"paused": {
							SchemaProps: spec.SchemaProps{
								Description: "Paused indicates that the deployment config is paused resulting in no new deployments on template changes or changes in the template caused by other triggers.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"selector": {
							SchemaProps: spec.SchemaProps{
								Description: "Selector is a label query over pods that should match the Replicas count.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"template": {
							SchemaProps: spec.SchemaProps{
								Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"),
							},
						},
					},
					Required: []string{"strategy", "triggers", "replicas", "test"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentStrategy", "github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentTriggerPolicy", "k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentConfigStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentConfigStatus represents the current deployment state.",
					Properties: map[string]spec.Schema{
						"latestVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "LatestVersion is used to determine whether the current deployment associated with a deployment config is out of sync.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"observedGeneration": {
							SchemaProps: spec.SchemaProps{
								Description: "ObservedGeneration is the most recent generation observed by the deployment config controller.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"replicas": {
							SchemaProps: spec.SchemaProps{
								Description: "Replicas is the total number of pods targeted by this deployment config.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"updatedReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "UpdatedReplicas is the total number of non-terminated pods targeted by this deployment config that have the desired template spec.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"availableReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "AvailableReplicas is the total number of available pods targeted by this deployment config.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"unavailableReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "UnavailableReplicas is the total number of unavailable pods targeted by this deployment config.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"details": {
							SchemaProps: spec.SchemaProps{
								Description: "Details are the reasons for the update to this deployment config. This could be based on a change made by the user or caused by an automatic trigger",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentDetails"),
							},
						},
						"conditions": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "type",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Conditions represents the latest available observations of a deployment config's current state.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentCondition"),
										},
									},
								},
							},
						},
						"readyReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "Total number of ready pods targeted by this deployment.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"latestVersion", "observedGeneration", "replicas", "updatedReplicas", "availableReplicas", "unavailableReplicas"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentCondition", "github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentDetails"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentDetails": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentDetails captures information about the causes of a deployment.",
					Properties: map[string]spec.Schema{
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Message is the user specified change message, if this deployment was triggered manually by the user",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"causes": {
							SchemaProps: spec.SchemaProps{
								Description: "Causes are extended data associated with all the causes for creating a new deployment",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentCause"),
										},
									},
								},
							},
						},
					},
					Required: []string{"causes"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentCause"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentLog": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentLog represents the logs for a deployment",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentLogOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentLogOptions is the REST options for a deployment log",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"container": {
							SchemaProps: spec.SchemaProps{
								Description: "The container for which to stream logs. Defaults to only container if there is one container in the pod.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"follow": {
							SchemaProps: spec.SchemaProps{
								Description: "Follow if true indicates that the build log should be streamed until the build terminates.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"previous": {
							SchemaProps: spec.SchemaProps{
								Description: "Return previous deployment logs. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"sinceSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "A relative time in seconds before the current time from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"sinceTime": {
							SchemaProps: spec.SchemaProps{
								Description: "An RFC3339 timestamp from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"timestamps": {
							SchemaProps: spec.SchemaProps{
								Description: "If true, add an RFC3339 or RFC3339Nano timestamp at the beginning of every line of log output. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"tailLines": {
							SchemaProps: spec.SchemaProps{
								Description: "If set, the number of lines from the end of the logs to show. If not specified, logs are shown from the creation of the container or sinceSeconds or sinceTime",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"limitBytes": {
							SchemaProps: spec.SchemaProps{
								Description: "If set, the number of bytes to read from the server before terminating the log output. This may not display a complete final line of logging, and may return slightly more or slightly less than the specified limit.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"nowait": {
							SchemaProps: spec.SchemaProps{
								Description: "NoWait if true causes the call to return immediately even if the deployment is not available yet. Otherwise the server will wait until the deployment has started.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"version": {
							SchemaProps: spec.SchemaProps{
								Description: "Version of the deployment for which to view logs.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentRequest": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentRequest is a request to a deployment config for a new deployment.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the deployment config for requesting a new deployment.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"latest": {
							SchemaProps: spec.SchemaProps{
								Description: "Latest will update the deployment config with the latest state from all triggers.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"force": {
							SchemaProps: spec.SchemaProps{
								Description: "Force will try to force a new deployment to run. If the deployment config is paused, then setting this to true will return an Invalid error.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"excludeTriggers": {
							SchemaProps: spec.SchemaProps{
								Description: "ExcludeTriggers instructs the instantiator to avoid processing the specified triggers. This field overrides the triggers from latest and allows clients to control specific logic. This field is ignored if not specified.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"name", "latest", "force"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentStrategy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentStrategy describes how to perform a deployment.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type is the name of a deployment strategy.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"customParams": {
							SchemaProps: spec.SchemaProps{
								Description: "CustomParams are the input to the Custom deployment strategy, and may also be specified for the Recreate and Rolling strategies to customize the execution process that runs the deployment.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.CustomDeploymentStrategyParams"),
							},
						},
						"recreateParams": {
							SchemaProps: spec.SchemaProps{
								Description: "RecreateParams are the input to the Recreate deployment strategy.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.RecreateDeploymentStrategyParams"),
							},
						},
						"rollingParams": {
							SchemaProps: spec.SchemaProps{
								Description: "RollingParams are the input to the Rolling deployment strategy.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.RollingDeploymentStrategyParams"),
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "Resources contains resource requirements to execute the deployment and any hooks.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceRequirements"),
							},
						},
						"labels": {
							SchemaProps: spec.SchemaProps{
								Description: "Labels is a set of key, value pairs added to custom deployer and lifecycle pre/post hook pods.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"annotations": {
							SchemaProps: spec.SchemaProps{
								Description: "Annotations is a set of key, value pairs added to custom deployer and lifecycle pre/post hook pods.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"activeDeadlineSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "ActiveDeadlineSeconds is the duration in seconds that the deployer pods for this deployment config may be active on a node before the system actively tries to terminate them.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.CustomDeploymentStrategyParams", "github.com/openshift/origin/pkg/deploy/apis/apps/v1.RecreateDeploymentStrategyParams", "github.com/openshift/origin/pkg/deploy/apis/apps/v1.RollingDeploymentStrategyParams", "k8s.io/kubernetes/pkg/api/v1.ResourceRequirements"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentTriggerImageChangeParams": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentTriggerImageChangeParams represents the parameters to the ImageChange trigger.",
					Properties: map[string]spec.Schema{
						"automatic": {
							SchemaProps: spec.SchemaProps{
								Description: "Automatic means that the detection of a new tag value should result in an image update inside the pod template.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"containerNames": {
							SchemaProps: spec.SchemaProps{
								Description: "ContainerNames is used to restrict tag updates to the specified set of container names in a pod. If multiple triggers point to the same containers, the resulting behavior is undefined. Future API versions will make this a validation error. If ContainerNames does not point to a valid container, the trigger will be ignored. Future API versions will make this a validation error.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "From is a reference to an image stream tag to watch for changes. From.Name is the only required subfield - if From.Namespace is blank, the namespace of the current deployment trigger will be used.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"lastTriggeredImage": {
							SchemaProps: spec.SchemaProps{
								Description: "LastTriggeredImage is the last image to be triggered.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"from"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentTriggerPolicy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentTriggerPolicy describes a policy for a single trigger that results in a new deployment.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of the trigger",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"imageChangeParams": {
							SchemaProps: spec.SchemaProps{
								Description: "ImageChangeParams represents the parameters for the ImageChange trigger.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentTriggerImageChangeParams"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.DeploymentTriggerImageChangeParams"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.ExecNewPodHook": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ExecNewPodHook is a hook implementation which runs a command in a new pod based on the specified container which is assumed to be part of the deployment template.",
					Properties: map[string]spec.Schema{
						"command": {
							SchemaProps: spec.SchemaProps{
								Description: "Command is the action command and its arguments.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"env": {
							SchemaProps: spec.SchemaProps{
								Description: "Env is a set of environment variables to supply to the hook pod's container.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvVar"),
										},
									},
								},
							},
						},
						"containerName": {
							SchemaProps: spec.SchemaProps{
								Description: "ContainerName is the name of a container in the deployment pod template whose Docker image will be used for the hook pod's container.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"volumes": {
							SchemaProps: spec.SchemaProps{
								Description: "Volumes is a list of named volumes from the pod template which should be copied to the hook pod. Volumes names not found in pod spec are ignored. An empty list means no volumes will be copied.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"command", "containerName"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.EnvVar"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.LifecycleHook": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "LifecycleHook defines a specific deployment lifecycle action. Only one type of action may be specified at any time.",
					Properties: map[string]spec.Schema{
						"failurePolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "FailurePolicy specifies what action to take if the hook fails.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"execNewPod": {
							SchemaProps: spec.SchemaProps{
								Description: "ExecNewPod specifies the options for a lifecycle hook backed by a pod.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.ExecNewPodHook"),
							},
						},
						"tagImages": {
							SchemaProps: spec.SchemaProps{
								Description: "TagImages instructs the deployer to tag the current image referenced under a container onto an image stream tag.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.TagImageHook"),
										},
									},
								},
							},
						},
					},
					Required: []string{"failurePolicy"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.ExecNewPodHook", "github.com/openshift/origin/pkg/deploy/apis/apps/v1.TagImageHook"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.RecreateDeploymentStrategyParams": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RecreateDeploymentStrategyParams are the input to the Recreate deployment strategy.",
					Properties: map[string]spec.Schema{
						"timeoutSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "TimeoutSeconds is the time to wait for updates before giving up. If the value is nil, a default will be used.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"pre": {
							SchemaProps: spec.SchemaProps{
								Description: "Pre is a lifecycle hook which is executed before the strategy manipulates the deployment. All LifecycleHookFailurePolicy values are supported.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.LifecycleHook"),
							},
						},
						"mid": {
							SchemaProps: spec.SchemaProps{
								Description: "Mid is a lifecycle hook which is executed while the deployment is scaled down to zero before the first new pod is created. All LifecycleHookFailurePolicy values are supported.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.LifecycleHook"),
							},
						},
						"post": {
							SchemaProps: spec.SchemaProps{
								Description: "Post is a lifecycle hook which is executed after the strategy has finished all deployment logic. All LifecycleHookFailurePolicy values are supported.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.LifecycleHook"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.LifecycleHook"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.RollingDeploymentStrategyParams": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RollingDeploymentStrategyParams are the input to the Rolling deployment strategy.",
					Properties: map[string]spec.Schema{
						"updatePeriodSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "UpdatePeriodSeconds is the time to wait between individual pod updates. If the value is nil, a default will be used.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"intervalSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "IntervalSeconds is the time to wait between polling deployment status after update. If the value is nil, a default will be used.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"timeoutSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "TimeoutSeconds is the time to wait for updates before giving up. If the value is nil, a default will be used.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"maxUnavailable": {
							SchemaProps: spec.SchemaProps{
								Description: "MaxUnavailable is the maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total pods at the start of update (ex: 10%). Absolute number is calculated from percentage by rounding down.\n\nThis cannot be 0 if MaxSurge is 0. By default, 25% is used.\n\nExample: when this is set to 30%, the old RC can be scaled down by 30% immediately when the rolling update starts. Once new pods are ready, old RC can be scaled down further, followed by scaling up the new RC, ensuring that at least 70% of original number of pods are available at all times during the update.",
								Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
							},
						},
						"maxSurge": {
							SchemaProps: spec.SchemaProps{
								Description: "MaxSurge is the maximum number of pods that can be scheduled above the original number of pods. Value can be an absolute number (ex: 5) or a percentage of total pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up.\n\nThis cannot be 0 if MaxUnavailable is 0. By default, 25% is used.\n\nExample: when this is set to 30%, the new RC can be scaled up by 30% immediately when the rolling update starts. Once old pods have been killed, new RC can be scaled up further, ensuring that total number of pods running at any time during the update is atmost 130% of original pods.",
								Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
							},
						},
						"pre": {
							SchemaProps: spec.SchemaProps{
								Description: "Pre is a lifecycle hook which is executed before the deployment process begins. All LifecycleHookFailurePolicy values are supported.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.LifecycleHook"),
							},
						},
						"post": {
							SchemaProps: spec.SchemaProps{
								Description: "Post is a lifecycle hook which is executed after the strategy has finished all deployment logic. All LifecycleHookFailurePolicy values are supported.",
								Ref:         ref("github.com/openshift/origin/pkg/deploy/apis/apps/v1.LifecycleHook"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/deploy/apis/apps/v1.LifecycleHook", "k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
		},
		"github.com/openshift/origin/pkg/deploy/apis/apps/v1.TagImageHook": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TagImageHook is a request to tag the image in a particular container onto an ImageStreamTag.",
					Properties: map[string]spec.Schema{
						"containerName": {
							SchemaProps: spec.SchemaProps{
								Description: "ContainerName is the name of a container in the deployment config whose image value will be used as the source of the tag. If there is only a single container this value will be defaulted to the name of that container.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"to": {
							SchemaProps: spec.SchemaProps{
								Description: "To is the target ImageStreamTag to set the container's image onto.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
					Required: []string{"containerName", "to"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.DockerImageReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DockerImageReference points to a Docker image.",
					Properties: map[string]spec.Schema{
						"Registry": {
							SchemaProps: spec.SchemaProps{
								Description: "Registry is the registry that contains the Docker image",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"Namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the namespace that contains the Docker image",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"Name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name is the name of the Docker image",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"Tag": {
							SchemaProps: spec.SchemaProps{
								Description: "Tag is which tag of the Docker image is being referenced",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"ID": {
							SchemaProps: spec.SchemaProps{
								Description: "ID is the identifier for the Docker image",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"Registry", "Namespace", "Name", "Tag", "ID"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.Image": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Image is an immutable representation of a Docker image and metadata at a point in time.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"dockerImageReference": {
							SchemaProps: spec.SchemaProps{
								Description: "DockerImageReference is the string that can be used to pull this image.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"dockerImageMetadata": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-strategy": "replace",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "DockerImageMetadata contains metadata about this image",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
						"dockerImageMetadataVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "DockerImageMetadataVersion conveys the version of the object, which if empty defaults to \"1.0\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"dockerImageManifest": {
							SchemaProps: spec.SchemaProps{
								Description: "DockerImageManifest is the raw JSON of the manifest",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"dockerImageLayers": {
							SchemaProps: spec.SchemaProps{
								Description: "DockerImageLayers represents the layers in the image. May not be set if the image does not define that data.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageLayer"),
										},
									},
								},
							},
						},
						"signatures": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "name",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Signatures holds all signatures of the image.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageSignature"),
										},
									},
								},
							},
						},
						"dockerImageSignatures": {
							SchemaProps: spec.SchemaProps{
								Description: "DockerImageSignatures provides the signatures as opaque blobs. This is a part of manifest schema v1.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "byte",
										},
									},
								},
							},
						},
						"dockerImageManifestMediaType": {
							SchemaProps: spec.SchemaProps{
								Description: "DockerImageManifestMediaType specifies the mediaType of manifest. This is a part of manifest schema v2.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"dockerImageConfig": {
							SchemaProps: spec.SchemaProps{
								Description: "DockerImageConfig is a JSON blob that the runtime uses to set up the container. This is a part of manifest schema v2.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"dockerImageLayers"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.ImageLayer", "github.com/openshift/origin/pkg/image/apis/image/v1.ImageSignature", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageImportSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageImportSpec describes a request to import a specific image.",
					Properties: map[string]spec.Schema{
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "From is the source of an image to import; only kind DockerImage is allowed",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"to": {
							SchemaProps: spec.SchemaProps{
								Description: "To is a tag in the current image stream to assign the imported image to, if name is not specified the default tag from from.name will be used",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"importPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "ImportPolicy is the policy controlling how the image is imported",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.TagImportPolicy"),
							},
						},
						"referencePolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "ReferencePolicy defines how other components should consume the image",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.TagReferencePolicy"),
							},
						},
						"includeManifest": {
							SchemaProps: spec.SchemaProps{
								Description: "IncludeManifest determines if the manifest for each image is returned in the response",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"from"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.TagImportPolicy", "github.com/openshift/origin/pkg/image/apis/image/v1.TagReferencePolicy", "k8s.io/kubernetes/pkg/api/v1.LocalObjectReference", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageImportStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageImportStatus describes the result of an image import.",
					Properties: map[string]spec.Schema{
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status is the status of the image import, including errors encountered while retrieving the image",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Status"),
							},
						},
						"image": {
							SchemaProps: spec.SchemaProps{
								Description: "Image is the metadata of that image, if the image was located",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.Image"),
							},
						},
						"tag": {
							SchemaProps: spec.SchemaProps{
								Description: "Tag is the tag this image was located under, if any",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"status"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.Image", "k8s.io/apimachinery/pkg/apis/meta/v1.Status"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageLayer": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageLayer represents a single layer of the image. Some images may have multiple layers. Some may have none.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the layer as defined by the underlying store.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"size": {
							SchemaProps: spec.SchemaProps{
								Description: "Size of the layer in bytes as defined by the underlying store.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"mediaType": {
							SchemaProps: spec.SchemaProps{
								Description: "MediaType of the referenced object.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name", "size", "mediaType"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageList is a list of Image objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of images",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.Image"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.Image", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageLookupPolicy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageLookupPolicy describes how an image stream can be used to override the image references used by pods, builds, and other resources in a namespace.",
					Properties: map[string]spec.Schema{
						"local": {
							SchemaProps: spec.SchemaProps{
								Description: "local will change the docker short image references (like \"mysql\" or \"php:latest\") on objects in this namespace to the image ID whenever they match this image stream, instead of reaching out to a remote registry. The name will be fully qualified to an image ID if found. The tag's referencePolicy is taken into account on the replaced value. Only works within the current namespace.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"local"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageSignature": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageSignature holds a signature of an image. It allows to verify image identity and possibly other claims as long as the signature is trusted. Based on this information it is possible to restrict runnable images to those matching cluster-wide policy. Mandatory fields should be parsed by clients doing image verification. The others are parsed from signature's content by the server. They serve just an informative purpose.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Required: Describes a type of stored blob.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"content": {
							SchemaProps: spec.SchemaProps{
								Description: "Required: An opaque binary string which is an image's signature.",
								Type:        []string{"string"},
								Format:      "byte",
							},
						},
						"conditions": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "type",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Conditions represent the latest available observations of a signature's current state.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.SignatureCondition"),
										},
									},
								},
							},
						},
						"imageIdentity": {
							SchemaProps: spec.SchemaProps{
								Description: "A human readable string representing image's identity. It could be a product name and version, or an image pull spec (e.g. \"registry.access.redhat.com/rhel7/rhel:7.2\").",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"signedClaims": {
							SchemaProps: spec.SchemaProps{
								Description: "Contains claims from the signature.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"created": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, it is the time of signature's creation.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"issuedBy": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, it holds information about an issuer of signing certificate or key (a person or entity who signed the signing certificate or key).",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.SignatureIssuer"),
							},
						},
						"issuedTo": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, it holds information about a subject of signing certificate or key (a person or entity who signed the image).",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.SignatureSubject"),
							},
						},
					},
					Required: []string{"type", "content"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.SignatureCondition", "github.com/openshift/origin/pkg/image/apis/image/v1.SignatureIssuer", "github.com/openshift/origin/pkg/image/apis/image/v1.SignatureSubject", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStream": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageStream stores a mapping of tags to images, metadata overrides that are applied when images are tagged in a stream, and an optional reference to a Docker image repository on a registry.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec describes the desired state of this stream",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status describes the current state of this stream",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamStatus"),
							},
						},
					},
					Required: []string{"spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamSpec", "github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamImage": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageStreamImage represents an Image that is retrieved by image name from an ImageStream.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"image": {
							SchemaProps: spec.SchemaProps{
								Description: "Image associated with the ImageStream and image name.",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.Image"),
							},
						},
					},
					Required: []string{"image"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.Image", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamImport": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "The image stream import resource provides an easy way for a user to find and import Docker images from other Docker registries into the server. Individual images or an entire image repository may be imported, and users may choose to see the results of the import prior to tagging the resulting images into the specified image stream.\n\nThis API is intended for end-user tools that need to see the metadata of the image prior to import (for instance, to generate an application from it). Clients that know the desired image can continue to create spec.tags directly into their image streams.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec is a description of the images that the user wishes to import",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamImportSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status is the the result of importing the image",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamImportStatus"),
							},
						},
					},
					Required: []string{"spec", "status"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamImportSpec", "github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamImportStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamImportSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageStreamImportSpec defines what images should be imported.",
					Properties: map[string]spec.Schema{
						"import": {
							SchemaProps: spec.SchemaProps{
								Description: "Import indicates whether to perform an import - if so, the specified tags are set on the spec and status of the image stream defined by the type meta.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"repository": {
							SchemaProps: spec.SchemaProps{
								Description: "Repository is an optional import of an entire Docker image repository. A maximum limit on the number of tags imported this way is imposed by the server.",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.RepositoryImportSpec"),
							},
						},
						"images": {
							SchemaProps: spec.SchemaProps{
								Description: "Images are a list of individual images to import.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageImportSpec"),
										},
									},
								},
							},
						},
					},
					Required: []string{"import"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.ImageImportSpec", "github.com/openshift/origin/pkg/image/apis/image/v1.RepositoryImportSpec"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamImportStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageStreamImportStatus contains information about the status of an image stream import.",
					Properties: map[string]spec.Schema{
						"import": {
							SchemaProps: spec.SchemaProps{
								Description: "Import is the image stream that was successfully updated or created when 'to' was set.",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageStream"),
							},
						},
						"repository": {
							SchemaProps: spec.SchemaProps{
								Description: "Repository is set if spec.repository was set to the outcome of the import",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.RepositoryImportStatus"),
							},
						},
						"images": {
							SchemaProps: spec.SchemaProps{
								Description: "Images is set with the result of importing spec.images",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageImportStatus"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.ImageImportStatus", "github.com/openshift/origin/pkg/image/apis/image/v1.ImageStream", "github.com/openshift/origin/pkg/image/apis/image/v1.RepositoryImportStatus"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageStreamList is a list of ImageStream objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of imageStreams",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageStream"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStream", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamMapping": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageStreamMapping represents a mapping from a single tag to a Docker image as well as the reference to the Docker image stream the image came from.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"image": {
							SchemaProps: spec.SchemaProps{
								Description: "Image is a Docker image.",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.Image"),
							},
						},
						"tag": {
							SchemaProps: spec.SchemaProps{
								Description: "Tag is a string value this image can be located with inside the stream.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"image", "tag"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.Image", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageStreamSpec represents options for ImageStreams.",
					Properties: map[string]spec.Schema{
						"lookupPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "lookupPolicy controls how other resources reference images within this namespace.",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageLookupPolicy"),
							},
						},
						"dockerImageRepository": {
							SchemaProps: spec.SchemaProps{
								Description: "dockerImageRepository is optional, if specified this stream is backed by a Docker repository on this server",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"tags": {
							SchemaProps: spec.SchemaProps{
								Description: "tags map arbitrary string values to specific image locators",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.TagReference"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.ImageLookupPolicy", "github.com/openshift/origin/pkg/image/apis/image/v1.TagReference"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageStreamStatus contains information about the state of this image stream.",
					Properties: map[string]spec.Schema{
						"dockerImageRepository": {
							SchemaProps: spec.SchemaProps{
								Description: "DockerImageRepository represents the effective location this stream may be accessed at. May be empty until the server determines where the repository is located",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"publicDockerImageRepository": {
							SchemaProps: spec.SchemaProps{
								Description: "PublicDockerImageRepository represents the public location from where the image can be pulled outside the cluster. This field may be empty if the administrator has not exposed the integrated registry externally.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"tags": {
							SchemaProps: spec.SchemaProps{
								Description: "Tags are a historical record of images associated with each tag. The first entry in the TagEvent array is the currently tagged image.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.NamedTagEventList"),
										},
									},
								},
							},
						},
					},
					Required: []string{"dockerImageRepository"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.NamedTagEventList"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamTag": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageStreamTag represents an Image that is retrieved by tag name from an ImageStream.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"tag": {
							SchemaProps: spec.SchemaProps{
								Description: "tag is the spec tag associated with this image stream tag, and it may be null if only pushes have occurred to this image stream.",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.TagReference"),
							},
						},
						"generation": {
							SchemaProps: spec.SchemaProps{
								Description: "generation is the current generation of the tagged image - if tag is provided and this value is not equal to the tag generation, a user has requested an import that has not completed, or conditions will be filled out indicating any error.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"lookupPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "lookupPolicy indicates whether this tag will handle image references in this namespace.",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageLookupPolicy"),
							},
						},
						"conditions": {
							SchemaProps: spec.SchemaProps{
								Description: "conditions is an array of conditions that apply to the image stream tag.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.TagEventCondition"),
										},
									},
								},
							},
						},
						"image": {
							SchemaProps: spec.SchemaProps{
								Description: "image associated with the ImageStream and tag.",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.Image"),
							},
						},
					},
					Required: []string{"tag", "generation", "lookupPolicy", "image"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.Image", "github.com/openshift/origin/pkg/image/apis/image/v1.ImageLookupPolicy", "github.com/openshift/origin/pkg/image/apis/image/v1.TagEventCondition", "github.com/openshift/origin/pkg/image/apis/image/v1.TagReference", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamTagList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ImageStreamTagList is a list of ImageStreamTag objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of image stream tags",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamTag"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.ImageStreamTag", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.NamedTagEventList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NamedTagEventList relates a tag to its image history.",
					Properties: map[string]spec.Schema{
						"tag": {
							SchemaProps: spec.SchemaProps{
								Description: "Tag is the tag for which the history is recorded",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.TagEvent"),
										},
									},
								},
							},
						},
						"conditions": {
							SchemaProps: spec.SchemaProps{
								Description: "Conditions is an array of conditions that apply to the tag event list.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.TagEventCondition"),
										},
									},
								},
							},
						},
					},
					Required: []string{"tag", "items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.TagEvent", "github.com/openshift/origin/pkg/image/apis/image/v1.TagEventCondition"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.RepositoryImportSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RepositoryImportSpec describes a request to import images from a Docker image repository.",
					Properties: map[string]spec.Schema{
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "From is the source for the image repository to import; only kind DockerImage and a name of a Docker image repository is allowed",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"importPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "ImportPolicy is the policy controlling how the image is imported",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.TagImportPolicy"),
							},
						},
						"referencePolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "ReferencePolicy defines how other components should consume the image",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.TagReferencePolicy"),
							},
						},
						"includeManifest": {
							SchemaProps: spec.SchemaProps{
								Description: "IncludeManifest determines if the manifest for each image is returned in the response",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"from"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.TagImportPolicy", "github.com/openshift/origin/pkg/image/apis/image/v1.TagReferencePolicy", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.RepositoryImportStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RepositoryImportStatus describes the result of an image repository import",
					Properties: map[string]spec.Schema{
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status reflects whether any failure occurred during import",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Status"),
							},
						},
						"images": {
							SchemaProps: spec.SchemaProps{
								Description: "Images is a list of images successfully retrieved by the import of the repository.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/image/apis/image/v1.ImageImportStatus"),
										},
									},
								},
							},
						},
						"additionalTags": {
							SchemaProps: spec.SchemaProps{
								Description: "AdditionalTags are tags that exist in the repository but were not imported because a maximum limit of automatic imports was applied.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.ImageImportStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.Status"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.SignatureCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SignatureCondition describes an image signature condition of particular kind at particular probe time.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of signature condition, Complete or Failed.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of True, False, Unknown.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastProbeTime": {
							SchemaProps: spec.SchemaProps{
								Description: "Last time the condition was checked.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "Last time the condition transit from one status to another.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "(brief) reason for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Human readable message indicating details about last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.SignatureGenericEntity": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SignatureGenericEntity holds a generic information about a person or entity who is an issuer or a subject of signing certificate or key.",
					Properties: map[string]spec.Schema{
						"organization": {
							SchemaProps: spec.SchemaProps{
								Description: "Organization name.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"commonName": {
							SchemaProps: spec.SchemaProps{
								Description: "Common name (e.g. openshift-signing-service).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.SignatureIssuer": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SignatureIssuer holds information about an issuer of signing certificate or key.",
					Properties: map[string]spec.Schema{
						"organization": {
							SchemaProps: spec.SchemaProps{
								Description: "Organization name.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"commonName": {
							SchemaProps: spec.SchemaProps{
								Description: "Common name (e.g. openshift-signing-service).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.SignatureSubject": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SignatureSubject holds information about a person or entity who created the signature.",
					Properties: map[string]spec.Schema{
						"organization": {
							SchemaProps: spec.SchemaProps{
								Description: "Organization name.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"commonName": {
							SchemaProps: spec.SchemaProps{
								Description: "Common name (e.g. openshift-signing-service).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"publicKeyID": {
							SchemaProps: spec.SchemaProps{
								Description: "If present, it is a human readable key id of public key belonging to the subject used to verify image signature. It should contain at least 64 lowest bits of public key's fingerprint (e.g. 0x685ebe62bf278440).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"publicKeyID"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.TagEvent": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TagEvent is used by ImageStreamStatus to keep a historical record of images associated with a tag.",
					Properties: map[string]spec.Schema{
						"created": {
							SchemaProps: spec.SchemaProps{
								Description: "Created holds the time the TagEvent was created",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"dockerImageReference": {
							SchemaProps: spec.SchemaProps{
								Description: "DockerImageReference is the string that can be used to pull this image",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"image": {
							SchemaProps: spec.SchemaProps{
								Description: "Image is the image",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"generation": {
							SchemaProps: spec.SchemaProps{
								Description: "Generation is the spec tag generation that resulted in this tag being updated",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
					Required: []string{"created", "dockerImageReference", "image", "generation"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.TagEventCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TagEventCondition contains condition information for a tag event.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of tag event condition, currently only ImportSuccess",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of True, False, Unknown.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "LastTransitionTIme is the time the condition transitioned from one status to another.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "Reason is a brief machine readable explanation for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Message is a human readable description of the details about last transition, complementing reason.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"generation": {
							SchemaProps: spec.SchemaProps{
								Description: "Generation is the spec tag generation that this status corresponds to",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
					Required: []string{"type", "status", "generation"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.TagImportPolicy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TagImportPolicy controls how images related to this tag will be imported.",
					Properties: map[string]spec.Schema{
						"insecure": {
							SchemaProps: spec.SchemaProps{
								Description: "Insecure is true if the server may bypass certificate verification or connect directly over HTTP during image import.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"scheduled": {
							SchemaProps: spec.SchemaProps{
								Description: "Scheduled indicates to the server that this tag should be periodically checked to ensure it is up to date, and imported",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.TagReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TagReference specifies optional annotations for images using this tag and an optional reference to an ImageStreamTag, ImageStreamImage, or DockerImage this tag should track.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the tag",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"annotations": {
							SchemaProps: spec.SchemaProps{
								Description: "Annotations associated with images using this tag",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "From is a reference to an image stream tag or image stream this tag should track",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"reference": {
							SchemaProps: spec.SchemaProps{
								Description: "Reference states if the tag will be imported. Default value is false, which means the tag will be imported.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"generation": {
							SchemaProps: spec.SchemaProps{
								Description: "Generation is the image stream generation that updated this tag - setting it to 0 is an indication that the generation must be updated. Legacy clients will send this as nil, which means the client doesn't know or care.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"importPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "Import is information that controls how images may be imported by the server.",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.TagImportPolicy"),
							},
						},
						"referencePolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "ReferencePolicy defines how other components should consume the image",
								Ref:         ref("github.com/openshift/origin/pkg/image/apis/image/v1.TagReferencePolicy"),
							},
						},
					},
					Required: []string{"name", "annotations", "generation"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/image/apis/image/v1.TagImportPolicy", "github.com/openshift/origin/pkg/image/apis/image/v1.TagReferencePolicy", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/image/apis/image/v1.TagReferencePolicy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TagReferencePolicy describes how pull-specs for images in this image stream tag are generated when image change triggers in deployment configs or builds are resolved. This allows the image stream author to control how images are accessed.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type determines how the image pull spec should be transformed when the image stream tag is used in deployment config triggers or new builds. The default value is `Source`, indicating the original location of the image should be used (if imported). The user may also specify `Local`, indicating that the pull spec should point to the integrated Docker registry and leverage the registry's ability to proxy the pull to an upstream registry. `Local` allows the credentials used to pull this image to be managed from the image stream's namespace, so others on the platform can access a remote image but have no access to the remote secret. It also allows the image layers to be mirrored into the local registry which the images can still be pulled even if the upstream registry is unavailable.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.ClusterRoleScopeRestriction": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterRoleScopeRestriction describes restrictions on cluster role scopes",
					Properties: map[string]spec.Schema{
						"roleNames": {
							SchemaProps: spec.SchemaProps{
								Description: "RoleNames is the list of cluster roles that can referenced.  * means anything",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"namespaces": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespaces is the list of namespaces that can be referenced.  * means any of them (including *)",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"allowEscalation": {
							SchemaProps: spec.SchemaProps{
								Description: "AllowEscalation indicates whether you can request roles and their escalating resources",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"roleNames", "namespaces", "allowEscalation"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthAccessToken": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "OAuthAccessToken describes an OAuth access token",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"clientName": {
							SchemaProps: spec.SchemaProps{
								Description: "ClientName references the client that created this token.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"expiresIn": {
							SchemaProps: spec.SchemaProps{
								Description: "ExpiresIn is the seconds from CreationTime before this token expires.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"scopes": {
							SchemaProps: spec.SchemaProps{
								Description: "Scopes is an array of the requested scopes.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"redirectURI": {
							SchemaProps: spec.SchemaProps{
								Description: "RedirectURI is the redirection associated with the token.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"userName": {
							SchemaProps: spec.SchemaProps{
								Description: "UserName is the user name associated with this token",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"userUID": {
							SchemaProps: spec.SchemaProps{
								Description: "UserUID is the unique UID associated with this token",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"authorizeToken": {
							SchemaProps: spec.SchemaProps{
								Description: "AuthorizeToken contains the token that authorized this token",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"refreshToken": {
							SchemaProps: spec.SchemaProps{
								Description: "RefreshToken is the value by which this token can be renewed. Can be blank.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthAccessTokenList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "OAuthAccessTokenList is a collection of OAuth access tokens",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of OAuth access tokens",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthAccessToken"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthAccessToken", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthAuthorizeToken": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "OAuthAuthorizeToken describes an OAuth authorization token",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"clientName": {
							SchemaProps: spec.SchemaProps{
								Description: "ClientName references the client that created this token.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"expiresIn": {
							SchemaProps: spec.SchemaProps{
								Description: "ExpiresIn is the seconds from CreationTime before this token expires.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"scopes": {
							SchemaProps: spec.SchemaProps{
								Description: "Scopes is an array of the requested scopes.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"redirectURI": {
							SchemaProps: spec.SchemaProps{
								Description: "RedirectURI is the redirection associated with the token.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"state": {
							SchemaProps: spec.SchemaProps{
								Description: "State data from request",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"userName": {
							SchemaProps: spec.SchemaProps{
								Description: "UserName is the user name associated with this token",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"userUID": {
							SchemaProps: spec.SchemaProps{
								Description: "UserUID is the unique UID associated with this token. UserUID and UserName must both match for this token to be valid.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"codeChallenge": {
							SchemaProps: spec.SchemaProps{
								Description: "CodeChallenge is the optional code_challenge associated with this authorization code, as described in rfc7636",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"codeChallengeMethod": {
							SchemaProps: spec.SchemaProps{
								Description: "CodeChallengeMethod is the optional code_challenge_method associated with this authorization code, as described in rfc7636",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthAuthorizeTokenList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "OAuthAuthorizeTokenList is a collection of OAuth authorization tokens",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of OAuth authorization tokens",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthAuthorizeToken"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthAuthorizeToken", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthClient": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "OAuthClient describes an OAuth client",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "Secret is the unique secret associated with a client",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"additionalSecrets": {
							SchemaProps: spec.SchemaProps{
								Description: "AdditionalSecrets holds other secrets that may be used to identify the client.  This is useful for rotation and for service account token validation",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"respondWithChallenges": {
							SchemaProps: spec.SchemaProps{
								Description: "RespondWithChallenges indicates whether the client wants authentication needed responses made in the form of challenges instead of redirects",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"redirectURIs": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-strategy": "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "RedirectURIs is the valid redirection URIs associated with a client",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"grantMethod": {
							SchemaProps: spec.SchemaProps{
								Description: "GrantMethod determines how to handle grants for this client. If no method is provided, the cluster default grant handling method will be used. Valid grant handling methods are:\n - auto:   always approves grant requests, useful for trusted clients\n - prompt: prompts the end user for approval of grant requests, useful for third-party clients\n - deny:   always denies grant requests, useful for black-listed clients",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"scopeRestrictions": {
							SchemaProps: spec.SchemaProps{
								Description: "ScopeRestrictions describes which scopes this client can request.  Each requested scope is checked against each restriction.  If any restriction matches, then the scope is allowed. If no restriction matches, then the scope is denied.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/oauth/apis/oauth/v1.ScopeRestriction"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.ScopeRestriction", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthClientAuthorization": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "OAuthClientAuthorization describes an authorization created by an OAuth client",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"clientName": {
							SchemaProps: spec.SchemaProps{
								Description: "ClientName references the client that created this authorization",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"userName": {
							SchemaProps: spec.SchemaProps{
								Description: "UserName is the user name that authorized this client",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"userUID": {
							SchemaProps: spec.SchemaProps{
								Description: "UserUID is the unique UID associated with this authorization. UserUID and UserName must both match for this authorization to be valid.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"scopes": {
							SchemaProps: spec.SchemaProps{
								Description: "Scopes is an array of the granted scopes.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthClientAuthorizationList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "OAuthClientAuthorizationList is a collection of OAuth client authorizations",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of OAuth client authorizations",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthClientAuthorization"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthClientAuthorization", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthClientList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "OAuthClientList is a collection of OAuth clients",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of OAuth clients",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthClient"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthClient", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.OAuthRedirectReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "OAuthRedirectReference is a reference to an OAuth redirect object.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"reference": {
							SchemaProps: spec.SchemaProps{
								Description: "The reference to an redirect object in the current namespace.",
								Ref:         ref("github.com/openshift/origin/pkg/oauth/apis/oauth/v1.RedirectReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.RedirectReference", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.RedirectReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RedirectReference specifies the target in the current namespace that resolves into redirect URIs.  Only the 'Route' kind is currently allowed.",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Description: "The group of the target that is being referred to.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "The kind of the target that is being referred to.  Currently, only 'Route' is allowed.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "The name of the target that is being referred to. e.g. name of the Route.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"group", "kind", "name"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.ScopeRestriction": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ScopeRestriction describe one restriction on scopes.  Exactly one option must be non-nil.",
					Properties: map[string]spec.Schema{
						"literals": {
							SchemaProps: spec.SchemaProps{
								Description: "ExactValues means the scope has to match a particular set of strings exactly",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"clusterRole": {
							SchemaProps: spec.SchemaProps{
								Description: "ClusterRole describes a set of restrictions for cluster role scoping.",
								Ref:         ref("github.com/openshift/origin/pkg/oauth/apis/oauth/v1.ClusterRoleScopeRestriction"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/oauth/apis/oauth/v1.ClusterRoleScopeRestriction"},
		},
		"github.com/openshift/origin/pkg/project/apis/project/v1.Project": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Projects are the unit of isolation and collaboration in OpenShift. A project has one or more members, a quota on the resources that the project may consume, and the security controls on the resources in the project. Within a project, members may have different roles - project administrators can set membership, editors can create and manage the resources, and viewers can see but not access running containers. In a normal cluster project administrators are not able to alter their quotas - that is restricted to cluster administrators.\n\nListing or watching projects will return only projects the user has the reader role on.\n\nAn OpenShift project is an alternative representation of a Kubernetes namespace. Projects are exposed as editable to end users while namespaces are not. Direct creation of a project is typically restricted to administrators, while end users should use the requestproject resource.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the behavior of the Namespace.",
								Ref:         ref("github.com/openshift/origin/pkg/project/apis/project/v1.ProjectSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status describes the current status of a Namespace",
								Ref:         ref("github.com/openshift/origin/pkg/project/apis/project/v1.ProjectStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/project/apis/project/v1.ProjectSpec", "github.com/openshift/origin/pkg/project/apis/project/v1.ProjectStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/project/apis/project/v1.ProjectList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ProjectList is a list of Project objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of projects",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/project/apis/project/v1.Project"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/project/apis/project/v1.Project", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/project/apis/project/v1.ProjectRequest": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ProjecRequest is the set of options necessary to fully qualify a project request",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"displayName": {
							SchemaProps: spec.SchemaProps{
								Description: "DisplayName is the display name to apply to a project",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"description": {
							SchemaProps: spec.SchemaProps{
								Description: "Description is the description to apply to a project",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/project/apis/project/v1.ProjectSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ProjectSpec describes the attributes on a Project",
					Properties: map[string]spec.Schema{
						"finalizers": {
							SchemaProps: spec.SchemaProps{
								Description: "Finalizers is an opaque list of values that must be empty to permanently remove object from storage",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/project/apis/project/v1.ProjectStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ProjectStatus is information about the current status of a Project",
					Properties: map[string]spec.Schema{
						"phase": {
							SchemaProps: spec.SchemaProps{
								Description: "Phase is the current lifecycle phase of the project",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/quota/apis/quota/v1.AppliedClusterResourceQuota": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "AppliedClusterResourceQuota mirrors ClusterResourceQuota at a project scope, for projection into a project.  It allows a project-admin to know which ClusterResourceQuotas are applied to his project and their associated usage.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the desired quota",
								Ref:         ref("github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status defines the actual enforced quota and its current usage",
								Ref:         ref("github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaStatus"),
							},
						},
					},
					Required: []string{"metadata", "spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaSpec", "github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/quota/apis/quota/v1.AppliedClusterResourceQuotaList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "AppliedClusterResourceQuotaList is a collection of AppliedClusterResourceQuotas",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of AppliedClusterResourceQuota",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/quota/apis/quota/v1.AppliedClusterResourceQuota"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/quota/apis/quota/v1.AppliedClusterResourceQuota", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuota": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterResourceQuota mirrors ResourceQuota at a cluster scope.  This object is easily convertible to synthetic ResourceQuota object to allow quota evaluation re-use.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the desired quota",
								Ref:         ref("github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status defines the actual enforced quota and its current usage",
								Ref:         ref("github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaStatus"),
							},
						},
					},
					Required: []string{"metadata", "spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaSpec", "github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterResourceQuotaList is a collection of ClusterResourceQuotas",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of ClusterResourceQuotas",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuota"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuota", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaSelector": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterResourceQuotaSelector is used to select projects.  At least one of LabelSelector or AnnotationSelector must present.  If only one is present, it is the only selection criteria.  If both are specified, the project must match both restrictions.",
					Properties: map[string]spec.Schema{
						"labels": {
							SchemaProps: spec.SchemaProps{
								Description: "LabelSelector is used to select projects by label.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
							},
						},
						"annotations": {
							SchemaProps: spec.SchemaProps{
								Description: "AnnotationSelector is used to select projects by annotation.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"labels", "annotations"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
		},
		"github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterResourceQuotaSpec defines the desired quota restrictions",
					Properties: map[string]spec.Schema{
						"selector": {
							SchemaProps: spec.SchemaProps{
								Description: "Selector is the selector used to match projects. It should only select active projects on the scale of dozens (though it can select many more less active projects).  These projects will contend on object creation through this resource.",
								Ref:         ref("github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaSelector"),
							},
						},
						"quota": {
							SchemaProps: spec.SchemaProps{
								Description: "Quota defines the desired quota",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceQuotaSpec"),
							},
						},
					},
					Required: []string{"selector", "quota"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaSelector", "k8s.io/kubernetes/pkg/api/v1.ResourceQuotaSpec"},
		},
		"github.com/openshift/origin/pkg/quota/apis/quota/v1.ClusterResourceQuotaStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterResourceQuotaStatus defines the actual enforced quota and its current usage",
					Properties: map[string]spec.Schema{
						"total": {
							SchemaProps: spec.SchemaProps{
								Description: "Total defines the actual enforced quota and its current usage across all projects",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceQuotaStatus"),
							},
						},
						"namespaces": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespaces slices the usage by project.  This division allows for quick resolution of deletion reconciliation inside of a single project without requiring a recalculation across all projects.  This can be used to pull the deltas for a given project.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/quota/apis/quota/v1.ResourceQuotaStatusByNamespace"),
										},
									},
								},
							},
						},
					},
					Required: []string{"total", "namespaces"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/quota/apis/quota/v1.ResourceQuotaStatusByNamespace", "k8s.io/kubernetes/pkg/api/v1.ResourceQuotaStatus"},
		},
		"github.com/openshift/origin/pkg/quota/apis/quota/v1.ResourceQuotaStatusByNamespace": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ResourceQuotaStatusByNamespace gives status for a particular project",
					Properties: map[string]spec.Schema{
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace the project this status applies to",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status indicates how many resources have been consumed by this project",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceQuotaStatus"),
							},
						},
					},
					Required: []string{"namespace", "status"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ResourceQuotaStatus"},
		},
		"github.com/openshift/origin/pkg/route/apis/route/v1.Route": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A route allows developers to expose services through an HTTP(S) aware load balancing and proxy layer via a public DNS entry. The route may further specify TLS options and a certificate, or specify a public CNAME that the router should also accept for HTTP and HTTPS traffic. An administrator typically configures their router to be visible outside the cluster firewall, and may also add additional security, caching, or traffic controls on the service content. Routers usually talk directly to the service endpoints.\n\nOnce a route is created, the `host` field may not be changed. Generally, routers use the oldest route with a given host when resolving conflicts.\n\nRouters are subject to additional customization and may support additional controls via the annotations field.\n\nBecause administrators may configure multiple routers, the route status field is used to return information to clients about the names and states of the route under each router. If a client chooses a duplicate name, for instance, the route status conditions are used to indicate the route cannot be chosen.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "spec is the desired state of the route",
								Ref:         ref("github.com/openshift/origin/pkg/route/apis/route/v1.RouteSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "status is the current state of the route",
								Ref:         ref("github.com/openshift/origin/pkg/route/apis/route/v1.RouteStatus"),
							},
						},
					},
					Required: []string{"spec", "status"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/route/apis/route/v1.RouteSpec", "github.com/openshift/origin/pkg/route/apis/route/v1.RouteStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/route/apis/route/v1.RouteIngress": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RouteIngress holds information about the places where a route is exposed.",
					Properties: map[string]spec.Schema{
						"host": {
							SchemaProps: spec.SchemaProps{
								Description: "Host is the host string under which the route is exposed; this value is required",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"routerName": {
							SchemaProps: spec.SchemaProps{
								Description: "Name is a name chosen by the router to identify itself; this value is required",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"conditions": {
							SchemaProps: spec.SchemaProps{
								Description: "Conditions is the state of the route, may be empty.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/route/apis/route/v1.RouteIngressCondition"),
										},
									},
								},
							},
						},
						"wildcardPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "Wildcard policy is the wildcard policy that was allowed where this route is exposed.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"routerCanonicalHostname": {
							SchemaProps: spec.SchemaProps{
								Description: "CanonicalHostname is the external host name for the router that can be used as a CNAME for the host requested for this route. This value is optional and may not be set in all cases.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/route/apis/route/v1.RouteIngressCondition"},
		},
		"github.com/openshift/origin/pkg/route/apis/route/v1.RouteIngressCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RouteIngressCondition contains details for the current condition of this route on a particular router.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type is the type of the condition. Currently only Ready.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status is the status of the condition. Can be True, False, Unknown.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "(brief) reason for the condition's last transition, and is usually a machine and human readable constant",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Human readable message indicating details about last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "RFC 3339 date and time when this condition last transitioned",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
					},
					Required: []string{"type", "status"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/route/apis/route/v1.RouteList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RouteList is a collection of Routes.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "items is a list of routes",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/route/apis/route/v1.Route"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/route/apis/route/v1.Route", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/route/apis/route/v1.RoutePort": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RoutePort defines a port mapping from a router to an endpoint in the service endpoints.",
					Properties: map[string]spec.Schema{
						"targetPort": {
							SchemaProps: spec.SchemaProps{
								Description: "The target port on pods selected by the service this route points to. If this is a string, it will be looked up as a named port in the target endpoints port list. Required",
								Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
							},
						},
					},
					Required: []string{"targetPort"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
		},
		"github.com/openshift/origin/pkg/route/apis/route/v1.RouteSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RouteSpec describes the hostname or path the route exposes, any security information, and one to four backends (services) the route points to. Requests are distributed among the backends depending on the weights assigned to each backend. When using roundrobin scheduling the portion of requests that go to each backend is the backend weight divided by the sum of all of the backend weights. When the backend has more than one endpoint the requests that end up on the backend are roundrobin distributed among the endpoints. Weights are between 0 and 256 with default 1. Weight 0 causes no requests to the backend. If all weights are zero the route will be considered to have no backends and return a standard 503 response.\n\nThe `tls` field is optional and allows specific certificates or behavior for the route. Routers typically configure a default certificate on a wildcard domain to terminate routes without explicit certificates, but custom hostnames usually must choose passthrough (send traffic directly to the backend via the TLS Server-Name- Indication field) or provide a certificate.",
					Properties: map[string]spec.Schema{
						"host": {
							SchemaProps: spec.SchemaProps{
								Description: "host is an alias/DNS that points to the service. Optional. If not specified a route name will typically be automatically chosen. Must follow DNS952 subdomain conventions.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path that the router watches for, to route traffic for to the service. Optional",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"to": {
							SchemaProps: spec.SchemaProps{
								Description: "to is an object the route should use as the primary backend. Only the Service kind is allowed, and it will be defaulted to Service. If the weight field (0-256 default 1) is set to zero, no traffic will be sent to this backend.",
								Ref:         ref("github.com/openshift/origin/pkg/route/apis/route/v1.RouteTargetReference"),
							},
						},
						"alternateBackends": {
							SchemaProps: spec.SchemaProps{
								Description: "alternateBackends allows up to 3 additional backends to be assigned to the route. Only the Service kind is allowed, and it will be defaulted to Service. Use the weight field in RouteTargetReference object to specify relative preference.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/route/apis/route/v1.RouteTargetReference"),
										},
									},
								},
							},
						},
						"port": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, the port to be used by the router. Most routers will use all endpoints exposed by the service by default - set this value to instruct routers which port to use.",
								Ref:         ref("github.com/openshift/origin/pkg/route/apis/route/v1.RoutePort"),
							},
						},
						"tls": {
							SchemaProps: spec.SchemaProps{
								Description: "The tls field provides the ability to configure certificates and termination for the route.",
								Ref:         ref("github.com/openshift/origin/pkg/route/apis/route/v1.TLSConfig"),
							},
						},
						"wildcardPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "Wildcard policy if any for the route. Currently only 'Subdomain' or 'None' is allowed.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"host", "to"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/route/apis/route/v1.RoutePort", "github.com/openshift/origin/pkg/route/apis/route/v1.RouteTargetReference", "github.com/openshift/origin/pkg/route/apis/route/v1.TLSConfig"},
		},
		"github.com/openshift/origin/pkg/route/apis/route/v1.RouteStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RouteStatus provides relevant info about the status of a route, including which routers acknowledge it.",
					Properties: map[string]spec.Schema{
						"ingress": {
							SchemaProps: spec.SchemaProps{
								Description: "ingress describes the places where the route may be exposed. The list of ingress points may contain duplicate Host or RouterName values. Routes are considered live once they are `Ready`",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/route/apis/route/v1.RouteIngress"),
										},
									},
								},
							},
						},
					},
					Required: []string{"ingress"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/route/apis/route/v1.RouteIngress"},
		},
		"github.com/openshift/origin/pkg/route/apis/route/v1.RouteTargetReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RouteTargetReference specifies the target that resolve into endpoints. Only the 'Service' kind is allowed. Use 'weight' field to emphasize one over others.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "The kind of target that the route is referring to. Currently, only 'Service' is allowed",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name of the service/target that is being referred to. e.g. name of the service",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"weight": {
							SchemaProps: spec.SchemaProps{
								Description: "weight as an integer between 0 and 256, default 1, that specifies the target's relative weight against other target reference objects. 0 suppresses requests to this backend.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"kind", "name", "weight"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/route/apis/route/v1.RouterShard": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RouterShard has information of a routing shard and is used to generate host names and routing table entries when a routing shard is allocated for a specific route. Caveat: This is WIP and will likely undergo modifications when sharding\n        support is added.",
					Properties: map[string]spec.Schema{
						"shardName": {
							SchemaProps: spec.SchemaProps{
								Description: "shardName uniquely identifies a router shard in the \"set\" of routers used for routing traffic to the services.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"dnsSuffix": {
							SchemaProps: spec.SchemaProps{
								Description: "dnsSuffix for the shard ala: shard-1.v3.openshift.com",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"shardName", "dnsSuffix"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/route/apis/route/v1.TLSConfig": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TLSConfig defines config used to secure a route and provide termination",
					Properties: map[string]spec.Schema{
						"termination": {
							SchemaProps: spec.SchemaProps{
								Description: "termination indicates termination type.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"certificate": {
							SchemaProps: spec.SchemaProps{
								Description: "certificate provides certificate contents",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"key": {
							SchemaProps: spec.SchemaProps{
								Description: "key provides key file contents",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"caCertificate": {
							SchemaProps: spec.SchemaProps{
								Description: "caCertificate provides the cert authority certificate contents",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"destinationCACertificate": {
							SchemaProps: spec.SchemaProps{
								Description: "destinationCACertificate provides the contents of the ca certificate of the final destination.  When using reencrypt termination this file should be provided in order to have routers use it for health checks on the secure connection. If this field is not specified, the router may provide its own destination CA and perform hostname validation using the short service name (service.namespace.svc), which allows infrastructure generated certificates to automatically verify.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"insecureEdgeTerminationPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "insecureEdgeTerminationPolicy indicates the desired behavior for insecure connections to a route. While each router may make its own decisions on which ports to expose, this is normally port 80.\n\n* Allow - traffic is sent to the server on the insecure port (default) * Disable - no traffic is allowed on the insecure port. * Redirect - clients are redirected to the secure port.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"termination"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/sdn/apis/network/v1.ClusterNetwork": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterNetwork describes the cluster network. There is normally only one object of this type, named \"default\", which is created by the SDN network plugin based on the master configuration when the cluster is brought up for the first time.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"network": {
							SchemaProps: spec.SchemaProps{
								Description: "Network is a CIDR string specifying the global overlay network's L3 space",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"hostsubnetlength": {
							SchemaProps: spec.SchemaProps{
								Description: "HostSubnetLength is the number of bits of network to allocate to each node. eg, 8 would mean that each node would have a /24 slice of the overlay network for its pods",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"serviceNetwork": {
							SchemaProps: spec.SchemaProps{
								Description: "ServiceNetwork is the CIDR range that Service IP addresses are allocated from",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"pluginName": {
							SchemaProps: spec.SchemaProps{
								Description: "PluginName is the name of the network plugin being used",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"network", "hostsubnetlength", "serviceNetwork"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/sdn/apis/network/v1.ClusterNetworkList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterNetworkList is a collection of ClusterNetworks",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of cluster networks",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/sdn/apis/network/v1.ClusterNetwork"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/sdn/apis/network/v1.ClusterNetwork", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EgressNetworkPolicy describes the current egress network policy for a Namespace. When using the 'redhat/openshift-ovs-multitenant' network plugin, traffic from a pod to an IP address outside the cluster will be checked against each EgressNetworkPolicyRule in the pod's namespace's EgressNetworkPolicy, in order. If no rule matches (or no EgressNetworkPolicy is present) then the traffic will be allowed by default.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "metadata for EgressNetworkPolicy",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "spec is the specification of the current egress network policy",
								Ref:         ref("github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicySpec"),
							},
						},
					},
					Required: []string{"spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicySpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicyList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EgressNetworkPolicyList is a collection of EgressNetworkPolicy",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "metadata for EgressNetworkPolicyList",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "items is the list of policies",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicy"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicy", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicyPeer": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EgressNetworkPolicyPeer specifies a target to apply egress network policy to",
					Properties: map[string]spec.Schema{
						"cidrSelector": {
							SchemaProps: spec.SchemaProps{
								Description: "cidrSelector is the CIDR range to allow/deny traffic to. If this is set, dnsName must be unset",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"dnsName": {
							SchemaProps: spec.SchemaProps{
								Description: "dnsName is the domain name to allow/deny traffic to. If this is set, cidrSelector must be unset",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicyRule": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EgressNetworkPolicyRule contains a single egress network policy rule",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "type marks this as an \"Allow\" or \"Deny\" rule",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"to": {
							SchemaProps: spec.SchemaProps{
								Description: "to is the target that traffic is allowed/denied to",
								Ref:         ref("github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicyPeer"),
							},
						},
					},
					Required: []string{"type", "to"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicyPeer"},
		},
		"github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicySpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EgressNetworkPolicySpec provides a list of policies on outgoing network traffic",
					Properties: map[string]spec.Schema{
						"egress": {
							SchemaProps: spec.SchemaProps{
								Description: "egress contains the list of egress policy rules",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicyRule"),
										},
									},
								},
							},
						},
					},
					Required: []string{"egress"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/sdn/apis/network/v1.EgressNetworkPolicyRule"},
		},
		"github.com/openshift/origin/pkg/sdn/apis/network/v1.HostSubnet": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "HostSubnet describes the container subnet network on a node. The HostSubnet object must have the same name as the Node object it corresponds to.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"host": {
							SchemaProps: spec.SchemaProps{
								Description: "Host is the name of the node. (This is the same as the object's name, but both fields must be set.)",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"hostIP": {
							SchemaProps: spec.SchemaProps{
								Description: "HostIP is the IP address to be used as a VTEP by other nodes in the overlay network",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"subnet": {
							SchemaProps: spec.SchemaProps{
								Description: "Subnet is the CIDR range of the overlay network assigned to the node for its pods",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"host", "hostIP", "subnet"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/sdn/apis/network/v1.HostSubnetList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "HostSubnetList is a collection of HostSubnets",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of host subnets",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/sdn/apis/network/v1.HostSubnet"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/sdn/apis/network/v1.HostSubnet", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/sdn/apis/network/v1.NetNamespace": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NetNamespace describes a single isolated network. When using the redhat/openshift-ovs-multitenant plugin, every Namespace will have a corresponding NetNamespace object with the same name. (When using redhat/openshift-ovs-subnet, NetNamespaces are not used.)",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"netname": {
							SchemaProps: spec.SchemaProps{
								Description: "NetName is the name of the network namespace. (This is the same as the object's name, but both fields must be set.)",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"netid": {
							SchemaProps: spec.SchemaProps{
								Description: "NetID is the network identifier of the network namespace assigned to each overlay network packet. This can be manipulated with the \"oc adm pod-network\" commands.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
					Required: []string{"netname", "netid"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/sdn/apis/network/v1.NetNamespaceList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NetNamespaceList is a collection of NetNamespaces",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of net namespaces",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/sdn/apis/network/v1.NetNamespace"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/sdn/apis/network/v1.NetNamespace", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.FSGroupStrategyOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "FSGroupStrategyOptions defines the strategy type and options used to create the strategy.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type is the strategy that will dictate what FSGroup is used in the SecurityContext.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"ranges": {
							SchemaProps: spec.SchemaProps{
								Description: "Ranges are the allowed ranges of fs groups.  If you would like to force a single fs group then supply a single range with the same start and end.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/security/apis/security/v1.IDRange"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/security/apis/security/v1.IDRange"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.IDRange": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "IDRange provides a min/max of an allowed range of IDs.",
					Properties: map[string]spec.Schema{
						"min": {
							SchemaProps: spec.SchemaProps{
								Description: "Min is the start of the range, inclusive.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"max": {
							SchemaProps: spec.SchemaProps{
								Description: "Max is the end of the range, inclusive.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicyReview": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodSecurityPolicyReview checks which service accounts (not users, since that would be cluster-wide) can create the `PodTemplateSpec` in question.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "spec is the PodSecurityPolicy to check.",
								Ref:         ref("github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicyReviewSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "status represents the current information/status for the PodSecurityPolicyReview.",
								Ref:         ref("github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicyReviewStatus"),
							},
						},
					},
					Required: []string{"spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicyReviewSpec", "github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicyReviewStatus"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicyReviewSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodSecurityPolicyReviewSpec defines specification for PodSecurityPolicyReview",
					Properties: map[string]spec.Schema{
						"template": {
							SchemaProps: spec.SchemaProps{
								Description: "template is the PodTemplateSpec to check. The template.spec.serviceAccountName field is used if serviceAccountNames is empty, unless the template.spec.serviceAccountName is empty, in which case \"default\" is used. If serviceAccountNames is specified, template.spec.serviceAccountName is ignored.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"),
							},
						},
						"serviceAccountNames": {
							SchemaProps: spec.SchemaProps{
								Description: "serviceAccountNames is an optional set of ServiceAccounts to run the check with. If serviceAccountNames is empty, the template.spec.serviceAccountName is used, unless it's empty, in which case \"default\" is used instead. If serviceAccountNames is specified, template.spec.serviceAccountName is ignored.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"template"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicyReviewStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodSecurityPolicyReviewStatus represents the status of PodSecurityPolicyReview.",
					Properties: map[string]spec.Schema{
						"allowedServiceAccounts": {
							SchemaProps: spec.SchemaProps{
								Description: "allowedServiceAccounts returns the list of service accounts in *this* namespace that have the power to create the PodTemplateSpec.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/security/apis/security/v1.ServiceAccountPodSecurityPolicyReviewStatus"),
										},
									},
								},
							},
						},
					},
					Required: []string{"allowedServiceAccounts"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/security/apis/security/v1.ServiceAccountPodSecurityPolicyReviewStatus"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySelfSubjectReview": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodSecurityPolicySelfSubjectReview checks whether this user/SA tuple can create the PodTemplateSpec",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "spec defines specification the PodSecurityPolicySelfSubjectReview.",
								Ref:         ref("github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySelfSubjectReviewSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "status represents the current information/status for the PodSecurityPolicySelfSubjectReview.",
								Ref:         ref("github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySubjectReviewStatus"),
							},
						},
					},
					Required: []string{"spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySelfSubjectReviewSpec", "github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySubjectReviewStatus"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySelfSubjectReviewSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodSecurityPolicySelfSubjectReviewSpec contains specification for PodSecurityPolicySelfSubjectReview.",
					Properties: map[string]spec.Schema{
						"template": {
							SchemaProps: spec.SchemaProps{
								Description: "template is the PodTemplateSpec to check.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"),
							},
						},
					},
					Required: []string{"template"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySubjectReview": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodSecurityPolicySubjectReview checks whether a particular user/SA tuple can create the PodTemplateSpec.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "spec defines specification for the PodSecurityPolicySubjectReview.",
								Ref:         ref("github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySubjectReviewSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "status represents the current information/status for the PodSecurityPolicySubjectReview.",
								Ref:         ref("github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySubjectReviewStatus"),
							},
						},
					},
					Required: []string{"spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySubjectReviewSpec", "github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySubjectReviewStatus"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySubjectReviewSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodSecurityPolicySubjectReviewSpec defines specification for PodSecurityPolicySubjectReview",
					Properties: map[string]spec.Schema{
						"template": {
							SchemaProps: spec.SchemaProps{
								Description: "template is the PodTemplateSpec to check. If template.spec.serviceAccountName is empty it will not be defaulted. If its non-empty, it will be checked.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"),
							},
						},
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "user is the user you're testing for. If you specify \"user\" but not \"group\", then is it interpreted as \"What if user were not a member of any groups. If user and groups are empty, then the check is performed using *only* the serviceAccountName in the template.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "groups is the groups you're testing for.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"template"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.PodSecurityPolicySubjectReviewStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodSecurityPolicySubjectReviewStatus contains information/status for PodSecurityPolicySubjectReview.",
					Properties: map[string]spec.Schema{
						"allowedBy": {
							SchemaProps: spec.SchemaProps{
								Description: "allowedBy is a reference to the rule that allows the PodTemplateSpec. A rule can be a SecurityContextConstraint or a PodSecurityPolicy A `nil`, indicates that it was denied.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "A machine-readable description of why this operation is in the \"Failure\" status. If this value is empty there is no information available.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"template": {
							SchemaProps: spec.SchemaProps{
								Description: "template is the PodTemplateSpec after the defaulting is applied.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference", "k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.RunAsUserStrategyOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type is the strategy that will dictate what RunAsUser is used in the SecurityContext.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"uid": {
							SchemaProps: spec.SchemaProps{
								Description: "UID is the user id that containers must run as.  Required for the MustRunAs strategy if not using namespace/service account allocated uids.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"uidRangeMin": {
							SchemaProps: spec.SchemaProps{
								Description: "UIDRangeMin defines the min value for a strategy that allocates by range.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"uidRangeMax": {
							SchemaProps: spec.SchemaProps{
								Description: "UIDRangeMax defines the max value for a strategy that allocates by range.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.SELinuxContextStrategyOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SELinuxContextStrategyOptions defines the strategy type and any options used to create the strategy.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type is the strategy that will dictate what SELinux context is used in the SecurityContext.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"seLinuxOptions": {
							SchemaProps: spec.SchemaProps{
								Description: "seLinuxOptions required to run as; required for MustRunAs",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.SELinuxOptions"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.SELinuxOptions"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.SecurityContextConstraints": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SecurityContextConstraints governs the ability to make requests that affect the SecurityContext that will be applied to a container.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"priority": {
							SchemaProps: spec.SchemaProps{
								Description: "Priority influences the sort order of SCCs when evaluating which SCCs to try first for a given pod request based on access in the Users and Groups fields.  The higher the int, the higher priority. An unset value is considered a 0 priority. If scores for multiple SCCs are equal they will be sorted from most restrictive to least restrictive. If both priorities and restrictions are equal the SCCs will be sorted by name.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"allowPrivilegedContainer": {
							SchemaProps: spec.SchemaProps{
								Description: "AllowPrivilegedContainer determines if a container can request to be run as privileged.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"defaultAddCapabilities": {
							SchemaProps: spec.SchemaProps{
								Description: "DefaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capabiility in both DefaultAddCapabilities and RequiredDropCapabilities.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"requiredDropCapabilities": {
							SchemaProps: spec.SchemaProps{
								Description: "RequiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"allowedCapabilities": {
							SchemaProps: spec.SchemaProps{
								Description: "AllowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field maybe added at the pod author's discretion. You must not list a capability in both AllowedCapabilities and RequiredDropCapabilities. To allow all capabilities you may use '*'.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"allowHostDirVolumePlugin": {
							SchemaProps: spec.SchemaProps{
								Description: "AllowHostDirVolumePlugin determines if the policy allow containers to use the HostDir volume plugin",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"volumes": {
							SchemaProps: spec.SchemaProps{
								Description: "Volumes is a white list of allowed volume plugins.  FSType corresponds directly with the field names of a VolumeSource (azureFile, configMap, emptyDir).  To allow all volumes you may use \"*\". To allow no volumes, set to [\"none\"].",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"allowHostNetwork": {
							SchemaProps: spec.SchemaProps{
								Description: "AllowHostNetwork determines if the policy allows the use of HostNetwork in the pod spec.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"allowHostPorts": {
							SchemaProps: spec.SchemaProps{
								Description: "AllowHostPorts determines if the policy allows host ports in the containers.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"allowHostPID": {
							SchemaProps: spec.SchemaProps{
								Description: "AllowHostPID determines if the policy allows host pid in the containers.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"allowHostIPC": {
							SchemaProps: spec.SchemaProps{
								Description: "AllowHostIPC determines if the policy allows host ipc in the containers.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"seLinuxContext": {
							SchemaProps: spec.SchemaProps{
								Description: "SELinuxContext is the strategy that will dictate what labels will be set in the SecurityContext.",
								Ref:         ref("github.com/openshift/origin/pkg/security/apis/security/v1.SELinuxContextStrategyOptions"),
							},
						},
						"runAsUser": {
							SchemaProps: spec.SchemaProps{
								Description: "RunAsUser is the strategy that will dictate what RunAsUser is used in the SecurityContext.",
								Ref:         ref("github.com/openshift/origin/pkg/security/apis/security/v1.RunAsUserStrategyOptions"),
							},
						},
						"supplementalGroups": {
							SchemaProps: spec.SchemaProps{
								Description: "SupplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.",
								Ref:         ref("github.com/openshift/origin/pkg/security/apis/security/v1.SupplementalGroupsStrategyOptions"),
							},
						},
						"fsGroup": {
							SchemaProps: spec.SchemaProps{
								Description: "FSGroup is the strategy that will dictate what fs group is used by the SecurityContext.",
								Ref:         ref("github.com/openshift/origin/pkg/security/apis/security/v1.FSGroupStrategyOptions"),
							},
						},
						"readOnlyRootFilesystem": {
							SchemaProps: spec.SchemaProps{
								Description: "ReadOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the SCC should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"users": {
							SchemaProps: spec.SchemaProps{
								Description: "The users who have permissions to use this security context constraints",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "The groups that have permission to use this security context constraints",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"seccompProfiles": {
							SchemaProps: spec.SchemaProps{
								Description: "SeccompProfiles lists the allowed profiles that may be set for the pod or container's seccomp annotations.  An unset (nil) or empty value means that no profiles may be specifid by the pod or container.\tThe wildcard '*' may be used to allow all profiles.  When used to generate a value for a pod the first non-wildcard profile will be used as the default.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"priority", "allowPrivilegedContainer", "defaultAddCapabilities", "requiredDropCapabilities", "allowedCapabilities", "allowHostDirVolumePlugin", "volumes", "allowHostNetwork", "allowHostPorts", "allowHostPID", "allowHostIPC", "readOnlyRootFilesystem"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/security/apis/security/v1.FSGroupStrategyOptions", "github.com/openshift/origin/pkg/security/apis/security/v1.RunAsUserStrategyOptions", "github.com/openshift/origin/pkg/security/apis/security/v1.SELinuxContextStrategyOptions", "github.com/openshift/origin/pkg/security/apis/security/v1.SupplementalGroupsStrategyOptions", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.SecurityContextConstraintsList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SecurityContextConstraintsList is a list of SecurityContextConstraints objects",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of security context constraints.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/security/apis/security/v1.SecurityContextConstraints"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/security/apis/security/v1.SecurityContextConstraints", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.ServiceAccountPodSecurityPolicyReviewStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceAccountPodSecurityPolicyReviewStatus represents ServiceAccount name and related review status",
					Properties: map[string]spec.Schema{
						"allowedBy": {
							SchemaProps: spec.SchemaProps{
								Description: "allowedBy is a reference to the rule that allows the PodTemplateSpec. A rule can be a SecurityContextConstraint or a PodSecurityPolicy A `nil`, indicates that it was denied.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "A machine-readable description of why this operation is in the \"Failure\" status. If this value is empty there is no information available.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"template": {
							SchemaProps: spec.SchemaProps{
								Description: "template is the PodTemplateSpec after the defaulting is applied.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"),
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name contains the allowed and the denied ServiceAccount name",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference", "k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"},
		},
		"github.com/openshift/origin/pkg/security/apis/security/v1.SupplementalGroupsStrategyOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type is the strategy that will dictate what supplemental groups is used in the SecurityContext.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"ranges": {
							SchemaProps: spec.SchemaProps{
								Description: "Ranges are the allowed ranges of supplemental groups.  If you would like to force a single supplemental group then supply a single range with the same start and end.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/security/apis/security/v1.IDRange"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/security/apis/security/v1.IDRange"},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.BrokerTemplateInstance": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BrokerTemplateInstance holds the service broker-related state associated with a TemplateInstance.  BrokerTemplateInstance is part of an experimental API.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "spec describes the state of this BrokerTemplateInstance.",
								Ref:         ref("github.com/openshift/origin/pkg/template/apis/template/v1.BrokerTemplateInstanceSpec"),
							},
						},
					},
					Required: []string{"spec"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/template/apis/template/v1.BrokerTemplateInstanceSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.BrokerTemplateInstanceList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BrokerTemplateInstanceList is a list of BrokerTemplateInstance objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "items is a list of BrokerTemplateInstances",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/template/apis/template/v1.BrokerTemplateInstance"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/template/apis/template/v1.BrokerTemplateInstance", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.BrokerTemplateInstanceSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BrokerTemplateInstanceSpec describes the state of a BrokerTemplateInstance.",
					Properties: map[string]spec.Schema{
						"templateInstance": {
							SchemaProps: spec.SchemaProps{
								Description: "templateinstance is a reference to a TemplateInstance object residing in a namespace.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "secret is a reference to a Secret object residing in a namespace, containing the necessary template parameters.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"bindingIDs": {
							SchemaProps: spec.SchemaProps{
								Description: "bindingids is a list of 'binding_id's provided during successive bind calls to the template service broker.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"templateInstance", "secret"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.Parameter": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Parameter defines a name/value variable that is to be processed during the Template to Config transformation.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name must be set and it can be referenced in Template Items using ${PARAMETER_NAME}. Required.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"displayName": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: The name that will show in UI instead of parameter 'Name'",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"description": {
							SchemaProps: spec.SchemaProps{
								Description: "Description of a parameter. Optional.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"value": {
							SchemaProps: spec.SchemaProps{
								Description: "Value holds the Parameter data. If specified, the generator will be ignored. The value replaces all occurrences of the Parameter ${Name} expression during the Template to Config transformation. Optional.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"generate": {
							SchemaProps: spec.SchemaProps{
								Description: "generate specifies the generator to be used to generate random string from an input value specified by From field. The result string is stored into Value field. If empty, no generator is being used, leaving the result Value untouched. Optional.\n\nThe only supported generator is \"expression\", which accepts a \"from\" value in the form of a simple regular expression containing the range expression \"[a-zA-Z0-9]\", and the length expression \"a{length}\".\n\nExamples:\n\nfrom             | value ----------------------------- \"test[0-9]{1}x\"  | \"test7x\" \"[0-1]{8}\"       | \"01001100\" \"0x[A-F0-9]{4}\"  | \"0xB3AF\" \"[a-zA-Z0-9]{8}\" | \"hW4yQU5i\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"from": {
							SchemaProps: spec.SchemaProps{
								Description: "From is an input value for the generator. Optional.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"required": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: Indicates the parameter must have a value.  Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"name"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.Template": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Template contains the inputs needed to produce a Config.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "message is an optional instructional message that will be displayed when this template is instantiated. This field should inform the user how to utilize the newly created resources. Parameter substitution will be performed on the message before being displayed so that generated credentials and other parameters can be included in the output.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"objects": {
							SchemaProps: spec.SchemaProps{
								Description: "objects is an array of resources to include in this template. If a namespace value is hardcoded in the object, it will be removed during template instantiation, however if the namespace value is, or contains, a ${PARAMETER_REFERENCE}, the resolved value after parameter substitution will be respected and the object will be created in that namespace.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
										},
									},
								},
							},
						},
						"parameters": {
							SchemaProps: spec.SchemaProps{
								Description: "parameters is an optional array of Parameters used during the Template to Config transformation.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/template/apis/template/v1.Parameter"),
										},
									},
								},
							},
						},
						"labels": {
							SchemaProps: spec.SchemaProps{
								Description: "labels is a optional set of labels that are applied to every object during the Template to Config transformation.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"objects"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/template/apis/template/v1.Parameter", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstance": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TemplateInstance requests and records the instantiation of a Template. TemplateInstance is part of an experimental API.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "spec describes the desired state of this TemplateInstance.",
								Ref:         ref("github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "status describes the current state of this TemplateInstance.",
								Ref:         ref("github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceStatus"),
							},
						},
					},
					Required: []string{"spec", "status"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceSpec", "github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TemplateInstanceCondition contains condition information for a TemplateInstance.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of the condition, currently Ready or InstantiateFailure.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of True, False or Unknown.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "LastTransitionTime is the last time a condition status transitioned from one state to another.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "Reason is a brief machine readable explanation for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Message is a human readable description of the details of the last transition, complementing reason.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status", "lastTransitionTime", "reason", "message"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TemplateInstanceList is a list of TemplateInstance objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "items is a list of Templateinstances",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstance"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstance", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceObject": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TemplateInstanceObject references an object created by a TemplateInstance.",
					Properties: map[string]spec.Schema{
						"ref": {
							SchemaProps: spec.SchemaProps{
								Description: "ref is a reference to the created object.  When used under .spec, only name and namespace are used; these can contain references to parameters which will be substituted following the usual rules.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceRequester": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TemplateInstanceRequester holds the identity of an agent requesting a template instantiation.",
					Properties: map[string]spec.Schema{
						"username": {
							SchemaProps: spec.SchemaProps{
								Description: "username uniquely identifies this user among all active users.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"uid": {
							SchemaProps: spec.SchemaProps{
								Description: "uid is a unique value that identifies this user across time; if this user is deleted and another user by the same name is added, they will have different UIDs.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "groups represent the groups this user is a part of.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"extra": {
							SchemaProps: spec.SchemaProps{
								Description: "extra holds additional information provided by the authenticator.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type: []string{"array"},
											Items: &spec.SchemaOrArray{
												Schema: &spec.Schema{
													SchemaProps: spec.SchemaProps{
														Type:   []string{"string"},
														Format: "",
													},
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TemplateInstanceSpec describes the desired state of a TemplateInstance.",
					Properties: map[string]spec.Schema{
						"template": {
							SchemaProps: spec.SchemaProps{
								Description: "template is a full copy of the template for instantiation.",
								Ref:         ref("github.com/openshift/origin/pkg/template/apis/template/v1.Template"),
							},
						},
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "secret is a reference to a Secret object containing the necessary template parameters.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"requester": {
							SchemaProps: spec.SchemaProps{
								Description: "requester holds the identity of the agent requesting the template instantiation.",
								Ref:         ref("github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceRequester"),
							},
						},
					},
					Required: []string{"template", "requester"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/template/apis/template/v1.Template", "github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceRequester", "k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TemplateInstanceStatus describes the current state of a TemplateInstance.",
					Properties: map[string]spec.Schema{
						"conditions": {
							SchemaProps: spec.SchemaProps{
								Description: "conditions represent the latest available observations of a TemplateInstance's current state.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceCondition"),
										},
									},
								},
							},
						},
						"objects": {
							SchemaProps: spec.SchemaProps{
								Description: "Objects references the objects created by the TemplateInstance.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceObject"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceCondition", "github.com/openshift/origin/pkg/template/apis/template/v1.TemplateInstanceObject"},
		},
		"github.com/openshift/origin/pkg/template/apis/template/v1.TemplateList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TemplateList is a list of Template objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of templates",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/template/apis/template/v1.Template"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/template/apis/template/v1.Template", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/user/apis/user/v1.Group": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Group represents a referenceable set of Users",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"users": {
							SchemaProps: spec.SchemaProps{
								Description: "Users is the list of users in this group.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"users"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/user/apis/user/v1.GroupList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupList is a collection of Groups",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of groups",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/user/apis/user/v1.Group"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/user/apis/user/v1.Group", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/user/apis/user/v1.Identity": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Identity records a successful authentication of a user with an identity provider. The information about the source of authentication is stored on the identity, and the identity is then associated with a single user object. Multiple identities can reference a single user. Information retrieved from the authentication provider is stored in the extra field using a schema determined by the provider.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"providerName": {
							SchemaProps: spec.SchemaProps{
								Description: "ProviderName is the source of identity information",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"providerUserName": {
							SchemaProps: spec.SchemaProps{
								Description: "ProviderUserName uniquely represents this identity in the scope of the provider",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "User is a reference to the user this identity is associated with Both Name and UID must be set",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"extra": {
							SchemaProps: spec.SchemaProps{
								Description: "Extra holds extra information about this identity",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"providerName", "providerUserName", "user"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/user/apis/user/v1.IdentityList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "IdentityList is a collection of Identities",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of identities",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/user/apis/user/v1.Identity"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/user/apis/user/v1.Identity", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/openshift/origin/pkg/user/apis/user/v1.User": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Upon log in, every user of the system receives a User and Identity resource. Administrators may directly manipulate the attributes of the users for their own tracking, or set groups via the API. The user name is unique and is chosen based on the value provided by the identity provider - if a user already exists with the incoming name, the user name may have a number appended to it depending on the configuration of the system.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"fullName": {
							SchemaProps: spec.SchemaProps{
								Description: "FullName is the full name of user",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"identities": {
							SchemaProps: spec.SchemaProps{
								Description: "Identities are the identities associated with this user",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "Groups specifies group names this user is a member of. This field is deprecated and will be removed in a future release. Instead, create a Group object containing the name of this User.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"identities", "groups"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/openshift/origin/pkg/user/apis/user/v1.UserIdentityMapping": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "UserIdentityMapping maps a user to an identity",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"identity": {
							SchemaProps: spec.SchemaProps{
								Description: "Identity is a reference to an identity",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "User is a reference to a user",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"github.com/openshift/origin/pkg/user/apis/user/v1.UserList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "UserList is a collection of Users",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of users",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/openshift/origin/pkg/user/apis/user/v1.User"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/openshift/origin/pkg/user/apis/user/v1.User", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"k8s.io/apimachinery/pkg/api/resource.Quantity": resource.Quantity{}.OpenAPIDefinition(),
		"k8s.io/apimachinery/pkg/api/resource.int64Amount": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "int64Amount represents a fixed precision numerator and arbitrary scale exponent. It is faster than operations on inf.Dec for values that can be represented as int64.",
					Properties: map[string]spec.Schema{
						"value": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"integer"},
								Format: "int64",
							},
						},
						"scale": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"integer"},
								Format: "int32",
							},
						},
					},
					Required: []string{"value", "scale"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroup": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIGroup contains the name, the supported versions, and the preferred version of a group.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name is the name of the group.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"versions": {
							SchemaProps: spec.SchemaProps{
								Description: "versions are the versions supported in this group.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery"),
										},
									},
								},
							},
						},
						"preferredVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "preferredVersion is the version preferred by the API server, which probably is the storage version.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery"),
							},
						},
						"serverAddressByClientCIDRs": {
							SchemaProps: spec.SchemaProps{
								Description: "a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"),
										},
									},
								},
							},
						},
					},
					Required: []string{"name", "versions", "serverAddressByClientCIDRs"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery", "k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroupList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIGroupList is a list of APIGroup, to allow clients to discover the API at /apis.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "groups is a list of APIGroup.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.APIGroup"),
										},
									},
								},
							},
						},
					},
					Required: []string{"groups"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroup"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIResource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIResource specifies the name of a resource and whether it is namespaced.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name is the plural name of the resource.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"singularName": {
							SchemaProps: spec.SchemaProps{
								Description: "singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespaced": {
							SchemaProps: spec.SchemaProps{
								Description: "namespaced indicates if a resource is namespaced or not.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"verbs": {
							SchemaProps: spec.SchemaProps{
								Description: "verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"shortNames": {
							SchemaProps: spec.SchemaProps{
								Description: "shortNames is a list of suggested short names of the resource.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"categories": {
							SchemaProps: spec.SchemaProps{
								Description: "categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"name", "singularName", "namespaced", "kind", "verbs"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIResourceList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIResourceList is a list of APIResource, it is used to expose the name of the resources supported in a specific group and version, and if the resource is namespaced.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"groupVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "groupVersion is the group and version this APIResourceList is for.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "resources contains the name of the resources and if they are namespaced.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.APIResource"),
										},
									},
								},
							},
						},
					},
					Required: []string{"groupVersion", "resources"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.APIResource"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIVersions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIVersions lists the versions that are available, to allow clients to discover the API at /api, which is the root path of the legacy v1 API.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"versions": {
							SchemaProps: spec.SchemaProps{
								Description: "versions are the api versions that are available.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"serverAddressByClientCIDRs": {
							SchemaProps: spec.SchemaProps{
								Description: "a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"),
										},
									},
								},
							},
						},
					},
					Required: []string{"versions", "serverAddressByClientCIDRs"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.DeleteOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeleteOptions may be provided when deleting an API object.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"gracePeriodSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"preconditions": {
							SchemaProps: spec.SchemaProps{
								Description: "Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Preconditions"),
							},
						},
						"orphanDependents": {
							SchemaProps: spec.SchemaProps{
								Description: "Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"propagationPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Preconditions"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Duration": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Duration is a wrapper around time.Duration which supports correct marshaling to YAML and JSON. In particular, it marshals into strings, which can be used as map keys in json.",
					Properties: map[string]spec.Schema{
						"Duration": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"integer"},
								Format: "int64",
							},
						},
					},
					Required: []string{"Duration"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.ExportOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ExportOptions is the query options to the standard REST get call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"export": {
							SchemaProps: spec.SchemaProps{
								Description: "Should this value be exported.  Export strips fields that a user can not specify.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"exact": {
							SchemaProps: spec.SchemaProps{
								Description: "Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"export", "exact"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GetOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GetOptions is the standard query options to the standard REST get call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "When specified: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"includeUninitialized": {
							SchemaProps: spec.SchemaProps{
								Description: "If true, partially initialized resources are included in the response.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupKind": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupKind specifies a Group and a Kind, but does not force a version.  This is useful for identifying concepts during lookup stages without having partially valid types",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"group", "kind"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupResource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupResource specifies a Group and a Resource, but does not force a version.  This is useful for identifying concepts during lookup stages without having partially valid types",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"resource": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"group", "resource"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersion": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupVersion contains the \"group\" and the \"version\", which uniquely identifies the API.",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"version": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"group", "version"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupVersion contains the \"group/version\" and \"version\" string of a version. It is made a struct to keep extensibility.",
					Properties: map[string]spec.Schema{
						"groupVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "groupVersion specifies the API group and version in the form \"group/version\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"version": {
							SchemaProps: spec.SchemaProps{
								Description: "version specifies the version in the form of \"version\". This is to save the clients the trouble of splitting the GroupVersion.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"groupVersion", "version"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupVersionKind unambiguously identifies a kind.  It doesn't anonymously include GroupVersion to avoid automatic coersion.  It doesn't use a GroupVersion to avoid custom marshalling",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"version": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"group", "version", "kind"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionResource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupVersionResource unambiguously identifies a resource.  It doesn't anonymously include GroupVersion to avoid automatic coersion.  It doesn't use a GroupVersion to avoid custom marshalling",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"version": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"resource": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"group", "version", "resource"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Initializer": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Initializer is information about an initializer that has not yet completed.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name of the process that is responsible for initializing this object.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Initializers": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Initializers tracks the progress of initialization.",
					Properties: map[string]spec.Schema{
						"pending": {
							SchemaProps: spec.SchemaProps{
								Description: "Pending is a list of initializers that must execute in order before this object is visible. When the last pending initializer is removed, and no failing result is set, the initializers struct will be set to nil and the object is considered as initialized and visible to all clients.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Initializer"),
										},
									},
								},
							},
						},
						"result": {
							SchemaProps: spec.SchemaProps{
								Description: "If result is set with the Failure field, the object will be persisted to storage and then deleted, ensuring that other clients can observe the deletion.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Status"),
							},
						},
					},
					Required: []string{"pending"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Initializer", "k8s.io/apimachinery/pkg/apis/meta/v1.Status"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.InternalEvent": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "InternalEvent makes watch.Event versioned",
					Properties: map[string]spec.Schema{
						"Type": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"Object": {
							SchemaProps: spec.SchemaProps{
								Description: "Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *api.Status is recommended; other types may make sense\n   depending on context.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.Object"),
							},
						},
					},
					Required: []string{"Type", "Object"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/runtime.Object"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.",
					Properties: map[string]spec.Schema{
						"matchLabels": {
							SchemaProps: spec.SchemaProps{
								Description: "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \"key\", the operator is \"In\", and the values array contains only \"value\". The requirements are ANDed.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"matchExpressions": {
							SchemaProps: spec.SchemaProps{
								Description: "matchExpressions is a list of label selector requirements. The requirements are ANDed.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
					Properties: map[string]spec.Schema{
						"key": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "key",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "key is the label key that the selector applies to.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"operator": {
							SchemaProps: spec.SchemaProps{
								Description: "operator represents a key's relationship to a set of values. Valid operators ard In, NotIn, Exists and DoesNotExist.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"values": {
							SchemaProps: spec.SchemaProps{
								Description: "values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"key", "operator"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.",
					Properties: map[string]spec.Schema{
						"selfLink": {
							SchemaProps: spec.SchemaProps{
								Description: "SelfLink is a URL representing this object. Populated by the system. Read-only.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.ListOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ListOptions is the query options to a standard REST list call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"labelSelector": {
							SchemaProps: spec.SchemaProps{
								Description: "A selector to restrict the list of returned objects by their labels. Defaults to everything.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fieldSelector": {
							SchemaProps: spec.SchemaProps{
								Description: "A selector to restrict the list of returned objects by their fields. Defaults to everything.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"includeUninitialized": {
							SchemaProps: spec.SchemaProps{
								Description: "If true, partially initialized resources are included in the response.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"watch": {
							SchemaProps: spec.SchemaProps{
								Description: "Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"resourceVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"timeoutSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Timeout for the list/watch call.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime": v1.MicroTime{}.OpenAPIDefinition(),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"generateName": {
							SchemaProps: spec.SchemaProps{
								Description: "GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header).\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace defines the space within each name must be unique. An empty namespace is equivalent to the \"default\" namespace, but \"default\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"selfLink": {
							SchemaProps: spec.SchemaProps{
								Description: "SelfLink is a URL representing this object. Populated by the system. Read-only.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"uid": {
							SchemaProps: spec.SchemaProps{
								Description: "UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"generation": {
							SchemaProps: spec.SchemaProps{
								Description: "A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"creationTimestamp": {
							SchemaProps: spec.SchemaProps{
								Description: "CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"deletionTimestamp": {
							SchemaProps: spec.SchemaProps{
								Description: "DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field. Once set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"deletionGracePeriodSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"labels": {
							SchemaProps: spec.SchemaProps{
								Description: "Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"annotations": {
							SchemaProps: spec.SchemaProps{
								Description: "Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"ownerReferences": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "uid",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference"),
										},
									},
								},
							},
						},
						"initializers": {
							SchemaProps: spec.SchemaProps{
								Description: "An initializer is a controller which enforces some system invariant at object creation time. This field is a list of initializers that have not yet acted on this object. If nil or empty, this object has been completely initialized. Otherwise, the object is considered uninitialized and is hidden (in list/watch and get calls) from clients that haven't explicitly asked to observe uninitialized objects.\n\nWhen an object is created, the system will populate this list with the current set of initializers. Only privileged users may set or modify this list. Once it is empty, it may not be modified further by any user.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Initializers"),
							},
						},
						"finalizers": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-strategy": "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"clusterName": {
							SchemaProps: spec.SchemaProps{
								Description: "The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Initializers", "k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "OwnerReference contains enough information to let you identify an owning object. Currently, an owning object must be in the same namespace, so there is no namespace field.",
					Properties: map[string]spec.Schema{
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "API version of the referent.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"uid": {
							SchemaProps: spec.SchemaProps{
								Description: "UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"controller": {
							SchemaProps: spec.SchemaProps{
								Description: "If true, this reference points to the managing controller.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"blockOwnerDeletion": {
							SchemaProps: spec.SchemaProps{
								Description: "If true, AND if the owner has the \"foregroundDeletion\" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs \"delete\" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"apiVersion", "kind", "name", "uid"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Patch": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Patch is provided to give a concrete name and type to the Kubernetes PATCH request body.",
					Properties:  map[string]spec.Schema{},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Preconditions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.",
					Properties: map[string]spec.Schema{
						"uid": {
							SchemaProps: spec.SchemaProps{
								Description: "Specifies the target UID.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.RootPaths": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RootPaths lists the paths available at root. For example: \"/healthz\", \"/apis\".",
					Properties: map[string]spec.Schema{
						"paths": {
							SchemaProps: spec.SchemaProps{
								Description: "paths are the paths available at root.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"paths"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.",
					Properties: map[string]spec.Schema{
						"clientCIDR": {
							SchemaProps: spec.SchemaProps{
								Description: "The CIDR with which clients can match their IP to figure out the server address that they should use.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"serverAddress": {
							SchemaProps: spec.SchemaProps{
								Description: "Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"clientCIDR", "serverAddress"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Status": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Status is a return value for calls that don't return other objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the operation. One of: \"Success\" or \"Failure\". More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "A human-readable description of the status of this operation.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "A machine-readable description of why this operation is in the \"Failure\" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"details": {
							SchemaProps: spec.SchemaProps{
								Description: "Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.StatusDetails"),
							},
						},
						"code": {
							SchemaProps: spec.SchemaProps{
								Description: "Suggested HTTP return code for this status, 0 if not set.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.StatusDetails"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.StatusCause": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.",
					Properties: map[string]spec.Schema{
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "A machine-readable description of the cause of the error. If this value is empty there is no information available.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "A human-readable description of the cause of the error.  This field may be presented as-is to a reader.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"field": {
							SchemaProps: spec.SchemaProps{
								Description: "The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  \"name\" - the field \"name\" on the current resource\n  \"items[0].name\" - the field \"name\" on the first array entry in \"items\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.StatusDetails": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"group": {
							SchemaProps: spec.SchemaProps{
								Description: "The group attribute of the resource associated with the status StatusReason.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"uid": {
							SchemaProps: spec.SchemaProps{
								Description: "UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"causes": {
							SchemaProps: spec.SchemaProps{
								Description: "The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.StatusCause"),
										},
									},
								},
							},
						},
						"retryAfterSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, the time in seconds before the operation should be retried.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.StatusCause"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Time": v1.Time{}.OpenAPIDefinition(),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Timestamp": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Timestamp is a struct that is equivalent to Time, but intended for protobuf marshalling/unmarshalling. It is generated into a serialization that matches Time. Do not use in Go structs.",
					Properties: map[string]spec.Schema{
						"seconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"nanos": {
							SchemaProps: spec.SchemaProps{
								Description: "Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive. This field may be limited in precision depending on context.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"seconds", "nanos"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TypeMeta describes an individual object in an API response or request with strings representing the type of the object and its API schema version. Structures that are versioned or persisted should inline TypeMeta.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.WatchEvent": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Event represents a single event to a watched resource.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"object": {
							SchemaProps: spec.SchemaProps{
								Description: "Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
					},
					Required: []string{"type", "object"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1alpha1.PartialObjectMetadata": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PartialObjectMetadata is a generic representation of any object with ObjectMeta. It allows clients to get access to a particular ObjectMeta schema without knowing the details of the version.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1alpha1.PartialObjectMetadataList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PartialObjectMetadataList contains a list of objects containing only their metadata",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "items contains each of the included items.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("*k8s.io/apimachinery/pkg/apis/meta/v1alpha1.PartialObjectMetadata"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"*k8s.io/apimachinery/pkg/apis/meta/v1alpha1.PartialObjectMetadata"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1alpha1.Table": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Table is a tabular representation of a set of API resources. The server transforms the object into a set of preferred columns for quickly reviewing the objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"columnDefinitions": {
							SchemaProps: spec.SchemaProps{
								Description: "columnDefinitions describes each column in the returned items array. The number of cells per row will always match the number of column definitions.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1alpha1.TableColumnDefinition"),
										},
									},
								},
							},
						},
						"rows": {
							SchemaProps: spec.SchemaProps{
								Description: "rows is the list of items in the table.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1alpha1.TableRow"),
										},
									},
								},
							},
						},
					},
					Required: []string{"columnDefinitions", "rows"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/apimachinery/pkg/apis/meta/v1alpha1.TableColumnDefinition", "k8s.io/apimachinery/pkg/apis/meta/v1alpha1.TableRow"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1alpha1.TableColumnDefinition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TableColumnDefinition contains information about a column returned in the Table.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name is a human readable name for the column.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"format": {
							SchemaProps: spec.SchemaProps{
								Description: "format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"description": {
							SchemaProps: spec.SchemaProps{
								Description: "description is a human readable description of this column.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"priority": {
							SchemaProps: spec.SchemaProps{
								Description: "priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a higher priority.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"name", "type", "format", "description", "priority"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1alpha1.TableOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TableOptions are used when a Table is requested by the caller.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"includeObject": {
							SchemaProps: spec.SchemaProps{
								Description: "includeObject decides whether to include each object along with its columnar information. Specifying \"None\" will return no object, specifying \"Object\" will return the full object contents, and specifying \"Metadata\" (the default) will return the object's metadata in the PartialObjectMetadata kind in version v1alpha1 of the meta.k8s.io API group.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1alpha1.TableRow": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TableRow is an individual row in a table.",
					Properties: map[string]spec.Schema{
						"cells": {
							SchemaProps: spec.SchemaProps{
								Description: "cells will be as wide as headers and may contain strings, numbers, booleans, simple maps, or lists, or null. See the type field of the column definition for a more detailed description.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"object"},
											Format: "",
										},
									},
								},
							},
						},
						"conditions": {
							SchemaProps: spec.SchemaProps{
								Description: "conditions describe additional status of a row that are relevant for a human user.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1alpha1.TableRowCondition"),
										},
									},
								},
							},
						},
						"object": {
							SchemaProps: spec.SchemaProps{
								Description: "This field contains the requested additional information about each object based on the includeObject policy when requesting the Table. If \"None\", this field is empty, if \"Object\" this will be the default serialization of the object for the current API version, and if \"Metadata\" (the default) will contain the object metadata. Check the returned kind and apiVersion of the object before parsing.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
					},
					Required: []string{"cells"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1alpha1.TableRowCondition", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1alpha1.TableRowCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TableRowCondition allows a row to be marked with additional information.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of row condition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of True, False, Unknown.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "(brief) machine readable reason for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Human readable message indicating details about last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/runtime.RawExtension": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RawExtension is used to hold extensions in external versions.\n\nTo use this, make a field which has RawExtension as its type in your external, versioned struct, and Object in your internal struct. You also need to register your various plugin types.\n\n// Internal package: type MyAPIObject struct {\n\truntime.TypeMeta `json:\",inline\"`\n\tMyPlugin runtime.Object `json:\"myPlugin\"`\n} type PluginA struct {\n\tAOption string `json:\"aOption\"`\n}\n\n// External package: type MyAPIObject struct {\n\truntime.TypeMeta `json:\",inline\"`\n\tMyPlugin runtime.RawExtension `json:\"myPlugin\"`\n} type PluginA struct {\n\tAOption string `json:\"aOption\"`\n}\n\n// On the wire, the JSON will look something like this: {\n\t\"kind\":\"MyAPIObject\",\n\t\"apiVersion\":\"v1\",\n\t\"myPlugin\": {\n\t\t\"kind\":\"PluginA\",\n\t\t\"aOption\":\"foo\",\n\t},\n}\n\nSo what happens? Decode first uses json or yaml to unmarshal the serialized data into your external MyAPIObject. That causes the raw JSON to be stored, but not unpacked. The next step is to copy (using pkg/conversion) into the internal struct. The runtime package's DefaultScheme has conversion functions installed which will unpack the JSON stored in RawExtension, turning it into the correct object type, and storing it in the Object. (TODO: In the case where the object is of an unknown type, a runtime.Unknown object will be created and stored.)",
					Properties: map[string]spec.Schema{
						"Raw": {
							SchemaProps: spec.SchemaProps{
								Description: "Raw is the underlying serialization of this object.",
								Type:        []string{"string"},
								Format:      "byte",
							},
						},
					},
					Required: []string{"Raw"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/runtime.TypeMeta": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TypeMeta is shared by all top level objects. The proper way to use it is to inline it in your type, like this: type MyAwesomeAPIObject struct {\n     runtime.TypeMeta    `json:\",inline\"`\n     ... // other fields\n} func (obj *MyAwesomeAPIObject) SetGroupVersionKind(gvk *metav1.GroupVersionKind) { metav1.UpdateTypeMeta(obj,gvk) }; GroupVersionKind() *GroupVersionKind\n\nTypeMeta is provided here for convenience. You may use it directly from this package or define your own with the same fields.",
					Properties: map[string]spec.Schema{
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/runtime.Unknown": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Unknown allows api objects with unknown types to be passed-through. This can be used to deal with the API objects from a plug-in. Unknown objects still have functioning TypeMeta features-- kind, version, etc. metadata and field mutatation.",
					Properties: map[string]spec.Schema{
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"Raw": {
							SchemaProps: spec.SchemaProps{
								Description: "Raw will hold the complete serialized object which couldn't be matched with a registered type. Most likely, nothing should be done with this except for passing it through the system.",
								Type:        []string{"string"},
								Format:      "byte",
							},
						},
						"ContentEncoding": {
							SchemaProps: spec.SchemaProps{
								Description: "ContentEncoding is encoding used to encode 'Raw' data. Unspecified means no encoding.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"ContentType": {
							SchemaProps: spec.SchemaProps{
								Description: "ContentType  is serialization method used to serialize 'Raw'. Unspecified means ContentTypeJSON.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"Raw", "ContentEncoding", "ContentType"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/util/intstr.IntOrString": intstr.IntOrString{}.OpenAPIDefinition(),
		"k8s.io/apimachinery/pkg/version.Info": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Info contains versioning information. how we'll want to distribute that information.",
					Properties: map[string]spec.Schema{
						"major": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"minor": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"gitVersion": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"gitCommit": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"gitTreeState": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"buildDate": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"goVersion": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"compiler": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"platform": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"major", "minor", "gitVersion", "gitCommit", "gitTreeState", "buildDate", "goVersion", "compiler", "platform"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apiserver/pkg/apis/audit/v1alpha1.Event": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Event captures all the information that can be included in an API audit log.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "ObjectMeta is included for interoperability with API infrastructure.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"level": {
							SchemaProps: spec.SchemaProps{
								Description: "AuditLevel at which event was generated",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"timestamp": {
							SchemaProps: spec.SchemaProps{
								Description: "Time the request reached the apiserver.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"auditID": {
							SchemaProps: spec.SchemaProps{
								Description: "Unique audit ID, generated for each request.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"stage": {
							SchemaProps: spec.SchemaProps{
								Description: "Stage of the request handling when this event instance was generated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"requestURI": {
							SchemaProps: spec.SchemaProps{
								Description: "RequestURI is the request URI as sent by the client to a server.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"verb": {
							SchemaProps: spec.SchemaProps{
								Description: "Verb is the kubernetes verb associated with the request. For non-resource requests, this is the lower-cased HTTP method.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "Authenticated user information.",
								Ref:         ref("k8s.io/client-go/pkg/apis/authentication/v1.UserInfo"),
							},
						},
						"impersonatedUser": {
							SchemaProps: spec.SchemaProps{
								Description: "Impersonated user information.",
								Ref:         ref("k8s.io/client-go/pkg/apis/authentication/v1.UserInfo"),
							},
						},
						"sourceIPs": {
							SchemaProps: spec.SchemaProps{
								Description: "Source IPs, from where the request originated and intermediate proxies.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"objectRef": {
							SchemaProps: spec.SchemaProps{
								Description: "Object reference this request is targeted at. Does not apply for List-type requests, or non-resource requests.",
								Ref:         ref("k8s.io/apiserver/pkg/apis/audit/v1alpha1.ObjectReference"),
							},
						},
						"responseStatus": {
							SchemaProps: spec.SchemaProps{
								Description: "The response status, populated even when the ResponseObject is not a Status type. For successful responses, this will only include the Code and StatusSuccess. For non-status type error responses, this will be auto-populated with the error Message.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Status"),
							},
						},
						"requestObject": {
							SchemaProps: spec.SchemaProps{
								Description: "API object from the request, in JSON format. The RequestObject is recorded as-is in the request (possibly re-encoded as JSON), prior to version conversion, defaulting, admission or merging. It is an external versioned object type, and may not be a valid object on its own. Omitted for non-resource requests.  Only logged at Request Level and higher.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.Unknown"),
							},
						},
						"responseObject": {
							SchemaProps: spec.SchemaProps{
								Description: "API object returned in the response, in JSON. The ResponseObject is recorded after conversion to the external type, and serialized as JSON.  Omitted for non-resource requests.  Only logged at Response Level.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.Unknown"),
							},
						},
					},
					Required: []string{"level", "timestamp", "auditID", "stage", "requestURI", "verb", "user"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.Status", "k8s.io/apimachinery/pkg/apis/meta/v1.Time", "k8s.io/apimachinery/pkg/runtime.Unknown", "k8s.io/apiserver/pkg/apis/audit/v1alpha1.ObjectReference", "k8s.io/client-go/pkg/apis/authentication/v1.UserInfo"},
		},
		"k8s.io/apiserver/pkg/apis/audit/v1alpha1.EventList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EventList is a list of audit Events.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Type: []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apiserver/pkg/apis/audit/v1alpha1.Event"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/apiserver/pkg/apis/audit/v1alpha1.Event"},
		},
		"k8s.io/apiserver/pkg/apis/audit/v1alpha1.GroupResources": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupResources represents resource kinds in an API group.",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Description: "Group is the name of the API group that contains the resources. The empty string represents the core API group.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "Resources is a list of resources within the API group. Any empty list implies every resource kind in the API group.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apiserver/pkg/apis/audit/v1alpha1.ObjectReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ObjectReference contains enough information to let you inspect or modify the referred object.",
					Properties: map[string]spec.Schema{
						"resource": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"uid": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"resourceVersion": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"subresource": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apiserver/pkg/apis/audit/v1alpha1.Policy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Policy defines the configuration of audit logging, and the rules for how different request categories are logged.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "ObjectMeta is included for interoperability with API infrastructure.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"rules": {
							SchemaProps: spec.SchemaProps{
								Description: "Rules specify the audit Level a request should be recorded at. A request may match multiple rules, in which case the FIRST matching rule is used. The default audit level is None, but can be overridden by a catch-all rule at the end of the list. PolicyRules are strictly ordered.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apiserver/pkg/apis/audit/v1alpha1.PolicyRule"),
										},
									},
								},
							},
						},
					},
					Required: []string{"rules"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apiserver/pkg/apis/audit/v1alpha1.PolicyRule"},
		},
		"k8s.io/apiserver/pkg/apis/audit/v1alpha1.PolicyList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PolicyList is a list of audit Policies.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Type: []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apiserver/pkg/apis/audit/v1alpha1.Policy"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/apiserver/pkg/apis/audit/v1alpha1.Policy"},
		},
		"k8s.io/apiserver/pkg/apis/audit/v1alpha1.PolicyRule": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PolicyRule maps requests based off metadata to an audit Level. Requests must match the rules of every field (an intersection of rules).",
					Properties: map[string]spec.Schema{
						"level": {
							SchemaProps: spec.SchemaProps{
								Description: "The Level that requests matching this rule are recorded at.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"users": {
							SchemaProps: spec.SchemaProps{
								Description: "The users (by authenticated user name) this rule applies to. An empty list implies every user.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"userGroups": {
							SchemaProps: spec.SchemaProps{
								Description: "The user groups this rule applies to. A user is considered matching if it is a member of any of the UserGroups. An empty list implies every user group.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"verbs": {
							SchemaProps: spec.SchemaProps{
								Description: "The verbs that match this rule. An empty list implies every verb.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "Resources that this rule matches. An empty list implies all kinds in all API groups.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apiserver/pkg/apis/audit/v1alpha1.GroupResources"),
										},
									},
								},
							},
						},
						"namespaces": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespaces that this rule matches. The empty string \"\" matches non-namespaced resources. An empty list implies every namespace.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"nonResourceURLs": {
							SchemaProps: spec.SchemaProps{
								Description: "NonResourceURLs is a set of URL paths that should be audited. *s are allowed, but only as the full, final step in the path. Examples:\n \"/metrics\" - Log requests for apiserver metrics\n \"/healthz*\" - Log all health checks",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"level"},
				},
			},
			Dependencies: []string{
				"k8s.io/apiserver/pkg/apis/audit/v1alpha1.GroupResources"},
		},
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIService": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIService represents a server for a particular GroupVersion. Name must be \"version.group\".",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec contains information for locating and communicating with a server",
								Ref:         ref("k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status contains derived information about an API server",
								Ref:         ref("k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceSpec", "k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceStatus"},
		},
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type is the type of the condition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status is the status of the condition. Can be True, False, Unknown.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "Last time the condition transitioned from one status to another.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "Unique, one-word, CamelCase reason for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Human-readable message indicating details about last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIServiceList is a list of APIService objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Type: []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIService"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIService"},
		},
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIServiceSpec contains information for locating and communicating with a server. Only https is supported, though you are able to disable certificate verification.",
					Properties: map[string]spec.Schema{
						"service": {
							SchemaProps: spec.SchemaProps{
								Description: "Service is a reference to the service for this API server.  It must communicate on port 443 If the Service is nil, that means the handling for the API groupversion is handled locally on this server. The call will simply delegate to the normal handler chain to be fulfilled.",
								Ref:         ref("k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.ServiceReference"),
							},
						},
						"group": {
							SchemaProps: spec.SchemaProps{
								Description: "Group is the API group name this server hosts",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"version": {
							SchemaProps: spec.SchemaProps{
								Description: "Version is the API version this server hosts.  For example, \"v1\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"insecureSkipTLSVerify": {
							SchemaProps: spec.SchemaProps{
								Description: "InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server. This is strongly discouraged.  You should use the CABundle instead.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"caBundle": {
							SchemaProps: spec.SchemaProps{
								Description: "CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate.",
								Type:        []string{"string"},
								Format:      "byte",
							},
						},
						"groupPriorityMinimum": {
							SchemaProps: spec.SchemaProps{
								Description: "GroupPriorityMininum is the priority this group should have at least. Higher priority means that the group is prefered by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"versionPriority": {
							SchemaProps: spec.SchemaProps{
								Description: "VersionPriority controls the ordering of this API version inside of its group.  Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) Since it's inside of a group, the number can be small, probably in the 10s.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"service", "caBundle", "groupPriorityMinimum", "versionPriority"},
				},
			},
			Dependencies: []string{
				"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.ServiceReference"},
		},
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIServiceStatus contains derived information about an API server",
					Properties: map[string]spec.Schema{
						"conditions": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "type",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Current service state of apiService.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceCondition"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceCondition"},
		},
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.ServiceReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceReference holds a reference to Service.legacy.k8s.io",
					Properties: map[string]spec.Schema{
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the namespace of the service",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name is the name of the service",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kube-gen/cmd/client-gen/test_apis/testgroup/v1.TestType": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/kube-gen/cmd/client-gen/test_apis/testgroup/v1.TestTypeStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kube-gen/cmd/client-gen/test_apis/testgroup/v1.TestTypeStatus"},
		},
		"k8s.io/kube-gen/cmd/client-gen/test_apis/testgroup/v1.TestTypeList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Type: []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kube-gen/cmd/client-gen/test_apis/testgroup/v1.TestType"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kube-gen/cmd/client-gen/test_apis/testgroup/v1.TestType"},
		},
		"k8s.io/kube-gen/cmd/client-gen/test_apis/testgroup/v1.TestTypeStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Properties: map[string]spec.Schema{
						"Blah": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"Blah"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/federation/apis/federation/v1beta1.Cluster": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Information about a registered cluster in a federated kubernetes setup. Clusters are not namespaced and have unique names in the federation.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the behavior of the Cluster.",
								Ref:         ref("k8s.io/kubernetes/federation/apis/federation/v1beta1.ClusterSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status describes the current status of a Cluster",
								Ref:         ref("k8s.io/kubernetes/federation/apis/federation/v1beta1.ClusterStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/federation/apis/federation/v1beta1.ClusterSpec", "k8s.io/kubernetes/federation/apis/federation/v1beta1.ClusterStatus"},
		},
		"k8s.io/kubernetes/federation/apis/federation/v1beta1.ClusterCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterCondition describes current state of a cluster.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of cluster condition, Complete or Failed.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of True, False, Unknown.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastProbeTime": {
							SchemaProps: spec.SchemaProps{
								Description: "Last time the condition was checked.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "Last time the condition transit from one status to another.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "(brief) reason for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Human readable message indicating details about last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/kubernetes/federation/apis/federation/v1beta1.ClusterList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A list of all the kubernetes clusters registered to the federation",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of Cluster objects.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/federation/apis/federation/v1beta1.Cluster"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/federation/apis/federation/v1beta1.Cluster"},
		},
		"k8s.io/kubernetes/federation/apis/federation/v1beta1.ClusterSelectorRequirement": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterSelectorRequirement contains values, a key, and an operator that relates the key and values. The zero value of ClusterSelectorRequirement is invalid. ClusterSelectorRequirement implements both set based match and exact match",
					Properties: map[string]spec.Schema{
						"key": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "key",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"operator": {
							SchemaProps: spec.SchemaProps{
								Description: "The Operator defines how the Key is matched to the Values. One of \"in\", \"notin\", \"exists\", \"!\", \"=\", \"!=\", \"gt\" or \"lt\".",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"values": {
							SchemaProps: spec.SchemaProps{
								Description: "An array of string values. If the operator is \"in\" or \"notin\", the values array must be non-empty. If the operator is \"exists\" or \"!\", the values array must be empty. If the operator is \"gt\" or \"lt\", the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"key", "operator"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/federation/apis/federation/v1beta1.ClusterSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterSpec describes the attributes of a kubernetes cluster.",
					Properties: map[string]spec.Schema{
						"serverAddressByClientCIDRs": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "clientCIDR",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "A map of client CIDR to server address. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/federation/apis/federation/v1beta1.ServerAddressByClientCIDR"),
										},
									},
								},
							},
						},
						"secretRef": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the secret containing kubeconfig to access this cluster. The secret is read from the kubernetes cluster that is hosting federation control plane. Admin needs to ensure that the required secret exists. Secret should be in the same namespace where federation control plane is hosted and it should have kubeconfig in its data with key \"kubeconfig\". This will later be changed to a reference to secret in federation control plane when the federation control plane supports secrets. This can be left empty if the cluster allows insecure access.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
					},
					Required: []string{"serverAddressByClientCIDRs"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/federation/apis/federation/v1beta1.ServerAddressByClientCIDR", "k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"},
		},
		"k8s.io/kubernetes/federation/apis/federation/v1beta1.ClusterStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ClusterStatus is information about the current status of a cluster updated by cluster controller periodically.",
					Properties: map[string]spec.Schema{
						"conditions": {
							SchemaProps: spec.SchemaProps{
								Description: "Conditions is an array of current cluster conditions.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/federation/apis/federation/v1beta1.ClusterCondition"),
										},
									},
								},
							},
						},
						"zones": {
							SchemaProps: spec.SchemaProps{
								Description: "Zones is the list of availability zones in which the nodes of the cluster exist, e.g. 'us-east1-a'. These will always be in the same region.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"region": {
							SchemaProps: spec.SchemaProps{
								Description: "Region is the name of the region in which all of the nodes in the cluster exist.  e.g. 'us-east1'.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/federation/apis/federation/v1beta1.ClusterCondition"},
		},
		"k8s.io/kubernetes/federation/apis/federation/v1beta1.ServerAddressByClientCIDR": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.",
					Properties: map[string]spec.Schema{
						"clientCIDR": {
							SchemaProps: spec.SchemaProps{
								Description: "The CIDR with which clients can match their IP to figure out the server address that they should use.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"serverAddress": {
							SchemaProps: spec.SchemaProps{
								Description: "Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"clientCIDR", "serverAddress"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.AWSElasticBlockStoreVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a Persistent Disk resource in AWS.\n\nAn AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"volumeID": {
							SchemaProps: spec.SchemaProps{
								Description: "Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"partition": {
							SchemaProps: spec.SchemaProps{
								Description: "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \"1\". Similarly, the volume partition for /dev/sda is \"0\" (or you can leave the property empty).",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Specify \"true\" to force and set the ReadOnly property in VolumeMounts to \"true\". If omitted, the default is \"false\". More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"volumeID"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.Affinity": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Affinity is a group of affinity scheduling rules.",
					Properties: map[string]spec.Schema{
						"nodeAffinity": {
							SchemaProps: spec.SchemaProps{
								Description: "Describes node affinity scheduling rules for the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NodeAffinity"),
							},
						},
						"podAffinity": {
							SchemaProps: spec.SchemaProps{
								Description: "Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodAffinity"),
							},
						},
						"podAntiAffinity": {
							SchemaProps: spec.SchemaProps{
								Description: "Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodAntiAffinity"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.NodeAffinity", "k8s.io/kubernetes/pkg/api/v1.PodAffinity", "k8s.io/kubernetes/pkg/api/v1.PodAntiAffinity"},
		},
		"k8s.io/kubernetes/pkg/api/v1.AttachedVolume": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "AttachedVolume describes a volume attached to a node",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the attached volume",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"devicePath": {
							SchemaProps: spec.SchemaProps{
								Description: "DevicePath represents the device path where the volume should be available",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name", "devicePath"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.AvoidPods": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "AvoidPods describes pods that should avoid this node. This is the value for a Node annotation with key scheduler.alpha.kubernetes.io/preferAvoidPods and will eventually become a field of NodeStatus.",
					Properties: map[string]spec.Schema{
						"preferAvoidPods": {
							SchemaProps: spec.SchemaProps{
								Description: "Bounded-sized list of signatures of pods that should avoid this node, sorted in timestamp order from oldest to newest. Size of the slice is unspecified.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.PreferAvoidPodsEntry"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.PreferAvoidPodsEntry"},
		},
		"k8s.io/kubernetes/pkg/api/v1.AzureDiskVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
					Properties: map[string]spec.Schema{
						"diskName": {
							SchemaProps: spec.SchemaProps{
								Description: "The Name of the data disk in the blob storage",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"diskURI": {
							SchemaProps: spec.SchemaProps{
								Description: "The URI the data disk in the blob storage",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"cachingMode": {
							SchemaProps: spec.SchemaProps{
								Description: "Host Caching mode: None, Read Only, Read Write.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Expected values Shared: mulitple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"diskName", "diskURI"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.AzureFileVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
					Properties: map[string]spec.Schema{
						"secretName": {
							SchemaProps: spec.SchemaProps{
								Description: "the name of secret that contains Azure Storage Account Name and Key",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"shareName": {
							SchemaProps: spec.SchemaProps{
								Description: "Share Name",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"secretName", "shareName"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.Binding": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Binding ties one object to another; for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"target": {
							SchemaProps: spec.SchemaProps{
								Description: "The target object that you want to bind to the standard object.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
					Required: []string{"target"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.Capabilities": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Adds and removes POSIX capabilities from running containers.",
					Properties: map[string]spec.Schema{
						"add": {
							SchemaProps: spec.SchemaProps{
								Description: "Added capabilities",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"drop": {
							SchemaProps: spec.SchemaProps{
								Description: "Removed capabilities",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.CephFSVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"monitors": {
							SchemaProps: spec.SchemaProps{
								Description: "Required: Monitors is a collection of Ceph monitors More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: Used as the mounted root, rather than the full Ceph tree, default is /",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: User is the rados user name, default is admin More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"secretFile": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"secretRef": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"monitors"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.CinderVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"volumeID": {
							SchemaProps: spec.SchemaProps{
								Description: "volume id used to identify the volume in cinder More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"volumeID"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ComponentCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Information about the condition of a component.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of condition for a component. Valid value: \"Healthy\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition for a component. Valid values for \"Healthy\": \"True\", \"False\", or \"Unknown\".",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Message about the condition for a component. For example, information about a health check.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"error": {
							SchemaProps: spec.SchemaProps{
								Description: "Condition error code for a component. For example, a health check error code.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ComponentStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ComponentStatus (and ComponentStatusList) holds the cluster validation info.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"conditions": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "type",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "List of component conditions observed",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ComponentCondition"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.ComponentCondition"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ComponentStatusList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Status of all the conditions for the component as a list of ComponentStatus objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of ComponentStatus objects.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ComponentStatus"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.ComponentStatus"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ConfigMap": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ConfigMap holds configuration data for pods to consume.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"data": {
							SchemaProps: spec.SchemaProps{
								Description: "Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ConfigMapEnvSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.\n\nThe contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"optional": {
							SchemaProps: spec.SchemaProps{
								Description: "Specify whether the ConfigMap must be defined",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ConfigMapKeySelector": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Selects a key from a ConfigMap.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"key": {
							SchemaProps: spec.SchemaProps{
								Description: "The key to select.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"optional": {
							SchemaProps: spec.SchemaProps{
								Description: "Specify whether the ConfigMap or it's key must be defined",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"key"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ConfigMapList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ConfigMapList is a resource containing a list of ConfigMap objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of ConfigMaps.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ConfigMap"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.ConfigMap"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ConfigMapProjection": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Adapts a ConfigMap into a projected volume.\n\nThe contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.KeyToPath"),
										},
									},
								},
							},
						},
						"optional": {
							SchemaProps: spec.SchemaProps{
								Description: "Specify whether the ConfigMap or it's keys must be defined",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.KeyToPath"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ConfigMapVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Adapts a ConfigMap into a volume.\n\nThe contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.KeyToPath"),
										},
									},
								},
							},
						},
						"defaultMode": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"optional": {
							SchemaProps: spec.SchemaProps{
								Description: "Specify whether the ConfigMap or it's keys must be defined",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.KeyToPath"},
		},
		"k8s.io/kubernetes/pkg/api/v1.Container": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A single application container that you want to run within a pod.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"image": {
							SchemaProps: spec.SchemaProps{
								Description: "Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"command": {
							SchemaProps: spec.SchemaProps{
								Description: "Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"args": {
							SchemaProps: spec.SchemaProps{
								Description: "Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"workingDir": {
							SchemaProps: spec.SchemaProps{
								Description: "Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"ports": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "containerPort",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default \"0.0.0.0\" address inside a container will be accessible from the network. Cannot be updated.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ContainerPort"),
										},
									},
								},
							},
						},
						"envFrom": {
							SchemaProps: spec.SchemaProps{
								Description: "List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvFromSource"),
										},
									},
								},
							},
						},
						"env": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "name",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "List of environment variables to set in the container. Cannot be updated.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EnvVar"),
										},
									},
								},
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceRequirements"),
							},
						},
						"volumeMounts": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "mountPath",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Pod volumes to mount into the container's filesystem. Cannot be updated.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.VolumeMount"),
										},
									},
								},
							},
						},
						"livenessProbe": {
							SchemaProps: spec.SchemaProps{
								Description: "Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.Probe"),
							},
						},
						"readinessProbe": {
							SchemaProps: spec.SchemaProps{
								Description: "Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.Probe"),
							},
						},
						"lifecycle": {
							SchemaProps: spec.SchemaProps{
								Description: "Actions that the management system should take in response to container lifecycle events. Cannot be updated.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.Lifecycle"),
							},
						},
						"terminationMessagePath": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"terminationMessagePolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"imagePullPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"securityContext": {
							SchemaProps: spec.SchemaProps{
								Description: "Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://git.k8s.io/community/contributors/design-proposals/security_context.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.SecurityContext"),
							},
						},
						"stdin": {
							SchemaProps: spec.SchemaProps{
								Description: "Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"stdinOnce": {
							SchemaProps: spec.SchemaProps{
								Description: "Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"tty": {
							SchemaProps: spec.SchemaProps{
								Description: "Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"name", "image"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ContainerPort", "k8s.io/kubernetes/pkg/api/v1.EnvFromSource", "k8s.io/kubernetes/pkg/api/v1.EnvVar", "k8s.io/kubernetes/pkg/api/v1.Lifecycle", "k8s.io/kubernetes/pkg/api/v1.Probe", "k8s.io/kubernetes/pkg/api/v1.ResourceRequirements", "k8s.io/kubernetes/pkg/api/v1.SecurityContext", "k8s.io/kubernetes/pkg/api/v1.VolumeMount"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ContainerImage": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Describe a container image",
					Properties: map[string]spec.Schema{
						"names": {
							SchemaProps: spec.SchemaProps{
								Description: "Names by which this image is known. e.g. [\"gcr.io/google_containers/hyperkube:v1.0.7\", \"dockerhub.io/google_containers/hyperkube:v1.0.7\"]",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"sizeBytes": {
							SchemaProps: spec.SchemaProps{
								Description: "The size of the image in bytes.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
					Required: []string{"names"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ContainerPort": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ContainerPort represents a network port in a single container.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"hostPort": {
							SchemaProps: spec.SchemaProps{
								Description: "Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"containerPort": {
							SchemaProps: spec.SchemaProps{
								Description: "Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"protocol": {
							SchemaProps: spec.SchemaProps{
								Description: "Protocol for port. Must be UDP or TCP. Defaults to \"TCP\".",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"hostIP": {
							SchemaProps: spec.SchemaProps{
								Description: "What host IP to bind the external port to.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"containerPort"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ContainerState": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.",
					Properties: map[string]spec.Schema{
						"waiting": {
							SchemaProps: spec.SchemaProps{
								Description: "Details about a waiting container",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ContainerStateWaiting"),
							},
						},
						"running": {
							SchemaProps: spec.SchemaProps{
								Description: "Details about a running container",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ContainerStateRunning"),
							},
						},
						"terminated": {
							SchemaProps: spec.SchemaProps{
								Description: "Details about a terminated container",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ContainerStateTerminated"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ContainerStateRunning", "k8s.io/kubernetes/pkg/api/v1.ContainerStateTerminated", "k8s.io/kubernetes/pkg/api/v1.ContainerStateWaiting"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ContainerStateRunning": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ContainerStateRunning is a running state of a container.",
					Properties: map[string]spec.Schema{
						"startedAt": {
							SchemaProps: spec.SchemaProps{
								Description: "Time at which the container was last (re-)started",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ContainerStateTerminated": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ContainerStateTerminated is a terminated state of a container.",
					Properties: map[string]spec.Schema{
						"exitCode": {
							SchemaProps: spec.SchemaProps{
								Description: "Exit status from the last termination of the container",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"signal": {
							SchemaProps: spec.SchemaProps{
								Description: "Signal from the last termination of the container",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "(brief) reason from the last termination of the container",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Message regarding the last termination of the container",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"startedAt": {
							SchemaProps: spec.SchemaProps{
								Description: "Time at which previous execution of the container started",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"finishedAt": {
							SchemaProps: spec.SchemaProps{
								Description: "Time at which the container last terminated",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"containerID": {
							SchemaProps: spec.SchemaProps{
								Description: "Container's ID in the format 'docker://<container_id>'",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"exitCode"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ContainerStateWaiting": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ContainerStateWaiting is a waiting state of a container.",
					Properties: map[string]spec.Schema{
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "(brief) reason the container is not yet running.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Message regarding why the container is not yet running.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ContainerStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ContainerStatus contains details for the current status of this container.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "This must be a DNS_LABEL. Each container in a pod must have a unique name. Cannot be updated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"state": {
							SchemaProps: spec.SchemaProps{
								Description: "Details about the container's current condition.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ContainerState"),
							},
						},
						"lastState": {
							SchemaProps: spec.SchemaProps{
								Description: "Details about the container's last termination condition.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ContainerState"),
							},
						},
						"ready": {
							SchemaProps: spec.SchemaProps{
								Description: "Specifies whether the container has passed its readiness probe.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"restartCount": {
							SchemaProps: spec.SchemaProps{
								Description: "The number of times the container has been restarted, currently based on the number of dead containers that have not yet been removed. Note that this is calculated from dead containers. But those containers are subject to garbage collection. This value will get capped at 5 by GC.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"image": {
							SchemaProps: spec.SchemaProps{
								Description: "The image the container is running. More info: https://kubernetes.io/docs/concepts/containers/images",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"imageID": {
							SchemaProps: spec.SchemaProps{
								Description: "ImageID of the container's image.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"containerID": {
							SchemaProps: spec.SchemaProps{
								Description: "Container's ID in the format 'docker://<container_id>'.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name", "ready", "restartCount", "image", "imageID"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ContainerState"},
		},
		"k8s.io/kubernetes/pkg/api/v1.DaemonEndpoint": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DaemonEndpoint contains information about a single Daemon endpoint.",
					Properties: map[string]spec.Schema{
						"Port": {
							SchemaProps: spec.SchemaProps{
								Description: "Port number of the given endpoint.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"Port"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.DownwardAPIProjection": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode.",
					Properties: map[string]spec.Schema{
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of DownwardAPIVolume file",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.DownwardAPIVolumeFile"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.DownwardAPIVolumeFile"},
		},
		"k8s.io/kubernetes/pkg/api/v1.DownwardAPIVolumeFile": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DownwardAPIVolumeFile represents information to create the file containing the pod field",
					Properties: map[string]spec.Schema{
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fieldRef": {
							SchemaProps: spec.SchemaProps{
								Description: "Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectFieldSelector"),
							},
						},
						"resourceFieldRef": {
							SchemaProps: spec.SchemaProps{
								Description: "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceFieldSelector"),
							},
						},
						"mode": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"path"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectFieldSelector", "k8s.io/kubernetes/pkg/api/v1.ResourceFieldSelector"},
		},
		"k8s.io/kubernetes/pkg/api/v1.DownwardAPIVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of downward API volume file",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.DownwardAPIVolumeFile"),
										},
									},
								},
							},
						},
						"defaultMode": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.DownwardAPIVolumeFile"},
		},
		"k8s.io/kubernetes/pkg/api/v1.EmptyDirVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"medium": {
							SchemaProps: spec.SchemaProps{
								Description: "What type of storage medium should back this directory. The default is \"\" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"sizeLimit": {
							SchemaProps: spec.SchemaProps{
								Description: "Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir",
								Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/api/resource.Quantity"},
		},
		"k8s.io/kubernetes/pkg/api/v1.EndpointAddress": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EndpointAddress is a tuple that describes single IP address.",
					Properties: map[string]spec.Schema{
						"ip": {
							SchemaProps: spec.SchemaProps{
								Description: "The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"hostname": {
							SchemaProps: spec.SchemaProps{
								Description: "The Hostname of this endpoint",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"nodeName": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"targetRef": {
							SchemaProps: spec.SchemaProps{
								Description: "Reference to object providing the endpoint.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
					Required: []string{"ip"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.EndpointPort": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EndpointPort is a tuple that describes a single port.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "The name of this port (corresponds to ServicePort.Name). Must be a DNS_LABEL. Optional only if one port is defined.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"port": {
							SchemaProps: spec.SchemaProps{
								Description: "The port number of the endpoint.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"protocol": {
							SchemaProps: spec.SchemaProps{
								Description: "The IP protocol for this port. Must be UDP or TCP. Default is TCP.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"port"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.EndpointSubset": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:\n  {\n    Addresses: [{\"ip\": \"10.10.1.1\"}, {\"ip\": \"10.10.2.2\"}],\n    Ports:     [{\"name\": \"a\", \"port\": 8675}, {\"name\": \"b\", \"port\": 309}]\n  }\nThe resulting set of endpoints can be viewed as:\n    a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],\n    b: [ 10.10.1.1:309, 10.10.2.2:309 ]",
					Properties: map[string]spec.Schema{
						"addresses": {
							SchemaProps: spec.SchemaProps{
								Description: "IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EndpointAddress"),
										},
									},
								},
							},
						},
						"notReadyAddresses": {
							SchemaProps: spec.SchemaProps{
								Description: "IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EndpointAddress"),
										},
									},
								},
							},
						},
						"ports": {
							SchemaProps: spec.SchemaProps{
								Description: "Port numbers available on the related IP addresses.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EndpointPort"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.EndpointAddress", "k8s.io/kubernetes/pkg/api/v1.EndpointPort"},
		},
		"k8s.io/kubernetes/pkg/api/v1.Endpoints": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Endpoints is a collection of endpoints that implement the actual service. Example:\n  Name: \"mysvc\",\n  Subsets: [\n    {\n      Addresses: [{\"ip\": \"10.10.1.1\"}, {\"ip\": \"10.10.2.2\"}],\n      Ports: [{\"name\": \"a\", \"port\": 8675}, {\"name\": \"b\", \"port\": 309}]\n    },\n    {\n      Addresses: [{\"ip\": \"10.10.3.3\"}],\n      Ports: [{\"name\": \"a\", \"port\": 93}, {\"name\": \"b\", \"port\": 76}]\n    },\n ]",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"subsets": {
							SchemaProps: spec.SchemaProps{
								Description: "The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.EndpointSubset"),
										},
									},
								},
							},
						},
					},
					Required: []string{"subsets"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.EndpointSubset"},
		},
		"k8s.io/kubernetes/pkg/api/v1.EndpointsList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EndpointsList is a list of endpoints.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of endpoints.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Endpoints"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.Endpoints"},
		},
		"k8s.io/kubernetes/pkg/api/v1.EnvFromSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EnvFromSource represents the source of a set of ConfigMaps",
					Properties: map[string]spec.Schema{
						"prefix": {
							SchemaProps: spec.SchemaProps{
								Description: "An optional identifer to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"configMapRef": {
							SchemaProps: spec.SchemaProps{
								Description: "The ConfigMap to select from",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ConfigMapEnvSource"),
							},
						},
						"secretRef": {
							SchemaProps: spec.SchemaProps{
								Description: "The Secret to select from",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.SecretEnvSource"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ConfigMapEnvSource", "k8s.io/kubernetes/pkg/api/v1.SecretEnvSource"},
		},
		"k8s.io/kubernetes/pkg/api/v1.EnvVar": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EnvVar represents an environment variable present in a Container.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the environment variable. Must be a C_IDENTIFIER.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"value": {
							SchemaProps: spec.SchemaProps{
								Description: "Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to \"\".",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"valueFrom": {
							SchemaProps: spec.SchemaProps{
								Description: "Source for the environment variable's value. Cannot be used if value is not empty.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.EnvVarSource"),
							},
						},
					},
					Required: []string{"name"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.EnvVarSource"},
		},
		"k8s.io/kubernetes/pkg/api/v1.EnvVarSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EnvVarSource represents a source for the value of an EnvVar.",
					Properties: map[string]spec.Schema{
						"fieldRef": {
							SchemaProps: spec.SchemaProps{
								Description: "Selects a field of the pod: supports metadata.name, metadata.namespace, metadata.labels, metadata.annotations, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectFieldSelector"),
							},
						},
						"resourceFieldRef": {
							SchemaProps: spec.SchemaProps{
								Description: "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceFieldSelector"),
							},
						},
						"configMapKeyRef": {
							SchemaProps: spec.SchemaProps{
								Description: "Selects a key of a ConfigMap.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ConfigMapKeySelector"),
							},
						},
						"secretKeyRef": {
							SchemaProps: spec.SchemaProps{
								Description: "Selects a key of a secret in the pod's namespace",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.SecretKeySelector"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ConfigMapKeySelector", "k8s.io/kubernetes/pkg/api/v1.ObjectFieldSelector", "k8s.io/kubernetes/pkg/api/v1.ResourceFieldSelector", "k8s.io/kubernetes/pkg/api/v1.SecretKeySelector"},
		},
		"k8s.io/kubernetes/pkg/api/v1.Event": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Event is a report of an event somewhere in the cluster.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"involvedObject": {
							SchemaProps: spec.SchemaProps{
								Description: "The object that this event is about.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "This should be a short, machine understandable string that gives the reason for the transition into the object's current status.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "A human-readable description of the status of this operation.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"source": {
							SchemaProps: spec.SchemaProps{
								Description: "The component reporting this event. Should be a short machine understandable string.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.EventSource"),
							},
						},
						"firstTimestamp": {
							SchemaProps: spec.SchemaProps{
								Description: "The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"lastTimestamp": {
							SchemaProps: spec.SchemaProps{
								Description: "The time at which the most recent occurrence of this event was recorded.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"count": {
							SchemaProps: spec.SchemaProps{
								Description: "The number of times this event has occurred.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of this event (Normal, Warning), new types could be added in the future",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"metadata", "involvedObject"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.Time", "k8s.io/kubernetes/pkg/api/v1.EventSource", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.EventList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EventList is a list of events.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of events",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Event"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.Event"},
		},
		"k8s.io/kubernetes/pkg/api/v1.EventSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "EventSource contains information for an event.",
					Properties: map[string]spec.Schema{
						"component": {
							SchemaProps: spec.SchemaProps{
								Description: "Component from which the event is generated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"host": {
							SchemaProps: spec.SchemaProps{
								Description: "Node name on which the event is generated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ExecAction": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ExecAction describes a \"run in container\" action.",
					Properties: map[string]spec.Schema{
						"command": {
							SchemaProps: spec.SchemaProps{
								Description: "Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.FCVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"targetWWNs": {
							SchemaProps: spec.SchemaProps{
								Description: "Required: FC target worldwide names (WWNs)",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"lun": {
							SchemaProps: spec.SchemaProps{
								Description: "Required: FC target lun number",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"targetWWNs", "lun"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.FlexVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. This is an alpha feature and may change in future.",
					Properties: map[string]spec.Schema{
						"driver": {
							SchemaProps: spec.SchemaProps{
								Description: "Driver is the name of the driver to use for this volume.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". The default filesystem depends on FlexVolume script.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"secretRef": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"options": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: Extra command options if any.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"driver"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.FlockerVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"datasetName": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"datasetUUID": {
							SchemaProps: spec.SchemaProps{
								Description: "UUID of the dataset. This is unique identifier of a Flocker dataset",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.GCEPersistentDiskVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a Persistent Disk resource in Google Compute Engine.\n\nA GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"pdName": {
							SchemaProps: spec.SchemaProps{
								Description: "Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"partition": {
							SchemaProps: spec.SchemaProps{
								Description: "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \"1\". Similarly, the volume partition for /dev/sda is \"0\" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"pdName"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.GitRepoVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"repository": {
							SchemaProps: spec.SchemaProps{
								Description: "Repository URL",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "Commit hash for the specified revision.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"directory": {
							SchemaProps: spec.SchemaProps{
								Description: "Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"repository"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.GlusterfsVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"endpoints": {
							SchemaProps: spec.SchemaProps{
								Description: "EndpointsName is the endpoint name that details Glusterfs topology. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path is the Glusterfs volume path. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"endpoints", "path"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.HTTPGetAction": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "HTTPGetAction describes an action based on HTTP Get requests.",
					Properties: map[string]spec.Schema{
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path to access on the HTTP server.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"port": {
							SchemaProps: spec.SchemaProps{
								Description: "Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.",
								Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
							},
						},
						"host": {
							SchemaProps: spec.SchemaProps{
								Description: "Host name to connect to, defaults to the pod IP. You probably want to set \"Host\" in httpHeaders instead.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"scheme": {
							SchemaProps: spec.SchemaProps{
								Description: "Scheme to use for connecting to the host. Defaults to HTTP.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"httpHeaders": {
							SchemaProps: spec.SchemaProps{
								Description: "Custom headers to set in the request. HTTP allows repeated headers.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.HTTPHeader"),
										},
									},
								},
							},
						},
					},
					Required: []string{"port"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/util/intstr.IntOrString", "k8s.io/kubernetes/pkg/api/v1.HTTPHeader"},
		},
		"k8s.io/kubernetes/pkg/api/v1.HTTPHeader": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "HTTPHeader describes a custom header to be used in HTTP probes",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "The header field name",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"value": {
							SchemaProps: spec.SchemaProps{
								Description: "The header field value",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name", "value"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.Handler": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Handler defines a specific action that should be taken",
					Properties: map[string]spec.Schema{
						"exec": {
							SchemaProps: spec.SchemaProps{
								Description: "One and only one of the following should be specified. Exec specifies the action to take.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ExecAction"),
							},
						},
						"httpGet": {
							SchemaProps: spec.SchemaProps{
								Description: "HTTPGet specifies the http request to perform.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.HTTPGetAction"),
							},
						},
						"tcpSocket": {
							SchemaProps: spec.SchemaProps{
								Description: "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.TCPSocketAction"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ExecAction", "k8s.io/kubernetes/pkg/api/v1.HTTPGetAction", "k8s.io/kubernetes/pkg/api/v1.TCPSocketAction"},
		},
		"k8s.io/kubernetes/pkg/api/v1.HostAlias": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.",
					Properties: map[string]spec.Schema{
						"ip": {
							SchemaProps: spec.SchemaProps{
								Description: "IP address of the host file entry.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"hostnames": {
							SchemaProps: spec.SchemaProps{
								Description: "Hostnames for the above IP address.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.HostPathVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path of the directory on the host. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"path"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ISCSIVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"targetPortal": {
							SchemaProps: spec.SchemaProps{
								Description: "iSCSI target portal. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"iqn": {
							SchemaProps: spec.SchemaProps{
								Description: "Target iSCSI Qualified Name.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lun": {
							SchemaProps: spec.SchemaProps{
								Description: "iSCSI target lun number.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"iscsiInterface": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: Defaults to 'default' (tcp). iSCSI interface name that uses an iSCSI transport.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"portals": {
							SchemaProps: spec.SchemaProps{
								Description: "iSCSI target portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"chapAuthDiscovery": {
							SchemaProps: spec.SchemaProps{
								Description: "whether support iSCSI Discovery CHAP authentication",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"chapAuthSession": {
							SchemaProps: spec.SchemaProps{
								Description: "whether support iSCSI Session CHAP authentication",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"secretRef": {
							SchemaProps: spec.SchemaProps{
								Description: "CHAP secret for iSCSI target and initiator authentication",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
					},
					Required: []string{"targetPortal", "iqn", "lun"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.KeyToPath": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Maps a string key to a path within a volume.",
					Properties: map[string]spec.Schema{
						"key": {
							SchemaProps: spec.SchemaProps{
								Description: "The key to project.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"mode": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"key", "path"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.Lifecycle": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.",
					Properties: map[string]spec.Schema{
						"postStart": {
							SchemaProps: spec.SchemaProps{
								Description: "PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.Handler"),
							},
						},
						"preStop": {
							SchemaProps: spec.SchemaProps{
								Description: "PreStop is called immediately before a container is terminated. The container is terminated after the handler completes. The reason for termination is passed to the handler. Regardless of the outcome of the handler, the container is eventually terminated. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.Handler"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.Handler"},
		},
		"k8s.io/kubernetes/pkg/api/v1.LimitRange": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "LimitRange sets resource usage limits for each kind of resource in a Namespace.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LimitRangeSpec"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.LimitRangeSpec"},
		},
		"k8s.io/kubernetes/pkg/api/v1.LimitRangeItem": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "LimitRangeItem defines a min/max usage limit for any resource that matches on kind.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of resource that this limit applies to.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"max": {
							SchemaProps: spec.SchemaProps{
								Description: "Max usage constraints on this kind by resource name.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
						"min": {
							SchemaProps: spec.SchemaProps{
								Description: "Min usage constraints on this kind by resource name.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
						"default": {
							SchemaProps: spec.SchemaProps{
								Description: "Default resource requirement limit value by resource name if resource limit is omitted.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
						"defaultRequest": {
							SchemaProps: spec.SchemaProps{
								Description: "DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
						"maxLimitRequestRatio": {
							SchemaProps: spec.SchemaProps{
								Description: "MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/api/resource.Quantity"},
		},
		"k8s.io/kubernetes/pkg/api/v1.LimitRangeList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "LimitRangeList is a list of LimitRange items.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of LimitRange objects. More info: https://git.k8s.io/community/contributors/design-proposals/admission_control_limit_range.md",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.LimitRange"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.LimitRange"},
		},
		"k8s.io/kubernetes/pkg/api/v1.LimitRangeSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "LimitRangeSpec defines a min/max usage limit for resources that match on kind.",
					Properties: map[string]spec.Schema{
						"limits": {
							SchemaProps: spec.SchemaProps{
								Description: "Limits is the list of LimitRangeItem objects that are enforced.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.LimitRangeItem"),
										},
									},
								},
							},
						},
					},
					Required: []string{"limits"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.LimitRangeItem"},
		},
		"k8s.io/kubernetes/pkg/api/v1.List": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "List holds a list of objects, which may not be known by the server.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of objects",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"k8s.io/kubernetes/pkg/api/v1.LoadBalancerIngress": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.",
					Properties: map[string]spec.Schema{
						"ip": {
							SchemaProps: spec.SchemaProps{
								Description: "IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"hostname": {
							SchemaProps: spec.SchemaProps{
								Description: "Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.LoadBalancerStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "LoadBalancerStatus represents the status of a load-balancer.",
					Properties: map[string]spec.Schema{
						"ingress": {
							SchemaProps: spec.SchemaProps{
								Description: "Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.LoadBalancerIngress"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.LoadBalancerIngress"},
		},
		"k8s.io/kubernetes/pkg/api/v1.LocalObjectReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.LocalVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Local represents directly-attached storage with node affinity",
					Properties: map[string]spec.Schema{
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "The full path to the volume on the node For alpha, this path must be a directory Once block as a source is supported, then this path can point to a block device",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"path"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.NFSVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"server": {
							SchemaProps: spec.SchemaProps{
								Description: "Server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"server", "path"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.Namespace": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Namespace provides a scope for Names. Use of multiple namespaces is optional.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the behavior of the Namespace. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NamespaceSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status describes the current status of a Namespace. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NamespaceStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.NamespaceSpec", "k8s.io/kubernetes/pkg/api/v1.NamespaceStatus"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NamespaceList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NamespaceList is a list of Namespaces.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of Namespace objects in the list. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Namespace"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.Namespace"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NamespaceSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NamespaceSpec describes the attributes on a Namespace.",
					Properties: map[string]spec.Schema{
						"finalizers": {
							SchemaProps: spec.SchemaProps{
								Description: "Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: https://git.k8s.io/community/contributors/design-proposals/namespaces.md#finalizers",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.NamespaceStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NamespaceStatus is information about the current status of a Namespace.",
					Properties: map[string]spec.Schema{
						"phase": {
							SchemaProps: spec.SchemaProps{
								Description: "Phase is the current lifecycle phase of the namespace. More info: https://git.k8s.io/community/contributors/design-proposals/namespaces.md#phases",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.Node": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Node is a worker node in Kubernetes. Each node will have a unique identifier in the cache (i.e. in etcd).",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NodeSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Most recently observed status of the node. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NodeStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.NodeSpec", "k8s.io/kubernetes/pkg/api/v1.NodeStatus"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeAddress": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NodeAddress contains information for the node's address.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Node address type, one of Hostname, ExternalIP or InternalIP.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"address": {
							SchemaProps: spec.SchemaProps{
								Description: "The node address.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "address"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeAffinity": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Node affinity is a group of node affinity scheduling rules.",
					Properties: map[string]spec.Schema{
						"requiredDuringSchedulingIgnoredDuringExecution": {
							SchemaProps: spec.SchemaProps{
								Description: "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NodeSelector"),
							},
						},
						"preferredDuringSchedulingIgnoredDuringExecution": {
							SchemaProps: spec.SchemaProps{
								Description: "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.PreferredSchedulingTerm"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.NodeSelector", "k8s.io/kubernetes/pkg/api/v1.PreferredSchedulingTerm"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NodeCondition contains condition information for a node.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of node condition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of True, False, Unknown.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastHeartbeatTime": {
							SchemaProps: spec.SchemaProps{
								Description: "Last time we got an update on a given condition.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "Last time the condition transit from one status to another.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "(brief) reason for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Human readable message indicating details about last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeDaemonEndpoints": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NodeDaemonEndpoints lists ports opened by daemons running on the Node.",
					Properties: map[string]spec.Schema{
						"kubeletEndpoint": {
							SchemaProps: spec.SchemaProps{
								Description: "Endpoint on which Kubelet is listening.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.DaemonEndpoint"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.DaemonEndpoint"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NodeList is the whole list of all Nodes which have been registered with master.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of nodes",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Node"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.Node"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeProxyOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NodeProxyOptions is the query options to a Node's proxy call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path is the URL path to use for the current proxy request to node.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeResources": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NodeResources is an object for conveying resource information about a node. see http://releases.k8s.io/HEAD/docs/design/resources.md for more details.",
					Properties: map[string]spec.Schema{
						"Capacity": {
							SchemaProps: spec.SchemaProps{
								Description: "Capacity represents the available resources of a node",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
					},
					Required: []string{"Capacity"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/api/resource.Quantity"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeSelector": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms.",
					Properties: map[string]spec.Schema{
						"nodeSelectorTerms": {
							SchemaProps: spec.SchemaProps{
								Description: "Required. A list of node selector terms. The terms are ORed.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.NodeSelectorTerm"),
										},
									},
								},
							},
						},
					},
					Required: []string{"nodeSelectorTerms"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.NodeSelectorTerm"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeSelectorRequirement": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
					Properties: map[string]spec.Schema{
						"key": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "key",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "The label key that the selector applies to.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"operator": {
							SchemaProps: spec.SchemaProps{
								Description: "Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"values": {
							SchemaProps: spec.SchemaProps{
								Description: "An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"key", "operator"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeSelectorTerm": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A null or empty node selector term matches no objects.",
					Properties: map[string]spec.Schema{
						"matchExpressions": {
							SchemaProps: spec.SchemaProps{
								Description: "Required. A list of node selector requirements. The requirements are ANDed.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.NodeSelectorRequirement"),
										},
									},
								},
							},
						},
					},
					Required: []string{"matchExpressions"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.NodeSelectorRequirement"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NodeSpec describes the attributes that a node is created with.",
					Properties: map[string]spec.Schema{
						"podCIDR": {
							SchemaProps: spec.SchemaProps{
								Description: "PodCIDR represents the pod IP range assigned to the node.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"externalID": {
							SchemaProps: spec.SchemaProps{
								Description: "External ID of the node assigned by some machine database (e.g. a cloud provider). Deprecated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"providerID": {
							SchemaProps: spec.SchemaProps{
								Description: "ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"unschedulable": {
							SchemaProps: spec.SchemaProps{
								Description: "Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"taints": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, the node's taints.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Taint"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.Taint"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NodeStatus is information about the current status of a node.",
					Properties: map[string]spec.Schema{
						"capacity": {
							SchemaProps: spec.SchemaProps{
								Description: "Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
						"allocatable": {
							SchemaProps: spec.SchemaProps{
								Description: "Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
						"phase": {
							SchemaProps: spec.SchemaProps{
								Description: "NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"conditions": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "type",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/concepts/nodes/node/#condition",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.NodeCondition"),
										},
									},
								},
							},
						},
						"addresses": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "type",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/concepts/nodes/node/#addresses",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.NodeAddress"),
										},
									},
								},
							},
						},
						"daemonEndpoints": {
							SchemaProps: spec.SchemaProps{
								Description: "Endpoints of daemons running on the Node.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NodeDaemonEndpoints"),
							},
						},
						"nodeInfo": {
							SchemaProps: spec.SchemaProps{
								Description: "Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#info",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NodeSystemInfo"),
							},
						},
						"images": {
							SchemaProps: spec.SchemaProps{
								Description: "List of container images on this node",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ContainerImage"),
										},
									},
								},
							},
						},
						"volumesInUse": {
							SchemaProps: spec.SchemaProps{
								Description: "List of attachable volumes in use (mounted) by the node.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"volumesAttached": {
							SchemaProps: spec.SchemaProps{
								Description: "List of volumes that are attached to the node.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.AttachedVolume"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/kubernetes/pkg/api/v1.AttachedVolume", "k8s.io/kubernetes/pkg/api/v1.ContainerImage", "k8s.io/kubernetes/pkg/api/v1.NodeAddress", "k8s.io/kubernetes/pkg/api/v1.NodeCondition", "k8s.io/kubernetes/pkg/api/v1.NodeDaemonEndpoints", "k8s.io/kubernetes/pkg/api/v1.NodeSystemInfo"},
		},
		"k8s.io/kubernetes/pkg/api/v1.NodeSystemInfo": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "NodeSystemInfo is a set of ids/uuids to uniquely identify the node.",
					Properties: map[string]spec.Schema{
						"machineID": {
							SchemaProps: spec.SchemaProps{
								Description: "MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"systemUUID": {
							SchemaProps: spec.SchemaProps{
								Description: "SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-US/Red_Hat_Subscription_Management/1/html/RHSM/getting-system-uuid.html",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"bootID": {
							SchemaProps: spec.SchemaProps{
								Description: "Boot ID reported by the node.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"kernelVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"osImage": {
							SchemaProps: spec.SchemaProps{
								Description: "OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"containerRuntimeVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"kubeletVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "Kubelet Version reported by the node.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"kubeProxyVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "KubeProxy Version reported by the node.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"operatingSystem": {
							SchemaProps: spec.SchemaProps{
								Description: "The Operating System reported by the node",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"architecture": {
							SchemaProps: spec.SchemaProps{
								Description: "The Architecture reported by the node",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"machineID", "systemUUID", "bootID", "kernelVersion", "osImage", "containerRuntimeVersion", "kubeletVersion", "kubeProxyVersion", "operatingSystem", "architecture"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ObjectFieldSelector": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ObjectFieldSelector selects an APIVersioned field of an object.",
					Properties: map[string]spec.Schema{
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "Version of the schema the FieldPath is written in terms of, defaults to \"v1\".",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fieldPath": {
							SchemaProps: spec.SchemaProps{
								Description: "Path of the field to select in the specified API version.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"fieldPath"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ObjectReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ObjectReference contains enough information to let you inspect or modify the referred object.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"uid": {
							SchemaProps: spec.SchemaProps{
								Description: "UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "API version of the referent.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fieldPath": {
							SchemaProps: spec.SchemaProps{
								Description: "If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: \"spec.containers{name}\" (where \"name\" refers to the name of the container that triggered the event) or if no container name is specified \"spec.containers[2]\" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.PersistentVolume": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PersistentVolume (PV) is a storage resource provisioned by an administrator. It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PersistentVolumeSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status represents the current information/status for the persistent volume. Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PersistentVolumeStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.PersistentVolumeSpec", "k8s.io/kubernetes/pkg/api/v1.PersistentVolumeStatus"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaim": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PersistentVolumeClaim is a user's request for and claim to a persistent volume",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimSpec", "k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimStatus"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PersistentVolumeClaimList is a list of PersistentVolumeClaim items.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "A list of persistent volume claims. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaim"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaim"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes",
					Properties: map[string]spec.Schema{
						"accessModes": {
							SchemaProps: spec.SchemaProps{
								Description: "AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"selector": {
							SchemaProps: spec.SchemaProps{
								Description: "A label query over volumes to consider for binding.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceRequirements"),
							},
						},
						"volumeName": {
							SchemaProps: spec.SchemaProps{
								Description: "VolumeName is the binding reference to the PersistentVolume backing this claim.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"storageClassName": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector", "k8s.io/kubernetes/pkg/api/v1.ResourceRequirements"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PersistentVolumeClaimStatus is the current status of a persistent volume claim.",
					Properties: map[string]spec.Schema{
						"phase": {
							SchemaProps: spec.SchemaProps{
								Description: "Phase represents the current phase of PersistentVolumeClaim.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"accessModes": {
							SchemaProps: spec.SchemaProps{
								Description: "AccessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"capacity": {
							SchemaProps: spec.SchemaProps{
								Description: "Represents the actual resources of the underlying volume.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/api/resource.Quantity"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).",
					Properties: map[string]spec.Schema{
						"claimName": {
							SchemaProps: spec.SchemaProps{
								Description: "ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Will force the ReadOnly setting in VolumeMounts. Default false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"claimName"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.PersistentVolumeList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PersistentVolumeList is a list of PersistentVolume items.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of persistent volumes. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.PersistentVolume"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.PersistentVolume"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PersistentVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PersistentVolumeSource is similar to VolumeSource but meant for the administrator who creates PVs. Exactly one of its members must be set.",
					Properties: map[string]spec.Schema{
						"gcePersistentDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.GCEPersistentDiskVolumeSource"),
							},
						},
						"awsElasticBlockStore": {
							SchemaProps: spec.SchemaProps{
								Description: "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AWSElasticBlockStoreVolumeSource"),
							},
						},
						"hostPath": {
							SchemaProps: spec.SchemaProps{
								Description: "HostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.HostPathVolumeSource"),
							},
						},
						"glusterfs": {
							SchemaProps: spec.SchemaProps{
								Description: "Glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.GlusterfsVolumeSource"),
							},
						},
						"nfs": {
							SchemaProps: spec.SchemaProps{
								Description: "NFS represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NFSVolumeSource"),
							},
						},
						"rbd": {
							SchemaProps: spec.SchemaProps{
								Description: "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.RBDVolumeSource"),
							},
						},
						"iscsi": {
							SchemaProps: spec.SchemaProps{
								Description: "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ISCSIVolumeSource"),
							},
						},
						"cinder": {
							SchemaProps: spec.SchemaProps{
								Description: "Cinder represents a cinder volume attached and mounted on kubelets host machine More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.CinderVolumeSource"),
							},
						},
						"cephfs": {
							SchemaProps: spec.SchemaProps{
								Description: "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.CephFSVolumeSource"),
							},
						},
						"fc": {
							SchemaProps: spec.SchemaProps{
								Description: "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FCVolumeSource"),
							},
						},
						"flocker": {
							SchemaProps: spec.SchemaProps{
								Description: "Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FlockerVolumeSource"),
							},
						},
						"flexVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. This is an alpha feature and may change in future.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FlexVolumeSource"),
							},
						},
						"azureFile": {
							SchemaProps: spec.SchemaProps{
								Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AzureFileVolumeSource"),
							},
						},
						"vsphereVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.VsphereVirtualDiskVolumeSource"),
							},
						},
						"quobyte": {
							SchemaProps: spec.SchemaProps{
								Description: "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.QuobyteVolumeSource"),
							},
						},
						"azureDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AzureDiskVolumeSource"),
							},
						},
						"photonPersistentDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PhotonPersistentDiskVolumeSource"),
							},
						},
						"portworxVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "PortworxVolume represents a portworx volume attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PortworxVolumeSource"),
							},
						},
						"scaleIO": {
							SchemaProps: spec.SchemaProps{
								Description: "ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ScaleIOVolumeSource"),
							},
						},
						"local": {
							SchemaProps: spec.SchemaProps{
								Description: "Local represents directly-attached storage with node affinity",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalVolumeSource"),
							},
						},
						"storageos": {
							SchemaProps: spec.SchemaProps{
								Description: "StorageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod More info: https://releases.k8s.io/HEAD/examples/volumes/storageos/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.StorageOSPersistentVolumeSource"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.AWSElasticBlockStoreVolumeSource", "k8s.io/kubernetes/pkg/api/v1.AzureDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.AzureFileVolumeSource", "k8s.io/kubernetes/pkg/api/v1.CephFSVolumeSource", "k8s.io/kubernetes/pkg/api/v1.CinderVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FCVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FlexVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FlockerVolumeSource", "k8s.io/kubernetes/pkg/api/v1.GCEPersistentDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.GlusterfsVolumeSource", "k8s.io/kubernetes/pkg/api/v1.HostPathVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ISCSIVolumeSource", "k8s.io/kubernetes/pkg/api/v1.LocalVolumeSource", "k8s.io/kubernetes/pkg/api/v1.NFSVolumeSource", "k8s.io/kubernetes/pkg/api/v1.PhotonPersistentDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.PortworxVolumeSource", "k8s.io/kubernetes/pkg/api/v1.QuobyteVolumeSource", "k8s.io/kubernetes/pkg/api/v1.RBDVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ScaleIOVolumeSource", "k8s.io/kubernetes/pkg/api/v1.StorageOSPersistentVolumeSource", "k8s.io/kubernetes/pkg/api/v1.VsphereVirtualDiskVolumeSource"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PersistentVolumeSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PersistentVolumeSpec is the specification of a persistent volume.",
					Properties: map[string]spec.Schema{
						"capacity": {
							SchemaProps: spec.SchemaProps{
								Description: "A description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
						"gcePersistentDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.GCEPersistentDiskVolumeSource"),
							},
						},
						"awsElasticBlockStore": {
							SchemaProps: spec.SchemaProps{
								Description: "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AWSElasticBlockStoreVolumeSource"),
							},
						},
						"hostPath": {
							SchemaProps: spec.SchemaProps{
								Description: "HostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.HostPathVolumeSource"),
							},
						},
						"glusterfs": {
							SchemaProps: spec.SchemaProps{
								Description: "Glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.GlusterfsVolumeSource"),
							},
						},
						"nfs": {
							SchemaProps: spec.SchemaProps{
								Description: "NFS represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NFSVolumeSource"),
							},
						},
						"rbd": {
							SchemaProps: spec.SchemaProps{
								Description: "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.RBDVolumeSource"),
							},
						},
						"iscsi": {
							SchemaProps: spec.SchemaProps{
								Description: "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ISCSIVolumeSource"),
							},
						},
						"cinder": {
							SchemaProps: spec.SchemaProps{
								Description: "Cinder represents a cinder volume attached and mounted on kubelets host machine More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.CinderVolumeSource"),
							},
						},
						"cephfs": {
							SchemaProps: spec.SchemaProps{
								Description: "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.CephFSVolumeSource"),
							},
						},
						"fc": {
							SchemaProps: spec.SchemaProps{
								Description: "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FCVolumeSource"),
							},
						},
						"flocker": {
							SchemaProps: spec.SchemaProps{
								Description: "Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FlockerVolumeSource"),
							},
						},
						"flexVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. This is an alpha feature and may change in future.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FlexVolumeSource"),
							},
						},
						"azureFile": {
							SchemaProps: spec.SchemaProps{
								Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AzureFileVolumeSource"),
							},
						},
						"vsphereVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.VsphereVirtualDiskVolumeSource"),
							},
						},
						"quobyte": {
							SchemaProps: spec.SchemaProps{
								Description: "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.QuobyteVolumeSource"),
							},
						},
						"azureDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AzureDiskVolumeSource"),
							},
						},
						"photonPersistentDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PhotonPersistentDiskVolumeSource"),
							},
						},
						"portworxVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "PortworxVolume represents a portworx volume attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PortworxVolumeSource"),
							},
						},
						"scaleIO": {
							SchemaProps: spec.SchemaProps{
								Description: "ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ScaleIOVolumeSource"),
							},
						},
						"local": {
							SchemaProps: spec.SchemaProps{
								Description: "Local represents directly-attached storage with node affinity",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalVolumeSource"),
							},
						},
						"storageos": {
							SchemaProps: spec.SchemaProps{
								Description: "StorageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod More info: https://releases.k8s.io/HEAD/examples/volumes/storageos/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.StorageOSPersistentVolumeSource"),
							},
						},
						"accessModes": {
							SchemaProps: spec.SchemaProps{
								Description: "AccessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"claimRef": {
							SchemaProps: spec.SchemaProps{
								Description: "ClaimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
						"persistentVolumeReclaimPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "What happens to a persistent volume when released from its claim. Valid options are Retain (default) and Recycle. Recycling must be supported by the volume plugin underlying this persistent volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"storageClassName": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/kubernetes/pkg/api/v1.AWSElasticBlockStoreVolumeSource", "k8s.io/kubernetes/pkg/api/v1.AzureDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.AzureFileVolumeSource", "k8s.io/kubernetes/pkg/api/v1.CephFSVolumeSource", "k8s.io/kubernetes/pkg/api/v1.CinderVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FCVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FlexVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FlockerVolumeSource", "k8s.io/kubernetes/pkg/api/v1.GCEPersistentDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.GlusterfsVolumeSource", "k8s.io/kubernetes/pkg/api/v1.HostPathVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ISCSIVolumeSource", "k8s.io/kubernetes/pkg/api/v1.LocalVolumeSource", "k8s.io/kubernetes/pkg/api/v1.NFSVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ObjectReference", "k8s.io/kubernetes/pkg/api/v1.PhotonPersistentDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.PortworxVolumeSource", "k8s.io/kubernetes/pkg/api/v1.QuobyteVolumeSource", "k8s.io/kubernetes/pkg/api/v1.RBDVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ScaleIOVolumeSource", "k8s.io/kubernetes/pkg/api/v1.StorageOSPersistentVolumeSource", "k8s.io/kubernetes/pkg/api/v1.VsphereVirtualDiskVolumeSource"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PersistentVolumeStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PersistentVolumeStatus is the current status of a persistent volume.",
					Properties: map[string]spec.Schema{
						"phase": {
							SchemaProps: spec.SchemaProps{
								Description: "Phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "A human-readable message indicating details about why the volume is in this state.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "Reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.PhotonPersistentDiskVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a Photon Controller persistent disk resource.",
					Properties: map[string]spec.Schema{
						"pdID": {
							SchemaProps: spec.SchemaProps{
								Description: "ID that identifies Photon Controller persistent disk",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"pdID"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.Pod": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.PodSpec", "k8s.io/kubernetes/pkg/api/v1.PodStatus"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodAffinity": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Pod affinity is a group of inter pod affinity scheduling rules.",
					Properties: map[string]spec.Schema{
						"requiredDuringSchedulingIgnoredDuringExecution": {
							SchemaProps: spec.SchemaProps{
								Description: "NOT YET IMPLEMENTED. TODO: Uncomment field once it is implemented. If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system will try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied. RequiredDuringSchedulingRequiredDuringExecution []PodAffinityTerm  `json:\"requiredDuringSchedulingRequiredDuringExecution,omitempty\"` If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.PodAffinityTerm"),
										},
									},
								},
							},
						},
						"preferredDuringSchedulingIgnoredDuringExecution": {
							SchemaProps: spec.SchemaProps{
								Description: "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.WeightedPodAffinityTerm"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.PodAffinityTerm", "k8s.io/kubernetes/pkg/api/v1.WeightedPodAffinityTerm"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodAffinityTerm": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> tches that of any node on which a pod of the set of pods is running",
					Properties: map[string]spec.Schema{
						"labelSelector": {
							SchemaProps: spec.SchemaProps{
								Description: "A label query over a set of resources, in this case pods.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
							},
						},
						"namespaces": {
							SchemaProps: spec.SchemaProps{
								Description: "namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means \"this pod's namespace\"",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"topologyKey": {
							SchemaProps: spec.SchemaProps{
								Description: "This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. For PreferredDuringScheduling pod anti-affinity, empty topologyKey is interpreted as \"all topologies\" (\"all topologies\" here means all the topologyKeys indicated by scheduler command-line argument --failure-domains); for affinity and for RequiredDuringScheduling pod anti-affinity, empty topologyKey is not allowed.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodAntiAffinity": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Pod anti affinity is a group of inter pod anti affinity scheduling rules.",
					Properties: map[string]spec.Schema{
						"requiredDuringSchedulingIgnoredDuringExecution": {
							SchemaProps: spec.SchemaProps{
								Description: "NOT YET IMPLEMENTED. TODO: Uncomment field once it is implemented. If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system will try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied. RequiredDuringSchedulingRequiredDuringExecution []PodAffinityTerm  `json:\"requiredDuringSchedulingRequiredDuringExecution,omitempty\"` If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.PodAffinityTerm"),
										},
									},
								},
							},
						},
						"preferredDuringSchedulingIgnoredDuringExecution": {
							SchemaProps: spec.SchemaProps{
								Description: "The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.WeightedPodAffinityTerm"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.PodAffinityTerm", "k8s.io/kubernetes/pkg/api/v1.WeightedPodAffinityTerm"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodAttachOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodAttachOptions is the query options to a Pod's remote attach call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"stdin": {
							SchemaProps: spec.SchemaProps{
								Description: "Stdin if true, redirects the standard input stream of the pod for this call. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"stdout": {
							SchemaProps: spec.SchemaProps{
								Description: "Stdout if true indicates that stdout is to be redirected for the attach call. Defaults to true.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"stderr": {
							SchemaProps: spec.SchemaProps{
								Description: "Stderr if true indicates that stderr is to be redirected for the attach call. Defaults to true.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"tty": {
							SchemaProps: spec.SchemaProps{
								Description: "TTY if true indicates that a tty will be allocated for the attach call. This is passed through the container runtime so the tty is allocated on the worker node by the container runtime. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"container": {
							SchemaProps: spec.SchemaProps{
								Description: "The container in which to execute the command. Defaults to only container if there is only one container in the pod.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodCondition contains details for the current condition of this pod.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type is the type of the condition. Currently only Ready. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastProbeTime": {
							SchemaProps: spec.SchemaProps{
								Description: "Last time we probed the condition.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "Last time the condition transitioned from one status to another.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "Unique, one-word, CamelCase reason for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Human-readable message indicating details about last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodExecOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodExecOptions is the query options to a Pod's remote exec call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"stdin": {
							SchemaProps: spec.SchemaProps{
								Description: "Redirect the standard input stream of the pod for this call. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"stdout": {
							SchemaProps: spec.SchemaProps{
								Description: "Redirect the standard output stream of the pod for this call. Defaults to true.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"stderr": {
							SchemaProps: spec.SchemaProps{
								Description: "Redirect the standard error stream of the pod for this call. Defaults to true.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"tty": {
							SchemaProps: spec.SchemaProps{
								Description: "TTY if true indicates that a tty will be allocated for the exec call. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"container": {
							SchemaProps: spec.SchemaProps{
								Description: "Container in which to execute the command. Defaults to only container if there is only one container in the pod.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"command": {
							SchemaProps: spec.SchemaProps{
								Description: "Command is the remote command to execute. argv array. Not executed within a shell.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"command"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodList is a list of Pods.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of pods. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Pod"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.Pod"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodLogOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodLogOptions is the query options for a Pod's logs REST call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"container": {
							SchemaProps: spec.SchemaProps{
								Description: "The container for which to stream logs. Defaults to only container if there is one container in the pod.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"follow": {
							SchemaProps: spec.SchemaProps{
								Description: "Follow the log stream of the pod. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"previous": {
							SchemaProps: spec.SchemaProps{
								Description: "Return previous terminated container logs. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"sinceSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "A relative time in seconds before the current time from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"sinceTime": {
							SchemaProps: spec.SchemaProps{
								Description: "An RFC3339 timestamp from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"timestamps": {
							SchemaProps: spec.SchemaProps{
								Description: "If true, add an RFC3339 or RFC3339Nano timestamp at the beginning of every line of log output. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"tailLines": {
							SchemaProps: spec.SchemaProps{
								Description: "If set, the number of lines from the end of the logs to show. If not specified, logs are shown from the creation of the container or sinceSeconds or sinceTime",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"limitBytes": {
							SchemaProps: spec.SchemaProps{
								Description: "If set, the number of bytes to read from the server before terminating the log output. This may not display a complete final line of logging, and may return slightly more or slightly less than the specified limit.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodPortForwardOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodPortForwardOptions is the query options to a Pod's port forward call when using WebSockets. The `port` query parameter must specify the port or ports (comma separated) to forward over. Port forwarding over SPDY does not use these options. It requires the port to be passed in the `port` header as part of request.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"ports": {
							SchemaProps: spec.SchemaProps{
								Description: "List of ports to forward Required when using WebSockets",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"integer"},
											Format: "int32",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodProxyOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodProxyOptions is the query options to a Pod's proxy call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path is the URL path to use for the current proxy request to pod.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodSecurityContext": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodSecurityContext holds pod-level security attributes and common container settings. Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext.",
					Properties: map[string]spec.Schema{
						"seLinuxOptions": {
							SchemaProps: spec.SchemaProps{
								Description: "The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.SELinuxOptions"),
							},
						},
						"runAsUser": {
							SchemaProps: spec.SchemaProps{
								Description: "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"runAsNonRoot": {
							SchemaProps: spec.SchemaProps{
								Description: "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"supplementalGroups": {
							SchemaProps: spec.SchemaProps{
								Description: "A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"integer"},
											Format: "int64",
										},
									},
								},
							},
						},
						"fsGroup": {
							SchemaProps: spec.SchemaProps{
								Description: "A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:\n\n1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----\n\nIf unset, the Kubelet will not modify the ownership and permissions of any volume.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.SELinuxOptions"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodSignature": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Describes the class of pods that should avoid this node. Exactly one field should be set.",
					Properties: map[string]spec.Schema{
						"podController": {
							SchemaProps: spec.SchemaProps{
								Description: "Reference to controller whose pods should avoid this node.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodSpec is a description of a pod.",
					Properties: map[string]spec.Schema{
						"volumes": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "name",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Volume"),
										},
									},
								},
							},
						},
						"initContainers": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "name",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, or Liveness probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Container"),
										},
									},
								},
							},
						},
						"containers": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "name",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Container"),
										},
									},
								},
							},
						},
						"restartPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "Restart policy for all containers within the pod. One of Always, OnFailure, Never. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"terminationGracePeriodSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"activeDeadlineSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"dnsPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "Set DNS policy for containers within the pod. One of 'ClusterFirstWithHostNet', 'ClusterFirst' or 'Default'. Defaults to \"ClusterFirst\". To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"nodeSelector": {
							SchemaProps: spec.SchemaProps{
								Description: "NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"serviceAccountName": {
							SchemaProps: spec.SchemaProps{
								Description: "ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"serviceAccount": {
							SchemaProps: spec.SchemaProps{
								Description: "DeprecatedServiceAccount is a depreciated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"automountServiceAccountToken": {
							SchemaProps: spec.SchemaProps{
								Description: "AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"nodeName": {
							SchemaProps: spec.SchemaProps{
								Description: "NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"hostNetwork": {
							SchemaProps: spec.SchemaProps{
								Description: "Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified. Default to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"hostPID": {
							SchemaProps: spec.SchemaProps{
								Description: "Use the host's pid namespace. Optional: Default to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"hostIPC": {
							SchemaProps: spec.SchemaProps{
								Description: "Use the host's ipc namespace. Optional: Default to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"securityContext": {
							SchemaProps: spec.SchemaProps{
								Description: "SecurityContext holds pod-level security attributes and common container settings. Optional: Defaults to empty.  See type description for default values of each field.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodSecurityContext"),
							},
						},
						"imagePullSecrets": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "name",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
										},
									},
								},
							},
						},
						"hostname": {
							SchemaProps: spec.SchemaProps{
								Description: "Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"subdomain": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, the fully qualified Pod hostname will be \"<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>\". If not specified, the pod will not have a domainname at all.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"affinity": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, the pod's scheduling constraints",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.Affinity"),
							},
						},
						"schedulerName": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"tolerations": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, the pod's tolerations.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Toleration"),
										},
									},
								},
							},
						},
						"hostAliases": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "ip",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified. This is only valid for non-hostNetwork pods.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.HostAlias"),
										},
									},
								},
							},
						},
					},
					Required: []string{"containers"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.Affinity", "k8s.io/kubernetes/pkg/api/v1.Container", "k8s.io/kubernetes/pkg/api/v1.HostAlias", "k8s.io/kubernetes/pkg/api/v1.LocalObjectReference", "k8s.io/kubernetes/pkg/api/v1.PodSecurityContext", "k8s.io/kubernetes/pkg/api/v1.Toleration", "k8s.io/kubernetes/pkg/api/v1.Volume"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodStatus represents information about the status of a pod. Status may trail the actual state of a system.",
					Properties: map[string]spec.Schema{
						"phase": {
							SchemaProps: spec.SchemaProps{
								Description: "Current condition of the pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"conditions": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "type",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Current service state of pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.PodCondition"),
										},
									},
								},
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "A human readable message indicating details about why the pod is in this condition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "A brief CamelCase message indicating details about why the pod is in this state. e.g. 'OutOfDisk'",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"hostIP": {
							SchemaProps: spec.SchemaProps{
								Description: "IP address of the host to which the pod is assigned. Empty if not yet scheduled.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"podIP": {
							SchemaProps: spec.SchemaProps{
								Description: "IP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"startTime": {
							SchemaProps: spec.SchemaProps{
								Description: "RFC 3339 date and time at which the object was acknowledged by the Kubelet. This is before the Kubelet pulled the container image(s) for the pod.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"initContainerStatuses": {
							SchemaProps: spec.SchemaProps{
								Description: "The list has one entry per init container in the manifest. The most recent successful init container will have ready = true, the most recently started container will have startTime set. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ContainerStatus"),
										},
									},
								},
							},
						},
						"containerStatuses": {
							SchemaProps: spec.SchemaProps{
								Description: "The list has one entry per container in the manifest. Each entry is currently the output of `docker inspect`. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ContainerStatus"),
										},
									},
								},
							},
						},
						"qosClass": {
							SchemaProps: spec.SchemaProps{
								Description: "The Quality of Service (QOS) classification assigned to the pod based on resource requirements See PodQOSClass type for available QOS classes More info: https://github.com/kubernetes/kubernetes/blob/master/docs/design/resource-qos.md",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time", "k8s.io/kubernetes/pkg/api/v1.ContainerStatus", "k8s.io/kubernetes/pkg/api/v1.PodCondition"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodStatusResult": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodStatusResult is a wrapper for PodStatus returned by kubelet that can be encode/decoded",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.PodStatus"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodTemplate": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodTemplate describes a template for creating copies of a predefined pod.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"template": {
							SchemaProps: spec.SchemaProps{
								Description: "Template defines the pods that will be created from this pod template. https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodTemplateList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodTemplateList is a list of PodTemplates.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of pod templates",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.PodTemplate"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.PodTemplate"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PodTemplateSpec describes the data a pod should have when created from a template",
					Properties: map[string]spec.Schema{
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodSpec"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.PodSpec"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PortworxVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PortworxVolumeSource represents a Portworx volume resource.",
					Properties: map[string]spec.Schema{
						"volumeID": {
							SchemaProps: spec.SchemaProps{
								Description: "VolumeID uniquely identifies a Portworx volume",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "FSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\". Implicitly inferred to be \"ext4\" if unspecified.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"volumeID"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.PreferAvoidPodsEntry": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Describes a class of pods that should avoid this node.",
					Properties: map[string]spec.Schema{
						"podSignature": {
							SchemaProps: spec.SchemaProps{
								Description: "The class of pods.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodSignature"),
							},
						},
						"evictionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "Time at which this entry was added to the list.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "(brief) reason why this entry was added to the list.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Human readable message indicating why this entry was added to the list.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"podSignature"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time", "k8s.io/kubernetes/pkg/api/v1.PodSignature"},
		},
		"k8s.io/kubernetes/pkg/api/v1.PreferredSchedulingTerm": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).",
					Properties: map[string]spec.Schema{
						"weight": {
							SchemaProps: spec.SchemaProps{
								Description: "Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"preference": {
							SchemaProps: spec.SchemaProps{
								Description: "A node selector term, associated with the corresponding weight.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NodeSelectorTerm"),
							},
						},
					},
					Required: []string{"weight", "preference"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.NodeSelectorTerm"},
		},
		"k8s.io/kubernetes/pkg/api/v1.Probe": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.",
					Properties: map[string]spec.Schema{
						"exec": {
							SchemaProps: spec.SchemaProps{
								Description: "One and only one of the following should be specified. Exec specifies the action to take.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ExecAction"),
							},
						},
						"httpGet": {
							SchemaProps: spec.SchemaProps{
								Description: "HTTPGet specifies the http request to perform.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.HTTPGetAction"),
							},
						},
						"tcpSocket": {
							SchemaProps: spec.SchemaProps{
								Description: "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.TCPSocketAction"),
							},
						},
						"initialDelaySeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"timeoutSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"periodSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"successThreshold": {
							SchemaProps: spec.SchemaProps{
								Description: "Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness. Minimum value is 1.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"failureThreshold": {
							SchemaProps: spec.SchemaProps{
								Description: "Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ExecAction", "k8s.io/kubernetes/pkg/api/v1.HTTPGetAction", "k8s.io/kubernetes/pkg/api/v1.TCPSocketAction"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ProjectedVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a projected volume source",
					Properties: map[string]spec.Schema{
						"sources": {
							SchemaProps: spec.SchemaProps{
								Description: "list of volume projections",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.VolumeProjection"),
										},
									},
								},
							},
						},
						"defaultMode": {
							SchemaProps: spec.SchemaProps{
								Description: "Mode bits to use on created files by default. Must be a value between 0 and 0777. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"sources"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.VolumeProjection"},
		},
		"k8s.io/kubernetes/pkg/api/v1.QuobyteVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"registry": {
							SchemaProps: spec.SchemaProps{
								Description: "Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"volume": {
							SchemaProps: spec.SchemaProps{
								Description: "Volume is a string that references an already created Quobyte volume by name.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "User to map volume access to Defaults to serivceaccount user",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"group": {
							SchemaProps: spec.SchemaProps{
								Description: "Group to map volume access to Default is no group",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"registry", "volume"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.RBDVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"monitors": {
							SchemaProps: spec.SchemaProps{
								Description: "A collection of Ceph monitors. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"image": {
							SchemaProps: spec.SchemaProps{
								Description: "The rados image name. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"pool": {
							SchemaProps: spec.SchemaProps{
								Description: "The rados pool name. Default is rbd. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "The rados user name. Default is admin. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"keyring": {
							SchemaProps: spec.SchemaProps{
								Description: "Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"secretRef": {
							SchemaProps: spec.SchemaProps{
								Description: "SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"monitors", "image"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.RangeAllocation": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RangeAllocation is not a public type.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"range": {
							SchemaProps: spec.SchemaProps{
								Description: "Range is string that identifies the range represented by 'data'.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"data": {
							SchemaProps: spec.SchemaProps{
								Description: "Data is a bit array containing all allocated addresses in the previous segment.",
								Type:        []string{"string"},
								Format:      "byte",
							},
						},
					},
					Required: []string{"range", "data"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ReplicationController": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ReplicationController represents the configuration of a replication controller.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "If the Labels of a ReplicationController are empty, they are defaulted to be the same as the Pod(s) that the replication controller manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the specification of the desired behavior of the replication controller. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ReplicationControllerSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status is the most recently observed status of the replication controller. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ReplicationControllerStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.ReplicationControllerSpec", "k8s.io/kubernetes/pkg/api/v1.ReplicationControllerStatus"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ReplicationControllerCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ReplicationControllerCondition describes the state of a replication controller at a certain point.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of replication controller condition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of True, False, Unknown.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "The last time the condition transitioned from one status to another.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "The reason for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "A human readable message indicating details about the transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ReplicationControllerList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ReplicationControllerList is a collection of replication controllers.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of replication controllers. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ReplicationController"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.ReplicationController"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ReplicationControllerSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ReplicationControllerSpec is the specification of a replication controller.",
					Properties: map[string]spec.Schema{
						"replicas": {
							SchemaProps: spec.SchemaProps{
								Description: "Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"minReadySeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"selector": {
							SchemaProps: spec.SchemaProps{
								Description: "Selector is a label query over pods that should match the Replicas count. If Selector is empty, it is defaulted to the labels present on the Pod template. Label keys and values that must match in order to be controlled by this replication controller, if empty defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"template": {
							SchemaProps: spec.SchemaProps{
								Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected. This takes precedence over a TemplateRef. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ReplicationControllerStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ReplicationControllerStatus represents the current status of a replication controller.",
					Properties: map[string]spec.Schema{
						"replicas": {
							SchemaProps: spec.SchemaProps{
								Description: "Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"fullyLabeledReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "The number of pods that have labels matching the labels of the pod template of the replication controller.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"readyReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "The number of ready replicas for this replication controller.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"availableReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "The number of available replicas (ready for at least minReadySeconds) for this replication controller.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"observedGeneration": {
							SchemaProps: spec.SchemaProps{
								Description: "ObservedGeneration reflects the generation of the most recently observed replication controller.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"conditions": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "type",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Represents the latest available observations of a replication controller's current state.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ReplicationControllerCondition"),
										},
									},
								},
							},
						},
					},
					Required: []string{"replicas"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ReplicationControllerCondition"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ResourceFieldSelector": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ResourceFieldSelector represents container resources (cpu, memory) and their output format",
					Properties: map[string]spec.Schema{
						"containerName": {
							SchemaProps: spec.SchemaProps{
								Description: "Container name: required for volumes, optional for env vars",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resource": {
							SchemaProps: spec.SchemaProps{
								Description: "Required: resource to select",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"divisor": {
							SchemaProps: spec.SchemaProps{
								Description: "Specifies the output format of the exposed resources, defaults to \"1\"",
								Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
							},
						},
					},
					Required: []string{"resource"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/api/resource.Quantity"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ResourceQuota": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ResourceQuota sets aggregate quota restrictions enforced per namespace",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the desired quota. https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceQuotaSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status defines the actual enforced quota and its current usage. https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ResourceQuotaStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.ResourceQuotaSpec", "k8s.io/kubernetes/pkg/api/v1.ResourceQuotaStatus"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ResourceQuotaList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ResourceQuotaList is a list of ResourceQuota items.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of ResourceQuota objects. More info: https://git.k8s.io/community/contributors/design-proposals/admission_control_resource_quota.md",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ResourceQuota"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.ResourceQuota"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ResourceQuotaSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ResourceQuotaSpec defines the desired hard limits to enforce for Quota.",
					Properties: map[string]spec.Schema{
						"hard": {
							SchemaProps: spec.SchemaProps{
								Description: "Hard is the set of desired hard limits for each named resource. More info: https://git.k8s.io/community/contributors/design-proposals/admission_control_resource_quota.md",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
						"scopes": {
							SchemaProps: spec.SchemaProps{
								Description: "A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/api/resource.Quantity"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ResourceQuotaStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ResourceQuotaStatus defines the enforced hard limits and observed use.",
					Properties: map[string]spec.Schema{
						"hard": {
							SchemaProps: spec.SchemaProps{
								Description: "Hard is the set of enforced hard limits for each named resource. More info: https://git.k8s.io/community/contributors/design-proposals/admission_control_resource_quota.md",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
						"used": {
							SchemaProps: spec.SchemaProps{
								Description: "Used is the current observed total usage of the resource in the namespace.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/api/resource.Quantity"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ResourceRequirements": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ResourceRequirements describes the compute resource requirements.",
					Properties: map[string]spec.Schema{
						"limits": {
							SchemaProps: spec.SchemaProps{
								Description: "Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
						"requests": {
							SchemaProps: spec.SchemaProps{
								Description: "Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/api/resource.Quantity"},
		},
		"k8s.io/kubernetes/pkg/api/v1.SELinuxOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SELinuxOptions are the labels to be applied to the container",
					Properties: map[string]spec.Schema{
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "User is a SELinux user label that applies to the container.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"role": {
							SchemaProps: spec.SchemaProps{
								Description: "Role is a SELinux role label that applies to the container.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type is a SELinux type label that applies to the container.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"level": {
							SchemaProps: spec.SchemaProps{
								Description: "Level is SELinux level label that applies to the container.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ScaleIOVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ScaleIOVolumeSource represents a persistent ScaleIO volume",
					Properties: map[string]spec.Schema{
						"gateway": {
							SchemaProps: spec.SchemaProps{
								Description: "The host address of the ScaleIO API Gateway.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"system": {
							SchemaProps: spec.SchemaProps{
								Description: "The name of the storage system as configured in ScaleIO.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"secretRef": {
							SchemaProps: spec.SchemaProps{
								Description: "SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
						"sslEnabled": {
							SchemaProps: spec.SchemaProps{
								Description: "Flag to enable/disable SSL communication with Gateway, default false",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"protectionDomain": {
							SchemaProps: spec.SchemaProps{
								Description: "The name of the Protection Domain for the configured storage (defaults to \"default\").",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"storagePool": {
							SchemaProps: spec.SchemaProps{
								Description: "The Storage Pool associated with the protection domain (defaults to \"default\").",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"storageMode": {
							SchemaProps: spec.SchemaProps{
								Description: "Indicates whether the storage for a volume should be thick or thin (defaults to \"thin\").",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"volumeName": {
							SchemaProps: spec.SchemaProps{
								Description: "The name of a volume already created in the ScaleIO system that is associated with this volume source.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"gateway", "system", "secretRef"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.Secret": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Secret holds secret data of a certain type. The total bytes of the values in the Data field must be less than MaxSecretSize bytes.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"data": {
							SchemaProps: spec.SchemaProps{
								Description: "Data contains the secret data. Each key must consist of alphanumeric characters, '-', '_' or '.'. The serialized form of the secret data is a base64 encoded string, representing the arbitrary (possibly non-string) data value here. Described in https://tools.ietf.org/html/rfc4648#section-4",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "byte",
										},
									},
								},
							},
						},
						"stringData": {
							SchemaProps: spec.SchemaProps{
								Description: "stringData allows specifying non-binary secret data in string form. It is provided as a write-only convenience method. All keys and values are merged into the data field on write, overwriting any existing values. It is never output when reading from the API.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Used to facilitate programmatic handling of secret data.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"k8s.io/kubernetes/pkg/api/v1.SecretEnvSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SecretEnvSource selects a Secret to populate the environment variables with.\n\nThe contents of the target Secret's Data field will represent the key-value pairs as environment variables.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"optional": {
							SchemaProps: spec.SchemaProps{
								Description: "Specify whether the Secret must be defined",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.SecretKeySelector": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SecretKeySelector selects a key of a Secret.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"key": {
							SchemaProps: spec.SchemaProps{
								Description: "The key of the secret to select from.  Must be a valid secret key.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"optional": {
							SchemaProps: spec.SchemaProps{
								Description: "Specify whether the Secret or it's key must be defined",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"key"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.SecretList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SecretList is a list of Secret.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is a list of secret objects. More info: https://kubernetes.io/docs/concepts/configuration/secret",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Secret"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.Secret"},
		},
		"k8s.io/kubernetes/pkg/api/v1.SecretProjection": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Adapts a secret into a projected volume.\n\nThe contents of the target Secret's Data field will be presented in a projected volume as files using the keys in the Data field as the file names. Note that this is identical to a secret volume source without the default mode.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.KeyToPath"),
										},
									},
								},
							},
						},
						"optional": {
							SchemaProps: spec.SchemaProps{
								Description: "Specify whether the Secret or its key must be defined",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.KeyToPath"},
		},
		"k8s.io/kubernetes/pkg/api/v1.SecretVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Adapts a Secret into a volume.\n\nThe contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names. Secret volumes support ownership management and SELinux relabeling.",
					Properties: map[string]spec.Schema{
						"secretName": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.KeyToPath"),
										},
									},
								},
							},
						},
						"defaultMode": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"optional": {
							SchemaProps: spec.SchemaProps{
								Description: "Specify whether the Secret or it's keys must be defined",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.KeyToPath"},
		},
		"k8s.io/kubernetes/pkg/api/v1.SecurityContext": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence.",
					Properties: map[string]spec.Schema{
						"capabilities": {
							SchemaProps: spec.SchemaProps{
								Description: "The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.Capabilities"),
							},
						},
						"privileged": {
							SchemaProps: spec.SchemaProps{
								Description: "Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"seLinuxOptions": {
							SchemaProps: spec.SchemaProps{
								Description: "The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.SELinuxOptions"),
							},
						},
						"runAsUser": {
							SchemaProps: spec.SchemaProps{
								Description: "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"runAsNonRoot": {
							SchemaProps: spec.SchemaProps{
								Description: "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"readOnlyRootFilesystem": {
							SchemaProps: spec.SchemaProps{
								Description: "Whether this container has a read-only root filesystem. Default is false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.Capabilities", "k8s.io/kubernetes/pkg/api/v1.SELinuxOptions"},
		},
		"k8s.io/kubernetes/pkg/api/v1.SerializedReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SerializedReference is a reference to serialized object.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"reference": {
							SchemaProps: spec.SchemaProps{
								Description: "The reference to an object in the system.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.Service": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the behavior of a service. https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ServiceSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Most recently observed status of the service. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ServiceStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.ServiceSpec", "k8s.io/kubernetes/pkg/api/v1.ServiceStatus"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ServiceAccount": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"secrets": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "name",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount. More info: https://kubernetes.io/docs/concepts/configuration/secret",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
										},
									},
								},
							},
						},
						"imagePullSecrets": {
							SchemaProps: spec.SchemaProps{
								Description: "ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount. ImagePullSecrets are distinct from Secrets because Secrets can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet. More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
										},
									},
								},
							},
						},
						"automountServiceAccountToken": {
							SchemaProps: spec.SchemaProps{
								Description: "AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/api/v1.LocalObjectReference", "k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ServiceAccountList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceAccountList is a list of ServiceAccount objects",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of ServiceAccounts. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ServiceAccount"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.ServiceAccount"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ServiceList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceList holds a list of services.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of services",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.Service"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/api/v1.Service"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ServicePort": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServicePort contains information on service's port.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"protocol": {
							SchemaProps: spec.SchemaProps{
								Description: "The IP protocol for this port. Supports \"TCP\" and \"UDP\". Default is TCP.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"port": {
							SchemaProps: spec.SchemaProps{
								Description: "The port that will be exposed by this service.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"targetPort": {
							SchemaProps: spec.SchemaProps{
								Description: "Number or name of the port to access on the pods targeted by the service. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. If this is a string, it will be looked up as a named port in the target Pod's container ports. If this is not specified, the value of the 'port' field is used (an identity map). This field is ignored for services with clusterIP=None, and should be omitted or set equal to the 'port' field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service",
								Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
							},
						},
						"nodePort": {
							SchemaProps: spec.SchemaProps{
								Description: "The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"port"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ServiceProxyOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceProxyOptions is the query options to a Service's proxy call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"path": {
							SchemaProps: spec.SchemaProps{
								Description: "Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.ServiceSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceSpec describes the attributes that a user creates on a service.",
					Properties: map[string]spec.Schema{
						"ports": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "port",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.ServicePort"),
										},
									},
								},
							},
						},
						"selector": {
							SchemaProps: spec.SchemaProps{
								Description: "Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"clusterIP": {
							SchemaProps: spec.SchemaProps{
								Description: "clusterIP is the IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are \"None\", empty string (\"\"), or a valid IP address. \"None\" can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. \"ExternalName\" maps to the specified externalName. \"ClusterIP\" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object. If clusterIP is \"None\", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a stable IP. \"NodePort\" builds on ClusterIP and allocates a port on every node which routes to the clusterIP. \"LoadBalancer\" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the clusterIP. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services---service-types",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"externalIPs": {
							SchemaProps: spec.SchemaProps{
								Description: "externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"sessionAffinity": {
							SchemaProps: spec.SchemaProps{
								Description: "Supports \"ClientIP\" and \"None\". Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"loadBalancerIP": {
							SchemaProps: spec.SchemaProps{
								Description: "Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"loadBalancerSourceRanges": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.\" More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"externalName": {
							SchemaProps: spec.SchemaProps{
								Description: "externalName is the external reference that kubedns or equivalent will return as a CNAME record for this service. No proxying will be involved. Must be a valid DNS name and requires Type to be ExternalName.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"externalTrafficPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "externalTrafficPolicy denotes if this Service desires to route external traffic to node-local or cluster-wide endpoints. \"Local\" preserves the client source IP and avoids a second hop for LoadBalancer and Nodeport type services, but risks potentially imbalanced traffic spreading. \"Cluster\" obscures the client source IP and may cause a second hop to another node, but should have good overall load-spreading.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"healthCheckNodePort": {
							SchemaProps: spec.SchemaProps{
								Description: "healthCheckNodePort specifies the healthcheck nodePort for the service. If not specified, HealthCheckNodePort is created by the service api backend with the allocated nodePort. Will use user-specified nodePort value if specified by the client. Only effects when Type is set to LoadBalancer and ExternalTrafficPolicy is set to Local.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ServicePort"},
		},
		"k8s.io/kubernetes/pkg/api/v1.ServiceStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceStatus represents the current status of a service.",
					Properties: map[string]spec.Schema{
						"loadBalancer": {
							SchemaProps: spec.SchemaProps{
								Description: "LoadBalancer contains the current status of the load-balancer, if one is present.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LoadBalancerStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.LoadBalancerStatus"},
		},
		"k8s.io/kubernetes/pkg/api/v1.StorageOSPersistentVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a StorageOS persistent volume resource.",
					Properties: map[string]spec.Schema{
						"volumeName": {
							SchemaProps: spec.SchemaProps{
								Description: "VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"volumeNamespace": {
							SchemaProps: spec.SchemaProps{
								Description: "VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to \"default\" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"secretRef": {
							SchemaProps: spec.SchemaProps{
								Description: "SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ObjectReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.StorageOSVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a StorageOS persistent volume resource.",
					Properties: map[string]spec.Schema{
						"volumeName": {
							SchemaProps: spec.SchemaProps{
								Description: "VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"volumeNamespace": {
							SchemaProps: spec.SchemaProps{
								Description: "VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to \"default\" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"secretRef": {
							SchemaProps: spec.SchemaProps{
								Description: "SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.LocalObjectReference"},
		},
		"k8s.io/kubernetes/pkg/api/v1.Sysctl": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Sysctl defines a kernel parameter to be set",
					Properties: map[string]spec.Schema{
						"Name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of a property to set",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"Value": {
							SchemaProps: spec.SchemaProps{
								Description: "Value of a property to set",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"Name", "Value"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.TCPSocketAction": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TCPSocketAction describes an action based on opening a socket",
					Properties: map[string]spec.Schema{
						"port": {
							SchemaProps: spec.SchemaProps{
								Description: "Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.",
								Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
							},
						},
						"host": {
							SchemaProps: spec.SchemaProps{
								Description: "Optional: Host name to connect to, defaults to the pod IP.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"port"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
		},
		"k8s.io/kubernetes/pkg/api/v1.Taint": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "The node this Taint is attached to has the effect \"effect\" on any pod that that does not tolerate the Taint.",
					Properties: map[string]spec.Schema{
						"key": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "key",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Required. The taint key to be applied to a node.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"value": {
							SchemaProps: spec.SchemaProps{
								Description: "Required. The taint value corresponding to the taint key.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"effect": {
							SchemaProps: spec.SchemaProps{
								Description: "Required. The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule, PreferNoSchedule and NoExecute.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"timeAdded": {
							SchemaProps: spec.SchemaProps{
								Description: "TimeAdded represents the time at which the taint was added. It is only written for NoExecute taints.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
					},
					Required: []string{"key", "effect"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/kubernetes/pkg/api/v1.Toleration": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.",
					Properties: map[string]spec.Schema{
						"key": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "key",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"operator": {
							SchemaProps: spec.SchemaProps{
								Description: "Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"value": {
							SchemaProps: spec.SchemaProps{
								Description: "Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"effect": {
							SchemaProps: spec.SchemaProps{
								Description: "Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"tolerationSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.Volume": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Volume represents a named volume in a pod that may be accessed by any container in the pod.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Volume's name. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"hostPath": {
							SchemaProps: spec.SchemaProps{
								Description: "HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.HostPathVolumeSource"),
							},
						},
						"emptyDir": {
							SchemaProps: spec.SchemaProps{
								Description: "EmptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.EmptyDirVolumeSource"),
							},
						},
						"gcePersistentDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.GCEPersistentDiskVolumeSource"),
							},
						},
						"awsElasticBlockStore": {
							SchemaProps: spec.SchemaProps{
								Description: "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AWSElasticBlockStoreVolumeSource"),
							},
						},
						"gitRepo": {
							SchemaProps: spec.SchemaProps{
								Description: "GitRepo represents a git repository at a particular revision.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.GitRepoVolumeSource"),
							},
						},
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.SecretVolumeSource"),
							},
						},
						"nfs": {
							SchemaProps: spec.SchemaProps{
								Description: "NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NFSVolumeSource"),
							},
						},
						"iscsi": {
							SchemaProps: spec.SchemaProps{
								Description: "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://releases.k8s.io/HEAD/examples/volumes/iscsi/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ISCSIVolumeSource"),
							},
						},
						"glusterfs": {
							SchemaProps: spec.SchemaProps{
								Description: "Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.GlusterfsVolumeSource"),
							},
						},
						"persistentVolumeClaim": {
							SchemaProps: spec.SchemaProps{
								Description: "PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimVolumeSource"),
							},
						},
						"rbd": {
							SchemaProps: spec.SchemaProps{
								Description: "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.RBDVolumeSource"),
							},
						},
						"flexVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. This is an alpha feature and may change in future.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FlexVolumeSource"),
							},
						},
						"cinder": {
							SchemaProps: spec.SchemaProps{
								Description: "Cinder represents a cinder volume attached and mounted on kubelets host machine More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.CinderVolumeSource"),
							},
						},
						"cephfs": {
							SchemaProps: spec.SchemaProps{
								Description: "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.CephFSVolumeSource"),
							},
						},
						"flocker": {
							SchemaProps: spec.SchemaProps{
								Description: "Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FlockerVolumeSource"),
							},
						},
						"downwardAPI": {
							SchemaProps: spec.SchemaProps{
								Description: "DownwardAPI represents downward API about the pod that should populate this volume",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.DownwardAPIVolumeSource"),
							},
						},
						"fc": {
							SchemaProps: spec.SchemaProps{
								Description: "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FCVolumeSource"),
							},
						},
						"azureFile": {
							SchemaProps: spec.SchemaProps{
								Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AzureFileVolumeSource"),
							},
						},
						"configMap": {
							SchemaProps: spec.SchemaProps{
								Description: "ConfigMap represents a configMap that should populate this volume",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ConfigMapVolumeSource"),
							},
						},
						"vsphereVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.VsphereVirtualDiskVolumeSource"),
							},
						},
						"quobyte": {
							SchemaProps: spec.SchemaProps{
								Description: "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.QuobyteVolumeSource"),
							},
						},
						"azureDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AzureDiskVolumeSource"),
							},
						},
						"photonPersistentDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PhotonPersistentDiskVolumeSource"),
							},
						},
						"projected": {
							SchemaProps: spec.SchemaProps{
								Description: "Items for all in one resources secrets, configmaps, and downward API",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ProjectedVolumeSource"),
							},
						},
						"portworxVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "PortworxVolume represents a portworx volume attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PortworxVolumeSource"),
							},
						},
						"scaleIO": {
							SchemaProps: spec.SchemaProps{
								Description: "ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ScaleIOVolumeSource"),
							},
						},
						"storageos": {
							SchemaProps: spec.SchemaProps{
								Description: "StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.StorageOSVolumeSource"),
							},
						},
					},
					Required: []string{"name"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.AWSElasticBlockStoreVolumeSource", "k8s.io/kubernetes/pkg/api/v1.AzureDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.AzureFileVolumeSource", "k8s.io/kubernetes/pkg/api/v1.CephFSVolumeSource", "k8s.io/kubernetes/pkg/api/v1.CinderVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ConfigMapVolumeSource", "k8s.io/kubernetes/pkg/api/v1.DownwardAPIVolumeSource", "k8s.io/kubernetes/pkg/api/v1.EmptyDirVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FCVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FlexVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FlockerVolumeSource", "k8s.io/kubernetes/pkg/api/v1.GCEPersistentDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.GitRepoVolumeSource", "k8s.io/kubernetes/pkg/api/v1.GlusterfsVolumeSource", "k8s.io/kubernetes/pkg/api/v1.HostPathVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ISCSIVolumeSource", "k8s.io/kubernetes/pkg/api/v1.NFSVolumeSource", "k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimVolumeSource", "k8s.io/kubernetes/pkg/api/v1.PhotonPersistentDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.PortworxVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ProjectedVolumeSource", "k8s.io/kubernetes/pkg/api/v1.QuobyteVolumeSource", "k8s.io/kubernetes/pkg/api/v1.RBDVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ScaleIOVolumeSource", "k8s.io/kubernetes/pkg/api/v1.SecretVolumeSource", "k8s.io/kubernetes/pkg/api/v1.StorageOSVolumeSource", "k8s.io/kubernetes/pkg/api/v1.VsphereVirtualDiskVolumeSource"},
		},
		"k8s.io/kubernetes/pkg/api/v1.VolumeMount": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "VolumeMount describes a mounting of a Volume within a container.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "This must match the Name of a Volume.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readOnly": {
							SchemaProps: spec.SchemaProps{
								Description: "Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"mountPath": {
							SchemaProps: spec.SchemaProps{
								Description: "Path within the container at which the volume should be mounted.  Must not contain ':'.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"subPath": {
							SchemaProps: spec.SchemaProps{
								Description: "Path within the volume from which the container's volume should be mounted. Defaults to \"\" (volume's root).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name", "mountPath"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.VolumeProjection": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Projection that may be projected along with other supported volume types",
					Properties: map[string]spec.Schema{
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "information about the secret data to project",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.SecretProjection"),
							},
						},
						"downwardAPI": {
							SchemaProps: spec.SchemaProps{
								Description: "information about the downwardAPI data to project",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.DownwardAPIProjection"),
							},
						},
						"configMap": {
							SchemaProps: spec.SchemaProps{
								Description: "information about the configMap data to project",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ConfigMapProjection"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.ConfigMapProjection", "k8s.io/kubernetes/pkg/api/v1.DownwardAPIProjection", "k8s.io/kubernetes/pkg/api/v1.SecretProjection"},
		},
		"k8s.io/kubernetes/pkg/api/v1.VolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents the source of a volume to mount. Only one of its members may be specified.",
					Properties: map[string]spec.Schema{
						"hostPath": {
							SchemaProps: spec.SchemaProps{
								Description: "HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.HostPathVolumeSource"),
							},
						},
						"emptyDir": {
							SchemaProps: spec.SchemaProps{
								Description: "EmptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.EmptyDirVolumeSource"),
							},
						},
						"gcePersistentDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.GCEPersistentDiskVolumeSource"),
							},
						},
						"awsElasticBlockStore": {
							SchemaProps: spec.SchemaProps{
								Description: "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AWSElasticBlockStoreVolumeSource"),
							},
						},
						"gitRepo": {
							SchemaProps: spec.SchemaProps{
								Description: "GitRepo represents a git repository at a particular revision.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.GitRepoVolumeSource"),
							},
						},
						"secret": {
							SchemaProps: spec.SchemaProps{
								Description: "Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.SecretVolumeSource"),
							},
						},
						"nfs": {
							SchemaProps: spec.SchemaProps{
								Description: "NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.NFSVolumeSource"),
							},
						},
						"iscsi": {
							SchemaProps: spec.SchemaProps{
								Description: "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://releases.k8s.io/HEAD/examples/volumes/iscsi/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ISCSIVolumeSource"),
							},
						},
						"glusterfs": {
							SchemaProps: spec.SchemaProps{
								Description: "Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.GlusterfsVolumeSource"),
							},
						},
						"persistentVolumeClaim": {
							SchemaProps: spec.SchemaProps{
								Description: "PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimVolumeSource"),
							},
						},
						"rbd": {
							SchemaProps: spec.SchemaProps{
								Description: "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.RBDVolumeSource"),
							},
						},
						"flexVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. This is an alpha feature and may change in future.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FlexVolumeSource"),
							},
						},
						"cinder": {
							SchemaProps: spec.SchemaProps{
								Description: "Cinder represents a cinder volume attached and mounted on kubelets host machine More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.CinderVolumeSource"),
							},
						},
						"cephfs": {
							SchemaProps: spec.SchemaProps{
								Description: "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.CephFSVolumeSource"),
							},
						},
						"flocker": {
							SchemaProps: spec.SchemaProps{
								Description: "Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FlockerVolumeSource"),
							},
						},
						"downwardAPI": {
							SchemaProps: spec.SchemaProps{
								Description: "DownwardAPI represents downward API about the pod that should populate this volume",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.DownwardAPIVolumeSource"),
							},
						},
						"fc": {
							SchemaProps: spec.SchemaProps{
								Description: "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.FCVolumeSource"),
							},
						},
						"azureFile": {
							SchemaProps: spec.SchemaProps{
								Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AzureFileVolumeSource"),
							},
						},
						"configMap": {
							SchemaProps: spec.SchemaProps{
								Description: "ConfigMap represents a configMap that should populate this volume",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ConfigMapVolumeSource"),
							},
						},
						"vsphereVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.VsphereVirtualDiskVolumeSource"),
							},
						},
						"quobyte": {
							SchemaProps: spec.SchemaProps{
								Description: "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.QuobyteVolumeSource"),
							},
						},
						"azureDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.AzureDiskVolumeSource"),
							},
						},
						"photonPersistentDisk": {
							SchemaProps: spec.SchemaProps{
								Description: "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PhotonPersistentDiskVolumeSource"),
							},
						},
						"projected": {
							SchemaProps: spec.SchemaProps{
								Description: "Items for all in one resources secrets, configmaps, and downward API",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ProjectedVolumeSource"),
							},
						},
						"portworxVolume": {
							SchemaProps: spec.SchemaProps{
								Description: "PortworxVolume represents a portworx volume attached and mounted on kubelets host machine",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PortworxVolumeSource"),
							},
						},
						"scaleIO": {
							SchemaProps: spec.SchemaProps{
								Description: "ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.ScaleIOVolumeSource"),
							},
						},
						"storageos": {
							SchemaProps: spec.SchemaProps{
								Description: "StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.StorageOSVolumeSource"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.AWSElasticBlockStoreVolumeSource", "k8s.io/kubernetes/pkg/api/v1.AzureDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.AzureFileVolumeSource", "k8s.io/kubernetes/pkg/api/v1.CephFSVolumeSource", "k8s.io/kubernetes/pkg/api/v1.CinderVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ConfigMapVolumeSource", "k8s.io/kubernetes/pkg/api/v1.DownwardAPIVolumeSource", "k8s.io/kubernetes/pkg/api/v1.EmptyDirVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FCVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FlexVolumeSource", "k8s.io/kubernetes/pkg/api/v1.FlockerVolumeSource", "k8s.io/kubernetes/pkg/api/v1.GCEPersistentDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.GitRepoVolumeSource", "k8s.io/kubernetes/pkg/api/v1.GlusterfsVolumeSource", "k8s.io/kubernetes/pkg/api/v1.HostPathVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ISCSIVolumeSource", "k8s.io/kubernetes/pkg/api/v1.NFSVolumeSource", "k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaimVolumeSource", "k8s.io/kubernetes/pkg/api/v1.PhotonPersistentDiskVolumeSource", "k8s.io/kubernetes/pkg/api/v1.PortworxVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ProjectedVolumeSource", "k8s.io/kubernetes/pkg/api/v1.QuobyteVolumeSource", "k8s.io/kubernetes/pkg/api/v1.RBDVolumeSource", "k8s.io/kubernetes/pkg/api/v1.ScaleIOVolumeSource", "k8s.io/kubernetes/pkg/api/v1.SecretVolumeSource", "k8s.io/kubernetes/pkg/api/v1.StorageOSVolumeSource", "k8s.io/kubernetes/pkg/api/v1.VsphereVirtualDiskVolumeSource"},
		},
		"k8s.io/kubernetes/pkg/api/v1.VsphereVirtualDiskVolumeSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Represents a vSphere volume resource.",
					Properties: map[string]spec.Schema{
						"volumePath": {
							SchemaProps: spec.SchemaProps{
								Description: "Path that identifies vSphere volume vmdk",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fsType": {
							SchemaProps: spec.SchemaProps{
								Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"storagePolicyName": {
							SchemaProps: spec.SchemaProps{
								Description: "Storage Policy Based Management (SPBM) profile name.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"storagePolicyID": {
							SchemaProps: spec.SchemaProps{
								Description: "Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"volumePath"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/api/v1.WeightedPodAffinityTerm": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)",
					Properties: map[string]spec.Schema{
						"weight": {
							SchemaProps: spec.SchemaProps{
								Description: "weight associated with matching the corresponding podAffinityTerm, in the range 1-100.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"podAffinityTerm": {
							SchemaProps: spec.SchemaProps{
								Description: "Required. A pod affinity term, associated with the corresponding weight.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodAffinityTerm"),
							},
						},
					},
					Required: []string{"weight", "podAffinityTerm"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/api/v1.PodAffinityTerm"},
		},
		"k8s.io/kubernetes/pkg/api/v1.simpleNameGenerator": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "simpleNameGenerator generates random names.",
					Properties:  map[string]spec.Schema{},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/apis/abac/v1beta1.Policy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Policy contains a single ABAC policy rule",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec describes the policy rule",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/abac/v1beta1.PolicySpec"),
							},
						},
					},
					Required: []string{"spec"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/apis/abac/v1beta1.PolicySpec"},
		},
		"k8s.io/kubernetes/pkg/apis/abac/v1beta1.PolicySpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "PolicySpec contains the attributes for a policy rule",
					Properties: map[string]spec.Schema{
						"user": {
							SchemaProps: spec.SchemaProps{
								Description: "User is the username this rule applies to. Either user or group is required to match the request. \"*\" matches all users.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"group": {
							SchemaProps: spec.SchemaProps{
								Description: "Group is the group this rule applies to. Either user or group is required to match the request. \"*\" matches all groups.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"readonly": {
							SchemaProps: spec.SchemaProps{
								Description: "Readonly matches readonly requests when true, and all requests when false",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"apiGroup": {
							SchemaProps: spec.SchemaProps{
								Description: "APIGroup is the name of an API group. APIGroup, Resource, and Namespace are required to match resource requests. \"*\" matches all API groups",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resource": {
							SchemaProps: spec.SchemaProps{
								Description: "Resource is the name of a resource. APIGroup, Resource, and Namespace are required to match resource requests. \"*\" matches all resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the name of a namespace. APIGroup, Resource, and Namespace are required to match resource requests. \"*\" matches all namespaces (including unnamespaced requests)",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"nonResourcePath": {
							SchemaProps: spec.SchemaProps{
								Description: "NonResourcePath matches non-resource request paths. \"*\" matches all paths \"/foo/*\" matches all subpaths of foo",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.AdmissionHookClientConfig": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "AdmissionHookClientConfig contains the information to make a TLS connection with the webhook",
					Properties: map[string]spec.Schema{
						"service": {
							SchemaProps: spec.SchemaProps{
								Description: "Service is a reference to the service for this webhook. If there is only one port open for the service, that port will be used. If there are multiple ports open, port 443 will be used if it is open, otherwise it is an error. Required",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.ServiceReference"),
							},
						},
						"caBundle": {
							SchemaProps: spec.SchemaProps{
								Description: "CABundle is a PEM encoded CA bundle which will be used to validate webhook's server certificate. Required",
								Type:        []string{"string"},
								Format:      "byte",
							},
						},
					},
					Required: []string{"service", "caBundle"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.ServiceReference"},
		},
		"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.ExternalAdmissionHook": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ExternalAdmissionHook describes an external admission webhook and the resources and operations it applies to.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "The name of the external admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"clientConfig": {
							SchemaProps: spec.SchemaProps{
								Description: "ClientConfig defines how to communicate with the hook. Required",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.AdmissionHookClientConfig"),
							},
						},
						"rules": {
							SchemaProps: spec.SchemaProps{
								Description: "Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.RuleWithOperations"),
										},
									},
								},
							},
						},
						"failurePolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name", "clientConfig"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.AdmissionHookClientConfig", "k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.RuleWithOperations"},
		},
		"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.ExternalAdmissionHookConfiguration": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ExternalAdmissionHookConfiguration describes the configuration of initializers.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"externalAdmissionHooks": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "name",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "ExternalAdmissionHooks is a list of external admission webhooks and the affected resources and operations.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.ExternalAdmissionHook"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.ExternalAdmissionHook"},
		},
		"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.ExternalAdmissionHookConfigurationList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ExternalAdmissionHookConfigurationList is a list of ExternalAdmissionHookConfiguration.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of ExternalAdmissionHookConfiguration.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.ExternalAdmissionHookConfiguration"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.ExternalAdmissionHookConfiguration"},
		},
		"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.Initializer": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Initializer describes the name and the failure policy of an initializer, and what resources it applies to.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name is the identifier of the initializer. It will be added to the object that needs to be initialized. Name should be fully qualified, e.g., alwayspullimages.kubernetes.io, where \"alwayspullimages\" is the name of the webhook, and kubernetes.io is the name of the organization. Required",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"rules": {
							SchemaProps: spec.SchemaProps{
								Description: "Rules describes what resources/subresources the initializer cares about. The initializer cares about an operation if it matches _any_ Rule. Rule.Resources must not include subresources.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.Rule"),
										},
									},
								},
							},
						},
						"failurePolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "FailurePolicy defines what happens if the responsible initializer controller fails to takes action. Allowed values are Ignore, or Fail. If \"Ignore\" is set, initializer is removed from the initializers list of an object if the timeout is reached; If \"Fail\" is set, admissionregistration returns timeout error if the timeout is reached.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.Rule"},
		},
		"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.InitializerConfiguration": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "InitializerConfiguration describes the configuration of initializers.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"initializers": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "name",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Initializers is a list of resources and their default initializers Order-sensitive. When merging multiple InitializerConfigurations, we sort the initializers from different InitializerConfigurations by the name of the InitializerConfigurations; the order of the initializers from the same InitializerConfiguration is preserved.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.Initializer"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.Initializer"},
		},
		"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.InitializerConfigurationList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "InitializerConfigurationList is a list of InitializerConfiguration.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "List of InitializerConfiguration.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.InitializerConfiguration"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.InitializerConfiguration"},
		},
		"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.Rule": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Rule is a tuple of APIGroups, APIVersion, and Resources.It is recommended to make sure that all the tuple expansions are valid.",
					Properties: map[string]spec.Schema{
						"apiGroups": {
							SchemaProps: spec.SchemaProps{
								Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"apiVersions": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.RuleWithOperations": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RuleWithOperations is a tuple of Operations and Resources. It is recommended to make sure that all the tuple expansions are valid.",
					Properties: map[string]spec.Schema{
						"operations": {
							SchemaProps: spec.SchemaProps{
								Description: "Operations is the operations the admission hook cares about - CREATE, UPDATE, or * for all operations. If '*' is present, the length of the slice must be one. Required.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"apiGroups": {
							SchemaProps: spec.SchemaProps{
								Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"apiVersions": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/apis/admissionregistration/v1alpha1.ServiceReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceReference holds a reference to Service.legacy.k8s.io",
					Properties: map[string]spec.Schema{
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace is the namespace of the service Required",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name is the name of the service Required",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"namespace", "name"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.ControllerRevision": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"data": {
							SchemaProps: spec.SchemaProps{
								Description: "Data is the serialized representation of the state.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "Revision indicates the revision of the state represented by Data.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
					Required: []string{"revision"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.ControllerRevisionList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ControllerRevisionList is a resource containing a list of ControllerRevision objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of ControllerRevisions",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.ControllerRevision"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.ControllerRevision"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.Deployment": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Deployment enables declarative updates for Pods and ReplicaSets.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Specification of the desired behavior of the Deployment.",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Most recently observed status of the Deployment.",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentSpec", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentStatus"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentCondition describes the state of a deployment at a certain point.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of deployment condition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of True, False, Unknown.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastUpdateTime": {
							SchemaProps: spec.SchemaProps{
								Description: "The last time this condition was updated.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "Last time the condition transitioned from one status to another.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "The reason for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "A human readable message indicating details about the transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentList is a list of Deployments.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Description: "Items is the list of Deployments.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.Deployment"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.Deployment"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentRollback": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentRollback stores the information required to rollback a deployment.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Required: This must match the Name of a deployment.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"updatedAnnotations": {
							SchemaProps: spec.SchemaProps{
								Description: "The annotations to be updated to a deployment",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"rollbackTo": {
							SchemaProps: spec.SchemaProps{
								Description: "The config of this deployment rollback.",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.RollbackConfig"),
							},
						},
					},
					Required: []string{"name", "rollbackTo"},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/apis/apps/v1beta1.RollbackConfig"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentSpec is the specification of the desired behavior of the Deployment.",
					Properties: map[string]spec.Schema{
						"replicas": {
							SchemaProps: spec.SchemaProps{
								Description: "Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"selector": {
							SchemaProps: spec.SchemaProps{
								Description: "Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
							},
						},
						"template": {
							SchemaProps: spec.SchemaProps{
								Description: "Template describes the pods that will be created.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"),
							},
						},
						"strategy": {
							SchemaProps: spec.SchemaProps{
								Description: "The deployment strategy to use to replace existing pods with new ones.",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentStrategy"),
							},
						},
						"minReadySeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"revisionHistoryLimit": {
							SchemaProps: spec.SchemaProps{
								Description: "The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 2.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"paused": {
							SchemaProps: spec.SchemaProps{
								Description: "Indicates that the deployment is paused.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"rollbackTo": {
							SchemaProps: spec.SchemaProps{
								Description: "The config this deployment is rolling back to. Will be cleared after rollback is done.",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.RollbackConfig"),
							},
						},
						"progressDeadlineSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Once autoRollback is implemented, the deployment controller will automatically rollback failed deployments. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"template"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector", "k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentStrategy", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.RollbackConfig"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentStatus is the most recently observed status of the Deployment.",
					Properties: map[string]spec.Schema{
						"observedGeneration": {
							SchemaProps: spec.SchemaProps{
								Description: "The generation observed by the deployment controller.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"replicas": {
							SchemaProps: spec.SchemaProps{
								Description: "Total number of non-terminated pods targeted by this deployment (their labels match the selector).",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"updatedReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "Total number of non-terminated pods targeted by this deployment that have the desired template spec.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"readyReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "Total number of ready pods targeted by this deployment.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"availableReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"unavailableReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "Total number of unavailable pods targeted by this deployment.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"conditions": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "type",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Represents the latest available observations of a deployment's current state.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentCondition"),
										},
									},
								},
							},
						},
						"collisionCount": {
							SchemaProps: spec.SchemaProps{
								Description: "Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentCondition"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.DeploymentStrategy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeploymentStrategy describes how to replace existing pods with new ones.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of deployment. Can be \"Recreate\" or \"RollingUpdate\". Default is RollingUpdate.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"rollingUpdate": {
							SchemaProps: spec.SchemaProps{
								Description: "Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.RollingUpdateDeployment"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/kubernetes/pkg/apis/apps/v1beta1.RollingUpdateDeployment"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.RollbackConfig": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Properties: map[string]spec.Schema{
						"revision": {
							SchemaProps: spec.SchemaProps{
								Description: "The revision to rollback to. If set to 0, rollback to the last revision.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.RollingUpdateDeployment": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Spec to control the desired behavior of rolling update.",
					Properties: map[string]spec.Schema{
						"maxUnavailable": {
							SchemaProps: spec.SchemaProps{
								Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old RC can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old RC can be scaled down further, followed by scaling up the new RC, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.",
								Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
							},
						},
						"maxSurge": {
							SchemaProps: spec.SchemaProps{
								Description: "The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new RC can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new RC can be scaled up further, ensuring that total number of pods running at any time during the update is atmost 130% of desired pods.",
								Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.RollingUpdateStatefulSetStrategy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.",
					Properties: map[string]spec.Schema{
						"partition": {
							SchemaProps: spec.SchemaProps{
								Description: "Partition indicates the ordinal at which the StatefulSet should be partitioned.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.Scale": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Scale represents a scaling request for a resource.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.ScaleSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "current status of the scale. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status. Read-only.",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.ScaleStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.ScaleSpec", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.ScaleStatus"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.ScaleSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ScaleSpec describes the attributes of a scale subresource",
					Properties: map[string]spec.Schema{
						"replicas": {
							SchemaProps: spec.SchemaProps{
								Description: "desired number of instances for the scaled object.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.ScaleStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ScaleStatus represents the current status of a scale subresource.",
					Properties: map[string]spec.Schema{
						"replicas": {
							SchemaProps: spec.SchemaProps{
								Description: "actual number of observed instances of the scaled object.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"selector": {
							SchemaProps: spec.SchemaProps{
								Description: "label query over pods that should match the replicas count. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"targetSelector": {
							SchemaProps: spec.SchemaProps{
								Description: "label selector for pods that should match the replicas count. This is a serializated version of both map-based and more expressive set-based selectors. This is done to avoid introspection in the clients. The string will be in the same format as the query-param syntax. If the target type only supports map-based selectors, both this field and map-based selector field are populated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"replicas"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSet": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "StatefulSet represents a set of pods with consistent identities. Identities are defined as:\n - Network: A single stable DNS and hostname.\n - Storage: As many VolumeClaims as requested.\nThe StatefulSet guarantees that a given network identity will always map to the same storage identity.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Description: "Spec defines the desired identities of pods in this set.",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSetSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSetStatus"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSetSpec", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSetStatus"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSetList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "StatefulSetList is a collection of StatefulSets.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Type: []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSet"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSet"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSetSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A StatefulSetSpec is the specification of a StatefulSet.",
					Properties: map[string]spec.Schema{
						"replicas": {
							SchemaProps: spec.SchemaProps{
								Description: "replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"selector": {
							SchemaProps: spec.SchemaProps{
								Description: "selector is a label query over pods that should match the replica count. If empty, defaulted to labels on the pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
							},
						},
						"template": {
							SchemaProps: spec.SchemaProps{
								Description: "template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet.",
								Ref:         ref("k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec"),
							},
						},
						"volumeClaimTemplates": {
							SchemaProps: spec.SchemaProps{
								Description: "volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaim"),
										},
									},
								},
							},
						},
						"serviceName": {
							SchemaProps: spec.SchemaProps{
								Description: "serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"podManagementPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"updateStrategy": {
							SchemaProps: spec.SchemaProps{
								Description: "updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.",
								Ref:         ref("k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSetUpdateStrategy"),
							},
						},
						"revisionHistoryLimit": {
							SchemaProps: spec.SchemaProps{
								Description: "revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"template", "serviceName"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector", "k8s.io/kubernetes/pkg/api/v1.PersistentVolumeClaim", "k8s.io/kubernetes/pkg/api/v1.PodTemplateSpec", "k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSetUpdateStrategy"},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSetStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "StatefulSetStatus represents the current state of a StatefulSet.",
					Properties: map[string]spec.Schema{
						"observedGeneration": {
							SchemaProps: spec.SchemaProps{
								Description: "observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"replicas": {
							SchemaProps: spec.SchemaProps{
								Description: "replicas is the number of Pods created by the StatefulSet controller.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"readyReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "readyReplicas is the number of Pods created by the StatefulSet controller that have a Ready Condition.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"currentReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"updatedReplicas": {
							SchemaProps: spec.SchemaProps{
								Description: "updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
						"currentRevision": {
							SchemaProps: spec.SchemaProps{
								Description: "currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"updateRevision": {
							SchemaProps: spec.SchemaProps{
								Description: "updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"replicas"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/kubernetes/pkg/apis/apps/v1beta1.StatefulSetUpdateStrategy": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type indicates the type of the StatefulSetUpdateStrategy.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"rollingUpdate": {
							SchemaProps: spec.SchemaProp