// This file was automatically generated by lister-gen

package v1

import (
	v1 "github.com/openshift/origin/pkg/quota/apis/quota/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterResourceQuotaLister helps list ClusterResourceQuotas.
type ClusterResourceQuotaLister interface {
	// List lists all ClusterResourceQuotas in the indexer.
	List(selector labels.Selector) (ret []*v1.ClusterResourceQuota, err error)
	// Get retrieves the ClusterResourceQuota from the index for a given name.
	Get(name string) (*v1.ClusterResourceQuota, error)
	ClusterResourceQuotaListerExpansion
}

// clusterResourceQuotaLister implements the ClusterResourceQuotaLister interface.
type clusterResourceQuotaLister struct {
	indexer cache.Indexer
}

// NewClusterResourceQuotaLister returns a new ClusterResourceQuotaLister.
func NewClusterResourceQuotaLister(indexer cache.Indexer) ClusterResourceQuotaLister {
	return &clusterResourceQuotaLister{indexer: indexer}
}

// List lists all ClusterResourceQuotas in the indexer.
func (s *clusterResourceQuotaLister) List(selector labels.Selector) (ret []*v1.ClusterResourceQuota, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterResourceQuota))
	})
	return ret, err
}

// Get retrieves the ClusterResourceQuota from the index for a given name.
func (s *clusterResourceQuotaLister) Get(name string) (*v1.ClusterResourceQuota, error) {
	key := &v1.ClusterResourceQuota{ObjectMeta: meta_v1.ObjectMeta{Name: name}}
	obj, exists, err := s.indexer.Get(key)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("clusterresourcequota"), name)
	}
	return obj.(*v1.ClusterResourceQuota), nil
}
