/*
 * Copyright (C) 2016 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.syndesis.connector.kafka.model.crd;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.fabric8.kubernetes.api.builder.Function;
import io.fabric8.kubernetes.client.CustomResourceDoneable;

/**
 * Custom class for the Kubernetes client.
 * We don't really need anything from this class, just to exist.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class KafkaResourceDoneable extends CustomResourceDoneable<KafkaResource> {

    public KafkaResourceDoneable(KafkaResource resource, Function<KafkaResource, KafkaResource> function) {
        super(resource, function);
    }

}
