/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeCommand
extends GitCommand<String> {
    private final RevWalk w;
    private RevCommit target;
    private int maxCandidates = 10;

    protected DescribeCommand(Repository repo) {
        super(repo);
        this.w = new RevWalk(repo);
        this.w.setRetainBody(false);
    }

    public DescribeCommand setTarget(ObjectId target) throws IOException {
        this.target = this.w.parseCommit(target);
        return this;
    }

    public DescribeCommand setTarget(String rev) throws IOException, RefNotFoundException {
        ObjectId id2 = this.repo.resolve(rev);
        if (id2 == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, rev));
        }
        return this.setTarget(id2);
    }

    @Override
    public String call() throws GitAPIException {
        String string2;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Candidate {
            final Ref tag;
            final RevFlag flag;
            int depth;

            Candidate(RevCommit commit2, Ref tag2) {
                this.tag = tag2;
                this.flag = DescribeCommand.this.w.newFlag(tag2.getName());
                allFlags.add(this.flag);
                DescribeCommand.this.w.carry(this.flag);
                commit2.add(this.flag);
                commit2.carry(this.flag);
            }

            boolean reaches(RevCommit c) {
                return c.has(this.flag);
            }

            String describe(ObjectId tip) throws IOException {
                return String.format("%s-%d-g%s", this.tag.getName().substring("refs/tags/".length()), this.depth, DescribeCommand.this.w.getObjectReader().abbreviate(tip).name());
            }
        }
        ArrayList<Candidate> candidates2;
        block17: {
            RevCommit c;
            RevFlagSet allFlags;
            HashMap<ObjectId, Ref> tags;
            block16: {
                this.checkCallable();
                if (this.target == null) {
                    this.setTarget("HEAD");
                }
                tags = new HashMap<ObjectId, Ref>();
                for (Ref r : this.repo.getRefDatabase().getRefs("refs/tags/").values()) {
                    ObjectId key = this.repo.peel(r).getPeeledObjectId();
                    if (key == null) {
                        key = r.getObjectId();
                    }
                    tags.put(key, r);
                }
                allFlags = new RevFlagSet();
                candidates2 = new ArrayList<Candidate>();
                Ref lucky = (Ref)tags.get(this.target);
                if (lucky == null) break block16;
                String string3 = lucky.getName().substring("refs/tags/".length());
                Object var12_8 = null;
                this.setCallable(false);
                this.w.release();
                return string3;
            }
            this.w.markStart(this.target);
            int seen = 0;
            while ((c = this.w.next()) != null) {
                Ref t;
                if (!c.hasAny(allFlags) && (t = (Ref)tags.get(c)) != null) {
                    Candidate cd = new Candidate(c, t);
                    candidates2.add(cd);
                    cd.depth = seen;
                }
                for (Candidate cd : candidates2) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
                if (candidates2.size() >= this.maxCandidates) break;
                ++seen;
            }
            while ((c = this.w.next()) != null) {
                if (c.hasAll(allFlags)) {
                    for (RevCommit p : c.getParents()) {
                        p.add(RevFlag.SEEN);
                    }
                    continue;
                }
                for (Candidate cd : candidates2) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
            }
            if (!candidates2.isEmpty()) break block17;
            Iterator i$ = null;
            Object var12_9 = null;
            this.setCallable(false);
            this.w.release();
            return i$;
        }
        try {
            Candidate best = Collections.min(candidates2, new Comparator<Candidate>(){

                @Override
                public int compare(Candidate o1, Candidate o2) {
                    return o1.depth - o2.depth;
                }
            });
            string2 = best.describe(this.target);
            Object var12_10 = null;
        }
        catch (IOException e) {
            try {
                throw new JGitInternalException(e.getMessage(), e);
            }
            catch (Throwable throwable2) {
                Object var12_11 = null;
                this.setCallable(false);
                this.w.release();
                throw throwable2;
            }
        }
        this.setCallable(false);
        this.w.release();
        return string2;
    }
}

