/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.fnmatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.errors.NoClosingBracketException;
import org.eclipse.jgit.fnmatch.AbstractHead;
import org.eclipse.jgit.fnmatch.CharacterHead;
import org.eclipse.jgit.fnmatch.GroupHead;
import org.eclipse.jgit.fnmatch.Head;
import org.eclipse.jgit.fnmatch.LastHead;
import org.eclipse.jgit.fnmatch.RestrictedWildCardHead;
import org.eclipse.jgit.fnmatch.WildCardHead;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNameMatcher {
    static final List<Head> EMPTY_HEAD_LIST = Collections.emptyList();
    private static final Pattern characterClassStartPattern = Pattern.compile("\\[[.:=]");
    private List<Head> headsStartValue;
    private List<Head> heads;
    private List<Head> listForLocalUseage;

    private FileNameMatcher(List<Head> headsStartValue) {
        this(headsStartValue, headsStartValue);
    }

    private FileNameMatcher(List<Head> headsStartValue, List<Head> heads) {
        this.headsStartValue = headsStartValue;
        this.heads = new ArrayList<Head>(heads.size());
        this.heads.addAll(heads);
        this.listForLocalUseage = new ArrayList<Head>(heads.size());
    }

    public FileNameMatcher(String patternString, Character invalidWildgetCharacter) throws InvalidPatternException {
        this(FileNameMatcher.createHeadsStartValues(patternString, invalidWildgetCharacter));
    }

    public FileNameMatcher(FileNameMatcher other) {
        this(other.headsStartValue, other.heads);
    }

    private static List<Head> createHeadsStartValues(String patternString, Character invalidWildgetCharacter) throws InvalidPatternException {
        List<AbstractHead> allHeads = FileNameMatcher.parseHeads(patternString, invalidWildgetCharacter);
        ArrayList<Head> nextHeadsSuggestion = new ArrayList<Head>(2);
        nextHeadsSuggestion.add(LastHead.INSTANCE);
        for (int i = allHeads.size() - 1; i >= 0; --i) {
            AbstractHead head2 = allHeads.get(i);
            if (head2.isStar()) {
                nextHeadsSuggestion.add(head2);
                head2.setNewHeads(nextHeadsSuggestion);
                continue;
            }
            head2.setNewHeads(nextHeadsSuggestion);
            nextHeadsSuggestion = new ArrayList(2);
            nextHeadsSuggestion.add(head2);
        }
        return nextHeadsSuggestion;
    }

    private static int findGroupEnd(int indexOfStartBracket, String pattern2) throws InvalidPatternException {
        int firstValidCharClassIndex = indexOfStartBracket + 1;
        int firstValidEndBracketIndex = indexOfStartBracket + 2;
        if (indexOfStartBracket + 1 >= pattern2.length()) {
            throw new NoClosingBracketException(indexOfStartBracket, "[", "]", pattern2);
        }
        if (pattern2.charAt(firstValidCharClassIndex) == '!') {
            ++firstValidCharClassIndex;
            ++firstValidEndBracketIndex;
        }
        Matcher charClassStartMatcher = characterClassStartPattern.matcher(pattern2);
        int groupEnd = -1;
        while (groupEnd == -1) {
            int possibleGroupEnd = FileNameMatcher.indexOfUnescaped(pattern2, ']', firstValidEndBracketIndex);
            if (possibleGroupEnd == -1) {
                throw new NoClosingBracketException(indexOfStartBracket, "[", "]", pattern2);
            }
            boolean foundCharClass = charClassStartMatcher.find(firstValidCharClassIndex);
            if (foundCharClass && charClassStartMatcher.start() < possibleGroupEnd) {
                int classStartIndex;
                String classStart = charClassStartMatcher.group(0);
                String classEnd = classStart.charAt(1) + "]";
                int classEndIndex = pattern2.indexOf(classEnd, (classStartIndex = charClassStartMatcher.start()) + 2);
                if (classEndIndex == -1) {
                    throw new NoClosingBracketException(classStartIndex, classStart, classEnd, pattern2);
                }
                firstValidEndBracketIndex = firstValidCharClassIndex = classEndIndex + 2;
                continue;
            }
            groupEnd = possibleGroupEnd;
        }
        return groupEnd;
    }

    private static List<AbstractHead> parseHeads(String pattern2, Character invalidWildgetCharacter) throws InvalidPatternException {
        int currentIndex = 0;
        ArrayList<AbstractHead> heads = new ArrayList<AbstractHead>();
        while (currentIndex < pattern2.length()) {
            String patternPart;
            int groupStart = FileNameMatcher.indexOfUnescaped(pattern2, '[', currentIndex);
            if (groupStart == -1) {
                patternPart = pattern2.substring(currentIndex);
                heads.addAll(FileNameMatcher.createSimpleHeads(patternPart, invalidWildgetCharacter));
                currentIndex = pattern2.length();
                continue;
            }
            patternPart = pattern2.substring(currentIndex, groupStart);
            heads.addAll(FileNameMatcher.createSimpleHeads(patternPart, invalidWildgetCharacter));
            int groupEnd = FileNameMatcher.findGroupEnd(groupStart, pattern2);
            String groupPart = pattern2.substring(groupStart + 1, groupEnd);
            heads.add(new GroupHead(groupPart, pattern2));
            currentIndex = groupEnd + 1;
        }
        return heads;
    }

    private static List<AbstractHead> createSimpleHeads(String patternPart, Character invalidWildgetCharacter) {
        ArrayList<AbstractHead> heads = new ArrayList<AbstractHead>(patternPart.length());
        boolean escaped2 = false;
        block5: for (int i = 0; i < patternPart.length(); ++i) {
            AbstractHead head2;
            char c = patternPart.charAt(i);
            if (escaped2) {
                head2 = new CharacterHead(c);
                heads.add(head2);
                escaped2 = false;
                continue;
            }
            switch (c) {
                case '*': {
                    head2 = FileNameMatcher.createWildCardHead(invalidWildgetCharacter, true);
                    heads.add(head2);
                    continue block5;
                }
                case '?': {
                    head2 = FileNameMatcher.createWildCardHead(invalidWildgetCharacter, false);
                    heads.add(head2);
                    continue block5;
                }
                case '\\': {
                    escaped2 = true;
                    continue block5;
                }
                default: {
                    head2 = new CharacterHead(c);
                    heads.add(head2);
                }
            }
        }
        return heads;
    }

    private static AbstractHead createWildCardHead(Character invalidWildgetCharacter, boolean star) {
        if (invalidWildgetCharacter != null) {
            return new RestrictedWildCardHead(invalidWildgetCharacter.charValue(), star);
        }
        return new WildCardHead(star);
    }

    private boolean extendStringToMatchByOneCharacter(char c) {
        List<Head> newHeads = this.listForLocalUseage;
        newHeads.clear();
        List<Head> lastAddedHeads = null;
        for (int i = 0; i < this.heads.size(); ++i) {
            Head head2 = this.heads.get(i);
            List<Head> headsToAdd = head2.getNextHeads(c);
            if (headsToAdd == lastAddedHeads) continue;
            if (!headsToAdd.isEmpty()) {
                newHeads.addAll(headsToAdd);
            }
            lastAddedHeads = headsToAdd;
        }
        this.listForLocalUseage = this.heads;
        this.heads = newHeads;
        return !newHeads.isEmpty();
    }

    private static int indexOfUnescaped(String searchString, char ch, int fromIndex) {
        for (int i = fromIndex; i < searchString.length(); ++i) {
            char current = searchString.charAt(i);
            if (current == ch) {
                return i;
            }
            if (current != '\\') continue;
            ++i;
        }
        return -1;
    }

    public void append(String stringToMatch) {
        char c;
        for (int i = 0; i < stringToMatch.length() && this.extendStringToMatchByOneCharacter(c = stringToMatch.charAt(i)); ++i) {
        }
    }

    public void reset() {
        this.heads.clear();
        this.heads.addAll(this.headsStartValue);
    }

    public FileNameMatcher createMatcherForSuffix() {
        ArrayList<Head> copyOfHeads = new ArrayList<Head>(this.heads.size());
        copyOfHeads.addAll(this.heads);
        return new FileNameMatcher(copyOfHeads);
    }

    public boolean isMatch() {
        if (this.heads.isEmpty()) {
            return false;
        }
        ListIterator<Head> headIterator = this.heads.listIterator(this.heads.size());
        while (headIterator.hasPrevious()) {
            Head head2 = headIterator.previous();
            if (head2 != LastHead.INSTANCE) continue;
            return true;
        }
        return false;
    }

    public boolean canAppendMatch() {
        for (int i = 0; i < this.heads.size(); ++i) {
            if (this.heads.get(i) == LastHead.INSTANCE) continue;
            return true;
        }
        return false;
    }
}

