/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.storage.file.ByteWindow;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;

final class ByteBufferWindow
extends ByteWindow {
    private final ByteBuffer buffer;

    ByteBufferWindow(PackFile pack, long o, ByteBuffer b) {
        super(pack, o, b.capacity());
        this.buffer = b;
    }

    protected int copy(int p, byte[] b, int o, int n) {
        ByteBuffer s2 = this.buffer.slice();
        s2.position(p);
        n = Math.min(s2.remaining(), n);
        s2.get(b, o, n);
        return n;
    }

    void write(PackOutputStream out, long pos, int cnt, MessageDigest digest) throws IOException {
        ByteBuffer s2 = this.buffer.slice();
        s2.position((int)(pos - this.start));
        while (0 < cnt) {
            byte[] buf = out.getCopyBuffer();
            int n = Math.min(cnt, buf.length);
            s2.get(buf, 0, n);
            out.write(buf, 0, n);
            if (digest != null) {
                digest.update(buf, 0, n);
            }
            cnt -= n;
        }
    }

    protected int setInput(int pos, Inflater inf) throws DataFormatException {
        ByteBuffer s2 = this.buffer.slice();
        s2.position(pos);
        byte[] tmp = new byte[Math.min(s2.remaining(), 512)];
        s2.get(tmp, 0, tmp.length);
        inf.setInput(tmp, 0, tmp.length);
        return tmp.length;
    }
}

