/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.ByteArrayWindow;
import org.eclipse.jgit.internal.storage.file.ByteWindow;
import org.eclipse.jgit.internal.storage.file.DeltaBaseCache;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.LocalCachedPack;
import org.eclipse.jgit.internal.storage.file.LocalObjectToPack;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.WindowCache;
import org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.eclipse.jgit.internal.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WindowCursor
extends ObjectReader
implements ObjectReuseAsIs {
    final byte[] tempId = new byte[20];
    private Inflater inf;
    private ByteWindow window;
    private DeltaBaseCache baseCache;
    final FileObjectDatabase db;

    WindowCursor(FileObjectDatabase db) {
        this.db = db;
    }

    DeltaBaseCache getDeltaBaseCache() {
        if (this.baseCache == null) {
            this.baseCache = new DeltaBaseCache();
        }
        return this.baseCache;
    }

    @Override
    public ObjectReader newReader() {
        return new WindowCursor(this.db);
    }

    @Override
    public BitmapIndex getBitmapIndex() throws IOException {
        for (PackFile pack : this.db.getPacks()) {
            PackBitmapIndex index2 = pack.getBitmapIndex();
            if (index2 == null) continue;
            return new BitmapIndexImpl(index2);
        }
        return null;
    }

    @Override
    public Collection<CachedPack> getCachedPacksAndUpdate(BitmapIndex.BitmapBuilder needBitmap) throws IOException {
        for (PackFile pack : this.db.getPacks()) {
            PackBitmapIndex index2 = pack.getBitmapIndex();
            if (!needBitmap.removeAllOrNone(index2)) continue;
            return Collections.singletonList(new LocalCachedPack(Collections.singletonList(pack)));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ObjectId> resolve(AbbreviatedObjectId id2) throws IOException {
        if (id2.isComplete()) {
            return Collections.singleton(id2.toObjectId());
        }
        HashSet<ObjectId> matches = new HashSet<ObjectId>(4);
        this.db.resolve(matches, id2);
        return matches;
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        return this.db.has(objectId);
    }

    @Override
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr = this.db.openObject(this, objectId);
        if (ldr == null) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), "unknown");
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        if (typeHint != -1 && ldr.getType() != typeHint) {
            throw new IncorrectObjectTypeException(objectId.copy(), typeHint);
        }
        return ldr;
    }

    @Override
    public Set<ObjectId> getShallowCommits() throws IOException {
        return this.db.getShallowCommits();
    }

    @Override
    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        long sz = this.db.getObjectSize(this, objectId);
        if (sz < 0L) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), "unknown");
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        return sz;
    }

    @Override
    public LocalObjectToPack newObjectToPack(AnyObjectId objectId, int type) {
        return new LocalObjectToPack(objectId, type);
    }

    @Override
    public void selectObjectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects) throws IOException, MissingObjectException {
        for (ObjectToPack otp : objects) {
            this.db.selectObjectRepresentation(packer, otp, this);
            monitor.update(1);
        }
    }

    @Override
    public void copyObjectAsIs(PackOutputStream out, ObjectToPack otp, boolean validate2) throws IOException, StoredObjectRepresentationNotAvailableException {
        LocalObjectToPack src = (LocalObjectToPack)otp;
        src.pack.copyAsIs(out, src, validate2, this);
    }

    @Override
    public void writeObjects(PackOutputStream out, List<ObjectToPack> list2) throws IOException {
        for (ObjectToPack otp : list2) {
            out.writeObject(otp);
        }
    }

    int copy(PackFile pack, long position2, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        int need;
        int r;
        long length = pack.length;
        for (need = cnt; need > 0 && position2 < length; need -= r) {
            this.pin(pack, position2);
            r = this.window.copy(position2, dstbuf, dstoff, need);
            position2 += (long)r;
            dstoff += r;
        }
        return cnt - need;
    }

    @Override
    public void copyPackAsIs(PackOutputStream out, CachedPack pack, boolean validate2) throws IOException {
        ((LocalCachedPack)pack).copyAsIs(out, validate2, this);
    }

    void copyPackAsIs(PackFile pack, long length, boolean validate2, PackOutputStream out) throws IOException {
        int n;
        MessageDigest md = null;
        if (validate2) {
            md = Constants.newMessageDigest();
            byte[] buf = out.getCopyBuffer();
            this.pin(pack, 0L);
            if (this.window.copy(0, buf, 0, 12) != 12) {
                pack.setInvalid();
                throw new IOException(JGitText.get().packfileIsTruncated);
            }
            md.update(buf, 0, 12);
        }
        long position2 = 12L;
        for (long remaining = length - 32L; 0L < remaining; remaining -= (long)n) {
            this.pin(pack, position2);
            int ptr = (int)(position2 - this.window.start);
            n = (int)Math.min((long)(this.window.size() - ptr), remaining);
            this.window.write(out, position2, n, md);
            position2 += (long)n;
        }
        if (md != null) {
            byte[] buf = new byte[20];
            byte[] actHash = md.digest();
            this.pin(pack, position2);
            if (this.window.copy(position2, buf, 0, 20) != 20) {
                pack.setInvalid();
                throw new IOException(JGitText.get().packfileIsTruncated);
            }
            if (!Arrays.equals(actHash, buf)) {
                pack.setInvalid();
                throw new IOException(MessageFormat.format(JGitText.get().packfileCorruptionDetected, pack.getPackFile().getPath()));
            }
        }
    }

    int inflate(PackFile pack, long position2, byte[] dstbuf, boolean headerOnly) throws IOException, DataFormatException {
        this.prepareInflater();
        this.pin(pack, position2);
        position2 += (long)this.window.setInput(position2, this.inf);
        int dstoff = 0;
        while (true) {
            int n = this.inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff);
            if (this.inf.finished() || headerOnly && (dstoff += n) == dstbuf.length) {
                return dstoff;
            }
            if (this.inf.needsInput()) {
                this.pin(pack, position2);
                position2 += (long)this.window.setInput(position2, this.inf);
                continue;
            }
            if (n == 0) break;
        }
        throw new DataFormatException();
    }

    ByteArrayWindow quickCopy(PackFile p, long pos, long cnt) throws IOException {
        this.pin(p, pos);
        if (this.window instanceof ByteArrayWindow && this.window.contains(p, pos + (cnt - 1L))) {
            return (ByteArrayWindow)this.window;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(PackFile pack, long position2) throws IOException {
        ByteWindow w = this.window;
        if (w == null || !w.contains(pack, position2)) {
            this.window = null;
            this.window = WindowCache.get(pack, position2);
        }
    }

    int getStreamFileThreshold() {
        return WindowCache.getStreamFileThreshold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.window = null;
        this.baseCache = null;
        try {
            InflaterCache.release(this.inf);
            Object var2_1 = null;
            this.inf = null;
        }
        catch (Throwable throwable2) {
            Object var2_2 = null;
            this.inf = null;
            throw throwable2;
        }
    }
}

