/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;

public class StrategyOneSided
extends MergeStrategy {
    private final String strategyName;
    private final int treeIndex;

    protected StrategyOneSided(String name2, int index2) {
        this.strategyName = name2;
        this.treeIndex = index2;
    }

    public String getName() {
        return this.strategyName;
    }

    public Merger newMerger(Repository db) {
        return new OneSide(db, this.treeIndex);
    }

    public Merger newMerger(Repository db, boolean inCore) {
        return new OneSide(db, this.treeIndex);
    }

    static class OneSide
    extends Merger {
        private final int treeIndex;

        protected OneSide(Repository local2, int index2) {
            super(local2);
            this.treeIndex = index2;
        }

        protected boolean mergeImpl() throws IOException {
            return this.treeIndex < this.sourceTrees.length;
        }

        public ObjectId getResultTreeId() {
            return this.sourceTrees[this.treeIndex];
        }

        public ObjectId getBaseCommitId() {
            return null;
        }
    }
}

