/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by vfsgen; DO NOT EDIT.

package deploy

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"os"
	pathpkg "path"
	"time"
)

// assets statically implements the virtual filesystem provided to vfsgen.
var assets = func() http.FileSystem {
	fs := vfsgen۰FS{
		"/": &vfsgen۰DirInfo{
			name:    "/",
			modTime: time.Time{},
		},
		"/addons": &vfsgen۰DirInfo{
			name:    "addons",
			modTime: time.Time{},
		},
		"/addons/master": &vfsgen۰DirInfo{
			name:    "master",
			modTime: time.Time{},
		},
		"/addons/master/master-role-binding.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "master-role-binding.tmpl",
			modTime:          time.Time{},
			uncompressedSize: 362,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\x90\xbd\x4e\xc5\x30\x0c\x85\xf7\x3c\x85\x75\xf7\x1b\xd4\x0d\x65\x83\x85\x8d\xa1\x48\xec\x4e\x6a\xc0\x34\x89\xa3\xfc\x74\xa0\xea\xbb\xa3\xb6\x48\x14\x09\xf5\x8e\xc9\xa7\x63\x7f\x3e\x23\xc7\xc1\x40\x2f\x9e\x1e\x39\x0e\x1c\xdf\x15\x26\x7e\xa5\x5c\x58\xa2\x81\x6c\xd1\x69\x6c\xf5\x43\x32\x7f\x61\x65\x89\x7a\xbc\x2f\x9a\xe5\x6e\xea\x2c\x55\xec\x54\xa0\x8a\x03\x56\x34\x0a\x20\x62\x20\x03\xf3\x0c\xfa\x19\x03\xc1\xb2\xfc\xfc\x95\x84\xee\x00\xb6\xe7\x4e\x3d\x5a\xf2\x65\xcd\x02\x60\x4a\x06\x2e\x0e\x03\xf9\xeb\x78\x51\xa5\xd9\x4f\x72\x75\x83\x57\xd8\x35\x5f\x28\x4f\xec\xe8\xc1\x39\x69\xb1\x6e\xa9\xf3\xf9\x47\xa7\xbf\xe1\x95\x67\xf1\xd4\xd3\xdb\xba\xe1\xb7\x86\x9b\xce\xff\x5d\x89\x89\x9f\xb2\xb4\x74\xd2\x98\xfa\x0e\x00\x00\xff\xff\xa6\x3e\x0f\x20\x6a\x01\x00\x00"),
		},
		"/addons/master/master-role.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "master-role.tmpl",
			modTime:          time.Time{},
			uncompressedSize: 347,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\x8d\xb1\x6e\xc3\x30\x0c\x44\x77\x7d\x05\xe1\xdd\x2e\xb2\x15\xfa\x81\x6e\x1d\x3a\x74\x3f\xcb\x6c\x22\x58\x16\x09\x4a\x4a\x81\x06\xf9\xf7\xa2\x72\x02\x14\xed\x92\x89\xc7\x77\x47\xde\x1a\xf3\xe2\xe9\x4d\x12\x3b\x68\x7c\x67\x2b\x51\xb2\x27\x9b\x11\x26\xb4\x7a\x12\x8b\x5f\xa8\x51\xf2\xb4\x3e\x97\x29\xca\xd3\xf9\x30\x73\xc5\xc1\x6d\x5c\xb1\xa0\xc2\x3b\xa2\x8c\x8d\x3d\x5d\x2e\x34\xbd\x62\x63\xba\x5e\x6f\xac\x28\xc2\x2f\xa3\xaf\xbb\x9b\x30\x73\x2a\x3f\xb7\x44\x50\xf5\x34\x04\x6c\x9c\xc6\x75\x70\xd6\x12\x17\xef\x46\x82\xc6\x17\x93\xa6\x3d\x36\xd2\x30\x38\x22\xe3\x22\xcd\x02\xdf\x58\x90\xfc\x11\x8f\x1b\xb4\x38\xa2\x33\xdb\x7c\xe7\xc6\xa8\xdc\xe5\x91\x6b\x9f\x29\x96\x5d\x28\x6a\x38\x75\xd5\x74\xb9\xa7\x3e\x3b\x7c\xa8\x53\x65\xf9\xd3\xf6\xaf\x62\xff\xf6\x1d\x00\x00\xff\xff\x40\x05\x71\xea\x5b\x01\x00\x00"),
		},
		"/builder-role-binding.yaml": &vfsgen۰CompressedFileInfo{
			name:             "builder-role-binding.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1207,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x93\x41\x6f\xe3\x36\x14\x84\xef\xfc\x15\x03\xeb\x92\x00\xb6\xdc\xf4\x54\xb8\x27\x25\xb1\x5b\xa1\x81\x0d\x58\x4e\x83\x1c\x29\xea\x59\x7a\x35\x45\xaa\x24\x15\xc5\xfb\xeb\x17\x94\xed\x4d\x82\xc5\xe6\x14\xde\x04\x3d\xcd\xfb\x86\x33\x4a\x30\xfb\xba\x23\x12\x3c\xb0\x22\xe3\xa9\x42\xb0\x08\x0d\x21\xeb\xa4\x6a\x08\x85\xdd\x87\x41\x3a\xc2\xca\xf6\xa6\x92\x81\xad\xc1\x55\x56\xac\xae\xd1\x9b\x8a\x1c\xac\x21\x58\x87\xd6\x3a\x12\x09\x94\x35\xc1\x71\xd9\x07\xeb\xa0\x4f\x82\x90\xb5\x23\x6a\xc9\x04\x9f\x02\x05\xd1\xa8\xbe\xde\xec\xf2\xbb\x25\xf6\xac\x09\x15\xfb\xd3\x47\x54\x61\xe0\xd0\x88\x04\xa1\x61\x8f\xc1\xba\x03\xf6\xd6\x41\x56\x15\xc7\xc5\x52\x83\xcd\xde\xba\xf6\x84\xe1\xa8\x96\xae\x62\x53\x43\xd9\xee\xe8\xb8\x6e\x02\xec\x60\xc8\xf9\x86\xbb\x54\x24\xd8\x45\x1b\xc5\xea\x42\xe2\x4f\xb2\xe3\xce\x60\xf1\x6c\xfb\xb3\x87\x77\x76\xcf\xb7\x30\xc5\xbf\xe4\x7c\x5c\xf2\x7b\xfa\x9b\x48\x70\x15\x47\x26\xe7\x97\x93\xeb\x3f\x71\xb4\x3d\x5a\x79\x84\xb1\x01\xbd\xa7\x77\xca\xf4\xaa\xa8\x0b\x60\x03\x65\xdb\x4e\xb3\x34\x8a\xde\x6c\xfd\xd8\x90\x62\x04\x88\x1a\xb6\x0c\x92\x0d\xe4\x68\x03\x76\xff\x7e\x0c\x32\x88\x44\x24\x18\x4f\x13\x42\xb7\x98\xcf\x87\x61\x48\xe5\x88\x9b\x5a\x57\xcf\x2f\xee\xe6\x0f\xf9\xdd\x72\x5d\x2c\x67\x23\xb2\x48\xf0\x68\x34\x79\x0f\x47\xff\xf7\xec\xa8\x42\x79\x84\xec\x3a\xcd\x4a\x96\x9a\xa0\xe5\x10\x83\x1b\xd3\x19\x43\x67\x83\xc1\x71\x60\x53\x4f\xe1\xcf\xa9\x8b\xe4\x43\x3a\x6f\xd7\x75\xc1\x63\xff\x61\xc0\x1a\x48\x83\x49\x56\x20\x2f\x26\xb8\xcd\x8a\xbc\x98\x8a\x04\x4f\xf9\xee\xef\xcd\xe3\x0e\x4f\xd9\x76\x9b\xad\x77\xf9\xb2\xc0\x66\x8b\xbb\xcd\xfa\x3e\xdf\xe5\x9b\x75\x81\xcd\x0a\xd9\xfa\x19\xff\xe4\xeb\xfb\x29\x88\x43\x43\x0e\xf4\xda\xb9\xc8\x6f\x1d\x38\x5e\x24\x55\x31\xd3\x4b\x81\x2e\x00\xb1\x1f\xf1\xd9\x77\xa4\x78\xcf\x0a\x5a\x9a\xba\x97\x35\xa1\xb6\x2f\xe4\x4c\xac\x47\x47\xae\x65\x1f\xe3\xf4\x90\xa6\x12\x09\x34\xb7\x1c\xc6\x16\xf9\x9f\x4d\xc5\x35\x5f\xf9\x6f\x89\x03\x9b\x6a\x81\xad\xd5\x74\xcb\x26\x16\x56\xc8\x8e\xcf\x05\x5b\xc0\x95\x52\xa5\xb2\x0f\x8d\x75\xfc\x6d\x64\x4a\x0f\x7f\xf8\x94\xed\xfc\xe5\xa6\xa4\x20\x6f\x44\x4b\x41\x56\x32\xc8\x85\x00\x8c\x6c\x69\x01\x25\x5b\xd2\xb3\xc3\xac\xec\x59\x57\xe4\x04\xa0\x65\x49\xda\xc7\x09\xc4\x94\x17\x98\x9c\x67\x26\xc2\xf7\xe5\x7f\xa4\x82\x5f\x88\x19\x4e\x28\x05\xb9\x17\x56\x94\x29\x65\x7b\x13\x7e\xa9\xea\xac\xa6\x2d\xed\xa3\xe8\x9b\x85\x4f\x18\x64\xc7\x7f\x39\xdb\x77\x9f\x78\x12\xdf\x03\x00\x00\xff\xff\x69\xf9\x8e\x97\xb7\x04\x00\x00"),
		},
		"/builder-role-kubernetes.yaml": &vfsgen۰CompressedFileInfo{
			name:             "builder-role-kubernetes.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1456,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x54\xc1\x8e\xdb\x36\x14\xbc\xf3\x2b\x06\xd2\x25\x29\xd6\x72\xd3\x53\xe1\x9e\xdc\xcd\x6e\x2b\x34\xb0\x81\x95\xd3\x20\x47\x8a\x7c\x96\x1e\x96\x22\x59\x92\x5a\x65\xfb\xf5\x05\x69\xbb\xf1\x76\x2f\x29\x10\x5e\xfc\x48\x0f\xe7\xcd\x70\x9e\x5d\x63\xf5\xfd\x96\xa8\xf1\x81\x15\xd9\x48\x1a\xc9\x21\x8d\x84\xad\x97\x6a\x24\x74\xee\x98\x16\x19\x08\xf7\x6e\xb6\x5a\x26\x76\x16\x6f\xb6\xdd\xfd\x5b\xcc\x56\x53\x80\xb3\x04\x17\x30\xb9\x40\xa2\x86\x72\x36\x05\xee\xe7\xe4\x02\xcc\x89\x10\x72\x08\x44\x13\xd9\x14\x1b\xa0\x23\x2a\xec\xbb\xfd\xa1\xbd\xbd\xc3\x91\x0d\x41\x73\x3c\x5d\x22\x8d\x85\xd3\x28\x6a\xa4\x91\x23\x16\x17\x1e\x71\x74\x01\x52\x6b\xce\x8d\xa5\x01\xdb\xa3\x0b\xd3\x49\x46\xa0\x41\x06\xcd\x76\x80\x72\xfe\x39\xf0\x30\x26\xb8\xc5\x52\x88\x23\xfb\x46\xd4\x38\x64\x1b\xdd\xfd\x45\x49\x3c\xd1\x96\x9e\xc9\xe1\xb3\x9b\xcf\x1e\xae\xec\x9e\x5f\xe1\x06\x7f\x52\x88\xb9\xc9\x4f\xcd\x8f\xa2\xc6\x9b\x0c\xa9\xce\x5f\x56\x6f\x7f\xc1\xb3\x9b\x31\xc9\x67\x58\x97\x30\x47\xba\x62\xa6\x2f\x8a\x7c\x02\x5b\x28\x37\x79\xc3\xd2\x2a\xfa\x6a\xeb\xdf\x0e\x0d\x8a\x80\xcc\xe1\xfa\x24\xd9\x42\x16\x1b\x70\xc7\x6b\x18\x64\x12\xb5\xa8\x51\xd6\x98\x92\xdf\xac\xd7\xcb\xb2\x34\xb2\xc8\x6d\x5c\x18\xd6\x17\x77\xeb\x0f\xed\xed\xdd\xae\xbb\x5b\x15\xc9\xa2\xc6\x47\x6b\x28\x46\x04\xfa\x6b\xe6\x40\x1a\xfd\x33\xa4\xf7\x86\x95\xec\x0d\xc1\xc8\x25\x07\x57\xd2\x29\xa1\xb3\xc5\x12\x38\xb1\x1d\x6e\x10\xcf\xa9\x8b\xfa\x45\x3a\x5f\x9f\xeb\x22\x8f\xe3\x0b\x80\xb3\x90\x16\xd5\xb6\x43\xdb\x55\xf8\x75\xdb\xb5\xdd\x8d\xa8\xf1\xa9\x3d\xfc\xbe\xff\x78\xc0\xa7\xed\xc3\xc3\x76\x77\x68\xef\x3a\xec\x1f\x70\xbb\xdf\xbd\x6f\x0f\xed\x7e\xd7\x61\x7f\x8f\xed\xee\x33\xfe\x68\x77\xef\x6f\x40\x9c\x46\x0a\xa0\x2f\x3e\x64\xfd\x2e\x80\xf3\x43\x92\xce\x99\x5e\x06\xe8\x22\x20\xcf\x47\xde\x47\x4f\x8a\x8f\xac\x60\xa4\x1d\x66\x39\x10\x06\xf7\x44\xc1\xe6\xf1\xf0\x14\x26\x8e\x39\xce\x08\x69\xb5\xa8\x61\x78\xe2\x54\xa6\x28\xbe\x36\x95\xdb\x7c\xcf\xdf\x96\x78\x64\xab\x37\x78\x70\x86\x84\xf4\x7c\x9e\xac\x0d\x42\x2f\x55\x23\xe7\x34\xba\xc0\x7f\x17\x31\xcd\xe3\xcf\xb1\x61\xb7\x7e\x7a\xd7\x53\x92\xef\xc4\x44\x49\x6a\x99\xe4\x46\x00\x56\x4e\xb4\x81\x92\x13\x99\xd5\xe3\xaa\x9f\xd9\x68\x0a\x02\x30\xb2\x27\x13\x33\x02\x39\xde\x0d\xaa\x33\xa6\x12\x61\x36\x14\x37\x62\x05\xe9\xf9\xb7\xe0\x66\x5f\x60\xab\x13\xc9\xd5\x08\x09\x20\x50\x74\x73\x50\x74\x46\x54\x3f\x54\x02\x78\xa2\xd0\x5f\x1d\xbc\xe2\xa9\xaa\xd7\x37\xbd\xd3\xf1\xe5\x55\x15\x48\x26\x2a\xa5\x26\x43\x2f\x4a\xe5\x8c\x21\x95\xad\x97\xc3\x81\x52\xf9\x34\x1c\x4f\x85\x97\x49\x8d\xa5\x9a\xbd\xbe\xb0\x2c\xe5\xf0\x9b\xd4\x28\x67\x8f\x3c\x4c\xd2\xc7\xb2\x8d\xa4\x02\xa5\xff\xe8\x7b\xd5\xf4\x7f\xf0\xd3\x53\xfe\x5f\xfb\x26\xbe\x7f\x02\x00\x00\xff\xff\x2e\x96\x8f\xf5\xb0\x05\x00\x00"),
		},
		"/builder-role-openshift.yaml": &vfsgen۰CompressedFileInfo{
			name:             "builder-role-openshift.yaml",
			modTime:          time.Time{},
			uncompressedSize: 2121,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xc4\x54\x4d\x8f\xdb\x36\x10\xbd\xf3\x57\x3c\x48\x97\xa4\x58\xcb\x4d\x4f\x85\x7b\x72\x93\xdd\xd6\x68\x60\x03\x2b\xa7\x41\x8e\x23\x69\x2c\x0d\x4c\x91\x2c\x49\xad\xe2\xfe\xfa\x42\xb4\xdd\xb5\xe3\xf4\x0b\x0d\x10\x5d\x3c\x1a\x0e\xdf\xbc\x37\x6f\xac\x1c\xb3\x2f\xf7\xa8\x1c\x6f\xa5\x66\x13\xb8\x41\xb4\x88\x1d\x63\xe9\xa8\xee\x18\xa5\xdd\xc5\x91\x3c\xe3\xc1\x0e\xa6\xa1\x28\xd6\xe0\xc5\xb2\x7c\x78\x89\xc1\x34\xec\x61\x0d\xc3\x7a\xf4\xd6\xb3\xca\x51\x5b\x13\xbd\x54\x43\xb4\x1e\xfa\x08\x08\x6a\x3d\x73\xcf\x26\x86\x02\x28\x99\x13\xfa\x7a\xb3\x5d\xbd\xbe\xc7\x4e\x34\xa3\x91\x70\xbc\xc4\x0d\x46\x89\x9d\xca\x11\x3b\x09\x18\xad\xdf\x63\x67\x3d\xa8\x69\x64\x6a\x4c\x1a\x62\x76\xd6\xf7\x47\x1a\x9e\x5b\xf2\x8d\x98\x16\xb5\x75\x07\x2f\x6d\x17\x61\x47\xc3\x3e\x74\xe2\x0a\x95\x63\x3b\xc9\x28\x1f\xce\x4c\xc2\x11\x36\xf5\x8c\x16\x1f\xec\x70\xd2\x70\x21\xf7\x34\x85\x3b\xfc\xca\x3e\x4c\x4d\xbe\x2b\xbe\x55\x39\x5e\x4c\x25\xd9\xe9\x30\x7b\xf9\x03\x0e\x76\x40\x4f\x07\x18\x1b\x31\x04\xbe\x40\xe6\x8f\x35\xbb\x08\x31\xa8\x6d\xef\xb4\x90\xa9\xf9\x59\xd6\x9f\x1d\x0a\x24\x02\x13\x86\xad\x22\x89\x01\x25\x19\xb0\xbb\xcb\x32\x50\x54\xb9\xca\x91\x9e\x2e\x46\xb7\x98\xcf\xc7\x71\x2c\x28\xd1\x2d\xac\x6f\xe7\x67\x75\xf3\xb7\xab\xd7\xf7\xeb\xf2\x7e\x96\x28\xab\x1c\xef\x8c\xe6\x10\xe0\xf9\xb7\x41\x3c\x37\xa8\x0e\x20\xe7\xb4\xd4\x54\x69\x86\xa6\x71\x32\x2e\xb9\x93\x4c\x17\x83\xd1\x4b\x14\xd3\xde\x21\x9c\x5c\x57\xf9\x95\x3b\xcf\xe3\x3a\xd3\x93\x70\x55\x60\x0d\xc8\x20\x5b\x96\x58\x95\x19\x7e\x5c\x96\xab\xf2\x4e\xe5\x78\xbf\xda\xfe\xbc\x79\xb7\xc5\xfb\xe5\xe3\xe3\x72\xbd\x5d\xdd\x97\xd8\x3c\xe2\xf5\x66\xfd\x66\xb5\x5d\x6d\xd6\x25\x36\x0f\x58\xae\x3f\xe0\x97\xd5\xfa\xcd\x1d\x58\x62\xc7\x1e\xfc\xd1\xf9\x89\xbf\xf5\x90\x69\x90\xdc\x4c\x9e\x9e\x17\xe8\x4c\x60\xda\x8f\xe9\x3d\x38\xae\x65\x27\x35\x34\x99\x76\xa0\x96\xd1\xda\x27\xf6\x66\x5a\x0f\xc7\xbe\x97\x30\xd9\x19\x40\xa6\x51\x39\xb4\xf4\x12\xd3\x16\x85\x5b\x51\x53\x9b\x2f\xf9\xdf\x52\x7b\x31\xcd\x02\x8f\x56\xb3\x22\x27\xa7\xcd\x5a\xc0\x57\x54\x17\x34\xc4\xce\x7a\xf9\x3d\x91\x29\xf6\xdf\x87\x42\xec\xfc\xe9\x55\xc5\x91\x5e\xa9\x9e\x23\x35\x14\x69\xa1\x00\x43\x3d\x2f\x50\x53\xcf\x7a\xb6\x9f\x55\x83\xe8\x86\xbd\x02\x34\x55\xac\xc3\x54\x81\xc9\xde\x05\xb2\x53\x4d\xa6\xfc\xa0\x39\x2c\xd4\x0c\xe4\xe4\x27\x6f\x07\x97\xca\x66\x47\x90\x8b\x15\x52\x80\xe7\x60\x07\x5f\xf3\xa9\x22\xfb\x26\x53\xc0\x13\xfb\xea\x22\x71\x83\x93\x65\xb7\x37\x9d\x6d\xc2\xf5\xd5\xda\x33\x45\x4e\x61\xc3\x9a\xaf\xc2\xda\x6a\xcd\xf5\x24\x3d\x25\x5b\x8e\xe9\x57\x4b\x38\x06\x8e\x62\xdd\xa5\x68\x70\xcd\x19\x65\x4c\xc9\x7f\xc5\xa6\xb6\x66\x27\x6d\x4f\x2e\xa4\xd7\xc0\xb5\xe7\xf8\x09\xbf\x9b\xa6\xff\x01\x9f\x9f\xa6\xef\xda\xff\xc0\x9b\x21\x4b\x56\x16\xd6\xb1\x09\x9d\xec\x62\x21\xf6\x33\x8d\x52\xd1\x51\x4d\xb8\x49\xcc\x47\xae\x3a\x6b\xf7\x17\x27\x5f\xd3\x83\x19\x32\xe9\xa9\xe5\x7f\xd2\x94\x8a\x42\xf4\x4c\xfd\x31\xfc\x34\xdb\x93\x73\x62\xda\x9b\xfc\x6d\x62\xfe\xec\xec\xd5\x41\xa4\xf6\xeb\x4e\xe2\xd6\x5c\x05\x50\x3c\x7d\x30\x1f\x27\x9a\x92\x3a\x86\x05\xcc\xa0\xf5\xdf\x3b\x3f\x17\x13\x22\x99\x28\xe7\xe6\x7f\x75\x58\x89\x21\x7f\xb8\x58\x87\x79\xad\xad\xe1\xcf\x8e\xe2\x8f\x00\x00\x00\xff\xff\xc7\xc5\xbf\xa3\x49\x08\x00\x00"),
		},
		"/builder-service-account.yaml": &vfsgen۰CompressedFileInfo{
			name:             "builder-service-account.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1038,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\x3d\x6f\xdb\x30\x14\xdc\xf9\x2b\x0e\xd6\x92\x00\xfe\x68\x3b\xba\x93\x9a\xd8\xa8\xd0\xc0\x06\x22\xa7\x41\xc6\x67\xf1\x59\x7a\x08\x45\xaa\x24\x15\xc5\xff\xbe\xa0\x6c\x37\x09\xba\x86\x9b\xa0\xd3\x7d\xf0\x4e\x19\x66\x9f\x77\x54\x86\x3b\xa9\xd8\x06\xd6\x88\x0e\xb1\x61\xe4\x1d\x55\x0d\xa3\x74\x87\x38\x90\x67\xac\x5d\x6f\x35\x45\x71\x16\x57\x79\xb9\xbe\x46\x6f\x35\x7b\x38\xcb\x70\x1e\xad\xf3\xac\x32\x54\xce\x46\x2f\xfb\x3e\x3a\x0f\x73\x22\x04\xd5\x9e\xb9\x65\x1b\xc3\x1c\x28\x99\x47\xf6\xcd\x76\x57\xdc\xac\x70\x10\xc3\xd0\x12\x4e\x1f\xb1\xc6\x20\xb1\x51\x19\x62\x23\x01\x83\xf3\xcf\x38\x38\x0f\xd2\x5a\x92\x30\x19\x88\x3d\x38\xdf\x9e\x6c\x78\xae\xc9\x6b\xb1\x35\x2a\xd7\x1d\xbd\xd4\x4d\x84\x1b\x2c\xfb\xd0\x48\x37\x57\x19\x76\x29\x46\xb9\xbe\x38\x09\x27\xda\x51\x33\x3a\x3c\xb9\xfe\x9c\xe1\x5d\xdc\xf3\x2d\x4c\xf1\x9b\x7d\x48\x22\xdf\xe6\x5f\x54\x86\xab\x04\x99\x9c\x5f\x4e\xae\xbf\xe3\xe8\x7a\xb4\x74\x84\x75\x11\x7d\xe0\x77\xcc\xfc\x5a\x71\x17\x21\x16\x95\x6b\x3b\x23\x64\x2b\x7e\x8b\xf5\x4f\x61\x8e\xd1\x40\xe2\x70\xfb\x48\x62\x41\x63\x0c\xb8\xc3\x7b\x18\x28\xaa\x4c\x65\x18\x4f\x13\x63\xb7\x5c\x2c\x86\x61\x98\xd3\x68\x77\xee\x7c\xbd\xb8\xa4\x5b\xdc\x15\x37\xab\x4d\xb9\x9a\x8d\x96\x55\x86\x07\x6b\x38\x04\x78\xfe\xd3\x8b\x67\x8d\xfd\x11\xd4\x75\x46\x2a\xda\x1b\x86\xa1\x21\x15\x37\xb6\x33\x96\x2e\x16\x83\x97\x28\xb6\x9e\x22\x9c\x5b\x57\xd9\x87\x76\xde\xae\xeb\x62\x4f\xc2\x07\x80\xb3\x20\x8b\x49\x5e\xa2\x28\x27\xf8\x91\x97\x45\x39\x55\x19\x1e\x8b\xdd\xcf\xed\xc3\x0e\x8f\xf9\xfd\x7d\xbe\xd9\x15\xab\x12\xdb\x7b\xdc\x6c\x37\xb7\xc5\xae\xd8\x6e\x4a\x6c\xd7\xc8\x37\x4f\xf8\x55\x6c\x6e\xa7\x60\x89\x0d\x7b\xf0\x6b\xe7\x93\x7f\xe7\x21\xe9\x22\x59\xa7\x4e\x2f\x03\xba\x18\x48\xfb\x48\xcf\xa1\xe3\x4a\x0e\x52\xc1\x90\xad\x7b\xaa\x19\xb5\x7b\x61\x6f\xd3\x3c\x3a\xf6\xad\x84\x54\x67\x00\x59\xad\x32\x18\x69\x25\x8e\x2b\x0a\xff\x87\x4a\x32\x9f\xf9\x6f\x29\xea\xe4\x3c\xa7\x25\x5e\xbe\xaa\x67\xb1\x7a\x89\x92\xfd\x8b\x54\x9c\x57\x95\xeb\x6d\x54\x2d\x47\xd2\x14\x69\xa9\x00\x4b\x2d\x2f\x51\x51\xcb\x66\xf6\x3c\xdb\xf7\x62\x34\x7b\x05\x18\xda\xb3\x09\x09\x81\xd4\xe4\x12\x93\x33\x66\xa2\xfe\x06\x00\x00\xff\xff\x4e\x4d\xa1\x73\x0e\x04\x00\x00"),
		},
		"/camel-catalog-1.3.0-SNAPSHOT-main.yaml": &vfsgen۰CompressedFileInfo{
			name:             "camel-catalog-1.3.0-SNAPSHOT-main.yaml",
			modTime:          time.Time{},
			uncompressedSize: 87359,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x7d\x5b\x77\xdb\x38\xb2\xee\x7b\x7e\x05\xd7\xe4\x65\xef\x75\x46\x98\x6e\x67\x66\xfa\xec\x3e\x4f\xb6\x1c\x27\x76\x6c\xc7\x1d\x7a\x92\xcc\xbc\xf4\x82\x48\x48\x82\x45\x12\x34\x00\xc9\xb2\x7f\xfd\x59\xb8\xf0\x2a\x08\x12\x59\x86\xd7\xf6\x83\x49\x11\x55\x5f\xb1\x00\x10\xd7\x42\xd5\xfb\x68\xf2\x7a\x7f\xef\xde\x47\xd7\x34\x21\x85\x20\x69\x24\x59\x24\x97\x24\x3a\x2d\x71\xb2\x24\x51\xcc\xe6\xf2\x09\x73\x12\x5d\xb0\x75\x91\x62\x49\x59\x11\xfd\xd7\x69\x7c\xf1\xdf\xd1\xba\x48\x09\x8f\x58\x41\x22\xc6\xa3\x9c\x71\xf2\xee\x7d\x94\xb0\x42\x72\x3a\x5b\x4b\xc6\xa3\xcc\x00\x46\x78\xc1\x09\xc9\x49\x21\x05\x8a\xa2\x98\x10\x8d\x7e\xfb\xf5\xfe\x72\xfa\x31\x9a\xd3\x8c\x44\x29\x15\x86\x89\xa4\xd1\x13\x95\xcb\x77\xef\x23\xb9\xa4\x22\x7a\x62\x7c\x15\xcd\x19\x8f\x70\x9a\x52\x25\x18\x67\x11\x2d\xe6\x8c\xe7\xe6\x35\x38\x59\x60\x9e\xd2\x62\x11\x25\xac\x7c\xe6\x74\xb1\x94\x11\x7b\x2a\x08\x17\x4b\x5a\xa2\x77\xef\xa3\x7b\xa5\x46\x7c\x51\xbd\x89\x30\xb0\x5a\xa6\x64\xd1\xbf\xd9\xda\xea\xd0\x52\xd7\xe6\xc2\x5f\xa3\xef\x84\x0b\x25\xe4\x04\xfd\xf2\xee\x7d\xf4\x5f\x8a\xe4\x2f\x36\xf1\x2f\xff\xfd\xff\xa2\x67\xb6\x8e\x72\xfc\x1c\x15\x4c\x46\x6b\x41\x5a\xc8\x64\x9b\x90\x52\x46\xb4\x88\x12\x96\x97\x19\xc5\x45\x42\x1a\xb5\x6a\x09\x28\xd2\x2f\xa0\x30\xd8\x4c\x62\x5a\x44\x58\xab\x11\xb1\x79\x9b\x2c\xc2\xf2\xdd\xfb\x77\xef\x23\xfd\xb7\x94\xb2\xfc\xfd\x6f\x7f\x7b\x7a\x7a\x42\x58\xbf\x2e\x62\x7c\xf1\xb7\x4a\xbb\xbf\x5d\x5f\x4e\x3f\xde\xc6\x1f\x27\xfa\x95\xdf\xbd\x8f\xfe\x55\x64\x44\x88\x88\x93\xc7\x35\xe5\x24\x8d\x66\xcf\x11\x2e\xcb\x8c\x26\x78\x96\x91\x28\xc3\x4f\xaa\xe0\x74\xe9\xe8\x42\xa7\x45\xf4\xc4\xa9\xa4\xc5\xe2\xaf\x91\xb0\xa5\xfe\xee\x7d\xa7\x74\x9a\xec\xaa\x5e\x8f\x8a\x0e\x01\x2b\x22\x5c\x44\x7f\x39\x8d\xa3\xcb\xf8\x2f\xd1\xd9\x69\x7c\x19\xff\xf5\xdd\xfb\xe8\xc7\xe5\xfd\xe7\xaf\xff\xba\x8f\x7e\x9c\x7e\xfb\x76\x7a\x7b\x7f\xf9\x31\x8e\xbe\x7e\x8b\xa6\x5f\x6f\xcf\x2f\xef\x2f\xbf\xde\xc6\xd1\xd7\x8b\xe8\xf4\xf6\xdf\xd1\x97\xcb\xdb\xf3\xbf\x46\x84\xca\x25\xe1\x11\xd9\x96\x5c\xbd\x3f\xe3\x11\x55\x19\x49\x52\x55\xa6\x55\x05\xaa\x5e\x40\xd5\x0f\xf5\x5b\x94\x24\xa1\x73\x9a\x44\x19\x2e\x16\x6b\xbc\x20\xd1\x82\x6d\x08\x2f\x54\xf5\x28\x09\xcf\xa9\x50\xc5\x29\x22\x5c\xa4\xef\xde\x47\x19\xcd\xa9\xd4\xb5\x48\xec\x2a\xa5\xc4\xbc\xe6\xb7\xf5\x0e\x97\xd4\x56\xa7\xdf\xa3\x04\xe7\x24\x6b\x17\xdf\xe6\xd7\x77\x2b\x5a\xa4\xbf\x47\x53\x95\x32\xc5\x12\x67\x6c\xf1\x2e\x27\x12\xa7\x58\xe2\xdf\xdf\x45\x51\x81\x73\x62\x19\x27\x89\x49\x9f\xfc\x8a\x3e\xa0\x5f\x26\xa2\xc0\xa5\x58\x32\x39\xc9\x31\x2d\xde\x45\x51\x86\x67\x24\x13\x8a\x27\x52\x45\x5d\x31\xad\xf4\x83\x1d\xc9\x16\x0b\x6d\xaa\x77\xfb\x80\x7e\x45\xbf\xf8\x69\x33\x86\x53\xc2\x8f\x62\xe1\xeb\x42\xd2\x9c\x34\xb4\xe6\x9d\xe3\xdb\xd3\xbb\xf8\xf3\xd7\x7b\x3f\x53\xc9\xd9\x86\xa6\x84\xff\x1e\x69\xd5\x54\xe9\x2a\xb5\x6c\xb2\xd1\xd0\x07\xdc\xe3\xb7\x19\xa2\xea\xbe\x2a\xf4\x69\x86\x85\xf8\x3d\x62\x7c\x51\xc9\x36\x2f\xb2\x42\x8a\x1a\x9d\x36\x94\x9a\xb3\x5d\x18\xcd\x5b\x3b\xf2\x20\x8a\x1e\xd7\x98\xaf\xd6\xa2\xa7\x34\xba\xa0\x05\xce\xda\xdc\x13\x07\xe1\x2f\xe8\x97\xc9\xcd\x3f\x34\x55\x4a\x4a\x52\xa4\xa4\x48\x28\xb1\xc5\x39\x89\x16\x9c\xad\xcb\xcb\xd4\xf5\xda\x16\x19\x73\x49\xe7\x38\x91\x8a\xc8\x96\xfc\xc4\xe6\xd8\xa4\xce\x86\x04\x97\x78\x46\x33\x2a\x6b\xe8\x28\x4a\x38\x2b\xaa\x7b\x97\xf0\x63\x5f\xe0\xd0\x4b\x28\x39\x96\x74\x49\x70\x26\x97\x6f\x21\xd4\x48\xb2\xc4\x65\x86\xa5\xea\x41\x26\xba\x2d\x7d\x0b\xe9\x52\x96\x96\x94\x13\x21\x01\x22\xbd\x02\x15\x76\x88\xf7\xae\x48\xec\x2b\x1a\xaa\x17\x5a\xaa\xae\xae\x7a\xeb\x43\x6f\xbc\x2b\xc6\x02\xd8\x74\xf5\x69\x99\x5e\xbd\xce\x88\x49\xd4\x25\x79\xc0\x1b\x7c\xff\x5c\x92\x16\xc1\x8e\x66\x0d\x0c\xb2\xcc\xe8\x3f\xb4\xbc\xa0\x19\x39\xc7\x12\x5f\xe8\x94\x96\x12\x73\x56\x8e\x57\x60\xce\xaa\x42\x15\xc9\x92\xe4\xed\xf7\xa2\xe9\xef\x51\x93\x6c\x3b\xed\x68\x8e\x33\x41\xea\x67\x25\x16\x82\x6e\x48\xf7\xf1\x31\x3a\xaa\x21\x05\x2b\x48\x21\xd1\x9c\x95\xe8\x82\x95\xd3\xea\x41\x4b\x33\xfc\xb2\xe6\x80\xc2\xd1\xec\x3e\xed\x34\xc1\x64\x96\xb1\xd9\x70\x25\xdb\x08\x8f\x6b\xb2\x26\xa1\xf3\x49\x8b\x42\xea\x65\xd1\x59\xc6\x66\x31\xe1\x1b\x9a\x90\x6e\xb6\x1d\x05\xa1\xdf\x16\xfd\xa1\xfe\x3b\x41\x4c\xe6\x09\x92\xe2\xf1\x59\xaf\xb8\x7d\x39\xdf\x4a\x3f\x90\x61\x92\xaf\xc7\xe5\x97\x12\x81\x62\x92\x62\x97\x76\x39\x2d\x00\xda\x29\x6e\x9f\x76\xad\xf4\x60\xd5\x41\xc9\x40\x37\xb4\x70\xaa\x87\x9f\xc4\xc9\x24\x7f\x04\x7c\x3a\x06\xc0\xfb\xf1\x74\x48\xc2\x55\xfb\x27\x71\x82\xf2\x47\x74\xf3\xc7\x89\x4b\xd3\x92\xd3\x42\x12\x3e\x5e\x53\x0b\xe0\xd3\x34\x2b\x79\x68\x2d\xed\x5b\xa0\x3b\x73\x75\x69\xfa\xc4\x78\xaa\xe7\x11\xe3\x75\xad\x21\x7c\xda\xf6\x89\x82\xe9\x5c\x0b\x42\x3f\xaa\x3b\xa7\xde\x64\x26\x58\xb2\x22\x12\xa0\x77\x05\xe1\xd5\xbb\x47\x54\xe9\xdd\x6a\x80\x5e\x47\xed\x4a\x0e\xfa\x51\xdd\x39\xdb\xdf\x0c\x27\x2b\x40\x03\xac\xd8\xbd\x2d\x70\x8b\x20\x58\x11\x6b\x21\x28\x56\xff\x5d\x3a\xd2\x62\x9e\xad\xb7\xe9\x6c\xbc\x9a\x15\x82\x4f\xd3\x1e\x4d\x30\x65\x2b\x39\xe8\x52\xdf\x9c\xcf\x5c\x2a\x67\xeb\x7c\x46\xf8\x03\xa8\x6c\x1b\x0c\x6f\xab\xd5\xa7\x0a\xa6\x78\x23\x09\x5d\xd7\xb7\xce\x3a\x2d\xf1\x16\x50\xa5\x25\xde\x7a\x6b\x74\x93\x1e\xae\x42\x4b\xbc\x45\xb1\x3c\xfd\xe9\x54\xef\x21\x17\x27\x00\xfd\x14\xbb\x57\xc1\x16\x41\x38\x0d\x95\x10\x14\xab\xff\x2e\x1d\xe7\x38\x21\x33\xc6\x00\xb5\xb7\x42\xf0\x4e\x3b\xba\x34\xe1\xe6\x1e\x56\x0e\xba\xb0\x37\x2e\x95\x53\xd5\x46\x03\x46\x18\x86\xdf\xa7\x6e\x87\x22\x98\xb2\x46\x0a\x3a\xd7\x17\xe7\xa8\xb1\x2c\x00\x83\x0b\xc5\xed\x1d\x2f\x36\xe9\xe1\x06\x8b\x65\x21\xd0\x69\x59\x38\x07\x12\x7a\xc0\x2a\x08\x44\x45\x8b\x70\x70\x58\xdc\xd0\x84\x1d\x17\x0b\x22\x50\x4c\xdc\x5f\xea\x03\xde\x02\x3a\x56\xc5\x6d\x13\x9d\xab\x1a\xad\xf4\xe3\xde\xbb\xd8\x10\xae\x46\xb8\x8a\x11\x5d\xe1\xed\xcc\xb9\x96\xf1\xb8\xc6\x5c\xbe\x8c\x7f\x6d\xc3\xef\x2b\x9f\x0e\x45\xb0\xd2\x31\x52\xd0\x1f\xfa\xb2\xa7\x32\x4e\xc4\xd3\x1c\x54\x17\x15\xc0\x81\xaa\xd8\x22\x09\x59\x13\x91\x78\x9a\xa3\xf8\xc7\x85\x4b\x53\xb2\x4c\x14\xdb\x78\x4d\x2d\x80\x4f\xd3\x2e\x49\x30\x4d\xad\x18\xf4\xd1\x5c\x9d\x63\x00\x35\x93\x5b\x4c\x9e\x00\xad\x4c\x0d\xe1\x1d\x0b\xf4\x88\x42\xcd\x56\x8c\x1c\xf4\x24\x50\xac\xef\xd4\x9c\x65\xff\xa2\x51\x81\x17\x94\x01\x54\x37\xfc\x3e\xbd\x3b\x14\xc1\x0a\xda\x48\x41\xb7\xfa\xe2\x5c\x3f\x62\xc5\x82\x41\x26\x2e\x16\xc0\xa7\x6a\x97\x24\xdc\x42\x92\x11\x83\x6e\xd4\xd5\x3d\x69\xd1\x7d\x1a\xc5\x39\xb0\xe7\xa4\x38\x3f\xd8\x73\x36\x34\x61\x7b\x4e\x8a\x73\x74\x79\x7a\xe3\xec\x39\x55\xbb\x49\x56\xb0\x71\x82\x02\x38\xd4\x36\x37\x24\x41\xdb\x66\xb2\x12\xe8\xe3\x97\xd8\xb9\x7a\xe6\xda\x44\x1a\xb1\x86\xd6\x86\xf1\x69\xed\x22\x0c\xb7\xa6\x66\x85\x21\x85\x8f\xee\xec\xaf\xcf\x52\x3a\xf7\x1a\x1e\x88\x94\xcf\x80\xf1\x92\x62\xf7\xa9\xde\x26\x08\xd5\x58\x6b\x19\xff\x83\xae\xd4\xa5\xa3\xe7\xff\xb4\x14\xcd\x5e\x00\xa3\x8e\xec\x65\xee\x1b\x15\x36\xc9\x03\xf7\xb9\xb2\x97\x39\xba\xfe\xcf\x85\x73\x4c\xa8\xdb\x05\xc9\x71\x21\x32\x2c\x21\xdb\x41\x1d\x9c\x83\x2d\x51\x9f\x32\x6c\x7b\x54\x4b\x43\xf7\xd5\x9d\xb3\x6d\xda\x00\x1a\xe1\x8d\xb7\xf9\xdd\x1c\xd9\xf0\x8e\xde\x90\xd9\xe4\xe8\x7b\xee\xd2\x29\xe1\xcf\xa5\x64\xe3\xf5\x32\xfc\x3e\xdd\x3a\x14\x03\x0a\xd2\x59\xc9\x3b\x60\x93\xa8\x5c\x94\xa3\xb2\xc3\xc0\xa0\x73\xba\xa0\x12\x67\x31\x5d\x14\x58\xae\xf9\x71\x1b\x7a\xd5\x64\xca\x62\x4c\xf5\xa5\xf7\xf1\x1c\xc7\x7a\xf7\xe9\xce\xf9\xd1\x25\x2c\x27\x32\x05\x94\x89\xe6\xf7\x96\x49\x9b\x62\xf0\xc6\xab\xe1\x0e\xde\x7f\x1a\x31\x68\xaa\x2f\xae\xba\x3b\x23\xb8\x98\x6c\x70\x46\x53\x2c\x19\x60\x91\xa8\x8b\xe3\xcb\x37\x27\x65\xb0\x0c\x50\xd2\x50\x2d\x0d\x9d\x11\x5c\x7c\xaf\x7e\xb9\xf2\x03\x36\x90\x38\x34\x7e\x18\x37\x6c\x68\x78\x47\xd4\x17\x97\x75\xcb\x31\xb6\x2d\x8e\x85\xcf\x61\x56\x20\x4d\x19\xe8\xf1\xcb\xbe\x71\x8b\xa4\x2b\xc0\x4e\xb6\xe2\xf6\x65\x78\x2b\x3d\x58\x15\x53\x32\xd0\x3d\x5d\x39\x77\xb2\x13\x3c\x9f\x13\x5a\x00\xba\xfd\x0a\xc1\xdb\x16\x59\x9a\xc9\xc8\x65\x84\x1e\x4a\xc6\x70\xfa\x26\x0b\x12\x95\x44\x64\xd6\x25\xa6\xf6\xe7\x74\x77\x75\xe2\x58\x20\xf5\xea\x35\xce\x35\xc3\xa9\x03\xcb\x8e\x26\x08\x97\x80\xdd\x1c\xcd\xee\x1d\x8f\xb4\x08\x82\x65\xa0\x16\x82\xbe\xab\xff\xce\x49\x81\xc8\x00\xdb\xce\x8a\xdb\x3b\x25\x68\xd2\x83\x29\xa8\x64\xa0\x2b\x91\x39\xf7\x98\x59\x49\x0a\x21\x41\x7b\x91\x35\x84\x4f\xd1\x9a\x68\x92\xd0\x22\x1d\xb3\xd3\xd1\xc7\x59\x64\xb8\x48\x46\x7f\xa8\x0d\xce\x8a\x3c\x0b\xc9\x8a\x57\x40\x2a\xc8\x5a\x36\x46\xa1\x10\x20\xb6\x19\xd1\xe4\xf6\x51\xc4\x13\x9d\x07\xaf\x5c\xb5\x38\x64\xca\x15\x4d\xf5\x65\x50\xcb\xd3\x60\x98\x32\x45\x9f\xf4\x65\x24\x46\x55\x9e\xe8\x8b\xbd\x19\x89\x63\x4b\x13\xdd\x9a\xeb\x58\x14\xb6\xc1\xe8\x96\x6d\xf0\x48\x7e\x5d\x88\x28\x56\xff\x5d\x9f\xef\x82\xb1\x45\xa6\xfa\xac\x8c\x14\x29\x06\x0c\x3e\x7b\x40\xbe\x4f\xd9\x4d\x3a\xb8\xa2\xf6\x60\x26\x42\x72\x12\x7e\xe5\xcf\x48\x45\x95\x54\xf4\x49\xff\x9e\xda\x9f\x83\x0a\xa9\x0f\x65\x14\xe8\x21\xc6\xfa\xa1\x73\xda\xc0\xd9\x93\x00\x0c\x6a\x0c\xbf\x77\x9a\xd0\xa6\x08\x35\xa5\x37\x42\xd0\x99\xbe\x38\xcd\x5d\x52\x0a\x59\x6d\x4a\xa9\x77\x83\xab\x95\x1e\xce\xb8\x25\xa5\x73\x74\x9d\xd2\xb9\xe7\x0b\x14\x4b\x42\x24\x60\xbd\xb8\x03\x73\xc4\xd7\xd7\x21\x1c\xfb\xed\x19\x90\xb7\xfd\xf2\x8c\x4c\xfb\x95\xc4\xfa\xc7\x98\xaf\xce\xc2\x74\xbe\x39\x83\xb6\xff\x8b\x13\xb8\x9c\x14\x44\x3e\x11\xbc\x81\x18\x73\x74\x60\x7c\x45\xe5\x22\x0c\x67\xb4\x83\x4b\x54\x0b\x43\xb7\x44\xfe\xd0\x77\xce\x2a\x8b\x8b\x45\x46\x01\x53\x46\x0b\xe0\xad\xa6\x1d\x92\x70\x95\xca\x88\x41\x9f\xcc\xd5\x59\xea\xea\xf5\xb0\x6c\x9d\x0a\x1a\x51\xe4\x35\x86\xb7\xbc\xfb\x54\xe1\x0a\xbb\x96\x84\xe2\xfa\xd6\xa5\xfc\x33\xce\x73\x48\x5d\x37\xfc\x3e\xa5\x3b\x14\xc1\x14\x36\x52\xd0\xbf\xf5\xc5\x69\xa1\x45\x39\x49\x00\x13\x35\xc3\xef\x53\xb4\x43\x11\xaa\x37\x35\x42\xd0\xb9\xbe\x38\x17\x43\x96\xeb\x02\x30\x57\xd3\xec\x3e\x2d\xdb\x04\xe1\xd6\x2c\x94\x10\x34\x55\xff\xdd\xe6\xde\x90\xf5\x2c\xc5\xed\xd3\xb0\x95\x1e\xce\xae\x9d\xac\x30\xfa\x41\xdc\xeb\x59\x0f\x38\x59\x09\x56\x6c\xf3\x0c\x62\x9b\x55\x61\x58\x92\x3d\x16\x5a\x3d\xaa\x81\x0b\x07\x35\x3b\xba\x32\xb7\x3f\x6f\xae\x9d\x5b\x05\xd6\x14\x65\x86\x65\xb2\x04\x5b\xbd\x68\x14\x6f\x3b\xbb\x4b\x17\xae\xa5\x35\xc6\x2f\x5a\x96\xb5\x7f\x39\x53\xf7\x6e\xdb\xe6\x35\xc0\x1c\x44\x71\x7b\xb5\x6e\xd2\x83\x9d\x97\x92\xeb\x19\x8a\xe5\xda\x69\x01\x92\x72\x9a\x01\x6a\xac\x66\xf7\xb6\xaf\x2d\x82\x70\x06\xb0\x4a\x08\x3a\x57\xff\x5d\x3a\xbe\x30\xb6\x22\xa4\x84\xf4\x98\x35\x84\x4f\xd7\x3e\x51\x30\x7d\x6b\x41\xe8\x3f\x8c\x7d\xd1\x77\xfb\xcc\x5d\x92\x27\x98\xb5\x4b\xf2\xe4\xd3\xb8\x43\x11\xd4\xd6\x25\x79\x42\xd3\x27\x97\x92\x5b\x33\x59\x18\xaf\xe5\xb6\x33\x51\x72\xb7\xb8\x82\x15\x3d\xba\x49\xd4\xfd\x3d\xd0\x2c\xc2\x32\xa3\x2b\xc1\x8a\x63\xb6\x77\x1d\xac\x3f\xcd\x94\xc8\xd9\x72\x3f\x11\x2c\x97\x90\xfa\x6e\x01\xfc\x3d\x6e\x9b\x24\x60\xa7\xab\xc5\xa0\x1f\xe6\xea\x3e\xba\x20\xa4\x2a\xa2\xf1\xea\x56\x08\x07\x2b\x41\x8f\x70\xe8\xa1\x04\xc3\x8c\x2e\xec\x8d\xb3\xec\xca\x14\xb0\xb0\x52\xa6\xde\x75\x95\x26\x39\x9c\x71\x56\x3a\x47\x77\xa9\x73\x51\xc5\xf6\xf0\xb4\x90\x64\xc1\xb5\xef\x0a\xf0\xa8\xa2\x85\x75\xc4\xd8\x62\x97\x3a\xf4\x08\xa3\x25\xd1\x8e\x33\x2e\x9b\x27\x4e\xc3\x3d\xbc\x04\x18\xcc\x28\x6e\x6f\xf9\x37\xe9\xe1\x2a\x00\x5e\x32\x74\x87\x97\xcc\x69\x47\x0c\x33\xc6\x2b\x0e\x19\xe3\x15\x0e\x63\xbc\xd7\x37\x22\x56\x42\xd0\xad\xfa\xef\x34\x21\x5e\x0b\x09\x33\x8c\xaf\x10\x7c\x9a\xf6\x68\xc2\x59\x11\x5b\x39\xe8\xc6\xde\x38\xbf\x6c\x0a\xb0\x0d\x11\xd4\x6b\x1a\xd2\x24\x0f\x5e\x10\x15\x74\x8c\x61\xc8\xc0\x0f\x9d\x96\x28\xa6\x4e\x0b\x8e\xe5\x0c\x43\xb6\x02\x34\xbb\x2f\x67\xda\x04\xc1\xf4\xd3\x42\xd0\xe7\x33\xec\xde\x07\xb0\xb3\x49\xf0\x9c\xf7\x60\xcf\xdb\xa5\x1b\x35\xe5\xad\xe6\xbb\xce\x6e\x77\x85\xe7\x90\xf5\x09\xcd\xee\x2b\xac\x36\x41\xb0\xc2\xd2\x42\xd0\x17\xf5\xdf\x69\x52\xf4\x44\x25\xc8\xa7\x82\x05\xf0\xe9\x69\x49\xec\xd2\x5b\x4e\x84\xc0\x8b\xd1\xbb\xf0\x15\x98\x20\x98\x8f\x59\x15\xe8\xa2\x48\x9a\x93\x8c\x8e\xb1\x09\x18\x68\xf7\x64\xe4\xa1\x4e\x16\xa0\x7b\xf3\xd4\x2c\x02\xde\x98\x87\x83\xf6\x48\x2a\x58\x93\x19\x15\x5e\xac\x7f\x8d\x02\xaa\xf2\xa3\x82\xba\xb7\xbf\xdd\xbb\x2c\x19\x11\x73\xc6\x13\x40\x83\xd6\x60\x78\xdb\xfb\x3e\x55\xc0\xcd\x95\x4a\x12\x8a\xeb\x5b\xe7\x1c\xf3\x01\x30\xbd\x7c\xf0\x29\x5b\xa7\x06\x53\x72\xfb\x80\x7e\x5e\xed\x3d\xfb\x03\x3d\x0d\x73\x72\xc4\x71\x98\x93\x37\x3a\x0f\x73\x52\x1d\x88\x71\xda\xd7\xdb\xc3\x6d\x05\x03\x2c\x88\x34\x18\xde\x0a\xdc\xa7\x0a\x57\x81\x6b\x49\xc8\x3a\x7c\xba\x65\xce\x45\x12\x9a\x60\xc0\x22\x9f\xe2\xf6\xf5\xcf\xad\xf4\x81\x8e\x35\x12\x9c\xa1\xcb\x29\xce\xf6\x58\xaa\x73\x88\xa7\x2a\xcd\xee\x2b\xa7\x36\x41\x40\x3b\x73\x9e\x62\x34\x55\xff\x9d\x9b\xb6\x1c\x97\x80\x16\x55\xb3\xfb\x74\x6c\x13\x84\xdb\xae\x55\x42\xd0\x27\xf5\xdf\xa5\xe3\xba\xa0\x1b\x96\x50\xf9\x3c\x29\x31\x17\x84\x03\x5a\x9c\x1d\x28\x5f\xb5\x6c\x88\x13\xb1\x71\x3c\x9d\xd3\x2d\x49\x1d\xcf\x65\x4d\x3d\x70\x51\xaf\x86\x40\xff\x2a\xe8\x77\x7d\x37\x15\x9b\x81\xcb\x7b\x0e\x90\x0b\xf5\xa2\x3f\x68\x2a\x97\x70\xac\xfb\x9d\x17\xb2\x93\x8d\x74\x0e\x28\x17\xc5\xed\x9d\xa9\x34\xe9\xe1\x26\x2a\xe9\x5c\xa0\xcf\xe9\xdc\x79\xac\xf7\x21\xc9\xd8\x3a\x05\x68\x68\x01\x7c\x4a\x76\x49\xc2\x19\xfe\x1a\x31\xe8\xca\x5c\x5d\xda\x3e\xae\x69\xb2\x9a\x53\x80\x11\x77\x85\xe0\xd3\xb7\x47\x13\xd0\xe5\x82\x91\xf3\x80\xfe\xa8\xee\x9c\x4b\x4b\x02\xe0\x16\xaf\x10\x5e\x97\x78\x4d\x72\xb8\x45\x25\xf1\x88\x6e\xc5\xa3\x73\x1d\x81\x96\xc9\x12\x03\xcc\x20\x2c\x80\xf7\x0b\xed\x90\x84\xfb\x48\x8d\x18\xf4\xd9\x5c\x9d\xda\xe2\x17\x92\x25\x58\x40\xf4\xad\x20\xbc\x1a\x57\x44\x13\x2c\x59\x4e\x93\x0d\xce\xc6\xf8\xfa\xec\x83\xd1\x42\x48\x88\x09\x7b\x83\x94\x51\x31\xa2\x3c\xfa\x28\x39\x1e\x7f\xb0\xaa\x01\x59\x67\x92\xbe\x0a\xd2\x48\x8f\xaa\x7d\x18\x4e\x8c\xff\x6b\x92\xbe\xca\x5b\x71\x5a\x2c\x66\xeb\xf9\x7c\xfc\x09\x86\x06\xeb\x78\x0f\xa8\x7e\x94\x57\x28\x7b\xc9\x4a\x9a\x04\xff\xa4\x2b\x71\xc8\x7c\x47\x85\xf6\x14\x87\x3e\x57\x8f\x4f\x5b\x4f\x07\x2d\x53\x34\xc0\xd5\x37\xd5\x80\x5e\xda\x27\x23\x01\xd5\xa7\xd5\x80\x5d\x53\x21\x47\x02\xe5\xb8\x6c\x70\x6e\x70\x39\x16\xc6\x7e\x5f\x2d\x2c\xfb\x64\x24\xa0\x71\x05\x5c\xa3\x69\x9f\xc0\x23\xa1\x3a\x9f\x5a\x03\xf9\xad\xfd\x78\x2c\x74\xfd\xd9\xb5\x70\xeb\x67\x23\x41\xb5\x7b\xe0\x1a\x6e\xd7\x4f\xf0\x00\x20\xd9\xc6\x19\x5b\x45\xf4\x47\xd8\x00\xdd\xab\x9f\xce\x93\x03\x98\x27\x2c\x85\x1c\x1d\x30\x00\xbe\x29\x51\x97\x64\xe0\xf4\xc6\x32\xa3\x33\x73\xdd\xe7\xd2\xe1\x95\x3c\x3a\x1c\xed\xd0\xe1\x4d\xfd\x39\xb8\xdc\x39\x38\x17\xd7\x64\x0e\x71\x97\xa4\xd9\xbd\x7a\xb7\x08\xc2\xe9\xab\x84\xa0\x53\xf5\xdf\x79\x04\xc4\x86\x31\x19\xaf\x66\x85\xe0\xd3\xb4\x47\x13\xca\x48\xae\x12\x83\xae\xed\xcd\x1e\xb7\xb6\xb4\xa0\xa2\xc4\x80\xfd\xae\x06\xc3\xa7\xf5\x0e\x55\x48\xe7\xb6\x56\x12\xba\xac\x6f\xf7\xae\x17\xa7\x10\xd7\x58\x15\xc2\x81\x0f\xba\x4d\x33\xdc\x6f\xbf\xe5\x7f\x9b\xd3\x2f\x7a\xd5\x39\x4d\x67\xe8\x3c\x9d\x9d\x0c\xf3\xd8\x6f\x39\xad\x31\x97\xe2\xdf\x7f\xc4\xc5\x1e\xec\x29\xd7\x33\x01\xb1\x45\xed\xc0\xf8\x0a\xc1\x45\x18\xfa\x04\x91\x11\x66\xcf\xfc\xdc\xe9\x1f\xee\x5e\x52\x90\x7f\xfe\x1d\xd2\x49\x2a\x7e\x7f\x1f\xd9\xa2\x18\xdc\x45\x2a\x5e\x74\xa6\x2f\xce\x0e\x32\x5b\x27\x04\xe2\xf4\xc0\xf0\x7b\x1b\xcc\x36\x45\x40\xd7\xd0\x4a\x0a\xba\xd6\x97\x7d\xfe\x53\x00\xc5\x44\xfc\xed\x63\x2b\xfd\xf8\x1e\xc1\x2e\xfb\x67\xf8\x58\x17\xf8\x2d\xde\xaa\x7f\x68\x57\x94\xe6\x1d\x46\xb8\x5e\x39\x23\xfd\x66\xf6\x08\x2e\xfd\xee\x48\xc7\x86\x3a\x82\xb7\xee\xd3\x6a\x81\xd7\xed\xce\xd4\xee\x69\x01\xcd\x67\x3b\x0d\xed\x1e\x13\xf7\xb7\x68\x8a\x6d\x43\xea\x39\x27\xc8\x32\xc8\xf1\x40\x96\xf9\x4f\x05\x36\xe9\xc3\xcd\x94\x58\xc6\x47\x1f\xfa\x54\xcc\xd3\x8c\xad\x47\x38\x5c\x1a\x98\xc1\x2c\xe3\x28\x56\xd2\x5c\x63\x41\xb6\x00\xb4\x69\x6c\xe1\x6d\xd0\xea\xe4\x60\x83\x3f\xb6\x40\xd7\x6c\xe1\x1c\xf2\x91\xe4\x9f\xbf\xfc\xdf\xdf\x7e\x01\x0c\xf8\x2c\x82\x77\xb8\x67\x69\x26\x49\x46\x9b\x4f\x7a\x70\x5d\xa8\x61\x04\xe1\x6f\x70\x38\xb5\x12\x87\xcc\x5b\xa3\xa9\xbe\x0c\x6a\xd4\x6a\x08\xf3\xc6\x7a\x1b\x7b\xcf\x61\x06\x35\x0d\x29\x97\x84\x93\xd7\x08\x1c\xe2\x42\x3b\x38\xdf\x72\xd3\x87\xf2\xf9\xd8\x88\x3c\x36\xb2\x48\x4a\x66\xe4\x85\xae\x73\xb8\x13\xdb\x3e\x92\x2f\x6b\xf6\xd0\x86\x3b\xec\x63\xe5\xa1\x73\x7b\x73\x63\xe4\x7a\x2c\xce\xb3\x14\x43\xec\x53\x1b\x10\x6f\x0f\xb0\x43\x16\xd8\xb8\x5c\x49\xb2\x46\xe5\xd7\x69\x7f\x0d\xce\x96\x23\xc4\xef\x7f\xea\x77\xfb\x9f\x86\xf7\xfa\x9f\x16\x02\x9d\xfb\x7c\xfe\x3f\x42\xad\x97\xc4\xe3\x11\x3e\xff\x1f\xdf\xc8\xe7\xff\xa3\x40\xf1\xa3\xdb\xe7\x3f\x27\x38\x91\x74\x43\xec\x70\x0b\xa0\x76\x1f\xc9\xa7\xfe\x1e\xda\x60\xd9\x50\xc9\xb3\x83\x39\x81\xbe\xd9\x07\x66\x54\xe7\xac\x08\x0b\x8e\xcb\xe5\x23\xc0\xba\xc9\x02\xf8\xf2\xa1\x4b\x12\xd4\x8e\x66\xf9\x98\x69\x4b\x9a\xe5\xa3\xf3\x28\x63\xc2\x20\x2d\x99\xe2\xf6\xe9\xd9\x4a\x1f\xe1\xb7\x13\x8f\x31\xb6\x6f\x98\xff\x8f\x4c\x60\xc2\xc7\x01\x1c\x57\x44\xb8\x44\x53\x76\x7a\xe7\x6c\x63\xb1\xc4\x02\x32\x16\xb1\x00\xde\xb6\xb6\x43\x32\x74\xc6\x6b\xb9\x27\x92\x8c\xd9\x50\x1e\xd8\x64\x1b\x59\xe8\x1c\x4b\x3c\x74\xcf\xa4\xc7\x7b\x4f\xfa\xdb\x72\x26\xbf\x48\xf6\x0c\xf3\xfb\x61\x01\x7c\x19\xde\x25\x09\x17\x77\xc2\x88\x41\x1f\xcd\xd5\xed\xa9\x90\x15\xb8\xa4\x00\xcb\x25\x03\x60\xd3\xf7\x1e\xb0\x38\xad\x49\x86\xfa\x21\xd4\xf0\xfa\x24\xeb\x69\x49\x9d\x8b\x5e\x2f\xa4\x48\x89\x00\x38\xb8\xb0\x00\xbe\x12\xeb\x92\x84\x3b\x7a\x6d\xc4\xa0\xff\x98\xab\xb3\xc4\xd2\x59\x02\x28\xae\x74\x96\xf8\xf4\x6c\xa5\x87\x33\x31\x4b\x67\x09\xba\x4a\x67\xce\x7d\x4a\x51\x62\x0e\x89\x5f\xa8\xd8\xfd\xe3\xe8\x86\x20\xe0\x08\x1a\xf3\x15\x8a\xd5\x7f\xe7\xe8\x72\x09\x28\x41\xbc\xf4\x16\x60\x93\x1c\x6c\xe6\xb8\x4c\xd0\xe9\xd2\x59\x78\x09\x2b\x24\x67\xd9\x6c\x0d\x18\x41\x36\x18\xfe\xb1\x44\x8f\x2a\xd4\xe2\x4d\x23\x08\x4d\xcd\xed\xd9\xda\x39\x52\x4c\xa9\xe0\xeb\x12\xe4\xcc\xbb\x86\xf0\x76\xd6\x3d\xa2\xc1\xa3\x99\x1a\x60\x72\xac\xeb\x7e\x40\x7f\x5d\xc9\x42\xe7\xd5\xdd\xb0\x3e\xbb\xe6\xdf\xe4\x0d\x84\x3b\x1c\x40\xca\x5e\x60\xe1\xf6\x5e\x0e\x45\xdb\x7b\x79\x8b\x60\x7b\x2f\x3a\xd6\xde\x8b\x7b\x99\x6a\x46\x70\x41\x01\x27\xb8\x0d\xbf\xaf\xb3\xee\x50\x0c\xdd\x9f\xd2\xbc\x7a\x2b\xe0\xf2\xab\xb3\xab\x9e\xd1\x22\x05\x1c\xd0\xd6\xec\xde\xb7\x57\x04\x1d\x83\x7c\xf3\xa4\x6b\x8c\x6f\x9e\xad\x36\x43\x02\x30\xb4\xd5\x54\xec\x28\x11\x1b\x74\xa6\xee\x86\x1b\xe1\x1b\x00\xfd\x4e\x06\x42\x9b\xe0\x5f\x93\x62\x31\xd8\x06\xdf\x40\xad\x36\xa5\x01\xfa\x42\x9e\xbf\xe3\x6c\x4d\xee\x30\xe5\xce\x02\x58\xac\xf1\x06\x4f\xc8\x86\x14\x12\xd4\x4a\x77\x71\x7c\x9f\x8d\x93\x32\xdc\x24\x57\x49\x43\x95\x34\xf4\x49\xfd\xfc\xa8\x7e\xed\x69\xb5\x73\xb1\x19\x9f\x09\x79\x5d\xcf\xdc\x67\xe8\xeb\xe4\x70\x7e\xc8\xeb\x08\x0b\xb9\xd8\xa0\x1b\xb1\x71\x8e\x18\x21\x0b\x3a\x0f\xfe\x35\x9c\x87\xf0\xcb\x36\x0f\xb9\x40\x57\xee\xd5\x99\x39\xcd\xc8\xe4\x09\xe6\x40\xac\xc1\xf0\xe9\xb9\x43\x15\x2e\xb6\x2c\xcd\x08\xd2\x92\xd0\x05\xcd\xc8\x8f\x7d\x8e\xc3\x74\x94\x46\xa0\xbd\x8c\x02\xf0\x0e\x26\x3b\x24\x61\x23\x41\xa6\x33\x14\xbb\x97\xd9\x55\x8e\xc0\xca\xf7\x50\xc9\xbe\x49\x99\xaa\xd2\x74\x9b\xdf\x70\x88\x5b\x55\xc6\xfd\x3e\x55\x9b\xf4\x80\x36\x36\x1c\xa3\x4f\x8c\xbb\x3d\x17\xe6\x80\x83\x42\x0f\xb9\xf7\x8c\x50\x93\x1c\xb0\xf5\xd9\xa2\xab\x1b\x67\xdc\x6e\x49\x41\x6e\x52\x35\xbb\x4f\xbb\x36\x41\xc0\x28\x2a\x39\xe1\xe8\x9e\xee\x71\x91\xfa\x00\x0c\xc2\xfa\x70\x30\x06\xeb\xc3\x9b\x44\x3c\x31\x52\xd0\xd5\xde\xb0\x24\x73\x4e\x48\x8e\x39\x28\x62\x77\x83\xe1\x6d\x70\xfa\x54\xe1\x9a\x9d\x5a\x12\xba\xa8\x6f\x9d\x66\x08\x9c\x15\x39\xe0\x7c\x9b\xe1\xf7\x29\xdd\xa1\x08\x67\x32\xa0\xa5\xa0\x4b\xce\x8a\x9b\x3f\x9c\xa5\xbc\xa4\x90\xf2\x5d\x52\x7f\xc9\x36\xe9\xd0\x60\x71\x0a\xea\xaa\x71\x48\x63\x1e\xfc\x1c\xe9\x93\x55\xf1\xa2\x8b\x25\x1d\x36\xf7\xae\xb9\x8e\xf5\x22\xe8\x60\xfd\x99\xbb\x0f\xdf\x0b\xbc\x05\xb9\x67\x53\xec\xbe\x92\xd8\x3e\xae\x09\x1f\xe1\xa9\xcb\x61\x87\xd7\x81\x1a\xe8\x1c\x43\xb3\xa2\x9f\x7f\xa8\xcb\x10\x8b\xba\x0e\xa3\xc3\xaa\x8e\x13\x21\x75\x08\x1d\xd0\xd2\x7d\x1b\xc5\x97\x99\x0e\xba\x80\x7b\xb4\xc2\x44\x32\xc1\x25\x45\xdf\x88\x90\x5f\x4b\x52\x9c\x96\x74\xdf\xde\x45\x89\x25\x60\xec\x5f\x21\xec\x2f\xfd\x1e\xc5\x31\xca\x54\x2c\x7a\xcf\xe2\x0e\xcb\xa5\xcb\x2c\xb2\xc4\x7c\xa5\x0b\x00\xb8\xd4\xad\x31\x7c\x85\xb7\x43\x15\x6a\x59\x58\x0b\xd2\xc5\xb7\x77\xdd\xfb\x41\xfe\xfd\x17\x80\xa9\x9b\x66\xf7\x0e\x25\x5a\x04\xe1\x46\x12\x4a\x08\xba\x52\xff\x9d\xa6\x14\x78\x36\xa3\x12\xd2\x99\x56\x08\xde\x4f\xb2\x4b\x13\xee\x73\xb4\x72\xd0\x37\x7d\xe3\xee\x54\x1f\x66\x25\xc0\xc2\x57\x71\x7b\x0b\xb5\x49\x0f\x57\xa6\xb3\x32\x47\x57\x67\x77\x37\x4e\xf5\x68\x01\xb0\x3e\x55\xdc\x5e\xf5\x9a\xf4\x37\x58\x25\x52\xd2\xd0\x15\x2d\x9c\xc6\xa8\x6a\xb6\x0f\x8d\xd6\x7e\x44\xb0\xf6\x37\x8a\xd5\x5e\x85\x6a\x77\x6e\x32\x16\x39\xc4\x62\xaf\xc8\xfd\xa6\x7a\x4d\x7a\xb8\x1d\xc6\x22\x2f\x51\x5c\xe4\x4e\xbb\xbc\x27\x32\xfb\x00\xf0\x29\xa6\xd9\x7d\x0a\xb6\x09\x02\x7a\x66\x9e\x7d\x78\x40\x3f\xd4\x7f\xb7\xc1\x2e\x83\xd4\x54\xc9\xfc\xd5\xb4\x49\x0f\x78\xfe\x91\xe5\xe8\x54\x32\xe7\x66\x96\xc4\x0b\xc1\xd6\x80\x4a\x6a\x01\x7c\x73\x0c\x49\xd3\xe7\x1b\xcc\x57\xeb\x91\xfb\x20\x56\x04\xba\xaf\x71\x9c\x63\x7d\x22\x13\x40\x40\x68\xc5\xed\x2b\x29\x95\xae\xc3\x31\x0e\x2f\xae\x16\x80\x90\x78\x7c\x60\x2c\x8d\xf0\x26\x6b\xc3\x4a\x12\xfa\x28\x93\xf4\x0b\x79\x1e\x16\x01\xab\xe6\x8c\x95\xa6\xe3\x58\xf7\x2e\x45\xcf\x21\xb1\x9b\xe7\xfe\xd0\xcd\xf3\xf1\x91\x9b\xe7\xa3\x02\x37\xdb\x36\x7c\x94\xdc\x11\xab\xc2\x9c\xe4\x4c\x12\x74\xd1\x8f\xd2\x3c\x8c\x77\x58\x89\xb6\x99\xe3\xb9\x3b\x3e\xb4\x5e\xfa\x27\x30\x03\x68\x05\x70\x68\x30\xd0\x90\x84\xdd\x5e\x20\x02\xc5\xc4\xed\xbc\x4b\xeb\x06\xd9\x22\x33\x00\xde\x51\x5e\x87\x24\xdc\x38\xd6\x88\x41\x57\x9f\xf4\xd5\xb9\xe1\x89\x05\xc8\x47\xaf\xe1\xf7\xe9\xda\xa1\x08\xe7\x38\x5c\x4b\x41\x37\xfa\xe2\xb4\xe3\xdc\x90\x42\xe2\x34\xa7\x10\x53\xce\x1a\xc3\xdb\x05\xf5\xa9\xc2\xb5\xff\xb5\x24\xa4\x37\xb5\x4f\xd5\xad\x3b\x42\xb3\xc4\x65\x86\x8b\x02\x52\xd4\x2d\x10\x9f\xfa\xbb\x64\x01\x03\x07\xd7\xa2\xd0\xd7\x52\xe2\x3b\x73\xef\x6c\xbf\xf2\x47\x40\xa7\xa4\xb8\xbd\x2d\x57\x93\x1e\xae\xd9\xca\x1f\x4b\x74\x7a\xf3\x87\xd3\x2c\xdc\x1c\x1d\x81\x9c\xbf\xa9\x10\x0e\x34\xd0\x6d\x9a\xc0\x07\x54\x0a\x81\xe2\xc2\x7d\x40\x65\x41\xe5\x12\xe4\x9b\x40\xf3\xfb\x54\xed\x50\x84\xdb\x29\xd5\x52\xd0\x27\x2a\x3f\xbb\x1d\x10\x68\x27\x57\x80\x0d\x53\xc3\x7f\x68\x6a\x43\xb7\x10\xc7\x6d\x15\x82\x76\x32\x3e\x6a\xf9\xa2\x8b\x03\xf4\xfe\x66\x61\x40\xae\xdf\x2c\x06\xc0\x2d\x9a\x45\x18\xe9\xe6\x6f\xf8\xcc\x91\x6e\xab\x73\xb1\x39\x2e\xf5\x34\x92\x6e\x87\x7a\x08\xeb\xe1\x54\xe5\x59\xa1\x55\xbf\x21\x98\x95\xe7\x31\x0b\xa9\x7e\xc2\xde\xd2\xb8\x1e\x33\x70\xc3\xfd\x8e\x75\xb1\x04\x91\x16\x69\xe8\x59\x92\x2e\x8e\x2e\x74\x8b\xa4\xcd\xef\x9c\xa6\x9b\x0c\xf0\x59\xcf\x98\xf7\x9b\x6e\x92\x83\xd5\xb9\x19\xdb\xa2\x33\xb6\x75\xae\xa6\x41\xce\xc7\x09\xff\xd9\x38\x31\xe6\x5c\x5c\xcd\x3a\x11\x92\x71\x12\xde\x77\xc1\x63\x86\xe2\xfe\x89\xba\x23\x78\xcc\xdb\x29\xd6\x58\xdf\x39\xe7\xd6\x19\x96\x25\x4e\x00\x47\x22\x2a\x04\x5f\x36\xf7\x68\xc0\xbb\xd7\x5d\xb8\x81\xd3\x62\xcb\x8c\x2e\xec\xcd\x11\xf9\xda\x5a\x95\xda\x61\x77\xdb\xc1\x52\xc0\xce\xdb\x82\x7a\xb7\xdc\x9a\xe4\x90\xe3\x08\x35\x88\x70\x07\xfb\xc5\x52\x24\x9c\x96\x00\x05\x1b\x0c\x9f\x9e\x3b\x54\xe1\xdc\xdc\xd7\x92\xd0\x74\x89\x65\xac\x6f\x9d\xcb\xa6\x24\x23\x0b\x0e\xd9\xc3\xa8\x10\x7c\x8a\xf7\x68\xc2\xd9\x66\x59\x39\xe8\xde\xde\x38\x47\x8c\xa2\xf8\x15\x30\x5e\x14\xc5\xaf\xbe\x2f\xb9\x95\x3e\x70\x75\x58\x71\xa2\xd3\xf8\xf6\x57\xe7\xf7\x57\x50\xc9\x29\xc4\x87\xa3\x05\xf0\x15\x53\x97\x24\x9c\x6b\x6d\x23\x06\xdd\x9a\xeb\xde\xc5\x34\xe0\x64\xed\x88\xb9\xda\x1b\x4d\xd5\xaa\x99\x9a\x53\xd3\x0d\x07\x1c\x4f\x51\xdc\x5e\x1d\x9b\x74\x68\x17\xd5\x82\x1a\x98\x01\x1b\xce\xd0\xe9\x86\xb3\x61\xdd\x52\xcd\xe6\xfc\x1c\xf2\x2c\x03\xac\x56\x28\x6e\x5f\xb6\xb5\xd2\xc3\xad\xc7\x65\x59\x89\x6e\xb2\xcc\xb9\x98\x5c\x2e\x6a\x97\xda\x94\x15\x13\x91\x31\x40\xe7\xe4\x00\xf3\x29\xbf\x9f\x3c\x5c\x8c\xca\x05\x6a\x89\x44\x4a\x24\xba\x5b\x7c\x6b\x1e\xc5\x19\xdb\x73\xf6\x1c\x34\x96\xd6\xec\xbe\xbc\x68\x13\x04\x3c\x75\xae\xc6\xb6\x1f\xd5\xff\x7d\x6d\x61\x0e\x39\xad\x6d\x01\x0e\xb5\x85\x79\xf8\xd3\xda\xaa\x2d\xcc\xc5\x0a\xdd\xc4\x5f\x9c\xf3\x22\xc9\x69\xb1\x90\x24\x2f\x61\xee\x8a\xbb\x38\xde\xd9\x92\xa6\x9c\xf4\x48\x43\x3a\xc5\x6b\xbd\x18\x8a\xf5\xcf\x7b\xfb\xd3\xef\x42\xea\x19\x54\xd1\xbb\x38\xbe\x1c\x71\x52\xbe\xa1\xf3\xa8\xe7\x9d\x79\xa1\x2d\x53\xc2\x37\x19\xc4\xad\x87\x05\xf0\xd6\x86\x0e\x49\x30\xbb\x3f\x23\x45\xfb\x56\xcb\xdc\x9e\xc3\xac\xef\x2a\x4e\x52\x0a\x18\x03\xb5\x51\xbc\x6a\xef\xd2\x05\x34\x57\x4d\xa9\x40\xdf\xd4\x7f\xb7\x53\x48\xce\xd6\x02\x60\xa0\x6a\x01\xbc\xea\x76\x48\x02\xfa\x67\xd4\x62\x66\x4c\xb6\x1e\xc6\xe6\xe1\x99\xbb\x37\x7b\x10\x90\x73\x79\x8a\xdb\xab\x77\x38\x77\x3c\xb5\xce\x49\x89\xe2\xc4\x39\xa2\x59\xad\x67\x84\x17\x44\x42\x76\xc8\x1b\x0c\x9f\x9e\x0d\xd5\x24\x61\xc5\x9c\x2e\x26\x39\xc0\x15\x52\x0b\x2d\x25\x65\xc6\x9e\x73\x52\x8c\xb7\x7c\x69\xa1\x2d\xcb\xd1\x61\x49\x5a\x28\x0f\x6c\xb4\x6b\xee\x16\x4a\x81\x73\x22\x4a\x9c\x8c\x31\x2d\xd8\x05\x63\xe9\xab\xe0\x94\x84\x0b\x2a\x24\x29\xe4\x64\xc3\xb2\x75\x1e\x08\x74\x92\x64\x98\x8e\x39\x94\xbb\x8b\xcd\xc6\x44\x1b\xdb\x81\x69\x0f\xbe\xad\x33\x8d\x8c\x8c\x77\x48\xdb\x41\x16\x6c\xcd\x13\x22\x26\x8f\x6b\x26\x5f\xa3\xfa\x09\x92\x70\xf2\x2a\x9f\x83\x8d\x9d\x39\xc1\x49\xc2\xd6\xaf\xf3\x85\x59\xc8\xd1\x50\xac\x24\x85\x58\xd2\xb9\x9c\xcc\xd6\x34\x4b\x6d\x6b\xf2\x5a\x70\xc1\xbb\xda\x26\x27\x90\x79\xf3\x3f\x55\x3b\x88\xbe\xd4\x8f\xa7\xfa\xe9\x0d\x1e\x68\x0c\xd5\xc2\x6d\xb5\x88\x2d\xdc\xf3\xe6\xe9\x58\xe0\x65\x89\x5b\x80\x9f\xef\x4e\xc7\x02\x3d\xb0\x59\x0b\xe8\x8a\xcd\xc6\x02\x35\x4d\x64\x0b\xef\xb6\x7e\x38\x1a\x56\x35\x96\x6d\x44\xf5\x7b\x2c\x58\xd3\xb8\xfd\x69\x1b\xb7\x16\xf2\x5d\x9d\xf8\xdd\xa4\xbd\x9e\x94\x3f\x4d\x13\xea\x15\xa6\x29\x46\x8b\x64\x69\x07\x9d\xf5\xe3\x2c\x1e\x0f\xd5\x6a\x5d\xff\x6c\xb5\xae\x2d\xf4\xd6\xb2\xc3\xb4\x21\x18\x2f\xcf\xb6\xb9\x7f\xea\x36\xb7\x23\xc7\xa6\xfc\xa1\x12\xc6\xe2\xdb\x16\xb8\x85\x1b\x9b\x27\xe3\x01\x75\xab\xf9\x67\xd5\x10\x77\x90\x75\xd2\xa9\x4d\x01\x4a\x70\x20\x0f\x83\xac\x1b\x54\xa4\x1b\xd4\x3f\x6d\xfb\x8c\xbe\x56\xcf\xcf\xd4\x63\xd3\xca\x81\x90\xfb\x90\xfb\x3d\xe0\x92\xe4\x04\x68\x60\x44\x92\x13\xdf\xe0\xb6\x47\x13\xd6\xc0\x88\x24\x27\xe8\xf4\x47\x7c\xf2\x71\xea\xb4\x31\x4a\xe9\x82\x4a\x9c\xb1\x04\x14\x5a\xa2\x8d\xe2\x5d\x98\xd8\xa5\x0b\xe8\x85\xab\x91\x85\xce\xcd\x8f\xaf\xc9\x4e\x84\x88\x56\xb1\xad\x20\x2e\x63\x2a\x84\x83\x05\xbf\x0a\xef\x3c\x46\x17\xfc\x4a\x35\xe6\x37\xee\xc0\xed\x36\x18\xcd\x8c\x2e\xf4\x99\x5b\xc0\xa6\x70\x17\xc8\xa7\xbc\x9b\x74\xf0\x08\xac\x07\x33\x79\x83\x05\x2e\x1b\x4d\xa7\x12\x69\xe3\xe9\x9c\xd1\xc5\xb1\x47\x9c\xf7\x43\x89\xc7\xac\x07\x17\xff\x71\xbd\xc7\xc9\xa0\x58\x03\x16\x0f\x0d\xbf\xaf\x7c\x3a\x14\xe1\x36\xb5\xb5\x14\x34\xd5\x17\x97\xa2\x45\x6b\xc3\x6a\xc4\x06\x69\x73\xa2\xc5\xbd\x3b\x3a\xea\xc4\xcb\xc0\xad\x51\x2c\x05\xba\xdd\x39\x70\xd2\x5b\xc4\x2d\x99\x90\x0b\x0e\x59\x49\xd9\x81\xf2\xb6\xbc\x7b\x88\xdf\x6e\x55\xf8\xce\x0a\x76\xe5\xca\x32\xfb\x6d\x7c\x3e\x2c\xb3\xdf\x6c\x9a\xe3\x28\xfb\x32\xfb\x4d\x12\x2e\x6a\x2b\x6d\xe7\xb6\x68\x83\x30\x30\x4c\x6b\xf6\x1b\xfa\x9c\xfd\x76\xaf\x05\x5c\x77\x83\xea\x1d\x66\xbc\xfe\x6d\x6f\xb8\x47\x92\x00\xb7\xcd\x49\x72\x70\xdb\xbc\x21\x09\xba\x55\x44\x12\x81\x3e\x4e\x63\x57\xa9\xbf\xd0\x72\x92\x92\x79\x86\x41\x67\x33\xda\x28\xbe\x42\x5e\xbc\xd0\xb2\x47\x37\x89\x76\x9f\x0d\x34\xf8\xa8\xb8\xd1\xa7\x17\x5a\x9e\xdb\x1f\x03\xdd\x19\xd6\x18\xff\xd9\x0b\x51\xad\x9d\xa6\x6b\xc8\xca\x6b\xba\xf6\x55\x8a\x56\x7a\xc0\xf5\x8c\x74\x8d\xbe\xac\xd3\xb5\xe7\x4c\xd2\x84\xe3\x39\x60\x8f\xa8\x8d\xe2\x53\xd7\x41\x17\xfc\x88\x92\x92\x55\x9d\x53\xfa\x86\xe7\x6e\x53\xb6\x1c\xb2\x5f\xa4\xb8\xbd\xbd\x7c\x1e\x7e\x7f\x48\xc9\x40\xd3\x9b\x4b\xe7\x47\x3f\x23\xb8\x10\x12\x67\x80\xbd\xf0\x1a\xc2\xa7\x68\x9f\x28\x9c\x8d\x70\x25\x48\xbb\x80\xd5\x77\x7b\x2d\x00\x00\x0e\x32\x0c\xff\xa1\x46\x3d\xbc\x73\x0c\xbd\xfd\xff\x88\xdc\x4e\x31\x6c\xb8\xa2\xc9\x82\xd3\x74\x0e\xa8\xc5\x5d\x1c\x9f\xd2\x4e\xca\x70\xf6\x3e\x46\x1a\x32\xd2\xd0\x27\x4e\xd3\x0b\xe7\x80\x66\x5d\xa4\x84\x4b\xf6\x34\x3e\x0b\x2a\x04\x9f\xf2\x3d\x9a\x50\x9b\xdd\x95\x18\xf4\x2f\x7b\xe3\x74\x01\xc3\x66\x4c\xce\x39\xce\xc9\x13\x83\xf8\xb2\xef\xe2\xf8\xb4\x77\x52\x86\xdb\xf4\xee\x48\x43\xdf\xd4\xcf\x8b\xea\xa7\x2b\x43\xb6\x30\x2f\x4d\x5b\xbf\x8b\xa6\xed\x40\xff\x4c\x8d\x97\x2d\xed\xa5\xe9\xe7\x3e\x17\x4d\xa0\x7d\xfb\x03\x7b\xf6\x6f\xb0\x5f\x2f\x96\x28\x16\xce\xe3\xfa\x39\x83\x1c\x27\x50\xdc\xfe\x66\xe8\xd8\x63\x04\xa3\x7d\xf2\x2b\x11\xe8\x86\xf5\x4f\x06\x98\xf7\xab\xa3\xd9\x4d\x1e\x04\xff\xf0\x8f\x7f\x8e\xd7\xb4\x8f\xe4\xd3\x7a\x0f\xed\x2b\x17\x6f\x13\xa9\xcf\x48\x41\x57\xf1\xb7\x0f\xff\xf8\xe7\x0f\x32\x8b\xf7\x86\xed\x93\x4f\x34\x83\xb8\x8c\x37\xfc\x3e\xdd\x3b\x14\xe1\x8c\xe1\xb5\x14\x74\xaf\x2f\xce\x31\x33\xcb\x20\x63\x65\x96\xf9\xc7\xc8\x4d\x7a\xb8\xb1\x31\xcb\x24\xba\x62\x99\xdb\x88\x0a\x14\x9b\x4b\x34\xb1\xb7\x9c\x53\x42\x95\xfe\x80\xb7\xb3\x01\xef\xdd\x9a\xb6\x29\x6e\x14\x33\x5c\x5e\xe1\xed\xcc\x39\x5f\x93\x4b\x4e\x21\x53\x19\xc3\xef\xad\x85\x6d\x0a\xa8\x75\x78\x07\x6c\x60\x3d\xd5\xac\xe8\x5e\x5f\x86\xd9\x88\x77\x58\x9d\xd9\x98\xf0\xe7\x52\xb2\x49\x02\x59\x9e\x6f\x30\xbc\xb3\xa3\x3e\x55\xb8\x39\x92\x96\x84\x92\x5c\xa0\xa9\xbe\x9d\xba\x9d\xbd\x6f\xf3\x6c\xf2\x80\xb7\x80\x8f\xa0\x42\xf0\x8c\x25\x24\x5b\x91\x82\xbe\x0c\xd1\xa4\x19\x4f\x54\xcc\x1c\xfd\xbc\xb9\xbe\xb7\x3f\x1c\x43\x0b\xb6\x28\x00\xeb\xd7\x8a\x7b\xbf\x06\xad\xd4\x41\x2f\xaf\xf8\xd0\xd7\x45\x91\x39\xde\x37\x61\xeb\x64\x09\x71\x35\x6f\x01\xbc\xf5\xad\x43\x12\x70\xd1\x5d\x8b\x41\x53\x75\x3d\x77\x1e\xc1\x5f\x70\xc6\x36\x90\x8d\x20\xcd\xbf\xbf\x84\x3a\xe9\x83\xca\xc8\x70\xa2\x4f\xfa\xe2\x1a\xb2\xe2\x05\xc0\x93\xbc\xe2\xf6\x0e\x5a\x9b\xf4\x70\xa3\x56\xbc\xc0\x28\xc6\x0b\xa7\x27\x79\x92\x61\x21\x69\x22\x08\xe6\xc9\x12\xe8\x3c\x75\x17\xcb\xa7\xfa\x5e\xea\x80\x87\x28\x5a\x12\xd1\xc7\xf6\x2f\x57\xd6\xc0\x42\x10\x1f\x8a\x3d\xfc\x16\x41\x87\x75\xb8\xe1\x7d\x81\x86\x13\x48\x94\x96\x26\x1a\x90\xb3\xab\x6f\x92\x07\x0e\x7a\x12\xb1\x41\xbb\xb1\x7f\x6c\x1b\x40\x58\xc2\x52\xc8\x5a\x7e\x85\xe0\x2b\x97\x1e\x4d\xb8\x5d\x5f\x2b\x07\x7d\x22\x6c\xaa\x6e\x9c\xb3\xca\xe7\x19\x96\x90\xf5\x5a\x0b\xe0\x53\xb8\x4b\x32\x78\xc3\xdc\xb2\xeb\x55\xd3\xd0\x79\x66\x65\xa1\x9b\xe7\x33\x75\x1d\xb4\x35\xde\xe3\x3d\xdb\x63\xa9\x91\x52\x4e\x12\xb9\x01\x1c\x76\xae\x10\x7c\x79\x6e\x68\x8e\x8e\x15\x37\x7a\x52\x5f\xbd\x0b\x3a\xd7\x37\xee\x18\x6f\xd6\x5e\x08\x6a\x9c\x72\x78\x4f\xf0\xe4\x8d\x36\x05\x4f\xaa\x5d\x41\xa7\x71\xca\x36\x2f\x41\xc3\xdd\xd2\xdb\xac\xb7\xd2\x83\xa9\xa8\x64\xa0\x9f\x79\xe9\xf6\x53\xcb\xf8\x2a\xc5\x80\xa1\x96\x05\xf0\x29\xd9\x25\x09\xe7\xad\xd6\x88\x41\x3f\xcc\xd5\xed\x47\x1a\x12\xe7\x47\x71\xfb\xf4\x6c\xa5\x87\x5b\x9f\xa0\x1c\xa3\x2b\xea\x8e\xf3\xa3\x1d\xf1\x51\xd0\xc1\x4e\x8b\xe0\xfd\x34\xbb\x34\xe1\x3e\x4d\x2b\x07\x9d\xda\x1b\xf7\xb9\xb6\x6c\x5d\x80\x82\xd5\x2a\x7e\xef\x98\xbb\x4d\x11\x30\x5c\xad\x92\x82\x62\x7d\x71\x3b\x8d\xa4\x80\x09\xab\xe2\xf6\x29\x09\x71\xfe\x45\x21\x87\xa1\x4a\x56\x7e\x80\xf0\x8e\xf7\x2e\x9b\x8f\xf7\x6a\xab\x78\x47\x08\x76\x8e\x7d\x73\x9a\x13\xe3\x7f\xad\xc4\x7c\xdc\x72\x97\x2a\x5c\x74\x83\xe9\x31\xde\x8f\x5a\x83\x67\x25\x19\xd5\x92\xd1\x0d\xcd\xc9\x4d\xf5\xcb\xed\x21\x81\x48\x4e\x21\x1d\xbf\x05\xf0\x0e\x2f\x3b\x24\xe1\x86\x86\x46\x0c\xba\x31\xd7\xbd\x0e\x43\x1e\x81\x96\x4f\xe2\xf1\xb0\xc3\x90\xc7\xb7\x71\x18\xf2\x28\x50\xfc\xe8\xd4\x34\xc9\x27\x02\xb4\x9a\xa9\xf9\x7d\x7a\x76\x28\x02\x5a\x7a\xa0\xa9\x33\xd6\xc0\x56\x40\xb6\x25\x14\xb7\x77\x0c\x27\xc2\x6f\x4b\x28\x19\xe8\xa7\x70\x6f\x4b\xcc\x33\x0a\xe9\x02\x35\xbb\x4f\xc1\x36\x41\x38\x4f\xdc\x4a\x08\xba\x50\xff\x9d\x86\x3a\x1c\xd3\x42\x72\x02\xf0\xe1\x50\x43\xf8\x74\xed\x13\x85\x33\xd4\xa9\x04\xa1\xb3\xea\x6e\xef\x6c\x0b\xea\xab\xe3\xe4\x08\x67\x1d\x27\x6f\xe4\xad\xe3\xa4\x72\xd7\xe1\x9c\x6d\xcd\xb0\x80\x94\x30\xae\xdf\xcb\xb1\xe8\x9b\xb0\x42\x48\xdc\xea\x1c\xc9\x36\x59\xe2\x62\x41\xee\x38\x2b\x09\x97\xcf\x75\x42\x2b\x1e\xe9\x24\x5a\x12\x9c\xb6\x6c\x34\x39\x99\xd7\xf7\x82\xe6\x65\x8b\x12\xb2\x71\x51\xbd\x9c\xb6\x45\x57\x37\x87\x0d\x78\x6b\xde\xd2\xbe\x3f\xfa\xd8\x53\x68\x00\x86\x51\x45\x07\x48\x1d\xc0\x65\xf2\x06\x7d\xd6\x97\x01\x7c\x9c\xcc\xd1\x37\x32\x1f\xfe\x7e\xb1\xbe\x0c\xe0\x6b\xf6\x83\x3c\x9b\x41\x0f\x25\x64\x56\x58\xfa\x27\x85\x63\x0e\xe5\x0f\x9c\x13\x96\x18\x5d\x95\xce\x19\x61\x82\x85\xc0\x45\xca\x31\xc4\xd5\x4b\x0b\xc4\xdb\xc9\x87\x3f\xfb\x52\xbf\x09\x9a\x56\x77\xee\xe3\x29\xeb\x64\x09\x6b\x4a\x6a\x08\xaf\xc6\x3d\xa2\xb0\x5b\x66\x4a\x90\xd9\x34\x53\x77\xfb\x86\xac\x29\x34\x1e\x75\x7a\x38\x1e\x75\x3a\x66\x93\xb0\xc3\x2e\x24\x27\x6f\x13\x82\x2a\x4d\x67\xe8\xbc\x1f\xd4\xfa\x38\x3e\xf3\x92\x8a\x3b\xd6\x77\xce\xf5\x87\x67\x91\x31\x40\x6c\x32\xc3\x6f\x93\xdd\x66\x21\x6d\x8a\x81\x8b\x0a\x9a\x15\xc5\xfa\xe2\x9c\xd2\x95\xeb\x59\x01\x71\xea\x6e\xf8\x7d\xf5\xa5\x43\x11\xce\xdd\x9b\x96\x82\xee\xd6\xb3\x5b\xb7\x53\xf7\x85\x80\x04\x3b\x5d\x34\x61\x60\x9d\x65\xf4\x20\x58\xd1\x26\x1a\xb8\xb7\x23\x58\x81\x3e\xed\x46\x78\xb5\xfd\x8b\xc2\xae\xc3\xc7\x01\xfa\xa9\x0e\x8e\xb7\xcb\x72\x51\x86\xeb\xbd\x04\x2b\x9a\xe8\x78\x57\x82\x15\xdf\xab\x5f\x4e\xcb\x5e\x01\x98\xa9\x72\xe1\x9d\xa6\x36\xc9\xd0\x55\x9d\x06\x69\xa0\x5d\xaf\x10\xe8\x9b\x38\x66\xab\xaa\xb5\x90\x63\x99\x9c\xb5\xa7\x21\x03\x6c\x51\xd5\x18\xbe\xcc\xdb\xa1\x0a\xb6\x4b\xd5\x68\xde\xa8\xbc\xc7\x5a\x49\x90\x64\xcd\xa9\x04\xec\x6f\xb4\x40\x7c\xda\xb7\xc8\x26\x82\x2e\x46\xec\x6d\xee\xe2\x6c\x08\xa7\xf3\x11\xdb\x26\xee\x6e\x44\xa1\x92\x9f\x37\xd7\xa3\xf2\xbc\xf5\x5a\xe8\x67\x9e\xc5\x74\x51\x60\xb9\xe6\xc3\x3c\xff\xf7\x40\xbe\x2b\xf5\x68\x7f\x27\xfb\x50\x65\xef\x80\xdc\x5c\xc7\xf6\xde\x59\xf9\x67\xac\xa0\x12\x30\xb4\x37\xfc\xbe\x62\xef\x50\x04\x74\xfc\xaf\xa4\xa0\x33\x7d\x71\x36\x8a\x20\x43\x9c\x43\xa6\x37\xa3\x22\x17\x37\xac\x93\xb7\x8a\x59\xfd\x8d\x88\x61\x21\x24\x6a\xae\x3d\xd1\xad\xad\x5b\x11\xc0\xe8\xce\x00\xf8\x32\xb7\x4b\x12\x6e\x7f\xc9\x88\x41\xd6\x2d\x8a\xd3\x43\x30\x67\x92\xcd\xd6\x73\xc0\x68\xd0\x22\xf8\xda\xa1\x1e\xcd\x40\x83\x9f\x8a\x1b\xdd\xd9\x1b\x77\x68\x7b\xd0\x9e\xbd\x38\xb0\x67\x2f\x46\xed\xd9\x37\xbc\xc1\xd7\xc1\x95\x10\x14\xef\xd9\xf0\xdf\x90\x8c\x25\xa0\x1e\xb1\x42\xf0\xe5\x51\x8f\x26\x98\xaa\x95\x1c\xf4\xdd\xde\x78\xfc\x8b\xc0\x76\x50\x5b\x20\x3e\xc5\x77\xc9\xc6\xfa\x14\x51\x10\x93\xb7\x99\x27\x5b\x3f\x20\x7a\x1f\xd1\xf8\xff\x38\x72\x37\xd1\x0d\x61\xe7\xcd\x0d\xd2\xfe\xe9\x33\x16\x10\xef\x46\xc2\xef\xd8\x48\x84\xf7\x69\x24\x4e\xd0\xe9\x1e\xbb\x21\xb3\x14\x0b\x18\x78\x1a\x00\xef\xa0\xb3\x43\x12\x6e\xf3\xc9\x88\x41\x3f\xa7\xfa\xea\xec\x3b\xf0\x36\x63\x8b\x05\x28\x4c\x7b\x83\xe1\xd3\x79\x87\x2a\xdc\x9a\x42\x2d\x09\xdd\xe1\xed\xb5\xb9\x75\x07\x8a\xe6\x73\x9a\x01\x8a\xda\x02\xf8\xba\xcd\x2e\xc9\xe0\x28\xd1\x9a\x19\xdd\x63\x7e\x41\x33\xe2\x5e\x66\x60\x0c\x70\x1e\x5c\x71\xfb\x4a\xad\x95\x1e\xf0\xe8\x16\x7b\x44\x57\x8c\x3d\x3a\x1b\x9a\x65\x32\x79\x82\x6c\xe6\x6b\x7e\x6f\x73\xd3\xa6\x18\x3a\x4e\x36\xcc\xe1\x0d\x01\x96\x09\x7a\x12\xe8\x87\x3b\x08\x2f\x5b\x16\x2f\x90\x55\x32\x0b\xe0\xab\xc6\x7a\x69\xa9\x4b\x37\xb4\x90\x35\x2f\xba\x32\x57\x67\x55\xa6\x8b\x02\x14\xd7\xc6\xf0\xfb\xca\xda\x50\x4c\x12\x05\x36\xb6\x9b\xaf\x30\x58\x5e\xae\xc7\xc4\x09\xe8\xa0\xe8\xa8\xb4\xa3\x6d\xa1\x2c\x08\x4d\x17\x64\xf4\xc2\x85\xc5\x00\x47\xa4\xb4\x38\xa0\x50\x92\x16\x63\x54\x28\xc9\x61\xd5\xd1\x48\x42\xba\x22\xa0\x4b\xfd\x63\xaa\xee\x07\x8d\x9d\x2a\x10\x53\x13\x2a\x18\xf3\x6b\x0c\x90\xa9\x0c\x16\x47\x07\x29\x1e\x66\xfb\x6e\x61\x74\x75\xb0\x28\x97\xe9\x27\x52\x8c\x01\x69\x22\x5a\x1a\xa0\x71\x11\x2d\x2d\x98\x09\x3c\x69\x80\x86\x07\x9e\xb4\x20\x82\x48\x0b\xb1\x13\x71\xd2\x0e\xbc\x44\x26\x27\x02\x6f\x21\x4d\x61\x83\xe1\x1d\xbf\xf5\xa9\xc2\xda\x0f\x69\x49\xda\x8a\x28\x56\x77\xce\x71\xdc\x3a\x13\x18\xb0\xc9\x60\xf8\xbd\xe3\xb7\x36\x45\xc0\xfd\x20\x25\x05\xdd\xe9\xcb\xbe\x15\xb3\x89\x78\xc2\x8b\x05\xe4\x84\x50\x1b\xc5\xa7\xb4\x83\x2e\xec\x52\x98\x95\xa5\x17\xb7\x62\x73\xbf\x3f\x2a\x08\xc4\x7a\x9a\x1f\x18\xae\xdb\x48\x20\xba\x49\x1a\xae\xb9\xc3\x8a\x47\x94\x64\xc8\xe1\xda\xd6\x71\x3e\xf5\x0a\x26\x66\xfb\x11\xcd\x46\x63\x78\x52\x92\x0c\xc5\x25\x71\x1d\xca\x25\x5b\x92\x8c\xcf\x3c\xc5\xed\xcb\xba\x56\x7a\xb8\x33\x8e\x5b\x92\xa0\x8f\x5b\x92\x38\x4d\xce\x69\xc2\x59\xc9\x99\x9a\x3b\xbc\x82\xf1\xaf\x03\xcd\xa7\xbe\x87\x3e\x9c\x59\x70\x4b\x66\x63\x23\xac\x1e\xde\x99\x87\x87\xec\x85\x3f\x00\xcd\x85\x3f\x78\x67\x18\x6d\x8a\xb0\xc6\xc2\x1f\x50\xfc\xc1\x69\x59\xc3\x21\xbd\xa2\xe2\xf6\x29\xd8\x4a\x0f\xe8\xea\x80\x15\x68\xca\xdd\xdd\xdf\x0b\x63\x2b\x42\x4a\xc2\x27\xb9\x3e\x7d\x32\x5e\xd5\x3e\x92\x4f\xed\x3d\xb4\xc1\xb2\xa0\x96\x67\xc4\xa1\x1b\x7d\xd9\x73\x0e\x1f\x60\x79\xaa\xb8\x7d\x93\xc1\x56\xfa\xc0\xf5\x4a\xce\x56\xe8\x13\x67\xee\xb8\xc2\xf9\x86\x40\x4e\xca\x6c\x88\x77\x81\xb7\x95\x0e\xeb\xc8\x5a\x40\x03\x1b\xa9\x0d\xc9\xd0\xcd\x86\x1c\xb3\x40\x5b\x77\x63\x35\x93\xa3\x1b\xab\xbd\xf1\x8a\xc7\x4c\x10\xbe\x81\xd4\xfb\x5d\x2c\x5f\x66\xee\xa5\x7e\x3b\x47\xc0\x71\x25\xd9\xd9\xdc\xcd\x20\x16\x37\x8a\xdb\x57\xff\x5b\xe9\x03\xdb\xb0\x19\xe3\x68\x7a\xf6\xf5\x9b\xfb\xe0\xbb\xd9\x3f\x48\xb9\xca\xaa\xf1\x1f\x6f\x0b\xc5\x57\x84\x0e\xba\xd0\xfb\x14\x5a\x96\xdd\x5e\x38\x57\xf7\xae\xa2\xa3\x0c\xb2\xf3\x4f\x99\x7f\xdf\x9f\x8e\x0a\x76\x34\x70\x6d\x81\x49\x8c\x2e\xbf\xde\x9f\x3a\x6b\xe6\x16\xb0\x4f\x9b\x6c\xe7\xde\x6e\xb8\x4e\x1e\xba\x8c\x99\x6c\xe7\x3b\x61\xa5\x5e\xdb\xff\x63\xb2\x9d\xa3\xe9\x76\x3e\x68\xea\xaf\x78\x1e\xf0\x96\x0b\xc5\xf9\xcd\x39\x7c\xe3\x04\x90\xa1\xcd\xa1\x80\x3d\xd3\xbf\x7e\x86\xbe\xb6\x4d\x94\x35\xa8\x77\x87\x40\x65\x39\x64\x37\x5c\xb1\xfb\x94\x6b\x13\x04\x0c\x73\xca\xf2\x12\xc5\xea\xbf\x53\xc7\x02\xaf\xc8\x33\xce\x01\xfd\x7e\x0d\xe1\x6b\xb1\x55\xfa\x0e\xe5\x40\x4d\x2a\x6e\x14\xab\xbb\x7f\x9f\xde\x5c\x3b\x5b\x71\x96\xd1\x62\xc1\xfe\x3e\x5e\x21\x0b\xe0\x2b\xba\x2e\x49\xb0\xc2\xb3\x62\xd0\x57\x73\x75\x15\xa0\x21\x01\xec\x05\x5b\x80\xc3\xda\x06\xdf\x13\xb6\x62\xac\xb6\xce\xbd\xe1\x9c\x66\x00\x6f\x90\x8a\xdb\x3b\x42\xa5\x19\x9b\x24\x19\x1d\xb5\xe2\xd2\x82\x78\x9b\x01\x99\x12\x85\xcc\xdb\xa2\x1b\x9a\xb1\xa9\xbe\x1d\xe6\xab\x45\x41\x98\xb7\xd5\x10\xf1\xde\xf1\x9c\x3e\xe7\x96\x00\xfc\x20\x5b\x00\x5f\xf6\x77\x49\xc2\x1e\xa5\x4b\x9e\xd0\xf4\xc9\x1d\x53\x87\x97\x80\xa5\x29\xc5\xed\x1d\xf4\x35\xe9\xa1\xba\x79\x25\x02\x7d\xe2\xa5\x73\x65\xea\x89\xcc\x96\x0c\x32\x35\xb5\x00\x3e\x1d\xbb\x24\xa1\xd4\xb4\x52\xd0\x0f\x73\x75\x47\xee\xd7\x4b\x97\x80\x45\xf9\x45\x7b\xf9\x75\x4f\x84\xfe\x91\x2b\xb4\x43\xa3\xf2\x9b\x55\xd8\xbb\x85\x63\x1d\xb6\xb5\x4c\x98\x13\xd0\xe2\x4b\x83\xe1\x6f\x27\x7b\x54\x61\x97\x15\xb5\x24\xb3\x98\xa8\x6f\x9d\xed\x53\xf1\x7c\x02\x59\x42\x54\xec\xbe\xf1\x4b\x9b\x60\xa0\x0d\x89\x66\x45\xa7\xea\xff\xde\x40\x31\x19\xce\x67\x29\x60\xd6\xd5\x60\x1c\x68\x60\xbb\x54\x41\x97\x42\x8d\x24\x74\xad\x2f\xfb\xd6\x7d\x57\xb4\x20\x02\xe2\x78\xad\x05\x72\x48\xf5\x2e\xd9\xa8\x03\x78\x16\x62\x32\xa7\x9c\x2c\x59\xf8\xe3\x8b\x2a\x1f\xad\x4c\xf4\xc5\x5c\x07\x9f\xc7\xab\xde\xb5\x02\xb8\xb0\xbf\x9d\x51\xbb\x88\x94\xcf\x13\xad\xcc\xe8\x12\x69\x30\x7c\x05\xb2\x43\x15\xaa\x9f\xd0\x82\x90\xc2\x46\xb7\xea\xf6\xb3\x94\xce\x99\x10\x2d\x21\x91\x2e\x14\xb7\x4f\xdd\x56\x7a\xb8\x65\x8f\x72\x2e\xd0\xe5\xdd\x85\x33\x5e\x8b\xae\xbd\xc0\xc0\x88\x47\xc4\x45\x7c\xa3\xb0\x88\x55\x54\xc4\x7d\x9a\x42\x63\x7f\x1e\x11\xfa\xf3\x8d\x22\x7f\xea\xc0\x9f\x7b\x82\x7e\x8a\x07\x48\x81\x2a\x6e\x9f\x8e\xad\xf4\xe1\xd6\xfa\x0f\xb9\x98\xcc\xb0\x4c\xc2\x87\x8a\x78\xc8\x05\x8a\x1f\x06\xc6\x33\xd6\x5c\xfa\xfd\x34\xef\x99\xba\x73\x36\x0a\x1c\x30\x17\xa0\xdc\x3b\x15\x68\x92\xc3\xb5\x08\x3c\x41\x97\xdc\x39\x11\x78\x48\x20\x27\x62\x13\xff\x31\xd8\x24\xfc\xd9\xd7\x84\xa3\xab\xc4\x39\x14\x4c\x39\x2b\x67\x6c\x0b\xd8\x89\x31\x00\x3e\x0d\xbb\x24\xe1\xf6\x5c\x8c\x18\x74\x6e\xae\xce\xd6\x2e\x91\x74\x43\x40\x11\xa9\x2c\x82\xb7\xbd\xeb\xd2\x84\x6b\xf0\xac\x1c\x74\xaa\x6f\xdc\xd1\xa9\xd4\x1b\xa6\xeb\x0c\x32\xcf\xa9\x21\xbc\x0d\x60\x8f\x28\x5c\x1b\x56\x09\x42\x71\x75\xe7\x3c\x80\x04\x3f\xca\x7e\xd4\x29\xf6\x81\x07\xd8\x47\x2f\xbd\x37\x67\xd7\xbd\xe7\xd6\x57\x93\x8c\xe1\x94\xf0\xc9\x51\xcb\xd4\x68\xb5\x57\xf9\x0e\x90\x4b\xc0\x91\xce\xf3\x8f\x11\xd1\xf2\x93\xdf\x4b\x59\x31\x99\xd1\xc3\xa6\x20\xc7\x08\x31\x50\x2e\x21\x0f\x87\xc7\x05\xc7\x08\x78\x10\x2e\xf0\xed\x2b\x15\xc3\xd6\x5d\x0a\xaa\x12\xbd\xce\xdb\xe3\x0d\xee\x08\xe0\xeb\x42\x6a\xa7\x91\x18\x5a\x00\x6d\x24\xa7\x88\x25\xc1\xd9\x11\x61\xc3\x8e\x12\x62\xb0\xdc\x62\x8e\x99\xa9\x1d\x27\xa4\x9a\x89\xf5\x13\x8e\x5d\x31\x3c\x4a\x4a\x7b\x69\xb0\x9f\x76\x94\x85\xd4\x51\x52\x6a\x6b\xa8\x7e\xc2\xaa\xc0\xf2\x98\xbd\xfd\xa3\xa4\x58\x30\x4b\x99\x92\x92\x14\x29\x29\x12\x4a\xba\x86\x3a\x07\x24\x1c\xd7\x50\x01\xb0\xcc\x5b\xb6\x8e\x92\x03\x91\x5e\xe9\x7d\xfa\xf5\xed\x15\x4a\xa6\xf3\x7e\xee\xd0\xb8\x1d\x92\xe3\x57\x1c\x5e\xb5\x70\xff\x77\x17\x88\xa9\x79\x56\xcb\xd7\xef\x71\x9d\x06\x5d\x75\x6a\x98\x0e\xf8\x50\x20\x9b\xd5\x11\x91\xea\x07\x76\xc7\x4e\x91\x2b\x7b\xce\xe8\x75\x3b\x67\xa7\x28\x9b\xf6\xda\x3d\xb5\x3b\xec\x94\x4d\x7c\xfd\x7e\xdb\xad\x9a\x4a\xfd\xff\x01\x00\x00\xff\xff\x01\x77\x57\x27\x3f\x55\x01\x00"),
		},
		"/camel-catalog-1.3.0-SNAPSHOT-quarkus.yaml": &vfsgen۰CompressedFileInfo{
			name:             "camel-catalog-1.3.0-SNAPSHOT-quarkus.yaml",
			modTime:          time.Time{},
			uncompressedSize: 29335,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xbc\x5d\x5b\x5b\xdb\x38\xf3\xbf\xcf\xa7\xd0\x53\x6e\xde\xf7\x79\x6a\xb5\xbb\xfc\x77\x2f\xf8\x5f\x01\x85\x16\x4a\x80\xad\xb3\x6d\x77\xef\x14\x5b\x89\x45\x6c\xcb\x48\xca\x01\x3e\xfd\xfb\x48\x96\xe3\x03\x66\x6c\x07\xb9\x5c\x10\xc7\x9a\xf9\x8d\x66\x74\x18\x69\x74\xc8\x11\xf2\xdc\xfd\x4d\x8e\xd0\x0d\x0b\x68\x2a\x69\x88\x14\x47\x2a\xa2\xe8\x34\x23\x41\x44\x91\xcf\x17\x6a\x4b\x04\x45\x97\x7c\x9d\x86\x44\x31\x9e\xa2\xff\x9c\xfa\x97\xff\x45\xeb\x34\xa4\x02\xf1\x94\x22\x2e\x50\xc2\x05\x9d\x1c\xa1\x80\xa7\x4a\xb0\xf9\x5a\x71\x81\xe2\x1c\x10\x91\xa5\xa0\x34\xa1\xa9\x92\x18\x21\x9f\x52\x83\x7e\x7b\x37\xbb\x3a\xbf\x40\x0b\x16\x53\x14\x32\x99\x33\xd1\x10\x6d\x99\x8a\x26\x47\x48\x45\x4c\xa2\x2d\x17\x2b\xb4\xe0\x02\x91\x30\x64\x5a\x30\x89\x11\x4b\x17\x5c\x24\x79\x36\x04\x5d\x12\x11\xb2\x74\x89\x02\x9e\x3d\x09\xb6\x8c\x14\xe2\xdb\x94\x0a\x19\xb1\x0c\x4f\x8e\xd0\x4c\xab\xe1\x5f\x16\x39\x91\x39\xac\x91\xa9\x38\xfa\x87\xaf\xad\x0e\x15\x75\xad\x15\xde\xa3\xef\x54\x48\x2d\xe4\x77\xfc\x71\x72\x84\xfe\xa3\x49\xde\xd9\xc4\x77\xff\xfd\x7f\xf4\xc4\xd7\x28\x21\x4f\x28\xe5\x0a\xad\x25\xad\x20\xd3\x5d\x40\x33\x85\x58\x8a\x02\x9e\x64\x31\x23\x69\x40\x4b\xb5\xf6\x12\x30\x32\x19\xd0\x18\x7c\xae\x08\x4b\x11\x31\x6a\x20\xbe\xa8\x92\x21\xa2\x26\x47\x93\x23\x64\xfe\x22\xa5\xb2\x93\x0f\x1f\xb6\xdb\x2d\x26\x26\xbb\x98\x8b\xe5\x87\x42\xbb\x0f\x37\x57\xe7\x17\xb7\xfe\x85\x67\xb2\x3c\x39\x42\x7f\xa7\x31\x95\x12\x09\xfa\xb8\x66\x82\x86\x68\xfe\x84\x48\x96\xc5\x2c\x20\xf3\x98\xa2\x98\x6c\x75\xc1\x99\xd2\x31\x85\xce\x52\xb4\x15\x4c\xb1\x74\xf9\x1e\x49\x5b\xea\x93\xa3\x5a\xe9\x94\xe6\x2a\xb2\xc7\x64\x8d\x80\xa7\x88\xa4\xe8\xdd\xa9\x8f\xae\xfc\x77\xe8\xec\xd4\xbf\xf2\xdf\x4f\x8e\xd0\x8f\xab\xd9\x97\xbb\xbf\x67\xe8\xc7\xe9\xb7\x6f\xa7\xb7\xb3\xab\x0b\x1f\xdd\x7d\x43\xe7\x77\xb7\x9f\xae\x66\x57\x77\xb7\x3e\xba\xbb\x44\xa7\xb7\xff\xa0\xaf\x57\xb7\x9f\xde\x23\xca\x54\x44\x05\xa2\xbb\x4c\xe8\xfc\x73\x81\x98\x36\x24\x0d\x75\x99\x16\x15\xa8\xc8\x80\xae\x1f\xfa\xbb\xcc\x68\xc0\x16\x2c\x40\x31\x49\x97\x6b\xb2\xa4\x68\xc9\x37\x54\xa4\xba\x7a\x64\x54\x24\x4c\xea\xe2\x94\x88\xa4\xe1\xe4\x08\xc5\x2c\x61\xca\xd4\x22\xf9\x52\x29\x2d\xc6\x65\xdb\x9a\x90\x8c\xd9\xea\x74\x82\x02\x92\xd0\xb8\x5a\x7c\x9b\xdf\x26\x2b\x96\x86\x27\xe8\x5c\xa7\x9c\x13\x45\x62\xbe\x9c\x24\x54\x91\x90\x28\x72\x32\x41\x28\x25\x09\xb5\x8c\x5e\x90\xa7\x7b\xbf\xe1\x63\xfc\xd1\x93\x29\xc9\x64\xc4\x95\xf7\xb8\x26\x62\xb5\x96\x13\x84\x62\x32\xa7\xb1\xd4\x6c\x48\x97\x76\xc1\xb7\x32\x2f\x5e\x08\xb7\x70\x78\x53\x64\xef\x18\xff\x86\x3f\xc2\xb4\x31\x27\x21\x15\xbd\x58\xc4\x3a\x55\x2c\xa1\x25\x6d\x9e\x6d\xff\xf6\xf4\xde\xff\x72\x37\x83\x99\x32\xc1\x37\x2c\xa4\xe2\x04\x15\xda\xe9\x32\xd6\x9a\x59\x8a\x5c\x49\x08\xfb\x25\x84\x35\x8b\x6e\x04\xba\xf4\xcf\x63\x22\xe5\x09\x62\x1c\x5b\x02\x2c\xd6\x69\x4a\x05\xfe\x4c\x53\x2a\x88\xa2\xe1\x94\xb0\xd4\x70\x55\x4b\xa4\xcc\x77\x8b\x15\x50\x21\xac\xa1\x36\xbe\x64\x29\x89\xab\xdc\x5e\x0b\xe1\x47\xfc\xd1\x9b\xfe\x61\xa8\x42\x9a\xd1\x34\xa4\x69\xc0\xa8\x2d\x50\x0f\x2d\x05\x5f\x67\x57\xe1\x09\xe2\x62\x59\x18\x2d\xcf\xc9\xca\x22\x13\xa1\xd8\x82\x04\x4a\x13\xd9\xb2\xf7\xac\xc1\xbc\xaa\x15\x02\x92\x91\x39\x8b\x99\xda\xa3\x23\x14\x08\x9e\x16\xcf\x6d\xf2\xfb\xe6\xa1\x2b\x1f\x5a\x8e\x25\x8d\x28\x89\x55\xf4\x16\xa1\x55\xa5\x5e\x13\x6d\x69\xbc\x84\x05\x82\x67\x82\xeb\x9e\xda\xcb\x45\x5b\xbe\x2c\x26\x4a\xbb\x16\xcf\x74\xb2\xbf\x28\x3b\x35\xa1\x96\x43\x50\xa9\x7e\x95\x7c\x2d\x6b\x74\xa5\x0a\x4a\x9b\xff\x3a\xf1\x43\x38\x0f\x0a\xbd\xfa\x8a\x7f\x5d\xb4\x46\xb3\x44\x32\x88\x68\x52\xda\xcc\x43\x2c\x3c\x41\x95\x74\xeb\x4d\xd1\x82\xc4\x92\xee\xdf\x65\x44\x4a\xb6\xa1\xf5\xd7\x0f\x64\x43\x66\x4f\x59\x15\xec\x45\x0e\xb5\xaf\xe7\x29\x4d\x15\xd6\x32\xf0\x75\x38\x0f\xce\x8b\x57\x2d\x6a\xeb\xfa\xe7\x4e\x6d\x8d\x06\xa9\x5d\x49\x1f\x4d\x6d\x2d\x03\x5f\xb2\x98\x42\x6a\x67\xe1\xc2\x9d\xd6\x59\xb8\x80\x94\x2e\x93\x47\xd3\x39\x0b\x17\xf8\x3e\x5c\x40\x1a\xcf\x59\x1a\x3e\xb9\xd3\xd9\xc0\x59\x2a\xed\x8c\xf2\xc1\x70\x25\xb7\x86\xc0\x0b\xe4\xa6\xf1\x66\xc1\x76\x34\x6c\xbc\x5b\x6d\xb2\x01\x6a\x97\xe2\xb0\x61\xc7\x81\xdc\xe0\x33\xfd\x74\x2e\x37\x9f\x88\x22\x97\x26\x71\x00\x80\xc9\x53\x0e\x71\xa9\x1f\x6f\x68\xba\x54\xd1\x41\x50\xab\x4d\x96\x03\x7d\xa5\x4f\xdf\x49\xbc\xa6\xf7\x84\x89\x06\x52\xdd\x92\xbb\x8c\x94\x6e\xe7\xed\x05\x63\xe0\x2c\x55\x31\x02\xad\x58\xb3\x9a\xdc\xc7\xd8\x05\x04\x36\x8c\xf8\xe7\x3d\x51\xd1\x8d\x7d\xd7\xa2\x8c\x22\x4b\xc9\xd7\x99\x3b\x75\x2c\x20\x54\xd3\x14\x0b\x9f\xa6\x9a\xfa\xc0\x4a\x64\x45\xe0\xd9\x1e\x07\x2c\xaf\x07\x12\xac\x64\x39\x3a\x71\xe0\x2b\x72\x40\x48\xc5\x07\xc9\xd3\x06\xdd\x40\x5f\x90\xf3\xe2\xeb\xfc\x13\x54\x30\x90\x1b\x77\xca\x95\x1d\x40\xab\x62\x65\xf2\xc0\x42\xd3\x6d\xfe\x65\x73\xaf\xcb\xae\x0e\xa0\xde\xae\x49\x65\x64\xd4\xda\xcd\x57\xd2\x07\xf4\xf3\x25\xaf\x1c\xdb\x49\x68\x58\xfc\x45\xa9\x0c\x72\x13\x64\x2b\x3d\x99\x4a\x77\x66\xb3\x80\x90\xe5\xea\x24\xa3\xe9\x4f\xb6\x12\xcb\x54\x62\x3f\x95\x90\x05\x36\x24\x66\x21\x51\x5c\xb8\xb3\xc1\x1e\x12\xb2\x42\x93\xa8\xc3\x0e\x4a\xac\x0f\x33\xc3\x5e\x0e\xfe\x5e\x3c\x41\xe6\x78\x66\x99\xdb\x31\xa2\x05\x84\x7a\x85\x3a\xc9\xc0\x9e\xc1\x32\xe3\x7f\x59\xa6\x47\x81\x70\x5f\xce\xa3\xf4\xd9\x69\x5f\x9e\x03\x76\xf7\xe5\x35\xba\x81\x7d\x79\xce\x8b\xaf\xf3\x4f\x50\xc1\x94\x2a\xe5\x70\xd4\x67\xe0\xa0\x4a\x5c\x25\x18\xad\x21\x1b\x21\xf8\x56\xff\x87\x6a\xae\x24\x31\x95\x0b\x2e\x02\x87\x95\xb7\xc4\x84\xac\xf0\x82\x6a\x34\x53\x94\x92\xb0\xbf\x7f\x04\xa7\x01\x82\xb0\x54\x09\xea\xd0\x26\x7b\x48\xc8\x24\x4d\xa2\xd1\x2c\xb2\x17\x84\xcf\x8a\x27\xb0\x92\x50\xb1\x89\xa9\x72\x58\x43\x72\x40\xb0\x7a\xd4\x48\x0a\x4b\x54\x3a\x74\x37\x55\x23\x97\x82\xfd\xfc\x13\x32\x82\xa0\x24\x50\x6c\x43\x3d\xa9\x04\x25\x89\x43\xef\xdf\x44\x86\xcc\xf2\x0a\xed\x68\x35\xa5\x90\x87\xad\x3c\xfc\xcd\xbe\xf0\xf3\xef\x5d\xc3\x24\xba\x72\x3c\x4c\xa2\xab\xce\x61\x52\x49\x32\xea\x30\x89\xae\x24\xbe\xf8\xea\x43\x16\x08\xb8\x70\xd8\x87\x68\xb4\xd7\x27\xad\x01\x4f\xa5\x22\x69\x39\x0f\xa7\xbb\x20\x22\xe9\x92\xde\x0b\x9e\x51\xb1\xf7\x38\x5e\x35\xc0\xe4\xa1\x88\x92\x90\x8a\xfd\x57\x41\x17\xfb\x67\xc9\x92\xac\x42\xa9\xf8\x8a\xa6\xec\x79\x88\xc1\xf6\x13\xe3\x22\x73\xf8\xdc\x3e\xd4\xa6\xc7\x30\x6f\x66\xf3\x8f\x2f\x1a\x0a\x0d\xc0\xc8\x55\x31\x11\xaf\x01\x5c\xb9\x6d\xf0\x17\xf3\x31\x80\x4f\xd0\x05\xfe\x46\x17\xc3\xf3\xe7\x9b\x8f\x01\x7c\x45\x99\x08\x3c\xb3\x4f\x40\xdc\x81\xee\xa8\xc3\xe8\xad\x46\x83\x5a\x62\x25\x7d\xb4\x66\xa8\x65\xe0\x8b\x1d\x05\xa3\xb7\x66\x24\xe4\x78\x9e\x5b\x62\x76\x0e\xf4\xbc\x96\x39\xaf\x6b\x37\x96\x0f\xf6\xcc\xdc\xd5\x8c\xf8\xba\x26\xb0\x79\x67\xee\xd0\x9f\x1b\x3c\xd0\x9d\x57\x29\xc6\x1b\xe9\x19\x29\x38\xf7\x4d\x70\xc7\x9c\xca\x75\xec\xb2\x6b\xd6\x78\x90\x01\x6a\x14\xa3\x19\x20\x97\x62\x7a\xd9\x75\xdc\x19\xc2\x38\x76\x1c\xc1\x38\xee\xf2\xcc\x7b\x8a\x71\xe3\x17\xc7\xd8\x3f\x86\x94\x57\x44\xb8\x9d\xae\x5b\x40\x68\x46\x5b\x27\x19\x1c\x7d\x35\xcc\x78\x46\x44\xf7\x74\x9d\x09\xe2\x70\xae\xce\x04\x81\x4a\xb5\x92\x3e\xde\x1a\x1d\x13\x04\x5f\x33\x41\xc0\x35\x3a\x97\xdd\xfb\x02\xee\xd7\x17\x87\x07\x31\x17\x07\xc5\x30\x6d\x1f\x7a\x90\xdc\x03\x16\x06\x05\x4d\xb8\xa2\xf8\xb2\xe9\x44\x86\xf1\xca\x83\x99\xfd\x45\x47\xfc\xf5\x79\xed\x72\x5c\x6d\xe0\xc0\xae\x4b\x13\x78\xf3\x98\xcf\x0f\x2d\xba\x1c\xe1\x71\x4d\xd7\xa3\xcf\xed\x8d\x28\xac\x33\x8b\xcf\x62\x3e\xd7\x33\x5b\xd6\x0c\x77\xf4\x82\x30\xb9\xc5\x7f\xe9\xff\xad\x20\x8d\x21\x40\x4c\x82\x95\xc3\x11\x85\x86\x03\x07\x14\x15\x82\xf1\xc6\x13\x5a\x08\xf6\xf5\x7f\x50\xf7\x87\x44\xfe\xee\x50\x77\x0d\x07\xea\x5e\x21\x18\x4f\x77\x2d\x04\xfb\xfa\x7f\xd7\x40\x22\x26\xc9\x3c\x74\xe8\x74\x4a\xcc\xae\x01\x45\x8d\x6a\xd4\x41\x45\x2e\x09\xdf\x98\x8f\xce\xa8\x47\xe0\x3a\xea\x11\x74\x47\x3d\x82\x5f\x13\xf5\x08\x24\xbe\x38\x07\xa3\x1e\x3a\x8b\xe1\x3a\xa6\x0e\x17\x87\xf6\x90\x60\xb3\x68\x10\x8d\xd7\x34\x0a\x41\xd8\x2f\x9e\xc0\x7d\x34\x6d\x9b\xd5\x1c\xec\xa8\x69\xd9\x8e\xd6\xbe\xb7\xa6\x85\x70\xbc\x5d\x36\x56\x58\x3e\x1b\xbd\xb7\xdf\xba\x26\xa4\x3b\x19\x3b\x0c\x2f\x6b\x34\xc8\x20\x95\xf4\xd1\xec\xa0\x65\xe0\x9f\x32\x06\x63\xca\xba\x8f\x75\xeb\x37\xba\xdc\xc6\xc1\x63\xcf\x87\x44\x7a\x73\xa2\x82\xe8\x57\xf8\x1d\xe3\x76\x06\x0d\x59\x0c\x97\xc9\x9f\xe1\x3d\xd3\x4f\x60\x9b\x24\x11\x77\xd8\x14\x49\xc4\xc1\x16\x58\xa6\x8f\xd7\xf0\x48\xc4\xf1\x3d\x89\x38\xa4\x76\xc8\x9f\x5d\x76\xcb\x06\x0e\x52\xbc\x4a\x30\x9a\xe6\x46\x08\xfe\xa4\xff\x83\xab\x7a\x94\x38\x5c\xc4\xd6\x68\x90\xe6\x95\xf4\xfe\x9b\x14\x6c\xa8\x28\x26\xb2\x67\x43\xad\xf0\xb6\x2c\x09\x54\xf2\x30\x70\x7d\x90\x92\x14\x9f\x51\x92\x0e\x6a\x83\x9a\xcb\xe4\x1d\x9b\x8d\xfa\x3d\x78\xf7\x71\xec\xbd\x40\x20\x7c\x6d\xb7\x67\xed\x12\x87\x71\xbb\x12\xd3\x92\xb6\xef\x46\x68\x52\x1d\xb4\xaf\x6c\x97\xc4\xc5\xd6\xb2\x9f\xd3\x1b\x30\x86\xa3\xc7\x73\x4a\x90\x54\xc6\x44\xb9\x9c\xe8\x56\x61\xbb\xc6\x93\x4d\xc2\x51\x47\x95\x7b\x61\x78\x56\x3c\x41\x4d\x39\x59\x4b\xa5\xb1\xdc\x99\xa6\x40\x84\xac\xd2\xa0\x19\xcd\x20\x85\x1c\x3c\xb5\x0f\xa0\x29\x08\x73\xd8\x1e\x34\x1a\x64\x02\x96\x90\x83\x43\x5f\x9a\xf7\xe0\xf1\x47\xc6\xb3\x03\x62\xc7\x25\xef\xe1\x03\x9f\xe4\xf0\x60\x9f\xe6\x3d\x40\x70\x6b\x1f\x94\xb0\x84\x7a\xc9\x3a\x56\x2c\x23\x42\x1d\x56\xaf\x08\x8b\xf1\x94\xb0\xb8\x47\xcf\x5c\x09\x3e\x6b\xc9\x78\x2f\x19\x4f\x59\x42\xa7\xc5\x37\xb0\x17\xd3\x9d\xfa\x18\x3b\x05\xeb\xb8\x5d\x4e\xf8\x05\xe5\x78\xbb\x6a\xb4\x13\x2b\x77\x0e\x6a\x77\xd6\x6b\xf7\xa0\x4c\xc9\x8a\x3e\x11\x97\x7e\x6d\x0f\x09\x55\x29\x9d\xfe\x82\x72\xe0\x60\xbd\xe0\xc6\xbe\x7e\xfa\xe7\xb4\xc3\xb1\x6d\x1c\x2e\x3a\x6e\xc0\x05\xc7\x4d\xcf\xc5\xc6\xc3\xb7\x88\x26\xf8\x3b\xb8\xc6\xb8\x22\x8b\x95\xc3\xa0\x98\x81\x83\x34\xae\x12\x8c\x56\xc7\x8d\x10\xfc\x55\xff\x87\x77\x8c\xb9\x8c\x07\x6a\x34\x48\xf3\x4a\xfa\x58\xa5\xad\x45\x60\x9f\xc2\xa1\xbf\xa5\x20\x59\xf4\xe8\xb0\x19\x5b\x40\x48\xf7\x3a\xc9\x68\xe5\x6e\xc5\xe0\xcf\xf9\x27\x68\x05\xa7\x07\x3f\x96\x7d\x4e\x7d\x2c\x0f\x3d\xf2\xa1\x19\xf1\xe7\xae\xc3\x1e\x31\x5f\xba\x53\x28\xe6\x4b\xa8\x3c\xcb\xe4\xb1\xaa\x72\xcc\x97\xf8\x86\x2f\xc1\x05\xf2\x2d\x53\xca\x65\xa0\xc0\x02\x42\x8a\x5b\x12\x2f\x64\x82\x06\x2a\xa1\x52\x96\x5b\xa0\x06\x8f\xbc\x0a\x30\x49\x89\x38\x24\x64\x55\x47\x51\x2c\xa1\x31\x4b\x47\x1f\xf8\x5b\x79\xb8\x66\x02\x3c\xcb\xdf\x7e\x32\x2f\xa7\xf9\xcb\x41\xf3\xf2\x02\x36\x37\x46\x81\xe7\x9b\x6f\x07\x01\x15\xf6\x28\xa0\x66\xf6\x3b\x54\xa5\x78\xcc\xd2\x25\xff\x3f\x77\x55\xca\x02\x42\x55\xaa\x4e\x32\x5a\xb1\x59\x31\xf8\x2e\xff\x04\xfd\xa2\x4b\xef\x20\x61\xcf\x20\x0f\xf1\x0a\x7b\x56\x4f\x2a\x2e\xf6\x87\x50\xc7\x8b\xf6\x3e\xc6\xd8\x6f\xfa\x93\x1e\x3c\x79\xee\x34\xab\x6f\x9e\x20\xa3\xb3\x80\x38\xb4\xba\x46\x83\x1c\x52\x25\x7d\x98\x29\x34\x23\xbe\x3a\x27\x31\x3c\xa9\xe2\x3b\x87\x33\x29\xbe\x03\xa7\x4f\xfb\xe4\xf1\xe6\x4c\x7c\x87\xcf\xf8\x0e\x8c\x70\xf0\x74\xc9\xc3\xb9\xc3\x20\x47\x0e\x08\x69\x5e\x27\x19\x2f\xd2\x93\x8b\xc1\x53\xfd\xf9\x69\x0e\xae\x90\x25\xb1\xf7\x40\x76\x0e\xd7\x0f\x0b\x44\x4b\xd8\x76\x0e\xfa\x2d\x5b\xbe\x77\xe5\xde\xe4\x9f\xd3\x9b\x1e\xdb\x93\x6b\xb7\x7d\x24\x54\x09\xe6\x72\x15\xbd\x0d\x1d\xac\x01\xaf\xd3\x8f\x57\x1d\x2a\x32\xb1\x95\x89\xa7\xfa\xe5\x7d\xfe\x72\x9a\xbf\x03\x3b\xbb\x74\xc1\x52\x26\x33\x97\x6b\x1d\x25\x26\x64\xb1\x17\x54\xa3\xd9\xa9\x94\x84\xaf\xf6\x8f\xe0\x9e\x0c\x73\x64\x25\x79\x74\x18\x4a\xb7\x88\x90\x41\x1a\x34\xe3\x05\xd0\xad\x1c\x7c\x6a\x1e\xa6\x7f\x75\xdd\x65\xe2\x6d\x89\x0a\x1c\x5e\xa7\x50\x62\x42\xe6\x78\x41\x35\xee\x26\x46\x23\xc9\x9c\xf8\xf8\xd1\xb5\x18\xac\x68\x4c\x97\xc2\xe5\x86\xf8\x02\x11\x9c\xf0\xd4\x69\xc6\x9b\x55\x58\x39\x78\x66\x1f\xe0\x53\x6e\x0e\xef\x7c\x29\x0f\x13\xbd\x72\x96\xad\xe7\x9d\x2f\x07\x4f\x75\xed\x41\x1c\x48\x61\xa7\x3b\x30\x3a\x36\x60\x1c\xb4\xff\x62\xe0\x5a\x63\x22\xf1\x35\x7c\x2c\xaf\x7a\x65\x95\x8b\x32\x96\xe0\x5e\x9b\xda\xa5\x55\x7d\x4f\xbf\x94\xac\x1e\xc9\xd8\xd8\x36\xd3\x72\xf0\x37\x2a\xd5\xa0\x59\xc8\x9e\xeb\x34\x63\xa0\xef\x89\x02\x6f\xeb\x72\x3b\xa0\xc1\x03\xfd\x4e\x95\x62\xa8\xd1\x73\xe6\xf1\xb7\x12\x46\x01\xde\x4a\xfc\x03\x3e\x40\x1a\x39\x3c\xaf\x46\x22\xf0\xb8\x5a\x99\x3c\xd6\x21\x2d\xad\xf2\x69\x04\x1e\x55\x33\x17\xb2\xf2\x78\xbe\x76\x58\x5f\x4a\x4c\x48\xfd\x17\x54\x63\x75\xc9\xa5\x20\x7c\x9e\x3f\x9e\xad\xc1\x4a\x30\x27\x92\xfe\xe9\x30\x6e\x94\xe3\x59\xb2\xf6\x5b\xb9\xaa\x14\x43\x2f\xdb\x32\xbc\xf8\xcc\x7c\xc0\x41\xe5\x67\x87\x9e\x36\x7e\x5e\x40\x1a\x95\xc9\x03\xd5\x89\x9f\x17\xf8\xe6\xdf\x4b\x50\x91\x3c\x5a\xe9\x70\x53\x99\xc1\x83\x2a\x6b\x8d\x62\xac\x8a\x9a\x0b\xc1\x79\xd8\x15\x1c\x51\x47\xcc\x61\xa4\x5c\xa3\x81\xa3\xe8\x32\xfd\xad\x5b\x0a\x34\xd4\x75\xb9\x72\x92\xbf\xf8\x79\xe0\x4a\xb0\xe6\xc5\x97\x11\x13\xc3\x4e\xfd\x14\x5c\xd7\x2f\xd7\x60\xfa\xb2\xfe\x4c\xe0\x88\x59\xa9\xbb\xc3\x3a\xba\xc7\x04\xeb\x69\x93\x6a\xb4\xba\x5a\xb6\xd8\xd2\x14\x50\x9d\xdd\xd2\xb9\xe4\xc1\x8a\x2a\xef\x41\x8a\xe3\x3f\xfe\x74\x67\x99\x26\x32\x64\x9f\x57\x68\x1d\x0f\x3a\xf6\x52\x70\x2e\x05\x5f\xfb\xdf\x8e\xff\xf8\xf3\x07\x9d\xfb\xe6\x75\xd7\x61\x8e\x15\x4b\xa9\x64\x8e\x0f\x74\x58\x50\x70\x44\xf2\x82\x6c\xf8\xb1\xb3\x12\xc2\x5b\x30\x41\x23\x2e\x7f\xc9\x76\x3e\x2b\x13\x7f\xcd\x3f\x87\x1d\x3e\xdb\x4a\x5c\xe4\xb5\x00\xb8\xb4\xdf\xc1\x89\x1c\xd9\x39\x8c\x11\x6b\x34\xa8\xef\xac\xa4\xf7\x33\x4f\xba\xa1\x42\x51\x81\x35\x23\xbe\x26\xbb\x79\xe7\x06\xd0\x95\xcb\x99\xa9\x05\xec\xac\x6f\xe3\xcf\x50\x4d\xfd\x48\x24\xfe\x3a\x05\x0f\x11\xed\x5c\xdf\x51\xb0\xab\x5d\x41\xf0\xfa\x5e\x82\x3a\x9d\x87\xea\xdf\x07\x8e\x9f\x2c\x33\xee\xeb\xde\x5a\x58\x7f\xe6\xb7\x19\x80\xd5\x45\xb1\xc4\xe9\x6a\xbd\x86\x83\xaa\x4a\x95\x60\xbc\xb8\x95\x16\x82\x67\xfa\x7f\xf7\x79\x3b\x87\xc7\x2f\x2d\x60\x57\x53\x29\x49\x46\x3e\x6f\xf7\x3b\xbe\x38\x07\x8f\x60\x3e\xb3\xcc\x0b\xe9\x22\x26\x4e\xb7\x6c\x54\x51\xa1\x46\xb3\x7c\x66\x59\x83\xce\x5c\x4e\xd8\x78\x37\xb0\xe1\x14\xdc\xf8\xf3\x33\xcb\x3e\xd9\x2f\x03\x5b\xd0\x1e\xe3\xdf\x57\x21\x1a\x9d\xbe\xe4\xa9\xdb\x8b\x86\x0b\x44\x4b\xd8\xb2\xc6\xd6\xa0\xe8\x63\xa6\x82\xc5\xf4\x2a\x1d\x77\x0d\x9b\x5b\x37\x1e\x1d\x3b\x12\xf9\xd8\x7d\x55\xe9\xe3\xaf\xb9\xaa\xf4\x51\x62\xff\xb1\xf3\x16\x32\xe6\xd2\x91\x58\xc0\x2e\x0b\xb0\xf1\x23\xfb\xda\x02\x8c\x24\xf8\xea\x74\xda\x66\x81\x95\x97\xff\xf8\x87\xd7\x6f\x6f\x31\xf4\x93\x14\x15\xa0\x36\x01\x4b\xc1\xf9\xa6\xc7\x15\x9a\x3d\x44\xe4\x50\x6d\x42\x56\x5c\xc5\xac\xc7\xaa\x66\x0f\x21\x39\x54\x9b\x90\x87\x1e\x4d\xa5\x87\x80\x07\xd9\x06\xde\xeb\xe8\x52\x0f\xf4\x5d\x7b\x29\xe8\xca\xe3\x26\xf7\x64\x43\x6a\x02\x8a\x5f\x02\x49\xc8\x5b\x0b\xa0\x8a\xd4\x2a\xa2\xfe\x0b\x23\x6f\x13\x52\xf9\xc9\x90\x17\x49\xbd\x8e\x62\xf7\x12\x52\x1c\xaa\x6e\x26\x6c\xe9\x3c\xe2\xbc\xc7\x9d\x18\x7d\xa4\x58\xb0\x56\x41\xd5\xdf\x81\x79\x9b\x94\xfd\x2f\xbd\x34\x13\x56\x29\x51\xba\xb3\x72\x22\xc5\x82\x15\x83\x8a\x96\xdf\x4c\xe9\xf7\xab\x35\x6d\x32\xf6\xbb\xe5\x6b\x32\xde\x8e\xf7\x4a\x07\xe8\xc0\x2c\xb5\x8c\xb6\x6f\xec\xaf\x91\xf4\x5f\x9e\x18\xdb\xb2\xb9\x4d\x2c\xf4\xdb\x7d\xcc\x6b\xa6\x6e\x1d\x36\x55\x52\x9b\x3f\xf5\x84\x90\x2d\x15\xf4\x4e\xdb\xe8\xdd\xc4\x66\xe9\xcd\x1e\xaa\x91\xc1\x8a\xa7\x6a\xcd\x62\x2d\x1d\xc8\xa4\x29\xb2\x3c\x97\x2b\xf5\x46\xf7\xd3\xc8\x62\xc5\xcf\xb5\x66\x71\xa5\xe4\xa0\xfc\xbd\xd5\x3b\x36\xb2\xf7\x20\xa1\x71\xf1\x90\xe2\x7d\xb3\x67\x6d\xe4\x6c\x07\xd5\xbd\xdd\xb0\xaa\xf7\x76\xb7\xdc\x34\x5b\xe1\x9e\xdb\x0d\x57\xa6\x76\x17\xea\xff\x02\x00\x00\xff\xff\x81\xe7\x22\x94\x97\x72\x00\x00"),
		},
		"/cr-example.yaml": &vfsgen۰CompressedFileInfo{
			name:             "cr-example.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1411,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x54\xc1\x6e\xdb\x46\x10\xbd\xf3\x2b\x5e\xcd\x83\x64\xc0\xa6\x9c\x1e\x55\x18\x81\xe2\xd8\x35\x91\x40\x02\x4c\x25\x41\x50\xf4\xb0\xe6\x8e\xc8\x41\xc8\x1d\x76\x76\x69\x5a\x68\xfb\xef\xc5\x92\x52\x23\xb5\xd7\xec\x49\xda\x99\x7d\xf3\xde\xbe\xb7\x4c\x71\xfd\xe3\x56\x92\xe2\x23\x97\xe4\x3c\x59\x04\x41\xa8\x09\xab\xce\x94\x35\xa1\x90\x5d\x18\x8c\x12\x1e\xa4\x77\xd6\x04\x16\x87\xf9\xaa\x78\xb8\x44\xef\x2c\x29\xc4\x11\x44\xd1\x8a\x52\x92\xa2\x14\x17\x94\x9f\xfb\x20\x8a\x66\x02\x84\xa9\x94\xa8\x25\x17\x7c\x06\x14\x44\x23\xfa\x7a\xb3\xcd\xef\xee\xb1\xe3\x86\x60\xd9\x4f\x87\xc8\x62\xe0\x50\x27\x29\x42\xcd\x1e\x83\xe8\x37\xec\x44\x61\xac\xe5\x38\xd8\x34\x60\xb7\x13\x6d\x27\x1a\x4a\x95\x51\xcb\xae\x42\x29\xdd\x5e\xb9\xaa\x03\x64\x70\xa4\xbe\xe6\x2e\x4b\x52\x6c\xa3\x8c\xe2\xe1\xc8\xc4\x4f\xb0\xe3\xcc\x20\xf8\x2a\xfd\x41\xc3\x89\xdc\xc3\x2d\x5c\xe1\x33\xa9\x8f\x43\x7e\xce\x6e\x92\x14\xf3\xd8\x72\x71\x28\x5e\x5c\xfe\x82\xbd\xf4\x68\xcd\x1e\x4e\x02\x7a\x4f\x27\xc8\xf4\x5a\x52\x17\xc0\x0e\xa5\xb4\x5d\xc3\xc6\x95\xf4\x5d\xd6\xbf\x13\x32\x8c\x04\x22\x86\x3c\x07\xc3\x0e\x66\x94\x01\xd9\x9d\xb6\xc1\x84\x24\x4d\x52\x8c\xab\x0e\xa1\x5b\x2e\x16\xc3\x30\x64\x66\xa4\x9b\x89\x56\x8b\xa3\xba\xc5\xc7\xfc\xee\x7e\x5d\xdc\x5f\x8f\x94\x93\x14\x9f\x5c\x43\xde\x43\xe9\x8f\x9e\x95\x2c\x9e\xf7\x30\x5d\xd7\x70\x69\x9e\x1b\x42\x63\x86\x68\xdc\xe8\xce\x68\x3a\x3b\x0c\xca\x81\x5d\x75\x05\x7f\x70\x3d\x49\xcf\xdc\xf9\x7e\x5d\x47\x7a\xec\xcf\x1a\xc4\xc1\x38\x5c\xac\x0a\xe4\xc5\x05\xde\xad\x8a\xbc\xb8\x4a\x52\x7c\xc9\xb7\x8f\x9b\x4f\x5b\x7c\x59\x3d\x3d\xad\xd6\xdb\xfc\xbe\xc0\xe6\x09\x77\x9b\xf5\xfb\x7c\x9b\x6f\xd6\x05\x36\x0f\x58\xad\xbf\xe2\x43\xbe\x7e\x7f\x05\xe2\x50\x93\x82\x5e\x3b\x8d\xfc\x45\xc1\xf1\x22\xc9\x46\x4f\x8f\x01\x3a\x12\x88\xf9\x88\xff\x7d\x47\x25\xef\xb8\x44\x63\x5c\xd5\x9b\x8a\x50\xc9\x0b\xa9\x8b\xf1\xe8\x48\x5b\xf6\xd1\x4e\x0f\xe3\x6c\x92\xa2\xe1\x96\xc3\x98\x22\xff\x7f\x51\x71\xcc\x8f\x7c\x5b\x89\xe9\xf8\x10\xa7\x25\x4a\xd3\x52\x73\x6a\xdf\xcb\x9b\xe4\x1b\x3b\xbb\x44\xee\x02\x55\x3a\x92\x4a\x5a\x0a\xc6\x9a\x60\x96\x09\xe0\x4c\x4b\x4b\xd0\xab\x69\xbb\x86\x92\xa8\x33\xee\x7a\xe9\xb5\x24\x1f\x7f\x5e\x8f\xcf\x8e\x5c\x58\xe2\xaf\xeb\x64\x8a\xca\x62\x81\x6d\x8c\x24\x7b\xdc\xc5\x89\xf8\x80\x5f\x55\xe4\x65\x7f\x04\x82\x4a\x1f\x28\x39\xb4\xab\xb3\xb8\x85\xa3\x01\x4f\xc6\x59\x69\xe7\x97\xc7\xca\x4e\xa5\x9d\xcf\x02\xb7\xa4\xcb\x6a\x44\x78\xdb\x91\xb2\xd8\xdb\x37\x37\x37\x37\xb3\xcb\x43\x5b\x5c\xd9\x08\x99\xdb\xf9\x6c\x6a\x3c\x2f\x7a\x0a\xef\xc4\xee\xe7\xa7\x9b\x63\xa1\x14\xe7\x83\x71\x61\x3e\x7b\xa4\xa6\x91\x23\xdf\x9f\xce\x8f\x77\x2a\x65\x4c\xc3\x9f\xff\x39\xce\x21\x63\x97\xd5\x64\x2c\xa9\xff\x6d\x36\xd1\xff\x6c\x9a\x9e\x66\xbf\xe3\x36\x0a\xcb\x1c\xbd\x86\xdc\x85\xb3\xc9\x7f\x9f\x62\x07\x99\xcf\x1a\xa9\x96\xf1\xe3\xf2\xd6\xd7\x32\x3c\x4e\x70\xb7\x41\x7b\x3a\xd0\x98\x5c\x18\x15\xfa\x6c\xd2\x97\xfc\x13\x00\x00\xff\xff\x19\x6c\xe5\xa5\x83\x05\x00\x00"),
		},
		"/crd-build.yaml": &vfsgen۰CompressedFileInfo{
			name:             "crd-build.yaml",
			modTime:          time.Time{},
			uncompressedSize: 2190,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x55\x4d\x6f\xdb\x46\x13\xbe\xf3\x57\x3c\x30\x2f\x09\x60\x51\x6f\xde\xb6\x40\xc0\x9e\x14\xd9\x46\xd5\x18\x92\x61\x2a\x0d\x72\x1c\x91\x23\x72\x61\x72\x97\xdd\x9d\x15\x2d\x14\xfd\xef\xc5\xae\x28\x4b\xaa\x6b\xf4\xd0\xf0\xc6\xdd\x99\x79\x3e\x66\x38\x4c\x31\xf9\x7e\x4f\x92\xe2\x5e\x95\xac\x1d\x57\x10\x03\x69\x18\xb3\x9e\xca\x86\x51\x98\xad\x0c\x64\x19\x77\xc6\xeb\x8a\x44\x19\x8d\x77\xb3\xe2\xee\x3d\xbc\xae\xd8\xc2\x68\x86\xb1\xe8\x8c\xe5\x24\x45\x69\xb4\x58\xb5\xf1\x62\x2c\xda\x43\x41\x50\x6d\x99\x3b\xd6\xe2\x32\xa0\x60\x8e\xd5\x97\xab\xf5\x62\x7e\x8b\xad\x6a\x19\x95\x72\x87\x24\xae\x30\x28\x69\x92\x14\xd2\x28\x87\xc1\xd8\x27\x6c\x8d\x05\x55\x95\x0a\xc0\xd4\x42\xe9\xad\xb1\xdd\x81\x86\xe5\x9a\x6c\xa5\x74\x8d\xd2\xf4\x7b\xab\xea\x46\x60\x06\xcd\xd6\x35\xaa\xcf\x92\x14\xeb\x20\xa3\xb8\x3b\x32\x71\x87\xb2\x11\x53\x0c\xbe\x19\x3f\x6a\x38\x93\x3b\xba\x70\x8d\xdf\xd8\xba\x00\xf2\xff\xec\x7f\x49\x8a\x77\x21\xe4\x6a\xbc\xbc\x7a\xff\x33\xf6\xc6\xa3\xa3\x3d\xb4\x11\x78\xc7\x67\x95\xf9\xb9\xe4\x5e\xa0\x34\x4a\xd3\xf5\xad\x22\x5d\xf2\x49\xd6\x0b\x42\x86\x48\x20\xd4\x30\x1b\x21\xa5\x41\x51\x06\xcc\xf6\x3c\x0c\x24\x49\x9a\xa4\x88\x4f\x23\xd2\xe7\xd3\xe9\x30\x0c\x19\x45\xba\x99\xb1\xf5\xf4\xa8\x6e\x7a\xbf\x98\xdf\x2e\x8b\xdb\x49\xa4\x9c\xa4\xf8\xa2\x5b\x76\x0e\x96\x7f\xf7\xca\x72\x85\xcd\x1e\xd4\xf7\xad\x2a\x69\xd3\x32\x5a\x1a\x42\xe3\x62\x77\x62\xd3\x95\xc6\x60\x95\x28\x5d\x5f\xc3\x8d\x5d\x4f\xd2\x8b\xee\x9c\xec\x3a\xd2\x53\xee\x22\xc0\x68\x90\xc6\xd5\xac\xc0\xa2\xb8\xc2\xa7\x59\xb1\x28\xae\x93\x14\x5f\x17\xeb\x5f\x56\x5f\xd6\xf8\x3a\x7b\x7c\x9c\x2d\xd7\x8b\xdb\x02\xab\x47\xcc\x57\xcb\x9b\xc5\x7a\xb1\x5a\x16\x58\xdd\x61\xb6\xfc\x86\xcf\x8b\xe5\xcd\x35\x58\x49\xc3\x16\xfc\xdc\xdb\xc0\xdf\x58\xa8\x60\x24\x57\xa1\xa7\xc7\x01\x3a\x12\x08\xf3\x11\xde\x5d\xcf\xa5\xda\xaa\x12\x2d\xe9\xda\x53\xcd\xa8\xcd\x8e\xad\x0e\xe3\xd1\xb3\xed\x94\x0b\xed\x74\x20\x5d\x25\x29\x5a\xd5\x29\x89\x53\xe4\x5e\x8b\x0a\x30\xdf\xf3\xdb\x4a\xa8\x57\xe3\x38\xe5\xa0\x5e\xf1\xb3\xb0\x8e\x6c\xb2\xa7\x8f\x2e\x53\x66\xba\xfb\xb0\x61\xa1\x0f\xc9\x93\xd2\x55\x8e\xb9\x77\x62\xba\x47\x76\xc6\xdb\x92\x6f\x78\xab\x74\x1c\xff\xa4\x63\xa1\x8a\x84\xf2\x04\xd0\xd4\x71\x8e\x8d\x57\x6d\xe5\xb2\x92\x3a\x6e\xcf\x66\x22\x01\x5a\xda\x70\xeb\x42\x24\x42\xd7\x73\x5c\xc5\xa0\xc9\xd3\x55\x12\xac\x0a\x17\xb5\x35\xbe\xcf\xf1\x0f\xc9\xae\x34\x3d\xe7\x58\x52\xc7\xae\xa7\x92\xab\x04\xd8\x1d\x15\xec\x3e\x9c\xde\x22\xc0\x64\x24\x13\x2f\x00\xc7\x76\xc7\x55\x0e\xb1\x9e\x0f\x07\x62\x2c\xd5\xfc\x72\x72\x8a\xa7\xb6\x6f\xe8\xdf\xb2\xb6\xd4\x3a\x1e\x15\x8f\x82\x0e\x3e\x7d\x0a\xe2\xe3\x7b\xab\x9c\x7c\x3e\x9d\xdd\x2b\x27\xf1\xbc\x6f\xbd\xa5\xf6\x68\xd3\xa1\xac\xd2\xb5\x6f\xc9\x8e\x87\x41\xac\xdf\xd8\xd1\xeb\xb1\xbc\x13\x12\xef\x72\xfc\xf1\x67\x82\xb3\xe5\xf3\x60\x95\x16\xb6\x73\xd3\xfa\x4e\x8f\xa1\x47\x2d\x0f\x0d\xb9\x03\x6f\x40\xf6\xc1\xbc\xf0\x51\xe8\x7a\x3c\xaa\xd8\x95\x56\xf5\x12\x0d\x0c\x6b\x29\x82\xa3\x3f\xcb\xfa\xb5\x58\x2d\x1f\x48\x9a\x1c\xd9\x01\x3f\x3b\xdd\x1e\x51\x66\xf5\x25\x46\x45\xc2\x6f\x21\x88\xea\xc2\xf6\xc0\xd0\xa8\xb2\x89\xe3\x7d\xc0\x1c\xc8\xa1\xb4\x4c\xc2\xd5\x6b\xe4\xe3\x84\x65\x31\x42\x19\xbd\x56\x1d\x3b\xa1\xae\xbf\xe0\x51\x08\xd9\x53\xfe\x7f\xe3\xd2\x92\x13\xbc\xb3\x3c\x79\xef\x2e\xaa\xbe\xf6\x63\xbc\x9f\xc9\x05\x97\x1b\x6f\x23\xd3\xb7\xcd\x4f\x31\x6f\x48\xd7\x8c\xa1\x61\x8d\xf9\xe3\x4d\xd8\xd8\x0e\xab\x9e\xf5\xec\x61\x11\x37\x07\x76\x3f\xbc\x04\x87\x2d\xeb\xf2\xe9\xb4\x56\xd2\xf8\x4d\x56\x9a\x6e\xba\x9a\x2d\xa6\x63\xf8\xa4\x18\x17\x4d\x04\x9d\x2a\xe7\x3c\xbb\xe9\xc7\x1f\x7f\x7a\xc9\x3f\xfc\xa0\x72\x54\x97\xc4\xde\x18\x81\x28\x9f\x9f\xb9\xf4\xf1\x9f\xf6\xb7\xa4\xd7\x26\x5c\x04\xbc\xcc\x85\x08\x77\xbd\xb8\x0b\x0f\xc2\xb0\xd6\x6c\xdf\x82\xd7\xbe\xdb\x84\xff\xf7\xf6\x0c\x9d\x2e\xeb\xbc\x46\xdf\x92\x6a\xbd\xe5\xcc\x72\x19\xb6\xeb\x3e\x1b\x33\x92\xbf\x02\x00\x00\xff\xff\xa8\x57\x5a\xdc\x8e\x08\x00\x00"),
		},
		"/crd-camel-catalog.yaml": &vfsgen۰CompressedFileInfo{
			name:             "crd-camel-catalog.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1740,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x54\xc1\x6e\xe3\x36\x10\xbd\xf3\x2b\x1e\xac\xcb\x2e\x90\x28\x4d\x4f\x85\x7b\x72\x9d\x04\x75\x13\xd8\x41\xe4\xed\x62\x8f\x63\x69\x2c\x0d\x42\x91\x2c\x49\xd9\x09\x8a\xfe\x7b\x41\x5a\x4e\xec\x5d\x14\x3d\xec\xea\x46\xce\x9b\x99\xf7\xe6\x8d\x58\xe0\xf2\xc7\x7d\xaa\xc0\x83\xd4\x6c\x02\x37\x88\x16\xb1\x63\xcc\x1c\xd5\x1d\xa3\xb2\xdb\xb8\x27\xcf\xb8\xb3\x83\x69\x28\x8a\x35\xf8\x30\xab\xee\x3e\x62\x30\x0d\x7b\x58\xc3\xb0\x1e\xbd\xf5\xac\x0a\xd4\xd6\x44\x2f\x9b\x21\x5a\x0f\x7d\x28\x08\x6a\x3d\x73\xcf\x26\x86\x12\xa8\x98\x73\xf5\xe5\x6a\xbd\x98\xdf\x62\x2b\x9a\xd1\x48\x38\x24\x71\x83\xbd\xc4\x4e\x15\x88\x9d\x04\xec\xad\x7f\xc6\xd6\x7a\x50\xd3\x48\x6a\x4c\x1a\x62\xb6\xd6\xf7\x07\x1a\x9e\x5b\xf2\x8d\x98\x16\xb5\x75\xaf\x5e\xda\x2e\xc2\xee\x0d\xfb\xd0\x89\x2b\x55\x81\x75\x92\x51\xdd\x1d\x99\x84\x43\xd9\xdc\x33\x5a\x7c\xb1\xc3\xa8\xe1\x44\xee\x38\x85\x0b\xfc\xc9\x3e\xa4\x26\x3f\x97\x3f\xa9\x02\x1f\x12\x64\x32\x06\x27\x1f\x7f\xc5\xab\x1d\xd0\xd3\x2b\x8c\x8d\x18\x02\x9f\x54\xe6\x97\x9a\x5d\x84\x18\xd4\xb6\x77\x5a\xc8\xd4\xfc\x2e\xeb\xad\x43\x89\x4c\x20\xd5\xb0\x9b\x48\x62\x40\x59\x06\xec\xf6\x14\x06\x8a\xaa\x50\x05\xf2\xd7\xc5\xe8\xa6\x57\x57\xfb\xfd\xbe\xa4\x4c\xb7\xb4\xbe\xbd\x3a\xaa\xbb\x7a\x58\xcc\x6f\x97\xd5\xed\x65\xa6\xac\x0a\x7c\x32\x9a\x43\x80\xe7\xbf\x06\xf1\xdc\x60\xf3\x0a\x72\x4e\x4b\x4d\x1b\xcd\xd0\xb4\x4f\xc6\x65\x77\xb2\xe9\x62\xb0\xf7\x12\xc5\xb4\x17\x08\xa3\xeb\xaa\x38\x73\xe7\x7d\x5c\x47\x7a\x12\xce\x00\xd6\x80\x0c\x26\xb3\x0a\x8b\x6a\x82\xdf\x66\xd5\xa2\xba\x50\x05\x3e\x2f\xd6\xbf\xaf\x3e\xad\xf1\x79\xf6\xf4\x34\x5b\xae\x17\xb7\x15\x56\x4f\x98\xaf\x96\x37\x8b\xf5\x62\xb5\xac\xb0\xba\xc3\x6c\xf9\x05\xf7\x8b\xe5\xcd\x05\x58\x62\xc7\x1e\xfc\xe2\x7c\xe2\x6f\x3d\x24\x0d\x92\x9b\xe4\xe9\x71\x81\x8e\x04\xd2\x7e\xa4\x73\x70\x5c\xcb\x56\x6a\x68\x32\xed\x40\x2d\xa3\xb5\x3b\xf6\x26\xad\x87\x63\xdf\x4b\x48\x76\x06\x90\x69\x54\x01\x2d\xbd\xc4\xbc\x45\xe1\x5b\x51\xa9\xcd\x8f\xfc\xb7\x14\x39\x19\xd7\x69\x0a\x72\xc2\x2f\x91\x4d\x66\x53\x3e\xff\x12\x4a\xb1\x57\xbb\xeb\x0d\x47\xba\x56\xcf\x62\x9a\x29\xe6\x43\x88\xb6\x7f\xe2\x60\x07\x5f\xf3\x0d\x6f\xc5\xe4\xf5\x57\x3d\x47\x6a\x28\xd2\x54\x01\x86\x7a\x9e\xa2\xa6\x9e\x75\x4d\x91\xb4\x6d\x43\x99\x4f\x27\xab\xa1\x00\x4d\x1b\xd6\x21\x25\x20\x99\x3f\xc5\x24\x83\x2e\x9f\x27\x2a\x4d\x2c\x05\x5a\x6f\x07\x37\x96\x3a\x4f\x4e\x3d\xc6\xdc\x91\x59\xc2\xcc\x0f\xed\xf2\xb5\x96\x10\xef\xbf\x09\x3d\x48\x88\x39\xec\xf4\xe0\x49\x7f\x45\x33\x47\x82\x98\x76\xd0\xe4\xcf\x63\x87\x50\x67\x7d\x5c\xbe\xb7\x06\x2e\x51\xd7\x0a\x08\xb5\x75\x3c\x45\x0e\x39\xaa\xb9\x51\xc0\xee\x38\xd7\xdd\xf5\xfb\x29\x27\x5e\x8e\x23\xca\x01\x20\xb0\xdf\x71\x33\x45\xf4\x03\x1f\x2e\xa2\xf5\xd4\xf2\xdb\xcd\x3b\x9e\xb4\xeb\xe8\xff\xb2\xb6\xa4\x43\xba\x0a\xc3\xc6\x8f\x4e\x8d\x7c\x43\xa4\x38\x84\x29\xfe\xfe\x47\xe1\xe4\xe9\x7a\xf4\x62\x22\xfb\xb9\xd5\x43\x6f\x46\xe8\xb1\xe7\xd3\x60\xa2\xf4\x7c\x7c\x74\x46\xd9\xf1\x35\xc9\x4d\x3f\x97\x69\xc7\xab\x86\x43\xed\xc5\xc5\x2c\x39\x3d\x6f\x79\xec\xb8\x7f\xab\xb0\x3b\xab\xf0\x47\xb5\x5a\x3e\x52\xec\xa6\x28\x93\xdb\xa5\x3f\xa0\xca\x53\xd4\xd7\x1c\x1e\xbd\xdd\x49\xc3\xfe\x3b\x48\xb8\xf3\x12\xff\xc5\xe2\x0d\xa6\xfe\x0d\x00\x00\xff\xff\x1f\x93\x33\xc8\xcc\x06\x00\x00"),
		},
		"/crd-integration-kit.yaml": &vfsgen۰CompressedFileInfo{
			name:             "crd-integration-kit.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1844,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x54\x4d\x6f\xe3\x36\x10\xbd\xeb\x57\x3c\x58\x97\x5d\x20\x91\xbb\x3d\x15\xea\xc9\xcd\x07\xaa\x26\xb0\x83\xc8\xdb\xc5\x02\xb9\x8c\xa5\xb1\x34\x30\x45\xb2\x24\x15\xc7\x28\xfa\xdf\x0b\x4a\x72\xec\x34\x0b\xf4\xb0\xab\x9b\x38\x33\x7c\x1f\xf3\xa4\x14\x97\x3f\xee\x49\x52\xdc\x4b\xc5\xda\x73\x8d\x60\x10\x5a\xc6\xc2\x52\xd5\x32\x4a\xb3\x0d\x7b\x72\x8c\x5b\xd3\xeb\x9a\x82\x18\x8d\x0f\x8b\xf2\xf6\x23\x7a\x5d\xb3\x83\xd1\x0c\xe3\xd0\x19\xc7\x49\x8a\xca\xe8\xe0\x64\xd3\x07\xe3\xa0\xc6\x0b\x41\x8d\x63\xee\x58\x07\x9f\x01\x25\xf3\x70\xfb\x72\xb5\x2e\xae\x6e\xb0\x15\xc5\xa8\xc5\x8f\x43\x5c\x63\x2f\xa1\x4d\x52\x84\x56\x3c\xf6\xc6\xed\xb0\x35\x0e\x54\xd7\x12\x81\x49\x41\xf4\xd6\xb8\x6e\xa4\xe1\xb8\x21\x57\x8b\x6e\x50\x19\x7b\x70\xd2\xb4\x01\x66\xaf\xd9\xf9\x56\x6c\x96\xa4\x58\x47\x19\xe5\xed\x91\x89\x1f\xaf\x1d\x30\x83\xc1\x57\xd3\x4f\x1a\xce\xe4\x4e\x2e\x5c\xe0\x4f\x76\x3e\x82\xfc\x9c\xfd\x94\xa4\xf8\x10\x5b\x66\x53\x71\xf6\xf1\x57\x1c\x4c\x8f\x8e\x0e\xd0\x26\xa0\xf7\x7c\x76\x33\xbf\x54\x6c\x03\x44\xa3\x32\x9d\x55\x42\xba\xe2\x93\xac\x57\x84\x0c\x03\x81\x78\x87\xd9\x04\x12\x0d\x1a\x64\xc0\x6c\xcf\xdb\x40\x21\x49\x93\x14\xc3\xd3\x86\x60\xf3\xf9\x7c\xbf\xdf\x67\x34\xd0\xcd\x8c\x6b\xe6\x47\x75\xf3\xfb\xe2\xea\x66\x59\xde\x5c\x0e\x94\x93\x14\x9f\xb5\x62\xef\xe1\xf8\xaf\x5e\x1c\xd7\xd8\x1c\x40\xd6\x2a\xa9\x68\xa3\x18\x8a\xf6\x71\x71\xc3\x76\x86\xa5\x8b\xc6\xde\x49\x10\xdd\x5c\xc0\x4f\x5b\x4f\xd2\x37\xdb\x39\xd9\x75\xa4\x27\xfe\x4d\x83\xd1\x20\x8d\xd9\xa2\x44\x51\xce\xf0\xdb\xa2\x2c\xca\x8b\x24\xc5\x97\x62\xfd\xfb\xea\xf3\x1a\x5f\x16\x8f\x8f\x8b\xe5\xba\xb8\x29\xb1\x7a\xc4\xd5\x6a\x79\x5d\xac\x8b\xd5\xb2\xc4\xea\x16\x8b\xe5\x57\xdc\x15\xcb\xeb\x0b\xb0\x84\x96\x1d\xf8\xc5\xba\xc8\xdf\x38\x48\x34\x92\xeb\xb8\xd3\x63\x80\x8e\x04\x62\x3e\xe2\xbb\xb7\x5c\xc9\x56\x2a\x28\xd2\x4d\x4f\x0d\xa3\x31\xcf\xec\x74\x8c\x87\x65\xd7\x89\x8f\xeb\xf4\x20\x5d\x27\x29\x94\x74\x12\x86\x14\xf9\xf7\xa2\x22\xcc\x8f\xfc\xb6\x12\xb2\x32\xc5\x29\x07\x59\xe1\x97\xc0\x7a\x60\x93\xed\x7e\xf1\x99\x98\xf9\xf3\xa7\x0d\x07\xfa\x94\xec\x44\xd7\x39\xae\x7a\x1f\x4c\xf7\xc8\xde\xf4\xae\xe2\x6b\xde\x8a\x1e\xe2\x9f\x74\x1c\xa8\xa6\x40\x79\x02\x68\xea\x38\x87\xe8\xc0\x8d\x1b\x84\xec\x24\xf8\xac\xa2\x8e\xd5\x59\x38\x12\x40\xd1\x86\x95\x8f\x23\x88\xeb\xcf\x31\x1b\x9a\x2e\x77\xb3\x24\x7a\x16\x0b\x8d\x33\xbd\xcd\xf1\x8d\x61\x5f\x19\xcb\x39\x96\xd4\xb1\xb7\x54\x71\x9d\x00\xcf\x47\x29\xcf\x9f\x4e\x6f\x03\xc0\xe5\xc4\x6a\x28\x00\x9e\xdd\x33\xd7\x39\x82\xeb\x79\x3c\x08\xc6\x51\xc3\xaf\x27\xa7\x7e\x52\xb6\xa5\xff\x9b\xda\x92\xf2\xf1\xc8\xf7\x1b\x37\x99\x33\xe9\xf2\x81\x42\xef\x73\xfc\xfd\xcf\xe4\xcc\x74\x3e\xfa\x59\x9c\x4c\xba\x93\x30\x14\x94\xf8\x70\xf7\x8d\xe2\xbd\xf8\xb1\xc1\xaa\xde\x91\x7a\x67\xf0\x88\x26\xba\xe9\x15\xb9\xff\x56\xc7\x62\x6b\x5c\x58\x9e\x28\x5c\x42\x76\x09\xce\x7e\x61\x0f\x2e\x4e\xb9\x2b\xa3\xfa\x4e\xbf\x36\x8d\x46\x3c\xb4\xe4\x47\xd1\x40\x38\x44\xe7\xe3\xa7\xa5\x9b\xe9\xa8\x66\x5f\x39\xb1\x61\x70\x3f\xfe\xdc\xde\x92\x87\x3d\x1b\xff\xa3\x5c\x2d\x1f\x28\xb4\x39\xb2\xd1\x9d\xec\x54\x3d\xc2\xad\x0f\xf6\x3b\xd0\xc2\x69\xfa\x0c\xec\x98\xd1\x6c\xcc\xdd\x98\xc8\xa7\x29\x55\x4f\x31\x56\x4f\xf3\x9d\x84\xa7\xec\x75\xfc\xc8\xa6\xe8\xa8\xf9\x0e\x3a\x72\x36\xfe\x5e\xfc\x58\xfd\x37\x00\x00\xff\xff\x56\x5d\x9b\x74\x34\x07\x00\x00"),
		},
		"/crd-integration-platform.yaml": &vfsgen۰CompressedFileInfo{
			name:             "crd-integration-platform.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1621,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x54\xc1\x6e\xe3\x46\x0c\xbd\xeb\x2b\x1e\xac\xcb\x2e\x90\x28\x4d\x4f\x85\x7a\x72\x9d\x04\x55\x37\x90\x83\xc8\xdb\xc5\x1e\x69\x89\x96\x88\x8c\x66\xa6\x33\x23\x3b\x46\xd1\x7f\x2f\x46\x92\x63\x2f\x9a\x62\x2f\xab\x9b\xc8\x47\xf2\xbd\x47\x4a\x29\xae\x7f\xdc\x93\xa4\x78\x94\x9a\xb5\xe7\x06\xc1\x20\x74\x8c\xa5\xa5\xba\x63\x54\x66\x17\x0e\xe4\x18\x0f\x66\xd0\x0d\x05\x31\x1a\x1f\x96\xd5\xc3\x47\x0c\xba\x61\x07\xa3\x19\xc6\xa1\x37\x8e\x93\x14\xb5\xd1\xc1\xc9\x76\x08\xc6\x41\x4d\x0d\x41\xad\x63\xee\x59\x07\x9f\x01\x15\xf3\xd8\xbd\x5c\x6f\x8a\xd5\x3d\x76\xa2\x18\x8d\xf8\xa9\x88\x1b\x1c\x24\x74\x49\x8a\xd0\x89\xc7\xc1\xb8\x17\xec\x8c\x03\x35\x8d\xc4\xc1\xa4\x20\x7a\x67\x5c\x3f\xd1\x70\xdc\x92\x6b\x44\xb7\xa8\x8d\x3d\x3a\x69\xbb\x00\x73\xd0\xec\x7c\x27\x36\x4b\x52\x6c\xa2\x8c\xea\xe1\xc4\xc4\x4f\x6d\xc7\x99\xc1\xe0\xab\x19\x66\x0d\x17\x72\x67\x17\xae\xf0\x27\x3b\x1f\x87\xfc\x9c\xfd\x94\xa4\xf8\x10\x21\x8b\x39\xb9\xf8\xf8\x2b\x8e\x66\x40\x4f\x47\x68\x13\x30\x78\xbe\xe8\xcc\xaf\x35\xdb\x00\xd1\xa8\x4d\x6f\x95\x90\xae\xf9\x2c\xeb\x6d\x42\x86\x91\x40\xec\x61\xb6\x81\x44\x83\x46\x19\x30\xbb\x4b\x18\x28\x24\x69\x92\x62\x7c\xba\x10\x6c\x7e\x73\x73\x38\x1c\x32\x1a\xe9\x66\xc6\xb5\x37\x27\x75\x37\x8f\xc5\xea\xbe\xac\xee\xaf\x47\xca\x49\x8a\xcf\x5a\xb1\xf7\x70\xfc\xd7\x20\x8e\x1b\x6c\x8f\x20\x6b\x95\xd4\xb4\x55\x0c\x45\x87\xb8\xb8\x71\x3b\xe3\xd2\x45\xe3\xe0\x24\x88\x6e\xaf\xe0\xe7\xad\x27\xe9\x37\xdb\x39\xdb\x75\xa2\x27\xfe\x1b\x80\xd1\x20\x8d\xc5\xb2\x42\x51\x2d\xf0\xdb\xb2\x2a\xaa\xab\x24\xc5\x97\x62\xf3\xfb\xfa\xf3\x06\x5f\x96\xcf\xcf\xcb\x72\x53\xdc\x57\x58\x3f\x63\xb5\x2e\xef\x8a\x4d\xb1\x2e\x2b\xac\x1f\xb0\x2c\xbf\xe2\x53\x51\xde\x5d\x81\x25\x74\xec\xc0\xaf\xd6\x45\xfe\xc6\x41\xa2\x91\xdc\xc4\x9d\x9e\x0e\xe8\x44\x20\xde\x47\x7c\xf7\x96\x6b\xd9\x49\x0d\x45\xba\x1d\xa8\x65\xb4\x66\xcf\x4e\xc7\xf3\xb0\xec\x7a\xf1\x71\x9d\x1e\xa4\x9b\x24\x85\x92\x5e\xc2\x78\x45\xfe\xbf\xa2\xe2\x98\x1f\xf9\x6d\x25\x64\x65\x3e\xa7\x1c\x64\x85\x5f\x03\xeb\x91\x4d\xf6\xf2\x8b\xcf\xc4\xdc\xec\x6f\xb7\x1c\xe8\x36\x79\x11\xdd\xe4\x58\x0d\x3e\x98\xfe\x99\xbd\x19\x5c\xcd\x77\xbc\x13\x3d\x9e\x7f\xd2\x73\xa0\x86\x02\xe5\x09\xa0\xa9\xe7\x1c\xa2\x03\xb7\x6e\x14\x62\x15\x85\xf8\x6d\xf8\xac\xa6\x9e\xd5\xc5\x85\x24\x80\xa2\x2d\x2b\x1f\xeb\x10\x6f\x20\xc7\x62\x04\x5d\xbf\x2c\x92\x68\x5c\x4c\xb4\xce\x0c\x36\xc7\x3b\xc5\xbe\x36\x96\x73\x94\xd4\xb3\xb7\x54\x73\x93\x00\xfb\x93\x9e\xfd\xed\xf9\x6d\x1c\x70\x3d\x53\x1b\x13\x80\x67\xb7\xe7\x26\x47\x70\x03\x4f\x81\x60\x1c\xb5\xfc\x16\x39\xe3\x49\xd9\x8e\xbe\x57\xb5\x23\xe5\x63\xc8\x0f\x5b\x37\x3b\x34\xeb\xf2\x81\xc2\xe0\x73\xfc\xfd\xcf\x6c\xcf\x1c\x9f\x4c\x2d\xce\x4e\x3d\xcd\x4e\x8d\x59\x25\x3e\x7c\xfa\x3f\xc4\xa3\xf8\x30\xa2\xac\x1a\x1c\xa9\xf7\xfd\x9e\x86\x8b\x6e\x07\x45\xee\x5d\xc8\x84\xe8\x8c\x0b\xe5\x99\xd6\x35\xc4\x26\xb8\xf8\xb7\x3d\xb9\x58\xea\x56\x46\x0d\xbd\x7e\x03\x4d\xe6\x3c\x75\xe4\x27\x23\x80\x70\x8c\xdb\x88\xdf\x9c\x6e\xe7\x50\xc3\xbe\x76\x62\xc3\xb8\x91\xf8\xd7\x7b\x47\x0b\xec\x45\x8f\x3f\xaa\x75\xf9\x44\xa1\xcb\x91\x4d\xb6\x65\x53\xf6\xdf\x00\x00\x00\xff\xff\xaa\xf7\xbe\x6c\x55\x06\x00\x00"),
		},
		"/crd-integration.yaml": &vfsgen۰CompressedFileInfo{
			name:             "crd-integration.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1880,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x55\xcd\x6e\xe3\x46\x13\xbc\xf3\x29\x0a\xe2\x65\x17\xb0\xe9\xcf\xdf\x29\x60\x4e\x8a\x7f\x10\xc5\x86\x64\x88\xda\x2c\xf6\xd8\x22\x5b\x64\xc3\xc3\x99\xc9\xcc\xd0\xb2\x11\xe4\xdd\x83\x19\x52\x96\xb4\x9b\x45\x80\x60\x75\x63\xff\x55\x55\x57\x93\xca\x71\xf9\xe3\x7e\x59\x8e\x47\xa9\x59\x7b\x6e\x10\x0c\x42\xc7\x98\x5b\xaa\x3b\x46\x65\x76\x61\x4f\x8e\x71\x6f\x06\xdd\x50\x10\xa3\xf1\x61\x5e\xdd\x7f\xc4\xa0\x1b\x76\x30\x9a\x61\x1c\x7a\xe3\x38\xcb\x51\x1b\x1d\x9c\x6c\x87\x60\x1c\xd4\x38\x10\xd4\x3a\xe6\x9e\x75\xf0\x05\x50\x31\xa7\xe9\xcb\xd5\x66\x71\x73\x87\x9d\x28\x46\x23\x7e\x6c\xe2\x06\x7b\x09\x5d\x96\x23\x74\xe2\xb1\x37\xee\x19\x3b\xe3\x40\x4d\x23\x11\x98\x14\x44\xef\x8c\xeb\x47\x1a\x8e\x5b\x72\x8d\xe8\x16\xb5\xb1\x6f\x4e\xda\x2e\xc0\xec\x35\x3b\xdf\x89\x2d\xb2\x1c\x9b\x28\xa3\xba\x3f\x30\xf1\xe3\xd8\x84\x19\x0c\xbe\x98\x61\xd2\x70\x22\x77\xda\xc2\x05\x7e\x67\xe7\x23\xc8\xff\x8b\xff\x65\x39\x3e\xc4\x92\xd9\x94\x9c\x7d\xfc\x19\x6f\x66\x40\x4f\x6f\xd0\x26\x60\xf0\x7c\x32\x99\x5f\x6b\xb6\x01\xa2\x51\x9b\xde\x2a\x21\x5d\xf3\x51\xd6\x3b\x42\x81\x44\x20\xce\x30\xdb\x40\xa2\x41\x49\x06\xcc\xee\xb4\x0c\x14\xb2\x3c\xcb\x91\x7e\x5d\x08\xb6\xbc\xba\xda\xef\xf7\x05\x25\xba\x85\x71\xed\xd5\x41\xdd\xd5\xe3\xe2\xe6\x6e\x59\xdd\x5d\x26\xca\x59\x8e\x4f\x5a\xb1\xf7\x70\xfc\xc7\x20\x8e\x1b\x6c\xdf\x40\xd6\x2a\xa9\x69\xab\x18\x8a\xf6\xd1\xb8\xe4\x4e\x32\x5d\x34\xf6\x4e\x82\xe8\xf6\x02\x7e\x72\x3d\xcb\xcf\xdc\x39\xae\xeb\x40\x4f\xfc\x59\x81\xd1\x20\x8d\xd9\xbc\xc2\xa2\x9a\xe1\x97\x79\xb5\xa8\x2e\xb2\x1c\x9f\x17\x9b\x5f\x57\x9f\x36\xf8\x3c\x5f\xaf\xe7\xcb\xcd\xe2\xae\xc2\x6a\x8d\x9b\xd5\xf2\x76\xb1\x59\xac\x96\x15\x56\xf7\x98\x2f\xbf\xe0\x61\xb1\xbc\xbd\x00\x4b\xe8\xd8\x81\x5f\xad\x8b\xfc\x8d\x83\xc4\x45\x72\x13\x3d\x3d\x1c\xd0\x81\x40\xbc\x8f\xf8\xec\x2d\xd7\xb2\x93\x1a\x8a\x74\x3b\x50\xcb\x68\xcd\x0b\x3b\x1d\xcf\xc3\xb2\xeb\xc5\x47\x3b\x3d\x48\x37\x59\x0e\x25\xbd\x84\x74\x45\xfe\x5b\x51\x11\xe6\x47\xbe\x5b\x19\x59\x99\xce\xa9\x04\x59\xe1\xd7\xc0\x3a\xb1\x29\x9e\x7f\xf2\x85\x98\xab\x97\xeb\x2d\x07\xba\xce\x9e\x45\x37\x25\x6e\x06\x1f\x4c\xbf\x66\x6f\x06\x57\xf3\x2d\xef\x44\xa7\xf3\xcf\x7a\x0e\xd4\x50\xa0\x32\x03\x34\xf5\x5c\x42\x74\xe0\xd6\x8d\x42\x8a\x9a\x7a\x56\x27\x97\x91\x01\x8a\xb6\xac\x7c\xac\x47\xf4\xbe\xc4\x2c\x15\x5d\x3e\xcf\xb2\xb8\xb0\x98\x68\x9d\x19\x6c\x89\x7f\x68\xf6\xb5\xb1\x5c\x62\x49\x3d\x7b\x4b\x35\x37\x19\xf0\x72\xd0\xf1\x72\x7d\x7c\x4a\x00\x97\x13\xa5\x94\x00\x3c\xbb\x17\x6e\x4a\x04\x37\xf0\x18\x08\xc6\x51\xcb\xef\x91\x63\x3d\x29\xdb\xd1\xbf\x75\xed\x48\xf9\x18\xf2\xc3\xd6\x4d\x9b\x99\x74\xf9\x40\x61\xf0\x25\xfe\xfc\x6b\x7c\xac\x49\xf1\x98\x41\xba\x8a\x35\xa7\x9b\xf7\x4f\x14\xba\x12\x45\x0c\x15\x6e\x8a\x1d\xca\xd2\x88\xaf\x0b\x53\xf0\xb4\x34\x12\x9e\x40\x47\xa7\x16\xc7\xf5\xa7\xa8\x12\x1f\x1e\xbe\xce\x3c\x8a\x0f\x29\x6b\xd5\xe0\x48\x9d\x9b\x36\x52\x16\xdd\x0e\x8a\xdc\x59\x6a\xcc\x74\xc6\x85\xe5\x11\xf6\x12\x12\x67\x1d\x3f\x88\x4f\x2e\xb6\xb8\x1b\xa3\x86\x5e\xbf\x17\x8d\x9b\x7d\xea\xc8\xf3\xa4\x30\xbc\x45\x2b\xe3\x8b\xaa\xdb\x29\xd4\xb0\xaf\x9d\xd8\x90\xec\x8c\x9f\xca\x13\x70\xd8\x93\xde\xdf\xaa\xd5\xf2\x7c\x27\xc7\xec\x01\xeb\x41\xc2\x7f\x44\x7a\x7e\xef\xfc\x16\xe7\x90\x3b\xa0\xac\xcf\x6d\x1b\xa1\xd2\x30\x76\xdf\xc3\xd2\x43\xbf\x8d\xff\x53\x3b\x58\xd3\xf8\xef\x42\xbd\xdb\xfc\x77\x00\x00\x00\xff\xff\x51\x14\xa2\xfc\x58\x07\x00\x00"),
		},
		"/operator-deployment.yaml": &vfsgen۰CompressedFileInfo{
			name:             "operator-deployment.yaml",
			modTime:          time.Time{},
			uncompressedSize: 2179,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xbc\x54\xc1\x6e\xe3\x36\x10\xbd\xeb\x2b\x1e\xac\xcb\x2e\x10\xdb\x9b\x9e\x0a\xf5\xa4\x26\x0e\xd6\x68\x6a\x1b\x96\xb7\xc1\x9e\x8a\x09\x35\x92\x88\x50\xa4\x4a\x52\xd6\xea\xef\x0b\xca\x96\x63\x67\xb3\x69\x0f\xc1\xf2\x24\x71\x86\x6f\xde\x9b\x79\x64\x8c\xe9\xfb\xad\x28\xc6\xbd\x14\xac\x1d\xe7\xf0\x06\xbe\x62\xa4\x0d\x89\x8a\x91\x99\xc2\x77\x64\x19\x77\xa6\xd5\x39\x79\x69\x34\x3e\xa4\xd9\xdd\x47\xb4\x3a\x67\x0b\xa3\x19\xc6\xa2\x36\x96\xa3\x18\xc2\x68\x6f\xe5\x63\xeb\x8d\x85\x3a\x00\x82\x4a\xcb\x5c\xb3\xf6\x6e\x06\x64\xcc\x03\xfa\x6a\xbd\x5b\xde\x2c\x50\x48\xc5\xc8\xa5\x3b\x1c\xe2\x1c\x9d\xf4\x55\x14\xc3\x57\xd2\xa1\x33\xf6\x09\x85\xb1\xa0\x3c\x97\xa1\x30\x29\x48\x5d\x18\x5b\x1f\x68\x58\x2e\xc9\xe6\x52\x97\x10\xa6\xe9\xad\x2c\x2b\x0f\xd3\x69\xb6\xae\x92\xcd\x2c\x8a\xb1\x0b\x32\xb2\xbb\x91\x89\x3b\xc0\x0e\x35\xbd\xc1\x57\xd3\x1e\x35\x9c\xc9\x3d\x76\xe1\x0a\x7f\xb1\x75\xa1\xc8\x2f\xb3\x4f\x51\x8c\x0f\x21\x65\x72\x0c\x4e\x3e\xfe\x86\xde\xb4\xa8\xa9\x87\x36\x1e\xad\xe3\x33\x64\xfe\x26\xb8\xf1\x90\x1a\xc2\xd4\x8d\x92\xa4\x05\x3f\xcb\x3a\x55\x98\x61\x20\x10\x30\xcc\xa3\x27\xa9\x41\x83\x0c\x98\xe2\x3c\x0d\xe4\xa3\x38\x8a\x31\xac\xca\xfb\x26\x99\xcf\xbb\xae\x9b\xd1\x40\x77\x66\x6c\x39\x1f\xd5\xcd\xef\x97\x37\x8b\x55\xb6\x98\x0e\x94\xa3\x18\x5f\xb4\x62\xe7\x60\xf9\x9f\x56\x5a\xce\xf1\xd8\x83\x9a\x46\x49\x41\x8f\x8a\xa1\xa8\x0b\x83\x1b\xa6\x33\x0c\x5d\x6a\x74\x56\x7a\xa9\xcb\x2b\xb8\xe3\xd4\xa3\xf8\x62\x3a\xcf\xed\x1a\xe9\x49\x77\x91\x60\x34\x48\x63\x92\x66\x58\x66\x13\xfc\x9e\x66\xcb\xec\x2a\x8a\xf1\xb0\xdc\x7d\x5e\x7f\xd9\xe1\x21\xdd\x6e\xd3\xd5\x6e\xb9\xc8\xb0\xde\xe2\x66\xbd\xba\x5d\xee\x96\xeb\x55\x86\xf5\x1d\xd2\xd5\x57\xfc\xb1\x5c\xdd\x5e\x81\xa5\xaf\xd8\x82\xbf\x35\x36\xf0\x37\x16\x32\x34\x92\xf3\x30\xd3\xd1\x40\x23\x81\xe0\x8f\xf0\xef\x1a\x16\xb2\x90\x02\x8a\x74\xd9\x52\xc9\x28\xcd\x9e\xad\x0e\xf6\x68\xd8\xd6\xd2\x85\x71\x3a\x90\xce\xa3\x18\x4a\xd6\xd2\x0f\x2e\x72\xdf\x8b\x0a\x65\xde\xf3\x6e\x45\xd4\xc8\xa3\x9d\x92\x30\x01\x37\xdf\x5f\x47\x4f\x52\xe7\x09\x6e\xb9\x51\xa6\x0f\x97\x23\xaa\xd9\x53\x4e\x9e\x92\x08\xd0\x54\x73\x02\x41\x35\xab\xe9\xd3\xd4\x34\x6c\xc9\x1b\x1b\x01\x8a\x1e\x59\xb9\x90\x82\x80\x94\x60\x72\x4c\x9a\x0c\x5b\xc3\xcf\xb9\x37\x82\x05\x8d\x66\xed\x13\x9c\x50\x42\xa7\x02\x82\xe5\xc1\x0b\x2e\xc1\x75\x04\x38\x6f\xc9\x73\xd9\x1f\xb0\x7d\xdf\x70\x82\x2d\x0b\xcb\xe4\x39\x84\x59\xb1\xf0\xc6\x1e\xc2\x35\x79\x51\xdd\x9f\x71\x79\x83\xb2\xe7\xba\x51\xe4\xf9\x78\xf2\x4c\x65\x58\xea\x02\xe4\x0d\x98\xc3\xfa\x5f\x02\xc7\xe4\x57\x1a\x34\x6a\x1f\xbe\xd9\xee\xa5\xe0\x54\x08\xd3\x6a\xbf\x7a\xab\x70\x78\xd6\x48\x86\x97\xe5\x99\xe9\xf4\xbf\xb8\x02\xb2\xa6\x92\x93\xf0\x4e\x85\x2b\xd2\xcf\x2c\xe7\x15\xf9\x99\x34\x73\xa9\x3d\x97\x76\x30\xe0\xd4\xb3\xa8\xa6\x8d\xe5\xbd\xe4\x6e\x3e\xa2\xd9\x8a\xd5\xaf\x27\xcc\xe4\x7a\xf6\xe9\x0c\x57\x98\xba\x26\x9d\x27\x67\x5b\x53\x3c\x85\x93\x17\x3b\x3f\x62\xb4\x69\x95\xda\x18\x25\x45\x9f\x60\x59\xac\x8c\xdf\x58\x76\xc1\x82\xcf\x79\xac\xf7\xe7\xe8\xcf\x6a\x1f\xd2\xdd\xcd\xe7\xbf\x57\xe9\x9f\x8b\x6c\x93\xde\x2c\x2e\x72\x80\x3d\xa9\x96\xef\xac\xa9\x93\x17\x01\xa0\x90\xac\xf2\x2d\x17\xdf\x47\x8e\xb1\x0d\xf9\x2a\x39\xf9\x63\x16\xca\xb9\x86\x04\xbf\x4a\x63\xbd\x59\x6c\xd3\xdd\x7a\x3b\x30\x79\x8d\xc4\xcb\xc1\xbf\x04\xd8\xac\x6f\x7f\x78\xf6\xfd\x04\x5c\xa4\xc6\x38\xb5\x2d\x3c\x9b\xa4\x3a\xea\xdd\xf0\xee\x8c\x83\xc2\x49\xf4\x15\xa4\xce\xb9\x61\x9d\xb3\xf6\xaa\x47\x61\x4d\xfd\x66\xef\x47\x5d\x3f\x75\x32\xff\x06\x00\x00\xff\xff\x50\x0d\xbe\xce\x83\x08\x00\x00"),
		},
		"/operator-role-binding-events.yaml": &vfsgen۰CompressedFileInfo{
			name:             "operator-role-binding-events.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1224,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x93\x41\x6f\xdb\x46\x10\x85\xef\xfb\x2b\x1e\xc4\x4b\x02\x58\x54\xd3\x53\xa1\x9e\x18\xc7\x6e\x89\x06\x12\x20\x2a\x0d\x72\x1c\x2e\x47\xe4\xd4\xe4\x0e\xbb\xbb\x34\xe3\xfe\xfa\x62\x29\xa9\x76\x50\xb4\xc8\xc1\x7b\x13\x34\x7c\xf3\xbd\x7d\x6f\x33\xac\x5f\xef\x98\x0c\x1f\xc5\xb2\x0b\xdc\x20\x2a\x62\xc7\x28\x46\xb2\x1d\xa3\xd2\x53\x9c\xc9\x33\xee\x75\x72\x0d\x45\x51\x87\x37\x45\x75\xff\x16\x93\x6b\xd8\x43\x1d\x43\x3d\x06\xf5\x6c\x32\x58\x75\xd1\x4b\x3d\x45\xf5\xe8\xcf\x82\xa0\xd6\x33\x0f\xec\x62\xc8\x81\x8a\x79\x51\xdf\xed\x8f\xe5\xed\x1d\x4e\xd2\x33\x1a\x09\xe7\x8f\xb8\xc1\x2c\xb1\x33\x19\x62\x27\x01\xb3\xfa\x07\x9c\xd4\x83\x9a\x46\xd2\x62\xea\x21\xee\xa4\x7e\x38\x63\x78\x6e\xc9\x37\xe2\x5a\x58\x1d\x9f\xbc\xb4\x5d\x84\xce\x8e\x7d\xe8\x64\xcc\x4d\x86\x63\xb2\x51\xdd\x5f\x49\xc2\x59\x76\xd9\x19\x15\x5f\x74\xba\x78\x78\x61\xf7\x72\x0b\x37\xf8\x9d\x7d\x48\x4b\x7e\xcc\x7f\x30\x19\xde\xa4\x91\xd5\xe5\xcf\xd5\xdb\x9f\xf1\xa4\x13\x06\x7a\x82\xd3\x88\x29\xf0\x0b\x65\xfe\x6a\x79\x8c\x10\x07\xab\xc3\xd8\x0b\x39\xcb\xcf\xb6\xfe\xd9\x90\x63\x01\x48\x1a\x5a\x47\x12\x07\x5a\x6c\x40\x4f\x2f\xc7\x40\xd1\x64\x26\xc3\x72\xba\x18\xc7\xed\x66\x33\xcf\x73\x4e\x0b\x6e\xae\xbe\xdd\x5c\xdd\x6d\x3e\x96\xb7\x77\xbb\xea\x6e\xbd\x20\x9b\x0c\x9f\x5c\xcf\x21\xc0\xf3\x9f\x93\x78\x6e\x50\x3f\x81\xc6\xb1\x17\x4b\x75\xcf\xe8\x69\x4e\xc1\x2d\xe9\x2c\xa1\x8b\xc3\xec\x25\x8a\x6b\x6f\x10\x2e\xa9\x9b\xec\x9b\x74\x9e\xaf\xeb\x8a\x27\xe1\x9b\x01\x75\x20\x87\x55\x51\xa1\xac\x56\x78\x5f\x54\x65\x75\x63\x32\x7c\x2e\x8f\xbf\xee\x3f\x1d\xf1\xb9\x38\x1c\x8a\xdd\xb1\xbc\xab\xb0\x3f\xe0\x76\xbf\xfb\x50\x1e\xcb\xfd\xae\xc2\xfe\x1e\xc5\xee\x0b\x7e\x2b\x77\x1f\x6e\xc0\x12\x3b\xf6\xe0\xaf\xa3\x4f\xfc\xea\x21\xe9\x22\xb9\x49\x99\x5e\x0b\x74\x05\x48\xfd\x48\xbf\xc3\xc8\x56\x4e\x62\xd1\x93\x6b\x27\x6a\x19\xad\x3e\xb2\x77\xa9\x1e\x23\xfb\x41\x42\x8a\x33\x80\x5c\x63\x32\xf4\x32\x48\x5c\x5a\x14\xfe\x6d\x2a\xad\x79\xcd\xb7\x65\x1e\xc4\x35\x5b\x1c\xb4\xe7\xf7\xe2\x52\x61\x0d\x8d\x72\x29\xd8\x16\xbe\x26\x9b\xd3\x14\x3b\xf5\xf2\xd7\xc2\x94\x3f\xfc\x14\x72\xd1\xcd\xe3\xbb\x9a\x23\xbd\x33\x03\x47\x6a\x28\xd2\xd6\x00\x8e\x06\xde\xc2\xd2\xc0\xfd\xfa\x61\xad\x23\x7b\x8a\xea\xd7\xfc\x98\x1e\x98\x01\x7a\xaa\xb9\x0f\x69\x12\x29\xed\x2d\x56\x97\xd9\x95\x09\x53\xfd\x07\xdb\x18\xb6\x66\x8d\x33\x52\xc5\xfe\x51\x2c\x17\xd6\xea\xe4\xe2\x7f\xaa\x1b\xaf\x3d\x1f\xf8\x94\x54\x9f\xbd\x7c\x07\x0c\x8d\xf2\x8b\xd7\x69\xfc\x1f\x93\xe6\xef\x00\x00\x00\xff\xff\xdf\x30\x8d\x1c\xc8\x04\x00\x00"),
		},
		"/operator-role-binding-knative.yaml": &vfsgen۰CompressedFileInfo{
			name:             "operator-role-binding-knative.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1226,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x93\x41\x8f\xdb\x36\x10\x85\xef\xfc\x15\x0f\xd6\x25\x01\xd6\x72\xd3\x53\xe1\x9e\x9c\xcd\x6e\x2b\x34\xb0\x01\xcb\x69\x90\xe3\x88\x1a\x4b\x53\x4b\x1c\x95\xa4\x56\x71\x7f\x7d\x41\xd9\xee\x6e\x50\xb4\xc8\x61\x79\x13\x34\x7a\xf3\x3d\xbe\xa7\x0c\xcb\xd7\x3b\x26\xc3\x47\xb1\xec\x02\xd7\x88\x8a\xd8\x32\x36\x03\xd9\x96\x51\xea\x31\x4e\xe4\x19\x8f\x3a\xba\x9a\xa2\xa8\xc3\x9b\x4d\xf9\xf8\x16\xa3\xab\xd9\x43\x1d\x43\x3d\x7a\xf5\x6c\x32\x58\x75\xd1\x4b\x35\x46\xf5\xe8\x2e\x82\xa0\xc6\x33\xf7\xec\x62\xc8\x81\x92\x79\x56\xdf\xee\x0e\xc5\xfd\x03\x8e\xd2\x31\x6a\x09\x97\x8f\xb8\xc6\x24\xb1\x35\x19\x62\x2b\x01\x93\xfa\x13\x8e\xea\x41\x75\x2d\x69\x31\x75\x10\x77\x54\xdf\x5f\x30\x3c\x37\xe4\x6b\x71\x0d\xac\x0e\x67\x2f\x4d\x1b\xa1\x93\x63\x1f\x5a\x19\x72\x93\xe1\x90\x6c\x94\x8f\x37\x92\x70\x91\x9d\x77\x46\xc5\x17\x1d\xaf\x1e\x5e\xd8\xbd\xde\xc2\x1d\x7e\x67\x1f\xd2\x92\x1f\xf3\x1f\x4c\x86\x37\x69\x64\x71\x7d\xb9\x78\xfb\x33\xce\x3a\xa2\xa7\x33\x9c\x46\x8c\x81\x5f\x28\xf3\x57\xcb\x43\x84\x38\x58\xed\x87\x4e\xc8\x59\x7e\xb6\xf5\xcf\x86\x1c\x33\x40\xd2\xd0\x2a\x92\x38\xd0\x6c\x03\x7a\x7c\x39\x06\x8a\x26\x33\x19\xe6\xd3\xc6\x38\xac\x57\xab\x69\x9a\x72\x9a\x71\x73\xf5\xcd\xea\xe6\x6e\xf5\xb1\xb8\x7f\xd8\x96\x0f\xcb\x19\xd9\x64\xf8\xe4\x3a\x0e\x01\x9e\xff\x1c\xc5\x73\x8d\xea\x0c\x1a\x86\x4e\x2c\x55\x1d\xa3\xa3\x29\x05\x37\xa7\x33\x87\x2e\x0e\x93\x97\x28\xae\xb9\x43\xb8\xa6\x6e\xb2\x6f\xd2\x79\xbe\xae\x1b\x9e\x84\x6f\x06\xd4\x81\x1c\x16\x9b\x12\x45\xb9\xc0\xfb\x4d\x59\x94\x77\x26\xc3\xe7\xe2\xf0\xeb\xee\xd3\x01\x9f\x37\xfb\xfd\x66\x7b\x28\x1e\x4a\xec\xf6\xb8\xdf\x6d\x3f\x14\x87\x62\xb7\x2d\xb1\x7b\xc4\x66\xfb\x05\xbf\x15\xdb\x0f\x77\x60\x89\x2d\x7b\xf0\xd7\xc1\x27\x7e\xf5\x90\x74\x91\x5c\xa7\x4c\x6f\x05\xba\x01\xa4\x7e\xa4\xe7\x30\xb0\x95\xa3\x58\x74\xe4\x9a\x91\x1a\x46\xa3\x4f\xec\x5d\xaa\xc7\xc0\xbe\x97\x90\xe2\x0c\x20\x57\x9b\x0c\x9d\xf4\x12\xe7\x16\x85\x7f\x9b\x4a\x6b\x5e\xf3\xdf\x32\x27\x71\xf5\x1a\x7b\xed\xf8\xbd\xb8\x54\x58\x43\x83\x5c\x0b\xb6\x86\xaf\xc8\xe6\x34\xc6\x56\xbd\xfc\x35\x33\xe5\xa7\x9f\x42\x2e\xba\x7a\x7a\x57\x71\xa4\x77\xa6\xe7\x48\x35\x45\x5a\x1b\xc0\x51\xcf\x6b\x58\xea\xb9\x5b\x9e\x96\x3a\xb0\xa7\xa8\x7e\x79\x72\x14\xe5\x89\x0d\xd0\x51\xc5\x5d\x48\xa3\x48\x71\xaf\xb1\xb8\x0e\x2f\x4c\x18\xab\x3f\xd8\xc6\xb0\x36\x4b\x5c\x98\x4a\xf6\x4f\x62\x79\x63\xad\x8e\x2e\xfe\xa7\xbc\xf1\xda\xf1\x9e\x8f\x49\xf5\xd9\xcc\xf7\xd0\xd0\x20\xbf\x78\x1d\x87\xff\xb1\x69\xfe\x0e\x00\x00\xff\xff\x0e\xd3\x59\xb8\xca\x04\x00\x00"),
		},
		"/operator-role-binding.yaml": &vfsgen۰CompressedFileInfo{
			name:             "operator-role-binding.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1210,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x93\x41\x6f\xdb\x46\x10\x85\xef\xfb\x2b\x1e\xc4\x4b\x02\x58\x54\xd3\x53\xa1\x9e\x18\xc7\x6e\x89\x06\x12\x20\x2a\x0d\x72\x1c\x2e\x47\xe4\xd4\xe4\x0e\xbb\xbb\x34\xe3\xfe\xfa\x62\x29\xa9\x76\x50\x24\x27\xef\x8d\xe0\xf0\xcd\xf7\xf6\x3d\x66\x58\xbf\xde\x31\x19\x3e\x8a\x65\x17\xb8\x41\x54\xc4\x8e\x51\x8c\x64\x3b\x46\xa5\xa7\x38\x93\x67\xdc\xeb\xe4\x1a\x8a\xa2\x0e\x6f\x8a\xea\xfe\x2d\x26\xd7\xb0\x87\x3a\x86\x7a\x0c\xea\xd9\x64\xb0\xea\xa2\x97\x7a\x8a\xea\xd1\x9f\x05\x41\xad\x67\x1e\xd8\xc5\x90\x03\x15\xf3\xa2\xbe\xdb\x1f\xcb\xdb\x3b\x9c\xa4\x67\x34\x12\xce\x1f\x71\x83\x59\x62\x67\x32\xc4\x4e\x02\x66\xf5\x0f\x38\xa9\x07\x35\x8d\xa4\xc5\xd4\x43\xdc\x49\xfd\x70\xc6\xf0\xdc\x92\x6f\xc4\xb5\xb0\x3a\x3e\x79\x69\xbb\x08\x9d\x1d\xfb\xd0\xc9\x98\x9b\x0c\xc7\x64\xa3\xba\xbf\x92\x84\xb3\xec\xb2\x33\x2a\xbe\xe8\x74\xf1\xf0\xc2\xee\xe5\x16\x6e\xf0\x27\xfb\x90\x96\xfc\x9c\xff\x64\x32\xbc\x49\x23\xab\xcb\xcb\xd5\xdb\x5f\xf1\xa4\x13\x06\x7a\x82\xd3\x88\x29\xf0\x0b\x65\xfe\x6a\x79\x8c\x10\x07\xab\xc3\xd8\x0b\x39\xcb\xcf\xb6\xfe\xdb\x90\x63\x01\x48\x1a\x5a\x47\x12\x07\x5a\x6c\x40\x4f\x2f\xc7\x40\xd1\x64\x26\xc3\x72\xba\x18\xc7\xed\x66\x33\xcf\x73\x4e\x0b\x6e\xae\xbe\xdd\x5c\xdd\x6d\x3e\x96\xb7\x77\xbb\xea\x6e\xbd\x20\x9b\x0c\x9f\x5c\xcf\x21\xc0\xf3\xdf\x93\x78\x6e\x50\x3f\x81\xc6\xb1\x17\x4b\x75\xcf\xe8\x69\x4e\xc1\x2d\xe9\x2c\xa1\x8b\xc3\xec\x25\x8a\x6b\x6f\x10\x2e\xa9\x9b\xec\x9b\x74\x9e\xaf\xeb\x8a\x27\xe1\x9b\x01\x75\x20\x87\x55\x51\xa1\xac\x56\x78\x5f\x54\x65\x75\x63\x32\x7c\x2e\x8f\xbf\xef\x3f\x1d\xf1\xb9\x38\x1c\x8a\xdd\xb1\xbc\xab\xb0\x3f\xe0\x76\xbf\xfb\x50\x1e\xcb\xfd\xae\xc2\xfe\x1e\xc5\xee\x0b\xfe\x28\x77\x1f\x6e\xc0\x12\x3b\xf6\xe0\xaf\xa3\x4f\xfc\xea\x21\xe9\x22\xb9\x49\x99\x5e\x0b\x74\x05\x48\xfd\x48\xcf\x61\x64\x2b\x27\xb1\xe8\xc9\xb5\x13\xb5\x8c\x56\x1f\xd9\xbb\x54\x8f\x91\xfd\x20\x21\xc5\x19\x40\xae\x31\x19\x7a\x19\x24\x2e\x2d\x0a\xff\x37\x95\xd6\xbc\xe6\xbf\x65\x1e\xc4\x35\x5b\x1c\xb4\xe7\xf7\xe2\x52\x61\x0d\x8d\x72\x29\xd8\x16\xbe\x26\x9b\xd3\x14\x3b\xf5\xf2\xcf\xc2\x94\x3f\xfc\x12\x72\xd1\xcd\xe3\xbb\x9a\x23\xbd\x33\x03\x47\x6a\x28\xd2\xd6\x00\x8e\x06\xde\xc2\xd2\xc0\xfd\xfa\x61\xad\x23\x7b\x8a\xea\x0d\xd0\x53\xcd\x7d\x48\x23\x48\x31\x6f\xb1\xba\x0c\xad\x4c\x98\xea\xbf\xd8\xc6\xb0\x35\x6b\x9c\x59\x2a\xf6\x8f\x62\xb9\xb0\x56\x27\x17\xbf\x2f\xeb\xb5\xe7\x03\x9f\x92\xea\xb3\x89\x1f\x51\xd0\x28\xbf\x79\x9d\xc6\x1f\xd8\x32\xff\x06\x00\x00\xff\xff\x6d\x95\x91\xb1\xba\x04\x00\x00"),
		},
		"/operator-role-events.yaml": &vfsgen۰CompressedFileInfo{
			name:             "operator-role-events.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1175,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\xc1\x8e\xdb\x36\x10\xbd\xf3\x2b\x1e\xac\x4b\x02\xac\xe5\xa6\xa7\xc2\x3d\xb9\x9b\xdd\x56\x68\x60\x03\x2b\xa7\x41\x8e\x63\x69\x2c\x0d\x56\xe2\xa8\x43\x6a\x15\xf7\xeb\x0b\xca\x72\xb2\x41\xae\xe1\xc5\x34\xf9\xf4\xe6\xbd\x79\xc3\x0c\xeb\x9f\xb7\x5c\x86\x0f\x52\xb1\x0f\x5c\x23\x2a\x62\xcb\xd8\x0d\x54\xb5\x8c\x52\xcf\x71\x22\x63\x3c\xea\xe8\x6b\x8a\xa2\x1e\x6f\x76\xe5\xe3\x5b\x8c\xbe\x66\x83\x7a\x86\x1a\x7a\x35\x76\x19\x2a\xf5\xd1\xe4\x34\x46\x35\x74\x57\x42\x50\x63\xcc\x3d\xfb\x18\x72\xa0\x64\x9e\xd9\xf7\x87\x63\x71\xff\x80\xb3\x74\x8c\x5a\xc2\xf5\x23\xae\x31\x49\x6c\x5d\x86\xd8\x4a\xc0\xa4\xf6\x8c\xb3\x1a\xa8\xae\x25\x15\xa6\x0e\xe2\xcf\x6a\xfd\x55\x86\x71\x43\x56\x8b\x6f\x50\xe9\x70\x31\x69\xda\x08\x9d\x3c\x5b\x68\x65\xc8\x5d\x86\x63\xb2\x51\x3e\xde\x94\x84\x2b\xed\x5c\x33\x2a\x3e\xeb\xb8\x78\x78\x65\x77\xe9\xc2\x1d\xfe\x61\x0b\xa9\xc8\xaf\xf9\x2f\x2e\xc3\x9b\x04\x59\x2d\x97\xab\xb7\xbf\xe3\xa2\x23\x7a\xba\xc0\x6b\xc4\x18\xf8\x15\x33\x7f\xa9\x78\x88\x10\x8f\x4a\xfb\xa1\x13\xf2\x15\x7f\xb3\xf5\xb5\x42\x8e\x59\x40\xe2\xd0\x53\x24\xf1\xa0\xd9\x06\xf4\xfc\x1a\x06\x8a\x2e\x73\x19\xe6\xd5\xc6\x38\x6c\x37\x9b\x69\x9a\x72\x9a\xe5\xe6\x6a\xcd\xe6\xe6\x6e\xf3\xa1\xb8\x7f\xd8\x97\x0f\xeb\x59\xb2\xcb\xf0\xd1\x77\x1c\x02\x8c\xff\x1d\xc5\xb8\xc6\xe9\x02\x1a\x86\x4e\x2a\x3a\x75\x8c\x8e\xa6\x14\xdc\x9c\xce\x1c\xba\x78\x4c\x26\x51\x7c\x73\x87\xb0\xa4\xee\xb2\xef\xd2\xf9\xd6\xae\x9b\x3c\x09\xdf\x01\xd4\x83\x3c\x56\xbb\x12\x45\xb9\xc2\x1f\xbb\xb2\x28\xef\x5c\x86\x4f\xc5\xf1\xaf\xc3\xc7\x23\x3e\xed\x9e\x9e\x76\xfb\x63\xf1\x50\xe2\xf0\x84\xfb\xc3\xfe\x7d\x71\x2c\x0e\xfb\x12\x87\x47\xec\xf6\x9f\xf1\x77\xb1\x7f\x7f\x07\x96\xd8\xb2\x81\xbf\x0c\x96\xf4\xab\x41\x52\x23\xb9\x4e\x99\xde\x06\xe8\x26\x20\xcd\x47\xfa\x1f\x06\xae\xe4\x2c\x15\x3a\xf2\xcd\x48\x0d\xa3\xd1\x17\x36\x9f\xc6\x63\x60\xeb\x25\xa4\x38\x03\xc8\xd7\x2e\x43\x27\xbd\xc4\x79\x8a\xc2\x8f\xa6\x52\x99\x9f\xf9\xb6\xdc\xb3\xf8\x7a\x8b\x27\xed\xd8\xd1\x20\xcb\x64\x6d\x61\x27\xaa\x72\x1a\x63\xab\x26\xff\xcd\x62\xf2\xe7\xdf\x42\x2e\xba\x79\x79\x77\xe2\x48\xef\x5c\xcf\x91\x6a\x8a\xb4\x75\x80\xa7\x9e\xb7\xa8\xa8\xe7\x6e\xfd\xbc\xd6\x81\x8d\xa2\xda\x9a\x5f\xd2\xcb\x72\x40\x47\x27\xee\x42\x42\x22\xc5\xbc\xc5\x6a\xc1\xae\x9c\x8d\x1d\x87\xad\x5b\x83\x06\xf9\xd3\x74\x1c\x66\xd8\x1a\xab\x95\x03\x8c\x83\x8e\x56\xf1\x72\xf6\x95\xef\x85\xed\xb4\x9c\x55\xc6\x14\x79\xde\x0e\x14\xab\x76\xde\x35\x1c\xe7\xdf\x4e\xc2\x75\x33\xcd\x57\xff\x07\x00\x00\xff\xff\xb6\x1d\x1a\x31\x97\x04\x00\x00"),
		},
		"/operator-role-knative.yaml": &vfsgen۰CompressedFileInfo{
			name:             "operator-role-knative.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1423,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xbc\x53\xc1\x8e\xdb\x36\x10\xbd\xf3\x2b\x1e\xac\x4b\x52\xac\xe5\xa6\xa7\xc2\x3d\xb9\xc9\x6e\x2b\x34\xb0\x81\x95\xd3\x20\xc7\x31\x35\x96\x06\xa6\x48\x75\x48\x59\xd9\x7e\x7d\x21\xda\x6e\x76\xb1\x87\x5e\x82\xf2\xe2\x31\xf5\xf4\xe6\xbd\x79\xa3\x02\xcb\xef\x77\x4c\x81\x8f\x62\xd9\x47\x6e\x90\x02\x52\xc7\xd8\x0c\x64\x3b\x46\x1d\x8e\x69\x22\x65\x3c\x84\xd1\x37\x94\x24\x78\xbc\xd9\xd4\x0f\x6f\x31\xfa\x86\x15\xc1\x33\x82\xa2\x0f\xca\xa6\x80\x0d\x3e\xa9\x1c\xc6\x14\x14\xee\x42\x08\x6a\x95\xb9\x67\x9f\x62\x09\xd4\xcc\x99\x7d\xbb\xdb\x57\xef\xef\x71\x14\xc7\x68\x24\x5e\x5e\xe2\x06\x93\xa4\xce\x14\x48\x9d\x44\x4c\x41\x4f\x38\x06\x05\x35\x8d\xcc\x8d\xc9\x41\xfc\x31\x68\x7f\x91\xa1\xdc\x92\x36\xe2\x5b\xd8\x30\x3c\xa9\xb4\x5d\x42\x98\x3c\x6b\xec\x64\x28\x4d\x81\xfd\x6c\xa3\x7e\xb8\x29\x89\x17\xda\xdc\x33\x05\x7c\x09\xe3\xd5\xc3\x33\xbb\xd7\x29\xdc\xe1\x4f\xd6\x38\x37\xf9\xa9\xfc\xd1\x14\x78\x33\x43\x16\xd7\x87\x8b\xb7\xbf\xe0\x29\x8c\xe8\xe9\x09\x3e\x24\x8c\x91\x9f\x31\xf3\x57\xcb\x43\x82\x78\xd8\xd0\x0f\x4e\xc8\x5b\xfe\x66\xeb\xdf\x0e\x25\xb2\x80\x99\x23\x1c\x12\x89\x07\x65\x1b\x08\xc7\xe7\x30\x50\x32\x85\x29\x90\x4f\x97\xd2\xb0\x5e\xad\xa6\x69\x2a\x29\xcb\x2d\x83\xb6\xab\x9b\xbb\xd5\xc7\xea\xfd\xfd\xb6\xbe\x5f\x66\xc9\xa6\xc0\x27\xef\x38\x46\x28\xff\x35\x8a\x72\x83\xc3\x13\x68\x18\x9c\x58\x3a\x38\x86\xa3\x69\x0e\x2e\xa7\x93\x43\x17\x8f\x49\x25\x89\x6f\xef\x10\xaf\xa9\x9b\xe2\x45\x3a\xdf\xc6\x75\x93\x27\xf1\x05\x20\x78\x90\xc7\x62\x53\xa3\xaa\x17\xf8\x75\x53\x57\xf5\x9d\x29\xf0\xb9\xda\xff\xbe\xfb\xb4\xc7\xe7\xcd\xe3\xe3\x66\xbb\xaf\xee\x6b\xec\x1e\xf1\x7e\xb7\xfd\x50\xed\xab\xdd\xb6\xc6\xee\x01\x9b\xed\x17\xfc\x51\x6d\x3f\xdc\x81\x25\x75\xac\xe0\xaf\x83\xce\xfa\x83\x42\xe6\x41\x72\x33\x67\x7a\x5b\xa0\x9b\x80\x79\x3f\xe6\xff\x71\x60\x2b\x47\xb1\x70\xe4\xdb\x91\x5a\x46\x1b\xce\xac\x7e\x5e\x8f\x81\xb5\x97\x38\xc7\x19\x41\xbe\x31\x05\x9c\xf4\x92\xf2\x16\xc5\xd7\xa6\xe6\x36\xdf\xf3\xdb\x32\x27\xf1\xcd\x1a\x8f\xc1\xb1\xa1\x41\xae\x9b\xb5\x86\x1e\xc8\x96\x34\xa6\x2e\xa8\xfc\x9d\xc5\x94\xa7\x9f\x63\x29\x61\x75\x7e\x77\xe0\x44\xef\x4c\xcf\x89\x1a\x4a\xb4\x36\x80\xa7\x9e\xd7\xb0\xd4\xb3\x5b\x9e\x96\x61\x60\xa5\x14\x74\x79\xf2\x94\xe4\xcc\x06\x70\x74\x60\x17\x67\x28\xe6\x9c\xd7\x58\x5c\xc1\x0b\xa3\xa3\xe3\xb8\x36\x4b\xd0\x20\xbf\x69\x18\x87\x0c\x5b\x22\xb2\x9e\xc5\xb7\xe5\x95\xa4\x6c\xf8\x6c\x00\xe5\x18\x46\xb5\xfc\x1c\x64\x39\x1a\xe0\xcc\x7a\xb8\xde\x5a\x65\x4a\x9c\xcb\x86\x1d\xbf\x28\x6d\x70\x8e\xed\x6c\x28\x5f\xb6\x9c\xf2\xaf\x93\x78\x29\x06\x4a\xb6\xcb\xd5\x38\x34\x37\x96\x29\x5f\xbe\x92\xc8\x67\xf6\xe9\xb5\xc6\x25\x7a\x8e\x91\xda\xff\x54\xbf\xf8\x61\xf1\xbf\x08\xff\x27\x00\x00\xff\xff\x43\x4b\xa1\x03\x8f\x05\x00\x00"),
		},
		"/operator-role-kubernetes.yaml": &vfsgen۰CompressedFileInfo{
			name:             "operator-role-kubernetes.yaml",
			modTime:          time.Time{},
			uncompressedSize: 2249,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xc4\x54\xc1\x6e\x1b\x37\x10\xbd\xf3\x2b\x1e\xb4\x97\xa4\xb0\xe4\xa6\xa7\x42\x3d\xa9\x8e\xdd\x0a\x0d\x24\xc0\xab\x34\xc8\x71\x96\x3b\x5a\xb1\xe6\x72\x58\x92\x2b\xd9\xfd\xfa\x82\xd4\x2a\x91\xa3\x04\xe8\x21\xa8\xf7\xa2\x21\x77\xf6\xcd\x9b\xf7\x46\x53\x61\xfa\xfd\x1e\x55\xe1\x9d\xd1\xec\x22\xb7\x48\x82\xb4\x63\x2c\x3c\xe9\x1d\xa3\x96\x6d\x3a\x50\x60\xdc\xc9\xe0\x5a\x4a\x46\x1c\x5e\x2d\xea\xbb\xd7\x18\x5c\xcb\x01\xe2\x18\x12\xd0\x4b\x60\x55\x41\x8b\x4b\xc1\x34\x43\x92\x00\x7b\x04\x04\x75\x81\xb9\x67\x97\xe2\x0c\xa8\x99\x0b\xfa\x6a\xbd\x59\xde\xdc\x62\x6b\x2c\xa3\x35\xf1\xf8\x11\xb7\x38\x98\xb4\x53\x15\xd2\xce\x44\x1c\x24\x3c\x60\x2b\x01\xd4\xb6\x26\x17\x26\x0b\xe3\xb6\x12\xfa\x23\x8d\xc0\x1d\x85\xd6\xb8\x0e\x5a\xfc\x53\x30\xdd\x2e\x41\x0e\x8e\x43\xdc\x19\x3f\x53\x15\x36\xb9\x8d\xfa\xee\xc4\x24\x1e\x61\x4b\xcd\x24\xf8\x28\xc3\xd8\xc3\x59\xbb\xa3\x0a\x57\xf8\x93\x43\xcc\x45\x7e\x9a\xfd\xa8\x2a\xbc\xca\x29\x93\xf1\xe5\xe4\xf5\x2f\x78\x92\x01\x3d\x3d\xc1\x49\xc2\x10\xf9\x0c\x99\x1f\x35\xfb\x04\xe3\xa0\xa5\xf7\xd6\x90\xd3\xfc\xb9\xad\x4f\x15\x66\x28\x04\x32\x86\x34\x89\x8c\x03\x95\x36\x20\xdb\xf3\x34\x50\x52\x95\xaa\x50\x9e\x5d\x4a\x7e\x7e\x7d\x7d\x38\x1c\x66\x54\xe8\xce\x24\x74\xd7\xa7\xee\xae\xdf\x2d\x6f\x6e\x57\xf5\xed\xb4\x50\x56\x15\xde\x3b\xcb\x31\x22\xf0\xdf\x83\x09\xdc\xa2\x79\x02\x79\x6f\x8d\xa6\xc6\x32\x2c\x1d\xb2\x71\xc5\x9d\x62\xba\x71\x38\x04\x93\x8c\xeb\xae\x10\x47\xd7\x55\xf5\xcc\x9d\xcf\x72\x9d\xe8\x99\xf8\x2c\x41\x1c\xc8\x61\xb2\xa8\xb1\xac\x27\xf8\x75\x51\x2f\xeb\x2b\x55\xe1\xc3\x72\xf3\xfb\xfa\xfd\x06\x1f\x16\xf7\xf7\x8b\xd5\x66\x79\x5b\x63\x7d\x8f\x9b\xf5\xea\xed\x72\xb3\x5c\xaf\x6a\xac\xef\xb0\x58\x7d\xc4\x1f\xcb\xd5\xdb\x2b\xb0\x49\x3b\x0e\xe0\x47\x1f\x32\x7f\x09\x30\x59\x48\x6e\xb3\xa7\xa7\x01\x3a\x11\xc8\xf3\x91\xcf\xd1\xb3\x36\x5b\xa3\x61\xc9\x75\x03\x75\x8c\x4e\xf6\x1c\x5c\x1e\x0f\xcf\xa1\x37\x31\xdb\x19\x41\xae\x55\x15\xac\xe9\x4d\x2a\x53\x14\x2f\x9b\xca\x65\xbe\xe7\x7f\x4b\x3d\x18\xd7\xce\x71\x2f\x96\x15\x79\x33\x4e\xd6\x1c\xa1\x21\x3d\xa3\x21\xed\x24\x98\x7f\x0a\x99\xd9\xc3\xcf\x71\x66\xe4\x7a\xff\xa6\xe1\x44\x6f\x54\xcf\x89\x5a\x4a\x34\x57\x80\xa3\x9e\xe7\xd0\xd4\xb3\x9d\x3e\x4c\xc5\x73\xa0\x24\x41\x01\x96\x1a\xb6\x31\xa7\x20\xfb\x3b\xc7\x64\x4c\x9a\xa8\x30\x58\x8e\x73\x35\x05\x79\xf3\x5b\x90\xc1\x97\xb4\xe9\x11\xe5\x6c\x86\x14\x10\x38\xca\x10\x34\x8f\x19\x93\x1f\x26\x0a\xd8\x73\x68\xce\x2e\x2e\x70\x26\x93\xcb\x2f\xbd\xb4\xb1\x04\x91\xc3\xde\x68\x3e\x1e\xd8\xb5\x5e\x8c\x4b\xc7\x93\xcf\x12\xc4\xc4\x2e\xed\xc5\x0e\x3d\x6b\x4b\xa6\x3f\xbe\xd2\xe2\xb6\xa6\xeb\xc9\x9f\x40\x74\xe0\xf4\x0c\x90\xb4\x96\xe1\x88\x74\xc6\x4f\x07\xa6\xc4\x25\x6c\xd9\xf2\xb3\x50\x8b\xb5\xac\xb3\xc0\xe5\xb2\xe3\x54\x7e\xad\x89\xc7\xc0\x53\xd2\xbb\x12\x0d\xbe\x3d\xa1\x1c\xca\xe5\x45\xcb\xdf\x34\xed\x52\x89\x20\x76\xec\x3e\x47\x8d\x71\x79\x57\xbd\x10\xed\xaf\x39\xc5\x7b\xbe\x90\xf1\xa2\xc8\x37\xf0\xc8\x17\x83\xbe\x40\x6c\xd9\x5b\x79\xea\xf9\xe4\x73\xe0\xb2\x6e\xe2\x27\x07\x13\x25\xde\x0e\x76\xbc\x78\x01\x1d\x9a\x31\xf7\x0b\xe2\x3a\x88\xfb\x4b\x9a\x17\x22\x35\x8a\x49\x69\xdc\xa3\xf7\x9c\x37\x6a\x01\x8f\x73\xb8\xc1\xda\xaf\x48\x4d\xdc\x8b\xbb\x14\xf2\xbf\x1a\xc8\x8f\x89\x5d\x59\x89\x97\xd8\xc6\x75\x79\xf3\xf2\xff\x23\xc7\xbf\x01\x00\x00\xff\xff\x25\x6a\xb3\x25\xc9\x08\x00\x00"),
		},
		"/operator-role-olm-cluster.yaml": &vfsgen۰CompressedFileInfo{
			name:             "operator-role-olm-cluster.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1321,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\xc1\x72\xdb\x36\x10\xbd\xe3\x2b\xde\x88\x87\x24\x1d\x8b\x6a\x7a\xea\xa8\x27\xd5\xb1\x5b\x4e\x33\xd2\x8c\xa9\x34\x93\x23\x44\xae\xc8\x1d\x83\x58\x74\x01\x9a\x71\xbf\xbe\x03\x4a\x6a\xac\xf1\xd5\xb8\x70\x09\x3e\xee\xbe\x87\xf7\x50\x60\xf9\x76\xcb\x14\xf8\xcc\x0d\xf9\x48\x2d\x92\x20\xf5\x84\x4d\xb0\x4d\x4f\xa8\xe5\x98\x26\xab\x84\x7b\x19\x7d\x6b\x13\x8b\xc7\xfb\x4d\x7d\xff\x01\xa3\x6f\x49\x21\x9e\x20\x8a\x41\x94\x4c\x81\x46\x7c\x52\x3e\x8c\x49\x14\xee\xd4\x10\xb6\x53\xa2\x81\x7c\x8a\x25\x50\x13\xcd\xdd\xb7\xbb\x7d\x75\x7b\x87\x23\x3b\x42\xcb\xf1\xf4\x13\xb5\x98\x38\xf5\xa6\x40\xea\x39\x62\x12\x7d\xc4\x51\x14\xb6\x6d\x39\x0f\xb6\x0e\xec\x8f\xa2\xc3\x89\x86\x52\x67\xb5\x65\xdf\xa1\x91\xf0\xac\xdc\xf5\x09\x32\x79\xd2\xd8\x73\x28\x4d\x81\x7d\x96\x51\xdf\x5f\x98\xc4\x53\xdb\x79\x66\x12\x7c\x93\xf1\xac\xe1\x85\xdc\xf3\x29\xdc\xe0\x6f\xd2\x98\x87\xfc\x52\xfe\x6c\x0a\xbc\xcf\x90\xc5\xf9\xe3\xe2\xc3\x6f\x78\x96\x11\x83\x7d\x86\x97\x84\x31\xd2\x8b\xce\xf4\xbd\xa1\x90\xc0\x1e\x8d\x0c\xc1\xb1\xf5\x0d\xfd\x90\xf5\xff\x84\x12\x33\x81\xdc\x43\x0e\xc9\xb2\x87\x9d\x65\x40\x8e\x2f\x61\xb0\xc9\x14\xa6\xc0\xbc\xfa\x94\xc2\x7a\xb5\x9a\xa6\xa9\xb4\x33\xdd\x52\xb4\x5b\x5d\xd4\xad\x3e\x57\xb7\x77\xdb\xfa\x6e\x39\x53\x36\x05\xbe\x78\x47\x31\x42\xe9\x9f\x91\x95\x5a\x1c\x9e\x61\x43\x70\xdc\xd8\x83\x23\x38\x3b\x65\xe3\x66\x77\x66\xd3\xd9\x63\x52\x4e\xec\xbb\x1b\xc4\xb3\xeb\xa6\xb8\x72\xe7\xc7\x71\x5d\xe8\x71\xbc\x02\x88\x87\xf5\x58\x6c\x6a\x54\xf5\x02\xbf\x6f\xea\xaa\xbe\x31\x05\xbe\x56\xfb\x3f\x77\x5f\xf6\xf8\xba\x79\x78\xd8\x6c\xf7\xd5\x5d\x8d\xdd\x03\x6e\x77\xdb\x4f\xd5\xbe\xda\x6d\x6b\xec\xee\xb1\xd9\x7e\xc3\x5f\xd5\xf6\xd3\x0d\x88\x53\x4f\x0a\xfa\x1e\x34\xf3\x17\x05\xe7\x83\xa4\x36\x7b\x7a\x09\xd0\x85\x40\xce\x47\x7e\x8f\x81\x1a\x3e\x72\x03\x67\x7d\x37\xda\x8e\xd0\xc9\x13\xa9\xcf\xf1\x08\xa4\x03\xc7\x6c\x67\x84\xf5\xad\x29\xe0\x78\xe0\x34\xa7\x28\xbe\x16\x95\xc7\xbc\xe5\xdd\x32\x8f\xec\xdb\x35\x6e\xdd\x18\x13\xe9\x83\x38\x32\x36\xf0\x39\x60\x6b\xe8\xc1\x36\xa5\x1d\x53\x2f\xca\xff\xce\x9c\xca\xc7\x5f\x63\xc9\xb2\x7a\xfa\x78\xa0\x64\x3f\x9a\x81\x92\x6d\x6d\xb2\x6b\x03\x78\x3b\xd0\x1a\x8d\x1d\xc8\x2d\x1f\x97\x12\x48\x6d\x12\x35\x80\xb3\x07\x72\x31\x43\x90\x6d\x5e\x63\x71\x06\x2d\x8c\x8e\x8e\xe2\xda\x2c\x61\x03\xff\xa1\x32\x86\x19\xb6\xcc\xb7\x35\x8a\xa3\x52\x02\xf9\xd8\xf3\x31\x95\x2c\x06\x50\x8a\x32\x6a\x43\xd7\xa8\xc6\x71\x2b\x93\x77\x62\xdb\x68\x80\x27\xd2\xc3\x05\xa0\x64\x13\xcd\x65\x4b\x8e\xae\xca\x46\x9c\xa3\x26\x8b\x9a\x37\x3b\x4a\xf3\xd3\x71\x3c\x15\xc1\xa6\xa6\x9f\xab\x31\xb4\x97\x2e\xd3\xbc\xf9\x9a\x6e\xd6\xf3\x22\xf9\xaf\xa9\xbe\xfb\xe9\xdd\x35\xb5\xbc\xf1\x5f\x00\x00\x00\xff\xff\x8f\x77\x93\x45\x29\x05\x00\x00"),
		},
		"/operator-role-olm.yaml": &vfsgen۰CompressedFileInfo{
			name:             "operator-role-olm.yaml",
			modTime:          time.Time{},
			uncompressedSize: 3856,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x56\xc1\x8e\xdb\x36\x10\xbd\xeb\x2b\x06\xf6\x25\x29\xd6\x72\xd3\x53\xe1\x9e\xdc\x64\xb7\x35\x1a\x78\x81\xf5\xa6\x41\x8e\x23\x6a\x2c\x4d\x97\xe4\xb0\x24\x65\xc7\xfd\xfa\x82\xb4\x9c\xc8\xd1\x6e\x37\x05\x82\xba\xbe\x98\x22\xc7\x6f\xde\xbc\x37\x1a\x73\x0a\xb3\x6f\xf7\x29\xa6\xf0\x96\x15\xd9\x40\x35\x44\x81\xd8\x12\x2c\x1d\xaa\x96\x60\x23\xdb\xb8\x47\x4f\x70\x23\x9d\xad\x31\xb2\x58\x78\xb1\xdc\xdc\xbc\x84\xce\xd6\xe4\x41\x2c\x81\x78\x30\xe2\xa9\x98\x82\x12\x1b\x3d\x57\x5d\x14\x0f\xfa\x08\x08\xd8\x78\x22\x43\x36\x86\x12\x60\x43\x94\xd1\xd7\xb7\xf7\xab\xd7\xd7\xb0\x65\x4d\x50\x73\x38\xfe\x88\x6a\xd8\x73\x6c\x8b\x29\xc4\x96\x03\xec\xc5\x3f\xc0\x56\x3c\x60\x5d\x73\x4a\x8c\x1a\xd8\x6e\xc5\x9b\x23\x0d\x4f\x0d\xfa\x9a\x6d\x03\x4a\xdc\xc1\x73\xd3\x46\x90\xbd\x25\x1f\x5a\x76\x65\x31\x85\xfb\x54\xc6\xe6\xe6\xc4\x24\x1c\x61\x73\xce\x28\xf0\x41\xba\xbe\x86\x41\xb9\xbd\x0a\x57\xf0\x3b\xf9\x90\x92\xfc\x50\x7e\x5f\x4c\xe1\x45\x0a\x99\xf4\x87\x93\x97\x3f\xc1\x41\x3a\x30\x78\x00\x2b\x11\xba\x40\x03\x64\xfa\xa8\xc8\x45\x60\x0b\x4a\x8c\xd3\x8c\x56\xd1\xe7\xb2\x3e\x65\x28\x21\x13\x48\x18\x52\x45\x64\x0b\x98\xcb\x00\xd9\x0e\xc3\x00\x63\x31\x2d\xa6\x90\x3f\x6d\x8c\x6e\x31\x9f\xef\xf7\xfb\x12\x33\xdd\x52\x7c\x33\x3f\x55\x37\x7f\xbb\x7a\x7d\xbd\xde\x5c\xcf\x32\xe5\x62\x0a\xef\xac\xa6\x10\xc0\xd3\x9f\x1d\x7b\xaa\xa1\x3a\x00\x3a\xa7\x59\x61\xa5\x09\x34\xee\x93\x71\xd9\x9d\x6c\x3a\x5b\xd8\x7b\x8e\x6c\x9b\x2b\x08\xbd\xeb\xc5\xf4\xcc\x9d\xcf\x72\x9d\xe8\x71\x38\x0b\x10\x0b\x68\x61\xb2\xdc\xc0\x6a\x33\x81\x9f\x97\x9b\xd5\xe6\xaa\x98\xc2\xfb\xd5\xfd\xaf\xb7\xef\xee\xe1\xfd\xf2\xee\x6e\xb9\xbe\x5f\x5d\x6f\xe0\xf6\x0e\x5e\xdf\xae\xdf\xac\xee\x57\xb7\xeb\x0d\xdc\xde\xc0\x72\xfd\x01\x7e\x5b\xad\xdf\x5c\x01\x71\x6c\xc9\x03\x7d\x74\x3e\xf1\x17\x0f\x9c\x84\xa4\x3a\x79\x7a\x6a\xa0\x13\x81\xd4\x1f\xe9\x39\x38\x52\xbc\x65\x05\x1a\x6d\xd3\x61\x43\xd0\xc8\x8e\xbc\x4d\xed\xe1\xc8\x1b\x0e\xc9\xce\x00\x68\xeb\x62\x0a\x9a\x0d\xc7\xdc\x45\x61\x5c\x54\x4a\xf3\x2d\xdf\xad\xe2\x81\x6d\xbd\x80\x3b\xd1\x54\xa0\xe3\xbe\xb3\x16\xe0\x2b\x54\x25\x76\xb1\x15\xcf\x7f\x65\x32\xe5\xc3\x8f\xa1\x64\x99\xef\x5e\x55\x14\xf1\x55\x61\x28\x62\x8d\x11\x17\x05\x80\x45\x43\x0b\x50\x68\x48\xcf\x1e\x66\xe2\xc8\x63\x14\x5f\x00\x68\xac\x48\x87\x14\x02\xc9\xdf\x05\x4c\xfa\xa0\x49\xe1\x3b\x4d\x61\x51\xcc\x00\x1d\xff\xe2\xa5\x73\x39\x6c\x76\x44\x19\xf4\x50\x01\xe0\x29\x48\xe7\x15\xf5\x11\x93\xef\x26\x05\xc0\x8e\x7c\x35\xd8\x18\xe1\x4c\x26\xe3\x5f\x3a\xa9\x43\x5e\x04\xf2\x3b\x56\x74\x7c\x20\x5b\x3b\x61\x1b\x8f\x4f\x2e\x49\x10\x22\xd9\xb8\x13\xdd\x19\x52\x1a\xd9\x1c\x8f\x94\xd8\x2d\x37\x06\xdd\x09\x44\x79\x8a\x67\x80\xa8\x94\x74\x47\xa4\x01\x3f\xe5\x09\x23\xe5\x65\x4d\x9a\xce\x96\x4a\xb4\x26\x95\x04\xce\x9b\x0d\xc5\xfc\xad\x39\x1c\x17\x0e\xa3\x6a\xf3\xaa\x73\xf5\x09\x65\x9f\x37\x47\x25\x3f\x69\xda\x58\x09\x2f\xba\xaf\x3e\xad\x2a\xb6\x69\x56\x5d\x88\xf6\x63\x4e\xd1\x8e\xfe\x49\xc6\xcf\xf0\xa3\xcc\x4f\x24\x41\x97\x5d\xfb\x22\x4d\x4d\x4e\xcb\xc1\xd0\xc9\x7c\x4f\x79\x06\x85\x4f\xb6\x46\x8c\xb4\xed\x74\xbf\x71\x01\x71\xaa\x3e\xf6\x0b\xe2\xca\x8b\xfd\x43\xaa\x0b\x91\xea\xc5\xc4\xd8\x0f\xd7\x3b\x4a\x63\x36\x83\x87\x05\xd8\x4e\xeb\x47\xa4\x46\x32\x62\xc7\x42\x7e\xad\x81\xf4\x31\x92\xcd\x73\x72\x8c\xcd\xb6\x49\xe3\x98\x2e\xd9\xc0\x33\x98\x54\x1d\xeb\xba\x14\x47\x36\xb4\xbc\x8d\x25\xcb\x23\x9d\x9d\x83\x8e\x93\x24\x8c\x36\xe6\x7b\xaa\x5a\x91\x87\xc1\xc9\x85\x6b\x62\x83\x0d\x3d\x57\x53\x0e\x0a\xd1\x13\x9a\xe3\xf2\xcb\x5d\x83\xce\xf5\x03\xe6\x6c\x7f\xbc\x31\x1f\x4e\xd5\xc1\x41\xc4\x8b\x8e\xa7\xde\x8c\x33\x21\xfe\xed\x1b\x70\x66\x34\xdb\x10\xd1\x46\x3e\x25\x7f\xea\xb0\x62\x8b\xfe\x30\x68\x87\xb9\xd2\x62\xe9\x51\x29\x9e\x34\xd1\x4b\x17\x9f\x35\x31\x07\x5d\x56\xe3\x31\xcf\xa7\x68\xce\x55\x17\xa2\x98\x59\x2b\x39\xdb\x57\x68\x91\xff\xa1\x6d\x53\x3e\x58\x8c\xbc\xa3\xb2\xa6\xdd\x18\x7c\x70\x2f\xb8\x80\x0a\xf9\x4f\x6f\xcc\x71\x06\x86\x42\xc0\xe6\x59\xf6\xa3\x8b\xd1\xff\xf0\xe2\xa1\x74\x17\x22\xf9\xd3\xfd\x63\x40\x36\x5d\x42\x06\xf1\x6b\x34\x9f\x5c\x39\x84\x48\x66\x91\xa7\xc1\x2c\xbf\x05\xe4\xc7\x24\x8c\x58\x8e\xe2\x93\x4a\x4a\x3c\x49\x28\x95\x98\x27\x2d\xee\xa3\xff\x1b\xa7\xff\x0e\x00\x00\xff\xff\xf6\x75\x9c\xad\x10\x0f\x00\x00"),
		},
		"/operator-role-openshift.yaml": &vfsgen۰CompressedFileInfo{
			name:             "operator-role-openshift.yaml",
			modTime:          time.Time{},
			uncompressedSize: 3027,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xc4\x54\xc1\x8e\xdb\x46\x0c\xbd\xeb\x2b\x08\xe9\x92\x14\x6b\xb9\xe9\xa9\x70\x4f\x6e\xb2\xdb\x1a\x0d\xbc\xc0\xca\x69\x90\x23\x35\xa2\x25\x76\x47\xc3\xe9\xcc\xc8\x8a\xfb\xf5\x85\x46\x72\x62\xaf\x76\x91\x16\x08\x60\x5f\x4c\x71\xa8\xc7\xc7\xf7\xa8\xc9\x60\xf1\xfd\x7e\x49\x06\xef\x59\x91\xf1\x54\x41\x10\x08\x0d\xc1\xda\xa2\x6a\x08\x0a\xd9\x87\x1e\x1d\xc1\x9d\x74\xa6\xc2\xc0\x62\xe0\xd5\xba\xb8\x7b\x0d\x9d\xa9\xc8\x81\x18\x02\x71\xd0\x8a\xa3\x24\x03\x25\x26\x38\x2e\xbb\x20\x0e\xf4\x08\x08\x58\x3b\xa2\x96\x4c\xf0\x39\x40\x41\x14\xd1\xb7\xf7\xbb\xcd\xdb\x5b\xd8\xb3\x26\xa8\xd8\x8f\x2f\x51\x05\x3d\x87\x26\xc9\x20\x34\xec\xa1\x17\xf7\x08\x7b\x71\x80\x55\xc5\x43\x63\xd4\xc0\x66\x2f\xae\x1d\x69\x38\xaa\xd1\x55\x6c\x6a\x50\x62\x8f\x8e\xeb\x26\x80\xf4\x86\x9c\x6f\xd8\xe6\x49\x06\xbb\x61\x8c\xe2\xee\xc4\xc4\x8f\xb0\xb1\x67\x10\xf8\x24\xdd\x34\xc3\xd9\xb8\x93\x0a\x37\xf0\x27\x39\x3f\x34\xf9\x29\xff\x31\xc9\xe0\xd5\x50\x92\x4e\x87\xe9\xeb\x5f\xe0\x28\x1d\xb4\x78\x04\x23\x01\x3a\x4f\x67\xc8\xf4\x59\x91\x0d\xc0\x06\x94\xb4\x56\x33\x1a\x45\x5f\xc7\xfa\xd2\x21\x87\x48\x60\xc0\x90\x32\x20\x1b\xc0\x38\x06\xc8\xfe\xbc\x0c\x30\x24\x59\x92\x41\xfc\x35\x21\xd8\xd5\x72\xd9\xf7\x7d\x8e\x91\x6e\x2e\xae\x5e\x9e\xa6\x5b\xbe\xdf\xbc\xbd\xdd\x16\xb7\x8b\x48\x39\xc9\xe0\x83\xd1\xe4\x3d\x38\xfa\xbb\x63\x47\x15\x94\x47\x40\x6b\x35\x2b\x2c\x35\x81\xc6\x7e\x30\x2e\xba\x13\x4d\x67\x03\xbd\xe3\xc0\xa6\xbe\x01\x3f\xb9\x9e\x64\x17\xee\x7c\x95\xeb\x44\x8f\xfd\x45\x81\x18\x40\x03\xe9\xba\x80\x4d\x91\xc2\xaf\xeb\x62\x53\xdc\x24\x19\x7c\xdc\xec\x7e\xbf\xff\xb0\x83\x8f\xeb\x87\x87\xf5\x76\xb7\xb9\x2d\xe0\xfe\x01\xde\xde\x6f\xdf\x6d\x76\x9b\xfb\x6d\x01\xf7\x77\xb0\xde\x7e\x82\x3f\x36\xdb\x77\x37\x40\x1c\x1a\x72\x40\x9f\xad\x1b\xf8\x8b\x03\x1e\x84\xa4\x6a\xf0\xf4\xb4\x40\x27\x02\xc3\x7e\x0c\xcf\xde\x92\xe2\x3d\x2b\xd0\x68\xea\x0e\x6b\x82\x5a\x0e\xe4\xcc\xb0\x1e\x96\x5c\xcb\x7e\xb0\xd3\x03\x9a\x2a\xc9\x40\x73\xcb\x21\x6e\x91\x9f\x0f\x35\xb4\xf9\x9e\xdf\x56\xf2\xc8\xa6\x5a\xc1\x83\x68\x4a\xd0\xf2\xb4\x59\x2b\x70\x25\xaa\x1c\xbb\xd0\x88\xe3\x7f\x22\x99\xfc\xf1\x67\x9f\xb3\x2c\x0f\x6f\x4a\x0a\xf8\x26\x69\x29\x60\x85\x01\x57\x09\x80\xc1\x96\x56\xa0\xb0\x25\xbd\x78\x5c\x88\x25\x87\x41\x5c\x02\xa0\xb1\x24\xed\x87\x12\x18\xfc\x5d\x41\x3a\x15\xa5\x89\xeb\x34\xf9\x55\xb2\x00\xb4\xfc\x9b\x93\xce\xc6\xb2\xc5\x88\x72\xb6\x43\x09\x80\x23\x2f\x9d\x53\x34\x55\xa4\x3f\xa4\x09\xc0\x81\x5c\x79\x96\x98\xe1\xa4\xe9\xfc\x4d\x2b\x95\x8f\x81\x27\x77\x60\x45\xe3\x03\x99\xca\x0a\x9b\x30\x3e\xd9\x41\x02\x1f\xc8\x84\x83\xe8\xae\x25\xa5\x91\xdb\xf1\x48\x89\xd9\x73\xdd\xa2\x3d\x81\x28\x47\xe1\x02\x10\x95\x92\x6e\x44\x3a\xe3\xa7\x1c\x61\xa0\x18\x56\xa4\xe9\x22\x54\xa2\x35\xa9\x41\xe0\x98\xac\x29\xc4\x7f\xcd\x7e\x0c\x2c\x06\xd5\xc4\xa8\xb3\xd5\x09\xa5\x8f\xc9\xd9\xc8\x2f\x9a\x36\x57\xc2\x89\x9e\xa6\x1f\xa2\x92\xcd\x70\x57\x5d\x89\xf6\x73\x4e\xd1\x81\x66\x32\xce\x9a\xbc\x80\x87\x36\x1a\xf4\x04\xb1\x22\xab\xe5\xd8\xd2\xc9\x67\x47\xf1\xba\xf1\x5f\x1c\x0c\x18\x68\xdf\xe9\x29\x71\x05\x1d\xca\xa9\xf6\x09\x71\xe5\xc4\xfc\x25\xe5\x95\x48\x4d\x62\x62\x98\xee\xd1\x07\x1a\x6e\xd4\x08\xee\x57\x60\x3a\xad\x9f\x91\x1a\xa9\x15\x33\x17\xf2\xbf\x1a\x18\x17\x62\x01\x69\xd9\xb1\xae\x72\xb1\x64\x7c\xc3\xfb\x90\xb3\x3c\xb3\x29\xb1\x68\xfc\x32\xfd\x2c\xb1\xec\xa9\x6c\x44\x1e\xcf\x4e\xae\xb9\xe4\x0b\x48\xb9\xc5\x9a\xbe\x35\x53\x2c\xf2\xc1\x11\xb6\x63\xf8\x34\xdb\xa2\xb5\xd3\x07\x7b\x91\x9f\x27\x96\xe7\xb7\xd4\xd9\x41\xc0\xab\x7e\xee\x93\x19\x17\x42\xfc\xdf\x35\xbb\x30\x9a\x8d\x0f\x68\x02\x9f\x9a\xbf\x74\x58\xb2\x41\x77\x3c\x5b\x87\xa5\xd2\x62\xe8\x59\x29\x5e\x34\xd1\x49\x17\xbe\x69\x62\x2c\xba\xae\xc6\x73\x9e\x2f\xd1\x5c\xaa\xce\x07\x69\x17\x8d\xc4\x6e\x73\xca\xff\x06\x00\x00\xff\xff\x2e\xce\xda\xac\xd3\x0b\x00\x00"),
		},
		"/operator-service-account.yaml": &vfsgen۰CompressedFileInfo{
			name:             "operator-service-account.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1039,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\x4d\x6f\x9b\x40\x14\xbc\xef\xaf\x18\x99\x4b\x22\xf9\xa3\xed\xd1\x3d\xd1\xc4\x56\x51\x23\x5b\x0a\x4e\xa3\x1c\x9f\xe1\x19\x9e\x02\xfb\xe8\xee\x12\xe2\x7f\x5f\x2d\xb6\x9b\x44\xbd\x66\x6f\x88\x61\x3e\x76\x86\x04\xb3\xcf\x3b\x26\xc1\x9d\x14\x6c\x3d\x97\x08\x8a\x50\x33\xd2\x8e\x8a\x9a\x91\xeb\x21\x0c\xe4\x18\x6b\xed\x6d\x49\x41\xd4\xe2\x2a\xcd\xd7\xd7\xe8\x6d\xc9\x0e\x6a\x19\xea\xd0\xaa\x63\x93\xa0\x50\x1b\x9c\xec\xfb\xa0\x0e\xcd\x89\x10\x54\x39\xe6\x96\x6d\xf0\x73\x20\x67\x1e\xd9\x37\xdb\x5d\x76\xb3\xc2\x41\x1a\x46\x29\xfe\xf4\x11\x97\x18\x24\xd4\x26\x41\xa8\xc5\x63\x50\xf7\x8c\x83\x3a\x50\x59\x4a\x14\xa6\x06\x62\x0f\xea\xda\x93\x0d\xc7\x15\xb9\x52\x6c\x85\x42\xbb\xa3\x93\xaa\x0e\xd0\xc1\xb2\xf3\xb5\x74\x73\x93\x60\x17\x63\xe4\xeb\x8b\x13\x7f\xa2\x1d\x35\x83\xe2\x49\xfb\x73\x86\x77\x71\xcf\xb7\x30\xc5\x6f\x76\x3e\x8a\x7c\x9b\x7f\x31\x09\xae\x22\x64\x72\x7e\x39\xb9\xfe\x8e\xa3\xf6\x68\xe9\x08\xab\x01\xbd\xe7\x77\xcc\xfc\x5a\x70\x17\x20\x16\x85\xb6\x5d\x23\x64\x0b\x7e\x8b\xf5\x4f\x61\x8e\xd1\x40\xe4\xd0\x7d\x20\xb1\xa0\x31\x06\xf4\xf0\x1e\x06\x0a\x26\x31\x09\xc6\x53\x87\xd0\x2d\x17\x8b\x61\x18\xe6\x34\xda\x9d\xab\xab\x16\x97\x74\x8b\xbb\xec\x66\xb5\xc9\x57\xb3\xd1\xb2\x49\xf0\x60\x1b\xf6\x1e\x8e\xff\xf4\xe2\xb8\xc4\xfe\x08\xea\xba\x46\x0a\xda\x37\x8c\x86\x86\x58\xdc\xd8\xce\x58\xba\x58\x0c\x4e\x82\xd8\x6a\x0a\x7f\x6e\xdd\x24\x1f\xda\x79\xbb\xae\x8b\x3d\xf1\x1f\x00\x6a\x41\x16\x93\x34\x47\x96\x4f\xf0\x23\xcd\xb3\x7c\x6a\x12\x3c\x66\xbb\x9f\xdb\x87\x1d\x1e\xd3\xfb\xfb\x74\xb3\xcb\x56\x39\xb6\xf7\xb8\xd9\x6e\x6e\xb3\x5d\xb6\xdd\xe4\xd8\xae\x91\x6e\x9e\xf0\x2b\xdb\xdc\x4e\xc1\x12\x6a\x76\xe0\xd7\xce\x45\xff\xea\x20\xf1\x22\xb9\x8c\x9d\x5e\x06\x74\x31\x10\xf7\x11\x9f\x7d\xc7\x85\x1c\xa4\x40\x43\xb6\xea\xa9\x62\x54\xfa\xc2\xce\xc6\x79\x74\xec\x5a\xf1\xb1\x4e\x0f\xb2\xa5\x49\xd0\x48\x2b\x61\x5c\x91\xff\x3f\x54\x94\xf9\xcc\x7f\xcb\x50\x27\xe7\x39\x2d\xf1\xf2\xd5\x3c\x8b\x2d\x97\xc8\xd9\xbd\x48\xc1\x69\x51\x68\x6f\x83\x69\x39\x50\x49\x81\x96\x06\xb0\xd4\xf2\x12\x05\xb5\xdc\xcc\x9e\x67\xda\xb1\xa3\xa0\xce\x00\x0d\xed\xb9\xf1\x11\x82\x58\xe5\x12\x93\x33\x68\x62\xfe\x06\x00\x00\xff\xff\xaf\x8c\x67\xdd\x0f\x04\x00\x00"),
		},
		"/platform-cr.yaml": &vfsgen۰CompressedFileInfo{
			name:             "platform-cr.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1052,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\xcd\x6e\xdb\x3c\x10\xbc\xf3\x29\x06\xd6\x25\x01\x1c\xfb\xfb\x7a\x74\x4f\x6a\x62\xa3\x42\x03\xb9\x88\x9c\x06\x39\xae\xa5\xb5\xb4\x08\x45\xaa\x24\x15\xc5\x6f\x5f\x50\x96\x1b\x07\xbd\x86\x37\x81\xcb\xf9\xd9\x19\x25\xb8\xf9\xbc\xa3\x12\xdc\x4b\xc9\xc6\x73\x85\x60\x11\x1a\x46\xda\x51\xd9\x30\x0a\x7b\x08\x03\x39\xc6\xc6\xf6\xa6\xa2\x20\xd6\xe0\x2a\x2d\x36\xd7\xe8\x4d\xc5\x0e\xd6\x30\xac\x43\x6b\x1d\xab\x04\xa5\x35\xc1\xc9\xbe\x0f\xd6\x41\x9f\x00\x41\xb5\x63\x6e\xd9\x04\xbf\x00\x0a\xe6\x11\x3d\xdf\xee\xb2\xdb\x35\x0e\xa2\x19\x95\xf8\xd3\x23\xae\x30\x48\x68\x54\x82\xd0\x88\xc7\x60\xdd\x0b\x0e\xd6\x81\xaa\x4a\x22\x31\x69\x88\x39\x58\xd7\x9e\x64\x38\xae\xc9\x55\x62\x6a\x94\xb6\x3b\x3a\xa9\x9b\x00\x3b\x18\x76\xbe\x91\x6e\xa1\x12\xec\xa2\x8d\x62\x73\x56\xe2\x4f\xb0\x23\x67\xb0\x78\xb6\xfd\xe4\xe1\xc2\xee\xb4\x85\x39\x7e\xb1\xf3\x91\xe4\xcb\xe2\x3f\x95\xe0\x2a\x8e\xcc\xa6\xcb\xd9\xf5\x57\x1c\x6d\x8f\x96\x8e\x30\x36\xa0\xf7\x7c\x81\xcc\x6f\x25\x77\x01\x62\x50\xda\xb6\xd3\x42\xa6\xe4\x77\x5b\x7f\x19\x16\x18\x05\x44\x0c\xbb\x0f\x24\x06\x34\xda\x80\x3d\x5c\x8e\x81\x82\x4a\x54\x82\xf1\x34\x21\x74\xab\xe5\x72\x18\x86\x05\x8d\x72\x17\xd6\xd5\xcb\xb3\xbb\xe5\x7d\x76\xbb\xce\x8b\xf5\xcd\x28\x59\x25\x78\x34\x9a\xbd\x87\xe3\xdf\xbd\x38\xae\xb0\x3f\x82\xba\x4e\x4b\x49\x7b\xcd\xd0\x34\xc4\xe0\xc6\x74\xc6\xd0\xc5\x60\x70\x12\xc4\xd4\x73\xf8\x29\x75\x95\x7c\x48\xe7\x7d\x5d\x67\x79\xe2\x3f\x0c\x58\x03\x32\x98\xa5\x05\xb2\x62\x86\x6f\x69\x91\x15\x73\x95\xe0\x29\xdb\x7d\xdf\x3e\xee\xf0\x94\x3e\x3c\xa4\xf9\x2e\x5b\x17\xd8\x3e\xe0\x76\x9b\xdf\x65\xbb\x6c\x9b\x17\xd8\x6e\x90\xe6\xcf\xf8\x91\xe5\x77\x73\xb0\x84\x86\x1d\xf8\xad\x73\x51\xbf\x75\x90\xb8\x48\xae\x62\xa6\xe7\x02\x9d\x05\xc4\x7e\xc4\x6f\xdf\x71\x29\x07\x29\xa1\xc9\xd4\x3d\xd5\x8c\xda\xbe\xb2\x33\xb1\x1e\x1d\xbb\x56\x7c\x8c\xd3\x83\x4c\xa5\x12\x68\x69\x25\x8c\x2d\xf2\xff\x9a\x8a\x34\x9f\xf9\x6f\x29\xea\x64\xaa\xd3\x0a\x25\xb5\xac\x2f\xe3\x7b\xfd\x5f\xbd\x88\xa9\x56\xc8\x4c\xe0\xda\x8d\xa2\x7e\x6a\x0a\xb1\xe7\xaa\xe5\x40\x15\x05\x5a\x29\xc0\x50\xcb\xd3\xfb\x9b\x17\x05\x68\xda\xb3\xf6\xf1\x06\x31\xd7\x15\x66\xd3\xdd\x4c\xfd\x09\x00\x00\xff\xff\xdb\xec\x78\x40\x1c\x04\x00\x00"),
		},
		"/platform-integration-kit-groovy.yaml": &vfsgen۰CompressedFileInfo{
			name:             "platform-integration-kit-groovy.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1310,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\x4d\x8f\xdb\x36\x10\xbd\xf3\x57\x3c\x58\x97\x04\x58\xcb\x6d\x8f\xee\xc9\xdd\xec\xa2\x42\x02\x1b\x58\x39\x0d\x72\x1c\x8b\x63\x79\x60\x89\x64\x87\xd4\x2a\xfe\xf7\x05\x25\xbb\x71\x10\xa0\xcd\x21\xbc\x49\x9c\x79\x1f\xf3\x86\x05\x96\x3f\xef\x98\x02\x1f\xa4\x61\x17\xd9\x22\x79\xa4\x13\x63\x13\xa8\x39\x31\x6a\x7f\x4c\x23\x29\xe3\xd9\x0f\xce\x52\x12\xef\xf0\x66\x53\x3f\xbf\xc5\xe0\x2c\x2b\xbc\x63\x78\x45\xef\x95\x4d\x81\xc6\xbb\xa4\x72\x18\x92\x57\x74\x33\x20\xa8\x55\xe6\x9e\x5d\x8a\x25\x50\x33\x4f\xe8\xdb\xdd\xbe\x7a\x7c\xc2\x51\x3a\x86\x95\x38\x37\xb1\xc5\x28\xe9\x64\x0a\xa4\x93\x44\x8c\x5e\xcf\x38\x7a\x05\x59\x2b\x99\x98\x3a\x88\x3b\x7a\xed\x67\x19\xca\x2d\xa9\x15\xd7\xa2\xf1\xe1\xa2\xd2\x9e\x12\xfc\xe8\x58\xe3\x49\x42\x69\x0a\xec\xb3\x8d\xfa\xf9\xa6\x24\xce\xb0\x13\x67\xf2\xf8\xec\x87\xab\x87\x3b\xbb\xd7\x29\x3c\xe0\x2f\xd6\x98\x49\x7e\x2b\x7f\x31\x05\xde\xe4\x92\xc5\xf5\x72\xf1\xf6\x77\x5c\xfc\x80\x9e\x2e\x70\x3e\x61\x88\x7c\x87\xcc\x5f\x1a\x0e\x09\xe2\xd0\xf8\x3e\x74\x42\xae\xe1\xaf\xb6\xfe\x65\x28\x31\x09\xc8\x18\xfe\x90\x48\x1c\x68\xb2\x01\x7f\xbc\x2f\x03\x25\x53\x98\x02\xd3\x39\xa5\x14\xd6\xab\xd5\x38\x8e\x25\x4d\x72\x4b\xaf\xed\xea\xe6\x6e\xf5\xa1\x7a\x7c\xda\xd6\x4f\xcb\x49\xb2\x29\xf0\xd1\x75\x1c\x23\x94\xff\x1e\x44\xd9\xe2\x70\x01\x85\xd0\x49\x43\x87\x8e\xd1\xd1\x98\x83\x9b\xd2\x99\x42\x17\x87\x51\x25\x89\x6b\x1f\x10\xaf\xa9\x9b\xe2\x9b\x74\xbe\x8e\xeb\x26\x4f\xe2\x37\x05\xde\x81\x1c\x16\x9b\x1a\x55\xbd\xc0\x1f\x9b\xba\xaa\x1f\x4c\x81\x4f\xd5\xfe\xcf\xdd\xc7\x3d\x3e\x6d\x5e\x5e\x36\xdb\x7d\xf5\x54\x63\xf7\x82\xc7\xdd\xf6\x5d\xb5\xaf\x76\xdb\x1a\xbb\x67\x6c\xb6\x9f\xf1\xbe\xda\xbe\x7b\x00\x4b\x3a\xb1\x82\xbf\x04\xcd\xfa\xbd\x42\xf2\x20\xd9\xe6\x4c\x6f\x0b\x74\x13\x90\xf7\x23\x7f\xc7\xc0\x8d\x1c\xa5\x41\x47\xae\x1d\xa8\x65\xb4\xfe\x95\xd5\xe5\xf5\x08\xac\xbd\xc4\x1c\x67\x04\x39\x6b\x0a\x74\xd2\x4b\x9a\xb6\x28\x7e\x6f\x2a\xd3\xfc\xcc\xb7\x65\x28\xc8\x75\x9d\xd6\x68\xa8\xe7\xee\x3e\xbe\xd7\x5f\xcd\x59\x9c\x5d\xa3\x72\x89\x5b\x9d\x44\xbd\x97\x64\x7a\x4e\x64\x29\xd1\xda\x00\x8e\x7a\x5e\xa3\x55\xef\x5f\x2f\x06\xe8\xe8\xc0\x5d\xcc\x17\xc8\x89\xae\xb1\x98\x50\x97\xe7\xc5\xf4\xeb\x3b\x8a\x46\x99\x12\xdb\xf2\x70\x29\x67\xaa\x5d\x60\xa5\xe4\xf5\x7f\xcb\x67\xe2\x2b\xfa\xd2\xff\x67\xdb\x59\x52\x99\x2e\x81\xd7\x08\x1d\xa5\xfc\x4c\x4d\x0e\x25\xcb\xb4\x1c\xd8\x59\x76\x8d\xf0\x55\xf6\x12\xfd\xab\x5b\x7b\x6d\x6f\x08\x33\xdc\x79\x75\xe3\xd2\xc1\x25\xe9\x79\xd9\x93\xb8\x1f\xeb\xe8\x3c\x59\xd6\xe5\x3c\xa5\x7f\x02\x00\x00\xff\xff\x58\xbe\x32\x55\x1e\x05\x00\x00"),
		},
		"/platform-integration-kit-java.yaml": &vfsgen۰CompressedFileInfo{
			name:             "platform-integration-kit-java.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1306,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\x4d\x8f\xdb\x36\x10\xbd\xf3\x57\x3c\x58\x97\x04\xb0\xe5\xb6\x47\xf5\xe4\x6e\x6c\x54\x48\x60\x03\x2b\xa7\x41\x8e\x63\x71\x2c\x4d\x2d\x91\x2c\x49\x59\xf1\xbf\x2f\x28\xdb\x5d\x2f\x16\x68\x7b\x58\xde\x44\xcd\xbc\x8f\x79\xc3\x0c\x8b\xf7\x3b\x2a\xc3\x17\xa9\xd9\x04\xd6\x88\x16\xb1\x65\xac\x1c\xd5\x2d\xa3\xb2\xc7\x38\x92\x67\x6c\xec\x60\x34\x45\xb1\x06\x1f\x56\xd5\xe6\x23\x06\xa3\xd9\xc3\x1a\x86\xf5\xe8\xad\x67\x95\xa1\xb6\x26\x7a\x39\x0c\xd1\x7a\x74\x57\x40\x50\xe3\x99\x7b\x36\x31\xe4\x40\xc5\x3c\xa1\x6f\x77\xfb\xf2\x69\x8d\xa3\x74\x0c\x2d\xe1\xda\xc4\x1a\xa3\xc4\x56\x65\x88\xad\x04\x8c\xd6\x9f\x70\xb4\x1e\xa4\xb5\x24\x62\xea\x20\xe6\x68\x7d\x7f\x95\xe1\xb9\x21\xaf\xc5\x34\xa8\xad\xbb\x78\x69\xda\x08\x3b\x1a\xf6\xa1\x15\x97\xab\x0c\xfb\x64\xa3\xda\xdc\x95\x84\x2b\xec\xc4\x19\x2d\xbe\xdb\xe1\xe6\xe1\xc1\xee\x6d\x0a\x73\xfc\xc1\x3e\x24\x92\x5f\xf2\x9f\x54\x86\x0f\xa9\x64\x76\xfb\x39\xfb\xf8\x2b\x2e\x76\x40\x4f\x17\x18\x1b\x31\x04\x7e\x40\xe6\x1f\x35\xbb\x08\x31\xa8\x6d\xef\x3a\x21\x53\xf3\x8b\xad\x7f\x18\x72\x4c\x02\x12\x86\x3d\x44\x12\x03\x9a\x6c\xc0\x1e\x1f\xcb\x40\x51\x65\x2a\xc3\x74\xda\x18\x5d\xb1\x5c\x8e\xe3\x98\xd3\x24\x37\xb7\xbe\x59\xde\xdd\x2d\xbf\x94\x4f\xeb\x6d\xb5\x5e\x4c\x92\x55\x86\xaf\xa6\xe3\x10\xe0\xf9\xaf\x41\x3c\x6b\x1c\x2e\x20\xe7\x3a\xa9\xe9\xd0\x31\x3a\x1a\x53\x70\x53\x3a\x53\xe8\x62\x30\x7a\x89\x62\x9a\x39\xc2\x2d\x75\x95\xbd\x4a\xe7\x65\x5c\x77\x79\x12\x5e\x15\x58\x03\x32\x98\xad\x2a\x94\xd5\x0c\xbf\xad\xaa\xb2\x9a\xab\x0c\xdf\xca\xfd\xef\xbb\xaf\x7b\x7c\x5b\x3d\x3f\xaf\xb6\xfb\x72\x5d\x61\xf7\x8c\xa7\xdd\xf6\x53\xb9\x2f\x77\xdb\x0a\xbb\x0d\x56\xdb\xef\xf8\x5c\x6e\x3f\xcd\xc1\x12\x5b\xf6\xe0\x1f\xce\x27\xfd\xd6\x43\xd2\x20\x59\xa7\x4c\xef\x0b\x74\x17\x90\xf6\x23\x7d\x07\xc7\xb5\x1c\xa5\x46\x47\xa6\x19\xa8\x61\x34\xf6\xcc\xde\xa4\xf5\x70\xec\x7b\x09\x29\xce\x00\x32\x5a\x65\xe8\xa4\x97\x38\x6d\x51\x78\x6b\x2a\xd1\xbc\xe7\xdb\x52\xe4\xe4\xb6\x4e\x05\x6a\xea\xb9\x7b\x8c\xef\xfc\xb3\x3a\x89\xd1\x05\x4a\x13\xb9\xf1\x93\xa8\xcf\x12\x55\xcf\x91\x34\x45\x2a\x14\x60\xa8\xe7\x02\x7f\xd2\x99\x14\xd0\xd1\x81\xbb\x90\xae\x91\xf2\x2c\x30\x9b\x30\x17\xa7\xd9\x74\xf5\x86\xa0\xf6\x4c\x91\x75\x7e\xb8\xe4\x57\xa2\x9d\x63\x4f\xd1\xfa\xff\x2c\xbf\xd2\xde\xd0\x17\xf6\x5f\xdb\x4e\x12\xf3\x78\x71\x5c\xc0\x75\x14\xd3\x23\x55\x29\x92\x24\x53\xb3\x63\xa3\xd9\xd4\xc2\x37\xd9\x0b\xf4\x67\x53\x58\xdf\xdc\x11\xae\x70\xa7\xe5\x9d\xcb\x0f\x26\x4a\xcf\x8b\x9e\xc4\xfc\xbf\x8e\xce\x92\x66\xbf\x48\x33\xfa\x3b\x00\x00\xff\xff\x86\x14\x49\x65\x1a\x05\x00\x00"),
		},
		"/platform-integration-kit-js.yaml": &vfsgen۰CompressedFileInfo{
			name:             "platform-integration-kit-js.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1302,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\x4d\x8f\xdb\x36\x10\xbd\xf3\x57\x3c\x58\x97\x04\xb0\xe5\xb6\x47\xf5\xe4\x6e\x6c\x54\x48\x60\x03\x2b\xa7\x41\x8e\x63\x71\x2c\x4d\x2c\x91\x2c\x49\xad\xd6\xff\xbe\xa0\x6c\x77\xbd\x58\xa0\xcd\x61\x79\x13\x35\xf3\x3e\xe6\x0d\x33\x2c\xde\xef\xa8\x0c\x5f\xa4\x66\x13\x58\x23\x5a\xc4\x96\xb1\x72\x54\xb7\x8c\xca\x1e\xe3\x48\x9e\xb1\xb1\x83\xd1\x14\xc5\x1a\x7c\x58\x55\x9b\x8f\x18\x8c\x66\x0f\x6b\x18\xd6\xa3\xb7\x9e\x55\x86\xda\x9a\xe8\xe5\x30\x44\xeb\xd1\x5d\x00\x41\x8d\x67\xee\xd9\xc4\x90\x03\x15\xf3\x84\xbe\xdd\xed\xcb\x87\x35\x8e\xd2\x31\xb4\x84\x4b\x13\x6b\x8c\x12\x5b\x95\x21\xb6\x12\x30\x5a\x7f\xc2\xd1\x7a\x90\xd6\x92\x88\xa9\x83\x98\xa3\xf5\xfd\x45\x86\xe7\x86\xbc\x16\xd3\xa0\xb6\xee\xec\xa5\x69\x23\xec\x68\xd8\x87\x56\x5c\xae\x32\xec\x93\x8d\x6a\x73\x53\x12\x2e\xb0\x13\x67\xb4\xf8\x6e\x87\xab\x87\x3b\xbb\xd7\x29\xcc\xf1\x17\xfb\x90\x48\x7e\xcb\x7f\x51\x19\x3e\xa4\x92\xd9\xf5\xe7\xec\xe3\xef\x38\xdb\x01\x3d\x9d\x61\x6c\xc4\x10\xf8\x0e\x99\x9f\x6b\x76\x11\x62\x50\xdb\xde\x75\x42\xa6\xe6\x17\x5b\xff\x32\xe4\x98\x04\x24\x0c\x7b\x88\x24\x06\x34\xd9\x80\x3d\xde\x97\x81\xa2\xca\x54\x86\xe9\xb4\x31\xba\x62\xb9\x1c\xc7\x31\xa7\x49\x6e\x6e\x7d\xb3\xbc\xb9\x5b\x7e\x29\x1f\xd6\xdb\x6a\xbd\x98\x24\xab\x0c\x5f\x4d\xc7\x21\xc0\xf3\xdf\x83\x78\xd6\x38\x9c\x41\xce\x75\x52\xd3\xa1\x63\x74\x34\xa6\xe0\xa6\x74\xa6\xd0\xc5\x60\xf4\x12\xc5\x34\x73\x84\x6b\xea\x2a\x7b\x95\xce\xcb\xb8\x6e\xf2\x24\xbc\x2a\xb0\x06\x64\x30\x5b\x55\x28\xab\x19\xfe\x58\x55\x65\x35\x57\x19\xbe\x95\xfb\x3f\x77\x5f\xf7\xf8\xb6\x7a\x7c\x5c\x6d\xf7\xe5\xba\xc2\xee\x11\x0f\xbb\xed\xa7\x72\x5f\xee\xb6\x15\x76\x1b\xac\xb6\xdf\xf1\xb9\xdc\x7e\x9a\x83\x25\xb6\xec\xc1\xcf\xce\x27\xfd\xd6\x43\xd2\x20\x59\xa7\x4c\x6f\x0b\x74\x13\x90\xf6\x23\x7d\x07\xc7\xb5\x1c\xa5\x46\x47\xa6\x19\xa8\x61\x34\xf6\x89\xbd\x49\xeb\xe1\xd8\xf7\x12\x52\x9c\x01\x64\xb4\xca\xd0\x49\x2f\x71\xda\xa2\xf0\xd6\x54\xa2\x79\xcf\xb7\xa5\xc8\xc9\x75\x9d\x0a\xd4\xd4\x73\x77\x1f\xdf\xd3\xaf\xea\x24\x46\x17\x28\x4d\xe4\xc6\x4f\xa2\x3e\x4b\x54\x3d\x47\xd2\x14\xa9\x50\x80\xa1\x9e\x0b\xfc\x08\x0a\xe8\xe8\xc0\x5d\x48\x97\x48\x69\x16\x98\x4d\x88\x8b\xd3\x6c\xba\x7a\x03\x5f\x7b\xa6\xc8\x3a\x3f\x9c\xf3\x0b\xcd\xce\xb1\xa7\x68\xfd\xff\x96\x5f\x48\xaf\xe8\x0b\xfb\x9f\x6d\x27\x89\x79\x3c\x3b\x2e\xe0\x3a\x8a\xe9\x89\xaa\x14\x48\x92\xa9\xd9\xb1\xd1\x6c\x6a\xe1\xab\xec\x05\xfa\x27\x53\x58\xdf\xdc\x10\x2e\x70\xa7\xe5\x8d\xcb\x0f\x26\x4a\xcf\x8b\x9e\xc4\xfc\x5c\x47\x67\x49\xb3\x5f\xfc\x08\xff\x04\x00\x00\xff\xff\x1f\x6a\x8f\x3b\x16\x05\x00\x00"),
		},
		"/platform-integration-kit-knative.yaml": &vfsgen۰CompressedFileInfo{
			name:             "platform-integration-kit-knative.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1313,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\xcd\xce\xdb\x36\x10\xbc\xf3\x29\x06\xd6\x25\x01\x6c\xb9\xed\x51\x3d\xb9\x5f\x6c\x54\x48\x60\x03\x9f\x9c\x06\x39\xae\xc5\xb5\xb4\xb0\x44\xb2\x24\x65\xc5\x6f\x5f\x50\x96\x1b\x07\x01\x5a\x04\x08\x6f\x12\x77\xe7\x67\x67\x99\x61\xf5\xf3\x8e\xca\xf0\x41\x6a\x36\x81\x35\xa2\x45\x6c\x19\x1b\x47\x75\xcb\xa8\xec\x39\x8e\xe4\x19\x3b\x3b\x18\x4d\x51\xac\xc1\x9b\x4d\xb5\x7b\x8b\xc1\x68\xf6\xb0\x86\x61\x3d\x7a\xeb\x59\x65\xa8\xad\x89\x5e\x4e\x43\xb4\x1e\xdd\x1d\x10\xd4\x78\xe6\x9e\x4d\x0c\x39\x50\x31\x4f\xe8\xfb\xc3\xb1\x7c\xd9\xe2\x2c\x1d\x43\x4b\xb8\x37\xb1\xc6\x28\xb1\x55\x19\x62\x2b\x01\xa3\xf5\x17\x9c\xad\x07\x69\x2d\x89\x98\x3a\x88\x39\x5b\xdf\xdf\x65\x78\x6e\xc8\x6b\x31\x0d\x6a\xeb\x6e\x5e\x9a\x36\xc2\x8e\x86\x7d\x68\xc5\xe5\x2a\xc3\x31\xd9\xa8\x76\x0f\x25\xe1\x0e\x3b\x71\x46\x8b\xcf\x76\x98\x3d\x3c\xd9\x9d\xa7\xb0\xc4\x5f\xec\x43\x22\xf9\x2d\xff\x45\x65\x78\x93\x4a\x16\xf3\xe5\xe2\xed\xef\xb8\xd9\x01\x3d\xdd\x60\x6c\xc4\x10\xf8\x09\x99\xbf\xd4\xec\x22\xc4\xa0\xb6\xbd\xeb\x84\x4c\xcd\x5f\x6d\xfd\xcb\x90\x63\x12\x90\x30\xec\x29\x92\x18\xd0\x64\x03\xf6\xfc\x5c\x06\x8a\x2a\x53\x19\xa6\xd3\xc6\xe8\x8a\xf5\x7a\x1c\xc7\x9c\x26\xb9\xb9\xf5\xcd\xfa\xe1\x6e\xfd\xa1\x7c\xd9\xee\xab\xed\x6a\x92\xac\x32\x7c\x34\x1d\x87\x00\xcf\x7f\x0f\xe2\x59\xe3\x74\x03\x39\xd7\x49\x4d\xa7\x8e\xd1\xd1\x98\x82\x9b\xd2\x99\x42\x17\x83\xd1\x4b\x14\xd3\x2c\x11\xe6\xd4\x55\xf6\x4d\x3a\x5f\xc7\xf5\x90\x27\xe1\x9b\x02\x6b\x40\x06\x8b\x4d\x85\xb2\x5a\xe0\x8f\x4d\x55\x56\x4b\x95\xe1\x53\x79\xfc\xf3\xf0\xf1\x88\x4f\x9b\xd7\xd7\xcd\xfe\x58\x6e\x2b\x1c\x5e\xf1\x72\xd8\xbf\x2b\x8f\xe5\x61\x5f\xe1\xb0\xc3\x66\xff\x19\xef\xcb\xfd\xbb\x25\x58\x62\xcb\x1e\xfc\xc5\xf9\xa4\xdf\x7a\x48\x1a\x24\xeb\x94\xe9\x63\x81\x1e\x02\xd2\x7e\xa4\xef\xe0\xb8\x96\xb3\xd4\xe8\xc8\x34\x03\x35\x8c\xc6\x5e\xd9\x9b\xb4\x1e\x8e\x7d\x2f\x21\xc5\x19\x40\x46\xab\x0c\x9d\xf4\x12\xa7\x2d\x0a\xdf\x9b\x4a\x34\x3f\xf3\x6d\x29\x72\x32\xaf\x53\x81\x9a\x7a\xee\x9e\xe3\xbb\xfe\xaa\x2e\x62\x74\x81\xd2\x44\x6e\xfc\x24\xea\xbd\x44\xd5\x73\x24\x4d\x91\x0a\x05\x18\xea\xb9\xc0\xc5\x50\x94\x2b\x2b\xa0\xa3\x13\x77\x21\xdd\x20\x45\x5a\x60\x31\xc1\xae\x2e\x8b\xe9\xd7\x77\x1c\xb5\x67\x8a\xac\xf3\xd3\x2d\xbf\x73\x1d\x1c\x7b\x8a\xd6\xff\x6f\xf9\x9d\x79\x46\x5f\xd9\xff\x6c\xbb\x48\xcc\xe3\xcd\x71\x01\xd7\x51\x4c\xef\x54\xa5\x54\x92\x4c\xcd\x8e\x8d\x66\x53\x0b\xcf\xb2\x57\xe8\xaf\xa6\xb0\xbe\x79\x20\xdc\xe1\x2e\xeb\x07\x97\x1f\x4c\x94\x9e\x57\x3d\x89\xf9\xb1\x8e\x79\x4e\xff\x04\x00\x00\xff\xff\x86\x07\x9c\x5b\x21\x05\x00\x00"),
		},
		"/platform-integration-kit-kotlin.yaml": &vfsgen۰CompressedFileInfo{
			name:             "platform-integration-kit-kotlin.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1310,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\x4d\x8f\xdb\x36\x10\xbd\xf3\x57\x3c\x58\x97\x04\x58\xcb\x6d\x8f\xea\xc9\xdd\xec\xa2\x42\x02\x1b\x58\x39\x0d\x72\x1c\x8b\x63\x69\x60\x8a\x64\x49\x6a\x15\xff\xfb\x82\x92\xdd\x38\x08\xd0\xe6\x10\xde\x24\xce\xbc\x8f\x79\xc3\x02\xeb\x9f\x77\x54\x81\x0f\xd2\xb2\x8d\xac\x91\x1c\x52\xcf\xd8\x7a\x6a\x7b\x46\xe3\x4e\x69\xa2\xc0\x78\x76\xa3\xd5\x94\xc4\x59\xbc\xd9\x36\xcf\x6f\x31\x5a\xcd\x01\xce\x32\x5c\xc0\xe0\x02\xab\x02\xad\xb3\x29\xc8\x71\x4c\x2e\xc0\x2c\x80\xa0\x2e\x30\x0f\x6c\x53\x2c\x81\x86\x79\x46\xdf\xed\x0f\xf5\xe3\x13\x4e\x62\x18\x5a\xe2\xd2\xc4\x1a\x93\xa4\x5e\x15\x48\xbd\x44\x4c\x2e\x9c\x71\x72\x01\xa4\xb5\x64\x62\x32\x10\x7b\x72\x61\x58\x64\x04\xee\x28\x68\xb1\x1d\x5a\xe7\x2f\x41\xba\x3e\xc1\x4d\x96\x43\xec\xc5\x97\xaa\xc0\x21\xdb\x68\x9e\x6f\x4a\xe2\x02\x3b\x73\x26\x87\xcf\x6e\xbc\x7a\xb8\xb3\x7b\x9d\xc2\x03\xfe\xe2\x10\x33\xc9\x6f\xe5\x2f\xaa\xc0\x9b\x5c\xb2\xba\x5e\xae\xde\xfe\x8e\x8b\x1b\x31\xd0\x05\xd6\x25\x8c\x91\xef\x90\xf9\x4b\xcb\x3e\x41\x2c\x5a\x37\x78\x23\x64\x5b\xfe\x6a\xeb\x5f\x86\x12\xb3\x80\x8c\xe1\x8e\x89\xc4\x82\x66\x1b\x70\xa7\xfb\x32\x50\x52\x85\x2a\x30\x9f\x3e\x25\x5f\x6d\x36\xd3\x34\x95\x34\xcb\x2d\x5d\xe8\x36\x37\x77\x9b\x0f\xf5\xe3\xd3\xae\x79\x5a\xcf\x92\x55\x81\x8f\xd6\x70\x8c\x08\xfc\xf7\x28\x81\x35\x8e\x17\x90\xf7\x46\x5a\x3a\x1a\x86\xa1\x29\x07\x37\xa7\x33\x87\x2e\x16\x53\x90\x24\xb6\x7b\x40\xbc\xa6\xae\x8a\x6f\xd2\xf9\x3a\xae\x9b\x3c\x89\xdf\x14\x38\x0b\xb2\x58\x6d\x1b\xd4\xcd\x0a\x7f\x6c\x9b\xba\x79\x50\x05\x3e\xd5\x87\x3f\xf7\x1f\x0f\xf8\xb4\x7d\x79\xd9\xee\x0e\xf5\x53\x83\xfd\x0b\x1e\xf7\xbb\x77\xf5\xa1\xde\xef\x1a\xec\x9f\xb1\xdd\x7d\xc6\xfb\x7a\xf7\xee\x01\x2c\xa9\xe7\x00\xfe\xe2\x43\xd6\xef\x02\x24\x0f\x92\x75\xce\xf4\xb6\x40\x37\x01\x79\x3f\xf2\x77\xf4\xdc\xca\x49\x5a\x18\xb2\xdd\x48\x1d\xa3\x73\xaf\x1c\x6c\x5e\x0f\xcf\x61\x90\x98\xe3\x8c\x20\xab\x55\x01\x23\x83\xa4\x79\x8b\xe2\xf7\xa6\x32\xcd\xcf\x7c\x5b\x8a\xbc\x5c\xd7\xa9\x42\x4b\x03\x9b\xfb\xf8\x5e\x7f\x55\x67\xb1\xba\x42\x6d\x13\x77\x61\x16\xf5\x5e\x92\x1a\x38\x91\xa6\x44\x95\x02\x2c\x0d\x5c\xe1\xec\x92\x11\xab\x00\x43\x47\x36\x31\x5f\x20\x27\x5a\x61\x35\xa3\xae\xcf\xab\xf9\xd7\x77\x14\x6d\x60\x4a\xac\xcb\xe3\xa5\x5c\xa8\xf6\x9e\x03\x25\x17\xfe\xb7\x7c\x21\xbe\xa2\xaf\xdd\x7f\xb6\x9d\x25\x95\xe9\xe2\xb9\x82\x37\x94\xf2\x33\x55\x39\x94\x2c\x53\xb3\x67\xab\xd9\xb6\xc2\x57\xd9\x6b\x0c\xaf\xb6\x72\xa1\xbb\x21\x2c\x70\xe7\xcd\x8d\x2b\x8c\x36\xc9\xc0\xeb\x81\x66\xcb\x3f\xd0\x61\x1c\x69\x0e\xeb\x65\x4a\xff\x04\x00\x00\xff\xff\x6b\xcf\x60\x83\x1e\x05\x00\x00"),
		},
		"/platform-integration-kit-main.yaml": &vfsgen۰CompressedFileInfo{
			name:             "platform-integration-kit-main.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1257,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\x4d\x6f\xe3\x36\x10\xbd\xf3\x57\x3c\x58\x97\x5d\xc0\x96\xdb\x1e\xd5\x93\x9b\xb5\x51\x61\x17\x36\x10\x79\x1b\xe4\x38\x16\xc7\xd2\xc0\x12\xc9\x92\x54\x14\xff\xfb\x82\xb2\xdd\x38\x08\xd0\x5e\xc2\x9b\xa8\xe1\xfb\xe0\x7b\xcc\xb0\xf8\xbc\xa5\x32\xfc\x90\x9a\x4d\x60\x8d\x68\x11\x5b\xc6\xca\x51\xdd\x32\x2a\x7b\x8c\x23\x79\xc6\xc6\x0e\x46\x53\x14\x6b\xf0\x65\x55\x6d\xbe\x62\x30\x9a\x3d\xac\x61\x58\x8f\xde\x7a\x56\x19\x6a\x6b\xa2\x97\xc3\x10\xad\x47\x77\x01\x04\x35\x9e\xb9\x67\x13\x43\x0e\x54\xcc\x13\xfa\x76\xb7\x2f\x1f\xd6\x38\x4a\xc7\xd0\x12\x2e\x87\x58\x63\x94\xd8\xaa\x0c\xb1\x95\x80\xd1\xfa\x13\x8e\xd6\x83\xb4\x96\x44\x4c\x1d\xc4\x1c\xad\xef\x2f\x32\x3c\x37\xe4\xb5\x98\x06\xb5\x75\x67\x2f\x4d\x1b\x61\x47\xc3\x3e\xb4\xe2\x72\x95\x61\x9f\x6c\x54\x9b\x9b\x92\x70\x81\x9d\x38\xa3\xc5\xb3\x1d\xae\x1e\xee\xec\x5e\x6f\x61\x8e\xbf\xd8\x87\x44\xf2\x5b\xfe\x8b\xca\xf0\x25\x8d\xcc\xae\x3f\x67\x5f\x7f\xc7\xd9\x0e\xe8\xe9\x0c\x63\x23\x86\xc0\x77\xc8\xfc\x5a\xb3\x8b\x10\x83\xda\xf6\xae\x13\x32\x35\xbf\xd9\xfa\x97\x21\xc7\x24\x20\x61\xd8\x43\x24\x31\xa0\xc9\x06\xec\xf1\x7e\x0c\x14\x55\xa6\x32\x4c\xab\x8d\xd1\x15\xcb\xe5\x38\x8e\x39\x4d\x72\x73\xeb\x9b\xe5\xcd\xdd\xf2\x47\xf9\xb0\xde\x56\xeb\xc5\x24\x59\x65\xf8\x69\x3a\x0e\x01\x9e\xff\x1e\xc4\xb3\xc6\xe1\x0c\x72\xae\x93\x9a\x0e\x1d\xa3\xa3\x31\x05\x37\xa5\x33\x85\x2e\x06\xa3\x97\x28\xa6\x99\x23\x5c\x53\x57\xd9\xbb\x74\xde\xae\xeb\x26\x4f\xc2\xbb\x01\x6b\x40\x06\xb3\x55\x85\xb2\x9a\xe1\x8f\x55\x55\x56\x73\x95\xe1\xa9\xdc\xff\xb9\xfb\xb9\xc7\xd3\xea\xf1\x71\xb5\xdd\x97\xeb\x0a\xbb\x47\x3c\xec\xb6\xdf\xca\x7d\xb9\xdb\x56\xd8\x6d\xb0\xda\x3e\xe3\x7b\xb9\xfd\x36\x07\x4b\x6c\xd9\x83\x5f\x9d\x4f\xfa\xad\x87\xa4\x8b\x64\x9d\x32\xbd\x15\xe8\x26\x20\xf5\x23\x7d\x07\xc7\xb5\x1c\xa5\x46\x47\xa6\x19\xa8\x61\x34\xf6\x85\xbd\x49\xf5\x70\xec\x7b\x09\x29\xce\x00\x32\x5a\x65\xe8\xa4\x97\x38\xb5\x28\x7c\x34\x95\x68\x3e\xf3\x6d\x29\x72\x72\xad\x53\x81\x9a\x7a\xee\xee\xe3\x7b\xf9\x55\x9d\xc4\xe8\x02\xa5\x89\xdc\xf8\x49\xd4\x77\x89\xaa\xe7\x48\x9a\x22\x15\x0a\x30\xd4\x73\x81\x9e\xc4\x28\xa0\xa3\x03\x77\x21\x6d\x23\xe5\x59\x60\x36\x61\x2e\x4e\xb3\x69\xeb\x03\x41\xed\x99\x22\xeb\xfc\x70\xce\x2f\x44\x3b\xc7\x9e\xa2\xf5\xff\x3b\x7e\xa1\xbd\xa2\x2f\xec\x7f\x1e\x3b\x49\xcc\xe3\xd9\x71\x01\xd7\x51\x4c\x8f\x54\xa5\x48\x92\x4c\xcd\x8e\x8d\x66\x53\x0b\x5f\x65\x2f\xd0\xbf\x98\xc2\xfa\xe6\x86\x70\x81\x3b\x2d\x6f\x5c\x7e\x30\x51\x7a\x5e\x24\xcb\xff\x04\x00\x00\xff\xff\x90\xcf\xf9\x62\xe9\x04\x00\x00"),
		},
		"/platform-integration-kit-xml.yaml": &vfsgen۰CompressedFileInfo{
			name:             "platform-integration-kit-xml.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1303,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\x4d\x8f\xdb\x36\x10\xbd\xf3\x57\x3c\x58\x97\x04\x58\xcb\x6d\x8f\xea\xc9\xdd\xac\x51\x21\x81\x0d\xac\x9c\x06\x39\x8e\xc5\xb1\x34\x35\x45\xb2\x24\xb5\x5a\xff\xfb\x82\xb2\xdd\x38\x08\xd0\xf6\xb0\xbc\x89\x9a\x79\x1f\xf3\x86\x05\x96\x6f\x77\x54\x81\x4f\xd2\xb2\x8d\xac\x91\x1c\x52\xcf\x58\x7b\x6a\x7b\x46\xe3\x8e\x69\xa2\xc0\xd8\xb8\xd1\x6a\x4a\xe2\x2c\xde\xad\x9b\xcd\x7b\x8c\x56\x73\x80\xb3\x0c\x17\x30\xb8\xc0\xaa\x40\xeb\x6c\x0a\x72\x18\x93\x0b\x30\x17\x40\x50\x17\x98\x07\xb6\x29\x96\x40\xc3\x3c\xa3\x6f\x77\xfb\xfa\xf1\x09\x47\x31\x0c\x2d\xf1\xd2\xc4\x1a\x93\xa4\x5e\x15\x48\xbd\x44\x4c\x2e\x9c\x70\x74\x01\xa4\xb5\x64\x62\x32\x10\x7b\x74\x61\xb8\xc8\x08\xdc\x51\xd0\x62\x3b\xb4\xce\x9f\x83\x74\x7d\x82\x9b\x2c\x87\xd8\x8b\x2f\x55\x81\x7d\xb6\xd1\x6c\x6e\x4a\xe2\x05\x76\xe6\x4c\x0e\x5f\xdd\x78\xf5\x70\x67\xf7\x3a\x85\x07\xfc\xc1\x21\x66\x92\x5f\xca\x9f\x54\x81\x77\xb9\x64\x71\xfd\xb9\x78\xff\x2b\xce\x6e\xc4\x40\x67\x58\x97\x30\x46\xbe\x43\xe6\xd7\x96\x7d\x82\x58\xb4\x6e\xf0\x46\xc8\xb6\xfc\xcd\xd6\x3f\x0c\x25\x66\x01\x19\xc3\x1d\x12\x89\x05\xcd\x36\xe0\x8e\xf7\x65\xa0\xa4\x0a\x55\x60\x3e\x7d\x4a\xbe\x5a\xad\xa6\x69\x2a\x69\x96\x5b\xba\xd0\xad\x6e\xee\x56\x9f\xea\xc7\xa7\x6d\xf3\xb4\x9c\x25\xab\x02\x9f\xad\xe1\x18\x11\xf8\xaf\x51\x02\x6b\x1c\xce\x20\xef\x8d\xb4\x74\x30\x0c\x43\x53\x0e\x6e\x4e\x67\x0e\x5d\x2c\xa6\x20\x49\x6c\xf7\x80\x78\x4d\x5d\x15\xdf\xa5\xf3\x6d\x5c\x37\x79\x12\xbf\x2b\x70\x16\x64\xb1\x58\x37\xa8\x9b\x05\x7e\x5b\x37\x75\xf3\xa0\x0a\x7c\xa9\xf7\xbf\xef\x3e\xef\xf1\x65\xfd\xfc\xbc\xde\xee\xeb\xa7\x06\xbb\x67\x3c\xee\xb6\x1f\xea\x7d\xbd\xdb\x36\xd8\x6d\xb0\xde\x7e\xc5\xc7\x7a\xfb\xe1\x01\x2c\xa9\xe7\x00\x7e\xf5\x21\xeb\x77\x01\x92\x07\xc9\x3a\x67\x7a\x5b\xa0\x9b\x80\xbc\x1f\xf9\x3b\x7a\x6e\xe5\x28\x2d\x0c\xd9\x6e\xa4\x8e\xd1\xb9\x17\x0e\x36\xaf\x87\xe7\x30\x48\xcc\x71\x46\x90\xd5\xaa\x80\x91\x41\xd2\xbc\x45\xf1\x47\x53\x99\xe6\x2d\xdf\x96\x22\x2f\xd7\x75\xaa\xd0\xd2\xc0\xe6\x3e\xbe\x97\x9f\xd5\x49\xac\xae\x50\xdb\xc4\x5d\x98\x45\x7d\x94\xa4\x06\x4e\xa4\x29\x51\xa5\x00\x4b\x03\x57\x78\x1d\x8c\x02\x0c\x1d\xd8\xc4\x7c\x8b\x1c\x67\x85\xc5\x0c\xb9\x3c\x2d\xe6\xab\x1f\xf0\xdb\xc0\x94\x58\x97\x87\x73\x79\xe1\xd9\x79\x0e\x94\x5c\xf8\xcf\xf2\x0b\xeb\x15\x7d\xe9\xfe\xb5\xed\x24\xa9\x4c\x67\xcf\x15\xbc\xa1\x94\xdf\xa8\xca\x89\x64\x99\x9a\x3d\x5b\xcd\xb6\x15\xbe\xca\x5e\x62\x78\xb1\x95\x0b\xdd\x0d\xe1\x02\x77\x5a\xdd\xb8\xc2\x68\x93\x0c\xbc\x1c\x48\xec\xff\xeb\x30\x8e\x34\x87\xe5\x9f\xf1\xef\x00\x00\x00\xff\xff\xcd\x6f\x3e\xbf\x17\x05\x00\x00"),
		},
		"/platform-integration-kit-yaml.yaml": &vfsgen۰CompressedFileInfo{
			name:             "platform-integration-kit-yaml.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1306,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\x4d\x8f\xdb\x36\x10\xbd\xf3\x57\x3c\x58\x97\x04\x58\xcb\x6d\x8f\xea\xc9\xdd\xd8\xa8\x90\xc0\x06\x56\x4e\x83\x1c\xc7\xe2\x58\x1a\x98\x22\x59\x92\x5a\xc5\xff\xbe\xa0\x6c\x37\x0e\x02\xb4\x39\x84\x37\x51\x33\xef\x63\xde\xb0\xc0\xf2\xe7\x1d\x55\xe0\x83\xb4\x6c\x23\x6b\x24\x87\xd4\x33\xd6\x9e\xda\x9e\xd1\xb8\x53\x9a\x28\x30\xb6\x6e\xb4\x9a\x92\x38\x8b\x37\xeb\x66\xfb\x16\xa3\xd5\x1c\xe0\x2c\xc3\x05\x0c\x2e\xb0\x2a\xd0\x3a\x9b\x82\x1c\xc7\xe4\x02\xcc\x15\x10\xd4\x05\xe6\x81\x6d\x8a\x25\xd0\x30\xcf\xe8\xbb\xfd\xa1\x7e\xde\xe0\x24\x86\xa1\x25\x5e\x9b\x58\x63\x92\xd4\xab\x02\xa9\x97\x88\xc9\x85\x33\x4e\x2e\x80\xb4\x96\x4c\x4c\x06\x62\x4f\x2e\x0c\x57\x19\x81\x3b\x0a\x5a\x6c\x87\xd6\xf9\x4b\x90\xae\x4f\x70\x93\xe5\x10\x7b\xf1\xa5\x2a\x70\xc8\x36\x9a\xed\x5d\x49\xbc\xc2\xce\x9c\xc9\xe1\xb3\x1b\x6f\x1e\x1e\xec\xde\xa6\xf0\x84\xbf\x38\xc4\x4c\xf2\x5b\xf9\x8b\x2a\xf0\x26\x97\x2c\x6e\x3f\x17\x6f\x7f\xc7\xc5\x8d\x18\xe8\x02\xeb\x12\xc6\xc8\x0f\xc8\xfc\xa5\x65\x9f\x20\x16\xad\x1b\xbc\x11\xb2\x2d\x7f\xb5\xf5\x2f\x43\x89\x59\x40\xc6\x70\xc7\x44\x62\x41\xb3\x0d\xb8\xd3\x63\x19\x28\xa9\x42\x15\x98\x4f\x9f\x92\xaf\x56\xab\x69\x9a\x4a\x9a\xe5\x96\x2e\x74\xab\xbb\xbb\xd5\x87\xfa\x79\xb3\x6b\x36\xcb\x59\xb2\x2a\xf0\xd1\x1a\x8e\x11\x81\xff\x1e\x25\xb0\xc6\xf1\x02\xf2\xde\x48\x4b\x47\xc3\x30\x34\xe5\xe0\xe6\x74\xe6\xd0\xc5\x62\x0a\x92\xc4\x76\x4f\x88\xb7\xd4\x55\xf1\x4d\x3a\x5f\xc7\x75\x97\x27\xf1\x9b\x02\x67\x41\x16\x8b\x75\x83\xba\x59\xe0\x8f\x75\x53\x37\x4f\xaa\xc0\xa7\xfa\xf0\xe7\xfe\xe3\x01\x9f\xd6\x2f\x2f\xeb\xdd\xa1\xde\x34\xd8\xbf\xe0\x79\xbf\x7b\x57\x1f\xea\xfd\xae\xc1\x7e\x8b\xf5\xee\x33\xde\xd7\xbb\x77\x4f\x60\x49\x3d\x07\xf0\x17\x1f\xb2\x7e\x17\x20\x79\x90\xac\x73\xa6\xf7\x05\xba\x0b\xc8\xfb\x91\xbf\xa3\xe7\x56\x4e\xd2\xc2\x90\xed\x46\xea\x18\x9d\x7b\xe5\x60\xf3\x7a\x78\x0e\x83\xc4\x1c\x67\x04\x59\xad\x0a\x18\x19\x24\xcd\x5b\x14\xbf\x37\x95\x69\x7e\xe6\xdb\x52\xe4\xe5\xb6\x4e\x15\x5a\x1a\xd8\x3c\xc6\xf7\xfa\xab\x3a\x8b\xd5\x15\x6a\x9b\xb8\x0b\xb3\xa8\xf7\x92\xd4\xc0\x89\x34\x25\xaa\x14\x60\x69\xe0\x0a\x17\x1a\x8c\x02\x0c\x1d\xd9\xc4\x7c\x8d\x9c\x67\x85\xc5\x8c\xb9\x3c\x2f\xe6\xab\xef\x08\xda\xc0\x94\x58\x97\xc7\x4b\x79\x25\xda\x7b\x0e\x94\x5c\xf8\xdf\xf2\x2b\xed\x0d\x7d\xe9\xfe\xb3\xed\x2c\xa9\x4c\x17\xcf\x15\xbc\xa1\x94\x1f\xa9\xca\x91\x64\x99\x9a\x3d\x5b\xcd\xb6\x15\xbe\xc9\x5e\x62\x78\xb5\x95\x0b\xdd\x1d\xe1\x0a\x77\x5e\xdd\xb9\xc2\x68\x93\x0c\xbc\x1c\x48\xec\x8f\x75\x18\x47\x9a\xc3\x32\xcf\xe8\x9f\x00\x00\x00\xff\xff\xe9\xdb\x5d\x36\x1a\x05\x00\x00"),
		},
		"/prometheus-jmx-exporter.yaml": &vfsgen۰CompressedFileInfo{
			name:             "prometheus-jmx-exporter.yaml",
			modTime:          time.Time{},
			uncompressedSize: 19730,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xec\x9c\x5d\x73\xda\xb8\x17\xc6\xef\xfd\x29\xce\x40\x67\x9a\xfc\x9b\x92\xff\x76\xb7\x37\x6c\x9a\x19\x9a\x97\x96\xd9\x14\x76\x80\x6c\xa7\xd3\x69\x67\x84\x7d\x30\x6a\x64\xc9\x2b\xc9\x40\xbe\xfd\x8e\xdf\xc0\x60\x87\x97\x84\x60\x41\xcb\x1d\x3e\x8f\x85\x7e\x8f\x8e\x1d\x3d\x40\xa8\xc2\xeb\xed\x3d\xac\x2a\xdc\x50\x1b\xb9\x42\x07\xb4\x00\x3d\x44\x68\xf8\xc4\x1e\x22\x74\xc5\x40\x8f\x89\x44\xb8\x16\x01\x77\x88\xa6\x82\xc3\x51\xa3\x7b\x7d\x0c\x01\x77\x50\x82\xe0\x08\x42\x82\x27\x24\x5a\x55\xb0\x05\xd7\x92\xf6\x03\x2d\x24\xb0\x78\x40\x20\xae\x44\xf4\x90\x6b\x55\x03\xe8\x22\x46\xa3\xb7\xda\xbd\xe6\xc5\x15\x0c\x28\x43\x70\xa8\x8a\x4f\x42\x07\xc6\x54\x0f\xad\x2a\xe8\x21\x55\x30\x16\xf2\x0e\x06\x42\x02\x71\x1c\x1a\xbe\x30\x61\x40\xf9\x40\x48\x2f\x9e\x86\x44\x97\x48\x87\x72\x17\x6c\xe1\xdf\x4b\xea\x0e\x35\x88\x31\x47\xa9\x86\xd4\xaf\x59\x55\xe8\x85\x18\xdd\xeb\x74\x26\x2a\x1e\x36\x7a\x4d\x2d\xe0\x8b\x08\x12\x86\x0c\x6e\xe2\xc2\x09\xfc\x83\x52\x85\x2f\xf2\xa6\xf6\x7f\xab\x0a\x47\xa1\xa4\x92\x14\x2b\xc7\x7f\xc2\xbd\x08\xc0\x23\xf7\xc0\x85\x86\x40\x61\x66\x64\x9c\xd8\xe8\x6b\xa0\x1c\x6c\xe1\xf9\x8c\x12\x6e\xe3\x0c\x6b\xfa\x0a\x35\x88\x26\x10\x8e\x21\xfa\x9a\x50\x0e\x24\xc2\x00\x31\xc8\xca\x80\x68\xab\x6a\x55\x21\x7a\x0c\xb5\xf6\xeb\xa7\xa7\xe3\xf1\xb8\x46\xa2\xe9\xd6\x84\x74\x4f\x53\xba\xd3\x9b\xe6\xc5\x55\xab\x7b\xf5\x3a\x9a\xb2\x55\x85\x5b\xce\x50\x29\x90\xf8\x6f\x40\x25\x3a\xd0\xbf\x07\xe2\xfb\x8c\xda\xa4\xcf\x10\x18\x19\x87\x0b\x17\xad\x4e\xb4\xe8\x94\xc3\x58\x52\x4d\xb9\x7b\x02\x2a\x59\x75\xab\x3a\xb7\x3a\x33\xbb\xd2\xe9\x51\x35\x27\x10\x1c\x08\x87\x4a\xa3\x0b\xcd\x6e\x05\xde\x37\xba\xcd\xee\x89\x55\x85\xcf\xcd\xde\xc7\xf6\x6d\x0f\x3e\x37\x3a\x9d\x46\xab\xd7\xbc\xea\x42\xbb\x03\x17\xed\xd6\x65\xb3\xd7\x6c\xb7\xba\xd0\xbe\x86\x46\xeb\x0b\xfc\xd5\x6c\x5d\x9e\x00\x52\x3d\x44\x09\x38\xf1\x65\x38\x7f\x21\x81\x86\x46\xa2\x13\xae\x69\xda\x40\xe9\x04\xc2\xfe\x08\x9f\x2b\x1f\x6d\x3a\xa0\x36\x30\xc2\xdd\x80\xb8\x08\xae\x18\xa1\xe4\x61\x7b\xf8\x28\x3d\xaa\xc2\xe5\x54\x40\xb8\x63\x55\x81\x51\x8f\xea\xa8\x8b\x54\x1e\x2a\x7c\x99\x6d\x5e\x5b\x96\xd2\x44\xea\x4b\x64\xe4\xbe\x8b\xb6\xaa\xc3\x5b\x4b\x29\x56\x87\x01\x61\x0a\xad\x3e\x23\xf6\x1d\xa3\x4a\xb7\xfb\x3f\xd0\xd6\x2d\xe2\xa1\xaa\xc3\xd7\xca\x0f\x32\x22\xb5\x10\xa6\xfe\xbf\xca\x37\x4b\x06\x0c\x55\xdd\x02\xa8\xc2\x85\xe0\x1a\x27\x1a\x18\x8e\x90\x59\x00\xaf\xc1\x27\x5a\xa3\xe4\x75\x78\x29\xa4\x9b\xb6\x86\x4d\x3c\x64\x67\x76\x2c\x7e\x77\xf4\xf5\xfb\xc9\xb7\x57\xc7\x27\xa0\xef\x7d\x7c\x97\x1c\x3d\x01\x4e\x3c\x7c\x57\x39\xfa\xfa\xbd\xf2\xed\xd5\x71\xe5\xfc\xec\xfc\x6a\x62\x0f\x09\x77\x51\x5d\x84\xcd\x8b\x1a\x9d\x97\x56\xd8\x7a\xa1\xb0\x0e\x8b\xc3\xd7\xf2\xf2\x48\x3d\x44\xe6\xd7\x61\x5a\x84\xf9\x6a\x38\x85\x3a\x5c\xb4\x6f\x5b\xbd\xab\x4e\x74\x84\x91\x3e\xb2\x08\x2f\x7c\x24\xb3\xab\xc3\x8b\xdf\x92\x23\xf1\x19\xc9\xf1\x67\x43\xbe\x26\x94\xad\xcb\x1b\x6b\x0b\x61\x33\x25\x53\x49\x9b\x7c\xc0\xc2\xdb\xe5\x7a\xac\xa9\xba\x90\x76\xae\x68\x2a\x6f\x4f\x68\xc2\xd6\x83\x8d\xa4\x85\xa4\xb3\xca\x2f\xcc\x32\x30\xc3\xeb\x2a\x90\xa8\x3e\x12\xee\xac\xba\x4e\x17\xb4\x19\xd0\xb4\x02\xd9\xd2\xa6\x5c\x79\x6f\xb6\xbc\xa0\xe1\x48\x84\x75\xd0\x41\x46\x47\x28\x29\xaa\x15\xcb\x9a\x3f\x61\x6e\x71\xe3\x32\xe4\xea\x86\x81\x7f\x22\x93\xbf\xa5\xb0\x51\x29\xca\xdd\x1e\xf5\x70\x29\x75\x4e\x9d\x41\xfe\x44\x26\xd4\x0b\x3c\x98\x09\x60\xaa\x78\x2c\xf4\x87\xc6\xed\x87\xab\xad\x23\x23\xe1\x9b\x30\xe7\xe4\x59\x68\x24\x7c\x0f\x88\xe9\x46\xc0\x8b\xea\x2c\x2f\xe5\xfb\xb1\xc8\x37\x44\xe9\x0d\x98\xf3\xf2\x0c\x74\x58\x34\x9f\xf8\x12\x99\x26\x1b\x20\x17\xe8\x33\xcc\x51\xd5\x7c\xe8\xb5\xef\xd7\x0f\xdc\xa7\xb7\x76\x7b\x7e\x16\xba\x68\x63\xb0\xc1\x92\x16\xe8\x33\xac\x51\xd5\xa0\x25\x55\x81\x87\x52\x15\x60\xa7\x1b\xdc\xe9\x0e\x69\x29\x74\x4e\x9d\x41\x4e\x6b\x30\x5f\x7c\x1a\xaf\x15\x65\xc2\x8e\x08\x34\x3e\x25\x11\xca\x70\x80\x22\x7c\x33\x03\x61\x34\xdd\x3a\xbc\x78\x33\xe7\x51\x0c\xf1\x5c\x06\x98\x10\x0f\xcb\xe0\x36\x27\x2c\x96\x41\x5f\x7a\xa6\xfa\x05\xfd\xbc\xd0\x25\xc6\xca\x15\x94\x5b\x09\x5b\x4b\x16\xdb\x94\x90\x59\xaa\x0d\x66\x44\xce\x35\x2d\x78\xc2\x16\xe7\x61\x03\x4c\x08\xa0\x65\xf2\x1b\x11\x47\x4b\x34\xc0\x88\x70\x5a\x22\xbf\x29\x51\xb5\x44\x0b\x76\x1e\x5c\x4b\x64\x35\x25\xc6\x96\x68\x41\xe9\x91\x76\x23\xf6\x28\xe0\x26\x0e\x0b\xf9\x94\x90\xeb\xa7\x83\xec\x4f\xd0\x9d\x4e\x39\xe7\xd6\x0c\xe6\x39\xcd\x30\x21\xf4\x96\xed\x81\x39\x01\xb8\x6c\x27\x4a\xcf\x85\xbf\x0c\x28\xc7\x80\x12\x43\xf2\x9a\xc4\x5b\x49\x89\x2b\x9a\xc0\x94\xc0\x6c\x8c\x25\x66\x84\xe7\x0d\xed\x78\xc2\x8e\x6a\xb9\x19\x26\x04\x69\x53\xbc\x30\x22\x54\x1b\x62\x86\x11\x01\xdb\x10\x2f\x4c\x09\xdb\x86\xd8\xb1\xf3\xe0\x6d\x08\xb7\x29\x21\xdc\x10\x3b\x4a\x0f\xe4\x8f\xdc\x51\xa4\xdf\x47\x8e\x3f\x3c\x3f\xc0\xcf\xde\xd3\xc9\xe5\x6c\xb1\x33\xd0\x05\x6f\x57\x74\x51\x8e\xa8\xfd\xd8\xcf\xaa\x54\x72\x76\xf1\x8e\xeb\x32\x90\xd1\x37\xd7\x57\xed\xb5\x52\x5d\xc1\x2e\x6b\xae\xb4\xca\x83\x64\x36\x39\x0b\xd4\x8c\x71\x0b\xd7\xc7\x32\x66\x24\x7c\x3d\xe8\x8c\x70\x71\x33\xb5\x67\xc8\x74\x4d\x62\x5a\x08\x9c\xec\x99\xf6\x8b\x39\xba\x8b\xaf\x45\x3d\xa7\xcc\xfd\x1d\xd8\x33\xea\xa1\x44\xe2\xa8\xf7\x4c\xd8\x77\x2b\x82\xf5\xbc\x34\xcb\x1d\x17\x20\x5b\xd9\x17\xf0\x26\xd7\x28\x65\xe0\xaf\x7a\xbf\x35\x2f\x2f\x30\x60\xb1\xba\x43\x13\x26\x83\xb3\x7e\xa0\x6a\xd4\x59\x70\x60\xfa\x2c\x19\x73\x76\xc0\x17\x32\x63\x97\xf0\x31\x6e\xdb\xf4\xd0\xf9\xd9\x79\x2b\xf0\x6e\x84\x4b\x6d\xc2\x3a\x01\xd7\xd4\xc3\x6b\x12\x30\xfd\xe0\x1f\xc1\xc9\xa0\xf6\xc0\x19\x19\xab\x5a\x81\xd7\x47\x09\x62\x00\x2c\x16\x82\x8c\x95\x30\x98\x49\xe7\x91\x17\x7d\x8c\x39\x73\xdf\x50\x9b\x7a\x38\x73\xf5\xf7\x74\x7b\x21\x64\x68\xfb\x1f\xc9\xd3\x29\x6b\x1d\x5e\xbc\x7d\x36\x4f\x0f\xd4\xc0\x5d\x36\x60\x63\xe4\x76\x50\xf9\x82\x2b\x5c\xb6\x45\x9f\x0c\x6a\x0b\xca\x8c\x5f\x8d\x11\x4a\xe2\x22\xa4\xe5\xd9\xe6\xfc\x50\xba\x6c\x6f\x5d\xda\xf1\xbd\xac\xc9\x47\xc2\x8e\xff\xe9\x72\xf9\x15\x98\x11\x16\x5e\x78\x74\xa1\x7e\x28\x8d\xb4\xa7\x1e\xed\xb2\x8d\x3e\x91\xc9\x9a\xd7\xda\x82\xb2\x20\x05\x1d\xee\x1d\x69\x6f\x5d\xda\x69\x2b\x51\xbe\xae\x49\xf3\xca\x82\xa4\x75\xa0\xad\x74\x60\xc6\xed\xd2\xa4\x28\x8b\x46\x9f\x73\xae\x78\x7f\x73\x32\xa8\xe5\xb4\xb9\x4c\x9b\x16\x0f\xac\xbf\xf6\xdb\xa7\x1d\x6f\x9f\x36\x88\x30\xab\xb3\xcb\x61\x87\xbe\x3d\xb6\x6a\xc7\x4d\x75\xcb\x2f\x86\x68\xdf\xa1\xd3\x88\x7f\x19\x26\x54\xac\x63\xdb\xc3\xe7\x15\x7a\x18\x70\x3b\x96\xa7\xbf\x40\x13\xfd\x80\xcf\x61\x36\xdf\x4f\x60\xe9\x8e\x9b\xf4\x71\x7e\x6e\xe4\xe6\xcf\xd3\x9e\x87\x6b\xe6\x7f\x01\x00\x00\xff\xff\x8f\xcf\x94\x7a\x12\x4d\x00\x00"),
		},
		"/templates": &vfsgen۰DirInfo{
			name:    "templates",
			modTime: time.Time{},
		},
		"/templates/groovy.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "groovy.tmpl",
			modTime:          time.Time{},
			uncompressedSize: 207,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\x8e\xc1\x6a\xc3\x30\x0c\x86\xef\x7e\x8a\xff\x30\xb0\x03\xdb\x9c\x5d\x0d\x61\xb0\x5d\x36\xf6\x00\x3b\x9b\x46\x71\x4d\xed\x28\x28\x4e\x69\x28\x7d\xf7\xe2\xa6\x39\xea\x43\xdf\x27\x59\x8b\x83\xcf\x94\xde\x4e\x0e\xc9\x8f\x61\xf1\x81\xba\x20\xcc\xe7\x55\x29\x6b\xf1\x2f\xb1\x10\x56\x5e\x04\xc2\x4b\xa1\x19\x47\x12\x7a\xc5\xc0\x02\xba\xf8\x3c\x25\x72\x6a\x10\xce\x46\x97\x98\x49\xdc\xe6\x7e\x4e\x24\x91\xfb\xee\xa3\x6d\x5b\xdd\x28\x00\x78\x7f\xf8\xbf\xbd\xd1\xdb\xca\x8e\x67\x2a\x5f\xdc\xaf\x66\x1b\x2b\x88\xb5\x6a\xf4\x0f\xa5\xc4\xf8\xae\xdf\xe1\x0f\xf5\x06\x5e\xae\xcf\xc8\x6d\xb7\x0b\x1b\x9d\x38\xb8\x38\x0e\xac\x1b\x75\x0f\x00\x00\xff\xff\x22\xe1\x59\x85\xcf\x00\x00\x00"),
		},
		"/templates/java.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "java.tmpl",
			modTime:          time.Time{},
			uncompressedSize: 390,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x4c\x90\x41\x4b\xf3\x40\x10\x86\xef\xfb\x2b\x5e\xc2\x77\x48\xe1\x33\xa9\xd7\x94\xa2\x54\x04\x45\x50\xf0\xe2\x79\x9b\x9d\xa4\xa3\x9b\x4c\x98\x6c\x6a\x4b\xc8\x7f\x97\x8d\x01\xb3\xb7\x9d\x7d\xf6\x79\x79\x27\xcf\x51\xda\x86\xfc\xcd\x57\x01\x6f\xdb\x7a\xb0\x35\xed\x3f\xed\xd9\x1a\xc3\x4d\x27\x1a\x20\x5a\x67\xb6\xb3\xe5\x89\xb2\x99\xcc\x8e\x03\x7b\x47\x9a\xbd\xcb\x10\xe8\xf0\x7b\xd9\x19\xd3\x0d\x47\xcf\x25\x4a\x6f\xfb\x1e\xe3\x88\xec\xd5\x36\x84\x69\x02\x5d\x02\xb5\xae\xc7\x9a\xc7\x68\x80\xfb\xb7\x33\xa9\xb2\x23\x03\x2c\xbf\xcf\xc2\x0e\xa5\xb4\x15\xd7\x83\x52\xba\x41\x38\xa9\x7c\xf7\x78\xbc\x94\xd4\x05\x96\x16\xa3\x31\x98\x4f\x9e\xe3\x43\x39\x10\xae\x32\x28\x34\xca\x7b\x9c\x48\xe9\x3f\x2a\x51\xd0\xc5\x36\x9d\xa7\x62\xa1\x2b\x95\x26\x4d\x02\x37\xa4\x45\xac\x77\xd7\x91\xb2\xb8\xfd\xed\x76\xbb\x4d\x36\x0b\x04\x64\xb3\xe7\xd9\xa5\x49\x84\xd6\x0f\x3d\x85\x83\xb8\x6b\xfa\x37\x8a\x43\x8e\x19\x69\xf2\x44\xde\x0b\x1e\xe2\x7a\xf0\x32\x67\xe1\xdf\xb8\xa8\xa6\xb5\x25\x48\x9a\x78\xa9\x0b\x6e\x2b\x49\x36\xbb\xd8\x65\x32\x93\xf9\x09\x00\x00\xff\xff\xdd\x48\x43\xb2\x86\x01\x00\x00"),
		},
		"/templates/js.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "js.tmpl",
			modTime:          time.Time{},
			uncompressedSize: 195,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\x8e\xb1\x6a\xc3\x30\x14\x45\x77\x7d\xc5\x1d\x0a\x92\xa1\xad\xdc\x55\x60\x0a\xed\xd2\xd2\x0f\xe8\x2c\xe2\x67\x47\x8e\xe4\x67\x9e\x64\x88\x09\xf9\xf7\xa0\x24\x1e\xef\x81\x73\xb8\xd6\xe2\xe0\x13\xc5\xb7\x93\x43\xf4\xf3\xb8\xfa\x91\xba\x29\x2b\x65\x2d\xfe\x25\x14\xc2\xc6\xab\x40\x78\x2d\x94\x71\x24\xa1\x57\x0c\x2c\xa0\xb3\x4f\x4b\x24\xa7\x06\xe1\x64\x74\x09\x89\xc4\x4d\xf9\x73\x21\x09\xdc\x77\x1f\x6d\xdb\xea\x46\x01\xc0\xfb\xdd\xfd\xed\x8d\x9e\xf2\x8e\x32\x95\x2f\xee\x37\xf3\x98\x15\x84\x5a\x33\xfa\x87\x62\x64\x7c\xd7\x47\xf8\x43\x6d\xe3\xe5\xf2\x0c\x5c\x77\xbb\xb0\xd1\x91\x47\x17\xe6\x81\x75\xa3\x6e\x01\x00\x00\xff\xff\xf0\x06\x51\xe3\xc3\x00\x00\x00"),
		},
		"/templates/kts.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "kts.tmpl",
			modTime:          time.Time{},
			uncompressedSize: 200,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\x8e\x41\xca\xc2\x30\x10\x46\xf7\x39\xc5\x10\xfe\x45\x0a\xbf\xa6\x6e\x03\x45\xd0\x8d\xe2\x01\xdc\xb8\x09\x76\x5a\x43\x27\x9d\x32\x4d\xc1\x22\xde\x5d\x62\x5c\xbe\x61\xde\xe3\xb3\x16\xee\x3e\x22\x6d\x06\x07\xe4\xc7\x7e\xf1\x3d\x36\x03\x27\x0a\xa3\x52\xd6\xc2\x55\x42\x42\x58\x79\x11\x10\x5e\x12\xce\xf0\x40\xc1\x7f\xe8\x58\x00\x9f\x3e\x4e\x84\x4e\x75\xc2\xd1\xe8\x14\x22\x8a\x2b\xee\x7e\x42\x09\xdc\x36\xbb\xba\xae\x75\xa5\x00\xb6\x5f\xfb\xdc\x1a\x5d\x1e\xca\x71\xc6\x74\xe0\x76\x35\x19\x32\x86\xdc\x33\xfa\x84\x44\x0c\xc7\xbc\x0b\x2e\x90\xeb\x70\xfb\x7b\xfd\x0a\xef\xa2\x26\x36\x9a\xb8\x77\x61\xec\x58\x57\xea\x13\x00\x00\xff\xff\xfb\xc6\xfa\xba\xc8\x00\x00\x00"),
		},
		"/templates/xml.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "xml.tmpl",
			modTime:          time.Time{},
			uncompressedSize: 597,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\x92\x4f\x4b\xf4\x30\x10\xc6\xcf\x6f\x3f\xc5\xbc\xe1\x3d\xbe\x69\xba\x7a\x91\x92\x76\x41\x41\x14\xd7\x93\x8a\x5e\x43\x3b\xdb\x06\xf3\xa7\x24\xa9\xcd\x22\x7e\x77\x69\xba\xae\x2b\x5e\x74\x4e\x2d\x33\xbf\xe7\x99\x79\x08\x5f\x47\xad\xe0\x05\x9d\x97\xd6\x54\x64\x95\x17\x04\xd0\x34\xb6\x95\xa6\xab\xc8\xc3\xfd\x25\x3d\x23\xeb\x3a\xe3\x7f\x29\x85\x46\x68\x54\xf4\xb9\x04\x25\x4c\x37\x8a\x0e\xab\x99\xa5\xb4\xce\x32\xee\xec\x18\xd0\x43\xd4\xca\xf8\x32\x7a\x59\x91\x3e\x84\xa1\x64\x6c\x9a\xa6\x7c\x3a\xcd\xad\xeb\xd8\x49\x51\xac\xd8\xd3\xed\xe6\xae\xe9\x51\x0b\x2a\x8d\x0f\xc2\x34\x48\x32\xd8\x57\xa2\x0f\x64\xb2\xcb\xc5\x20\x9a\x1e\x13\xef\x13\xc7\xfc\xe0\xa4\xe9\x8e\x28\x2f\xcb\xa5\xb5\xb1\x8d\x08\xe9\x8e\x43\x73\xae\x1f\xe9\xfd\x9e\x58\xda\x74\xf9\xc9\xa3\x6f\x49\x9d\x65\x7f\x52\x52\x8f\x4e\x06\x84\x9d\x1d\x1d\xec\x83\xe9\xd1\xe1\x7f\xd8\x5a\x07\x18\x85\x1e\x14\x96\x29\xb8\xd9\x6c\xc9\x0e\x64\x5b\x91\xa8\x15\xa9\x0f\x9b\xf0\xad\xb3\x1a\x46\x27\x2b\x12\xa4\x46\x57\x46\xad\xd6\x03\x3a\x69\xdb\x6a\x55\x14\x05\x61\x47\xb3\x1e\xc3\xb9\x6d\x77\xf5\x97\x3b\xb8\x97\xb3\x57\x7d\x85\x4a\x59\xb8\x98\xf7\x85\x1b\x48\xb2\xff\x5e\x93\xed\x75\xfb\xc6\xd9\x7e\xea\x53\x8c\x7d\x53\xe3\xc1\x2e\x9b\x28\xdb\x95\xd2\x6c\xed\x87\x39\x67\x49\x67\x7e\x03\xcb\x97\xaf\xb3\xf7\x00\x00\x00\xff\xff\xd8\xbe\x95\x9a\x55\x02\x00\x00"),
		},
		"/templates/yaml.tmpl": &vfsgen۰CompressedFileInfo{
			name:             "yaml.tmpl",
			modTime:          time.Time{},
			uncompressedSize: 230,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x44\x8e\x31\x4e\x04\x31\x0c\x45\xfb\x9c\xe2\x2b\xdb\x32\xd2\xd0\x5a\xa2\xa2\x41\xe2\x00\xd4\x66\xd7\x33\x44\x24\x71\xe4\x38\x12\x73\x7b\x94\x1d\xc1\xba\xfc\x7e\xf6\x7f\x17\x5c\xb9\x48\x5e\xbe\x09\x99\xeb\x3e\x78\x97\x97\x83\x4b\x0e\xe1\x82\x0f\x4b\x2e\x38\x74\x18\x4c\x87\x4b\xc7\x97\x98\x3c\x61\x53\x83\xfc\x70\x69\x59\x28\x2c\xd8\x4c\x0b\x05\x00\x18\x96\x08\xd1\x53\x11\xa3\xf9\x24\xde\xd3\xc6\xc6\x45\x5c\xac\x9f\x14\xd0\xc4\x92\xde\x08\xf1\x79\x5d\xd7\x13\xea\x2e\xed\x7f\xbf\xa0\x8b\x2f\x9f\x7a\x3b\xfe\x92\x39\x57\xad\xdd\xb9\x3a\x21\xbe\x49\xce\x8a\xd7\x69\x8e\xf7\xbb\x00\x1e\x7d\xf3\xde\x95\x10\xb3\xee\x94\xea\xa6\x31\xfc\x06\x00\x00\xff\xff\xec\xe0\xb7\x2c\xe6\x00\x00\x00"),
		},
		"/user-cluster-role.yaml": &vfsgen۰CompressedFileInfo{
			name:             "user-cluster-role.yaml",
			modTime:          time.Time{},
			uncompressedSize: 1315,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x53\xc1\x8e\xdb\x36\x10\xbd\xf3\x2b\x1e\xa4\x4b\x52\xac\xe5\xb6\xa7\x42\x3d\xb9\x9b\xdd\x56\x68\x60\x03\x2b\xa7\x41\x50\xf4\x40\x8b\x63\x69\xb0\x14\xa9\x0e\xa9\x55\xb6\x5f\x5f\x90\xb6\x37\x5e\x14\x3d\x04\x08\x6f\x24\x87\x6f\xde\x9b\xf7\x58\x62\xf5\xed\x96\x2a\xf1\x9e\x3b\x72\x81\x0c\xa2\x47\x1c\x08\x9b\x49\x77\x03\xa1\xf5\xc7\xb8\x68\x21\xdc\xfb\xd9\x19\x1d\xd9\x3b\xbc\xd9\xb4\xf7\x6f\x31\x3b\x43\x02\xef\x08\x5e\x30\x7a\x21\x55\xa2\xf3\x2e\x0a\x1f\xe6\xe8\x05\xf6\x04\x08\xdd\x0b\xd1\x48\x2e\x86\x0a\x68\x89\x32\xfa\x76\xb7\x6f\x6e\xef\x70\x64\x4b\x30\x1c\x4e\x8f\xc8\x60\xe1\x38\xa8\x12\x71\xe0\x80\xc5\xcb\x23\x8e\x5e\xa0\x8d\xe1\xd4\x58\x5b\xb0\x3b\x7a\x19\x4f\x34\x84\x7a\x2d\x86\x5d\x8f\xce\x4f\xcf\xc2\xfd\x10\xe1\x17\x47\x12\x06\x9e\x2a\x55\x62\x9f\x64\xb4\xf7\x17\x26\xe1\x04\x9b\x7b\x46\x8f\x4f\x7e\x3e\x6b\xb8\x92\x7b\x9e\xc2\x0d\xfe\x20\x09\xa9\xc9\x8f\xd5\xf7\xaa\xc4\x9b\x54\x52\x9c\x2f\x8b\xb7\x3f\xe3\xd9\xcf\x18\xf5\x33\x9c\x8f\x98\x03\x5d\x21\xd3\xe7\x8e\xa6\x08\x76\xe8\xfc\x38\x59\xd6\xae\xa3\x2f\xb2\x5e\x3a\x54\xc8\x04\x12\x86\x3f\x44\xcd\x0e\x3a\xcb\x80\x3f\x5e\x97\x41\x47\x55\xaa\x12\x79\x0d\x31\x4e\xf5\x7a\xbd\x2c\x4b\xa5\x33\xdd\xca\x4b\xbf\xbe\xa8\x5b\xbf\x6f\x6e\xef\xb6\xed\xdd\x2a\x53\x56\x25\x3e\x38\x4b\x21\x40\xe8\xef\x99\x85\x0c\x0e\xcf\xd0\xd3\x64\xb9\xd3\x07\x4b\xb0\x7a\x49\xc6\x65\x77\xb2\xe9\xec\xb0\x08\x47\x76\xfd\x0d\xc2\xd9\x75\x55\xbe\x72\xe7\xcb\xb8\x2e\xf4\x38\xbc\x2a\xf0\x0e\xda\xa1\xd8\xb4\x68\xda\x02\xbf\x6c\xda\xa6\xbd\x51\x25\x3e\x36\xfb\xdf\x76\x1f\xf6\xf8\xb8\x79\x78\xd8\x6c\xf7\xcd\x5d\x8b\xdd\x03\x6e\x77\xdb\x77\xcd\xbe\xd9\x6d\x5b\xec\xee\xb1\xd9\x7e\xc2\xef\xcd\xf6\xdd\x0d\x88\xe3\x40\x02\xfa\x3c\x49\xe2\xef\x05\x9c\x06\x49\x26\x79\x7a\x09\xd0\x85\x40\xca\x47\xda\x87\x89\x3a\x3e\x72\x07\xab\x5d\x3f\xeb\x9e\xd0\xfb\x27\x12\x97\xe2\x31\x91\x8c\x1c\x92\x9d\x01\xda\x19\x55\xc2\xf2\xc8\x31\xa7\x28\xfc\x57\x54\x6a\xf3\x2d\xff\x96\x7a\x64\x67\x6a\xdc\xda\x39\x44\x92\x07\x6f\x49\xe9\x89\xcf\x01\xab\x21\x07\xdd\x55\x7a\x8e\x83\x17\xfe\x27\x73\xaa\x1e\x7f\x0a\x15\xfb\xf5\xd3\x0f\x6a\xa4\xa8\x8d\x8e\xba\x56\x80\xd3\x23\xd5\xe8\xf4\x48\x76\xf5\x58\x93\xe1\xa8\x00\xab\x0f\x64\x43\xba\x46\x72\xb7\x46\x71\x2e\x28\xf2\x51\x89\x8d\x31\x49\x5c\xa0\x57\x63\x38\x7f\xf2\x42\x9b\x91\x5d\x91\xa6\x82\x22\x21\x16\x30\x74\xd4\xb3\x8d\x10\x6f\x29\x54\x19\xe4\xff\x19\xea\xbe\x4f\xbf\x30\xd2\x2a\xfa\x55\xc6\xaa\x51\x44\x99\xa9\xf8\x9a\x87\xa9\xf1\xcb\x3b\x99\x2d\x85\x5a\xad\xa0\x27\xfe\x55\xfc\x3c\x85\x1a\x7f\x9e\x44\x5d\xa5\xbe\xf8\x4b\x01\x42\xc1\xcf\xd2\x51\xae\xf8\x2e\x1f\x3d\x91\x1c\x5e\xb6\xff\x06\x00\x00\xff\xff\x62\x84\x5b\x9b\x23\x05\x00\x00"),
		},
	}
	fs["/"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/addons"].(os.FileInfo),
		fs["/builder-role-binding.yaml"].(os.FileInfo),
		fs["/builder-role-kubernetes.yaml"].(os.FileInfo),
		fs["/builder-role-openshift.yaml"].(os.FileInfo),
		fs["/builder-service-account.yaml"].(os.FileInfo),
		fs["/camel-catalog-1.3.0-SNAPSHOT-main.yaml"].(os.FileInfo),
		fs["/camel-catalog-1.3.0-SNAPSHOT-quarkus.yaml"].(os.FileInfo),
		fs["/cr-example.yaml"].(os.FileInfo),
		fs["/crd-build.yaml"].(os.FileInfo),
		fs["/crd-camel-catalog.yaml"].(os.FileInfo),
		fs["/crd-integration-kit.yaml"].(os.FileInfo),
		fs["/crd-integration-platform.yaml"].(os.FileInfo),
		fs["/crd-integration.yaml"].(os.FileInfo),
		fs["/operator-deployment.yaml"].(os.FileInfo),
		fs["/operator-role-binding-events.yaml"].(os.FileInfo),
		fs["/operator-role-binding-knative.yaml"].(os.FileInfo),
		fs["/operator-role-binding.yaml"].(os.FileInfo),
		fs["/operator-role-events.yaml"].(os.FileInfo),
		fs["/operator-role-knative.yaml"].(os.FileInfo),
		fs["/operator-role-kubernetes.yaml"].(os.FileInfo),
		fs["/operator-role-olm-cluster.yaml"].(os.FileInfo),
		fs["/operator-role-olm.yaml"].(os.FileInfo),
		fs["/operator-role-openshift.yaml"].(os.FileInfo),
		fs["/operator-service-account.yaml"].(os.FileInfo),
		fs["/platform-cr.yaml"].(os.FileInfo),
		fs["/platform-integration-kit-groovy.yaml"].(os.FileInfo),
		fs["/platform-integration-kit-java.yaml"].(os.FileInfo),
		fs["/platform-integration-kit-js.yaml"].(os.FileInfo),
		fs["/platform-integration-kit-knative.yaml"].(os.FileInfo),
		fs["/platform-integration-kit-kotlin.yaml"].(os.FileInfo),
		fs["/platform-integration-kit-main.yaml"].(os.FileInfo),
		fs["/platform-integration-kit-xml.yaml"].(os.FileInfo),
		fs["/platform-integration-kit-yaml.yaml"].(os.FileInfo),
		fs["/prometheus-jmx-exporter.yaml"].(os.FileInfo),
		fs["/templates"].(os.FileInfo),
		fs["/user-cluster-role.yaml"].(os.FileInfo),
	}
	fs["/addons"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/addons/master"].(os.FileInfo),
	}
	fs["/addons/master"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/addons/master/master-role-binding.tmpl"].(os.FileInfo),
		fs["/addons/master/master-role.tmpl"].(os.FileInfo),
	}
	fs["/templates"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/templates/groovy.tmpl"].(os.FileInfo),
		fs["/templates/java.tmpl"].(os.FileInfo),
		fs["/templates/js.tmpl"].(os.FileInfo),
		fs["/templates/kts.tmpl"].(os.FileInfo),
		fs["/templates/xml.tmpl"].(os.FileInfo),
		fs["/templates/yaml.tmpl"].(os.FileInfo),
	}

	return fs
}()

type vfsgen۰FS map[string]interface{}

func (fs vfsgen۰FS) Open(path string) (http.File, error) {
	path = pathpkg.Clean("/" + path)
	f, ok := fs[path]
	if !ok {
		return nil, &os.PathError{Op: "open", Path: path, Err: os.ErrNotExist}
	}

	switch f := f.(type) {
	case *vfsgen۰CompressedFileInfo:
		gr, err := gzip.NewReader(bytes.NewReader(f.compressedContent))
		if err != nil {
			// This should never happen because we generate the gzip bytes such that they are always valid.
			panic("unexpected error reading own gzip compressed bytes: " + err.Error())
		}
		return &vfsgen۰CompressedFile{
			vfsgen۰CompressedFileInfo: f,
			gr:                        gr,
		}, nil
	case *vfsgen۰DirInfo:
		return &vfsgen۰Dir{
			vfsgen۰DirInfo: f,
		}, nil
	default:
		// This should never happen because we generate only the above types.
		panic(fmt.Sprintf("unexpected type %T", f))
	}
}

// vfsgen۰CompressedFileInfo is a static definition of a gzip compressed file.
type vfsgen۰CompressedFileInfo struct {
	name              string
	modTime           time.Time
	compressedContent []byte
	uncompressedSize  int64
}

func (f *vfsgen۰CompressedFileInfo) Readdir(count int) ([]os.FileInfo, error) {
	return nil, fmt.Errorf("cannot Readdir from file %s", f.name)
}
func (f *vfsgen۰CompressedFileInfo) Stat() (os.FileInfo, error) { return f, nil }

func (f *vfsgen۰CompressedFileInfo) GzipBytes() []byte {
	return f.compressedContent
}

func (f *vfsgen۰CompressedFileInfo) Name() string       { return f.name }
func (f *vfsgen۰CompressedFileInfo) Size() int64        { return f.uncompressedSize }
func (f *vfsgen۰CompressedFileInfo) Mode() os.FileMode  { return 0444 }
func (f *vfsgen۰CompressedFileInfo) ModTime() time.Time { return f.modTime }
func (f *vfsgen۰CompressedFileInfo) IsDir() bool        { return false }
func (f *vfsgen۰CompressedFileInfo) Sys() interface{}   { return nil }

// vfsgen۰CompressedFile is an opened compressedFile instance.
type vfsgen۰CompressedFile struct {
	*vfsgen۰CompressedFileInfo
	gr      *gzip.Reader
	grPos   int64 // Actual gr uncompressed position.
	seekPos int64 // Seek uncompressed position.
}

func (f *vfsgen۰CompressedFile) Read(p []byte) (n int, err error) {
	if f.grPos > f.seekPos {
		// Rewind to beginning.
		err = f.gr.Reset(bytes.NewReader(f.compressedContent))
		if err != nil {
			return 0, err
		}
		f.grPos = 0
	}
	if f.grPos < f.seekPos {
		// Fast-forward.
		_, err = io.CopyN(ioutil.Discard, f.gr, f.seekPos-f.grPos)
		if err != nil {
			return 0, err
		}
		f.grPos = f.seekPos
	}
	n, err = f.gr.Read(p)
	f.grPos += int64(n)
	f.seekPos = f.grPos
	return n, err
}
func (f *vfsgen۰CompressedFile) Seek(offset int64, whence int) (int64, error) {
	switch whence {
	case io.SeekStart:
		f.seekPos = 0 + offset
	case io.SeekCurrent:
		f.seekPos += offset
	case io.SeekEnd:
		f.seekPos = f.uncompressedSize + offset
	default:
		panic(fmt.Errorf("invalid whence value: %v", whence))
	}
	return f.seekPos, nil
}
func (f *vfsgen۰CompressedFile) Close() error {
	return f.gr.Close()
}

// vfsgen۰DirInfo is a static definition of a directory.
type vfsgen۰DirInfo struct {
	name    string
	modTime time.Time
	entries []os.FileInfo
}

func (d *vfsgen۰DirInfo) Read([]byte) (int, error) {
	return 0, fmt.Errorf("cannot Read from directory %s", d.name)
}
func (d *vfsgen۰DirInfo) Close() error               { return nil }
func (d *vfsgen۰DirInfo) Stat() (os.FileInfo, error) { return d, nil }

func (d *vfsgen۰DirInfo) Name() string       { return d.name }
func (d *vfsgen۰DirInfo) Size() int64        { return 0 }
func (d *vfsgen۰DirInfo) Mode() os.FileMode  { return 0755 | os.ModeDir }
func (d *vfsgen۰DirInfo) ModTime() time.Time { return d.modTime }
func (d *vfsgen۰DirInfo) IsDir() bool        { return true }
func (d *vfsgen۰DirInfo) Sys() interface{}   { return nil }

// vfsgen۰Dir is an opened dir instance.
type vfsgen۰Dir struct {
	*vfsgen۰DirInfo
	pos int // Position within entries for Seek and Readdir.
}

func (d *vfsgen۰Dir) Seek(offset int64, whence int) (int64, error) {
	if offset == 0 && whence == io.SeekStart {
		d.pos = 0
		return 0, nil
	}
	return 0, fmt.Errorf("unsupported Seek in directory %s", d.name)
}

func (d *vfsgen۰Dir) Readdir(count int) ([]os.FileInfo, error) {
	if d.pos >= len(d.entries) && count > 0 {
		return nil, io.EOF
	}
	if count <= 0 || count > len(d.entries)-d.pos {
		count = len(d.entries) - d.pos
	}
	e := d.entries[d.pos : d.pos+count]
	d.pos += count
	return e, nil
}
