/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.cryptocms;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelCryptocmsSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_CRYPTOCMS_PATH_CRYPTO_OPERATION_CONF = "camel.sink.path.cryptoOperation";
    public static final String CAMEL_SINK_CRYPTOCMS_PATH_CRYPTO_OPERATION_DOC = "Set the Crypto operation from that supplied after the crypto scheme in the endpoint uri e.g. crypto-cms:sign sets sign as the operation. Possible values: sign, verify, encrypt, or decrypt. One of: [sign] [verify] [encrypt] [decrypt]";
    public static final String CAMEL_SINK_CRYPTOCMS_PATH_CRYPTO_OPERATION_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_PATH_NAME_CONF = "camel.sink.path.name";
    public static final String CAMEL_SINK_CRYPTOCMS_PATH_NAME_DOC = "The name part in the URI can be chosen by the user to distinguish between different signer/verifier/encryptor/decryptor endpoints within the camel context.";
    public static final String CAMEL_SINK_CRYPTOCMS_PATH_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_CONF = "camel.sink.endpoint.keyStore";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_DOC = "Keystore which contains signer private keys, verifier public keys, encryptor public keys, decryptor private keys depending on the operation. Use either this parameter or the parameter 'keyStoreParameters'.";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_PARAMETERS_CONF = "camel.sink.endpoint.keyStoreParameters";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_PARAMETERS_DOC = "Keystore containing signer private keys, verifier public keys, encryptor public keys, decryptor private keys depending on the operation. Use either this parameter or the parameter 'keystore'.";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_CRYPTOCMS_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_CRYPTOCMS_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_CRYPTOCMS_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_PASSWORD_CONF = "camel.sink.endpoint.password";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_PASSWORD_DOC = "Sets the password of the private keys. It is assumed that all private keys in the keystore have the same password. If not set then it is assumed that the password of the private keys is given by the keystore password given in the KeyStoreParameters.";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_FROM_BASE_64CONF = "camel.sink.endpoint.fromBase64";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_FROM_BASE_64DOC = "If true then the CMS message is base 64 encoded and must be decoded during the processing. Default value is false.";
    public static final Boolean CAMEL_SINK_CRYPTOCMS_ENDPOINT_FROM_BASE_64DEFAULT = false;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_CONTENT_ENCRYPTION_ALGORITHM_CONF = "camel.sink.endpoint.contentEncryptionAlgorithm";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_CONTENT_ENCRYPTION_ALGORITHM_DOC = "Encryption algorithm, for example DESede/CBC/PKCS5Padding. Further possible values: DESede/CBC/PKCS5Padding, AES/CBC/PKCS5Padding, Camellia/CBC/PKCS5Padding, CAST5/CBC/PKCS5Padding. One of: [AES/CBC/PKCS5Padding] [DESede/CBC/PKCS5Padding] [Camellia/CBC/PKCS5Padding] [CAST5/CBC/PKCS5Padding]";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_CONTENT_ENCRYPTION_ALGORITHM_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_ORIGINATOR_INFORMATION_PROVIDER_CONF = "camel.sink.endpoint.originatorInformationProvider";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_ORIGINATOR_INFORMATION_PROVIDER_DOC = "Provider for the originator info. See https://tools.ietf.org/html/rfc5652#section-6.1. The default value is null.";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_ORIGINATOR_INFORMATION_PROVIDER_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_RECIPIENT_CONF = "camel.sink.endpoint.recipient";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_RECIPIENT_DOC = "Recipient Info: reference to a bean which implements the interface org.apache.camel.component.crypto.cms.api.TransRecipientInfo";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_RECIPIENT_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_SECRET_KEY_LENGTH_CONF = "camel.sink.endpoint.secretKeyLength";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_SECRET_KEY_LENGTH_DOC = "Key length for the secret symmetric key used for the content encryption. Only used if the specified content-encryption algorithm allows keys of different sizes. If contentEncryptionAlgorithm=AES/CBC/PKCS5Padding or Camellia/CBC/PKCS5Padding then 128; if contentEncryptionAlgorithm=DESede/CBC/PKCS5Padding then 192, 128; if strong encryption is enabled then for AES/CBC/PKCS5Padding and Camellia/CBC/PKCS5Padding also the key lengths 192 and 256 are possible.";
    public static final Integer CAMEL_SINK_CRYPTOCMS_ENDPOINT_SECRET_KEY_LENGTH_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_UNPROTECTED_ATTRIBUTES_GENERATOR_PROVIDER_CONF = "camel.sink.endpoint.unprotectedAttributesGeneratorProvider";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_UNPROTECTED_ATTRIBUTES_GENERATOR_PROVIDER_DOC = "Provider of the generator for the unprotected attributes. The default value is null which means no unprotected attribute is added to the Enveloped Data object. See https://tools.ietf.org/html/rfc5652#section-6.1.";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_UNPROTECTED_ATTRIBUTES_GENERATOR_PROVIDER_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_TO_BASE_64CONF = "camel.sink.endpoint.toBase64";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_TO_BASE_64DOC = "Indicates whether the Signed Data or Enveloped Data instance shall be base 64 encoded. Default value is false.";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_TO_BASE_64DEFAULT = "false";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_INCLUDE_CONTENT_CONF = "camel.sink.endpoint.includeContent";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_INCLUDE_CONTENT_DOC = "Indicates whether the signed content should be included into the Signed Data instance. If false then a detached Signed Data instance is created in the header CamelCryptoCmsSignedData.";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_INCLUDE_CONTENT_DEFAULT = "true";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNER_CONF = "camel.sink.endpoint.signer";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNER_DOC = "Signer information: reference to bean(s) which implements org.apache.camel.component.crypto.cms.api.SignerInfo. Multiple values can be separated by comma";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNER_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNED_DATA_HEADER_BASE_64CONF = "camel.sink.endpoint.signedDataHeaderBase64";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNED_DATA_HEADER_BASE_64DOC = "Indicates whether the value in the header CamelCryptoCmsSignedData is base64 encoded. Default value is false. Only relevant for detached signatures. In the detached signature case, the header contains the Signed Data object.";
    public static final Boolean CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNED_DATA_HEADER_BASE_64DEFAULT = false;
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_VERIFY_SIGNATURES_OF_ALL_SIGNERS_CONF = "camel.sink.endpoint.verifySignaturesOfAllSigners";
    public static final String CAMEL_SINK_CRYPTOCMS_ENDPOINT_VERIFY_SIGNATURES_OF_ALL_SIGNERS_DOC = "If true then the signatures of all signers contained in the Signed Data object are verified. If false then only one signature whose signer info matches with one of the specified certificates is verified. Default value is true.";
    public static final Boolean CAMEL_SINK_CRYPTOCMS_ENDPOINT_VERIFY_SIGNATURES_OF_ALL_SIGNERS_DEFAULT = true;
    public static final String CAMEL_SINK_CRYPTOCMS_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.crypto-cms.lazyStartProducer";
    public static final String CAMEL_SINK_CRYPTOCMS_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_CRYPTOCMS_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_CRYPTOCMS_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.crypto-cms.basicPropertyBinding";
    public static final String CAMEL_SINK_CRYPTOCMS_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_CRYPTOCMS_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_CRYPTOCMS_COMPONENT_ENVELOPED_DATA_DECRYPTOR_CONFIGURATION_CONF = "camel.component.crypto-cms.envelopedDataDecryptorConfiguration";
    public static final String CAMEL_SINK_CRYPTOCMS_COMPONENT_ENVELOPED_DATA_DECRYPTOR_CONFIGURATION_DOC = "To configure the shared EnvelopedDataDecryptorConfiguration, which determines the uri parameters for the decrypt operation.";
    public static final String CAMEL_SINK_CRYPTOCMS_COMPONENT_ENVELOPED_DATA_DECRYPTOR_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_CRYPTOCMS_COMPONENT_SIGNED_DATA_VERIFIER_CONFIGURATION_CONF = "camel.component.crypto-cms.signedDataVerifierConfiguration";
    public static final String CAMEL_SINK_CRYPTOCMS_COMPONENT_SIGNED_DATA_VERIFIER_CONFIGURATION_DOC = "To configure the shared SignedDataVerifierConfiguration, which determines the uri parameters for the verify operation.";
    public static final String CAMEL_SINK_CRYPTOCMS_COMPONENT_SIGNED_DATA_VERIFIER_CONFIGURATION_DEFAULT = null;

    public CamelCryptocmsSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelCryptocmsSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_CRYPTOCMS_PATH_CRYPTO_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_PATH_CRYPTO_OPERATION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_CRYPTOCMS_PATH_CRYPTO_OPERATION_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_PATH_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_PATH_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_CRYPTOCMS_PATH_NAME_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_KEY_STORE_PARAMETERS_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CRYPTOCMS_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CRYPTOCMS_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CRYPTOCMS_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_FROM_BASE_64CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CRYPTOCMS_ENDPOINT_FROM_BASE_64DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_FROM_BASE_64DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_CONTENT_ENCRYPTION_ALGORITHM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_ENDPOINT_CONTENT_ENCRYPTION_ALGORITHM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_CONTENT_ENCRYPTION_ALGORITHM_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_ORIGINATOR_INFORMATION_PROVIDER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_ENDPOINT_ORIGINATOR_INFORMATION_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_ORIGINATOR_INFORMATION_PROVIDER_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_RECIPIENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_ENDPOINT_RECIPIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_RECIPIENT_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_SECRET_KEY_LENGTH_CONF, ConfigDef.Type.INT, CAMEL_SINK_CRYPTOCMS_ENDPOINT_SECRET_KEY_LENGTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_SECRET_KEY_LENGTH_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_UNPROTECTED_ATTRIBUTES_GENERATOR_PROVIDER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_ENDPOINT_UNPROTECTED_ATTRIBUTES_GENERATOR_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_UNPROTECTED_ATTRIBUTES_GENERATOR_PROVIDER_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_TO_BASE_64CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_ENDPOINT_TO_BASE_64DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_TO_BASE_64DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_INCLUDE_CONTENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_ENDPOINT_INCLUDE_CONTENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_INCLUDE_CONTENT_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNER_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNED_DATA_HEADER_BASE_64CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNED_DATA_HEADER_BASE_64DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_SIGNED_DATA_HEADER_BASE_64DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_ENDPOINT_VERIFY_SIGNATURES_OF_ALL_SIGNERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CRYPTOCMS_ENDPOINT_VERIFY_SIGNATURES_OF_ALL_SIGNERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_ENDPOINT_VERIFY_SIGNATURES_OF_ALL_SIGNERS_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CRYPTOCMS_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_CRYPTOCMS_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_COMPONENT_ENVELOPED_DATA_DECRYPTOR_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_COMPONENT_ENVELOPED_DATA_DECRYPTOR_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_COMPONENT_ENVELOPED_DATA_DECRYPTOR_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_CRYPTOCMS_COMPONENT_SIGNED_DATA_VERIFIER_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_CRYPTOCMS_COMPONENT_SIGNED_DATA_VERIFIER_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_CRYPTOCMS_COMPONENT_SIGNED_DATA_VERIFIER_CONFIGURATION_DOC);
        return conf;
    }
}