/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.debeziummongodb;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelDebeziummongodbSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_PATH_NAME_CONF = "camel.source.path.name";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_PATH_NAME_DOC = "Unique name for the connector. Attempting to register again with the same name will fail.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_PATH_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_ADDITIONAL_PROPERTIES_CONF = "camel.source.endpoint.additionalProperties";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_ADDITIONAL_PROPERTIES_DOC = "Additional properties for debezium components in case they can't be set directly on the camel configurations (e.g: setting Kafka Connect properties needed by Debezium engine, for example setting KafkaOffsetBackingStore), the properties have to be prefixed with additionalProperties.. E.g: additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_KEY_CONVERTER_CONF = "camel.source.endpoint.internalKeyConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_KEY_CONVERTER_DOC = "The Converter class that should be used to serialize and deserialize key data for offsets. The default is JSON converter.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_KEY_CONVERTER_DEFAULT = "org.apache.kafka.connect.json.JsonConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_VALUE_CONVERTER_CONF = "camel.source.endpoint.internalValueConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_VALUE_CONVERTER_DOC = "The Converter class that should be used to serialize and deserialize value data for offsets. The default is JSON converter.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_VALUE_CONVERTER_DEFAULT = "org.apache.kafka.connect.json.JsonConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_POLICY_CONF = "camel.source.endpoint.offsetCommitPolicy";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_POLICY_DOC = "The name of the Java class of the commit policy. It defines when offsets commit has to be triggered based on the number of events processed and the time elapsed since the last commit. This class must implement the interface 'OffsetCommitPolicy'. The default is a periodic commit policy based upon time intervals.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_POLICY_DEFAULT = "io.debezium.embedded.spi.OffsetCommitPolicy.PeriodicCommitOffsetPolicy";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_CONF = "camel.source.endpoint.offsetCommitTimeoutMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DOC = "Maximum number of milliseconds to wait for records to flush and partition offset data to be committed to offset storage before cancelling the process and restoring the offset data to be committed in a future attempt. The default is 5 seconds.";
    public static final Long CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DEFAULT = 5000L;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_CONF = "camel.source.endpoint.offsetFlushIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DOC = "Interval at which to try committing offsets. The default is 1 minute.";
    public static final Long CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DEFAULT = 60000L;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_CONF = "camel.source.endpoint.offsetStorage";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_DOC = "The name of the Java class that is responsible for persistence of connector offsets.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_DEFAULT = "org.apache.kafka.connect.storage.FileOffsetBackingStore";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_FILE_NAME_CONF = "camel.source.endpoint.offsetStorageFileName";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DOC = "Path to file where offsets are to be stored. Required when offset.storage is set to the FileOffsetBackingStore.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_PARTITIONS_CONF = "camel.source.endpoint.offsetStoragePartitions";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DOC = "The number of partitions used when creating the offset storage topic. Required when offset.storage is set to the 'KafkaOffsetBackingStore'.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_CONF = "camel.source.endpoint.offsetStorageReplicationFactor";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DOC = "Replication factor used when creating the offset storage topic. Required when offset.storage is set to the KafkaOffsetBackingStore";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_TOPIC_CONF = "camel.source.endpoint.offsetStorageTopic";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_TOPIC_DOC = "The name of the Kafka topic where offsets are to be stored. Required when offset.storage is set to the KafkaOffsetBackingStore.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_TOPIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_BLACKLIST_CONF = "camel.source.endpoint.collectionBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_BLACKLIST_DOC = "Description is not available here, please check Debezium website for corresponding key 'collection.blacklist' description.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_WHITELIST_CONF = "camel.source.endpoint.collectionWhitelist";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_WHITELIST_DOC = "The collections for which changes are to be captured";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_WHITELIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_INITIAL_DELAY_MS_CONF = "camel.source.endpoint.connectBackoffInitialDelayMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_INITIAL_DELAY_MS_DOC = "The initial delay when trying to reconnect to a primary after a connection cannot be made or when no primary is available. Defaults to 1 second (1000 ms).";
    public static final Long CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_INITIAL_DELAY_MS_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_MAX_DELAY_MS_CONF = "camel.source.endpoint.connectBackoffMaxDelayMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_MAX_DELAY_MS_DOC = "The maximum delay when trying to reconnect to a primary after a connection cannot be made or when no primary is available. Defaults to 120 second (120,000 ms).";
    public static final Long CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_MAX_DELAY_MS_DEFAULT = 120000L;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_MAX_ATTEMPTS_CONF = "camel.source.endpoint.connectMaxAttempts";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_MAX_ATTEMPTS_DOC = "Maximum number of failed connection attempts to a replica set primary before an exception occurs and task is aborted. Defaults to 16, which with the defaults for 'connect.backoff.initial.delay.ms' and 'connect.backoff.max.delay.ms' results in just over 20 minutes of attempts before failing.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_MAX_ATTEMPTS_DEFAULT = 16;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_BLACKLIST_CONF = "camel.source.endpoint.databaseBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_BLACKLIST_DOC = "The databases for which changes are to be excluded";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_CONF = "camel.source.endpoint.databaseHistoryFileFilename";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DOC = "The path to the file that will be used to record the database history";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_WHITELIST_CONF = "camel.source.endpoint.databaseWhitelist";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_WHITELIST_DOC = "The databases for which changes are to be captured";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_WHITELIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_BLACKLIST_CONF = "camel.source.endpoint.fieldBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_BLACKLIST_DOC = "Description is not available here, please check Debezium website for corresponding key 'field.blacklist' description.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_RENAMES_CONF = "camel.source.endpoint.fieldRenames";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_RENAMES_DOC = "Description is not available here, please check Debezium website for corresponding key 'field.renames' description.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_RENAMES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_INTERVAL_MS_CONF = "camel.source.endpoint.heartbeatIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_INTERVAL_MS_DOC = "Length of an interval in milli-seconds in in which the connector periodically sends heartbeat messages to a heartbeat topic. Use 0 to disable heartbeat messages. Disabled by default.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_INTERVAL_MS_DEFAULT = 0;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_CONF = "camel.source.endpoint.heartbeatTopicsPrefix";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DOC = "The prefix that is used to name heartbeat topics.Defaults to __debezium-heartbeat.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DEFAULT = "__debezium-heartbeat";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INITIAL_SYNC_MAX_THREADS_CONF = "camel.source.endpoint.initialSyncMaxThreads";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INITIAL_SYNC_MAX_THREADS_DOC = "Maximum number of threads used to perform an intial sync of the collections in a replica set. Defaults to 1.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INITIAL_SYNC_MAX_THREADS_DEFAULT = 1;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_BATCH_SIZE_CONF = "camel.source.endpoint.maxBatchSize";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_BATCH_SIZE_DOC = "Maximum size of each batch of source records. Defaults to 2048.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_BATCH_SIZE_DEFAULT = 2048;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_QUEUE_SIZE_CONF = "camel.source.endpoint.maxQueueSize";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_QUEUE_SIZE_DOC = "Maximum size of the queue for change events read from the database log but not yet recorded or forwarded. Defaults to 8192, and should always be larger than the maximum batch size.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_QUEUE_SIZE_DEFAULT = 8192;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_HOSTS_CONF = "camel.source.endpoint.mongodbHosts";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_HOSTS_DOC = "The hostname and port pairs (in the form 'host' or 'host:port') of the MongoDB server(s) in the replica set.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_HOSTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_MEMBERS_AUTO_DISCOVER_CONF = "camel.source.endpoint.mongodbMembersAutoDiscover";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_MEMBERS_AUTO_DISCOVER_DOC = "Specifies whether the addresses in 'hosts' are seeds that should be used to discover all members of the cluster or replica set ('true'), or whether the address(es) in 'hosts' should be used as is ('false'). The default is 'true'.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_MEMBERS_AUTO_DISCOVER_DEFAULT = true;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_NAME_CONF = "camel.source.endpoint.mongodbName";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_NAME_DOC = "Unique name that identifies the MongoDB replica set or cluster and all recorded offsets, andthat is used as a prefix for all schemas and topics. Each distinct MongoDB installation should have a separate namespace and monitored by at most one Debezium connector.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_PASSWORD_CONF = "camel.source.endpoint.mongodbPassword";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_PASSWORD_DOC = "Password to be used when connecting to MongoDB, if necessary.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_ENABLED_CONF = "camel.source.endpoint.mongodbSslEnabled";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_ENABLED_DOC = "Should connector use SSL to connect to MongoDB instances";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_ENABLED_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_INVALID_HOSTNAME_ALLOWED_CONF = "camel.source.endpoint.mongodbSslInvalidHostnameAllowed";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_INVALID_HOSTNAME_ALLOWED_DOC = "Whether invalid host names are allowed when using SSL. If true the connection will not prevent man-in-the-middle attacks";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_INVALID_HOSTNAME_ALLOWED_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_USER_CONF = "camel.source.endpoint.mongodbUser";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_USER_DOC = "Database user for connecting to MongoDB, if necessary.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_USER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_POLL_INTERVAL_MS_CONF = "camel.source.endpoint.pollIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_POLL_INTERVAL_MS_DOC = "Frequency in milliseconds to wait for new change events to appear after receiving no events. Defaults to 500ms.";
    public static final Long CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_POLL_INTERVAL_MS_DEFAULT = 500L;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_DELAY_MS_CONF = "camel.source.endpoint.snapshotDelayMs";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_DELAY_MS_DOC = "The number of milliseconds to delay before a snapshot will begin.";
    public static final Long CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_DELAY_MS_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_FETCH_SIZE_CONF = "camel.source.endpoint.snapshotFetchSize";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_FETCH_SIZE_DOC = "The maximum number of records that should be loaded into memory while performing a snapshot";
    public static final Integer CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_FETCH_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_MODE_CONF = "camel.source.endpoint.snapshotMode";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_MODE_DOC = "The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should always perform an initial sync when required; 'never' to specify the connector should never perform an initial sync";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_MODE_DEFAULT = "initial";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SOURCE_STRUCT_VERSION_CONF = "camel.source.endpoint.sourceStructVersion";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SOURCE_STRUCT_VERSION_DOC = "A version of the format of the publicly visible source part in the message";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SOURCE_STRUCT_VERSION_DEFAULT = "v2";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_TOMBSTONES_ON_DELETE_CONF = "camel.source.endpoint.tombstonesOnDelete";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_TOMBSTONES_ON_DELETE_DOC = "Whether delete operations should be represented by a delete event and a subsquenttombstone event (true) or only by a delete event (false). Emitting the tombstone event (the default behavior) allows Kafka to completely delete all events pertaining to the given key once the source record got deleted.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_TOMBSTONES_ON_DELETE_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.debezium-mongodb.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_CONFIGURATION_CONF = "camel.component.debezium-mongodb.configuration";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_CONFIGURATION_DOC = "Allow pre-configured Configurations to be set.";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.debezium-mongodb.basicPropertyBinding";
    public static final String CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelDebeziummongodbSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelDebeziummongodbSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_PATH_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_PATH_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMMONGODB_PATH_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_ADDITIONAL_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_ADDITIONAL_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_KEY_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_KEY_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_KEY_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_VALUE_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_VALUE_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INTERNAL_VALUE_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_POLICY_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_FILE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_PARTITIONS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_TOPIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_OFFSET_STORAGE_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_WHITELIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_WHITELIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_COLLECTION_WHITELIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_INITIAL_DELAY_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_INITIAL_DELAY_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_INITIAL_DELAY_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_MAX_DELAY_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_MAX_DELAY_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_BACKOFF_MAX_DELAY_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_MAX_ATTEMPTS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_MAX_ATTEMPTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_CONNECT_MAX_ATTEMPTS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_WHITELIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_WHITELIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_DATABASE_WHITELIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_RENAMES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_RENAMES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_FIELD_RENAMES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_INTERVAL_MS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INITIAL_SYNC_MAX_THREADS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INITIAL_SYNC_MAX_THREADS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_INITIAL_SYNC_MAX_THREADS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_BATCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_BATCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_BATCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_QUEUE_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_QUEUE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MAX_QUEUE_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_HOSTS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_HOSTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_HOSTS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_MEMBERS_AUTO_DISCOVER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_MEMBERS_AUTO_DISCOVER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_MEMBERS_AUTO_DISCOVER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_INVALID_HOSTNAME_ALLOWED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_INVALID_HOSTNAME_ALLOWED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_SSL_INVALID_HOSTNAME_ALLOWED_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_USER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_USER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_MONGODB_USER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_POLL_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_POLL_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_POLL_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_DELAY_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_DELAY_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_DELAY_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_FETCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_FETCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_FETCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SNAPSHOT_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SOURCE_STRUCT_VERSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SOURCE_STRUCT_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_SOURCE_STRUCT_VERSION_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_TOMBSTONES_ON_DELETE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_TOMBSTONES_ON_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_ENDPOINT_TOMBSTONES_ON_DELETE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMMONGODB_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}