/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.ws.eventing.integration.notificationapi;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "earthquakeEvent", namespace = "http://www.example.com/earthquake/event")
public class EarthquakeEvent {

    private String location;
    private float richterScale;

    public EarthquakeEvent() {

    }

    public EarthquakeEvent(float richterScale, String location) {
        this.richterScale = richterScale;
        this.location = location;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public float getRichterScale() {
        return richterScale;
    }

    public void setRichterScale(float richterScale) {
        this.richterScale = richterScale;
    }

    @Override
    public String toString() {
        return "EarthquakeEvent{"
                + "location='" + location + '\''
                + ", richterScale=" + richterScale
                + '}';
    }
}
