/**
 */
package org.jboss.tools.windup.windup.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.jboss.tools.windup.windup.util.WindupAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class WindupItemProviderAdapterFactory extends WindupAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WindupItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.NamedElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NamedElementItemProvider namedElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.NamedElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNamedElementAdapter() {
		if (namedElementItemProvider == null) {
			namedElementItemProvider = new NamedElementItemProvider(this);
		}

		return namedElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.ConfigurationElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConfigurationElementItemProvider configurationElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.ConfigurationElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConfigurationElementAdapter() {
		if (configurationElementItemProvider == null) {
			configurationElementItemProvider = new ConfigurationElementItemProvider(this);
		}

		return configurationElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.Parameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterItemProvider parameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.Parameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterAdapter() {
		if (parameterItemProvider == null) {
			parameterItemProvider = new ParameterItemProvider(this);
		}

		return parameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.Parameterized} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterizedItemProvider parameterizedItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.Parameterized}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterizedAdapter() {
		if (parameterizedItemProvider == null) {
			parameterizedItemProvider = new ParameterizedItemProvider(this);
		}

		return parameterizedItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.WindupModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WindupModelItemProvider windupModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.WindupModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWindupModelAdapter() {
		if (windupModelItemProvider == null) {
			windupModelItemProvider = new WindupModelItemProvider(this);
		}

		return windupModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.Input} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InputItemProvider inputItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.Input}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInputAdapter() {
		if (inputItemProvider == null) {
			inputItemProvider = new InputItemProvider(this);
		}

		return inputItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.WindupResult} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WindupResultItemProvider windupResultItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.WindupResult}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWindupResultAdapter() {
		if (windupResultItemProvider == null) {
			windupResultItemProvider = new WindupResultItemProvider(this);
		}

		return windupResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.Issue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IssueItemProvider issueItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.Issue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIssueAdapter() {
		if (issueItemProvider == null) {
			issueItemProvider = new IssueItemProvider(this);
		}

		return issueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.Hint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HintItemProvider hintItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.Hint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHintAdapter() {
		if (hintItemProvider == null) {
			hintItemProvider = new HintItemProvider(this);
		}

		return hintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.Classification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassificationItemProvider classificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.Classification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassificationAdapter() {
		if (classificationItemProvider == null) {
			classificationItemProvider = new ClassificationItemProvider(this);
		}

		return classificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.Link} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinkItemProvider linkItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.Link}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinkAdapter() {
		if (linkItemProvider == null) {
			linkItemProvider = new LinkItemProvider(this);
		}

		return linkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.QuickFix} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QuickFixItemProvider quickFixItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.QuickFix}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQuickFixAdapter() {
		if (quickFixItemProvider == null) {
			quickFixItemProvider = new QuickFixItemProvider(this);
		}

		return quickFixItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.MigrationPath} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MigrationPathItemProvider migrationPathItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.MigrationPath}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMigrationPathAdapter() {
		if (migrationPathItemProvider == null) {
			migrationPathItemProvider = new MigrationPathItemProvider(this);
		}

		return migrationPathItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.Technology} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TechnologyItemProvider technologyItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.Technology}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTechnologyAdapter() {
		if (technologyItemProvider == null) {
			technologyItemProvider = new TechnologyItemProvider(this);
		}

		return technologyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.Pair} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PairItemProvider pairItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.Pair}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPairAdapter() {
		if (pairItemProvider == null) {
			pairItemProvider = new PairItemProvider(this);
		}

		return pairItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.CustomRuleProvider} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomRuleProviderItemProvider customRuleProviderItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.CustomRuleProvider}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomRuleProviderAdapter() {
		if (customRuleProviderItemProvider == null) {
			customRuleProviderItemProvider = new CustomRuleProviderItemProvider(this);
		}

		return customRuleProviderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.jboss.tools.windup.windup.MarkerElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MarkerElementItemProvider markerElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.jboss.tools.windup.windup.MarkerElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMarkerElementAdapter() {
		if (markerElementItemProvider == null) {
			markerElementItemProvider = new MarkerElementItemProvider(this);
		}

		return markerElementItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (namedElementItemProvider != null) namedElementItemProvider.dispose();
		if (configurationElementItemProvider != null) configurationElementItemProvider.dispose();
		if (parameterItemProvider != null) parameterItemProvider.dispose();
		if (parameterizedItemProvider != null) parameterizedItemProvider.dispose();
		if (windupModelItemProvider != null) windupModelItemProvider.dispose();
		if (inputItemProvider != null) inputItemProvider.dispose();
		if (windupResultItemProvider != null) windupResultItemProvider.dispose();
		if (issueItemProvider != null) issueItemProvider.dispose();
		if (hintItemProvider != null) hintItemProvider.dispose();
		if (classificationItemProvider != null) classificationItemProvider.dispose();
		if (linkItemProvider != null) linkItemProvider.dispose();
		if (quickFixItemProvider != null) quickFixItemProvider.dispose();
		if (migrationPathItemProvider != null) migrationPathItemProvider.dispose();
		if (technologyItemProvider != null) technologyItemProvider.dispose();
		if (pairItemProvider != null) pairItemProvider.dispose();
		if (customRuleProviderItemProvider != null) customRuleProviderItemProvider.dispose();
		if (markerElementItemProvider != null) markerElementItemProvider.dispose();
	}

}
