/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.hierarchicalroles;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public final class RoleHierarchyUtils {
    private RoleHierarchyUtils() {
    }

    public static String roleHierarchyFromMap(Map<String, List<String>> roleHierarchyMap) {
        Assert.notEmpty(roleHierarchyMap, (String)"roleHierarchyMap cannot be empty");
        StringWriter roleHierarchyBuffer = new StringWriter();
        PrintWriter roleHierarchyWriter = new PrintWriter(roleHierarchyBuffer);
        for (Map.Entry<String, List<String>> roleHierarchyEntry : roleHierarchyMap.entrySet()) {
            String role = roleHierarchyEntry.getKey();
            List<String> impliedRoles = roleHierarchyEntry.getValue();
            Assert.hasLength((String)role, (String)"role name must be supplied");
            Assert.notEmpty(impliedRoles, (String)"implied role name(s) cannot be empty");
            for (String impliedRole : impliedRoles) {
                String roleMapping = role + " > " + impliedRole;
                roleHierarchyWriter.println(roleMapping);
            }
        }
        return roleHierarchyBuffer.toString();
    }
}

