/*
 * Copyright © 2021 the Konveyor Contributors (https://konveyor.io/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.tackle.commons.testcontainers;

import org.junit.jupiter.api.Test;

import java.util.Collections;
import java.util.Map;

import static com.github.stefanbirkner.systemlambda.SystemLambda.withEnvironmentVariable;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class KeycloakTestResourceTest {

    @Test
    public void testExternalUrl() {
        String keycloakUrl = "https://foo.test.com/sample";
        String quarkusAuthUrl = "quarkus.oidc.auth-server-url";
        try {
            withEnvironmentVariable("TACKLE_KEYCLOAK_TEST_URL", keycloakUrl).execute(() -> {
                KeycloakTestResource keycloakTestResource = new KeycloakTestResource();
                Map<String, String> config = keycloakTestResource.start();
                assertTrue(config.containsKey(quarkusAuthUrl));
                assertEquals(keycloakUrl, config.get(quarkusAuthUrl));
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testStop() {
        KeycloakTestResource keycloakTestResource = new KeycloakTestResource();
        keycloakTestResource.stop();
    }

    @Test
    public void testInit() {
        KeycloakTestResource keycloakTestResource = new KeycloakTestResource();
        keycloakTestResource.init(Collections.emptyMap());
    }

}
